"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[1920],{9593:(e,t,n)=>{n.r(t),n.d(t,{assets:()=>c,contentTitle:()=>o,default:()=>d,frontMatter:()=>s,metadata:()=>r,toc:()=>l});var i=n(5893),a=n(1151);const s={title:"Transactions, Conflicts and Revisions",slug:"transactions-conflicts-revisions.html"},o="Transactions, Conflicts and Revisions",r={id:"transactions-conflicts-revisions",title:"Transactions, Conflicts and Revisions",description:"In contrast to most SQL databases, RxDB does not have the concept of relational, ACID transactions. Instead, RxDB has to apply different techniques that better suit the offline-first, client side world where it is not possible to create a transaction between multiple maybe-offline client devices.",source:"@site/docs/transactions-conflicts-revisions.md",sourceDirName:".",slug:"/transactions-conflicts-revisions.html",permalink:"/transactions-conflicts-revisions.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/transactions-conflicts-revisions.md",tags:[],version:"current",frontMatter:{title:"Transactions, Conflicts and Revisions",slug:"transactions-conflicts-revisions.html"},sidebar:"tutorialSidebar",previous:{title:"Backup",permalink:"/backup.html"},next:{title:"Middleware",permalink:"/middleware.html"}},c={},l=[{value:"Why RxDB does not have transactions",id:"why-rxdb-does-not-have-transactions",level:2},{value:"Revisions",id:"revisions",level:2},{value:"Conflicts",id:"conflicts",level:2},{value:"Local conflicts",id:"local-conflicts",level:3},{value:"Replication conflicts",id:"replication-conflicts",level:2},{value:"Custom conflict handler",id:"custom-conflict-handler",level:2}];function h(e){const t={a:"a",blockquote:"blockquote",code:"code",h1:"h1",h2:"h2",h3:"h3",li:"li",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,a.a)(),...e.components};return(0,i.jsxs)(i.Fragment,{children:[(0,i.jsx)(t.h1,{id:"transactions-conflicts-and-revisions",children:"Transactions, Conflicts and Revisions"}),"\n",(0,i.jsx)(t.p,{children:"In contrast to most SQL databases, RxDB does not have the concept of relational, ACID transactions. Instead, RxDB has to apply different techniques that better suit the offline-first, client side world where it is not possible to create a transaction between multiple maybe-offline client devices."}),"\n",(0,i.jsx)(t.h2,{id:"why-rxdb-does-not-have-transactions",children:"Why RxDB does not have transactions"}),"\n",(0,i.jsxs)(t.p,{children:["When talking about transactions, we mean ",(0,i.jsx)(t.a,{href:"https://en.wikipedia.org/wiki/ACID",children:"ACID transactions"})," that guarantee the properties of atomicity, consistency, isolation and durability.\nWith an ACID transaction you can mutate data dependent on the current state of the database. It is ensured that no other database operations happen in between your transaction and after the transaction has finished, it is guaranteed that the new data is actually written to the disc."]}),"\n",(0,i.jsxs)(t.p,{children:["To implement ACID transactions on a ",(0,i.jsx)(t.strong,{children:"single server"}),", the database has to keep track on who is running transactions and then schedule these transactions so that they can run in isolation."]}),"\n",(0,i.jsxs)(t.p,{children:["As soon as you have to split your database on ",(0,i.jsx)(t.strong,{children:"multiple servers"}),", transaction handling becomes way more difficult. The servers have to communicate with each other to find a consensus about which transaction can run and which has to wait. Network connections might break, or one server might complete its part of the transaction and then be required to roll back its changes because of an error on another server."]}),"\n",(0,i.jsxs)(t.p,{children:["But with RxDB you have ",(0,i.jsx)(t.strong,{children:"multiple clients"})," that can go randomly online or offline. The users can have different devices and the clock of these devices can go off by any time. To support ACID transactions here, RxDB would have to make the whole world stand still for all clients, while one client is doing a write operation. And even that can only work when all clients are online. Implementing that might be possible, but at the cost of an unpredictable amount of performance loss and not being able to support ",(0,i.jsx)(t.a,{href:"/offline-first.html",children:"offline-first"}),"."]}),"\n",(0,i.jsxs)(t.blockquote,{children:["\n",(0,i.jsx)(t.p,{children:"A single write operation to a document is the only atomic thing you can do in RxDB."}),"\n"]}),"\n",(0,i.jsx)(t.p,{children:"The benefits of not having to support transactions:"}),"\n",(0,i.jsxs)(t.ul,{children:["\n",(0,i.jsx)(t.li,{children:"Clients can read and write data without blocking each other."}),"\n",(0,i.jsxs)(t.li,{children:["Clients can write data while being ",(0,i.jsx)(t.strong,{children:"offline"})," and then replicate with a server when they are ",(0,i.jsx)(t.strong,{children:"online"})," again, called ",(0,i.jsx)(t.a,{href:"/offline-first.html",children:"offline-first"}),"."]}),"\n",(0,i.jsx)(t.li,{children:"Creating a compatible backend for the replication is easy so that RxDB can replicate with any existing infrastructure."}),"\n",(0,i.jsxs)(t.li,{children:["Optimizations like ",(0,i.jsx)(t.a,{href:"/rx-storage-sharding.html",children:"Sharding"})," can be used."]}),"\n"]}),"\n",(0,i.jsx)(t.h2,{id:"revisions",children:"Revisions"}),"\n",(0,i.jsx)(t.p,{children:"Working without transactions leads to having undefined state when doing multiple database operations at the same time. Most client side databases rely on a last-write-wins strategy on write operations. This might be a viable solution for some cases, but often this leads to strange problems that are hard to debug."}),"\n",(0,i.jsxs)(t.p,{children:["Instead, to ensure that the behavior of RxDB is ",(0,i.jsx)(t.strong,{children:"always predictable"}),", RxDB relies on ",(0,i.jsx)(t.strong,{children:"revisions"})," for version control. Revisions work similar to ",(0,i.jsx)(t.a,{href:"https://martinfowler.com/articles/patterns-of-distributed-systems/lamport-clock.html",children:"Lamport Clocks"}),"."]}),"\n",(0,i.jsxs)(t.p,{children:["Each document is stored together with its revision string, that looks like ",(0,i.jsx)(t.code,{children:"1-9dcca3b8e1a"})," and consists of:"]}),"\n",(0,i.jsxs)(t.ul,{children:["\n",(0,i.jsxs)(t.li,{children:["The revision height, a number that starts with ",(0,i.jsx)(t.code,{children:"1"})," and is increased with each write to that document."]}),"\n",(0,i.jsx)(t.li,{children:"The database instance token."}),"\n"]}),"\n",(0,i.jsxs)(t.p,{children:["An operation to the RxDB data layer does not only contain the new document data, but also the previous document data with its revision string. If the previous revision matches the revision that is currently stored in the database, the write operation can succeed. If the previous revision is ",(0,i.jsx)(t.strong,{children:"different"})," than the revision that is currently stored in the database, the operation will throw a ",(0,i.jsx)(t.code,{children:"409 CONFLICT"})," error."]}),"\n",(0,i.jsx)(t.h2,{id:"conflicts",children:"Conflicts"}),"\n",(0,i.jsxs)(t.p,{children:["There are two types of conflicts in RxDB, the ",(0,i.jsx)(t.strong,{children:"local conflict"})," and the ",(0,i.jsx)(t.strong,{children:"replication conflict"}),"."]}),"\n",(0,i.jsx)(t.h3,{id:"local-conflicts",children:"Local conflicts"}),"\n",(0,i.jsx)(t.p,{children:"A local conflict can happen when a write operation assumes a different previous document state, then what is currently stored in the database. This can happen when multiple parts of your application do simultaneous writes to the same document. This can happen on a single browser tab, or when multiple tabs write at once or when a write appears while the document gets replicated from a remote server replication."}),"\n",(0,i.jsxs)(t.p,{children:["When a local conflict appears, RxDB will throw a ",(0,i.jsx)(t.code,{children:"409 CONFLICT"})," error. The calling code must then handle the error properly, depending on the application logic."]}),"\n",(0,i.jsxs)(t.p,{children:["Instead of handling local conflicts, in most cases it is easier to ensure that they cannot happen, by using ",(0,i.jsx)(t.code,{children:"incremental"})," database operations like ",(0,i.jsx)(t.a,{href:"/rx-document.html",children:"incrementalModify()"}),", ",(0,i.jsx)(t.a,{href:"/rx-document.html",children:"incrementalPatch()"})," or ",(0,i.jsx)(t.a,{href:"/rx-collection.html",children:"incrementalUpsert()"}),". These write operations have a build in way to handle conflicts by re-applying the mutation functions to the conflicting document state."]}),"\n",(0,i.jsx)(t.h2,{id:"replication-conflicts",children:"Replication conflicts"}),"\n",(0,i.jsx)(t.p,{children:"A replication conflict appears when multiple clients write to the same documents at once and these documents are then replicated to the backend server."}),"\n",(0,i.jsxs)(t.p,{children:["When you replicate with the ",(0,i.jsx)(t.a,{href:"/replication-graphql.html",children:"Graphql replication"})," and the ",(0,i.jsx)(t.a,{href:"/replication.html",children:"replication primitives"}),", RxDB assumes that conflicts are ",(0,i.jsx)(t.strong,{children:"detected"})," and ",(0,i.jsx)(t.strong,{children:"resolved"})," at the client side."]}),"\n",(0,i.jsxs)(t.p,{children:["When a document is send to the backend and the backend detected a conflict (by comparing revisions or other properties), the backend will respond with the actual document state so that the client can compare this with the local document state and create a new, resolved document state that is then pushed to the server again. You can read more about the replication protocol ",(0,i.jsx)(t.a,{href:"/replication.html#conflict-handling",children:"here"}),"."]}),"\n",(0,i.jsx)(t.h2,{id:"custom-conflict-handler",children:"Custom conflict handler"}),"\n",(0,i.jsx)(t.p,{children:"A conflict handler is a JavaScript function that has two tasks:"}),"\n",(0,i.jsxs)(t.ul,{children:["\n",(0,i.jsx)(t.li,{children:"Detect if a conflict exists"}),"\n",(0,i.jsx)(t.li,{children:"Solve existing conflicts"}),"\n"]}),"\n",(0,i.jsx)(t.p,{children:"Because the conflict handler also is used for conflict detection, it will run many times on pull-, push- and write operations of RxDB. Most of the time it will detect that there is no conflict and then return."}),"\n",(0,i.jsx)(t.p,{children:"Lets have a look at the default conflict handler of RxDB to learn how to create a custom one:"}),"\n",(0,i.jsx)(t.pre,{children:(0,i.jsx)(t.code,{className:"language-ts",children:"export const defaultConflictHandler: RxConflictHandler<any> = function (\n    /**\n     * The conflict handler gets 3 input properties:\n     * - assumedMasterState: The state of the document that is assumed to be on the master branch\n     * - newDocumentState: The new document state of the fork branch (=client) that RxDB want to write to the master\n     * - realMasterState: The real master state of the document\n     */\n    i: RxConflictHandlerInput<any>\n): Promise<RxConflictHandlerOutput<any>> {\n    /**\n     * Here we detect if a conflict exists in the first place.\n     * If there is no conflict, we return isEqual=true.\n     * If there is a conflict, return isEqual=false.\n     * In the default handler we do a deepEqual check,\n     * but in your custom conflict handler you probably want\n     * to compare specific properties of the document, like the updatedAt time,\n     * for better performance because deepEqual() is expensive.\n     */\n    if (deepEqual(\n        i.newDocumentState,\n        i.realMasterState\n    )) {\n        return Promise.resolve({\n            isEqual: true\n        });\n    }\n\n    /**\n     * If a conflict exists, we have to resolve it.\n     * The default conflict handler will always\n     * drop the fork state and use the master state instead.\n     * \n     * In your custom conflict handler you likely want to merge properties\n     * of the realMasterState and the newDocumentState instead.\n     */\n    return Promise.resolve({\n        isEqual: false,\n        documentData: i.realMasterState\n    });\n};\n"})}),"\n",(0,i.jsxs)(t.p,{children:["To overwrite the default conflict handler, you have to specify a custom ",(0,i.jsx)(t.code,{children:"conflictHandler"})," property when creating a collection with ",(0,i.jsx)(t.code,{children:"addCollections()"}),"."]}),"\n",(0,i.jsx)(t.pre,{children:(0,i.jsx)(t.code,{className:"language-js",children:"const myCollections = await myDatabase.addCollections({\n  // key = collectionName\n  humans: {\n    schema: mySchema,\n    conflictHandler: myCustomConflictHandler\n  }\n});\n"})})]})}function d(e={}){const{wrapper:t}={...(0,a.a)(),...e.components};return t?(0,i.jsx)(t,{...e,children:(0,i.jsx)(h,{...e})}):h(e)}},1151:(e,t,n)=>{n.d(t,{Z:()=>r,a:()=>o});var i=n(7294);const a={},s=i.createContext(a);function o(e){const t=i.useContext(s);return i.useMemo((function(){return"function"==typeof e?e(t):{...t,...e}}),[t,e])}function r(e){let t;return t=e.disableParentContext?"function"==typeof e.components?e.components(a):e.components||a:o(e.components),i.createElement(s.Provider,{value:t},e.children)}}}]);