"use strict";(self.webpackChunkrxdb=self.webpackChunkrxdb||[]).push([[7729],{1314:(e,t,a)=>{a.r(t),a.d(t,{assets:()=>l,contentTitle:()=>o,default:()=>c,frontMatter:()=>i,metadata:()=>r,toc:()=>d});var n=a(5893),s=a(1151);const i={title:"LokiJS RxStorage",slug:"rx-storage-lokijs.html"},o="RxStorage LokiJS",r={id:"rx-storage-lokijs",title:"LokiJS RxStorage",description:"The LokiJS RxStorage is based on LokiJS which has the main benefit of having a better performance. It can do this because it is an in-memory database that processes all data in memory and only saves to disc when the app is closed or an interval is reached.",source:"@site/docs/rx-storage-lokijs.md",sourceDirName:".",slug:"/rx-storage-lokijs.html",permalink:"/rx-storage-lokijs.html",draft:!1,unlisted:!1,editUrl:"https://github.com/pubkey/rxdb/tree/master/docs-src/docs/rx-storage-lokijs.md",tags:[],version:"current",frontMatter:{title:"LokiJS RxStorage",slug:"rx-storage-lokijs.html"},sidebar:"tutorialSidebar",previous:{title:"Dexie.js RxStorage",permalink:"/rx-storage-dexie.html"},next:{title:"Memory RxStorage",permalink:"/rx-storage-memory.html"}},l={},d=[{value:"Pros",id:"pros",level:3},{value:"Cons",id:"cons",level:3},{value:"Usage",id:"usage",level:2},{value:"Adapters",id:"adapters",level:2},{value:"Multi-Tab support",id:"multi-tab-support",level:2},{value:"Autosave and autoload",id:"autosave-and-autoload",level:2},{value:"Known problems",id:"known-problems",level:2},{value:"Using the internal LokiJS database",id:"using-the-internal-lokijs-database",level:2}];function h(e){const t={a:"a",code:"code",h1:"h1",h2:"h2",h3:"h3",li:"li",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,s.a)(),...e.components};return(0,n.jsxs)(n.Fragment,{children:[(0,n.jsx)(t.h1,{id:"rxstorage-lokijs",children:"RxStorage LokiJS"}),"\n",(0,n.jsxs)(t.p,{children:["The LokiJS RxStorage is based on ",(0,n.jsx)(t.a,{href:"https://github.com/techfort/LokiJS",children:"LokiJS"})," which has the main benefit of having a better performance. It can do this because it is an ",(0,n.jsx)(t.strong,{children:"in-memory"})," database that processes all data in memory and only saves to disc when the app is closed or an interval is reached."]}),"\n",(0,n.jsxs)(t.p,{children:[(0,n.jsx)(t.strong,{children:"WARNING:"})," The LokiJS project itself is ",(0,n.jsx)(t.a,{href:"https://github.com/techfort/LokiJS/issues/917",children:"no longer"})," in development or maintained. Bugs that occur outside of the RxDB layer will likely not be fixed. It is recommended to use another ",(0,n.jsx)(t.a,{href:"/rx-storage.html",children:"RxStorage"})," instead."]}),"\n",(0,n.jsx)(t.h3,{id:"pros",children:"Pros"}),"\n",(0,n.jsxs)(t.ul,{children:["\n",(0,n.jsx)(t.li,{children:"Queries can run faster because all data is processed in memory."}),"\n",(0,n.jsx)(t.li,{children:"It has a much faster initial load time because it loads all data from IndexedDB in a single request. But this is only true for small datasets. If much data must is stored, the initial load time can be higher than on other RxStorage implementations."}),"\n"]}),"\n",(0,n.jsx)(t.h3,{id:"cons",children:"Cons"}),"\n",(0,n.jsxs)(t.ul,{children:["\n",(0,n.jsx)(t.li,{children:"It does not support attachments."}),"\n",(0,n.jsx)(t.li,{children:"Data can be lost when the JavaScript process is killed ungracefully like when the browser crashes or the power of the PC is terminated."}),"\n",(0,n.jsx)(t.li,{children:"All data must fit into the memory."}),"\n",(0,n.jsxs)(t.li,{children:["Slow initialisation time when used with ",(0,n.jsx)(t.code,{children:"multiInstance: true"})," because it has to await the leader election process."]}),"\n",(0,n.jsxs)(t.li,{children:["Slow initialisation time when really much data is stored inside of the database because it has to parse a big ",(0,n.jsx)(t.code,{children:"JSON"})," string."]}),"\n"]}),"\n",(0,n.jsx)(t.h2,{id:"usage",children:"Usage"}),"\n",(0,n.jsx)(t.pre,{children:(0,n.jsx)(t.code,{className:"language-ts",children:"import {\n    createRxDatabase\n} from 'rxdb';\nimport {\n    getRxStorageLoki\n} from 'rxdb/plugins/storage-lokijs';\n\n// in the browser, we want to persist data in IndexedDB, so we use the indexeddb adapter.\nconst LokiIncrementalIndexedDBAdapter = require('lokijs/src/incremental-indexeddb-adapter');\n\nconst db = await createRxDatabase({\n    name: 'exampledb',\n    storage: getRxStorageLoki({\n        adapter: new LokiIncrementalIndexedDBAdapter(),\n        /* \n         * Do not set lokiJS persistence options like autoload and autosave,\n         * RxDB will pick proper defaults based on the given adapter\n         */\n    })\n});\n"})}),"\n",(0,n.jsx)(t.h2,{id:"adapters",children:"Adapters"}),"\n",(0,n.jsxs)(t.p,{children:["LokiJS is based on adapters that determine where to store persistent data. For LokiJS there are adapters for IndexedDB, AWS S3, the NodeJS filesystem or NativeScript.\nFind more about the possible adapters at the ",(0,n.jsx)(t.a,{href:"https://github.com/techfort/LokiJS/blob/master/tutorials/Persistence%20Adapters.md",children:"LokiJS docs"}),"."]}),"\n",(0,n.jsx)(t.h2,{id:"multi-tab-support",children:"Multi-Tab support"}),"\n",(0,n.jsxs)(t.p,{children:["When you use plain LokiJS, you cannot build an app that can be used in multiple browser tabs. The reason is that LokiJS loads data in bulk and then only regularly persists the in-memory state to disc. When opened in multiple tabs, it would happen that the LokiJS instances overwrite each other and data is lost.\nWith the RxDB LokiJS-plugin, this problem is fixed with the ",(0,n.jsx)(t.a,{href:"https://github.com/pubkey/broadcast-channel#using-the-leaderelection",children:"LeaderElection"})," module. Between all open tabs, a leading tab is elected and only in this tab a database is created. All other tabs do not run queries against their own database, but instead call the leading tab to send and retrieve data. When the leading tab is closed, a new leader is elected that reopens the database and processes queries. You can disable this by setting ",(0,n.jsx)(t.code,{children:"multiInstance: false"})," when creating the ",(0,n.jsx)(t.code,{children:"RxDatabase"}),"."]}),"\n",(0,n.jsx)(t.h2,{id:"autosave-and-autoload",children:"Autosave and autoload"}),"\n",(0,n.jsxs)(t.p,{children:["When using plain LokiJS, you could set the ",(0,n.jsx)(t.code,{children:"autosave"})," option to ",(0,n.jsx)(t.code,{children:"true"})," to make sure that LokiJS persists the database state after each write into the persistence adapter. Same goes to ",(0,n.jsx)(t.code,{children:"autoload"})," which loads the persisted state on database creation.\nBut RxDB knows better when to persist the database state and when to load it, so it has its own autosave logic. This will ensure that running the persistence handler does not affect the performance of more important tasks. Instead RxDB will always wait until the database is idle and then runs the persistence handler.\nA load of the persisted state is done on database or collection creation and it is ensured that multiple load calls do not run in parallel and interfere with each other or with ",(0,n.jsx)(t.code,{children:"saveDatabase()"})," calls."]}),"\n",(0,n.jsx)(t.h2,{id:"known-problems",children:"Known problems"}),"\n",(0,n.jsxs)(t.p,{children:["When you bundle the LokiJS Plugin with webpack, you might get the error ",(0,n.jsx)(t.code,{children:'Cannot find module "fs"'}),". This is because LokiJS uses a ",(0,n.jsx)(t.code,{children:"require('fs')"})," statement that cannot work in the browser.\nYou can fix that by telling webpack to not resolve the ",(0,n.jsx)(t.code,{children:"fs"})," module with the following block in your webpack config:"]}),"\n",(0,n.jsx)(t.pre,{children:(0,n.jsx)(t.code,{className:"language-js",children:'// in your webpack.config.js\n{\n    /* ... */\n    resolve: {\n        fallback: {\n            fs: false\n        }\n    }\n    /* ... */\n}\n\n// Or if you do not have a webpack.config.js like you do with angular,\n// you might fix it by setting the browser field in the package.json\n{\n  /* ... */\n  "browser": {\n    "fs": false\n  }\n  /* ... */\n}\n\n'})}),"\n",(0,n.jsx)(t.h2,{id:"using-the-internal-lokijs-database",children:"Using the internal LokiJS database"}),"\n",(0,n.jsx)(t.p,{children:"For custom operations, you can access the internal LokiJS database.\nThis is dangerous because you might do changes that are not compatible with RxDB.\nOnly use this when there is no way to achieve your goals via the RxDB API."}),"\n",(0,n.jsx)(t.pre,{children:(0,n.jsx)(t.code,{className:"language-javascript",children:"\nconst storageInstance = myRxCollection.storageInstance;\nconst localState = await storageInstance.internals.localState;\nlocalState.collection.insert({\n    key: 'foo',\n    value: 'bar',\n    _deleted: false,\n    _attachments: {},\n    _rev: '1-62080c42d471e3d2625e49dcca3b8e3e',\n    _meta: {\n        lwt: new Date().getTime()\n    }\n});\n\n// manually trigger the save queue because we did a write to the internal loki db. \nawait localState.databaseState.saveQueue.addWrite();\n"})})]})}function c(e={}){const{wrapper:t}={...(0,s.a)(),...e.components};return t?(0,n.jsx)(t,{...e,children:(0,n.jsx)(h,{...e})}):h(e)}},1151:(e,t,a)=>{a.d(t,{Z:()=>r,a:()=>o});var n=a(7294);const s={},i=n.createContext(s);function o(e){const t=n.useContext(i);return n.useMemo((function(){return"function"==typeof e?e(t):{...t,...e}}),[t,e])}function r(e){let t;return t=e.disableParentContext?"function"==typeof e.components?e.components(s):e.components||s:o(e.components),n.createElement(i.Provider,{value:t},e.children)}}}]);