export function lastOfArray(ar) {
  return ar[ar.length - 1];
}

/**
 * shuffle the given array
 */
export function shuffleArray(arr) {
  return arr.slice(0).sort(() => Math.random() - 0.5);
}
export function toArray(input) {
  return Array.isArray(input) ? input.slice(0) : [input];
}

/**
 * Split array with items into smaller arrays with items
 * @link https://stackoverflow.com/a/7273794/3443137
 */
export function batchArray(array, batchSize) {
  array = array.slice(0);
  var ret = [];
  while (array.length) {
    var batch = array.splice(0, batchSize);
    ret.push(batch);
  }
  return ret;
}

/**
 * @link https://stackoverflow.com/a/15996017
 */
export function removeOneFromArrayIfMatches(ar, condition) {
  ar = ar.slice();
  var i = ar.length;
  var done = false;
  while (i-- && !done) {
    if (condition(ar[i])) {
      done = true;
      ar.splice(i, 1);
    }
  }
  return ar;
}

/**
 * returns true if the supplied argument is either an Array<T> or a Readonly<Array<T>>
 */
export function isMaybeReadonlyArray(x) {
  // While this looks strange, it's a workaround for an issue in TypeScript:
  // https://github.com/microsoft/TypeScript/issues/17002
  //
  // The problem is that `Array.isArray` as a type guard returns `false` for a readonly array,
  // but at runtime the object is an array and the runtime call to `Array.isArray` would return `true`.
  // The type predicate here allows for both `Array<T>` and `Readonly<Array<T>>` to pass a type check while
  // still performing runtime type inspection.
  return Array.isArray(x);
}
export function isOneItemOfArrayInOtherArray(ar1, ar2) {
  for (var i = 0; i < ar1.length; i++) {
    var el = ar1[i];
    var has = ar2.includes(el);
    if (has) {
      return true;
    }
  }
  return false;
}

/**
 * Use this in array.filter() to remove all empty slots
 * and have the correct typings afterwards.
 * @link https://stackoverflow.com/a/46700791/3443137
 */
export function arrayFilterNotEmpty(value) {
  if (value === null || value === undefined) {
    return false;
  }
  return true;
}
export function countUntilNotMatching(ar, matchingFn) {
  var count = 0;
  var idx = -1;
  for (var _item of ar) {
    idx = idx + 1;
    var matching = matchingFn(_item, idx);
    if (matching) {
      count = count + 1;
    } else {
      break;
    }
  }
  return count;
}
export async function asyncFilter(array, predicate) {
  var filters = await Promise.all(array.map(predicate));
  return array.filter((...[, index]) => filters[index]);
}

/**
 * @link https://stackoverflow.com/a/3762735
 */
export function sumNumberArray(array) {
  var count = 0;
  for (var i = array.length; i--;) {
    count += array[i];
  }
  return count;
}
export function maxOfNumbers(arr) {
  return Math.max(...arr);
}

/**
 * Appends the given documents to the given array.
 * This will mutate the first given array.
 * Mostly used as faster alternative to Array.concat()
 * because .concat() is so slow.
 * @link https://www.measurethat.net/Benchmarks/Show/4223/0/array-concat-vs-spread-operator-vs-push#latest_results_block
 */
export function appendToArray(ar, add) {
  var amount = add.length;
  for (var i = 0; i < amount; ++i) {
    var element = add[i];
    ar.push(element);
  }
}

/**
 * @link https://gist.github.com/telekosmos/3b62a31a5c43f40849bb
 */
export function uniqueArray(arrArg) {
  return arrArg.filter(function (elem, pos, arr) {
    return arr.indexOf(elem) === pos;
  });
}
//# sourceMappingURL=utils-array.js.map