<?php
/**
 * /install/timezone/index.php
 *
 * This file is part of DomainMOD, an open source domain and internet asset manager.
 * Copyright (c) 2010-2024 Greg Chetcuti <greg@chetcuti.com>
 *
 * Project: http://domainmod.org   Author: http://chetcuti.com
 *
 * DomainMOD is free software: you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * DomainMOD is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with DomainMOD. If not, see
 * http://www.gnu.org/licenses/.
 *
 */
?>
<?php
require_once __DIR__ . '/../../_includes/start-session.inc.php';
require_once __DIR__ . '/../../_includes/init.inc.php';
require_once DIR_INC . '/config.inc.php';
require_once DIR_INC . '/software.inc.php';
require_once DIR_ROOT . '/vendor/autoload.php';

$system = new DomainMOD\System();
$layout = new DomainMOD\Layout();
$form = new DomainMOD\Form();
$sanitize = new DomainMOD\Sanitize();
$unsanitize = new DomainMOD\Unsanitize();

require_once DIR_INC . '/head.inc.php';
require_once DIR_INC . '/debug.inc.php';
require_once DIR_INC . '/settings/install.timezone.inc.php';

$system->loginCheck();
$system->installCheck();

$_SESSION['s_installation_timezone'] = $_SESSION['s_installation_timezone'] ?? '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

    $_SESSION['s_installation_timezone'] = $sanitize->text($_POST['new_timezone']);

    header("Location: ../email-admin/");
    exit;

}
?>
<?php require_once DIR_INC . '/doctype.inc.php'; ?>
<html>
<head>
    <?php
    if ($page_title != "") { ?>
        <title><?php echo $layout->pageTitle($page_title); ?></title><?php
    } else { ?>
        <title><?php echo SOFTWARE_TITLE; ?></title><?php
    } ?>
    <?php require_once DIR_INC . '/layout/head-tags.inc.php'; ?>
</head>
<body class="hold-transition text-sm">
<?php require_once DIR_INC . '/layout/header-install.inc.php'; ?>
<?php
echo $form->showFormTop('');

echo $form->showDropdownTop('new_timezone', '', '', '', '');
echo $form->showDropdownOption('Africa/Abidjan', 'Africa/Abidjan', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Accra', 'Africa/Accra', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Addis_Ababa', 'Africa/Addis_Ababa', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Algiers', 'Africa/Algiers', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Asmara', 'Africa/Asmara', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Asmera', 'Africa/Asmera', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Bamako', 'Africa/Bamako', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Bangui', 'Africa/Bangui', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Banjul', 'Africa/Banjul', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Bissau', 'Africa/Bissau', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Blantyre', 'Africa/Blantyre', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Brazzaville', 'Africa/Brazzaville', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Bujumbura', 'Africa/Bujumbura', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Cairo', 'Africa/Cairo', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Casablanca', 'Africa/Casablanca', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Ceuta', 'Africa/Ceuta', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Conakry', 'Africa/Conakry', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Dakar', 'Africa/Dakar', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Dar_es_Salaam', 'Africa/Dar_es_Salaam', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Djibouti', 'Africa/Djibouti', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Douala', 'Africa/Douala', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/El_Aaiun', 'Africa/El_Aaiun', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Freetown', 'Africa/Freetown', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Gaborone', 'Africa/Gaborone', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Harare', 'Africa/Harare', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Johannesburg', 'Africa/Johannesburg', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Juba', 'Africa/Juba', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Kampala', 'Africa/Kampala', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Khartoum', 'Africa/Khartoum', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Kigali', 'Africa/Kigali', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Kinshasa', 'Africa/Kinshasa', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Lagos', 'Africa/Lagos', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Libreville', 'Africa/Libreville', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Lome', 'Africa/Lome', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Luanda', 'Africa/Luanda', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Lubumbashi', 'Africa/Lubumbashi', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Lusaka', 'Africa/Lusaka', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Malabo', 'Africa/Malabo', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Maputo', 'Africa/Maputo', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Maseru', 'Africa/Maseru', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Mbabane', 'Africa/Mbabane', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Mogadishu', 'Africa/Mogadishu', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Monrovia', 'Africa/Monrovia', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Nairobi', 'Africa/Nairobi', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Ndjamena', 'Africa/Ndjamena', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Niamey', 'Africa/Niamey', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Nouakchott', 'Africa/Nouakchott', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Ouagadougou', 'Africa/Ouagadougou', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Porto-Novo', 'Africa/Porto-Novo', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Sao_Tome', 'Africa/Sao_Tome', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Timbuktu', 'Africa/Timbuktu', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Tripoli', 'Africa/Tripoli', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Tunis', 'Africa/Tunis', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Africa/Windhoek', 'Africa/Windhoek', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Adak', 'America/Adak', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Anchorage', 'America/Anchorage', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Anguilla', 'America/Anguilla', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Antigua', 'America/Antigua', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Araguaina', 'America/Araguaina', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Argentina/Buenos_Aires', 'America/Argentina/Buenos_Aires', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Argentina/Catamarca', 'America/Argentina/Catamarca', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Argentina/ComodRivadavia', 'America/Argentina/ComodRivadavia', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Argentina/Cordoba', 'America/Argentina/Cordoba', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Argentina/Jujuy', 'America/Argentina/Jujuy', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Argentina/La_Rioja', 'America/Argentina/La_Rioja', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Argentina/Mendoza', 'America/Argentina/Mendoza', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Argentina/Rio_Gallegos', 'America/Argentina/Rio_Gallegos', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Argentina/Salta', 'America/Argentina/Salta', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Argentina/San_Juan', 'America/Argentina/San_Juan', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Argentina/San_Luis', 'America/Argentina/San_Luis', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Argentina/Tucuman', 'America/Argentina/Tucuman', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Argentina/Ushuaia', 'America/Argentina/Ushuaia', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Aruba', 'America/Aruba', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Asuncion', 'America/Asuncion', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Atikokan', 'America/Atikokan', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Atka', 'America/Atka', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Bahia', 'America/Bahia', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Bahia_Banderas', 'America/Bahia_Banderas', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Barbados', 'America/Barbados', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Belem', 'America/Belem', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Belize', 'America/Belize', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Blanc-Sablon', 'America/Blanc-Sablon', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Boa_Vista', 'America/Boa_Vista', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Bogota', 'America/Bogota', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Boise', 'America/Boise', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Buenos_Aires', 'America/Buenos_Aires', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Cambridge_Bay', 'America/Cambridge_Bay', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Campo_Grande', 'America/Campo_Grande', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Cancun', 'America/Cancun', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Caracas', 'America/Caracas', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Catamarca', 'America/Catamarca', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Cayenne', 'America/Cayenne', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Cayman', 'America/Cayman', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Chicago', 'America/Chicago', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Chihuahua', 'America/Chihuahua', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Coral_Harbour', 'America/Coral_Harbour', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Cordoba', 'America/Cordoba', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Costa_Rica', 'America/Costa_Rica', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Creston', 'America/Creston', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Cuiaba', 'America/Cuiaba', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Curacao', 'America/Curacao', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Danmarkshavn', 'America/Danmarkshavn', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Dawson', 'America/Dawson', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Dawson_Creek', 'America/Dawson_Creek', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Denver', 'America/Denver', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Detroit', 'America/Detroit', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Dominica', 'America/Dominica', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Edmonton', 'America/Edmonton', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Eirunepe', 'America/Eirunepe', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/El_Salvador', 'America/El_Salvador', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Ensenada', 'America/Ensenada', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Fort_Wayne', 'America/Fort_Wayne', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Fortaleza', 'America/Fortaleza', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Glace_Bay', 'America/Glace_Bay', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Godthab', 'America/Godthab', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Goose_Bay', 'America/Goose_Bay', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Grand_Turk', 'America/Grand_Turk', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Grenada', 'America/Grenada', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Guadeloupe', 'America/Guadeloupe', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Guatemala', 'America/Guatemala', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Guayaquil', 'America/Guayaquil', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Guyana', 'America/Guyana', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Halifax', 'America/Halifax', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Havana', 'America/Havana', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Hermosillo', 'America/Hermosillo', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Indiana/Indianapolis', 'America/Indiana/Indianapolis', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Indiana/Knox', 'America/Indiana/Knox', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Indiana/Marengo', 'America/Indiana/Marengo', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Indiana/Petersburg', 'America/Indiana/Petersburg', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Indiana/Tell_City', 'America/Indiana/Tell_City', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Indiana/Vevay', 'America/Indiana/Vevay', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Indiana/Vincennes', 'America/Indiana/Vincennes', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Indiana/Winamac', 'America/Indiana/Winamac', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Indianapolis', 'America/Indianapolis', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Inuvik', 'America/Inuvik', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Iqaluit', 'America/Iqaluit', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Jamaica', 'America/Jamaica', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Jujuy', 'America/Jujuy', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Juneau', 'America/Juneau', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Kentucky/Louisville', 'America/Kentucky/Louisville', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Kentucky/Monticello', 'America/Kentucky/Monticello', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Knox_IN', 'America/Knox_IN', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Kralendijk', 'America/Kralendijk', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/La_Paz', 'America/La_Paz', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Lima', 'America/Lima', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Los_Angeles', 'America/Los_Angeles', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Louisville', 'America/Louisville', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Lower_Princes', 'America/Lower_Princes', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Maceio', 'America/Maceio', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Managua', 'America/Managua', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Manaus', 'America/Manaus', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Marigot', 'America/Marigot', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Martinique', 'America/Martinique', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Matamoros', 'America/Matamoros', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Mazatlan', 'America/Mazatlan', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Mendoza', 'America/Mendoza', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Menominee', 'America/Menominee', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Merida', 'America/Merida', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Metlakatla', 'America/Metlakatla', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Mexico_City', 'America/Mexico_City', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Miquelon', 'America/Miquelon', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Moncton', 'America/Moncton', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Monterrey', 'America/Monterrey', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Montevideo', 'America/Montevideo', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Montreal', 'America/Montreal', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Montserrat', 'America/Montserrat', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Nassau', 'America/Nassau', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/New_York', 'America/New_York', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Nipigon', 'America/Nipigon', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Nome', 'America/Nome', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Noronha', 'America/Noronha', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/North_Dakota/Beulah', 'America/North_Dakota/Beulah', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/North_Dakota/Center', 'America/North_Dakota/Center', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/North_Dakota/New_Salem', 'America/North_Dakota/New_Salem', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Ojinaga', 'America/Ojinaga', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Panama', 'America/Panama', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Pangnirtung', 'America/Pangnirtung', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Paramaribo', 'America/Paramaribo', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Phoenix', 'America/Phoenix', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Port-au-Prince', 'America/Port-au-Prince', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Port_of_Spain', 'America/Port_of_Spain', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Porto_Acre', 'America/Porto_Acre', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Porto_Velho', 'America/Porto_Velho', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Puerto_Rico', 'America/Puerto_Rico', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Rainy_River', 'America/Rainy_River', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Rankin_Inlet', 'America/Rankin_Inlet', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Recife', 'America/Recife', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Regina', 'America/Regina', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Resolute', 'America/Resolute', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Rio_Branco', 'America/Rio_Branco', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Rosario', 'America/Rosario', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Santa_Isabel', 'America/Santa_Isabel', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Santarem', 'America/Santarem', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Santiago', 'America/Santiago', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Santo_Domingo', 'America/Santo_Domingo', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Sao_Paulo', 'America/Sao_Paulo', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Scoresbysund', 'America/Scoresbysund', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Shiprock', 'America/Shiprock', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Sitka', 'America/Sitka', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/St_Barthelemy', 'America/St_Barthelemy', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/St_Johns', 'America/St_Johns', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/St_Kitts', 'America/St_Kitts', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/St_Lucia', 'America/St_Lucia', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/St_Thomas', 'America/St_Thomas', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/St_Vincent', 'America/St_Vincent', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Swift_Current', 'America/Swift_Current', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Tegucigalpa', 'America/Tegucigalpa', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Thule', 'America/Thule', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Thunder_Bay', 'America/Thunder_Bay', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Tijuana', 'America/Tijuana', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Toronto', 'America/Toronto', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Tortola', 'America/Tortola', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Vancouver', 'America/Vancouver', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Virgin', 'America/Virgin', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Whitehorse', 'America/Whitehorse', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Winnipeg', 'America/Winnipeg', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Yakutat', 'America/Yakutat', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('America/Yellowknife', 'America/Yellowknife', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Antarctica/Casey', 'Antarctica/Casey', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Antarctica/Davis', 'Antarctica/Davis', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Antarctica/DumontDUrville', 'Antarctica/DumontDUrville', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Antarctica/Macquarie', 'Antarctica/Macquarie', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Antarctica/Mawson', 'Antarctica/Mawson', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Antarctica/McMurdo', 'Antarctica/McMurdo', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Antarctica/Palmer', 'Antarctica/Palmer', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Antarctica/Rothera', 'Antarctica/Rothera', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Antarctica/South_Pole', 'Antarctica/South_Pole', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Antarctica/Syowa', 'Antarctica/Syowa', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Antarctica/Vostok', 'Antarctica/Vostok', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Arctic/Longyearbyen', 'Arctic/Longyearbyen', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Aden', 'Asia/Aden', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Almaty', 'Asia/Almaty', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Amman', 'Asia/Amman', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Anadyr', 'Asia/Anadyr', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Aqtau', 'Asia/Aqtau', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Aqtobe', 'Asia/Aqtobe', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Ashgabat', 'Asia/Ashgabat', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Ashkhabad', 'Asia/Ashkhabad', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Baghdad', 'Asia/Baghdad', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Bahrain', 'Asia/Bahrain', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Baku', 'Asia/Baku', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Bangkok', 'Asia/Bangkok', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Beirut', 'Asia/Beirut', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Beirut', 'Asia/Beirut', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Brunei', 'Asia/Brunei', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Calcutta', 'Asia/Calcutta', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Choibalsan', 'Asia/Choibalsan', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Chongqing', 'Asia/Chongqing', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Chungking', 'Asia/Chungking', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Colombo', 'Asia/Colombo', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Dacca', 'Asia/Dacca', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Damascus', 'Asia/Damascus', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Dhaka', 'Asia/Dhaka', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Dili', 'Asia/Dili', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Dubai', 'Asia/Dubai', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Dushanbe', 'Asia/Dushanbe', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Gaza', 'Asia/Gaza', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Harbin', 'Asia/Harbin', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Hebron', 'Asia/Hebron', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Ho_Chi_Minh', 'Asia/Ho_Chi_Minh', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Hong_Kong', 'Asia/Hong_Kong', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Hovd', 'Asia/Hovd', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Irkutsk', 'Asia/Irkutsk', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Istanbul', 'Asia/Istanbul', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Jakarta', 'Asia/Jakarta', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Jayapura', 'Asia/Jayapura', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Jerusalem', 'Asia/Jerusalem', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Kabul', 'Asia/Kabul', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Kamchatka', 'Asia/Kamchatka', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Karachi', 'Asia/Karachi', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Kashgar', 'Asia/Kashgar', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Kathmandu', 'Asia/Kathmandu', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Katmandu', 'Asia/Katmandu', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Khandyga', 'Asia/Khandyga', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Kolkata', 'Asia/Kolkata', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Krasnoyarsk', 'Asia/Krasnoyarsk', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Kuala_Lumpur', 'Asia/Kuala_Lumpur', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Kuching', 'Asia/Kuching', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Kuwait', 'Asia/Kuwait', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Macao', 'Asia/Macao', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Macau', 'Asia/Macau', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Magadan', 'Asia/Magadan', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Makassar', 'Asia/Makassar', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Manila', 'Asia/Manila', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Muscat', 'Asia/Muscat', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Nicosia', 'Asia/Nicosia', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Novokuznetsk', 'Asia/Novokuznetsk', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Novosibirsk', 'Asia/Novosibirsk', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Omsk', 'Asia/Omsk', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Oral', 'Asia/Oral', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Phnom_Penh', 'Asia/Phnom_Penh', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Pontianak', 'Asia/Pontianak', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Pyongyang', 'Asia/Pyongyang', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Qatar', 'Asia/Qatar', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Qyzylorda', 'Asia/Qyzylorda', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Rangoon', 'Asia/Rangoon', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Riyadh', 'Asia/Riyadh', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Saigon', 'Asia/Saigon', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Sakhalin', 'Asia/Sakhalin', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Samarkand', 'Asia/Samarkand', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Seoul', 'Asia/Seoul', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Shanghai', 'Asia/Shanghai', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Singapore', 'Asia/Singapore', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Taipei', 'Asia/Taipei', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Tashkent', 'Asia/Tashkent', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Tbilisi', 'Asia/Tbilisi', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Tehran', 'Asia/Tehran', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Tel_Aviv', 'Asia/Tel_Aviv', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Thimbu', 'Asia/Thimbu', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Thimphu', 'Asia/Thimphu', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Tokyo', 'Asia/Tokyo', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Ujung_Pandang', 'Asia/Ujung_Pandang', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Ulaanbaatar', 'Asia/Ulaanbaatar', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Ulan_Bator', 'Asia/Ulan_Bator', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Urumqi', 'Asia/Urumqi', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Ust-Nera', 'Asia/Ust-Nera', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Vientiane', 'Asia/Vientiane', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Vladivostok', 'Asia/Vladivostok', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Yakutsk', 'Asia/Yakutsk', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Yekaterinburg', 'Asia/Yekaterinburg', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Asia/Yerevan', 'Asia/Yerevan', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Atlantic/Azores', 'Atlantic/Azores', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Atlantic/Bermuda', 'Atlantic/Bermuda', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Atlantic/Canary', 'Atlantic/Canary', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Atlantic/Cape_Verde', 'Atlantic/Cape_Verde', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Atlantic/Faeroe', 'Atlantic/Faeroe', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Atlantic/Faroe', 'Atlantic/Faroe', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Atlantic/Jan_Mayen', 'Atlantic/Jan_Mayen', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Atlantic/Madeira', 'Atlantic/Madeira', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Atlantic/Reykjavik', 'Atlantic/Reykjavik', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Atlantic/South_Georgia', 'Atlantic/South_Georgia', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Atlantic/St_Helena', 'Atlantic/St_Helena', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Atlantic/Stanley', 'Atlantic/Stanley', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/ACT', 'Australia/ACT', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/Adelaide', 'Australia/Adelaide', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/Brisbane', 'Australia/Brisbane', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/Broken_Hill', 'Australia/Broken_Hill', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/Canberra', 'Australia/Canberra', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/Currie', 'Australia/Currie', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/Darwin', 'Australia/Darwin', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/Eucla', 'Australia/Eucla', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/Hobart', 'Australia/Hobart', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/LHI', 'Australia/LHI', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/Lindeman', 'Australia/Lindeman', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/Lord_Howe', 'Australia/Lord_Howe', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/Melbourne', 'Australia/Melbourne', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/North', 'Australia/North', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/NSW', 'Australia/NSW', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/Perth', 'Australia/Perth', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/Queensland', 'Australia/Queensland', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/South', 'Australia/South', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/Sydney', 'Australia/Sydney', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/Tasmania', 'Australia/Tasmania', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/Victoria', 'Australia/Victoria', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/West', 'Australia/West', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Australia/Yancowinna', 'Australia/Yancowinna', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Brazil/Acre', 'Brazil/Acre', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Brazil/DeNoronha', 'Brazil/DeNoronha', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Brazil/East', 'Brazil/East', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Brazil/West', 'Brazil/West', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Canada/Atlantic', 'Canada/Atlantic', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Canada/Central', 'Canada/Central', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Canada/East-Saskatchewan', 'Canada/East-Saskatchewan', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Canada/Eastern', 'Canada/Eastern', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Canada/Mountain', 'Canada/Mountain', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Canada/Newfoundland', 'Canada/Newfoundland', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Canada/Pacific', 'Canada/Pacific', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Canada/Saskatchewan', 'Canada/Saskatchewan', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Canada/Yukon', 'Canada/Yukon', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Chile/Continental', 'Chile/Continental', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Chile/EasterIsland', 'Chile/EasterIsland', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Cuba', 'Cuba', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Egypt', 'Egypt', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Eire', 'Eire', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Amsterdam', 'Europe/Amsterdam', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Andorra', 'Europe/Andorra', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Athens', 'Europe/Athens', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Belfast', 'Europe/Belfast', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Belgrade', 'Europe/Belgrade', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Berlin', 'Europe/Berlin', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Bratislava', 'Europe/Bratislava', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Brussels', 'Europe/Brussels', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Bucharest', 'Europe/Bucharest', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Budapest', 'Europe/Budapest', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Busingen', 'Europe/Busingen', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Chisinau', 'Europe/Chisinau', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Copenhagen', 'Europe/Copenhagen', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Dublin', 'Europe/Dublin', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Gibraltar', 'Europe/Gibraltar', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Guernsey', 'Europe/Guernsey', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Helsinki', 'Europe/Helsinki', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Isle_of_Man', 'Europe/Isle_of_Man', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Istanbul', 'Europe/Istanbul', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Jersey', 'Europe/Jersey', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Kaliningrad', 'Europe/Kaliningrad', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Kiev', 'Europe/Kiev', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Lisbon', 'Europe/Lisbon', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Ljubljana', 'Europe/Ljubljana', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/London', 'Europe/London', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Luxembourg', 'Europe/Luxembourg', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Madrid', 'Europe/Madrid', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Malta', 'Europe/Malta', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Mariehamn', 'Europe/Mariehamn', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Minsk', 'Europe/Minsk', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Monaco', 'Europe/Monaco', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Moscow', 'Europe/Moscow', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Nicosia', 'Europe/Nicosia', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Oslo', 'Europe/Oslo', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Paris', 'Europe/Paris', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Podgorica', 'Europe/Podgorica', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Prague', 'Europe/Prague', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Riga', 'Europe/Riga', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Rome', 'Europe/Rome', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Samara', 'Europe/Samara', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/San_Marino', 'Europe/San_Marino', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Sarajevo', 'Europe/Sarajevo', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Simferopol', 'Europe/Simferopol', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Skopje', 'Europe/Skopje', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Sofia', 'Europe/Sofia', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Stockholm', 'Europe/Stockholm', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Tallinn', 'Europe/Tallinn', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Tirane', 'Europe/Tirane', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Tiraspol', 'Europe/Tiraspol', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Uzhgorod', 'Europe/Uzhgorod', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Vaduz', 'Europe/Vaduz', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Vatican', 'Europe/Vatican', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Vienna', 'Europe/Vienna', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Vilnius', 'Europe/Vilnius', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Volgograd', 'Europe/Volgograd', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Warsaw', 'Europe/Warsaw', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Zagreb', 'Europe/Zagreb', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Zaporozhye', 'Europe/Zaporozhye', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Europe/Zurich', 'Europe/Zurich', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Greenwich', 'Greenwich', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Hongkong', 'Hongkong', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Iceland', 'Iceland', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Indian/Antananarivo', 'Indian/Antananarivo', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Indian/Chagos', 'Indian/Chagos', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Indian/Christmas', 'Indian/Christmas', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Indian/Cocos', 'Indian/Cocos', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Indian/Comoro', 'Indian/Comoro', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Indian/Kerguelen', 'Indian/Kerguelen', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Indian/Mahe', 'Indian/Mahe', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Indian/Maldives', 'Indian/Maldives', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Indian/Mauritius', 'Indian/Mauritius', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Indian/Mayotte', 'Indian/Mayotte', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Indian/Reunion', 'Indian/Reunion', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Iran', 'Iran', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Israel', 'Israel', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Jamaica', 'Jamaica', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Japan', 'Japan', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Kwajalein', 'Kwajalein', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Libya', 'Libya', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Mexico/BajaNorte', 'Mexico/BajaNorte', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Mexico/BajaSur', 'Mexico/BajaSur', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Mexico/General', 'Mexico/General', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Apia', 'Pacific/Apia', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Auckland', 'Pacific/Auckland', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Chatham', 'Pacific/Chatham', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Chuuk', 'Pacific/Chuuk', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Easter', 'Pacific/Easter', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Efate', 'Pacific/Efate', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Enderbury', 'Pacific/Enderbury', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Fakaofo', 'Pacific/Fakaofo', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Fiji', 'Pacific/Fiji', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Funafuti', 'Pacific/Funafuti', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Galapagos', 'Pacific/Galapagos', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Gambier', 'Pacific/Gambier', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Guadalcanal', 'Pacific/Guadalcanal', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Guam', 'Pacific/Guam', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Honolulu', 'Pacific/Honolulu', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Johnston', 'Pacific/Johnston', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Kiritimati', 'Pacific/Kiritimati', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Kosrae', 'Pacific/Kosrae', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Kwajalein', 'Pacific/Kwajalein', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Majuro', 'Pacific/Majuro', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Marquesas', 'Pacific/Marquesas', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Midway', 'Pacific/Midway', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Nauru', 'Pacific/Nauru', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Niue', 'Pacific/Niue', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Norfolk', 'Pacific/Norfolk', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Noumea', 'Pacific/Noumea', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Pago_Pago', 'Pacific/Pago_Pago', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Palau', 'Pacific/Palau', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Pitcairn', 'Pacific/Pitcairn', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Pohnpei', 'Pacific/Pohnpei', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Ponape', 'Pacific/Ponape', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Port_Moresby', 'Pacific/Port_Moresby', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Rarotonga', 'Pacific/Rarotonga', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Saipan', 'Pacific/Saipan', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Samoa', 'Pacific/Samoa', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Tahiti', 'Pacific/Tahiti', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Tarawa', 'Pacific/Tarawa', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Tongatapu', 'Pacific/Tongatapu', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Truk', 'Pacific/Truk', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Wake', 'Pacific/Wake', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Wallis', 'Pacific/Wallis', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Pacific/Yap', 'Pacific/Yap', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Poland', 'Poland', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Portugal', 'Portugal', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Singapore', 'Singapore', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Turkey', 'Turkey', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('US/Alaska', 'US/Alaska', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('US/Aleutian', 'US/Aleutian', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('US/Arizona', 'US/Arizona', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('US/Central', 'US/Central', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('US/East-Indiana', 'US/East-Indiana', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('US/Eastern', 'US/Eastern', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('US/Hawaii', 'US/Hawaii', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('US/Indiana-Starke', 'US/Indiana-Starke', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('US/Michigan', 'US/Michigan', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('US/Mountain', 'US/Mountain', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('US/Pacific', 'US/Pacific', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('US/Pacific-New', 'US/Pacific-New', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('US/Samoa', 'US/Samoa', $_SESSION['s_installation_timezone']);
echo $form->showDropdownOption('Zulu', 'Zulu', $_SESSION['s_installation_timezone']);
echo $form->showDropdownBottom('');
?>
<BR>
<a href="../currency/"><?php echo $layout->showButton('button', _('Go Back')); ?></a>
<?php
echo $form->showSubmitButton(_('Next Step'), '', '');
echo $form->showFormBottom('');
?>
<?php require_once DIR_INC . '/layout/footer-install.inc.php'; ?>
</body>
</html>
