# Dagger

Dagger is a portable devkit for CICD.

Using Dagger, software teams can develop powerful CICD pipelines with minimal effort, then run them anywhere. Benefits include:

* Unify dev and CI environments. Write your pipeline once, Dagger will run it the same everywhere.
* Reduce CI lock-in. No more re-writing everything from scratch every 6 months.

<img src="https://user-images.githubusercontent.com/216487/122216381-328a3500-ce61-11eb-907f-d2b6f66b3b10.png" width="400" />

## How does it work?

1. Automate actions with your favorite programming language. No proprietary SDK: just regular shell, Go, Javascript, Python...
2. Reuse actions from a large and growing catalog.
3. Tie it all together in CUE - a revolutionary declarative language invented at Google. No more YAML hell!
4. Test and debug instantly on your local machine. No more waiting 10min to catch a typo.
5. Run your pipelines on any Docker-compatible runtime, for maximum portability. This means most modern CI runners can run Dagger out of the box.

## Getting Started

[Documentation website](https://docs.dagger.io/)

## Useful links

* [Join the Dagger community on Discord](https://discord.gg/ufnyBtc8uY)
* [Install from a binary release](https://docs.dagger.io/1001/install/)
* [Build from source](https://docs.dagger.io/1001/install/#option-4-install-from-source)
* [How to contribute](https://github.com/dagger/.github/blob/main/CONTRIBUTING.md)
