---
slug: /1213/api
displayed_sidebar: europa
---

# Dagger CUE API (0.2+)

As of Dagger 0.2 (codename Europa), the Dagger CUE API can be imported at `dagger.io/dagger`.

The Dagger CUE API is the set of CUE packages released alongside the Dagger engine, to allow developers to access its features.

### Plan definition

`#Plan` defines the structure of a Dagger plan - a complete configuration executable by `dagger up`.

### Core types

Dagger extends the CUE type system with the following core types:

* `#FS`: a reference to a filesystem tree
* `#Secret`: a secure reference to an external secret
* `#Service` a reference to a network service endpoints

### Core actions

Dagger works by executing actions in a certain order and passing data between actions in a certain layout.

Developers can combine actions into higher-level actions, which in turn can be combined into even higher-level actions,
and so on at arbitrary levels of depth. At the bottom of this abstraction stack are *core actions*: these
are implemented by Dagger itself, and are always available.

The following core actions are available:

| Core action | File | Description |
| -- | -- | -- |
| `#Exec` | exec.cue | Execute a command in a docker-compatible container |
| `#HTTPFetch` | http.cue | Download an archive from an HTTP server |
| `#Push` | image.cue | Upload an image to a docker registry |
| `#Pull` | image.cue | Download an image from a docker registry |
| `#Dockerfile` | image.cue | Execute a Dockerfile |
| `#Set` | image.cue | Modify a docker image |
| `#GitPush` | git.cue | Upload a repository to a remote git server |
| `#GitPull` | git.cue | Download a repository from a remote git server |
| `#DecodeSecret` | secrets.cue | Decode a secret without leaking its contents |
| `#NewSecret` | secrets.cue | Dynamically create a new secret |
| `#Source` | fs.cue | Access the source for the current CUE package |
| `#Mkdir` | fs.cue | Create a directory in a filesystem tree |
| `#ReadFile` | fs.cue | Read a file from a tree |
| `#WriteFile` | fs.cue | Write a file to a tree |
| `#Scratch` | fs.cue | Create an empty tree |
| `#Copy` | fs.cue | Copy files between two trees |
| `#Subdir` | fs.cue | Read a subdirectory from a filesystem tree |
