---
slug: /1220/vs
displayed_sidebar: "0.2"
pagination_prev: null
pagination_next: null
---

# Dagger vs. Other Software

## What is Dagger?

Dagger is a portable devkit for CI/CD.

Using Dagger, software teams can develop powerful CI/CD pipelines with minimal effort, then run them anywhere.

## Dagger Benefits

Benefits of using Dagger include:

- Unify dev and CI environments. Write your pipeline once, Dagger will run it the same everywhere.
- Reduce CI lock-in. No more re-writing everything from scratch every 6 months.
- Rapid debugging of your pipelines. Dagger runs equally well on your [local machine](/1200/local-dev), and in [CI](/1201/ci-environment). Dagger can be used with [any CI environment](/1201/ci-environment) (no migration required) and has two important advantages which make the overall experience less error-prone and more efficient:
  1. You don't write YAML, you write [CUE](/1215/what-is-cue) - typed configuration with built-in formatting
  2. Configuration is executed in [BuildKit](https://github.com/moby/buildkit), the execution engine at the heart of Docker

## How does it work?

- Automate actions with your favorite programming language. No proprietary SDK: just regular shell, Go, Javascript, Python...
- Reuse actions from a large and growing catalog.
- Tie it all together in CUE - a revolutionary declarative language invented at Google. No more YAML hell!
- Test and debug instantly on your local machine. No more waiting 10min to catch a typo.
- Run your pipelines on any Docker-compatible runtime, for maximum portability. This means most modern CI runners can run Dagger out of the box.

## Dagger vs. CI (GitHub Actions, GitLab, CircleCI, Jenkins, etc.)

Dagger does not replace your CI: it improves it by adding a portable development layer on top of it.

- Dagger runs on all major CI products. This _reduces CI lock-in_: you can change CI without rewriting all your pipelines.
- Dagger also runs on your dev machine. This allows _dev/CI parity_: the same pipelines can be used in CI and development.

## Dagger vs. PaaS (Heroku, Firebase, etc.)

Dagger is not a PaaS, but you can use it to add PaaS-like features to your CICD pipelines:

- A simple deployment abstraction for the developer
- A catalog of possible customizations, managed by the platform team
- On-demand staging or development environments

Using Dagger is a good way to get many of the benefits of a PaaS (developer productivity and peace of mind),
without giving up the benefits of custom CICD pipelines (full control over your infrastructure and tooling).

## Dagger vs. artisanal deploy scripts

Most applications have a custom deploy script that usually gets the job done, but is painful to change and troubleshoot.

Using Dagger, you have two options:

- You can _replace_ your script with a DAG that is better in every way: more features, more reliable, faster, easier to read, improve, and debug.
- You can _extend_ your script by wrapping it, as-is, into a DAG. This allows you to start using Dagger right away, and worry about rewrites later.

## Dagger vs. Infrastructure as Code (Terraform, Pulumi, Cloudformation, CDK)

Dagger is the perfect complement to an IaC tool.

- IaC tools help infrastructure teams answer questions like: what is the current state of my infrastructure? What is its desired state? And how do I get there?
- Dagger helps CICD teams answer question like: what work needs to be done to deliver my application, in what order, and how do I orchestrate it?

It is very common for a Dagger configuration to integrate with at least one IaC tool.

## Dagger vs. Build Systems (Make, Maven, Bazel, Npm/Yarn, Docker Build, etc.)

Dagger is complementary to build systems. Most Dagger configurations involve integrating with at least one specialized build.
If several build systems are involved, Dagger helps integrate them into a unified graph.
