---
slug: /sdk/cue/760478/go-ci
displayed_sidebar: 'current'
---

# Testing and building a Go project

This guide explains how to run some tests and build a Go project with the `go` cue package.

## Plan

The plan consist of 2 actions:

- `test` for `go test`
- `build` for `go build`

both use the [Go package](https://github.com/dagger/dagger/tree/main/pkg/universe.dagger.io/go)

```cue file=../../plans/go-ci/plan.cue

```

## Go project

The project is a simple program that takes `$NAME` environment variable, use the [Go greeting package](https://github.com/dagger/dagger/tree/main/docs/plans/go-ci/hello/greeting) to print the `greeting.Greeting()` out.

```go file=../../plans/go-ci/hello/main.go title=hello/main.go

```

```go file=../../plans/go-ci/hello/greeting/greeting.go title=hello/greeting/greeting.go

```

```go file=../../plans/go-ci/hello/greeting/greeting_test.go title=hello/greeting/greeting_test.go

```
