---
slug: /sdk/cue
---

# Dagger CUE SDK

### What is the Dagger CUE SDK?

The Dagger CUE SDK contains everything you need to develop CI/CD pipelines using the [CUE configuration language](https://cuelang.org), and run them on any OCI-compatible container runtime.

Currently the CUE SDK consists of:

- A CLI, `dagger-cue`
- The Dagger Engine (launched by the CLI by default)
- A collection of [CUE packages](https://github.com/dagger/dagger/tree/cue-sdk/pkg) and sample applications
- This documentation

### Who is it for?

The Dagger CUE SDK may be a good fit if...

- You are a fan of the CUE language, and looking for an opportunity to use it more.
- You enjoy the declarative nature of YAML, but wish it were more powerful.

The Dagger CUE SDK may *not* be a good fit it...

- You don't know CUE, and are not interested in learning a new language.
- You generally prefer using mainstream languages with established ecosystems.

### How does it work?

You write pipelines using the Dagger CUE SDK and execute on a Dagger Engine by using the `dagger-cue` CLI. You can connect to an existing Dagger Engine, or the `dagger-cue` CLI will provision one on-the-fly.

### Get started

To learn more, [install the CUE SDK](./getting-started/526369-install.mdx) and [start using it](./getting-started/470907-get-started.md).
