---
slug: /sdk/cue/232322/guides
---

# Guides

## Core Concepts

- [How Dagger works](./getting-started/159741-how-it-works.mdx)
- [Dagger Actions](./core-concepts/934917-action.md)
- [A Dagger Plan orchestrates the Actions](./core-concepts/347598-plan.md)
- [Interacting with the client](./core-concepts/006395-client.md)
- [How to use secrets](./core-concepts/233781-secrets.md)
- [What is CUE?](./core-concepts/151357-what-is-cue.md)
- [Dagger filesystems: `#FS`](./core-concepts/667572-dagger-fs.md)

## Writing Actions

- [Handling action outputs](./guides/actions/490715-handling-outputs.md)
- [How to always execute an action?](./guides/actions/236525-always-execute.md)
- [Default values and optional fields](./guides/actions/189635-default-values-cue.md)
- [Making reusable packages](./guides/actions/404569-making-reusable-package.md)
- [When to use `core.#Source`?](./guides/actions/246250-core-source.md)
- [Understanding field shadowing and how to avoid it](./guides/actions/831049-field-shadowing.md)

## Logging/Debugging

- [How can I have better logs?](./guides/logdebug/481414-better-logs.md)

## Projects/Packaging

- [Building container images](./guides/concepts/457544-container-images.md)
- [Pushing your plan's dependencies](./guides/concepts/204704-pushing-plan-dependencies.md)
- [How can I chain actions together?](./guides/concepts/200145-chain-actions.md)
- [Project file organization](./guides/concepts/809436-project-file-organization.md)
- [The docker package](./guides/concepts/966156-docker.md)
- [Testing and building a Go project](./guides/concepts/760478-go-ci.md)
- [Packages with customizable images](./guides/concepts/937034-api-customizable-image.md)

## Docker Engine

- [Loading an image into a docker engine](./guides/docker/921290-docker-cli-load.md)
- [Running commands with the docker binary (CLI)](./guides/docker/094907-docker-cli-run.md)

## System

- [Understanding CLI telemetry](./guides/system/642025-cli-telemetry.md)

## Guidelines

- [Contributing to Dagger](./guidelines/749394-contributing.md)
- [Package Coding Style](./guidelines/102745-coding-style.md)
