##########################################################################################

## Base script:   https://portal.firecloud.org/#methods/Talkowski-SV/04_v2_genotype_depth_part1/9/wdl

## Github commit: talkowski-lab/gatk-sv-v1:<ENTER HASH HERE IN FIRECLOUD>

##########################################################################################

version 1.0

import "TrainRDGenotyping.wdl" as rd_train

workflow GenotypeDepthPart1 {
  input {
    File batch_vcf
    String batch
    File coveragefile     # batch coverage file
    File medianfile         # batch median file
    File famfile            # batch famfile
    File rf_cutoffs         # Random forest cutoffs
    File seed_cutoffs
    Array[String] samples   # List of samples in batch
    Int n_RD_genotype_bins  # number of RdTest bins
    Int n_per_RD_split      # number of variants per RdTest split
    String reference_build  #hg19 or hg38

    String sv_mini_docker
    String sv_pipeline_rdtest_docker
    String sv_pipeline_docker
    RuntimeAttr? runtime_attr_training_bed
    RuntimeAttr? runtime_attr_genotype_train
    RuntimeAttr? runtime_attr_generate_cutoff
    RuntimeAttr? runtime_attr_update_cutoff
    RuntimeAttr? runtime_attr_split_variants
    RuntimeAttr? runtime_attr_rdtest_genotype
    RuntimeAttr? runtime_attr_merge_genotypes
  }
  
  call rd_train.TrainRDGenotyping as TrainRDGenotyping {
    input:
      rf_cutoffs = rf_cutoffs,
      seed_cutoffs = seed_cutoffs,
      medianfile = medianfile,
      coveragefile = coveragefile,
      prefix = batch,
      n_bins = n_RD_genotype_bins,
      reference_build = reference_build,
      samples = samples,
      n_per_split = n_per_RD_split,
      vcf = batch_vcf,
      famfile = famfile,
      sv_mini_docker = sv_mini_docker,
      sv_pipeline_docker = sv_pipeline_docker,
      sv_pipeline_rdtest_docker = sv_pipeline_rdtest_docker,
      runtime_attr_training_bed = runtime_attr_training_bed,
      runtime_attr_genotype_train = runtime_attr_genotype_train,
      runtime_attr_generate_cutoff = runtime_attr_generate_cutoff,
      runtime_attr_update_cutoff = runtime_attr_update_cutoff,
      runtime_attr_split_variants = runtime_attr_split_variants,
      runtime_attr_rdtest_genotype = runtime_attr_rdtest_genotype,
      runtime_attr_merge_genotypes = runtime_attr_merge_genotypes
  }

  output {
    File RD_pesr_sepcutoff = TrainRDGenotyping.pesr_sepcutoff
    File RD_depth_sepcutoff = TrainRDGenotyping.depth_sepcutoff
  }
}


