/*
 * Copyright 2024 OICR and UCSC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *           http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package io.dockstore.webservice.core.metrics;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;

@Schema(name = "ExecutionsResponseBody", description = "Response body model for execution metric APIs")
public class ExecutionsResponseBody {

    @Schema(description = "A list of responses for the executions submitted")
    private List<ExecutionResponse> executionResponses = new ArrayList<>();

    public List<ExecutionResponse> getExecutionResponses() {
        return executionResponses;
    }

    public void setExecutionResponses(List<ExecutionResponse> executionResponses) {
        this.executionResponses = executionResponses;
    }
}
