/*
 *    Copyright 2021 OICR
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package io.dockstore.common.yaml;

import io.dockstore.common.yaml.constraints.AuthorHasNameOrOrcid;
import io.dockstore.common.yaml.constraints.Orcid;
import jakarta.validation.constraints.Email;

@AuthorHasNameOrOrcid
public class YamlAuthor {

    private String name;

    private String role;

    private String affiliation;

    private String email;

    private String orcid;

    public String getName() {
        return name;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public String getRole() {
        return role;
    }

    public void setRole(final String role) {
        this.role = role;
    }

    public String getAffiliation() {
        return affiliation;
    }

    public void setAffiliation(final String affiliation) {
        this.affiliation = affiliation;
    }

    @Email
    public String getEmail() {
        return email;
    }

    public void setEmail(final String email) {
        this.email = email;
    }

    @Orcid
    public String getOrcid() {
        return orcid;
    }

    public void setOrcid(final String orcid) {
        this.orcid = orcid;
    }

    public String toString() {
        return new BriefToStringBuilder(this)
            .append("name", name)
            .append("role", role)
            .append("affiliation", affiliation)
            .append("email", email)
            .append("orcid", orcid)
            .toString();
    }
}
