/*
 * Copyright 2024 OICR and UCSC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *           http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package io.dockstore.common.metrics.constraints;

import io.dockstore.common.metrics.ExecutionStatus;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;

/**
 * Validates that the execution status is meant for client use.
 */
public class ValidClientExecutionStatusValidator implements ConstraintValidator<ValidClientExecutionStatus, ExecutionStatus> {

    @Override
    public boolean isValid(final ExecutionStatus executionStatus, final ConstraintValidatorContext context) {
        return executionStatus != ExecutionStatus.ALL; // ALL is only meant to be used internally
    }
}
