## How to contribute to Dockstore

#### **Did you find a bug?**

* **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/dockstore/dockstore/issues).

* If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/dockstore/dockstore/issues/new). Be sure to include a **title and clear description**, as much relevant information as possible, and a **code sample** or an **executable test case** demonstrating the expected behavior that is not occurring.

#### **Did you write a patch that fixes a bug?**

* Open a new GitHub pull request with the patch.

* Ensure the PR description clearly describes the problem and solution. Include the relevant issue number if applicable.

* Before submitting, please read ensure that your code passes the style guide and tests. See the GitHub status checks on your PR for more details. Note that until we resolve [this](https://github.com/dockstore/dockstore/issues/3541) issue, a large number of integration tests will fail.

#### **Do you intend to add a new feature or change an existing one?**

* Suggest your change as a [github issue](https://github.com/dockstore/dockstore/issues) either by creating a new issue or commenting on an existing one and start writing code. The relevant repositories are nested under our [organization](https://github.com/dockstore) including the webservice (dockstore), the user interface (dockstore-ui2), the command-line interface (dockstore-cli), and many more. 

#### **Do you want to contribute to the Dockstore documentation?**

* Most of our documentation is generated from [dockstore-documentation](https://github.com/dockstore/dockstore-documentation).
