/* Copyright (C) 2019, 2020, 2021, 2022, 2023, 2024, 2025 Dnote contributors
 *
 * This file is part of Dnote.
 *
 * Dnote is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Dnote is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Dnote.  If not, see <https://www.gnu.org/licenses/>.
 */

// Package consts provides definitions of constants
package consts

var (
	// LegacyDnoteDirName is the name of the legacy directory containing dnote files
	LegacyDnoteDirName = ".dnote"
	// DnoteDirName is the name of the directory containing dnote files
	DnoteDirName = "dnote"
	// DnoteDBFileName is a filename for the Dnote SQLite database
	DnoteDBFileName = "dnote.db"
	// TmpContentFileBase is the base for the filename for a temporary content
	TmpContentFileBase = "DNOTE_TMPCONTENT"
	// TmpContentFileExt is the extension for the temporary content file
	TmpContentFileExt = "md"
	// ConfigFilename is the name of the config file
	ConfigFilename = "dnoterc"

	// SystemSchema is the key for schema in the system table
	SystemSchema = "schema"
	// SystemRemoteSchema is the key for remote schema in the system table
	SystemRemoteSchema = "remote_schema"
	// SystemLastSyncAt is the timestamp of the server at the last sync
	SystemLastSyncAt = "last_sync_time"
	// SystemLastMaxUSN is the user's max_usn from the server at the alst sync
	SystemLastMaxUSN = "last_max_usn"
	// SystemLastUpgrade is the timestamp at which the system more recently checked for an upgrade
	SystemLastUpgrade = "last_upgrade"
	// SystemSessionKey is the session key
	SystemSessionKey = "session_token"
	// SystemSessionKeyExpiry is the timestamp at which the session key will expire
	SystemSessionKeyExpiry = "session_token_expiry"
)
