/**
 * Generated by @openapi-codegen
 *
 * @version 1.0.0
 */
import * as reactQuery from '@tanstack/react-query';
import {useApiContext, ApiContext} from './apiContext';
import type * as Fetcher from './apiFetcher';
import {apiFetch} from './apiFetcher';
import type * as Schemas from './apiSchemas';
import type * as RequestBodies from './apiRequestBodies';
import type {ClientErrorStatus, ServerErrorStatus} from './apiUtils';

export type GetAppsQueryParams = {
  page?: number;
  per_page?: number;
  q?: string;
};

export type GetAppsError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.AppPagination;
}>;

export type GetAppsVariables = {
  queryParams?: GetAppsQueryParams;
} & ApiContext['fetcherOptions'];

export const fetchGetApps = (variables: GetAppsVariables, signal?: AbortSignal) =>
  apiFetch<undefined, GetAppsError, undefined, {}, GetAppsQueryParams, {}>({
    url: '/api/apps',
    method: 'get',
    ...variables,
    signal,
  });

export const useGetApps = <TData = Schemas.AppPagination>(
  variables: GetAppsVariables,
  options?: Omit<reactQuery.UseQueryOptions<undefined, GetAppsError, TData>, 'queryKey' | 'queryFn' | 'initialData'>,
) => {
  const {fetcherOptions, queryOptions, queryKeyFn} = useApiContext(options);
  return reactQuery.useQuery<undefined, GetAppsError, TData>({
    queryKey: queryKeyFn({path: '/api/apps', operationId: 'getApps', variables}),
    queryFn: ({signal}) => fetchGetApps({...fetcherOptions, ...variables}, signal),
    ...options,
    ...queryOptions,
  });
};

export type CreateAppError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.App;
}>;

export type CreateAppVariables = {
  body: RequestBodies.App;
} & ApiContext['fetcherOptions'];

export const fetchCreateApp = (variables: CreateAppVariables, signal?: AbortSignal) =>
  apiFetch<Schemas.App, CreateAppError, RequestBodies.App, {}, {}, {}>({
    url: '/api/apps',
    method: 'post',
    ...variables,
    signal,
  });

export const useCreateApp = (
  options?: Omit<reactQuery.UseMutationOptions<Schemas.App, CreateAppError, CreateAppVariables>, 'mutationFn'>,
) => {
  const {fetcherOptions} = useApiContext();
  return reactQuery.useMutation<Schemas.App, CreateAppError, CreateAppVariables>(
    (variables: CreateAppVariables) => fetchCreateApp({...fetcherOptions, ...variables}),
    options,
  );
};

export type DeleteAppByIdPathParams = {
  appId: string;
};

export type DeleteAppByIdError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.DeleteMessage;
}>;

export type DeleteAppByIdVariables = {
  pathParams: DeleteAppByIdPathParams;
} & ApiContext['fetcherOptions'];

export const fetchDeleteAppById = (variables: DeleteAppByIdVariables, signal?: AbortSignal) =>
  apiFetch<undefined, DeleteAppByIdError, undefined, {}, {}, DeleteAppByIdPathParams>({
    url: '/api/apps/{appId}',
    method: 'delete',
    ...variables,
    signal,
  });

export const useDeleteAppById = (
  options?: Omit<reactQuery.UseMutationOptions<undefined, DeleteAppByIdError, DeleteAppByIdVariables>, 'mutationFn'>,
) => {
  const {fetcherOptions} = useApiContext();
  return reactQuery.useMutation<undefined, DeleteAppByIdError, DeleteAppByIdVariables>({
    mutationFn: (variables: DeleteAppByIdVariables) => fetchDeleteAppById({...fetcherOptions, ...variables}),
    ...options,
  });
};

export type GetAppByIdPathParams = {
  appId: string;
};

export type GetAppByIdError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.App;
}>;

export type GetAppByIdVariables = {
  pathParams: GetAppByIdPathParams;
} & ApiContext['fetcherOptions'];

export const fetchGetAppById = (variables: GetAppByIdVariables, signal?: AbortSignal) =>
  apiFetch<undefined, GetAppByIdError, undefined, {}, {}, GetAppByIdPathParams>({
    url: '/api/apps/{appId}',
    method: 'get',
    ...variables,
    signal,
  });

export const useGetAppById = <TData = Schemas.App>(
  variables: GetAppByIdVariables,
  options?: Omit<reactQuery.UseQueryOptions<undefined, GetAppByIdError, TData>, 'queryKey' | 'queryFn' | 'initialData'>,
) => {
  const {fetcherOptions, queryOptions, queryKeyFn} = useApiContext(options);
  return reactQuery.useQuery<undefined, GetAppByIdError, TData>({
    queryKey: queryKeyFn({path: '/api/apps/{appId}', operationId: 'getAppById', variables}),
    queryFn: ({signal}) => fetchGetAppById({...fetcherOptions, ...variables}, signal),
    ...options,
    ...queryOptions,
  });
};

export type PutAppByIdPathParams = {
  appId: string;
};

export type PutAppByIdError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.App;
}>;

export type PutAppByIdVariables = {
  body: RequestBodies.App;
  pathParams: PutAppByIdPathParams;
} & ApiContext['fetcherOptions'];

export const fetchPutAppById = (variables: PutAppByIdVariables, signal?: AbortSignal) =>
  apiFetch<Schemas.App, PutAppByIdError, RequestBodies.App, {}, {}, PutAppByIdPathParams>({
    url: '/api/apps/{appId}',
    method: 'put',
    ...variables,
    signal,
  });

export const usePutAppById = (
  options?: Omit<reactQuery.UseMutationOptions<Schemas.App, PutAppByIdError, PutAppByIdVariables>, 'mutationFn'>,
) => {
  const {fetcherOptions} = useApiContext();
  return reactQuery.useMutation<Schemas.App, PutAppByIdError, PutAppByIdVariables>(
    (variables: PutAppByIdVariables) => fetchPutAppById({...fetcherOptions, ...variables}),
    options,
  );
};

export type GetGroupRoleAuditsQueryParams = {
  page?: number;
  per_page?: number;
  q?: string;
  owner?: boolean;
  active?: boolean;
  needs_review?: boolean;
  app_owner?: boolean;
  managed?: boolean;
  /**
   * @default created_at
   */
  order_by?: 'moniker' | 'created_at' | 'ended_at';
  /**
   * @default true
   */
  order_desc?: boolean;
  group_id?: string;
  role_id?: string;
  owner_id?: string;
  role_owner_id?: string;
  start_date?: number;
  end_date?: number;
};

export type GetGroupRoleAuditsError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.GroupRoleAuditPagination;
}>;

export type GetGroupRoleAuditsVariables = {
  queryParams?: GetGroupRoleAuditsQueryParams;
} & ApiContext['fetcherOptions'];

export const fetchGetGroupRoleAudits = (variables: GetGroupRoleAuditsVariables, signal?: AbortSignal) =>
  apiFetch<undefined, GetGroupRoleAuditsError, undefined, {}, GetGroupRoleAuditsQueryParams, {}>({
    url: '/api/audit/groups',
    method: 'get',
    ...variables,
    signal,
  });

export const useGetGroupRoleAudits = <TData = Schemas.GroupRoleAuditPagination>(
  variables: GetGroupRoleAuditsVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<undefined, GetGroupRoleAuditsError, TData>,
    'queryKey' | 'queryFn' | 'initialData'
  >,
) => {
  const {fetcherOptions, queryOptions, queryKeyFn} = useApiContext(options);
  return reactQuery.useQuery<undefined, GetGroupRoleAuditsError, TData>({
    queryKey: queryKeyFn({path: '/api/audit/groups', operationId: 'getGroupRoleAudits', variables}),
    queryFn: ({signal}) => fetchGetGroupRoleAudits({...fetcherOptions, ...variables}, signal),
    ...options,
    ...queryOptions,
  });
};

export type GetUserGroupAuditsQueryParams = {
  page?: number;
  per_page?: number;
  q?: string;
  owner?: boolean;
  active?: boolean;
  needs_review?: boolean;
  managed?: boolean;
  /**
   * @default created_at
   */
  order_by?: 'moniker' | 'created_at' | 'ended_at';
  /**
   * @default true
   */
  order_desc?: boolean;
  user_id?: string;
  group_id?: string;
  owner_id?: string;
  direct?: boolean;
  deleted?: boolean;
  start_date?: number;
  end_date?: number;
};

export type GetUserGroupAuditsError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.UserGroupAuditPagination;
}>;

export type GetUserGroupAuditsVariables = {
  queryParams?: GetUserGroupAuditsQueryParams;
} & ApiContext['fetcherOptions'];

export const fetchGetUserGroupAudits = (variables: GetUserGroupAuditsVariables, signal?: AbortSignal) =>
  apiFetch<undefined, GetUserGroupAuditsError, undefined, {}, GetUserGroupAuditsQueryParams, {}>({
    url: '/api/audit/users',
    method: 'get',
    ...variables,
    signal,
  });

export const useGetUserGroupAudits = <TData = Schemas.UserGroupAuditPagination>(
  variables: GetUserGroupAuditsVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<undefined, GetUserGroupAuditsError, TData>,
    'queryKey' | 'queryFn' | 'initialData'
  >,
) => {
  const {fetcherOptions, queryOptions, queryKeyFn} = useApiContext(options);
  return reactQuery.useQuery<undefined, GetUserGroupAuditsError, TData>({
    queryKey: queryKeyFn({path: '/api/audit/users', operationId: 'getUserGroupAudits', variables}),
    queryFn: ({signal}) => fetchGetUserGroupAudits({...fetcherOptions, ...variables}, signal),
    ...options,
    ...queryOptions,
  });
};

export type GetGroupsQueryParams = {
  page?: number;
  per_page?: number;
  q?: string;
  managed?: boolean;
};

export type GetGroupsError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.GroupPagination;
}>;

export type GetGroupsVariables = {
  queryParams?: GetGroupsQueryParams;
} & ApiContext['fetcherOptions'];

export const fetchGetGroups = (variables: GetGroupsVariables, signal?: AbortSignal) =>
  apiFetch<undefined, GetGroupsError, undefined, {}, GetGroupsQueryParams, {}>({
    url: '/api/groups',
    method: 'get',
    ...variables,
    signal,
  });

export const useGetGroups = <TData = Schemas.GroupPagination>(
  variables: GetGroupsVariables,
  options?: Omit<reactQuery.UseQueryOptions<undefined, GetGroupsError, TData>, 'queryKey' | 'queryFn' | 'initialData'>,
) => {
  const {fetcherOptions, queryOptions, queryKeyFn} = useApiContext(options);
  return reactQuery.useQuery<undefined, GetGroupsError, TData>({
    queryKey: queryKeyFn({path: '/api/groups', operationId: 'getGroups', variables}),
    queryFn: ({signal}) => fetchGetGroups({...fetcherOptions, ...variables}, signal),
    ...options,
    ...queryOptions,
  });
};

export type CreateGroupError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.PolymorphicGroup;
}>;

export type CreateGroupVariables = {
  body?: RequestBodies.PolymorphicGroup;
} & ApiContext['fetcherOptions'];

export const fetchCreateGroup = (variables: CreateGroupVariables, signal?: AbortSignal) =>
  apiFetch<Schemas.PolymorphicGroup, CreateGroupError, RequestBodies.PolymorphicGroup, {}, {}, {}>({
    url: '/api/groups',
    method: 'post',
    ...variables,
    signal,
  });

export const useCreateGroup = (
  options?: Omit<
    reactQuery.UseMutationOptions<Schemas.PolymorphicGroup, CreateGroupError, CreateGroupVariables>,
    'mutationFn'
  >,
) => {
  const {fetcherOptions} = useApiContext();
  return reactQuery.useMutation<Schemas.PolymorphicGroup, CreateGroupError, CreateGroupVariables>(
    (variables: CreateGroupVariables) => fetchCreateGroup({...fetcherOptions, ...variables}),
    options,
  );
};

export type DeleteGroupByIdPathParams = {
  groupId: string;
};

export type DeleteGroupByIdError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.DeleteMessage;
}>;

export type DeleteGroupByIdVariables = {
  pathParams: DeleteGroupByIdPathParams;
} & ApiContext['fetcherOptions'];

export const fetchDeleteGroupById = (variables: DeleteGroupByIdVariables, signal?: AbortSignal) =>
  apiFetch<undefined, DeleteGroupByIdError, undefined, {}, {}, DeleteGroupByIdPathParams>({
    url: '/api/groups/{groupId}',
    method: 'delete',
    ...variables,
    signal,
  });

export const useDeleteGroupById = (
  options?: Omit<
    reactQuery.UseMutationOptions<undefined, DeleteGroupByIdError, DeleteGroupByIdVariables>,
    'mutationFn'
  >,
) => {
  const {fetcherOptions} = useApiContext();
  return reactQuery.useMutation<undefined, DeleteGroupByIdError, DeleteGroupByIdVariables>({
    mutationFn: (variables: DeleteGroupByIdVariables) => fetchDeleteGroupById({...fetcherOptions, ...variables}),
    ...options,
  });
};

export type GetGroupByIdPathParams = {
  groupId: string;
};

export type GetGroupByIdError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.PolymorphicGroup;
}>;

export type GetGroupByIdVariables = {
  pathParams: GetGroupByIdPathParams;
} & ApiContext['fetcherOptions'];

export const fetchGetGroupById = (variables: GetGroupByIdVariables, signal?: AbortSignal) =>
  apiFetch<undefined, GetGroupByIdError, undefined, {}, {}, GetGroupByIdPathParams>({
    url: '/api/groups/{groupId}',
    method: 'get',
    ...variables,
    signal,
  });

export const useGetGroupById = <TData = Schemas.PolymorphicGroup>(
  variables: GetGroupByIdVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<undefined, GetGroupByIdError, TData>,
    'queryKey' | 'queryFn' | 'initialData'
  >,
) => {
  const {fetcherOptions, queryOptions, queryKeyFn} = useApiContext(options);
  return reactQuery.useQuery<undefined, GetGroupByIdError, TData>({
    queryKey: queryKeyFn({path: '/api/groups/{groupId}', operationId: 'getGroupById', variables}),
    queryFn: ({signal}) => fetchGetGroupById({...fetcherOptions, ...variables}, signal),
    ...options,
    ...queryOptions,
  });
};

export type PutGroupByIdPathParams = {
  groupId: string;
};

export type PutGroupByIdError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.PolymorphicGroup;
}>;

export type PutGroupByIdVariables = {
  body?: RequestBodies.PolymorphicGroup;
  pathParams: PutGroupByIdPathParams;
} & ApiContext['fetcherOptions'];

export const fetchPutGroupById = (variables: PutGroupByIdVariables, signal?: AbortSignal) =>
  apiFetch<Schemas.PolymorphicGroup, PutGroupByIdError, RequestBodies.PolymorphicGroup, {}, {}, PutGroupByIdPathParams>(
    {url: '/api/groups/{groupId}', method: 'put', ...variables, signal},
  );

export const usePutGroupById = (
  options?: Omit<
    reactQuery.UseMutationOptions<Schemas.PolymorphicGroup, PutGroupByIdError, PutGroupByIdVariables>,
    'mutationFn'
  >,
) => {
  const {fetcherOptions} = useApiContext();
  return reactQuery.useMutation<Schemas.PolymorphicGroup, PutGroupByIdError, PutGroupByIdVariables>(
    (variables: PutGroupByIdVariables) => fetchPutGroupById({...fetcherOptions, ...variables}),
    options,
  );
};

export type GetGroupMembersByIdPathParams = {
  groupId: string;
};

export type GetGroupMembersByIdError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.GroupMember;
}>;

export type GetGroupMembersByIdVariables = {
  pathParams: GetGroupMembersByIdPathParams;
} & ApiContext['fetcherOptions'];

export const fetchGetGroupMembersById = (variables: GetGroupMembersByIdVariables, signal?: AbortSignal) =>
  apiFetch<undefined, GetGroupMembersByIdError, undefined, {}, {}, GetGroupMembersByIdPathParams>({
    url: '/api/groups/{groupId}/members',
    method: 'get',
    ...variables,
    signal,
  });

export const useGetGroupMembersById = <TData = Schemas.GroupMember>(
  variables: GetGroupMembersByIdVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<undefined, GetGroupMembersByIdError, TData>,
    'queryKey' | 'queryFn' | 'initialData'
  >,
) => {
  const {fetcherOptions, queryOptions, queryKeyFn} = useApiContext(options);
  return reactQuery.useQuery<undefined, GetGroupMembersByIdError, TData>({
    queryKey: queryKeyFn({path: '/api/groups/{groupId}/members', operationId: 'getGroupMembersById', variables}),
    queryFn: ({signal}) => fetchGetGroupMembersById({...fetcherOptions, ...variables}, signal),
    ...options,
    ...queryOptions,
  });
};

export type PutGroupMembersByIdPathParams = {
  groupId: string;
};

export type PutGroupMembersByIdError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.GroupMember;
}>;

export type PutGroupMembersByIdVariables = {
  body: Schemas.GroupMember;
  pathParams: PutGroupMembersByIdPathParams;
} & ApiContext['fetcherOptions'];

export const fetchPutGroupMembersById = (variables: PutGroupMembersByIdVariables, signal?: AbortSignal) =>
  apiFetch<Schemas.GroupMember, PutGroupMembersByIdError, Schemas.GroupMember, {}, {}, PutGroupMembersByIdPathParams>({
    url: '/api/groups/{groupId}/members',
    method: 'put',
    ...variables,
    signal,
  });

export const usePutGroupMembersById = (
  options?: Omit<
    reactQuery.UseMutationOptions<Schemas.GroupMember, PutGroupMembersByIdError, PutGroupMembersByIdVariables>,
    'mutationFn'
  >,
) => {
  const {fetcherOptions} = useApiContext();
  return reactQuery.useMutation<Schemas.GroupMember, PutGroupMembersByIdError, PutGroupMembersByIdVariables>(
    (variables: PutGroupMembersByIdVariables) => fetchPutGroupMembersById({...fetcherOptions, ...variables}),
    options,
  );
};

export type GetRequestsQueryParams = {
  page?: number;
  per_page?: number;
  q?: string;
  status?: 'PENDING' | 'APPROVED' | 'REJECTED';
  requester_user_id?: string;
  requested_group_id?: string;
  assignee_user_id?: string;
  resolver_user_id?: string;
};

export type GetRequestsError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.AccessRequestPagination;
}>;

export type GetRequestsVariables = {
  queryParams?: GetRequestsQueryParams;
} & ApiContext['fetcherOptions'];

export const fetchGetRequests = (variables: GetRequestsVariables, signal?: AbortSignal) =>
  apiFetch<undefined, GetRequestsError, undefined, {}, GetRequestsQueryParams, {}>({
    url: '/api/requests',
    method: 'get',
    ...variables,
    signal,
  });

export const useGetRequests = <TData = Schemas.AccessRequestPagination>(
  variables: GetRequestsVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<undefined, GetRequestsError, TData>,
    'queryKey' | 'queryFn' | 'initialData'
  >,
) => {
  const {fetcherOptions, queryOptions, queryKeyFn} = useApiContext(options);
  return reactQuery.useQuery<undefined, GetRequestsError, TData>({
    queryKey: queryKeyFn({path: '/api/requests', operationId: 'getRequests', variables}),
    queryFn: ({signal}) => fetchGetRequests({...fetcherOptions, ...variables}, signal),
    ...options,
    ...queryOptions,
  });
};

export type CreateRequestError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.AccessRequest;
}>;

export type CreateRequestVariables = {
  body: Schemas.CreateAccessRequest;
} & ApiContext['fetcherOptions'];

export const fetchCreateRequest = (variables: CreateRequestVariables, signal?: AbortSignal) =>
  apiFetch<Schemas.AccessRequest, CreateRequestError, Schemas.CreateAccessRequest, {}, {}, {}>({
    url: '/api/requests',
    method: 'post',
    ...variables,
    signal,
  });

export const useCreateRequest = (
  options?: Omit<
    reactQuery.UseMutationOptions<Schemas.AccessRequest, CreateRequestError, CreateRequestVariables>,
    'mutationFn'
  >,
) => {
  const {fetcherOptions} = useApiContext();
  return reactQuery.useMutation<Schemas.AccessRequest, CreateRequestError, CreateRequestVariables>(
    (variables: CreateRequestVariables) => fetchCreateRequest({...fetcherOptions, ...variables}),
    options,
  );
};

export type GetRequestByIdPathParams = {
  accessRequestId: string;
};

export type GetRequestByIdError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.AccessRequest;
}>;

export type GetRequestByIdVariables = {
  pathParams: GetRequestByIdPathParams;
} & ApiContext['fetcherOptions'];

export const fetchGetRequestById = (variables: GetRequestByIdVariables, signal?: AbortSignal) =>
  apiFetch<undefined, GetRequestByIdError, undefined, {}, {}, GetRequestByIdPathParams>({
    url: '/api/requests/{accessRequestId}',
    method: 'get',
    ...variables,
    signal,
  });

export const useGetRequestById = <TData = Schemas.AccessRequest>(
  variables: GetRequestByIdVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<undefined, GetRequestByIdError, TData>,
    'queryKey' | 'queryFn' | 'initialData'
  >,
) => {
  const {fetcherOptions, queryOptions, queryKeyFn} = useApiContext(options);
  return reactQuery.useQuery<undefined, GetRequestByIdError, TData>({
    queryKey: queryKeyFn({path: '/api/requests/{accessRequestId}', operationId: 'getRequestById', variables}),
    queryFn: ({signal}) => fetchGetRequestById({...fetcherOptions, ...variables}, signal),
    ...options,
    ...queryOptions,
  });
};

export type ResolveRequestByIdPathParams = {
  accessRequestId: string;
};

export type ResolveRequestByIdError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.AccessRequest;
}>;

export type ResolveRequestByIdVariables = {
  body: Schemas.ResolveAccessRequest;
  pathParams: ResolveRequestByIdPathParams;
} & ApiContext['fetcherOptions'];

export const fetchResolveRequestById = (variables: ResolveRequestByIdVariables, signal?: AbortSignal) =>
  apiFetch<
    Schemas.ResolveAccessRequest,
    ResolveRequestByIdError,
    Schemas.ResolveAccessRequest,
    {},
    {},
    ResolveRequestByIdPathParams
  >({
    url: '/api/requests/{accessRequestId}',
    method: 'put',
    ...variables,
    signal,
  });

export const useResolveRequestById = (
  options?: Omit<
    reactQuery.UseMutationOptions<Schemas.ResolveAccessRequest, ResolveRequestByIdError, ResolveRequestByIdVariables>,
    'mutationFn'
  >,
) => {
  const {fetcherOptions} = useApiContext();
  return reactQuery.useMutation<Schemas.ResolveAccessRequest, ResolveRequestByIdError, ResolveRequestByIdVariables>(
    (variables: ResolveRequestByIdVariables) => fetchResolveRequestById({...fetcherOptions, ...variables}),
    options,
  );
};

export type GetRoleRequestsQueryParams = {
  page?: number;
  per_page?: number;
  q?: string;
  status?: 'PENDING' | 'APPROVED' | 'REJECTED';
  requester_role_id?: string;
  requester_user_id?: string;
  requested_group_id?: string;
  assignee_user_id?: string;
  resolver_user_id?: string;
};

export type GetRoleRequestsError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.RoleRequestPagination;
}>;

export type GetRoleRequestsVariables = {
  queryParams?: GetRoleRequestsQueryParams;
} & ApiContext['fetcherOptions'];

export const fetchGetRoleRequests = (variables: GetRoleRequestsVariables, signal?: AbortSignal) =>
  apiFetch<undefined, GetRoleRequestsError, undefined, {}, GetRoleRequestsQueryParams, {}>({
    url: '/api/role-requests',
    method: 'get',
    ...variables,
    signal,
  });

export const useGetRoleRequests = <TData = Schemas.RoleRequestPagination>(
  variables: GetRoleRequestsVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<undefined, GetRoleRequestsError, TData>,
    'queryKey' | 'queryFn' | 'initialData'
  >,
) => {
  const {fetcherOptions, queryOptions, queryKeyFn} = useApiContext(options);
  return reactQuery.useQuery<undefined, GetRoleRequestsError, TData>({
    queryKey: queryKeyFn({path: '/api/role-requests', operationId: 'getRoleRequests', variables}),
    queryFn: ({signal}) => fetchGetRoleRequests({...fetcherOptions, ...variables}, signal),
    ...options,
    ...queryOptions,
  });
};

export type CreateRoleRequestError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.RoleRequest;
}>;

export type CreateRoleRequestVariables = {
  body: Schemas.CreateRoleRequest;
} & ApiContext['fetcherOptions'];

export const fetchCreateRoleRequest = (variables: CreateRoleRequestVariables, signal?: AbortSignal) =>
  apiFetch<Schemas.RoleRequest, CreateRoleRequestError, Schemas.CreateRoleRequest, {}, {}, {}>({
    url: '/api/role-requests',
    method: 'post',
    ...variables,
    signal,
  });

export const useCreateRoleRequest = (
  options?: Omit<
    reactQuery.UseMutationOptions<Schemas.RoleRequest, CreateRoleRequestError, CreateRoleRequestVariables>,
    'mutationFn'
  >,
) => {
  const {fetcherOptions} = useApiContext();
  return reactQuery.useMutation<Schemas.RoleRequest, CreateRoleRequestError, CreateRoleRequestVariables>(
    (variables: CreateRoleRequestVariables) => fetchCreateRoleRequest({...fetcherOptions, ...variables}),
    options,
  );
};

export type GetRoleRequestByIdPathParams = {
  roleRequestId: string;
};

export type GetRoleRequestByIdError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.AccessRequest;
}>;

export type GetRoleRequestByIdVariables = {
  pathParams: GetRoleRequestByIdPathParams;
} & ApiContext['fetcherOptions'];

export const fetchGetRoleRequestById = (variables: GetRoleRequestByIdVariables, signal?: AbortSignal) =>
  apiFetch<undefined, GetRoleRequestByIdError, undefined, {}, {}, GetRoleRequestByIdPathParams>({
    url: '/api/role-requests/{roleRequestId}',
    method: 'get',
    ...variables,
    signal,
  });

export const useGetRoleRequestById = <TData = Schemas.RoleRequest>(
  variables: GetRoleRequestByIdVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<undefined, GetRoleRequestByIdError, TData>,
    'queryKey' | 'queryFn' | 'initialData'
  >,
) => {
  const {fetcherOptions, queryOptions, queryKeyFn} = useApiContext(options);
  return reactQuery.useQuery<undefined, GetRoleRequestByIdError, TData>({
    queryKey: queryKeyFn({path: '/api/role-requests/{roleRequestId}', operationId: 'getRoleRequestById', variables}),
    queryFn: ({signal}) => fetchGetRoleRequestById({...fetcherOptions, ...variables}, signal),
    ...options,
    ...queryOptions,
  });
};

export type ResolveRoleRequestByIdPathParams = {
  roleRequestId: string;
};

export type ResolveRoleRequestByIdError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.RoleRequest;
}>;

export type ResolveRoleRequestByIdVariables = {
  body: Schemas.ResolveRoleRequest;
  pathParams: ResolveRoleRequestByIdPathParams;
} & ApiContext['fetcherOptions'];

export const fetchResolveRoleRequestById = (variables: ResolveRoleRequestByIdVariables, signal?: AbortSignal) =>
  apiFetch<
    Schemas.ResolveRoleRequest,
    ResolveRoleRequestByIdError,
    Schemas.ResolveRoleRequest,
    {},
    {},
    ResolveRoleRequestByIdPathParams
  >({
    url: '/api/role-requests/{roleRequestId}',
    method: 'put',
    ...variables,
    signal,
  });

export const useResolveRoleRequestById = (
  options?: Omit<
    reactQuery.UseMutationOptions<
      Schemas.ResolveRoleRequest,
      ResolveRoleRequestByIdError,
      ResolveRoleRequestByIdVariables
    >,
    'mutationFn'
  >,
) => {
  const {fetcherOptions} = useApiContext();
  return reactQuery.useMutation<
    Schemas.ResolveRoleRequest,
    ResolveRoleRequestByIdError,
    ResolveRoleRequestByIdVariables
  >(
    (variables: ResolveRoleRequestByIdVariables) => fetchResolveRoleRequestById({...fetcherOptions, ...variables}),
    options,
  );
};

export type GetRolesQueryParams = {
  page?: number;
  per_page?: number;
  q?: string;
  owner_id?: string;
};

export type GetRolesError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.RolePagination;
}>;

export type GetRolesVariables = {
  queryParams?: GetRolesQueryParams;
} & ApiContext['fetcherOptions'];

export const fetchGetRoles = (variables: GetRolesVariables, signal?: AbortSignal) =>
  apiFetch<undefined, GetRolesError, undefined, {}, GetRolesQueryParams, {}>({
    url: '/api/roles',
    method: 'get',
    ...variables,
    signal,
  });

export const useGetRoles = <TData = Schemas.RolePagination>(
  variables: GetRolesVariables,
  options?: Omit<reactQuery.UseQueryOptions<undefined, GetRolesError, TData>, 'queryKey' | 'queryFn' | 'initialData'>,
) => {
  const {fetcherOptions, queryOptions, queryKeyFn} = useApiContext(options);
  return reactQuery.useQuery<undefined, GetRolesError, TData>({
    queryKey: queryKeyFn({path: '/api/roles', operationId: 'getRoles', variables}),
    queryFn: ({signal}) => fetchGetRoles({...fetcherOptions, ...variables}, signal),
    ...options,
    ...queryOptions,
  });
};

export type GetRoleByIdPathParams = {
  roleId: string;
};

export type GetRoleByIdError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.RoleGroup;
}>;

export type GetRoleByIdVariables = {
  pathParams: GetRoleByIdPathParams;
} & ApiContext['fetcherOptions'];

export const fetchGetRoleById = (variables: GetRoleByIdVariables, signal?: AbortSignal) =>
  apiFetch<undefined, GetRoleByIdError, undefined, {}, {}, GetRoleByIdPathParams>({
    url: '/api/roles/{roleId}',
    method: 'get',
    ...variables,
    signal,
  });

export const useGetRoleById = <TData = Schemas.RoleGroup>(
  variables: GetRoleByIdVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<undefined, GetRoleByIdError, TData>,
    'queryKey' | 'queryFn' | 'initialData'
  >,
) => {
  const {fetcherOptions, queryOptions, queryKeyFn} = useApiContext(options);
  return reactQuery.useQuery<undefined, GetRoleByIdError, TData>({
    queryKey: queryKeyFn({path: '/api/roles/{roleId}', operationId: 'getRoleById', variables}),
    queryFn: ({signal}) => fetchGetRoleById({...fetcherOptions, ...variables}, signal),
    ...options,
    ...queryOptions,
  });
};

export type GetRoleMembersByIdPathParams = {
  roleId: string;
};

export type GetRoleMembersByIdError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.RoleMember;
}>;

export type GetRoleMembersByIdVariables = {
  pathParams: GetRoleMembersByIdPathParams;
} & ApiContext['fetcherOptions'];

export const fetchGetRoleMembersById = (variables: GetRoleMembersByIdVariables, signal?: AbortSignal) =>
  apiFetch<undefined, GetRoleMembersByIdError, undefined, {}, {}, GetRoleMembersByIdPathParams>({
    url: '/api/roles/{roleId}/members',
    method: 'get',
    ...variables,
    signal,
  });

export const useGetRoleMembersById = <TData = Schemas.RoleMember>(
  variables: GetRoleMembersByIdVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<undefined, GetRoleMembersByIdError, TData>,
    'queryKey' | 'queryFn' | 'initialData'
  >,
) => {
  const {fetcherOptions, queryOptions, queryKeyFn} = useApiContext(options);
  return reactQuery.useQuery<undefined, GetRoleMembersByIdError, TData>({
    queryKey: queryKeyFn({path: '/api/roles/{roleId}/members', operationId: 'getRoleMembersById', variables}),
    queryFn: ({signal}) => fetchGetRoleMembersById({...fetcherOptions, ...variables}, signal),
    ...options,
    ...queryOptions,
  });
};

export type PutRoleMembersByIdPathParams = {
  roleId: string;
};

export type PutRoleMembersByIdError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.RoleMember;
}>;

export type PutRoleMembersByIdVariables = {
  body: Schemas.RoleMember;
  pathParams: PutRoleMembersByIdPathParams;
} & ApiContext['fetcherOptions'];

export const fetchPutRoleMembersById = (variables: PutRoleMembersByIdVariables, signal?: AbortSignal) =>
  apiFetch<Schemas.RoleMember, PutRoleMembersByIdError, Schemas.RoleMember, {}, {}, PutRoleMembersByIdPathParams>({
    url: '/api/roles/{roleId}/members',
    method: 'put',
    ...variables,
    signal,
  });

export const usePutRoleMembersById = (
  options?: Omit<
    reactQuery.UseMutationOptions<Schemas.RoleMember, PutRoleMembersByIdError, PutRoleMembersByIdVariables>,
    'mutationFn'
  >,
) => {
  const {fetcherOptions} = useApiContext();
  return reactQuery.useMutation<Schemas.RoleMember, PutRoleMembersByIdError, PutRoleMembersByIdVariables>(
    (variables: PutRoleMembersByIdVariables) => fetchPutRoleMembersById({...fetcherOptions, ...variables}),
    options,
  );
};

export type GetTagsQueryParams = {
  page?: number;
  per_page?: number;
  q?: string;
};

export type GetTagsError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.TagPagination;
}>;

export type GetTagsVariables = {
  queryParams?: GetTagsQueryParams;
} & ApiContext['fetcherOptions'];

export const fetchGetTags = (variables: GetTagsVariables, signal?: AbortSignal) =>
  apiFetch<undefined, GetTagsError, undefined, {}, GetTagsQueryParams, {}>({
    url: '/api/tags',
    method: 'get',
    ...variables,
    signal,
  });

export const useGetTags = <TData = Schemas.TagPagination>(
  variables: GetTagsVariables,
  options?: Omit<reactQuery.UseQueryOptions<undefined, GetTagsError, TData>, 'queryKey' | 'queryFn' | 'initialData'>,
) => {
  const {fetcherOptions, queryOptions, queryKeyFn} = useApiContext(options);
  return reactQuery.useQuery<undefined, GetTagsError, TData>({
    queryKey: queryKeyFn({path: '/api/tags', operationId: 'getTags', variables}),
    queryFn: ({signal}) => fetchGetTags({...fetcherOptions, ...variables}, signal),
    ...options,
    ...queryOptions,
  });
};

export type CreateTagError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.Tag;
}>;

export type CreateTagVariables = {
  body: RequestBodies.Tag;
} & ApiContext['fetcherOptions'];

export const fetchCreateTag = (variables: CreateTagVariables, signal?: AbortSignal) =>
  apiFetch<Schemas.Tag, CreateTagError, RequestBodies.Tag, {}, {}, {}>({
    url: '/api/tags',
    method: 'post',
    ...variables,
    signal,
  });

export const useCreateTag = (
  options?: Omit<reactQuery.UseMutationOptions<Schemas.Tag, CreateTagError, CreateTagVariables>, 'mutationFn'>,
) => {
  const {fetcherOptions} = useApiContext();
  return reactQuery.useMutation<Schemas.Tag, CreateTagError, CreateTagVariables>(
    (variables: CreateTagVariables) => fetchCreateTag({...fetcherOptions, ...variables}),
    options,
  );
};

export type DeleteTagByIdPathParams = {
  tagId: string;
};

export type DeleteTagByIdError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.DeleteMessage;
}>;

export type DeleteTagByIdVariables = {
  pathParams: DeleteTagByIdPathParams;
} & ApiContext['fetcherOptions'];

export const fetchDeleteTagById = (variables: DeleteTagByIdVariables, signal?: AbortSignal) =>
  apiFetch<undefined, DeleteTagByIdError, undefined, {}, {}, DeleteTagByIdPathParams>({
    url: '/api/tags/{tagId}',
    method: 'delete',
    ...variables,
    signal,
  });

export const useDeleteTagById = (
  options?: Omit<reactQuery.UseMutationOptions<undefined, DeleteTagByIdError, DeleteTagByIdVariables>, 'mutationFn'>,
) => {
  const {fetcherOptions} = useApiContext();
  return reactQuery.useMutation<undefined, DeleteTagByIdError, DeleteTagByIdVariables>({
    mutationFn: (variables: DeleteTagByIdVariables) => fetchDeleteTagById({...fetcherOptions, ...variables}),
    ...options,
  });
};

export type GetTagByIdPathParams = {
  tagId: string;
};

export type GetTagByIdError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.Tag;
}>;

export type GetTagByIdVariables = {
  pathParams: GetTagByIdPathParams;
} & ApiContext['fetcherOptions'];

export const fetchGetTagById = (variables: GetTagByIdVariables, signal?: AbortSignal) =>
  apiFetch<undefined, GetTagByIdError, undefined, {}, {}, GetTagByIdPathParams>({
    url: '/api/tags/{tagId}',
    method: 'get',
    ...variables,
    signal,
  });

export const useGetTagById = <TData = undefined>(
  variables: GetTagByIdVariables,
  options?: Omit<reactQuery.UseQueryOptions<undefined, GetTagByIdError, TData>, 'queryKey' | 'queryFn' | 'initialData'>,
) => {
  const {fetcherOptions, queryOptions, queryKeyFn} = useApiContext(options);
  return reactQuery.useQuery<undefined, GetTagByIdError, TData>({
    queryKey: queryKeyFn({path: '/api/tags/{tagId}', operationId: 'getTagById', variables}),
    queryFn: ({signal}) => fetchGetTagById({...fetcherOptions, ...variables}, signal),
    ...options,
    ...queryOptions,
  });
};

export type PutTagByIdPathParams = {
  tagId: string;
};

export type PutTagByIdError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.Tag;
}>;

export type PutTagByIdVariables = {
  body: RequestBodies.Tag;
  pathParams: PutTagByIdPathParams;
} & ApiContext['fetcherOptions'];

export const fetchPutTagById = (variables: PutTagByIdVariables, signal?: AbortSignal) =>
  apiFetch<Schemas.Tag, PutTagByIdError, RequestBodies.Tag, {}, {}, PutTagByIdPathParams>({
    url: '/api/tags/{tagId}',
    method: 'put',
    ...variables,
    signal,
  });

export const usePutTagById = (
  options?: Omit<reactQuery.UseMutationOptions<Schemas.Tag, PutTagByIdError, PutTagByIdVariables>, 'mutationFn'>,
) => {
  const {fetcherOptions} = useApiContext();
  return reactQuery.useMutation<Schemas.Tag, PutTagByIdError, PutTagByIdVariables>(
    (variables: PutTagByIdVariables) => fetchPutTagById({...fetcherOptions, ...variables}),
    options,
  );
};

export type GetUsersQueryParams = {
  page?: number;
  per_page?: number;
  q?: string;
};

export type GetUsersError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.UserPagination;
}>;

export type GetUsersVariables = {
  queryParams?: GetUsersQueryParams;
} & ApiContext['fetcherOptions'];

export const fetchGetUsers = (variables: GetUsersVariables, signal?: AbortSignal) =>
  apiFetch<undefined, GetUsersError, undefined, {}, GetUsersQueryParams, {}>({
    url: '/api/users',
    method: 'get',
    ...variables,
    signal,
  });

export const useGetUsers = <TData = Schemas.UserPagination>(
  variables: GetUsersVariables,
  options?: Omit<reactQuery.UseQueryOptions<undefined, GetUsersError, TData>, 'queryKey' | 'queryFn' | 'initialData'>,
) => {
  const {fetcherOptions, queryOptions, queryKeyFn} = useApiContext(options);
  return reactQuery.useQuery<undefined, GetUsersError, TData>({
    queryKey: queryKeyFn({path: '/api/users', operationId: 'getUsers', variables}),
    queryFn: ({signal}) => fetchGetUsers({...fetcherOptions, ...variables}, signal),
    ...options,
    ...queryOptions,
  });
};

export type GetUserByIdPathParams = {
  userId: string;
};

export type GetUserByIdError = Fetcher.ErrorWrapper<{
  status: ClientErrorStatus | ServerErrorStatus;
  payload: Schemas.OktaUser;
}>;

export type GetUserByIdVariables = {
  pathParams: GetUserByIdPathParams;
} & ApiContext['fetcherOptions'];

export const fetchGetUserById = (variables: GetUserByIdVariables, signal?: AbortSignal) =>
  apiFetch<undefined, GetUserByIdError, undefined, {}, {}, GetUserByIdPathParams>({
    url: '/api/users/{userId}',
    method: 'get',
    ...variables,
    signal,
  });

export const useGetUserById = <TData = Schemas.OktaUser>(
  variables: GetUserByIdVariables,
  options?: Omit<
    reactQuery.UseQueryOptions<undefined, GetUserByIdError, TData>,
    'queryKey' | 'queryFn' | 'initialData'
  >,
) => {
  const {fetcherOptions, queryOptions, queryKeyFn} = useApiContext(options);
  return reactQuery.useQuery<undefined, GetUserByIdError, TData>({
    queryKey: queryKeyFn({path: '/api/users/{userId}', operationId: 'getUserById', variables}),
    queryFn: ({signal}) => fetchGetUserById({...fetcherOptions, ...variables}, signal),
    ...options,
    ...queryOptions,
  });
};

export type QueryOperation =
  | {
      path: '/api/apps';
      operationId: 'getApps';
      variables: GetAppsVariables;
    }
  | {
      path: '/api/apps/{appId}';
      operationId: 'getAppById';
      variables: GetAppByIdVariables;
    }
  | {
      path: '/api/audit/groups';
      operationId: 'getGroupRoleAudits';
      variables: GetGroupRoleAuditsVariables;
    }
  | {
      path: '/api/audit/users';
      operationId: 'getUserGroupAudits';
      variables: GetUserGroupAuditsVariables;
    }
  | {
      path: '/api/groups';
      operationId: 'getGroups';
      variables: GetGroupsVariables;
    }
  | {
      path: '/api/groups/{groupId}';
      operationId: 'getGroupById';
      variables: GetGroupByIdVariables;
    }
  | {
      path: '/api/groups/{groupId}/members';
      operationId: 'getGroupMembersById';
      variables: GetGroupMembersByIdVariables;
    }
  | {
      path: '/api/requests';
      operationId: 'getRequests';
      variables: GetRequestsVariables;
    }
  | {
      path: '/api/requests/{accessRequestId}';
      operationId: 'getRequestById';
      variables: GetRequestByIdVariables;
    }
  | {
      path: '/api/role-requests';
      operationId: 'getRoleRequests';
      variables: GetRoleRequestsVariables;
    }
  | {
      path: '/api/role-requests/{roleRequestId}';
      operationId: 'getRoleRequestById';
      variables: GetRoleRequestByIdVariables;
    }
  | {
      path: '/api/roles';
      operationId: 'getRoles';
      variables: GetRolesVariables;
    }
  | {
      path: '/api/roles/{roleId}';
      operationId: 'getRoleById';
      variables: GetRoleByIdVariables;
    }
  | {
      path: '/api/roles/{roleId}/members';
      operationId: 'getRoleMembersById';
      variables: GetRoleMembersByIdVariables;
    }
  | {
      path: '/api/tags';
      operationId: 'getTags';
      variables: GetTagsVariables;
    }
  | {
      path: '/api/tags/{tagId}';
      operationId: 'getTagById';
      variables: GetTagByIdVariables;
    }
  | {
      path: '/api/users';
      operationId: 'getUsers';
      variables: GetUsersVariables;
    }
  | {
      path: '/api/users/{userId}';
      operationId: 'getUserById';
      variables: GetUserByIdVariables;
    };
