"""Role requests

Revision ID: 6d2a03b326f9
Revises: d6db40b0805d
Create Date: 2024-11-01 15:57:24.776719

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "6d2a03b326f9"
down_revision = "d6db40b0805d"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "role_request",
        sa.Column("id", sa.Unicode(length=20), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("updated_at", sa.DateTime(), nullable=False),
        sa.Column("resolved_at", sa.DateTime(), nullable=True),
        sa.Column("status", sa.Enum("PENDING", "APPROVED", "REJECTED", name="accessrequeststatus"), nullable=False),
        sa.Column("requester_user_id", sa.Unicode(length=50), nullable=False),
        sa.Column("requester_role_id", sa.Unicode(length=50), nullable=False),
        sa.Column("requested_group_id", sa.Unicode(length=50), nullable=False),
        sa.Column("request_ownership", sa.Boolean(), nullable=False),
        sa.Column("request_reason", sa.Unicode(length=1024), nullable=False),
        sa.Column("request_ending_at", sa.DateTime(), nullable=True),
        sa.Column("resolver_user_id", sa.Unicode(length=50), nullable=True),
        sa.Column("resolution_reason", sa.Unicode(length=1024), nullable=False),
        sa.Column("approval_ending_at", sa.DateTime(), nullable=True),
        sa.Column("approved_membership_id", sa.BigInteger().with_variant(sa.Integer(), "sqlite"), nullable=True),
        sa.ForeignKeyConstraint(
            ["approved_membership_id"],
            ["role_group_map.id"],
            name=op.f("fk_role_request_approved_membership_id_role_group_map"),
        ),
        sa.ForeignKeyConstraint(
            ["requested_group_id"], ["okta_group.id"], name=op.f("fk_role_request_requested_group_id_okta_group")
        ),
        sa.ForeignKeyConstraint(
            ["requester_role_id"], ["okta_group.id"], name=op.f("fk_role_request_requester_role_id_okta_group")
        ),
        sa.ForeignKeyConstraint(
            ["requester_user_id"], ["okta_user.id"], name=op.f("fk_role_request_requester_user_id_okta_user")
        ),
        sa.ForeignKeyConstraint(
            ["resolver_user_id"], ["okta_user.id"], name=op.f("fk_role_request_resolver_user_id_okta_user")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_role_request")),
    )
    with op.batch_alter_table("access_request", schema=None) as batch_op:
        batch_op.alter_column("requester_user_id", existing_type=sa.VARCHAR(), nullable=False)
        batch_op.alter_column("requested_group_id", existing_type=sa.VARCHAR(), nullable=False)

    with op.batch_alter_table("app_tag_map", schema=None) as batch_op:
        batch_op.alter_column("tag_id", existing_type=sa.VARCHAR(), nullable=False)
        batch_op.alter_column("app_id", existing_type=sa.VARCHAR(), nullable=False)

    with op.batch_alter_table("okta_group_tag_map", schema=None) as batch_op:
        batch_op.alter_column("tag_id", existing_type=sa.VARCHAR(), nullable=False)
        batch_op.alter_column("group_id", existing_type=sa.VARCHAR(), nullable=False)

    with op.batch_alter_table("okta_user_group_member", schema=None) as batch_op:
        batch_op.alter_column("user_id", existing_type=sa.VARCHAR(), nullable=False)
        batch_op.alter_column("group_id", existing_type=sa.VARCHAR(), nullable=False)

    with op.batch_alter_table("role_group_map", schema=None) as batch_op:
        batch_op.alter_column("role_id", existing_type=sa.VARCHAR(), nullable=False)
        batch_op.alter_column("group_id", existing_type=sa.VARCHAR(), nullable=False)

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("role_group_map", schema=None) as batch_op:
        batch_op.alter_column("group_id", existing_type=sa.VARCHAR(), nullable=True)
        batch_op.alter_column("role_id", existing_type=sa.VARCHAR(), nullable=True)

    with op.batch_alter_table("okta_user_group_member", schema=None) as batch_op:
        batch_op.alter_column("group_id", existing_type=sa.VARCHAR(), nullable=True)
        batch_op.alter_column("user_id", existing_type=sa.VARCHAR(), nullable=True)

    with op.batch_alter_table("okta_group_tag_map", schema=None) as batch_op:
        batch_op.alter_column("group_id", existing_type=sa.VARCHAR(), nullable=True)
        batch_op.alter_column("tag_id", existing_type=sa.VARCHAR(), nullable=True)

    with op.batch_alter_table("app_tag_map", schema=None) as batch_op:
        batch_op.alter_column("app_id", existing_type=sa.VARCHAR(), nullable=True)
        batch_op.alter_column("tag_id", existing_type=sa.VARCHAR(), nullable=True)

    with op.batch_alter_table("access_request", schema=None) as batch_op:
        batch_op.alter_column("requested_group_id", existing_type=sa.VARCHAR(), nullable=True)
        batch_op.alter_column("requester_user_id", existing_type=sa.VARCHAR(), nullable=True)

    op.drop_table("role_request")
    # ### end Alembic commands ###
