/**
 * Generated by @openapi-codegen
 *
 * @version 1.0.0
 */
export type AccessRequest = {
  active_requested_group?: PolymorphicGroup;
  active_requester?: OktaUser;
  active_resolver?: OktaUser;
  /**
   * @format date-time
   */
  approval_ending_at?: string | null;
  approved_membership?: OktaUserGroupMember;
  /**
   * @format date-time
   */
  created_at?: string;
  /**
   * @maxLength 20
   */
  id: string;
  request_ownership?: boolean;
  /**
   * @maxLength 1024
   */
  request_reason?: string;
  /**
   * @format date-time
   */
  request_ending_at?: string | null;
  requested_group?: PolymorphicGroup;
  requester?: OktaUser;
  /**
   * @maxLength 1024
   */
  resolution_reason?: string;
  /**
   * @format date-time
   */
  resolved_at?: string | null;
  resolver?: OktaUser;
  /**
   * @maxLength 8
   */
  status?: 'PENDING' | 'APPROVED' | 'REJECTED';
  /**
   * @format date-time
   */
  updated_at?: string;
};

export type AccessRequestPagination = {
  /**
   * @format url
   */
  next?: string;
  pages?: number;
  /**
   * @format url
   */
  prev?: string;
  results?: AccessRequest[];
  total?: number;
};

export type App = {
  active_app_groups?: AppGroup[];
  active_app_tags?: AppTagMap[];
  active_owner_app_groups?: AppGroup[];
  active_non_owner_app_groups?: AppGroup[];
  all_app_tags?: AppTagMap[];
  app_groups?: AppGroup[];
  /**
   * @format date-time
   */
  created_at?: string;
  /**
   * @format date-time
   */
  deleted_at?: string | null;
  /**
   * @maxLength 1024
   */
  description?: string;
  /**
   * @maxLength 20
   */
  id?: string;
  initial_additional_app_groups?: InitialAppGroup[];
  /**
   * @maxLength 255
   * @minLength 1
   */
  initial_owner_id?: string;
  is_managed?: boolean;
  /**
   * @maxLength 255
   */
  name: string;
  tags_to_add?: string[];
  tags_to_remove?: string[];
  /**
   * @format date-time
   */
  updated_at?: string;
};

export type AppGroup = OktaGroup & {
  app?: App;
  /**
   * @maxLength 20
   * @minLength 20
   */
  app_id: string;
  is_owner?: boolean;
  /**
   * @maxLength 50
   */
  type: string;
  id?: string;
  /**
   * @maxLength 255
   */
  name: string;
  /**
   * @maxLength 1024
   */
  description?: string;
  tags_to_add?: string[];
  tags_to_remove?: string[];
};

export type AppPagination = {
  /**
   * @format url
   */
  next?: string;
  pages?: number;
  /**
   * @format url
   */
  prev?: string;
  results?: App[];
  total?: number;
};

export type AppTagMap = {
  active_app?: App;
  active_tag?: Tag;
  app?: App;
  /**
   * @format date-time
   */
  created_at?: string;
  /**
   * @format date-time
   */
  ended_at?: string | null;
  tag?: Tag;
};

export type CreateAccessRequest = {
  /**
   * @format date-time
   */
  ending_at?: string;
  /**
   * @maxLength 20
   * @minLength 20
   */
  group_id: string;
  /**
   * @default false
   */
  group_owner?: boolean;
  reason?: string;
};

export type CreateRoleRequest = {
  /**
   * @format date-time
   */
  ending_at?: string;
  /**
   * @maxLength 20
   * @minLength 20
   */
  role_id: string;
  /**
   * @maxLength 20
   * @minLength 20
   */
  group_id: string;
  /**
   * @default false
   */
  group_owner?: boolean;
  reason?: string;
};

export type DeleteMessage = {
  deleted?: boolean;
};

export type GroupMember = {
  members?: void[];
  members_to_add: string[];
  members_to_remove: string[];
  owners?: void[];
  owners_to_add: string[];
  owners_to_remove: string[];
  /**
   * @format date-time
   */
  users_added_ending_at?: string;
  created_reason?: string;
};

export type GroupPagination = {
  /**
   * @format url
   */
  next?: string;
  pages?: number;
  /**
   * @format url
   */
  prev?: string;
  results?: PolymorphicGroup[];
  total?: number;
};

export type OktaGroup = {
  active_group_tags?: OktaGroupTagMap[];
  active_non_role_user_memberships?: OktaUserGroupMember[];
  active_non_role_user_ownerships?: OktaUserGroupMember[];
  active_role_mappings?: RoleGroupMap[];
  active_role_member_mappings?: RoleGroupMap[];
  active_role_owner_mappings?: RoleGroupMap[];
  active_user_memberships?: OktaUserGroupMember[];
  active_user_memberships_and_ownerships?: OktaUserGroupMember[];
  active_user_ownerships?: OktaUserGroupMember[];
  all_group_tags?: OktaGroupTagMap[];
  all_role_mappings?: RoleGroupMap[];
  all_user_memberships_and_ownerships?: OktaUserGroupMember[];
  /**
   * @maxLength 50
   */
  type: string;
  id?: string;
  is_managed?: boolean;
  externally_managed_data?: Record<string, string>;
  /**
   * @maxLength 255
   */
  name: string;
  /**
   * @maxLength 1024
   */
  description?: string;
  tags_to_add?: string[];
  tags_to_remove?: string[];
  /**
   * @format date-time
   */
  created_at?: string;
  /**
   * @format date-time
   */
  updated_at?: string;
  /**
   * @format date-time
   */
  deleted_at?: string | null;
};

export type InitialAppGroup = {
  /**
   * @default
   * @maxLength 1024
   */
  description?: string;
  name: string;
};

export type OktaGroupTagMap = {
  active_app_tag_mapping?: AppTagMap;
  active_group?: PolymorphicGroup;
  active_tag?: Tag;
  app_tag_mapping?: AppTagMap;
  /**
   * @format date-time
   */
  created_at?: string;
  /**
   * @format date-time
   */
  ended_at?: string | null;
  group?: PolymorphicGroup;
  tag?: Tag;
};

export type OktaUser = {
  active_group_memberships?: OktaUserGroupMember[];
  active_group_memberships_and_ownerships?: OktaUserGroupMember[];
  active_group_ownerships?: OktaUserGroupMember[];
  all_group_memberships_and_ownerships?: OktaUserGroupMember[];
  /**
   * @format date-time
   */
  created_at?: string;
  /**
   * @format date-time
   */
  updated_at?: string;
  /**
   * @format date-time
   */
  deleted_at?: string | null;
  /**
   * @maxLength 100
   */
  display_name?: string | null;
  /**
   * @maxLength 100
   */
  email: string;
  /**
   * @maxLength 50
   */
  first_name: string;
  /**
   * @maxLength 50
   */
  id: string;
  /**
   * @maxLength 50
   */
  last_name: string;
  profile?: Record<string, any>;
  manager?: OktaUser;
};

export type OktaUserGroupMember = {
  role_group_mapping?: RoleGroupMap;
  active_role_group_mapping?: RoleGroupMap;
  user: OktaUser;
  active_user?: OktaUser;
  group: OktaGroup;
  active_group?: OktaGroup;
  access_request?: AccessRequest;
  created_actor?: OktaUser;
  /**
   * @format date-time
   */
  created_at?: string;
  ended_actor?: OktaUser;
  /**
   * @format date-time
   */
  ended_at?: string | null;
  created_reason?: string;
  is_owner: boolean;
  id: number;
};

export type PolymorphicGroup = OktaGroup | AppGroup | RoleGroup;

export type ResolveAccessRequest = {
  approved: boolean;
  /**
   * @format date-time
   */
  ending_at?: string;
  reason?: string;
};

export type ResolveRoleRequest = {
  approved: boolean;
  /**
   * @format date-time
   */
  ending_at?: string;
  reason?: string;
};

export type GroupRoleAuditPagination = {
  /**
   * @format url
   */
  next?: string;
  pages?: number;
  /**
   * @format url
   */
  prev?: string;
  results?: RoleGroupMap[];
  total?: number;
};

export type RoleGroup = OktaGroup & {
  active_role_associated_group_mappings?: RoleGroupMap[];
  active_role_associated_group_member_mappings?: RoleGroupMap[];
  active_role_associated_group_owner_mappings?: RoleGroupMap[];
  all_role_associated_group_mappings?: RoleGroupMap[];
  /**
   * @maxLength 50
   */
  type: string;
  id?: string;
  is_managed?: boolean;
  /**
   * @maxLength 255
   */
  name: string;
  /**
   * @maxLength 1024
   */
  description?: string;
  tags_to_add?: string[];
  tags_to_remove?: string[];
};

export type RoleGroupMap = {
  /**
   * @format date-time
   */
  created_at?: string;
  /**
   * @format date-time
   */
  ended_at?: string | null;
  is_owner?: boolean;
  active_role_group?: RoleGroup;
  active_group?: OktaGroup;
  active_group_memberships_and_ownerships?: OktaUserGroupMember[];
  role_group?: RoleGroup;
  group?: OktaGroup;
  all_group_memberships_and_ownerships?: OktaUserGroupMember[];
  created_actor?: OktaUser;
  ended_actor?: OktaUser;
  created_reason?: string;
  id?: number;
};

export type RoleMember = {
  /**
   * @format date-time
   */
  groups_added_ending_at?: string;
  groups_in_role?: void[];
  groups_owned_by_role?: void[];
  groups_to_add: string[];
  groups_to_remove: string[];
  owner_groups_to_add: string[];
  owner_groups_to_remove: string[];
  created_reason?: string;
};

export type RolePagination = {
  /**
   * @format url
   */
  next?: string;
  pages?: number;
  /**
   * @format url
   */
  prev?: string;
  results?: RoleGroup[];
  total?: number;
};

export type RoleRequest = {
  active_requester_role?: RoleGroup;
  active_requested_group?: PolymorphicGroup;
  active_requester?: OktaUser;
  active_resolver?: OktaUser;
  /**
   * @format date-time
   */
  approval_ending_at?: string | null;
  approved_membership?: OktaUserGroupMember;
  /**
   * @format date-time
   */
  created_at?: string;
  /**
   * @maxLength 20
   */
  id: string;
  request_ownership?: boolean;
  /**
   * @maxLength 1024
   */
  request_reason?: string;
  /**
   * @format date-time
   */
  request_ending_at?: string | null;
  requester_role?: RoleGroup;
  requested_group?: PolymorphicGroup;
  requester?: OktaUser;
  /**
   * @maxLength 1024
   */
  resolution_reason?: string;
  /**
   * @format date-time
   */
  resolved_at?: string | null;
  resolver?: OktaUser;
  /**
   * @maxLength 8
   */
  status?: 'PENDING' | 'APPROVED' | 'REJECTED';
  /**
   * @format date-time
   */
  updated_at?: string;
};

export type RoleRequestPagination = {
  /**
   * @format url
   */
  next?: string;
  pages?: number;
  /**
   * @format url
   */
  prev?: string;
  results?: RoleRequest[];
  total?: number;
};

export type Tag = {
  active_app_tags?: AppTagMap[];
  active_group_tags?: OktaGroupTagMap[];
  all_app_tags?: AppTagMap[];
  all_group_tags?: OktaGroupTagMap[];
  constraints?: Record<string, any>;
  /**
   * @format date-time
   */
  created_at?: string;
  /**
   * @format date-time
   */
  deleted_at?: string | null;
  /**
   * @maxLength 50
   */
  id: string;
  /**
   * @maxLength 1024
   */
  description?: string;
  enabled?: boolean;
  name: string;
  /**
   * @format date-time
   */
  updated_at?: string;
};

export type TagPagination = {
  /**
   * @format url
   */
  next?: string;
  pages?: number;
  /**
   * @format url
   */
  prev?: string;
  results?: Tag[];
  total?: number;
};

export type UserGroupAuditPagination = {
  /**
   * @format url
   */
  next?: string;
  pages?: number;
  /**
   * @format url
   */
  prev?: string;
  results?: OktaUserGroupMember[];
  total?: number;
};

export type UserPagination = {
  /**
   * @format url
   */
  next?: string;
  pages?: number;
  /**
   * @format url
   */
  prev?: string;
  results?: OktaUser[];
  total?: number;
};
