// Copyright 2015 The Go Authors.  All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package mobile

//go:generate gomobile help documentation doc.go

import (
	"flag"
	"fmt"
	"os"
	"path/filepath"
	"runtime"
)

var (
	gomobileName = "gomobile"
)

func goBin() string {
	return filepath.Join(runtime.GOROOT(), "bin", "go")
}

const documentationHeader = `// Copyright 2015 The Go Authors.  All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated by 'gomobile help documentation doc.go'. DO NOT EDIT.
`

type command struct {
	run   func(*command) error
	Flag  flag.FlagSet
	Name  string
	Usage string
	Short string
	Long  string

	IconPath, AppName string
}

func (cmd *command) usage() {
	fmt.Fprintf(os.Stdout, "usage: %s %s %s\n%s", gomobileName, cmd.Name, cmd.Usage, cmd.Long)
}
