package main

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestSanitiseName(t *testing.T) {
	file := "example.png"
	prefix := "file"

	assert.Equal(t, "fileExamplePng", sanitiseName(file, prefix))
}

func TestSanitiseName_Special(t *testing.T) {
	file := "a longer name (with-syms).png"
	prefix := "file"

	assert.Equal(t, "fileALongerNameWithSymsPng", sanitiseName(file, prefix))
}

func TestSanitiseName_Exported(t *testing.T) {
	file := "example.png"
	prefix := "Public"

	assert.Equal(t, "PublicExamplePng", sanitiseName(file, prefix))
}
