// Copyright 2018-2021 CERN
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// In applying this license, CERN does not waive the privileges and immunities
// granted to it by virtue of its status as an Intergovernmental Organization
// or submit itself to any jurisdiction.

// Code generated by protoc-gen-go. DO NOT EDIT.
// source: Rpc.proto

package eos_grpc

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type TYPE int32

const (
	TYPE_FILE      TYPE = 0
	TYPE_CONTAINER TYPE = 1
	TYPE_LISTING   TYPE = 2
	TYPE_STAT      TYPE = 3
)

var TYPE_name = map[int32]string{
	0: "FILE",
	1: "CONTAINER",
	2: "LISTING",
	3: "STAT",
}

var TYPE_value = map[string]int32{
	"FILE":      0,
	"CONTAINER": 1,
	"LISTING":   2,
	"STAT":      3,
}

func (x TYPE) String() string {
	return proto.EnumName(TYPE_name, int32(x))
}

func (TYPE) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{0}
}

type QUOTATYPE int32

const (
	QUOTATYPE_USER    QUOTATYPE = 0
	QUOTATYPE_GROUP   QUOTATYPE = 2
	QUOTATYPE_PROJECT QUOTATYPE = 3
)

var QUOTATYPE_name = map[int32]string{
	0: "USER",
	2: "GROUP",
	3: "PROJECT",
}

var QUOTATYPE_value = map[string]int32{
	"USER":    0,
	"GROUP":   2,
	"PROJECT": 3,
}

func (x QUOTATYPE) String() string {
	return proto.EnumName(QUOTATYPE_name, int32(x))
}

func (QUOTATYPE) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{1}
}

type QUOTAOP int32

const (
	QUOTAOP_GET    QUOTAOP = 0
	QUOTAOP_SET    QUOTAOP = 1
	QUOTAOP_RM     QUOTAOP = 2
	QUOTAOP_RMNODE QUOTAOP = 3
)

var QUOTAOP_name = map[int32]string{
	0: "GET",
	1: "SET",
	2: "RM",
	3: "RMNODE",
}

var QUOTAOP_value = map[string]int32{
	"GET":    0,
	"SET":    1,
	"RM":     2,
	"RMNODE": 3,
}

func (x QUOTAOP) String() string {
	return proto.EnumName(QUOTAOP_name, int32(x))
}

func (QUOTAOP) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{2}
}

type QUOTAENTRY int32

const (
	QUOTAENTRY_NONE   QUOTAENTRY = 0
	QUOTAENTRY_VOLUME QUOTAENTRY = 1
	QUOTAENTRY_INODE  QUOTAENTRY = 2
)

var QUOTAENTRY_name = map[int32]string{
	0: "NONE",
	1: "VOLUME",
	2: "INODE",
}

var QUOTAENTRY_value = map[string]int32{
	"NONE":   0,
	"VOLUME": 1,
	"INODE":  2,
}

func (x QUOTAENTRY) String() string {
	return proto.EnumName(QUOTAENTRY_name, int32(x))
}

func (QUOTAENTRY) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{3}
}

type MANILA_REQUEST_TYPE int32

const (
	MANILA_REQUEST_TYPE_CREATE_SHARE    MANILA_REQUEST_TYPE = 0
	MANILA_REQUEST_TYPE_DELETE_SHARE    MANILA_REQUEST_TYPE = 1
	MANILA_REQUEST_TYPE_EXTEND_SHARE    MANILA_REQUEST_TYPE = 2
	MANILA_REQUEST_TYPE_SHRINK_SHARE    MANILA_REQUEST_TYPE = 3
	MANILA_REQUEST_TYPE_MANAGE_EXISTING MANILA_REQUEST_TYPE = 4
	MANILA_REQUEST_TYPE_UNMANAGE        MANILA_REQUEST_TYPE = 5
	MANILA_REQUEST_TYPE_GET_CAPACITIES  MANILA_REQUEST_TYPE = 6
)

var MANILA_REQUEST_TYPE_name = map[int32]string{
	0: "CREATE_SHARE",
	1: "DELETE_SHARE",
	2: "EXTEND_SHARE",
	3: "SHRINK_SHARE",
	4: "MANAGE_EXISTING",
	5: "UNMANAGE",
	6: "GET_CAPACITIES",
}

var MANILA_REQUEST_TYPE_value = map[string]int32{
	"CREATE_SHARE":    0,
	"DELETE_SHARE":    1,
	"EXTEND_SHARE":    2,
	"SHRINK_SHARE":    3,
	"MANAGE_EXISTING": 4,
	"UNMANAGE":        5,
	"GET_CAPACITIES":  6,
}

func (x MANILA_REQUEST_TYPE) String() string {
	return proto.EnumName(MANILA_REQUEST_TYPE_name, int32(x))
}

func (MANILA_REQUEST_TYPE) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{4}
}

type NSRequest_VersionRequest_VERSION_CMD int32

const (
	NSRequest_VersionRequest_CREATE NSRequest_VersionRequest_VERSION_CMD = 0
	NSRequest_VersionRequest_PURGE  NSRequest_VersionRequest_VERSION_CMD = 1
	NSRequest_VersionRequest_LIST   NSRequest_VersionRequest_VERSION_CMD = 2
)

var NSRequest_VersionRequest_VERSION_CMD_name = map[int32]string{
	0: "CREATE",
	1: "PURGE",
	2: "LIST",
}

var NSRequest_VersionRequest_VERSION_CMD_value = map[string]int32{
	"CREATE": 0,
	"PURGE":  1,
	"LIST":   2,
}

func (x NSRequest_VersionRequest_VERSION_CMD) String() string {
	return proto.EnumName(NSRequest_VersionRequest_VERSION_CMD_name, int32(x))
}

func (NSRequest_VersionRequest_VERSION_CMD) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{20, 7, 0}
}

type NSRequest_RecycleRequest_RECYCLE_CMD int32

const (
	NSRequest_RecycleRequest_RESTORE NSRequest_RecycleRequest_RECYCLE_CMD = 0
	NSRequest_RecycleRequest_PURGE   NSRequest_RecycleRequest_RECYCLE_CMD = 1
	NSRequest_RecycleRequest_LIST    NSRequest_RecycleRequest_RECYCLE_CMD = 2
)

var NSRequest_RecycleRequest_RECYCLE_CMD_name = map[int32]string{
	0: "RESTORE",
	1: "PURGE",
	2: "LIST",
}

var NSRequest_RecycleRequest_RECYCLE_CMD_value = map[string]int32{
	"RESTORE": 0,
	"PURGE":   1,
	"LIST":    2,
}

func (x NSRequest_RecycleRequest_RECYCLE_CMD) String() string {
	return proto.EnumName(NSRequest_RecycleRequest_RECYCLE_CMD_name, int32(x))
}

func (NSRequest_RecycleRequest_RECYCLE_CMD) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{20, 8, 0}
}

type NSRequest_AclRequest_ACL_COMMAND int32

const (
	NSRequest_AclRequest_NONE   NSRequest_AclRequest_ACL_COMMAND = 0
	NSRequest_AclRequest_MODIFY NSRequest_AclRequest_ACL_COMMAND = 1
	NSRequest_AclRequest_LIST   NSRequest_AclRequest_ACL_COMMAND = 2
)

var NSRequest_AclRequest_ACL_COMMAND_name = map[int32]string{
	0: "NONE",
	1: "MODIFY",
	2: "LIST",
}

var NSRequest_AclRequest_ACL_COMMAND_value = map[string]int32{
	"NONE":   0,
	"MODIFY": 1,
	"LIST":   2,
}

func (x NSRequest_AclRequest_ACL_COMMAND) String() string {
	return proto.EnumName(NSRequest_AclRequest_ACL_COMMAND_name, int32(x))
}

func (NSRequest_AclRequest_ACL_COMMAND) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{20, 12, 0}
}

type NSRequest_AclRequest_ACL_TYPE int32

const (
	NSRequest_AclRequest_USER_ACL NSRequest_AclRequest_ACL_TYPE = 0
	NSRequest_AclRequest_SYS_ACL  NSRequest_AclRequest_ACL_TYPE = 1
)

var NSRequest_AclRequest_ACL_TYPE_name = map[int32]string{
	0: "USER_ACL",
	1: "SYS_ACL",
}

var NSRequest_AclRequest_ACL_TYPE_value = map[string]int32{
	"USER_ACL": 0,
	"SYS_ACL":  1,
}

func (x NSRequest_AclRequest_ACL_TYPE) String() string {
	return proto.EnumName(NSRequest_AclRequest_ACL_TYPE_name, int32(x))
}

func (NSRequest_AclRequest_ACL_TYPE) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{20, 12, 1}
}

type NSResponse_RecycleResponse_RecycleInfo_DELETIONTYPE int32

const (
	NSResponse_RecycleResponse_RecycleInfo_FILE NSResponse_RecycleResponse_RecycleInfo_DELETIONTYPE = 0
	NSResponse_RecycleResponse_RecycleInfo_TREE NSResponse_RecycleResponse_RecycleInfo_DELETIONTYPE = 1
)

var NSResponse_RecycleResponse_RecycleInfo_DELETIONTYPE_name = map[int32]string{
	0: "FILE",
	1: "TREE",
}

var NSResponse_RecycleResponse_RecycleInfo_DELETIONTYPE_value = map[string]int32{
	"FILE": 0,
	"TREE": 1,
}

func (x NSResponse_RecycleResponse_RecycleInfo_DELETIONTYPE) String() string {
	return proto.EnumName(NSResponse_RecycleResponse_RecycleInfo_DELETIONTYPE_name, int32(x))
}

func (NSResponse_RecycleResponse_RecycleInfo_DELETIONTYPE) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{21, 2, 0, 0}
}

type PingRequest struct {
	Authkey              string   `protobuf:"bytes,1,opt,name=authkey,proto3" json:"authkey,omitempty"`
	Message              []byte   `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PingRequest) Reset()         { *m = PingRequest{} }
func (m *PingRequest) String() string { return proto.CompactTextString(m) }
func (*PingRequest) ProtoMessage()    {}
func (*PingRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{0}
}

func (m *PingRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PingRequest.Unmarshal(m, b)
}
func (m *PingRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PingRequest.Marshal(b, m, deterministic)
}
func (m *PingRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PingRequest.Merge(m, src)
}
func (m *PingRequest) XXX_Size() int {
	return xxx_messageInfo_PingRequest.Size(m)
}
func (m *PingRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PingRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PingRequest proto.InternalMessageInfo

func (m *PingRequest) GetAuthkey() string {
	if m != nil {
		return m.Authkey
	}
	return ""
}

func (m *PingRequest) GetMessage() []byte {
	if m != nil {
		return m.Message
	}
	return nil
}

type PingReply struct {
	Message              []byte   `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PingReply) Reset()         { *m = PingReply{} }
func (m *PingReply) String() string { return proto.CompactTextString(m) }
func (*PingReply) ProtoMessage()    {}
func (*PingReply) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{1}
}

func (m *PingReply) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PingReply.Unmarshal(m, b)
}
func (m *PingReply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PingReply.Marshal(b, m, deterministic)
}
func (m *PingReply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PingReply.Merge(m, src)
}
func (m *PingReply) XXX_Size() int {
	return xxx_messageInfo_PingReply.Size(m)
}
func (m *PingReply) XXX_DiscardUnknown() {
	xxx_messageInfo_PingReply.DiscardUnknown(m)
}

var xxx_messageInfo_PingReply proto.InternalMessageInfo

func (m *PingReply) GetMessage() []byte {
	if m != nil {
		return m.Message
	}
	return nil
}

type ContainerInsertRequest struct {
	Container            []*ContainerMdProto `protobuf:"bytes,1,rep,name=container,proto3" json:"container,omitempty"`
	Authkey              string              `protobuf:"bytes,2,opt,name=authkey,proto3" json:"authkey,omitempty"`
	InheritMd            bool                `protobuf:"varint,3,opt,name=inherit_md,json=inheritMd,proto3" json:"inherit_md,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ContainerInsertRequest) Reset()         { *m = ContainerInsertRequest{} }
func (m *ContainerInsertRequest) String() string { return proto.CompactTextString(m) }
func (*ContainerInsertRequest) ProtoMessage()    {}
func (*ContainerInsertRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{2}
}

func (m *ContainerInsertRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ContainerInsertRequest.Unmarshal(m, b)
}
func (m *ContainerInsertRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ContainerInsertRequest.Marshal(b, m, deterministic)
}
func (m *ContainerInsertRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerInsertRequest.Merge(m, src)
}
func (m *ContainerInsertRequest) XXX_Size() int {
	return xxx_messageInfo_ContainerInsertRequest.Size(m)
}
func (m *ContainerInsertRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerInsertRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerInsertRequest proto.InternalMessageInfo

func (m *ContainerInsertRequest) GetContainer() []*ContainerMdProto {
	if m != nil {
		return m.Container
	}
	return nil
}

func (m *ContainerInsertRequest) GetAuthkey() string {
	if m != nil {
		return m.Authkey
	}
	return ""
}

func (m *ContainerInsertRequest) GetInheritMd() bool {
	if m != nil {
		return m.InheritMd
	}
	return false
}

type FileInsertRequest struct {
	Files                []*FileMdProto `protobuf:"bytes,1,rep,name=files,proto3" json:"files,omitempty"`
	Authkey              string         `protobuf:"bytes,2,opt,name=authkey,proto3" json:"authkey,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *FileInsertRequest) Reset()         { *m = FileInsertRequest{} }
func (m *FileInsertRequest) String() string { return proto.CompactTextString(m) }
func (*FileInsertRequest) ProtoMessage()    {}
func (*FileInsertRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{3}
}

func (m *FileInsertRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FileInsertRequest.Unmarshal(m, b)
}
func (m *FileInsertRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FileInsertRequest.Marshal(b, m, deterministic)
}
func (m *FileInsertRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FileInsertRequest.Merge(m, src)
}
func (m *FileInsertRequest) XXX_Size() int {
	return xxx_messageInfo_FileInsertRequest.Size(m)
}
func (m *FileInsertRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FileInsertRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FileInsertRequest proto.InternalMessageInfo

func (m *FileInsertRequest) GetFiles() []*FileMdProto {
	if m != nil {
		return m.Files
	}
	return nil
}

func (m *FileInsertRequest) GetAuthkey() string {
	if m != nil {
		return m.Authkey
	}
	return ""
}

type InsertReply struct {
	Message              []string `protobuf:"bytes,1,rep,name=message,proto3" json:"message,omitempty"`
	Retc                 []uint32 `protobuf:"varint,2,rep,packed,name=retc,proto3" json:"retc,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InsertReply) Reset()         { *m = InsertReply{} }
func (m *InsertReply) String() string { return proto.CompactTextString(m) }
func (*InsertReply) ProtoMessage()    {}
func (*InsertReply) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{4}
}

func (m *InsertReply) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InsertReply.Unmarshal(m, b)
}
func (m *InsertReply) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InsertReply.Marshal(b, m, deterministic)
}
func (m *InsertReply) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InsertReply.Merge(m, src)
}
func (m *InsertReply) XXX_Size() int {
	return xxx_messageInfo_InsertReply.Size(m)
}
func (m *InsertReply) XXX_DiscardUnknown() {
	xxx_messageInfo_InsertReply.DiscardUnknown(m)
}

var xxx_messageInfo_InsertReply proto.InternalMessageInfo

func (m *InsertReply) GetMessage() []string {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *InsertReply) GetRetc() []uint32 {
	if m != nil {
		return m.Retc
	}
	return nil
}

type Time struct {
	Sec                  uint64   `protobuf:"varint,1,opt,name=sec,proto3" json:"sec,omitempty"`
	NSec                 uint64   `protobuf:"varint,2,opt,name=n_sec,json=nSec,proto3" json:"n_sec,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Time) Reset()         { *m = Time{} }
func (m *Time) String() string { return proto.CompactTextString(m) }
func (*Time) ProtoMessage()    {}
func (*Time) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{5}
}

func (m *Time) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Time.Unmarshal(m, b)
}
func (m *Time) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Time.Marshal(b, m, deterministic)
}
func (m *Time) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Time.Merge(m, src)
}
func (m *Time) XXX_Size() int {
	return xxx_messageInfo_Time.Size(m)
}
func (m *Time) XXX_DiscardUnknown() {
	xxx_messageInfo_Time.DiscardUnknown(m)
}

var xxx_messageInfo_Time proto.InternalMessageInfo

func (m *Time) GetSec() uint64 {
	if m != nil {
		return m.Sec
	}
	return 0
}

func (m *Time) GetNSec() uint64 {
	if m != nil {
		return m.NSec
	}
	return 0
}

type Checksum struct {
	Value                []byte   `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	Type                 string   `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Checksum) Reset()         { *m = Checksum{} }
func (m *Checksum) String() string { return proto.CompactTextString(m) }
func (*Checksum) ProtoMessage()    {}
func (*Checksum) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{6}
}

func (m *Checksum) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Checksum.Unmarshal(m, b)
}
func (m *Checksum) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Checksum.Marshal(b, m, deterministic)
}
func (m *Checksum) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Checksum.Merge(m, src)
}
func (m *Checksum) XXX_Size() int {
	return xxx_messageInfo_Checksum.Size(m)
}
func (m *Checksum) XXX_DiscardUnknown() {
	xxx_messageInfo_Checksum.DiscardUnknown(m)
}

var xxx_messageInfo_Checksum proto.InternalMessageInfo

func (m *Checksum) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Checksum) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

type FileMdProto struct {
	Id                   uint64            `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	ContId               uint64            `protobuf:"varint,2,opt,name=cont_id,json=contId,proto3" json:"cont_id,omitempty"`
	Uid                  uint64            `protobuf:"varint,3,opt,name=uid,proto3" json:"uid,omitempty"`
	Gid                  uint64            `protobuf:"varint,4,opt,name=gid,proto3" json:"gid,omitempty"`
	Size                 uint64            `protobuf:"varint,5,opt,name=size,proto3" json:"size,omitempty"`
	LayoutId             uint32            `protobuf:"varint,6,opt,name=layout_id,json=layoutId,proto3" json:"layout_id,omitempty"`
	Flags                uint32            `protobuf:"varint,7,opt,name=flags,proto3" json:"flags,omitempty"`
	Name                 []byte            `protobuf:"bytes,8,opt,name=name,proto3" json:"name,omitempty"`
	LinkName             []byte            `protobuf:"bytes,9,opt,name=link_name,json=linkName,proto3" json:"link_name,omitempty"`
	Ctime                *Time             `protobuf:"bytes,10,opt,name=ctime,proto3" json:"ctime,omitempty"`
	Mtime                *Time             `protobuf:"bytes,11,opt,name=mtime,proto3" json:"mtime,omitempty"`
	Checksum             *Checksum         `protobuf:"bytes,12,opt,name=checksum,proto3" json:"checksum,omitempty"`
	Locations            []uint32          `protobuf:"varint,13,rep,packed,name=locations,proto3" json:"locations,omitempty"`
	UnlinkLocations      []uint32          `protobuf:"varint,14,rep,packed,name=unlink_locations,json=unlinkLocations,proto3" json:"unlink_locations,omitempty"`
	Xattrs               map[string][]byte `protobuf:"bytes,15,rep,name=xattrs,proto3" json:"xattrs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Path                 []byte            `protobuf:"bytes,16,opt,name=path,proto3" json:"path,omitempty"`
	Etag                 string            `protobuf:"bytes,17,opt,name=etag,proto3" json:"etag,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *FileMdProto) Reset()         { *m = FileMdProto{} }
func (m *FileMdProto) String() string { return proto.CompactTextString(m) }
func (*FileMdProto) ProtoMessage()    {}
func (*FileMdProto) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{7}
}

func (m *FileMdProto) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FileMdProto.Unmarshal(m, b)
}
func (m *FileMdProto) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FileMdProto.Marshal(b, m, deterministic)
}
func (m *FileMdProto) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FileMdProto.Merge(m, src)
}
func (m *FileMdProto) XXX_Size() int {
	return xxx_messageInfo_FileMdProto.Size(m)
}
func (m *FileMdProto) XXX_DiscardUnknown() {
	xxx_messageInfo_FileMdProto.DiscardUnknown(m)
}

var xxx_messageInfo_FileMdProto proto.InternalMessageInfo

func (m *FileMdProto) GetId() uint64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *FileMdProto) GetContId() uint64 {
	if m != nil {
		return m.ContId
	}
	return 0
}

func (m *FileMdProto) GetUid() uint64 {
	if m != nil {
		return m.Uid
	}
	return 0
}

func (m *FileMdProto) GetGid() uint64 {
	if m != nil {
		return m.Gid
	}
	return 0
}

func (m *FileMdProto) GetSize() uint64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *FileMdProto) GetLayoutId() uint32 {
	if m != nil {
		return m.LayoutId
	}
	return 0
}

func (m *FileMdProto) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

func (m *FileMdProto) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *FileMdProto) GetLinkName() []byte {
	if m != nil {
		return m.LinkName
	}
	return nil
}

func (m *FileMdProto) GetCtime() *Time {
	if m != nil {
		return m.Ctime
	}
	return nil
}

func (m *FileMdProto) GetMtime() *Time {
	if m != nil {
		return m.Mtime
	}
	return nil
}

func (m *FileMdProto) GetChecksum() *Checksum {
	if m != nil {
		return m.Checksum
	}
	return nil
}

func (m *FileMdProto) GetLocations() []uint32 {
	if m != nil {
		return m.Locations
	}
	return nil
}

func (m *FileMdProto) GetUnlinkLocations() []uint32 {
	if m != nil {
		return m.UnlinkLocations
	}
	return nil
}

func (m *FileMdProto) GetXattrs() map[string][]byte {
	if m != nil {
		return m.Xattrs
	}
	return nil
}

func (m *FileMdProto) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *FileMdProto) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

type ContainerMdProto struct {
	Id                   uint64            `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	ParentId             uint64            `protobuf:"varint,2,opt,name=parent_id,json=parentId,proto3" json:"parent_id,omitempty"`
	Uid                  uint64            `protobuf:"varint,3,opt,name=uid,proto3" json:"uid,omitempty"`
	Gid                  uint64            `protobuf:"varint,4,opt,name=gid,proto3" json:"gid,omitempty"`
	TreeSize             int64             `protobuf:"varint,6,opt,name=tree_size,json=treeSize,proto3" json:"tree_size,omitempty"`
	Mode                 uint32            `protobuf:"varint,5,opt,name=mode,proto3" json:"mode,omitempty"`
	Flags                uint32            `protobuf:"varint,7,opt,name=flags,proto3" json:"flags,omitempty"`
	Name                 []byte            `protobuf:"bytes,8,opt,name=name,proto3" json:"name,omitempty"`
	Ctime                *Time             `protobuf:"bytes,9,opt,name=ctime,proto3" json:"ctime,omitempty"`
	Mtime                *Time             `protobuf:"bytes,10,opt,name=mtime,proto3" json:"mtime,omitempty"`
	Stime                *Time             `protobuf:"bytes,11,opt,name=stime,proto3" json:"stime,omitempty"`
	Xattrs               map[string][]byte `protobuf:"bytes,12,rep,name=xattrs,proto3" json:"xattrs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Path                 []byte            `protobuf:"bytes,13,opt,name=path,proto3" json:"path,omitempty"`
	Etag                 string            `protobuf:"bytes,14,opt,name=etag,proto3" json:"etag,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ContainerMdProto) Reset()         { *m = ContainerMdProto{} }
func (m *ContainerMdProto) String() string { return proto.CompactTextString(m) }
func (*ContainerMdProto) ProtoMessage()    {}
func (*ContainerMdProto) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{8}
}

func (m *ContainerMdProto) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ContainerMdProto.Unmarshal(m, b)
}
func (m *ContainerMdProto) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ContainerMdProto.Marshal(b, m, deterministic)
}
func (m *ContainerMdProto) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ContainerMdProto.Merge(m, src)
}
func (m *ContainerMdProto) XXX_Size() int {
	return xxx_messageInfo_ContainerMdProto.Size(m)
}
func (m *ContainerMdProto) XXX_DiscardUnknown() {
	xxx_messageInfo_ContainerMdProto.DiscardUnknown(m)
}

var xxx_messageInfo_ContainerMdProto proto.InternalMessageInfo

func (m *ContainerMdProto) GetId() uint64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *ContainerMdProto) GetParentId() uint64 {
	if m != nil {
		return m.ParentId
	}
	return 0
}

func (m *ContainerMdProto) GetUid() uint64 {
	if m != nil {
		return m.Uid
	}
	return 0
}

func (m *ContainerMdProto) GetGid() uint64 {
	if m != nil {
		return m.Gid
	}
	return 0
}

func (m *ContainerMdProto) GetTreeSize() int64 {
	if m != nil {
		return m.TreeSize
	}
	return 0
}

func (m *ContainerMdProto) GetMode() uint32 {
	if m != nil {
		return m.Mode
	}
	return 0
}

func (m *ContainerMdProto) GetFlags() uint32 {
	if m != nil {
		return m.Flags
	}
	return 0
}

func (m *ContainerMdProto) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *ContainerMdProto) GetCtime() *Time {
	if m != nil {
		return m.Ctime
	}
	return nil
}

func (m *ContainerMdProto) GetMtime() *Time {
	if m != nil {
		return m.Mtime
	}
	return nil
}

func (m *ContainerMdProto) GetStime() *Time {
	if m != nil {
		return m.Stime
	}
	return nil
}

func (m *ContainerMdProto) GetXattrs() map[string][]byte {
	if m != nil {
		return m.Xattrs
	}
	return nil
}

func (m *ContainerMdProto) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *ContainerMdProto) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

type QuotaProto struct {
	Path                 []byte    `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Name                 string    `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Type                 QUOTATYPE `protobuf:"varint,3,opt,name=type,proto3,enum=eos.rpc.QUOTATYPE" json:"type,omitempty"`
	Usedbytes            uint64    `protobuf:"varint,4,opt,name=usedbytes,proto3" json:"usedbytes,omitempty"`
	Usedlogicalbytes     uint64    `protobuf:"varint,5,opt,name=usedlogicalbytes,proto3" json:"usedlogicalbytes,omitempty"`
	Usedfiles            uint64    `protobuf:"varint,6,opt,name=usedfiles,proto3" json:"usedfiles,omitempty"`
	Maxbytes             uint64    `protobuf:"varint,7,opt,name=maxbytes,proto3" json:"maxbytes,omitempty"`
	Maxlogicalbytes      uint64    `protobuf:"varint,8,opt,name=maxlogicalbytes,proto3" json:"maxlogicalbytes,omitempty"`
	Maxfiles             uint64    `protobuf:"varint,9,opt,name=maxfiles,proto3" json:"maxfiles,omitempty"`
	Percentageusedbytes  float32   `protobuf:"fixed32,10,opt,name=percentageusedbytes,proto3" json:"percentageusedbytes,omitempty"`
	Percentageusedfiles  float32   `protobuf:"fixed32,11,opt,name=percentageusedfiles,proto3" json:"percentageusedfiles,omitempty"`
	Statusbytes          string    `protobuf:"bytes,12,opt,name=statusbytes,proto3" json:"statusbytes,omitempty"`
	Statusfiles          string    `protobuf:"bytes,13,opt,name=statusfiles,proto3" json:"statusfiles,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *QuotaProto) Reset()         { *m = QuotaProto{} }
func (m *QuotaProto) String() string { return proto.CompactTextString(m) }
func (*QuotaProto) ProtoMessage()    {}
func (*QuotaProto) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{9}
}

func (m *QuotaProto) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QuotaProto.Unmarshal(m, b)
}
func (m *QuotaProto) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QuotaProto.Marshal(b, m, deterministic)
}
func (m *QuotaProto) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QuotaProto.Merge(m, src)
}
func (m *QuotaProto) XXX_Size() int {
	return xxx_messageInfo_QuotaProto.Size(m)
}
func (m *QuotaProto) XXX_DiscardUnknown() {
	xxx_messageInfo_QuotaProto.DiscardUnknown(m)
}

var xxx_messageInfo_QuotaProto proto.InternalMessageInfo

func (m *QuotaProto) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *QuotaProto) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *QuotaProto) GetType() QUOTATYPE {
	if m != nil {
		return m.Type
	}
	return QUOTATYPE_USER
}

func (m *QuotaProto) GetUsedbytes() uint64 {
	if m != nil {
		return m.Usedbytes
	}
	return 0
}

func (m *QuotaProto) GetUsedlogicalbytes() uint64 {
	if m != nil {
		return m.Usedlogicalbytes
	}
	return 0
}

func (m *QuotaProto) GetUsedfiles() uint64 {
	if m != nil {
		return m.Usedfiles
	}
	return 0
}

func (m *QuotaProto) GetMaxbytes() uint64 {
	if m != nil {
		return m.Maxbytes
	}
	return 0
}

func (m *QuotaProto) GetMaxlogicalbytes() uint64 {
	if m != nil {
		return m.Maxlogicalbytes
	}
	return 0
}

func (m *QuotaProto) GetMaxfiles() uint64 {
	if m != nil {
		return m.Maxfiles
	}
	return 0
}

func (m *QuotaProto) GetPercentageusedbytes() float32 {
	if m != nil {
		return m.Percentageusedbytes
	}
	return 0
}

func (m *QuotaProto) GetPercentageusedfiles() float32 {
	if m != nil {
		return m.Percentageusedfiles
	}
	return 0
}

func (m *QuotaProto) GetStatusbytes() string {
	if m != nil {
		return m.Statusbytes
	}
	return ""
}

func (m *QuotaProto) GetStatusfiles() string {
	if m != nil {
		return m.Statusfiles
	}
	return ""
}

type RoleId struct {
	Uid                  uint64   `protobuf:"varint,1,opt,name=uid,proto3" json:"uid,omitempty"`
	Gid                  uint64   `protobuf:"varint,2,opt,name=gid,proto3" json:"gid,omitempty"`
	Username             string   `protobuf:"bytes,3,opt,name=username,proto3" json:"username,omitempty"`
	Groupname            string   `protobuf:"bytes,4,opt,name=groupname,proto3" json:"groupname,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RoleId) Reset()         { *m = RoleId{} }
func (m *RoleId) String() string { return proto.CompactTextString(m) }
func (*RoleId) ProtoMessage()    {}
func (*RoleId) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{10}
}

func (m *RoleId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RoleId.Unmarshal(m, b)
}
func (m *RoleId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RoleId.Marshal(b, m, deterministic)
}
func (m *RoleId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RoleId.Merge(m, src)
}
func (m *RoleId) XXX_Size() int {
	return xxx_messageInfo_RoleId.Size(m)
}
func (m *RoleId) XXX_DiscardUnknown() {
	xxx_messageInfo_RoleId.DiscardUnknown(m)
}

var xxx_messageInfo_RoleId proto.InternalMessageInfo

func (m *RoleId) GetUid() uint64 {
	if m != nil {
		return m.Uid
	}
	return 0
}

func (m *RoleId) GetGid() uint64 {
	if m != nil {
		return m.Gid
	}
	return 0
}

func (m *RoleId) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *RoleId) GetGroupname() string {
	if m != nil {
		return m.Groupname
	}
	return ""
}

type MDId struct {
	Path                 []byte   `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Id                   uint64   `protobuf:"fixed64,2,opt,name=id,proto3" json:"id,omitempty"`
	Ino                  uint64   `protobuf:"fixed64,3,opt,name=ino,proto3" json:"ino,omitempty"`
	Type                 TYPE     `protobuf:"varint,4,opt,name=type,proto3,enum=eos.rpc.TYPE" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MDId) Reset()         { *m = MDId{} }
func (m *MDId) String() string { return proto.CompactTextString(m) }
func (*MDId) ProtoMessage()    {}
func (*MDId) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{11}
}

func (m *MDId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MDId.Unmarshal(m, b)
}
func (m *MDId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MDId.Marshal(b, m, deterministic)
}
func (m *MDId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MDId.Merge(m, src)
}
func (m *MDId) XXX_Size() int {
	return xxx_messageInfo_MDId.Size(m)
}
func (m *MDId) XXX_DiscardUnknown() {
	xxx_messageInfo_MDId.DiscardUnknown(m)
}

var xxx_messageInfo_MDId proto.InternalMessageInfo

func (m *MDId) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *MDId) GetId() uint64 {
	if m != nil {
		return m.Id
	}
	return 0
}

func (m *MDId) GetIno() uint64 {
	if m != nil {
		return m.Ino
	}
	return 0
}

func (m *MDId) GetType() TYPE {
	if m != nil {
		return m.Type
	}
	return TYPE_FILE
}

type Limit struct {
	Zero                 bool     `protobuf:"varint,1,opt,name=zero,proto3" json:"zero,omitempty"`
	Min                  uint64   `protobuf:"varint,2,opt,name=min,proto3" json:"min,omitempty"`
	Max                  uint64   `protobuf:"varint,3,opt,name=max,proto3" json:"max,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Limit) Reset()         { *m = Limit{} }
func (m *Limit) String() string { return proto.CompactTextString(m) }
func (*Limit) ProtoMessage()    {}
func (*Limit) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{12}
}

func (m *Limit) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Limit.Unmarshal(m, b)
}
func (m *Limit) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Limit.Marshal(b, m, deterministic)
}
func (m *Limit) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Limit.Merge(m, src)
}
func (m *Limit) XXX_Size() int {
	return xxx_messageInfo_Limit.Size(m)
}
func (m *Limit) XXX_DiscardUnknown() {
	xxx_messageInfo_Limit.DiscardUnknown(m)
}

var xxx_messageInfo_Limit proto.InternalMessageInfo

func (m *Limit) GetZero() bool {
	if m != nil {
		return m.Zero
	}
	return false
}

func (m *Limit) GetMin() uint64 {
	if m != nil {
		return m.Min
	}
	return 0
}

func (m *Limit) GetMax() uint64 {
	if m != nil {
		return m.Max
	}
	return 0
}

type MDSelection struct {
	Select               bool              `protobuf:"varint,1,opt,name=select,proto3" json:"select,omitempty"`
	Ctime                *Limit            `protobuf:"bytes,2,opt,name=ctime,proto3" json:"ctime,omitempty"`
	Mtime                *Limit            `protobuf:"bytes,3,opt,name=mtime,proto3" json:"mtime,omitempty"`
	Stime                *Limit            `protobuf:"bytes,4,opt,name=stime,proto3" json:"stime,omitempty"`
	Size                 *Limit            `protobuf:"bytes,5,opt,name=size,proto3" json:"size,omitempty"`
	Treesize             *Limit            `protobuf:"bytes,6,opt,name=treesize,proto3" json:"treesize,omitempty"`
	Children             *Limit            `protobuf:"bytes,7,opt,name=children,proto3" json:"children,omitempty"`
	Locations            *Limit            `protobuf:"bytes,8,opt,name=locations,proto3" json:"locations,omitempty"`
	UnlinkedLocations    *Limit            `protobuf:"bytes,9,opt,name=unlinked_locations,json=unlinkedLocations,proto3" json:"unlinked_locations,omitempty"`
	Layoutid             uint64            `protobuf:"varint,10,opt,name=layoutid,proto3" json:"layoutid,omitempty"`
	Flags                uint64            `protobuf:"varint,11,opt,name=flags,proto3" json:"flags,omitempty"`
	Symlink              bool              `protobuf:"varint,12,opt,name=symlink,proto3" json:"symlink,omitempty"`
	Checksum             *Checksum         `protobuf:"bytes,13,opt,name=checksum,proto3" json:"checksum,omitempty"`
	Owner                uint32            `protobuf:"varint,14,opt,name=owner,proto3" json:"owner,omitempty"`
	Group                uint32            `protobuf:"varint,15,opt,name=group,proto3" json:"group,omitempty"`
	OwnerRoot            bool              `protobuf:"varint,16,opt,name=owner_root,json=ownerRoot,proto3" json:"owner_root,omitempty"`
	GroupRoot            bool              `protobuf:"varint,17,opt,name=group_root,json=groupRoot,proto3" json:"group_root,omitempty"`
	RegexpFilename       []byte            `protobuf:"bytes,18,opt,name=regexp_filename,json=regexpFilename,proto3" json:"regexp_filename,omitempty"`
	RegexpDirname        []byte            `protobuf:"bytes,19,opt,name=regexp_dirname,json=regexpDirname,proto3" json:"regexp_dirname,omitempty"`
	Xattr                map[string][]byte `protobuf:"bytes,20,rep,name=xattr,proto3" json:"xattr,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *MDSelection) Reset()         { *m = MDSelection{} }
func (m *MDSelection) String() string { return proto.CompactTextString(m) }
func (*MDSelection) ProtoMessage()    {}
func (*MDSelection) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{13}
}

func (m *MDSelection) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MDSelection.Unmarshal(m, b)
}
func (m *MDSelection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MDSelection.Marshal(b, m, deterministic)
}
func (m *MDSelection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MDSelection.Merge(m, src)
}
func (m *MDSelection) XXX_Size() int {
	return xxx_messageInfo_MDSelection.Size(m)
}
func (m *MDSelection) XXX_DiscardUnknown() {
	xxx_messageInfo_MDSelection.DiscardUnknown(m)
}

var xxx_messageInfo_MDSelection proto.InternalMessageInfo

func (m *MDSelection) GetSelect() bool {
	if m != nil {
		return m.Select
	}
	return false
}

func (m *MDSelection) GetCtime() *Limit {
	if m != nil {
		return m.Ctime
	}
	return nil
}

func (m *MDSelection) GetMtime() *Limit {
	if m != nil {
		return m.Mtime
	}
	return nil
}

func (m *MDSelection) GetStime() *Limit {
	if m != nil {
		return m.Stime
	}
	return nil
}

func (m *MDSelection) GetSize() *Limit {
	if m != nil {
		return m.Size
	}
	return nil
}

func (m *MDSelection) GetTreesize() *Limit {
	if m != nil {
		return m.Treesize
	}
	return nil
}

func (m *MDSelection) GetChildren() *Limit {
	if m != nil {
		return m.Children
	}
	return nil
}

func (m *MDSelection) GetLocations() *Limit {
	if m != nil {
		return m.Locations
	}
	return nil
}

func (m *MDSelection) GetUnlinkedLocations() *Limit {
	if m != nil {
		return m.UnlinkedLocations
	}
	return nil
}

func (m *MDSelection) GetLayoutid() uint64 {
	if m != nil {
		return m.Layoutid
	}
	return 0
}

func (m *MDSelection) GetFlags() uint64 {
	if m != nil {
		return m.Flags
	}
	return 0
}

func (m *MDSelection) GetSymlink() bool {
	if m != nil {
		return m.Symlink
	}
	return false
}

func (m *MDSelection) GetChecksum() *Checksum {
	if m != nil {
		return m.Checksum
	}
	return nil
}

func (m *MDSelection) GetOwner() uint32 {
	if m != nil {
		return m.Owner
	}
	return 0
}

func (m *MDSelection) GetGroup() uint32 {
	if m != nil {
		return m.Group
	}
	return 0
}

func (m *MDSelection) GetOwnerRoot() bool {
	if m != nil {
		return m.OwnerRoot
	}
	return false
}

func (m *MDSelection) GetGroupRoot() bool {
	if m != nil {
		return m.GroupRoot
	}
	return false
}

func (m *MDSelection) GetRegexpFilename() []byte {
	if m != nil {
		return m.RegexpFilename
	}
	return nil
}

func (m *MDSelection) GetRegexpDirname() []byte {
	if m != nil {
		return m.RegexpDirname
	}
	return nil
}

func (m *MDSelection) GetXattr() map[string][]byte {
	if m != nil {
		return m.Xattr
	}
	return nil
}

type MDRequest struct {
	Type                 TYPE         `protobuf:"varint,1,opt,name=type,proto3,enum=eos.rpc.TYPE" json:"type,omitempty"`
	Id                   *MDId        `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	Authkey              string       `protobuf:"bytes,3,opt,name=authkey,proto3" json:"authkey,omitempty"`
	Role                 *RoleId      `protobuf:"bytes,4,opt,name=role,proto3" json:"role,omitempty"`
	Selection            *MDSelection `protobuf:"bytes,5,opt,name=selection,proto3" json:"selection,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *MDRequest) Reset()         { *m = MDRequest{} }
func (m *MDRequest) String() string { return proto.CompactTextString(m) }
func (*MDRequest) ProtoMessage()    {}
func (*MDRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{14}
}

func (m *MDRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MDRequest.Unmarshal(m, b)
}
func (m *MDRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MDRequest.Marshal(b, m, deterministic)
}
func (m *MDRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MDRequest.Merge(m, src)
}
func (m *MDRequest) XXX_Size() int {
	return xxx_messageInfo_MDRequest.Size(m)
}
func (m *MDRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MDRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MDRequest proto.InternalMessageInfo

func (m *MDRequest) GetType() TYPE {
	if m != nil {
		return m.Type
	}
	return TYPE_FILE
}

func (m *MDRequest) GetId() *MDId {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *MDRequest) GetAuthkey() string {
	if m != nil {
		return m.Authkey
	}
	return ""
}

func (m *MDRequest) GetRole() *RoleId {
	if m != nil {
		return m.Role
	}
	return nil
}

func (m *MDRequest) GetSelection() *MDSelection {
	if m != nil {
		return m.Selection
	}
	return nil
}

type MDResponse struct {
	Type                 TYPE              `protobuf:"varint,1,opt,name=type,proto3,enum=eos.rpc.TYPE" json:"type,omitempty"`
	Fmd                  *FileMdProto      `protobuf:"bytes,2,opt,name=fmd,proto3" json:"fmd,omitempty"`
	Cmd                  *ContainerMdProto `protobuf:"bytes,3,opt,name=cmd,proto3" json:"cmd,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *MDResponse) Reset()         { *m = MDResponse{} }
func (m *MDResponse) String() string { return proto.CompactTextString(m) }
func (*MDResponse) ProtoMessage()    {}
func (*MDResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{15}
}

func (m *MDResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MDResponse.Unmarshal(m, b)
}
func (m *MDResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MDResponse.Marshal(b, m, deterministic)
}
func (m *MDResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MDResponse.Merge(m, src)
}
func (m *MDResponse) XXX_Size() int {
	return xxx_messageInfo_MDResponse.Size(m)
}
func (m *MDResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MDResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MDResponse proto.InternalMessageInfo

func (m *MDResponse) GetType() TYPE {
	if m != nil {
		return m.Type
	}
	return TYPE_FILE
}

func (m *MDResponse) GetFmd() *FileMdProto {
	if m != nil {
		return m.Fmd
	}
	return nil
}

func (m *MDResponse) GetCmd() *ContainerMdProto {
	if m != nil {
		return m.Cmd
	}
	return nil
}

type FindRequest struct {
	Type                 TYPE         `protobuf:"varint,1,opt,name=type,proto3,enum=eos.rpc.TYPE" json:"type,omitempty"`
	Id                   *MDId        `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	Role                 *RoleId      `protobuf:"bytes,3,opt,name=role,proto3" json:"role,omitempty"`
	Authkey              string       `protobuf:"bytes,4,opt,name=authkey,proto3" json:"authkey,omitempty"`
	Maxdepth             uint64       `protobuf:"varint,5,opt,name=maxdepth,proto3" json:"maxdepth,omitempty"`
	Selection            *MDSelection `protobuf:"bytes,6,opt,name=selection,proto3" json:"selection,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *FindRequest) Reset()         { *m = FindRequest{} }
func (m *FindRequest) String() string { return proto.CompactTextString(m) }
func (*FindRequest) ProtoMessage()    {}
func (*FindRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{16}
}

func (m *FindRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FindRequest.Unmarshal(m, b)
}
func (m *FindRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FindRequest.Marshal(b, m, deterministic)
}
func (m *FindRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FindRequest.Merge(m, src)
}
func (m *FindRequest) XXX_Size() int {
	return xxx_messageInfo_FindRequest.Size(m)
}
func (m *FindRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FindRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FindRequest proto.InternalMessageInfo

func (m *FindRequest) GetType() TYPE {
	if m != nil {
		return m.Type
	}
	return TYPE_FILE
}

func (m *FindRequest) GetId() *MDId {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *FindRequest) GetRole() *RoleId {
	if m != nil {
		return m.Role
	}
	return nil
}

func (m *FindRequest) GetAuthkey() string {
	if m != nil {
		return m.Authkey
	}
	return ""
}

func (m *FindRequest) GetMaxdepth() uint64 {
	if m != nil {
		return m.Maxdepth
	}
	return 0
}

func (m *FindRequest) GetSelection() *MDSelection {
	if m != nil {
		return m.Selection
	}
	return nil
}

type ShareAuth struct {
	Prot                 string   `protobuf:"bytes,1,opt,name=prot,proto3" json:"prot,omitempty"`
	Name                 string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Host                 string   `protobuf:"bytes,3,opt,name=host,proto3" json:"host,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShareAuth) Reset()         { *m = ShareAuth{} }
func (m *ShareAuth) String() string { return proto.CompactTextString(m) }
func (*ShareAuth) ProtoMessage()    {}
func (*ShareAuth) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{17}
}

func (m *ShareAuth) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShareAuth.Unmarshal(m, b)
}
func (m *ShareAuth) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShareAuth.Marshal(b, m, deterministic)
}
func (m *ShareAuth) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShareAuth.Merge(m, src)
}
func (m *ShareAuth) XXX_Size() int {
	return xxx_messageInfo_ShareAuth.Size(m)
}
func (m *ShareAuth) XXX_DiscardUnknown() {
	xxx_messageInfo_ShareAuth.DiscardUnknown(m)
}

var xxx_messageInfo_ShareAuth proto.InternalMessageInfo

func (m *ShareAuth) GetProt() string {
	if m != nil {
		return m.Prot
	}
	return ""
}

func (m *ShareAuth) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ShareAuth) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

type ShareProto struct {
	Permission           string       `protobuf:"bytes,1,opt,name=permission,proto3" json:"permission,omitempty"`
	Expires              uint64       `protobuf:"varint,2,opt,name=expires,proto3" json:"expires,omitempty"`
	Owner                string       `protobuf:"bytes,3,opt,name=owner,proto3" json:"owner,omitempty"`
	Group                string       `protobuf:"bytes,4,opt,name=group,proto3" json:"group,omitempty"`
	Generation           uint64       `protobuf:"varint,5,opt,name=generation,proto3" json:"generation,omitempty"`
	Path                 string       `protobuf:"bytes,6,opt,name=path,proto3" json:"path,omitempty"`
	Allowtree            bool         `protobuf:"varint,7,opt,name=allowtree,proto3" json:"allowtree,omitempty"`
	Vtoken               string       `protobuf:"bytes,8,opt,name=vtoken,proto3" json:"vtoken,omitempty"`
	Origins              []*ShareAuth `protobuf:"bytes,9,rep,name=origins,proto3" json:"origins,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *ShareProto) Reset()         { *m = ShareProto{} }
func (m *ShareProto) String() string { return proto.CompactTextString(m) }
func (*ShareProto) ProtoMessage()    {}
func (*ShareProto) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{18}
}

func (m *ShareProto) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShareProto.Unmarshal(m, b)
}
func (m *ShareProto) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShareProto.Marshal(b, m, deterministic)
}
func (m *ShareProto) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShareProto.Merge(m, src)
}
func (m *ShareProto) XXX_Size() int {
	return xxx_messageInfo_ShareProto.Size(m)
}
func (m *ShareProto) XXX_DiscardUnknown() {
	xxx_messageInfo_ShareProto.DiscardUnknown(m)
}

var xxx_messageInfo_ShareProto proto.InternalMessageInfo

func (m *ShareProto) GetPermission() string {
	if m != nil {
		return m.Permission
	}
	return ""
}

func (m *ShareProto) GetExpires() uint64 {
	if m != nil {
		return m.Expires
	}
	return 0
}

func (m *ShareProto) GetOwner() string {
	if m != nil {
		return m.Owner
	}
	return ""
}

func (m *ShareProto) GetGroup() string {
	if m != nil {
		return m.Group
	}
	return ""
}

func (m *ShareProto) GetGeneration() uint64 {
	if m != nil {
		return m.Generation
	}
	return 0
}

func (m *ShareProto) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *ShareProto) GetAllowtree() bool {
	if m != nil {
		return m.Allowtree
	}
	return false
}

func (m *ShareProto) GetVtoken() string {
	if m != nil {
		return m.Vtoken
	}
	return ""
}

func (m *ShareProto) GetOrigins() []*ShareAuth {
	if m != nil {
		return m.Origins
	}
	return nil
}

type ShareToken struct {
	Token                *ShareProto `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	Signature            []byte      `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
	Serialized           []byte      `protobuf:"bytes,3,opt,name=serialized,proto3" json:"serialized,omitempty"`
	Seed                 int32       `protobuf:"varint,4,opt,name=seed,proto3" json:"seed,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ShareToken) Reset()         { *m = ShareToken{} }
func (m *ShareToken) String() string { return proto.CompactTextString(m) }
func (*ShareToken) ProtoMessage()    {}
func (*ShareToken) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{19}
}

func (m *ShareToken) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShareToken.Unmarshal(m, b)
}
func (m *ShareToken) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShareToken.Marshal(b, m, deterministic)
}
func (m *ShareToken) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShareToken.Merge(m, src)
}
func (m *ShareToken) XXX_Size() int {
	return xxx_messageInfo_ShareToken.Size(m)
}
func (m *ShareToken) XXX_DiscardUnknown() {
	xxx_messageInfo_ShareToken.DiscardUnknown(m)
}

var xxx_messageInfo_ShareToken proto.InternalMessageInfo

func (m *ShareToken) GetToken() *ShareProto {
	if m != nil {
		return m.Token
	}
	return nil
}

func (m *ShareToken) GetSignature() []byte {
	if m != nil {
		return m.Signature
	}
	return nil
}

func (m *ShareToken) GetSerialized() []byte {
	if m != nil {
		return m.Serialized
	}
	return nil
}

func (m *ShareToken) GetSeed() int32 {
	if m != nil {
		return m.Seed
	}
	return 0
}

type NSRequest struct {
	Authkey string  `protobuf:"bytes,1,opt,name=authkey,proto3" json:"authkey,omitempty"`
	Role    *RoleId `protobuf:"bytes,2,opt,name=role,proto3" json:"role,omitempty"`
	// Actual request data object
	//
	// Types that are valid to be assigned to Command:
	//	*NSRequest_Mkdir
	//	*NSRequest_Rmdir
	//	*NSRequest_Touch
	//	*NSRequest_Unlink
	//	*NSRequest_Rm
	//	*NSRequest_Rename
	//	*NSRequest_Symlink
	//	*NSRequest_Version
	//	*NSRequest_Recycle
	//	*NSRequest_Xattr
	//	*NSRequest_Chown
	//	*NSRequest_Chmod
	//	*NSRequest_Acl
	//	*NSRequest_Token
	//	*NSRequest_Quota
	Command              isNSRequest_Command `protobuf_oneof:"command"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *NSRequest) Reset()         { *m = NSRequest{} }
func (m *NSRequest) String() string { return proto.CompactTextString(m) }
func (*NSRequest) ProtoMessage()    {}
func (*NSRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{20}
}

func (m *NSRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSRequest.Unmarshal(m, b)
}
func (m *NSRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSRequest.Marshal(b, m, deterministic)
}
func (m *NSRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSRequest.Merge(m, src)
}
func (m *NSRequest) XXX_Size() int {
	return xxx_messageInfo_NSRequest.Size(m)
}
func (m *NSRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NSRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NSRequest proto.InternalMessageInfo

func (m *NSRequest) GetAuthkey() string {
	if m != nil {
		return m.Authkey
	}
	return ""
}

func (m *NSRequest) GetRole() *RoleId {
	if m != nil {
		return m.Role
	}
	return nil
}

type isNSRequest_Command interface {
	isNSRequest_Command()
}

type NSRequest_Mkdir struct {
	Mkdir *NSRequest_MkdirRequest `protobuf:"bytes,21,opt,name=mkdir,proto3,oneof"`
}

type NSRequest_Rmdir struct {
	Rmdir *NSRequest_RmdirRequest `protobuf:"bytes,22,opt,name=rmdir,proto3,oneof"`
}

type NSRequest_Touch struct {
	Touch *NSRequest_TouchRequest `protobuf:"bytes,23,opt,name=touch,proto3,oneof"`
}

type NSRequest_Unlink struct {
	Unlink *NSRequest_UnlinkRequest `protobuf:"bytes,24,opt,name=unlink,proto3,oneof"`
}

type NSRequest_Rm struct {
	Rm *NSRequest_RmRequest `protobuf:"bytes,25,opt,name=rm,proto3,oneof"`
}

type NSRequest_Rename struct {
	Rename *NSRequest_RenameRequest `protobuf:"bytes,26,opt,name=rename,proto3,oneof"`
}

type NSRequest_Symlink struct {
	Symlink *NSRequest_SymlinkRequest `protobuf:"bytes,27,opt,name=symlink,proto3,oneof"`
}

type NSRequest_Version struct {
	Version *NSRequest_VersionRequest `protobuf:"bytes,28,opt,name=version,proto3,oneof"`
}

type NSRequest_Recycle struct {
	Recycle *NSRequest_RecycleRequest `protobuf:"bytes,29,opt,name=recycle,proto3,oneof"`
}

type NSRequest_Xattr struct {
	Xattr *NSRequest_SetXAttrRequest `protobuf:"bytes,30,opt,name=xattr,proto3,oneof"`
}

type NSRequest_Chown struct {
	Chown *NSRequest_ChownRequest `protobuf:"bytes,31,opt,name=chown,proto3,oneof"`
}

type NSRequest_Chmod struct {
	Chmod *NSRequest_ChmodRequest `protobuf:"bytes,32,opt,name=chmod,proto3,oneof"`
}

type NSRequest_Acl struct {
	Acl *NSRequest_AclRequest `protobuf:"bytes,33,opt,name=acl,proto3,oneof"`
}

type NSRequest_Token struct {
	Token *NSRequest_TokenRequest `protobuf:"bytes,34,opt,name=token,proto3,oneof"`
}

type NSRequest_Quota struct {
	Quota *NSRequest_QuotaRequest `protobuf:"bytes,35,opt,name=quota,proto3,oneof"`
}

func (*NSRequest_Mkdir) isNSRequest_Command() {}

func (*NSRequest_Rmdir) isNSRequest_Command() {}

func (*NSRequest_Touch) isNSRequest_Command() {}

func (*NSRequest_Unlink) isNSRequest_Command() {}

func (*NSRequest_Rm) isNSRequest_Command() {}

func (*NSRequest_Rename) isNSRequest_Command() {}

func (*NSRequest_Symlink) isNSRequest_Command() {}

func (*NSRequest_Version) isNSRequest_Command() {}

func (*NSRequest_Recycle) isNSRequest_Command() {}

func (*NSRequest_Xattr) isNSRequest_Command() {}

func (*NSRequest_Chown) isNSRequest_Command() {}

func (*NSRequest_Chmod) isNSRequest_Command() {}

func (*NSRequest_Acl) isNSRequest_Command() {}

func (*NSRequest_Token) isNSRequest_Command() {}

func (*NSRequest_Quota) isNSRequest_Command() {}

func (m *NSRequest) GetCommand() isNSRequest_Command {
	if m != nil {
		return m.Command
	}
	return nil
}

func (m *NSRequest) GetMkdir() *NSRequest_MkdirRequest {
	if x, ok := m.GetCommand().(*NSRequest_Mkdir); ok {
		return x.Mkdir
	}
	return nil
}

func (m *NSRequest) GetRmdir() *NSRequest_RmdirRequest {
	if x, ok := m.GetCommand().(*NSRequest_Rmdir); ok {
		return x.Rmdir
	}
	return nil
}

func (m *NSRequest) GetTouch() *NSRequest_TouchRequest {
	if x, ok := m.GetCommand().(*NSRequest_Touch); ok {
		return x.Touch
	}
	return nil
}

func (m *NSRequest) GetUnlink() *NSRequest_UnlinkRequest {
	if x, ok := m.GetCommand().(*NSRequest_Unlink); ok {
		return x.Unlink
	}
	return nil
}

func (m *NSRequest) GetRm() *NSRequest_RmRequest {
	if x, ok := m.GetCommand().(*NSRequest_Rm); ok {
		return x.Rm
	}
	return nil
}

func (m *NSRequest) GetRename() *NSRequest_RenameRequest {
	if x, ok := m.GetCommand().(*NSRequest_Rename); ok {
		return x.Rename
	}
	return nil
}

func (m *NSRequest) GetSymlink() *NSRequest_SymlinkRequest {
	if x, ok := m.GetCommand().(*NSRequest_Symlink); ok {
		return x.Symlink
	}
	return nil
}

func (m *NSRequest) GetVersion() *NSRequest_VersionRequest {
	if x, ok := m.GetCommand().(*NSRequest_Version); ok {
		return x.Version
	}
	return nil
}

func (m *NSRequest) GetRecycle() *NSRequest_RecycleRequest {
	if x, ok := m.GetCommand().(*NSRequest_Recycle); ok {
		return x.Recycle
	}
	return nil
}

func (m *NSRequest) GetXattr() *NSRequest_SetXAttrRequest {
	if x, ok := m.GetCommand().(*NSRequest_Xattr); ok {
		return x.Xattr
	}
	return nil
}

func (m *NSRequest) GetChown() *NSRequest_ChownRequest {
	if x, ok := m.GetCommand().(*NSRequest_Chown); ok {
		return x.Chown
	}
	return nil
}

func (m *NSRequest) GetChmod() *NSRequest_ChmodRequest {
	if x, ok := m.GetCommand().(*NSRequest_Chmod); ok {
		return x.Chmod
	}
	return nil
}

func (m *NSRequest) GetAcl() *NSRequest_AclRequest {
	if x, ok := m.GetCommand().(*NSRequest_Acl); ok {
		return x.Acl
	}
	return nil
}

func (m *NSRequest) GetToken() *NSRequest_TokenRequest {
	if x, ok := m.GetCommand().(*NSRequest_Token); ok {
		return x.Token
	}
	return nil
}

func (m *NSRequest) GetQuota() *NSRequest_QuotaRequest {
	if x, ok := m.GetCommand().(*NSRequest_Quota); ok {
		return x.Quota
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*NSRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*NSRequest_Mkdir)(nil),
		(*NSRequest_Rmdir)(nil),
		(*NSRequest_Touch)(nil),
		(*NSRequest_Unlink)(nil),
		(*NSRequest_Rm)(nil),
		(*NSRequest_Rename)(nil),
		(*NSRequest_Symlink)(nil),
		(*NSRequest_Version)(nil),
		(*NSRequest_Recycle)(nil),
		(*NSRequest_Xattr)(nil),
		(*NSRequest_Chown)(nil),
		(*NSRequest_Chmod)(nil),
		(*NSRequest_Acl)(nil),
		(*NSRequest_Token)(nil),
		(*NSRequest_Quota)(nil),
	}
}

type NSRequest_MkdirRequest struct {
	Id                   *MDId    `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Recursive            bool     `protobuf:"varint,2,opt,name=recursive,proto3" json:"recursive,omitempty"`
	Mode                 int64    `protobuf:"varint,3,opt,name=mode,proto3" json:"mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NSRequest_MkdirRequest) Reset()         { *m = NSRequest_MkdirRequest{} }
func (m *NSRequest_MkdirRequest) String() string { return proto.CompactTextString(m) }
func (*NSRequest_MkdirRequest) ProtoMessage()    {}
func (*NSRequest_MkdirRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{20, 0}
}

func (m *NSRequest_MkdirRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSRequest_MkdirRequest.Unmarshal(m, b)
}
func (m *NSRequest_MkdirRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSRequest_MkdirRequest.Marshal(b, m, deterministic)
}
func (m *NSRequest_MkdirRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSRequest_MkdirRequest.Merge(m, src)
}
func (m *NSRequest_MkdirRequest) XXX_Size() int {
	return xxx_messageInfo_NSRequest_MkdirRequest.Size(m)
}
func (m *NSRequest_MkdirRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NSRequest_MkdirRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NSRequest_MkdirRequest proto.InternalMessageInfo

func (m *NSRequest_MkdirRequest) GetId() *MDId {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *NSRequest_MkdirRequest) GetRecursive() bool {
	if m != nil {
		return m.Recursive
	}
	return false
}

func (m *NSRequest_MkdirRequest) GetMode() int64 {
	if m != nil {
		return m.Mode
	}
	return 0
}

type NSRequest_RmdirRequest struct {
	Id                   *MDId    `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NSRequest_RmdirRequest) Reset()         { *m = NSRequest_RmdirRequest{} }
func (m *NSRequest_RmdirRequest) String() string { return proto.CompactTextString(m) }
func (*NSRequest_RmdirRequest) ProtoMessage()    {}
func (*NSRequest_RmdirRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{20, 1}
}

func (m *NSRequest_RmdirRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSRequest_RmdirRequest.Unmarshal(m, b)
}
func (m *NSRequest_RmdirRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSRequest_RmdirRequest.Marshal(b, m, deterministic)
}
func (m *NSRequest_RmdirRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSRequest_RmdirRequest.Merge(m, src)
}
func (m *NSRequest_RmdirRequest) XXX_Size() int {
	return xxx_messageInfo_NSRequest_RmdirRequest.Size(m)
}
func (m *NSRequest_RmdirRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NSRequest_RmdirRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NSRequest_RmdirRequest proto.InternalMessageInfo

func (m *NSRequest_RmdirRequest) GetId() *MDId {
	if m != nil {
		return m.Id
	}
	return nil
}

type NSRequest_TouchRequest struct {
	Id                   *MDId    `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NSRequest_TouchRequest) Reset()         { *m = NSRequest_TouchRequest{} }
func (m *NSRequest_TouchRequest) String() string { return proto.CompactTextString(m) }
func (*NSRequest_TouchRequest) ProtoMessage()    {}
func (*NSRequest_TouchRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{20, 2}
}

func (m *NSRequest_TouchRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSRequest_TouchRequest.Unmarshal(m, b)
}
func (m *NSRequest_TouchRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSRequest_TouchRequest.Marshal(b, m, deterministic)
}
func (m *NSRequest_TouchRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSRequest_TouchRequest.Merge(m, src)
}
func (m *NSRequest_TouchRequest) XXX_Size() int {
	return xxx_messageInfo_NSRequest_TouchRequest.Size(m)
}
func (m *NSRequest_TouchRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NSRequest_TouchRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NSRequest_TouchRequest proto.InternalMessageInfo

func (m *NSRequest_TouchRequest) GetId() *MDId {
	if m != nil {
		return m.Id
	}
	return nil
}

type NSRequest_UnlinkRequest struct {
	Id                   *MDId    `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Norecycle            bool     `protobuf:"varint,3,opt,name=norecycle,proto3" json:"norecycle,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NSRequest_UnlinkRequest) Reset()         { *m = NSRequest_UnlinkRequest{} }
func (m *NSRequest_UnlinkRequest) String() string { return proto.CompactTextString(m) }
func (*NSRequest_UnlinkRequest) ProtoMessage()    {}
func (*NSRequest_UnlinkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{20, 3}
}

func (m *NSRequest_UnlinkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSRequest_UnlinkRequest.Unmarshal(m, b)
}
func (m *NSRequest_UnlinkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSRequest_UnlinkRequest.Marshal(b, m, deterministic)
}
func (m *NSRequest_UnlinkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSRequest_UnlinkRequest.Merge(m, src)
}
func (m *NSRequest_UnlinkRequest) XXX_Size() int {
	return xxx_messageInfo_NSRequest_UnlinkRequest.Size(m)
}
func (m *NSRequest_UnlinkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NSRequest_UnlinkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NSRequest_UnlinkRequest proto.InternalMessageInfo

func (m *NSRequest_UnlinkRequest) GetId() *MDId {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *NSRequest_UnlinkRequest) GetNorecycle() bool {
	if m != nil {
		return m.Norecycle
	}
	return false
}

type NSRequest_RmRequest struct {
	Id                   *MDId    `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Recursive            bool     `protobuf:"varint,2,opt,name=recursive,proto3" json:"recursive,omitempty"`
	Norecycle            bool     `protobuf:"varint,3,opt,name=norecycle,proto3" json:"norecycle,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NSRequest_RmRequest) Reset()         { *m = NSRequest_RmRequest{} }
func (m *NSRequest_RmRequest) String() string { return proto.CompactTextString(m) }
func (*NSRequest_RmRequest) ProtoMessage()    {}
func (*NSRequest_RmRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{20, 4}
}

func (m *NSRequest_RmRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSRequest_RmRequest.Unmarshal(m, b)
}
func (m *NSRequest_RmRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSRequest_RmRequest.Marshal(b, m, deterministic)
}
func (m *NSRequest_RmRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSRequest_RmRequest.Merge(m, src)
}
func (m *NSRequest_RmRequest) XXX_Size() int {
	return xxx_messageInfo_NSRequest_RmRequest.Size(m)
}
func (m *NSRequest_RmRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NSRequest_RmRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NSRequest_RmRequest proto.InternalMessageInfo

func (m *NSRequest_RmRequest) GetId() *MDId {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *NSRequest_RmRequest) GetRecursive() bool {
	if m != nil {
		return m.Recursive
	}
	return false
}

func (m *NSRequest_RmRequest) GetNorecycle() bool {
	if m != nil {
		return m.Norecycle
	}
	return false
}

type NSRequest_RenameRequest struct {
	Id                   *MDId    `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Target               []byte   `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NSRequest_RenameRequest) Reset()         { *m = NSRequest_RenameRequest{} }
func (m *NSRequest_RenameRequest) String() string { return proto.CompactTextString(m) }
func (*NSRequest_RenameRequest) ProtoMessage()    {}
func (*NSRequest_RenameRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{20, 5}
}

func (m *NSRequest_RenameRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSRequest_RenameRequest.Unmarshal(m, b)
}
func (m *NSRequest_RenameRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSRequest_RenameRequest.Marshal(b, m, deterministic)
}
func (m *NSRequest_RenameRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSRequest_RenameRequest.Merge(m, src)
}
func (m *NSRequest_RenameRequest) XXX_Size() int {
	return xxx_messageInfo_NSRequest_RenameRequest.Size(m)
}
func (m *NSRequest_RenameRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NSRequest_RenameRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NSRequest_RenameRequest proto.InternalMessageInfo

func (m *NSRequest_RenameRequest) GetId() *MDId {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *NSRequest_RenameRequest) GetTarget() []byte {
	if m != nil {
		return m.Target
	}
	return nil
}

type NSRequest_SymlinkRequest struct {
	Id                   *MDId    `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Target               []byte   `protobuf:"bytes,2,opt,name=target,proto3" json:"target,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NSRequest_SymlinkRequest) Reset()         { *m = NSRequest_SymlinkRequest{} }
func (m *NSRequest_SymlinkRequest) String() string { return proto.CompactTextString(m) }
func (*NSRequest_SymlinkRequest) ProtoMessage()    {}
func (*NSRequest_SymlinkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{20, 6}
}

func (m *NSRequest_SymlinkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSRequest_SymlinkRequest.Unmarshal(m, b)
}
func (m *NSRequest_SymlinkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSRequest_SymlinkRequest.Marshal(b, m, deterministic)
}
func (m *NSRequest_SymlinkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSRequest_SymlinkRequest.Merge(m, src)
}
func (m *NSRequest_SymlinkRequest) XXX_Size() int {
	return xxx_messageInfo_NSRequest_SymlinkRequest.Size(m)
}
func (m *NSRequest_SymlinkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NSRequest_SymlinkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NSRequest_SymlinkRequest proto.InternalMessageInfo

func (m *NSRequest_SymlinkRequest) GetId() *MDId {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *NSRequest_SymlinkRequest) GetTarget() []byte {
	if m != nil {
		return m.Target
	}
	return nil
}

type NSRequest_VersionRequest struct {
	Id                   *MDId                                `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Cmd                  NSRequest_VersionRequest_VERSION_CMD `protobuf:"varint,2,opt,name=cmd,proto3,enum=eos.rpc.NSRequest_VersionRequest_VERSION_CMD" json:"cmd,omitempty"`
	Maxversion           int32                                `protobuf:"varint,3,opt,name=maxversion,proto3" json:"maxversion,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *NSRequest_VersionRequest) Reset()         { *m = NSRequest_VersionRequest{} }
func (m *NSRequest_VersionRequest) String() string { return proto.CompactTextString(m) }
func (*NSRequest_VersionRequest) ProtoMessage()    {}
func (*NSRequest_VersionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{20, 7}
}

func (m *NSRequest_VersionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSRequest_VersionRequest.Unmarshal(m, b)
}
func (m *NSRequest_VersionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSRequest_VersionRequest.Marshal(b, m, deterministic)
}
func (m *NSRequest_VersionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSRequest_VersionRequest.Merge(m, src)
}
func (m *NSRequest_VersionRequest) XXX_Size() int {
	return xxx_messageInfo_NSRequest_VersionRequest.Size(m)
}
func (m *NSRequest_VersionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NSRequest_VersionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NSRequest_VersionRequest proto.InternalMessageInfo

func (m *NSRequest_VersionRequest) GetId() *MDId {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *NSRequest_VersionRequest) GetCmd() NSRequest_VersionRequest_VERSION_CMD {
	if m != nil {
		return m.Cmd
	}
	return NSRequest_VersionRequest_CREATE
}

func (m *NSRequest_VersionRequest) GetMaxversion() int32 {
	if m != nil {
		return m.Maxversion
	}
	return 0
}

type NSRequest_RecycleRequest struct {
	Key                  string                                 `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Cmd                  NSRequest_RecycleRequest_RECYCLE_CMD   `protobuf:"varint,2,opt,name=cmd,proto3,enum=eos.rpc.NSRequest_RecycleRequest_RECYCLE_CMD" json:"cmd,omitempty"`
	Restoreflag          *NSRequest_RecycleRequest_RestoreFlags `protobuf:"bytes,3,opt,name=restoreflag,proto3" json:"restoreflag,omitempty"`
	Purgedate            *NSRequest_RecycleRequest_PurgeDate    `protobuf:"bytes,4,opt,name=purgedate,proto3" json:"purgedate,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *NSRequest_RecycleRequest) Reset()         { *m = NSRequest_RecycleRequest{} }
func (m *NSRequest_RecycleRequest) String() string { return proto.CompactTextString(m) }
func (*NSRequest_RecycleRequest) ProtoMessage()    {}
func (*NSRequest_RecycleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{20, 8}
}

func (m *NSRequest_RecycleRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSRequest_RecycleRequest.Unmarshal(m, b)
}
func (m *NSRequest_RecycleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSRequest_RecycleRequest.Marshal(b, m, deterministic)
}
func (m *NSRequest_RecycleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSRequest_RecycleRequest.Merge(m, src)
}
func (m *NSRequest_RecycleRequest) XXX_Size() int {
	return xxx_messageInfo_NSRequest_RecycleRequest.Size(m)
}
func (m *NSRequest_RecycleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NSRequest_RecycleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NSRequest_RecycleRequest proto.InternalMessageInfo

func (m *NSRequest_RecycleRequest) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *NSRequest_RecycleRequest) GetCmd() NSRequest_RecycleRequest_RECYCLE_CMD {
	if m != nil {
		return m.Cmd
	}
	return NSRequest_RecycleRequest_RESTORE
}

func (m *NSRequest_RecycleRequest) GetRestoreflag() *NSRequest_RecycleRequest_RestoreFlags {
	if m != nil {
		return m.Restoreflag
	}
	return nil
}

func (m *NSRequest_RecycleRequest) GetPurgedate() *NSRequest_RecycleRequest_PurgeDate {
	if m != nil {
		return m.Purgedate
	}
	return nil
}

type NSRequest_RecycleRequest_RestoreFlags struct {
	Force                bool     `protobuf:"varint,1,opt,name=force,proto3" json:"force,omitempty"`
	Mkpath               bool     `protobuf:"varint,2,opt,name=mkpath,proto3" json:"mkpath,omitempty"`
	Versions             bool     `protobuf:"varint,3,opt,name=versions,proto3" json:"versions,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NSRequest_RecycleRequest_RestoreFlags) Reset()         { *m = NSRequest_RecycleRequest_RestoreFlags{} }
func (m *NSRequest_RecycleRequest_RestoreFlags) String() string { return proto.CompactTextString(m) }
func (*NSRequest_RecycleRequest_RestoreFlags) ProtoMessage()    {}
func (*NSRequest_RecycleRequest_RestoreFlags) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{20, 8, 0}
}

func (m *NSRequest_RecycleRequest_RestoreFlags) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSRequest_RecycleRequest_RestoreFlags.Unmarshal(m, b)
}
func (m *NSRequest_RecycleRequest_RestoreFlags) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSRequest_RecycleRequest_RestoreFlags.Marshal(b, m, deterministic)
}
func (m *NSRequest_RecycleRequest_RestoreFlags) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSRequest_RecycleRequest_RestoreFlags.Merge(m, src)
}
func (m *NSRequest_RecycleRequest_RestoreFlags) XXX_Size() int {
	return xxx_messageInfo_NSRequest_RecycleRequest_RestoreFlags.Size(m)
}
func (m *NSRequest_RecycleRequest_RestoreFlags) XXX_DiscardUnknown() {
	xxx_messageInfo_NSRequest_RecycleRequest_RestoreFlags.DiscardUnknown(m)
}

var xxx_messageInfo_NSRequest_RecycleRequest_RestoreFlags proto.InternalMessageInfo

func (m *NSRequest_RecycleRequest_RestoreFlags) GetForce() bool {
	if m != nil {
		return m.Force
	}
	return false
}

func (m *NSRequest_RecycleRequest_RestoreFlags) GetMkpath() bool {
	if m != nil {
		return m.Mkpath
	}
	return false
}

func (m *NSRequest_RecycleRequest_RestoreFlags) GetVersions() bool {
	if m != nil {
		return m.Versions
	}
	return false
}

type NSRequest_RecycleRequest_PurgeDate struct {
	Year                 int32    `protobuf:"varint,1,opt,name=year,proto3" json:"year,omitempty"`
	Month                int32    `protobuf:"varint,2,opt,name=month,proto3" json:"month,omitempty"`
	Day                  int32    `protobuf:"varint,3,opt,name=day,proto3" json:"day,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NSRequest_RecycleRequest_PurgeDate) Reset()         { *m = NSRequest_RecycleRequest_PurgeDate{} }
func (m *NSRequest_RecycleRequest_PurgeDate) String() string { return proto.CompactTextString(m) }
func (*NSRequest_RecycleRequest_PurgeDate) ProtoMessage()    {}
func (*NSRequest_RecycleRequest_PurgeDate) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{20, 8, 1}
}

func (m *NSRequest_RecycleRequest_PurgeDate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSRequest_RecycleRequest_PurgeDate.Unmarshal(m, b)
}
func (m *NSRequest_RecycleRequest_PurgeDate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSRequest_RecycleRequest_PurgeDate.Marshal(b, m, deterministic)
}
func (m *NSRequest_RecycleRequest_PurgeDate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSRequest_RecycleRequest_PurgeDate.Merge(m, src)
}
func (m *NSRequest_RecycleRequest_PurgeDate) XXX_Size() int {
	return xxx_messageInfo_NSRequest_RecycleRequest_PurgeDate.Size(m)
}
func (m *NSRequest_RecycleRequest_PurgeDate) XXX_DiscardUnknown() {
	xxx_messageInfo_NSRequest_RecycleRequest_PurgeDate.DiscardUnknown(m)
}

var xxx_messageInfo_NSRequest_RecycleRequest_PurgeDate proto.InternalMessageInfo

func (m *NSRequest_RecycleRequest_PurgeDate) GetYear() int32 {
	if m != nil {
		return m.Year
	}
	return 0
}

func (m *NSRequest_RecycleRequest_PurgeDate) GetMonth() int32 {
	if m != nil {
		return m.Month
	}
	return 0
}

func (m *NSRequest_RecycleRequest_PurgeDate) GetDay() int32 {
	if m != nil {
		return m.Day
	}
	return 0
}

type NSRequest_SetXAttrRequest struct {
	Id                   *MDId             `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Xattrs               map[string][]byte `protobuf:"bytes,2,rep,name=xattrs,proto3" json:"xattrs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Recursive            bool              `protobuf:"varint,3,opt,name=recursive,proto3" json:"recursive,omitempty"`
	Keystodelete         []string          `protobuf:"bytes,4,rep,name=keystodelete,proto3" json:"keystodelete,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *NSRequest_SetXAttrRequest) Reset()         { *m = NSRequest_SetXAttrRequest{} }
func (m *NSRequest_SetXAttrRequest) String() string { return proto.CompactTextString(m) }
func (*NSRequest_SetXAttrRequest) ProtoMessage()    {}
func (*NSRequest_SetXAttrRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{20, 9}
}

func (m *NSRequest_SetXAttrRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSRequest_SetXAttrRequest.Unmarshal(m, b)
}
func (m *NSRequest_SetXAttrRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSRequest_SetXAttrRequest.Marshal(b, m, deterministic)
}
func (m *NSRequest_SetXAttrRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSRequest_SetXAttrRequest.Merge(m, src)
}
func (m *NSRequest_SetXAttrRequest) XXX_Size() int {
	return xxx_messageInfo_NSRequest_SetXAttrRequest.Size(m)
}
func (m *NSRequest_SetXAttrRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NSRequest_SetXAttrRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NSRequest_SetXAttrRequest proto.InternalMessageInfo

func (m *NSRequest_SetXAttrRequest) GetId() *MDId {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *NSRequest_SetXAttrRequest) GetXattrs() map[string][]byte {
	if m != nil {
		return m.Xattrs
	}
	return nil
}

func (m *NSRequest_SetXAttrRequest) GetRecursive() bool {
	if m != nil {
		return m.Recursive
	}
	return false
}

func (m *NSRequest_SetXAttrRequest) GetKeystodelete() []string {
	if m != nil {
		return m.Keystodelete
	}
	return nil
}

type NSRequest_ChownRequest struct {
	Id                   *MDId    `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Owner                *RoleId  `protobuf:"bytes,2,opt,name=owner,proto3" json:"owner,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NSRequest_ChownRequest) Reset()         { *m = NSRequest_ChownRequest{} }
func (m *NSRequest_ChownRequest) String() string { return proto.CompactTextString(m) }
func (*NSRequest_ChownRequest) ProtoMessage()    {}
func (*NSRequest_ChownRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{20, 10}
}

func (m *NSRequest_ChownRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSRequest_ChownRequest.Unmarshal(m, b)
}
func (m *NSRequest_ChownRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSRequest_ChownRequest.Marshal(b, m, deterministic)
}
func (m *NSRequest_ChownRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSRequest_ChownRequest.Merge(m, src)
}
func (m *NSRequest_ChownRequest) XXX_Size() int {
	return xxx_messageInfo_NSRequest_ChownRequest.Size(m)
}
func (m *NSRequest_ChownRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NSRequest_ChownRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NSRequest_ChownRequest proto.InternalMessageInfo

func (m *NSRequest_ChownRequest) GetId() *MDId {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *NSRequest_ChownRequest) GetOwner() *RoleId {
	if m != nil {
		return m.Owner
	}
	return nil
}

type NSRequest_ChmodRequest struct {
	Id                   *MDId    `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Mode                 int64    `protobuf:"varint,2,opt,name=mode,proto3" json:"mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NSRequest_ChmodRequest) Reset()         { *m = NSRequest_ChmodRequest{} }
func (m *NSRequest_ChmodRequest) String() string { return proto.CompactTextString(m) }
func (*NSRequest_ChmodRequest) ProtoMessage()    {}
func (*NSRequest_ChmodRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{20, 11}
}

func (m *NSRequest_ChmodRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSRequest_ChmodRequest.Unmarshal(m, b)
}
func (m *NSRequest_ChmodRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSRequest_ChmodRequest.Marshal(b, m, deterministic)
}
func (m *NSRequest_ChmodRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSRequest_ChmodRequest.Merge(m, src)
}
func (m *NSRequest_ChmodRequest) XXX_Size() int {
	return xxx_messageInfo_NSRequest_ChmodRequest.Size(m)
}
func (m *NSRequest_ChmodRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NSRequest_ChmodRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NSRequest_ChmodRequest proto.InternalMessageInfo

func (m *NSRequest_ChmodRequest) GetId() *MDId {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *NSRequest_ChmodRequest) GetMode() int64 {
	if m != nil {
		return m.Mode
	}
	return 0
}

type NSRequest_AclRequest struct {
	Id                   *MDId                            `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Cmd                  NSRequest_AclRequest_ACL_COMMAND `protobuf:"varint,2,opt,name=cmd,proto3,enum=eos.rpc.NSRequest_AclRequest_ACL_COMMAND" json:"cmd,omitempty"`
	Recursive            bool                             `protobuf:"varint,3,opt,name=recursive,proto3" json:"recursive,omitempty"`
	Type                 NSRequest_AclRequest_ACL_TYPE    `protobuf:"varint,4,opt,name=type,proto3,enum=eos.rpc.NSRequest_AclRequest_ACL_TYPE" json:"type,omitempty"`
	Rule                 string                           `protobuf:"bytes,5,opt,name=rule,proto3" json:"rule,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *NSRequest_AclRequest) Reset()         { *m = NSRequest_AclRequest{} }
func (m *NSRequest_AclRequest) String() string { return proto.CompactTextString(m) }
func (*NSRequest_AclRequest) ProtoMessage()    {}
func (*NSRequest_AclRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{20, 12}
}

func (m *NSRequest_AclRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSRequest_AclRequest.Unmarshal(m, b)
}
func (m *NSRequest_AclRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSRequest_AclRequest.Marshal(b, m, deterministic)
}
func (m *NSRequest_AclRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSRequest_AclRequest.Merge(m, src)
}
func (m *NSRequest_AclRequest) XXX_Size() int {
	return xxx_messageInfo_NSRequest_AclRequest.Size(m)
}
func (m *NSRequest_AclRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NSRequest_AclRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NSRequest_AclRequest proto.InternalMessageInfo

func (m *NSRequest_AclRequest) GetId() *MDId {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *NSRequest_AclRequest) GetCmd() NSRequest_AclRequest_ACL_COMMAND {
	if m != nil {
		return m.Cmd
	}
	return NSRequest_AclRequest_NONE
}

func (m *NSRequest_AclRequest) GetRecursive() bool {
	if m != nil {
		return m.Recursive
	}
	return false
}

func (m *NSRequest_AclRequest) GetType() NSRequest_AclRequest_ACL_TYPE {
	if m != nil {
		return m.Type
	}
	return NSRequest_AclRequest_USER_ACL
}

func (m *NSRequest_AclRequest) GetRule() string {
	if m != nil {
		return m.Rule
	}
	return ""
}

type NSRequest_TokenRequest struct {
	Token                *ShareToken `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *NSRequest_TokenRequest) Reset()         { *m = NSRequest_TokenRequest{} }
func (m *NSRequest_TokenRequest) String() string { return proto.CompactTextString(m) }
func (*NSRequest_TokenRequest) ProtoMessage()    {}
func (*NSRequest_TokenRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{20, 13}
}

func (m *NSRequest_TokenRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSRequest_TokenRequest.Unmarshal(m, b)
}
func (m *NSRequest_TokenRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSRequest_TokenRequest.Marshal(b, m, deterministic)
}
func (m *NSRequest_TokenRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSRequest_TokenRequest.Merge(m, src)
}
func (m *NSRequest_TokenRequest) XXX_Size() int {
	return xxx_messageInfo_NSRequest_TokenRequest.Size(m)
}
func (m *NSRequest_TokenRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NSRequest_TokenRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NSRequest_TokenRequest proto.InternalMessageInfo

func (m *NSRequest_TokenRequest) GetToken() *ShareToken {
	if m != nil {
		return m.Token
	}
	return nil
}

type NSRequest_QuotaRequest struct {
	Path                 []byte     `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Id                   *RoleId    `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	Op                   QUOTAOP    `protobuf:"varint,3,opt,name=op,proto3,enum=eos.rpc.QUOTAOP" json:"op,omitempty"`
	Maxfiles             uint64     `protobuf:"varint,4,opt,name=maxfiles,proto3" json:"maxfiles,omitempty"`
	Maxbytes             uint64     `protobuf:"varint,5,opt,name=maxbytes,proto3" json:"maxbytes,omitempty"`
	Entry                QUOTAENTRY `protobuf:"varint,6,opt,name=entry,proto3,enum=eos.rpc.QUOTAENTRY" json:"entry,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *NSRequest_QuotaRequest) Reset()         { *m = NSRequest_QuotaRequest{} }
func (m *NSRequest_QuotaRequest) String() string { return proto.CompactTextString(m) }
func (*NSRequest_QuotaRequest) ProtoMessage()    {}
func (*NSRequest_QuotaRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{20, 14}
}

func (m *NSRequest_QuotaRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSRequest_QuotaRequest.Unmarshal(m, b)
}
func (m *NSRequest_QuotaRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSRequest_QuotaRequest.Marshal(b, m, deterministic)
}
func (m *NSRequest_QuotaRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSRequest_QuotaRequest.Merge(m, src)
}
func (m *NSRequest_QuotaRequest) XXX_Size() int {
	return xxx_messageInfo_NSRequest_QuotaRequest.Size(m)
}
func (m *NSRequest_QuotaRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NSRequest_QuotaRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NSRequest_QuotaRequest proto.InternalMessageInfo

func (m *NSRequest_QuotaRequest) GetPath() []byte {
	if m != nil {
		return m.Path
	}
	return nil
}

func (m *NSRequest_QuotaRequest) GetId() *RoleId {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *NSRequest_QuotaRequest) GetOp() QUOTAOP {
	if m != nil {
		return m.Op
	}
	return QUOTAOP_GET
}

func (m *NSRequest_QuotaRequest) GetMaxfiles() uint64 {
	if m != nil {
		return m.Maxfiles
	}
	return 0
}

func (m *NSRequest_QuotaRequest) GetMaxbytes() uint64 {
	if m != nil {
		return m.Maxbytes
	}
	return 0
}

func (m *NSRequest_QuotaRequest) GetEntry() QUOTAENTRY {
	if m != nil {
		return m.Entry
	}
	return QUOTAENTRY_NONE
}

type NSResponse struct {
	Error                *NSResponse_ErrorResponse   `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	Version              *NSResponse_VersionResponse `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	Recycle              *NSResponse_RecycleResponse `protobuf:"bytes,3,opt,name=recycle,proto3" json:"recycle,omitempty"`
	Acl                  *NSResponse_AclResponse     `protobuf:"bytes,4,opt,name=acl,proto3" json:"acl,omitempty"`
	Quota                *NSResponse_QuotaResponse   `protobuf:"bytes,5,opt,name=quota,proto3" json:"quota,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *NSResponse) Reset()         { *m = NSResponse{} }
func (m *NSResponse) String() string { return proto.CompactTextString(m) }
func (*NSResponse) ProtoMessage()    {}
func (*NSResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{21}
}

func (m *NSResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSResponse.Unmarshal(m, b)
}
func (m *NSResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSResponse.Marshal(b, m, deterministic)
}
func (m *NSResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSResponse.Merge(m, src)
}
func (m *NSResponse) XXX_Size() int {
	return xxx_messageInfo_NSResponse.Size(m)
}
func (m *NSResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NSResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NSResponse proto.InternalMessageInfo

func (m *NSResponse) GetError() *NSResponse_ErrorResponse {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *NSResponse) GetVersion() *NSResponse_VersionResponse {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *NSResponse) GetRecycle() *NSResponse_RecycleResponse {
	if m != nil {
		return m.Recycle
	}
	return nil
}

func (m *NSResponse) GetAcl() *NSResponse_AclResponse {
	if m != nil {
		return m.Acl
	}
	return nil
}

func (m *NSResponse) GetQuota() *NSResponse_QuotaResponse {
	if m != nil {
		return m.Quota
	}
	return nil
}

type NSResponse_ErrorResponse struct {
	Code                 int64    `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	Msg                  string   `protobuf:"bytes,2,opt,name=msg,proto3" json:"msg,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NSResponse_ErrorResponse) Reset()         { *m = NSResponse_ErrorResponse{} }
func (m *NSResponse_ErrorResponse) String() string { return proto.CompactTextString(m) }
func (*NSResponse_ErrorResponse) ProtoMessage()    {}
func (*NSResponse_ErrorResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{21, 0}
}

func (m *NSResponse_ErrorResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSResponse_ErrorResponse.Unmarshal(m, b)
}
func (m *NSResponse_ErrorResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSResponse_ErrorResponse.Marshal(b, m, deterministic)
}
func (m *NSResponse_ErrorResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSResponse_ErrorResponse.Merge(m, src)
}
func (m *NSResponse_ErrorResponse) XXX_Size() int {
	return xxx_messageInfo_NSResponse_ErrorResponse.Size(m)
}
func (m *NSResponse_ErrorResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NSResponse_ErrorResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NSResponse_ErrorResponse proto.InternalMessageInfo

func (m *NSResponse_ErrorResponse) GetCode() int64 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *NSResponse_ErrorResponse) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

type NSResponse_VersionResponse struct {
	Code                 int64                                     `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	Msg                  string                                    `protobuf:"bytes,2,opt,name=msg,proto3" json:"msg,omitempty"`
	Versions             []*NSResponse_VersionResponse_VersionInfo `protobuf:"bytes,3,rep,name=versions,proto3" json:"versions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *NSResponse_VersionResponse) Reset()         { *m = NSResponse_VersionResponse{} }
func (m *NSResponse_VersionResponse) String() string { return proto.CompactTextString(m) }
func (*NSResponse_VersionResponse) ProtoMessage()    {}
func (*NSResponse_VersionResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{21, 1}
}

func (m *NSResponse_VersionResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSResponse_VersionResponse.Unmarshal(m, b)
}
func (m *NSResponse_VersionResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSResponse_VersionResponse.Marshal(b, m, deterministic)
}
func (m *NSResponse_VersionResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSResponse_VersionResponse.Merge(m, src)
}
func (m *NSResponse_VersionResponse) XXX_Size() int {
	return xxx_messageInfo_NSResponse_VersionResponse.Size(m)
}
func (m *NSResponse_VersionResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NSResponse_VersionResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NSResponse_VersionResponse proto.InternalMessageInfo

func (m *NSResponse_VersionResponse) GetCode() int64 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *NSResponse_VersionResponse) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

func (m *NSResponse_VersionResponse) GetVersions() []*NSResponse_VersionResponse_VersionInfo {
	if m != nil {
		return m.Versions
	}
	return nil
}

type NSResponse_VersionResponse_VersionInfo struct {
	Id                   *MDId    `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Mtime                *Time    `protobuf:"bytes,2,opt,name=mtime,proto3" json:"mtime,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NSResponse_VersionResponse_VersionInfo) Reset() {
	*m = NSResponse_VersionResponse_VersionInfo{}
}
func (m *NSResponse_VersionResponse_VersionInfo) String() string { return proto.CompactTextString(m) }
func (*NSResponse_VersionResponse_VersionInfo) ProtoMessage()    {}
func (*NSResponse_VersionResponse_VersionInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{21, 1, 0}
}

func (m *NSResponse_VersionResponse_VersionInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSResponse_VersionResponse_VersionInfo.Unmarshal(m, b)
}
func (m *NSResponse_VersionResponse_VersionInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSResponse_VersionResponse_VersionInfo.Marshal(b, m, deterministic)
}
func (m *NSResponse_VersionResponse_VersionInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSResponse_VersionResponse_VersionInfo.Merge(m, src)
}
func (m *NSResponse_VersionResponse_VersionInfo) XXX_Size() int {
	return xxx_messageInfo_NSResponse_VersionResponse_VersionInfo.Size(m)
}
func (m *NSResponse_VersionResponse_VersionInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_NSResponse_VersionResponse_VersionInfo.DiscardUnknown(m)
}

var xxx_messageInfo_NSResponse_VersionResponse_VersionInfo proto.InternalMessageInfo

func (m *NSResponse_VersionResponse_VersionInfo) GetId() *MDId {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *NSResponse_VersionResponse_VersionInfo) GetMtime() *Time {
	if m != nil {
		return m.Mtime
	}
	return nil
}

type NSResponse_RecycleResponse struct {
	Code                 int64                                     `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	Msg                  string                                    `protobuf:"bytes,2,opt,name=msg,proto3" json:"msg,omitempty"`
	Recycles             []*NSResponse_RecycleResponse_RecycleInfo `protobuf:"bytes,3,rep,name=recycles,proto3" json:"recycles,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *NSResponse_RecycleResponse) Reset()         { *m = NSResponse_RecycleResponse{} }
func (m *NSResponse_RecycleResponse) String() string { return proto.CompactTextString(m) }
func (*NSResponse_RecycleResponse) ProtoMessage()    {}
func (*NSResponse_RecycleResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{21, 2}
}

func (m *NSResponse_RecycleResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSResponse_RecycleResponse.Unmarshal(m, b)
}
func (m *NSResponse_RecycleResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSResponse_RecycleResponse.Marshal(b, m, deterministic)
}
func (m *NSResponse_RecycleResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSResponse_RecycleResponse.Merge(m, src)
}
func (m *NSResponse_RecycleResponse) XXX_Size() int {
	return xxx_messageInfo_NSResponse_RecycleResponse.Size(m)
}
func (m *NSResponse_RecycleResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NSResponse_RecycleResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NSResponse_RecycleResponse proto.InternalMessageInfo

func (m *NSResponse_RecycleResponse) GetCode() int64 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *NSResponse_RecycleResponse) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

func (m *NSResponse_RecycleResponse) GetRecycles() []*NSResponse_RecycleResponse_RecycleInfo {
	if m != nil {
		return m.Recycles
	}
	return nil
}

type NSResponse_RecycleResponse_RecycleInfo struct {
	Id                   *MDId                                               `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Owner                *RoleId                                             `protobuf:"bytes,2,opt,name=owner,proto3" json:"owner,omitempty"`
	Dtime                *Time                                               `protobuf:"bytes,3,opt,name=dtime,proto3" json:"dtime,omitempty"`
	Size                 uint64                                              `protobuf:"varint,4,opt,name=size,proto3" json:"size,omitempty"`
	Type                 NSResponse_RecycleResponse_RecycleInfo_DELETIONTYPE `protobuf:"varint,5,opt,name=type,proto3,enum=eos.rpc.NSResponse_RecycleResponse_RecycleInfo_DELETIONTYPE" json:"type,omitempty"`
	Key                  string                                              `protobuf:"bytes,6,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                            `json:"-"`
	XXX_unrecognized     []byte                                              `json:"-"`
	XXX_sizecache        int32                                               `json:"-"`
}

func (m *NSResponse_RecycleResponse_RecycleInfo) Reset() {
	*m = NSResponse_RecycleResponse_RecycleInfo{}
}
func (m *NSResponse_RecycleResponse_RecycleInfo) String() string { return proto.CompactTextString(m) }
func (*NSResponse_RecycleResponse_RecycleInfo) ProtoMessage()    {}
func (*NSResponse_RecycleResponse_RecycleInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{21, 2, 0}
}

func (m *NSResponse_RecycleResponse_RecycleInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSResponse_RecycleResponse_RecycleInfo.Unmarshal(m, b)
}
func (m *NSResponse_RecycleResponse_RecycleInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSResponse_RecycleResponse_RecycleInfo.Marshal(b, m, deterministic)
}
func (m *NSResponse_RecycleResponse_RecycleInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSResponse_RecycleResponse_RecycleInfo.Merge(m, src)
}
func (m *NSResponse_RecycleResponse_RecycleInfo) XXX_Size() int {
	return xxx_messageInfo_NSResponse_RecycleResponse_RecycleInfo.Size(m)
}
func (m *NSResponse_RecycleResponse_RecycleInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_NSResponse_RecycleResponse_RecycleInfo.DiscardUnknown(m)
}

var xxx_messageInfo_NSResponse_RecycleResponse_RecycleInfo proto.InternalMessageInfo

func (m *NSResponse_RecycleResponse_RecycleInfo) GetId() *MDId {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *NSResponse_RecycleResponse_RecycleInfo) GetOwner() *RoleId {
	if m != nil {
		return m.Owner
	}
	return nil
}

func (m *NSResponse_RecycleResponse_RecycleInfo) GetDtime() *Time {
	if m != nil {
		return m.Dtime
	}
	return nil
}

func (m *NSResponse_RecycleResponse_RecycleInfo) GetSize() uint64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *NSResponse_RecycleResponse_RecycleInfo) GetType() NSResponse_RecycleResponse_RecycleInfo_DELETIONTYPE {
	if m != nil {
		return m.Type
	}
	return NSResponse_RecycleResponse_RecycleInfo_FILE
}

func (m *NSResponse_RecycleResponse_RecycleInfo) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

type NSResponse_AclResponse struct {
	Code                 int64    `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	Msg                  string   `protobuf:"bytes,2,opt,name=msg,proto3" json:"msg,omitempty"`
	Rule                 string   `protobuf:"bytes,3,opt,name=rule,proto3" json:"rule,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NSResponse_AclResponse) Reset()         { *m = NSResponse_AclResponse{} }
func (m *NSResponse_AclResponse) String() string { return proto.CompactTextString(m) }
func (*NSResponse_AclResponse) ProtoMessage()    {}
func (*NSResponse_AclResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{21, 3}
}

func (m *NSResponse_AclResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSResponse_AclResponse.Unmarshal(m, b)
}
func (m *NSResponse_AclResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSResponse_AclResponse.Marshal(b, m, deterministic)
}
func (m *NSResponse_AclResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSResponse_AclResponse.Merge(m, src)
}
func (m *NSResponse_AclResponse) XXX_Size() int {
	return xxx_messageInfo_NSResponse_AclResponse.Size(m)
}
func (m *NSResponse_AclResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NSResponse_AclResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NSResponse_AclResponse proto.InternalMessageInfo

func (m *NSResponse_AclResponse) GetCode() int64 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *NSResponse_AclResponse) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

func (m *NSResponse_AclResponse) GetRule() string {
	if m != nil {
		return m.Rule
	}
	return ""
}

type NSResponse_QuotaResponse struct {
	Code                 int64         `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	Msg                  string        `protobuf:"bytes,2,opt,name=msg,proto3" json:"msg,omitempty"`
	Quotanode            []*QuotaProto `protobuf:"bytes,3,rep,name=quotanode,proto3" json:"quotanode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *NSResponse_QuotaResponse) Reset()         { *m = NSResponse_QuotaResponse{} }
func (m *NSResponse_QuotaResponse) String() string { return proto.CompactTextString(m) }
func (*NSResponse_QuotaResponse) ProtoMessage()    {}
func (*NSResponse_QuotaResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{21, 4}
}

func (m *NSResponse_QuotaResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NSResponse_QuotaResponse.Unmarshal(m, b)
}
func (m *NSResponse_QuotaResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NSResponse_QuotaResponse.Marshal(b, m, deterministic)
}
func (m *NSResponse_QuotaResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NSResponse_QuotaResponse.Merge(m, src)
}
func (m *NSResponse_QuotaResponse) XXX_Size() int {
	return xxx_messageInfo_NSResponse_QuotaResponse.Size(m)
}
func (m *NSResponse_QuotaResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NSResponse_QuotaResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NSResponse_QuotaResponse proto.InternalMessageInfo

func (m *NSResponse_QuotaResponse) GetCode() int64 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *NSResponse_QuotaResponse) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

func (m *NSResponse_QuotaResponse) GetQuotanode() []*QuotaProto {
	if m != nil {
		return m.Quotanode
	}
	return nil
}

type NsStatRequest struct {
	Authkey              string   `protobuf:"bytes,1,opt,name=authkey,proto3" json:"authkey,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NsStatRequest) Reset()         { *m = NsStatRequest{} }
func (m *NsStatRequest) String() string { return proto.CompactTextString(m) }
func (*NsStatRequest) ProtoMessage()    {}
func (*NsStatRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{22}
}

func (m *NsStatRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NsStatRequest.Unmarshal(m, b)
}
func (m *NsStatRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NsStatRequest.Marshal(b, m, deterministic)
}
func (m *NsStatRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NsStatRequest.Merge(m, src)
}
func (m *NsStatRequest) XXX_Size() int {
	return xxx_messageInfo_NsStatRequest.Size(m)
}
func (m *NsStatRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_NsStatRequest.DiscardUnknown(m)
}

var xxx_messageInfo_NsStatRequest proto.InternalMessageInfo

func (m *NsStatRequest) GetAuthkey() string {
	if m != nil {
		return m.Authkey
	}
	return ""
}

type NsStatResponse struct {
	Code                 int64    `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	Emsg                 string   `protobuf:"bytes,2,opt,name=emsg,proto3" json:"emsg,omitempty"`
	State                string   `protobuf:"bytes,3,opt,name=state,proto3" json:"state,omitempty"`
	Nfiles               uint64   `protobuf:"varint,4,opt,name=nfiles,proto3" json:"nfiles,omitempty"`
	Ncontainers          uint64   `protobuf:"varint,5,opt,name=ncontainers,proto3" json:"ncontainers,omitempty"`
	BootTime             uint64   `protobuf:"varint,6,opt,name=boot_time,json=bootTime,proto3" json:"boot_time,omitempty"`
	CurrentFid           uint64   `protobuf:"varint,7,opt,name=current_fid,json=currentFid,proto3" json:"current_fid,omitempty"`
	CurrentCid           uint64   `protobuf:"varint,8,opt,name=current_cid,json=currentCid,proto3" json:"current_cid,omitempty"`
	MemVirtual           uint64   `protobuf:"varint,9,opt,name=mem_virtual,json=memVirtual,proto3" json:"mem_virtual,omitempty"`
	MemResident          uint64   `protobuf:"varint,10,opt,name=mem_resident,json=memResident,proto3" json:"mem_resident,omitempty"`
	MemShare             uint64   `protobuf:"varint,11,opt,name=mem_share,json=memShare,proto3" json:"mem_share,omitempty"`
	MemGrowth            uint64   `protobuf:"varint,12,opt,name=mem_growth,json=memGrowth,proto3" json:"mem_growth,omitempty"`
	Threads              uint64   `protobuf:"varint,13,opt,name=threads,proto3" json:"threads,omitempty"`
	Fds                  uint64   `protobuf:"varint,14,opt,name=fds,proto3" json:"fds,omitempty"`
	Uptime               uint64   `protobuf:"varint,15,opt,name=uptime,proto3" json:"uptime,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NsStatResponse) Reset()         { *m = NsStatResponse{} }
func (m *NsStatResponse) String() string { return proto.CompactTextString(m) }
func (*NsStatResponse) ProtoMessage()    {}
func (*NsStatResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{23}
}

func (m *NsStatResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NsStatResponse.Unmarshal(m, b)
}
func (m *NsStatResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NsStatResponse.Marshal(b, m, deterministic)
}
func (m *NsStatResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NsStatResponse.Merge(m, src)
}
func (m *NsStatResponse) XXX_Size() int {
	return xxx_messageInfo_NsStatResponse.Size(m)
}
func (m *NsStatResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_NsStatResponse.DiscardUnknown(m)
}

var xxx_messageInfo_NsStatResponse proto.InternalMessageInfo

func (m *NsStatResponse) GetCode() int64 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *NsStatResponse) GetEmsg() string {
	if m != nil {
		return m.Emsg
	}
	return ""
}

func (m *NsStatResponse) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

func (m *NsStatResponse) GetNfiles() uint64 {
	if m != nil {
		return m.Nfiles
	}
	return 0
}

func (m *NsStatResponse) GetNcontainers() uint64 {
	if m != nil {
		return m.Ncontainers
	}
	return 0
}

func (m *NsStatResponse) GetBootTime() uint64 {
	if m != nil {
		return m.BootTime
	}
	return 0
}

func (m *NsStatResponse) GetCurrentFid() uint64 {
	if m != nil {
		return m.CurrentFid
	}
	return 0
}

func (m *NsStatResponse) GetCurrentCid() uint64 {
	if m != nil {
		return m.CurrentCid
	}
	return 0
}

func (m *NsStatResponse) GetMemVirtual() uint64 {
	if m != nil {
		return m.MemVirtual
	}
	return 0
}

func (m *NsStatResponse) GetMemResident() uint64 {
	if m != nil {
		return m.MemResident
	}
	return 0
}

func (m *NsStatResponse) GetMemShare() uint64 {
	if m != nil {
		return m.MemShare
	}
	return 0
}

func (m *NsStatResponse) GetMemGrowth() uint64 {
	if m != nil {
		return m.MemGrowth
	}
	return 0
}

func (m *NsStatResponse) GetThreads() uint64 {
	if m != nil {
		return m.Threads
	}
	return 0
}

func (m *NsStatResponse) GetFds() uint64 {
	if m != nil {
		return m.Fds
	}
	return 0
}

func (m *NsStatResponse) GetUptime() uint64 {
	if m != nil {
		return m.Uptime
	}
	return 0
}

type ManilaRequest struct {
	RequestType          MANILA_REQUEST_TYPE `protobuf:"varint,1,opt,name=request_type,json=requestType,proto3,enum=eos.rpc.MANILA_REQUEST_TYPE" json:"request_type,omitempty"`
	AuthKey              string              `protobuf:"bytes,2,opt,name=auth_key,json=authKey,proto3" json:"auth_key,omitempty"`
	Protocol             string              `protobuf:"bytes,3,opt,name=protocol,proto3" json:"protocol,omitempty"`
	ShareName            string              `protobuf:"bytes,4,opt,name=share_name,json=shareName,proto3" json:"share_name,omitempty"`
	Description          string              `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	ShareId              string              `protobuf:"bytes,6,opt,name=share_id,json=shareId,proto3" json:"share_id,omitempty"`
	ShareGroupId         string              `protobuf:"bytes,7,opt,name=share_group_id,json=shareGroupId,proto3" json:"share_group_id,omitempty"`
	Quota                int32               `protobuf:"varint,8,opt,name=quota,proto3" json:"quota,omitempty"`
	Creator              string              `protobuf:"bytes,9,opt,name=creator,proto3" json:"creator,omitempty"`
	Egroup               string              `protobuf:"bytes,10,opt,name=egroup,proto3" json:"egroup,omitempty"`
	AdminEgroup          string              `protobuf:"bytes,11,opt,name=admin_egroup,json=adminEgroup,proto3" json:"admin_egroup,omitempty"`
	ShareHost            string              `protobuf:"bytes,12,opt,name=share_host,json=shareHost,proto3" json:"share_host,omitempty"`
	ShareLocation        string              `protobuf:"bytes,13,opt,name=share_location,json=shareLocation,proto3" json:"share_location,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ManilaRequest) Reset()         { *m = ManilaRequest{} }
func (m *ManilaRequest) String() string { return proto.CompactTextString(m) }
func (*ManilaRequest) ProtoMessage()    {}
func (*ManilaRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{24}
}

func (m *ManilaRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ManilaRequest.Unmarshal(m, b)
}
func (m *ManilaRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ManilaRequest.Marshal(b, m, deterministic)
}
func (m *ManilaRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ManilaRequest.Merge(m, src)
}
func (m *ManilaRequest) XXX_Size() int {
	return xxx_messageInfo_ManilaRequest.Size(m)
}
func (m *ManilaRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ManilaRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ManilaRequest proto.InternalMessageInfo

func (m *ManilaRequest) GetRequestType() MANILA_REQUEST_TYPE {
	if m != nil {
		return m.RequestType
	}
	return MANILA_REQUEST_TYPE_CREATE_SHARE
}

func (m *ManilaRequest) GetAuthKey() string {
	if m != nil {
		return m.AuthKey
	}
	return ""
}

func (m *ManilaRequest) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

func (m *ManilaRequest) GetShareName() string {
	if m != nil {
		return m.ShareName
	}
	return ""
}

func (m *ManilaRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *ManilaRequest) GetShareId() string {
	if m != nil {
		return m.ShareId
	}
	return ""
}

func (m *ManilaRequest) GetShareGroupId() string {
	if m != nil {
		return m.ShareGroupId
	}
	return ""
}

func (m *ManilaRequest) GetQuota() int32 {
	if m != nil {
		return m.Quota
	}
	return 0
}

func (m *ManilaRequest) GetCreator() string {
	if m != nil {
		return m.Creator
	}
	return ""
}

func (m *ManilaRequest) GetEgroup() string {
	if m != nil {
		return m.Egroup
	}
	return ""
}

func (m *ManilaRequest) GetAdminEgroup() string {
	if m != nil {
		return m.AdminEgroup
	}
	return ""
}

func (m *ManilaRequest) GetShareHost() string {
	if m != nil {
		return m.ShareHost
	}
	return ""
}

func (m *ManilaRequest) GetShareLocation() string {
	if m != nil {
		return m.ShareLocation
	}
	return ""
}

type ManilaResponse struct {
	Msg                  string   `protobuf:"bytes,1,opt,name=msg,proto3" json:"msg,omitempty"`
	Code                 int32    `protobuf:"varint,2,opt,name=code,proto3" json:"code,omitempty"`
	TotalUsed            int64    `protobuf:"varint,3,opt,name=total_used,json=totalUsed,proto3" json:"total_used,omitempty"`
	TotalCapacity        int64    `protobuf:"varint,4,opt,name=total_capacity,json=totalCapacity,proto3" json:"total_capacity,omitempty"`
	NewShareQuota        int64    `protobuf:"varint,5,opt,name=new_share_quota,json=newShareQuota,proto3" json:"new_share_quota,omitempty"`
	NewSharePath         string   `protobuf:"bytes,6,opt,name=new_share_path,json=newSharePath,proto3" json:"new_share_path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ManilaResponse) Reset()         { *m = ManilaResponse{} }
func (m *ManilaResponse) String() string { return proto.CompactTextString(m) }
func (*ManilaResponse) ProtoMessage()    {}
func (*ManilaResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_979aee4989bceb08, []int{25}
}

func (m *ManilaResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ManilaResponse.Unmarshal(m, b)
}
func (m *ManilaResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ManilaResponse.Marshal(b, m, deterministic)
}
func (m *ManilaResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ManilaResponse.Merge(m, src)
}
func (m *ManilaResponse) XXX_Size() int {
	return xxx_messageInfo_ManilaResponse.Size(m)
}
func (m *ManilaResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ManilaResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ManilaResponse proto.InternalMessageInfo

func (m *ManilaResponse) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

func (m *ManilaResponse) GetCode() int32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *ManilaResponse) GetTotalUsed() int64 {
	if m != nil {
		return m.TotalUsed
	}
	return 0
}

func (m *ManilaResponse) GetTotalCapacity() int64 {
	if m != nil {
		return m.TotalCapacity
	}
	return 0
}

func (m *ManilaResponse) GetNewShareQuota() int64 {
	if m != nil {
		return m.NewShareQuota
	}
	return 0
}

func (m *ManilaResponse) GetNewSharePath() string {
	if m != nil {
		return m.NewSharePath
	}
	return ""
}

func init() {
	proto.RegisterEnum("eos.rpc.TYPE", TYPE_name, TYPE_value)
	proto.RegisterEnum("eos.rpc.QUOTATYPE", QUOTATYPE_name, QUOTATYPE_value)
	proto.RegisterEnum("eos.rpc.QUOTAOP", QUOTAOP_name, QUOTAOP_value)
	proto.RegisterEnum("eos.rpc.QUOTAENTRY", QUOTAENTRY_name, QUOTAENTRY_value)
	proto.RegisterEnum("eos.rpc.MANILA_REQUEST_TYPE", MANILA_REQUEST_TYPE_name, MANILA_REQUEST_TYPE_value)
	proto.RegisterEnum("eos.rpc.NSRequest_VersionRequest_VERSION_CMD", NSRequest_VersionRequest_VERSION_CMD_name, NSRequest_VersionRequest_VERSION_CMD_value)
	proto.RegisterEnum("eos.rpc.NSRequest_RecycleRequest_RECYCLE_CMD", NSRequest_RecycleRequest_RECYCLE_CMD_name, NSRequest_RecycleRequest_RECYCLE_CMD_value)
	proto.RegisterEnum("eos.rpc.NSRequest_AclRequest_ACL_COMMAND", NSRequest_AclRequest_ACL_COMMAND_name, NSRequest_AclRequest_ACL_COMMAND_value)
	proto.RegisterEnum("eos.rpc.NSRequest_AclRequest_ACL_TYPE", NSRequest_AclRequest_ACL_TYPE_name, NSRequest_AclRequest_ACL_TYPE_value)
	proto.RegisterEnum("eos.rpc.NSResponse_RecycleResponse_RecycleInfo_DELETIONTYPE", NSResponse_RecycleResponse_RecycleInfo_DELETIONTYPE_name, NSResponse_RecycleResponse_RecycleInfo_DELETIONTYPE_value)
	proto.RegisterType((*PingRequest)(nil), "eos.rpc.PingRequest")
	proto.RegisterType((*PingReply)(nil), "eos.rpc.PingReply")
	proto.RegisterType((*ContainerInsertRequest)(nil), "eos.rpc.ContainerInsertRequest")
	proto.RegisterType((*FileInsertRequest)(nil), "eos.rpc.FileInsertRequest")
	proto.RegisterType((*InsertReply)(nil), "eos.rpc.InsertReply")
	proto.RegisterType((*Time)(nil), "eos.rpc.Time")
	proto.RegisterType((*Checksum)(nil), "eos.rpc.Checksum")
	proto.RegisterType((*FileMdProto)(nil), "eos.rpc.FileMdProto")
	proto.RegisterMapType((map[string][]byte)(nil), "eos.rpc.FileMdProto.XattrsEntry")
	proto.RegisterType((*ContainerMdProto)(nil), "eos.rpc.ContainerMdProto")
	proto.RegisterMapType((map[string][]byte)(nil), "eos.rpc.ContainerMdProto.XattrsEntry")
	proto.RegisterType((*QuotaProto)(nil), "eos.rpc.QuotaProto")
	proto.RegisterType((*RoleId)(nil), "eos.rpc.RoleId")
	proto.RegisterType((*MDId)(nil), "eos.rpc.MDId")
	proto.RegisterType((*Limit)(nil), "eos.rpc.Limit")
	proto.RegisterType((*MDSelection)(nil), "eos.rpc.MDSelection")
	proto.RegisterMapType((map[string][]byte)(nil), "eos.rpc.MDSelection.XattrEntry")
	proto.RegisterType((*MDRequest)(nil), "eos.rpc.MDRequest")
	proto.RegisterType((*MDResponse)(nil), "eos.rpc.MDResponse")
	proto.RegisterType((*FindRequest)(nil), "eos.rpc.FindRequest")
	proto.RegisterType((*ShareAuth)(nil), "eos.rpc.ShareAuth")
	proto.RegisterType((*ShareProto)(nil), "eos.rpc.ShareProto")
	proto.RegisterType((*ShareToken)(nil), "eos.rpc.ShareToken")
	proto.RegisterType((*NSRequest)(nil), "eos.rpc.NSRequest")
	proto.RegisterType((*NSRequest_MkdirRequest)(nil), "eos.rpc.NSRequest.MkdirRequest")
	proto.RegisterType((*NSRequest_RmdirRequest)(nil), "eos.rpc.NSRequest.RmdirRequest")
	proto.RegisterType((*NSRequest_TouchRequest)(nil), "eos.rpc.NSRequest.TouchRequest")
	proto.RegisterType((*NSRequest_UnlinkRequest)(nil), "eos.rpc.NSRequest.UnlinkRequest")
	proto.RegisterType((*NSRequest_RmRequest)(nil), "eos.rpc.NSRequest.RmRequest")
	proto.RegisterType((*NSRequest_RenameRequest)(nil), "eos.rpc.NSRequest.RenameRequest")
	proto.RegisterType((*NSRequest_SymlinkRequest)(nil), "eos.rpc.NSRequest.SymlinkRequest")
	proto.RegisterType((*NSRequest_VersionRequest)(nil), "eos.rpc.NSRequest.VersionRequest")
	proto.RegisterType((*NSRequest_RecycleRequest)(nil), "eos.rpc.NSRequest.RecycleRequest")
	proto.RegisterType((*NSRequest_RecycleRequest_RestoreFlags)(nil), "eos.rpc.NSRequest.RecycleRequest.RestoreFlags")
	proto.RegisterType((*NSRequest_RecycleRequest_PurgeDate)(nil), "eos.rpc.NSRequest.RecycleRequest.PurgeDate")
	proto.RegisterType((*NSRequest_SetXAttrRequest)(nil), "eos.rpc.NSRequest.SetXAttrRequest")
	proto.RegisterMapType((map[string][]byte)(nil), "eos.rpc.NSRequest.SetXAttrRequest.XattrsEntry")
	proto.RegisterType((*NSRequest_ChownRequest)(nil), "eos.rpc.NSRequest.ChownRequest")
	proto.RegisterType((*NSRequest_ChmodRequest)(nil), "eos.rpc.NSRequest.ChmodRequest")
	proto.RegisterType((*NSRequest_AclRequest)(nil), "eos.rpc.NSRequest.AclRequest")
	proto.RegisterType((*NSRequest_TokenRequest)(nil), "eos.rpc.NSRequest.TokenRequest")
	proto.RegisterType((*NSRequest_QuotaRequest)(nil), "eos.rpc.NSRequest.QuotaRequest")
	proto.RegisterType((*NSResponse)(nil), "eos.rpc.NSResponse")
	proto.RegisterType((*NSResponse_ErrorResponse)(nil), "eos.rpc.NSResponse.ErrorResponse")
	proto.RegisterType((*NSResponse_VersionResponse)(nil), "eos.rpc.NSResponse.VersionResponse")
	proto.RegisterType((*NSResponse_VersionResponse_VersionInfo)(nil), "eos.rpc.NSResponse.VersionResponse.VersionInfo")
	proto.RegisterType((*NSResponse_RecycleResponse)(nil), "eos.rpc.NSResponse.RecycleResponse")
	proto.RegisterType((*NSResponse_RecycleResponse_RecycleInfo)(nil), "eos.rpc.NSResponse.RecycleResponse.RecycleInfo")
	proto.RegisterType((*NSResponse_AclResponse)(nil), "eos.rpc.NSResponse.AclResponse")
	proto.RegisterType((*NSResponse_QuotaResponse)(nil), "eos.rpc.NSResponse.QuotaResponse")
	proto.RegisterType((*NsStatRequest)(nil), "eos.rpc.NsStatRequest")
	proto.RegisterType((*NsStatResponse)(nil), "eos.rpc.NsStatResponse")
	proto.RegisterType((*ManilaRequest)(nil), "eos.rpc.ManilaRequest")
	proto.RegisterType((*ManilaResponse)(nil), "eos.rpc.ManilaResponse")
}

func init() { proto.RegisterFile("Rpc.proto", fileDescriptor_979aee4989bceb08) }

var fileDescriptor_979aee4989bceb08 = []byte{
	// 3555 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x3a, 0x4d, 0x73, 0x1b, 0xc7,
	0x72, 0x5a, 0x2c, 0x00, 0x62, 0x1b, 0x00, 0x09, 0x8d, 0x14, 0x19, 0x86, 0x24, 0x8b, 0x5e, 0x59,
	0x8e, 0xa4, 0xf7, 0x44, 0x3f, 0x2b, 0x71, 0xec, 0x67, 0xc7, 0xe5, 0xc0, 0x24, 0x48, 0xe1, 0x99,
	0x04, 0xe9, 0x01, 0xe4, 0x92, 0x72, 0x41, 0xad, 0xb1, 0x23, 0x70, 0x4b, 0xd8, 0x5d, 0xbc, 0xdd,
	0x85, 0x44, 0xfa, 0x9c, 0x4b, 0xde, 0x2d, 0x55, 0xef, 0x96, 0xaa, 0x1c, 0x72, 0xc8, 0x25, 0xb9,
	0xe4, 0x9a, 0xd3, 0x3b, 0xa6, 0x72, 0x48, 0x2e, 0xa9, 0xca, 0x2d, 0x7f, 0x20, 0xe7, 0xdc, 0x53,
	0xdd, 0x33, 0xbb, 0x3b, 0x4b, 0x82, 0x04, 0x1d, 0xfb, 0x36, 0xdd, 0xd3, 0xdd, 0x33, 0xd3, 0xd3,
	0x5f, 0xf3, 0x01, 0x16, 0x9f, 0x4f, 0xb6, 0xe6, 0x51, 0x98, 0x84, 0x6c, 0x4d, 0x84, 0xf1, 0x56,
	0x34, 0x9f, 0xd8, 0x5d, 0xa8, 0x1f, 0x79, 0xc1, 0x94, 0x8b, 0xdf, 0x2e, 0x44, 0x9c, 0xb0, 0x36,
	0xac, 0x39, 0x8b, 0xe4, 0xf8, 0xb5, 0x38, 0x6d, 0x1b, 0x9b, 0xc6, 0x43, 0x8b, 0xa7, 0x20, 0xf6,
	0xf8, 0x22, 0x8e, 0x9d, 0xa9, 0x68, 0x97, 0x36, 0x8d, 0x87, 0x0d, 0x9e, 0x82, 0xf6, 0x03, 0xb0,
	0xa4, 0x88, 0xf9, 0xac, 0x40, 0x66, 0x14, 0xc9, 0x7e, 0x67, 0xc0, 0xad, 0xed, 0x30, 0x48, 0x1c,
	0x2f, 0x10, 0x51, 0x3f, 0x88, 0x45, 0x94, 0xa4, 0xa3, 0x7e, 0x0a, 0xd6, 0x24, 0xed, 0x69, 0x1b,
	0x9b, 0xe6, 0xc3, 0xfa, 0xd3, 0x77, 0xb7, 0xd4, 0x0c, 0xb7, 0x32, 0x9e, 0x03, 0xf7, 0x08, 0xe7,
	0xce, 0x73, 0x5a, 0x7d, 0xba, 0xa5, 0xe2, 0x74, 0xef, 0x02, 0x78, 0xc1, 0xb1, 0x88, 0xbc, 0x64,
	0xec, 0xbb, 0x6d, 0x73, 0xd3, 0x78, 0x58, 0xe3, 0x96, 0xc2, 0x1c, 0xb8, 0xf6, 0x4b, 0xb8, 0xbe,
	0xeb, 0xcd, 0x44, 0x71, 0x1a, 0x8f, 0xa1, 0xf2, 0xca, 0x9b, 0x89, 0x58, 0x4d, 0xe1, 0x66, 0x36,
	0x05, 0x24, 0x4d, 0x47, 0x97, 0x24, 0x17, 0x8f, 0x6c, 0x7f, 0x01, 0xf5, 0x54, 0xec, 0x39, 0x85,
	0x98, 0x48, 0xa8, 0x40, 0xc6, 0xa0, 0x1c, 0x89, 0x64, 0xd2, 0x2e, 0x6d, 0x9a, 0x0f, 0x9b, 0x9c,
	0xda, 0xf6, 0x13, 0x28, 0x8f, 0x3c, 0x5f, 0xb0, 0x16, 0x98, 0xb1, 0x98, 0x90, 0x0a, 0xcb, 0x1c,
	0x9b, 0xec, 0x06, 0x54, 0x82, 0x31, 0xe2, 0x4a, 0x84, 0x2b, 0x07, 0x43, 0x31, 0xb1, 0xff, 0x14,
	0x6a, 0xdb, 0xc7, 0x62, 0xf2, 0x3a, 0x5e, 0xf8, 0xec, 0x26, 0x54, 0xde, 0x38, 0xb3, 0x45, 0xaa,
	0x77, 0x09, 0xe0, 0x20, 0xc9, 0xe9, 0x5c, 0xa8, 0x49, 0x52, 0xdb, 0xfe, 0xe7, 0x32, 0xd4, 0xb5,
	0x25, 0xb1, 0x75, 0x28, 0x79, 0xae, 0x1a, 0xab, 0xe4, 0xb9, 0xec, 0x1d, 0x58, 0x43, 0x15, 0x8f,
	0x3d, 0x57, 0x0d, 0x56, 0x45, 0xb0, 0xef, 0xe2, 0xac, 0x16, 0x9e, 0xd4, 0x66, 0x99, 0x63, 0x13,
	0x31, 0x53, 0xcf, 0x6d, 0x97, 0x25, 0x66, 0xea, 0xb9, 0x38, 0x60, 0xec, 0xfd, 0x20, 0xda, 0x15,
	0x39, 0x4d, 0x6c, 0xb3, 0xdb, 0x60, 0xcd, 0x9c, 0xd3, 0x70, 0x41, 0x22, 0xab, 0x9b, 0xc6, 0xc3,
	0x26, 0xaf, 0x49, 0x44, 0xdf, 0xc5, 0x79, 0xbf, 0x9a, 0x39, 0xd3, 0xb8, 0xbd, 0x46, 0x1d, 0x12,
	0x40, 0x31, 0x81, 0xe3, 0x8b, 0x76, 0x8d, 0x16, 0x43, 0x6d, 0x12, 0xe3, 0x05, 0xaf, 0xc7, 0xd4,
	0x61, 0x51, 0x47, 0x0d, 0x11, 0x03, 0xec, 0xbc, 0x0f, 0x95, 0x49, 0xe2, 0xf9, 0xa2, 0x0d, 0x9b,
	0xc6, 0xc3, 0xfa, 0xd3, 0x66, 0xb6, 0x79, 0xa8, 0x4f, 0x2e, 0xfb, 0x90, 0xc8, 0x27, 0xa2, 0xfa,
	0x52, 0x22, 0xea, 0x63, 0x4f, 0xa0, 0x36, 0x51, 0x4a, 0x6d, 0x37, 0x88, 0xee, 0x7a, 0x6e, 0x8c,
	0xaa, 0x83, 0x67, 0x24, 0xec, 0x0e, 0x58, 0xb3, 0x70, 0xe2, 0x24, 0x5e, 0x18, 0xc4, 0xed, 0x26,
	0xed, 0x65, 0x8e, 0x60, 0x8f, 0xa0, 0xb5, 0x08, 0x68, 0xd6, 0x39, 0xd1, 0x3a, 0x11, 0x6d, 0x48,
	0xfc, 0x7e, 0x46, 0xfa, 0x19, 0x54, 0x4f, 0x9c, 0x24, 0x89, 0xe2, 0xf6, 0x06, 0xd9, 0xdf, 0xe6,
	0x32, 0xfb, 0xdb, 0x7a, 0x41, 0x24, 0xbd, 0x20, 0x89, 0x4e, 0xb9, 0xa2, 0x47, 0x65, 0xcd, 0x9d,
	0xe4, 0xb8, 0xdd, 0x92, 0xca, 0xc2, 0x36, 0xe2, 0x44, 0xe2, 0x4c, 0xdb, 0xd7, 0xe5, 0xc6, 0x63,
	0xbb, 0xf3, 0x6b, 0xa8, 0x6b, 0xec, 0xb8, 0x79, 0xb9, 0xa3, 0x63, 0x33, 0xb7, 0xa1, 0x92, 0x66,
	0x43, 0x9f, 0x97, 0x3e, 0x33, 0xec, 0xff, 0x30, 0xa1, 0x75, 0xd6, 0x13, 0xcf, 0x19, 0xce, 0x6d,
	0xb0, 0xe6, 0x4e, 0x24, 0x74, 0xd3, 0xa9, 0x49, 0xc4, 0x15, 0x8d, 0xe7, 0x36, 0x58, 0x49, 0x24,
	0xc4, 0x98, 0x2c, 0x08, 0x0d, 0xc5, 0xe4, 0x35, 0x44, 0x0c, 0xd1, 0x8a, 0x18, 0x94, 0xfd, 0xd0,
	0x95, 0x96, 0xd5, 0xe4, 0xd4, 0xfe, 0x11, 0xc6, 0x93, 0xd9, 0x87, 0x75, 0x15, 0xfb, 0x80, 0x4b,
	0xec, 0xe3, 0x3e, 0x54, 0xe2, 0x4b, 0x8c, 0x88, 0xfa, 0xd8, 0x97, 0xd9, 0x66, 0x36, 0x68, 0x33,
	0x1f, 0x5c, 0x18, 0xcf, 0x2e, 0xdd, 0xd1, 0xe6, 0x92, 0x1d, 0x5d, 0xff, 0x79, 0x76, 0xf4, 0xdf,
	0x4d, 0x80, 0x6f, 0x17, 0x61, 0xe2, 0xc8, 0xbd, 0x4c, 0x47, 0x34, 0x8a, 0x23, 0x92, 0x1e, 0x55,
	0xf0, 0x20, 0x3d, 0x7e, 0xa8, 0x02, 0x0a, 0xee, 0xe3, 0xfa, 0x53, 0x96, 0x2d, 0xeb, 0xdb, 0xe7,
	0x87, 0xa3, 0xee, 0xe8, 0xe5, 0x51, 0x4f, 0x06, 0x19, 0x74, 0x8b, 0x45, 0x2c, 0xdc, 0xef, 0x4f,
	0x13, 0x11, 0xab, 0x2d, 0xce, 0x11, 0xec, 0x31, 0xb4, 0x10, 0x98, 0x85, 0x53, 0x6f, 0xe2, 0xcc,
	0x24, 0x91, 0x8c, 0x18, 0xe7, 0xf0, 0xa9, 0x24, 0x19, 0x9a, 0xab, 0xb9, 0x24, 0x19, 0x88, 0x3b,
	0x50, 0xf3, 0x9d, 0x13, 0x29, 0x61, 0x4d, 0x9a, 0x5c, 0x0a, 0xb3, 0x87, 0xb0, 0xe1, 0x3b, 0x27,
	0x85, 0x41, 0x6a, 0x44, 0x72, 0x16, 0xad, 0xa4, 0xc8, 0x21, 0xac, 0x4c, 0x8a, 0x1c, 0xe1, 0x57,
	0x70, 0x63, 0x2e, 0xa2, 0x89, 0x08, 0x12, 0x67, 0x2a, 0xf2, 0x35, 0xa1, 0x89, 0x94, 0xf8, 0xb2,
	0xae, 0xf3, 0x1c, 0x52, 0x70, 0x7d, 0x19, 0x87, 0x1c, 0x63, 0x13, 0xea, 0x71, 0xe2, 0x24, 0x8b,
	0x58, 0xca, 0x6e, 0x90, 0xc2, 0x75, 0x54, 0x4e, 0x21, 0x65, 0x35, 0x75, 0x0a, 0x42, 0xd9, 0xaf,
	0xa0, 0xca, 0xc3, 0x99, 0xc8, 0x5d, 0xcd, 0x38, 0xe7, 0x6a, 0xa5, 0xdc, 0xd5, 0x3a, 0x50, 0x5b,
	0xc4, 0x22, 0xa2, 0xfd, 0x35, 0x49, 0x58, 0x06, 0xa3, 0xc6, 0xa7, 0x51, 0xb8, 0x98, 0x53, 0x67,
	0x99, 0x3a, 0x73, 0x84, 0x3d, 0x86, 0xf2, 0xc1, 0x4e, 0xdf, 0x5d, 0x6a, 0x31, 0x32, 0x22, 0xe0,
	0x30, 0x55, 0x8a, 0x08, 0x2d, 0x30, 0xbd, 0x20, 0xa4, 0x01, 0xaa, 0x1c, 0x9b, 0xec, 0x7d, 0x65,
	0x3f, 0x65, 0xb2, 0x1f, 0xcd, 0x79, 0x32, 0xd3, 0xb1, 0xbf, 0x82, 0xca, 0xbe, 0xe7, 0x7b, 0x09,
	0x8e, 0xf0, 0x83, 0x88, 0x42, 0x1a, 0xa1, 0xc6, 0xa9, 0x8d, 0x12, 0x7d, 0x2f, 0x48, 0x57, 0xe2,
	0x7b, 0x01, 0x61, 0x9c, 0x93, 0x34, 0xb0, 0xf8, 0xce, 0x89, 0xfd, 0x0f, 0x55, 0xa8, 0x1f, 0xec,
	0x0c, 0xc5, 0x4c, 0x4c, 0x30, 0xb4, 0xb2, 0x5b, 0x50, 0x8d, 0x09, 0x50, 0x92, 0x14, 0xc4, 0x3e,
	0x48, 0x63, 0x42, 0x89, 0x3c, 0x79, 0x3d, 0x9b, 0x0c, 0x0d, 0x9f, 0x06, 0x85, 0x0f, 0xd2, 0xa0,
	0x60, 0x2e, 0xa7, 0xf2, 0x53, 0x2a, 0x19, 0x15, 0xca, 0xcb, 0xa9, 0x64, 0x58, 0xb0, 0xb5, 0xec,
	0x78, 0x9e, 0x48, 0x66, 0xcb, 0xc7, 0x40, 0x31, 0x2f, 0x8b, 0x81, 0xe7, 0xe9, 0xb2, 0x7e, 0xa4,
	0x9d, 0x1c, 0x7b, 0x33, 0x37, 0x12, 0x01, 0x59, 0xff, 0x12, 0xda, 0xb4, 0x9f, 0xfd, 0x52, 0x4f,
	0x54, 0xb5, 0xa5, 0xc4, 0x5a, 0xe2, 0xfa, 0x12, 0x98, 0x4c, 0x50, 0xc2, 0xd5, 0x52, 0x97, 0xb5,
	0x94, 0xed, 0x7a, 0x4a, 0x99, 0x27, 0xb3, 0x0e, 0xa8, 0x0c, 0xef, 0xb9, 0xe4, 0x29, 0x65, 0x9e,
	0xc1, 0x79, 0xd0, 0xae, 0x53, 0x87, 0x0a, 0xda, 0x6d, 0x58, 0x8b, 0x4f, 0x7d, 0x94, 0x43, 0xe6,
	0x5f, 0xe3, 0x29, 0x58, 0x48, 0xc8, 0xcd, 0xd5, 0x09, 0xf9, 0x26, 0x54, 0xc2, 0xb7, 0x58, 0x49,
	0xae, 0xcb, 0x9c, 0x40, 0x00, 0x62, 0xc9, 0x84, 0xdb, 0x1b, 0x12, 0x4b, 0x00, 0x96, 0x89, 0xd4,
	0x3d, 0x8e, 0xc2, 0x30, 0xa1, 0xfc, 0x59, 0xe3, 0x16, 0x61, 0x78, 0x18, 0x26, 0xd8, 0x4d, 0x74,
	0xb2, 0xfb, 0xba, 0xec, 0x26, 0x0c, 0x75, 0xff, 0x31, 0x6c, 0x44, 0x62, 0x2a, 0x4e, 0xe6, 0x63,
	0xf4, 0x40, 0xf2, 0x16, 0x46, 0xce, 0xb0, 0x2e, 0xd1, 0xbb, 0x0a, 0xcb, 0x1e, 0x80, 0xc2, 0x8c,
	0x5d, 0x4f, 0xba, 0xdc, 0x0d, 0xa2, 0x6b, 0x4a, 0xec, 0x8e, 0x44, 0xb2, 0x4f, 0xa0, 0x42, 0xf1,
	0xbf, 0x7d, 0x93, 0x72, 0xc6, 0xbd, 0x6c, 0x95, 0x9a, 0x31, 0xcb, 0x74, 0x21, 0xb3, 0x85, 0xa4,
	0xee, 0x7c, 0x06, 0x90, 0x23, 0x7f, 0x54, 0x0e, 0xf8, 0x83, 0x01, 0xd6, 0xc1, 0x4e, 0x5a, 0xff,
	0xa6, 0xae, 0x69, 0x5c, 0xe8, 0x9a, 0xec, 0x6e, 0xe6, 0xdf, 0x7a, 0xe2, 0xc3, 0x70, 0x40, 0xee,
	0xae, 0x55, 0xc5, 0x66, 0xb1, 0x1e, 0xbf, 0x0f, 0xe5, 0x28, 0x9c, 0xa5, 0xde, 0xb1, 0x91, 0xb1,
	0xca, 0x88, 0xc5, 0xa9, 0x93, 0x3d, 0x05, 0x2b, 0x4e, 0xd7, 0xa9, 0x5c, 0xe4, 0xe6, 0x32, 0x1d,
	0xf0, 0x9c, 0xcc, 0xfe, 0x2b, 0x03, 0x00, 0x97, 0x10, 0xcf, 0xc3, 0x20, 0x16, 0x57, 0x59, 0xc3,
	0x87, 0x60, 0xbe, 0xf2, 0xd3, 0x45, 0x2c, 0x2f, 0xf2, 0x91, 0x80, 0xfd, 0x02, 0xcc, 0x89, 0x3a,
	0x3b, 0x5c, 0x7a, 0x1e, 0x41, 0x2a, 0xfb, 0xbf, 0x0d, 0xac, 0xa9, 0x03, 0xf7, 0xe7, 0xd3, 0x65,
	0xaa, 0x31, 0xf3, 0x32, 0x8d, 0x69, 0x0a, 0x2f, 0x17, 0x15, 0x2e, 0x33, 0x9a, 0x2b, 0xe6, 0xc9,
	0xb1, 0xca, 0xac, 0x19, 0x5c, 0xd4, 0x73, 0xf5, 0x6a, 0x7a, 0xde, 0x03, 0x6b, 0x78, 0xec, 0x44,
	0xa2, 0xbb, 0x90, 0x85, 0x01, 0x9e, 0x23, 0x95, 0x91, 0x51, 0x7b, 0x69, 0xb1, 0xc0, 0xa0, 0x7c,
	0x1c, 0xc6, 0x89, 0x32, 0x06, 0x6a, 0xdb, 0xbf, 0x2b, 0x01, 0x90, 0x24, 0x59, 0x77, 0xbc, 0x07,
	0x30, 0x17, 0x91, 0xef, 0xc5, 0x31, 0x4e, 0x46, 0x0a, 0xd4, 0x30, 0xb8, 0x42, 0x71, 0x32, 0xf7,
	0x22, 0x11, 0xab, 0x98, 0x9f, 0x82, 0xb9, 0x9f, 0x4b, 0xe9, 0x67, 0xfd, 0x5c, 0xea, 0x43, 0xf9,
	0xf9, 0x7b, 0x00, 0x53, 0x11, 0x88, 0xc8, 0xc9, 0x4c, 0xab, 0xcc, 0x35, 0x4c, 0x96, 0xcb, 0xaa,
	0x6a, 0x41, 0x98, 0xcb, 0xee, 0x80, 0xe5, 0xcc, 0x66, 0xe1, 0x5b, 0x0c, 0xb6, 0x14, 0x5c, 0x6b,
	0x3c, 0x47, 0x60, 0x4e, 0x79, 0x93, 0x84, 0xaf, 0x45, 0x40, 0xa1, 0xd4, 0xe2, 0x0a, 0x62, 0xbf,
	0x84, 0xb5, 0x30, 0xf2, 0xa6, 0x1e, 0x05, 0x4b, 0xf4, 0xe2, 0xbc, 0x44, 0xca, 0xf4, 0xc7, 0x53,
	0x12, 0xfb, 0xaf, 0x0d, 0xa5, 0x8c, 0x11, 0x31, 0x3f, 0x82, 0x8a, 0x94, 0x69, 0xd0, 0xa6, 0xdc,
	0x28, 0xb2, 0xaa, 0x03, 0xa8, 0x1c, 0xe7, 0x0e, 0x58, 0xb1, 0x37, 0x0d, 0x9c, 0x64, 0x11, 0xa5,
	0x8e, 0x9d, 0x23, 0x70, 0xbd, 0xb1, 0x88, 0x3c, 0x67, 0xe6, 0xfd, 0x20, 0xa4, 0x09, 0x37, 0xb8,
	0x86, 0xa1, 0x53, 0x9a, 0x10, 0xb2, 0xf6, 0xae, 0x70, 0x6a, 0xdb, 0x7f, 0xd7, 0x06, 0x6b, 0x30,
	0x5c, 0x7d, 0x13, 0x90, 0x1a, 0x66, 0xe9, 0x32, 0xc3, 0xfc, 0x14, 0x2a, 0xfe, 0x6b, 0xd7, 0x8b,
	0xda, 0x7f, 0x44, 0x54, 0x79, 0x28, 0xcb, 0x46, 0xd8, 0x3a, 0xc0, 0x7e, 0x05, 0x3c, 0xbb, 0xc6,
	0x25, 0x3d, 0x32, 0x46, 0x3e, 0x32, 0xde, 0xba, 0x90, 0x91, 0xfb, 0x45, 0x46, 0xa2, 0x47, 0xc6,
	0x24, 0x5c, 0x4c, 0x8e, 0xdb, 0xef, 0x5c, 0xc8, 0x38, 0xc2, 0x7e, 0x8d, 0x91, 0xe8, 0xd9, 0xe7,
	0x50, 0x95, 0xf9, 0xab, 0xdd, 0x26, 0xce, 0xcd, 0x25, 0x9c, 0xcf, 0x89, 0x20, 0x67, 0x55, 0x1c,
	0x6c, 0x0b, 0x4a, 0x91, 0xdf, 0x7e, 0x97, 0xf8, 0xee, 0x2c, 0x9d, 0x6a, 0xce, 0x53, 0x8a, 0x7c,
	0x1c, 0x2b, 0x92, 0x89, 0xa2, 0x73, 0xe1, 0x58, 0x9c, 0x08, 0xb4, 0xb1, 0x24, 0x07, 0xfb, 0x32,
	0x4f, 0x90, 0xb7, 0x89, 0xf9, 0xfd, 0x25, 0xcc, 0x43, 0x49, 0x91, 0x73, 0x67, 0x59, 0xf4, 0x4b,
	0x58, 0x7b, 0x23, 0x22, 0xf2, 0xb2, 0x3b, 0x17, 0xb2, 0x7f, 0x27, 0x29, 0x34, 0x76, 0xc5, 0x83,
	0xec, 0x91, 0x98, 0x9c, 0x4e, 0x66, 0xa2, 0x7d, 0xf7, 0x42, 0x76, 0x2e, 0x29, 0x34, 0x76, 0xc5,
	0xc3, 0x3e, 0x4f, 0x53, 0xdb, 0x7b, 0xc4, 0x6c, 0x2f, 0x9b, 0xba, 0x48, 0x5e, 0x74, 0x93, 0x44,
	0xdf, 0x59, 0x62, 0xc1, 0x9d, 0x9d, 0x1c, 0x87, 0x6f, 0x83, 0xf6, 0xbd, 0x0b, 0x77, 0x76, 0x1b,
	0xfb, 0x35, 0x46, 0xa2, 0x97, 0x8c, 0x7e, 0xe8, 0xb6, 0x37, 0x2f, 0x61, 0xf4, 0x43, 0xb7, 0xc0,
	0xe8, 0x87, 0x2e, 0xfb, 0x18, 0x4c, 0x67, 0x32, 0x6b, 0xbf, 0x4f, 0x6c, 0x77, 0x97, 0xb0, 0x75,
	0x27, 0xb3, 0x9c, 0x09, 0x69, 0xa5, 0xf9, 0xa1, 0xeb, 0xda, 0x97, 0x98, 0xdf, 0x6b, 0x11, 0x14,
	0xcc, 0x0f, 0x1d, 0xf9, 0x53, 0xa8, 0xfc, 0x16, 0x8f, 0x61, 0xed, 0xfb, 0x17, 0x32, 0xd2, 0x31,
	0x4d, 0x63, 0x24, 0xfa, 0xce, 0x18, 0x1a, 0xba, 0x0b, 0xa9, 0x7c, 0x62, 0x5c, 0x94, 0x4f, 0xee,
	0x80, 0x15, 0x89, 0xc9, 0x22, 0x8a, 0xbd, 0x37, 0xd2, 0x77, 0x6b, 0x3c, 0x47, 0x64, 0x87, 0x6b,
	0x93, 0x0e, 0xdd, 0xd4, 0xee, 0x3c, 0x81, 0x86, 0xee, 0x6a, 0x2b, 0x06, 0x40, 0x72, 0xdd, 0xc1,
	0x56, 0x91, 0xef, 0x43, 0xb3, 0xe0, 0x55, 0x57, 0x98, 0x7f, 0x10, 0xa6, 0x26, 0xa8, 0x2e, 0xf4,
	0x32, 0x44, 0xe7, 0x15, 0x58, 0x99, 0xaf, 0xfd, 0x34, 0x4d, 0x5c, 0x3e, 0xce, 0x2e, 0x34, 0x0b,
	0xfe, 0xb9, 0x6a, 0xac, 0x5b, 0x50, 0x4d, 0x9c, 0x68, 0x2a, 0x12, 0x15, 0xa3, 0x15, 0xd4, 0xd9,
	0x83, 0xf5, 0xa2, 0xab, 0xfe, 0x7f, 0x05, 0xfd, 0xc1, 0x80, 0xf5, 0xa2, 0xd7, 0xae, 0x92, 0xf4,
	0x95, 0xac, 0x6b, 0x4a, 0x54, 0x99, 0x3c, 0x59, 0x19, 0x04, 0xb6, 0xbe, 0xeb, 0xf1, 0x61, 0xff,
	0x70, 0x30, 0xde, 0x3e, 0xd8, 0xa1, 0x5a, 0x07, 0x93, 0x8b, 0xef, 0x9c, 0xa4, 0xc1, 0xc4, 0xa4,
	0x14, 0xa2, 0x61, 0xec, 0x2d, 0xa8, 0x6b, 0x3c, 0x0c, 0xa0, 0xba, 0xcd, 0x7b, 0xdd, 0x51, 0xaf,
	0x75, 0x8d, 0x59, 0x50, 0x39, 0x7a, 0xce, 0xf7, 0x7a, 0x2d, 0x83, 0xd5, 0xa0, 0xbc, 0xdf, 0x1f,
	0x8e, 0x5a, 0xa5, 0xce, 0x7f, 0x9a, 0xb0, 0x5e, 0x8c, 0x1c, 0x4b, 0x8a, 0xd8, 0x95, 0xb3, 0x2e,
	0x4a, 0xd8, 0xe2, 0xbd, 0xed, 0x97, 0xdb, 0xfb, 0xbd, 0x7c, 0xd6, 0x47, 0x50, 0x8f, 0x44, 0x9c,
	0x84, 0x91, 0xc0, 0xf3, 0x86, 0x2a, 0xab, 0xb6, 0xae, 0x20, 0x48, 0x32, 0xed, 0xe2, 0x21, 0x85,
	0xeb, 0x22, 0x58, 0x1f, 0xac, 0xf9, 0x22, 0x9a, 0x0a, 0xd7, 0x49, 0xd2, 0xc2, 0xf6, 0x17, 0xab,
	0xe5, 0x1d, 0x21, 0xcb, 0x8e, 0x93, 0x08, 0x9e, 0x73, 0x77, 0x5e, 0x40, 0x43, 0x1f, 0x87, 0x8e,
	0x48, 0x61, 0x34, 0x11, 0xea, 0xc0, 0x2a, 0x01, 0xb4, 0x01, 0xff, 0x35, 0xd5, 0x29, 0xd2, 0x6a,
	0x15, 0x84, 0xb5, 0x9e, 0xd2, 0x7d, 0xac, 0x2c, 0x36, 0x83, 0x3b, 0x7b, 0x60, 0x65, 0x23, 0xa2,
	0x97, 0x9f, 0x0a, 0x27, 0x22, 0xa9, 0x15, 0x4e, 0x6d, 0x1c, 0xca, 0x0f, 0x03, 0x25, 0xb3, 0xc2,
	0x25, 0x80, 0x1b, 0xe0, 0x3a, 0xa7, 0x6a, 0x73, 0xb1, 0x69, 0x7f, 0x04, 0x75, 0x4d, 0xa7, 0xac,
	0x0e, 0x6b, 0xbc, 0x37, 0x1c, 0x1d, 0xf2, 0x0b, 0xb7, 0xf5, 0x7f, 0x0d, 0xd8, 0x38, 0x13, 0xd3,
	0x57, 0x99, 0xe6, 0x6e, 0x76, 0x6b, 0x56, 0xa2, 0xda, 0x69, 0x6b, 0x75, 0x9a, 0x58, 0x7a, 0x7d,
	0x56, 0xf0, 0x70, 0xf3, 0xac, 0x87, 0xdb, 0xd0, 0x78, 0x2d, 0x4e, 0xe3, 0x24, 0x74, 0xc5, 0x4c,
	0xd0, 0xd6, 0x99, 0x0f, 0x2d, 0x5e, 0xc0, 0xfd, 0x84, 0x8b, 0xb5, 0xce, 0x08, 0x1a, 0x7a, 0x3a,
	0x5a, 0xb5, 0xe6, 0x07, 0x69, 0x19, 0x7b, 0x41, 0x3d, 0x25, 0x7b, 0x3b, 0x5d, 0x94, 0x9a, 0xe7,
	0xaa, 0x55, 0x52, 0xd3, 0x78, 0x5e, 0xd2, 0xe2, 0xf9, 0x3f, 0x95, 0x00, 0xf2, 0xc4, 0xb5, 0x4a,
	0xc2, 0x17, 0xba, 0xc3, 0x3d, 0xba, 0x34, 0x07, 0x6e, 0x75, 0xb7, 0xf7, 0xc7, 0xdb, 0x87, 0x07,
	0x07, 0xdd, 0x81, 0x72, 0xb6, 0xcb, 0x37, 0xe0, 0xf3, 0xc2, 0x1d, 0xd0, 0x87, 0xab, 0x65, 0x6b,
	0xa7, 0x26, 0x06, 0xe5, 0x68, 0x31, 0x93, 0x37, 0x28, 0x16, 0xa7, 0xb6, 0xfd, 0x04, 0xea, 0xda,
	0x0c, 0xd0, 0x04, 0x07, 0x87, 0x03, 0xb4, 0x4b, 0x80, 0xea, 0xc1, 0xe1, 0x4e, 0x7f, 0xf7, 0xa5,
	0x6e, 0x98, 0xf6, 0x03, 0xa8, 0xa5, 0x42, 0x59, 0x03, 0x6a, 0xcf, 0x87, 0x3d, 0x3e, 0xee, 0x6e,
	0xef, 0xb7, 0xae, 0xa1, 0x51, 0x0f, 0x5f, 0x0e, 0x09, 0x30, 0x3a, 0xbf, 0xc6, 0x7c, 0x96, 0x67,
	0xec, 0x15, 0xc5, 0xb9, 0x24, 0x95, 0x14, 0x9d, 0x7f, 0x35, 0xa0, 0xa1, 0x27, 0xed, 0xa5, 0x77,
	0x65, 0xf7, 0xb4, 0xf3, 0xdf, 0xb9, 0x5d, 0xc7, 0x1d, 0xd8, 0x84, 0x52, 0x38, 0x57, 0x17, 0xad,
	0xad, 0xe2, 0x45, 0xeb, 0xe1, 0x11, 0x2f, 0x85, 0xf3, 0xc2, 0xb5, 0x65, 0xf9, 0xcc, 0xb5, 0xa5,
	0x7e, 0x31, 0x5a, 0x39, 0x73, 0x31, 0xfa, 0x08, 0x2a, 0x02, 0xed, 0x9a, 0xce, 0x3b, 0xeb, 0xda,
	0x52, 0x48, 0x78, 0x6f, 0x30, 0xe2, 0x2f, 0xb9, 0xa4, 0xf8, 0xda, 0x82, 0xb5, 0x49, 0xe8, 0xfb,
	0x4e, 0xe0, 0xda, 0x7f, 0x63, 0x01, 0xe0, 0x16, 0xa9, 0xa3, 0xf6, 0xa7, 0x50, 0x11, 0x51, 0x14,
	0x46, 0x4a, 0x1f, 0xc5, 0x7a, 0x50, 0xd2, 0x6c, 0xf5, 0x90, 0x20, 0x85, 0xb8, 0xa4, 0xd7, 0x2b,
	0x51, 0xb9, 0xfa, 0xfb, 0xcb, 0x58, 0xb3, 0x2c, 0xa4, 0x98, 0x97, 0x55, 0xa2, 0xe6, 0xc5, 0xec,
	0x59, 0xd4, 0x4d, 0xd9, 0xd3, 0x4a, 0x54, 0xd5, 0x76, 0xe5, 0x25, 0xd5, 0x96, 0x62, 0x25, 0xe3,
	0x53, 0x6c, 0x69, 0x6d, 0x27, 0x4b, 0xb4, 0xca, 0xc5, 0x2b, 0x55, 0xdb, 0x9d, 0xae, 0x54, 0x96,
	0x68, 0x9f, 0x40, 0xb3, 0xa0, 0x01, 0xb4, 0x83, 0x09, 0xba, 0xa5, 0x21, 0xdd, 0x12, 0xdb, 0x74,
	0x7f, 0x19, 0x4f, 0xd5, 0xb9, 0x19, 0x9b, 0x9d, 0xff, 0x32, 0x60, 0xe3, 0xcc, 0xf2, 0xaf, 0xc6,
	0xc9, 0xbe, 0x29, 0x64, 0x02, 0x0c, 0xa1, 0x1f, 0x5d, 0x41, 0xb7, 0x29, 0xdc, 0x0f, 0x5e, 0x85,
	0x5a, 0xea, 0xf8, 0x16, 0xea, 0x5a, 0xc7, 0xaa, 0x78, 0x91, 0xbd, 0x9d, 0x94, 0x2e, 0x7e, 0x3b,
	0xe9, 0xfc, 0xad, 0x09, 0x1b, 0x67, 0x76, 0xe6, 0xea, 0x2b, 0x53, 0x3b, 0x78, 0xe9, 0xca, 0xce,
	0x08, 0x4f, 0x61, 0xb9, 0xb2, 0x54, 0x40, 0xe7, 0xf7, 0x25, 0xa8, 0x6b, 0x3d, 0x3f, 0x4f, 0x88,
	0x46, 0x0d, 0xb8, 0xda, 0x45, 0xf1, 0x59, 0x0d, 0x50, 0x5f, 0xf6, 0x3e, 0x5a, 0xd6, 0xde, 0x47,
	0x8f, 0x54, 0x3c, 0xac, 0x90, 0x37, 0xfe, 0xf9, 0x8f, 0x5c, 0xd7, 0xd6, 0x4e, 0x6f, 0xbf, 0x37,
	0xea, 0x1f, 0x0e, 0xb4, 0x28, 0xa9, 0xf2, 0x55, 0x35, 0xcb, 0x57, 0xb6, 0x0d, 0x0d, 0x9d, 0x0e,
	0xc3, 0xe1, 0x6e, 0x7f, 0x1f, 0x83, 0x64, 0x0d, 0xca, 0x23, 0xde, 0xeb, 0xb5, 0x8c, 0xce, 0x1e,
	0xd4, 0x35, 0xdb, 0xbf, 0xe2, 0xc6, 0xa4, 0x01, 0xd9, 0xcc, 0x03, 0x72, 0xe7, 0x18, 0x9a, 0x05,
	0x7f, 0xb8, 0xa2, 0xa8, 0x8f, 0xc1, 0x22, 0xbf, 0x09, 0xe4, 0x49, 0xc4, 0x2c, 0x44, 0xd9, 0xfc,
	0xad, 0x8a, 0xe7, 0x54, 0xf6, 0x23, 0x68, 0x0e, 0xe2, 0x61, 0xe2, 0x24, 0x2b, 0xef, 0x2d, 0xec,
	0x7f, 0x34, 0x61, 0x3d, 0xa5, 0xbd, 0x64, 0x5a, 0x0c, 0xca, 0x22, 0x9f, 0x17, 0xb5, 0x31, 0xd9,
	0xc7, 0x09, 0x56, 0x79, 0xea, 0xaa, 0x89, 0x00, 0x2c, 0xc7, 0x02, 0x3d, 0xf6, 0x2a, 0x88, 0x6d,
	0x42, 0x3d, 0xc8, 0xfe, 0x28, 0xa4, 0xc1, 0x57, 0x47, 0xb1, 0xdb, 0x60, 0x7d, 0x1f, 0x86, 0xc9,
	0x98, 0xac, 0x45, 0x3e, 0x69, 0xd5, 0x10, 0x41, 0x6f, 0xff, 0xf7, 0xa0, 0x3e, 0x59, 0x44, 0xf4,
	0x8c, 0xfa, 0xca, 0x73, 0xd5, 0xa3, 0x16, 0x28, 0xd4, 0xae, 0xe7, 0xea, 0x04, 0x13, 0xcf, 0x55,
	0x4f, 0x5a, 0x29, 0xc1, 0xb6, 0x24, 0xf0, 0x85, 0x3f, 0x7e, 0xe3, 0x45, 0xc9, 0xc2, 0x99, 0xa9,
	0x07, 0x2d, 0xf0, 0x85, 0xff, 0x9d, 0xc4, 0xb0, 0xf7, 0xa1, 0x81, 0x04, 0x91, 0x88, 0x3d, 0x57,
	0x04, 0x89, 0xba, 0xa1, 0x47, 0x26, 0xae, 0x50, 0x38, 0x45, 0x24, 0x89, 0x31, 0xb7, 0xa9, 0x8b,
	0xfa, 0x9a, 0x2f, 0x7c, 0xca, 0x75, 0xec, 0x2e, 0xa0, 0xb4, 0xf1, 0x34, 0x0a, 0xdf, 0x26, 0xc7,
	0x74, 0x5d, 0x5f, 0xe6, 0x48, 0xbe, 0x47, 0x08, 0xdc, 0x83, 0xe4, 0x38, 0x12, 0x8e, 0x2b, 0xdf,
	0xa9, 0xca, 0x3c, 0x05, 0x71, 0xcf, 0x5f, 0xb9, 0x31, 0xdd, 0xcc, 0x97, 0x39, 0x36, 0x51, 0x89,
	0x8b, 0x39, 0xe9, 0x61, 0x43, 0x2a, 0x51, 0x42, 0xf6, 0xbf, 0x98, 0xd0, 0x3c, 0x70, 0x02, 0x6f,
	0x96, 0xe5, 0xd0, 0xaf, 0xa0, 0x11, 0xc9, 0xe6, 0x58, 0xbb, 0x5a, 0xcd, 0x6f, 0x5d, 0x0e, 0xba,
	0x83, 0xfe, 0x7e, 0x77, 0xcc, 0x7b, 0xdf, 0x3e, 0xef, 0x0d, 0x47, 0xb2, 0x66, 0xa8, 0x2b, 0x8e,
	0x11, 0x3a, 0xc5, 0xbb, 0x50, 0x43, 0x5b, 0x18, 0x9f, 0xf9, 0xb4, 0xf1, 0x8d, 0xbc, 0x2d, 0xa5,
	0x8f, 0x31, 0x93, 0x70, 0x96, 0xbe, 0x86, 0xa5, 0x30, 0x2e, 0x96, 0xb4, 0x30, 0xd6, 0x9f, 0xc3,
	0x08, 0x43, 0x1f, 0x0f, 0x36, 0xa1, 0xee, 0x8a, 0x78, 0x12, 0x79, 0xf3, 0xec, 0x6e, 0xd1, 0xe2,
	0x3a, 0x0a, 0xc7, 0x95, 0x02, 0xd4, 0xef, 0x07, 0x8b, 0xaf, 0x11, 0xdc, 0x77, 0xd9, 0x07, 0xb0,
	0x2e, 0xbb, 0xe4, 0x33, 0x83, 0xda, 0x6e, 0x8b, 0x37, 0x08, 0xbb, 0x87, 0x48, 0xf9, 0x45, 0x42,
	0xe6, 0x9f, 0x9a, 0x2c, 0xd1, 0x09, 0x40, 0x2d, 0x4f, 0x22, 0xe1, 0x24, 0x61, 0x44, 0x3b, 0x6c,
	0xf1, 0x14, 0x44, 0x9d, 0x0a, 0x79, 0x09, 0x0a, 0xf2, 0x6e, 0x52, 0x42, 0xb8, 0xed, 0x8e, 0xeb,
	0x7b, 0xc1, 0x58, 0xf5, 0xd6, 0xe5, 0x5c, 0x09, 0xd7, 0xcb, 0x1e, 0x44, 0xe4, 0x84, 0xe8, 0xde,
	0xb6, 0xa1, 0x2d, 0xf6, 0x59, 0x18, 0x27, 0xec, 0x41, 0x3a, 0xdf, 0xf4, 0x49, 0x48, 0x3d, 0x44,
	0x36, 0x09, 0x9b, 0x3e, 0xff, 0xd8, 0xff, 0x66, 0xc0, 0x7a, 0xba, 0x79, 0xca, 0xd5, 0x94, 0xb7,
	0x1b, 0x85, 0xc0, 0x31, 0x49, 0x4b, 0xd4, 0x8a, 0x72, 0xbe, 0xbb, 0x00, 0x49, 0x98, 0x38, 0xb3,
	0xf1, 0x22, 0x56, 0xf7, 0x96, 0x26, 0xb7, 0x08, 0xf3, 0x3c, 0x16, 0x18, 0x88, 0xd7, 0x65, 0xf7,
	0xc4, 0x99, 0x3b, 0x13, 0x2f, 0x91, 0xb7, 0xde, 0x26, 0x6f, 0x12, 0x76, 0x5b, 0x21, 0xd9, 0x87,
	0xb0, 0x11, 0x88, 0xb7, 0xd2, 0x76, 0xc7, 0x79, 0xe6, 0x36, 0x79, 0x33, 0x10, 0x6f, 0xc9, 0x82,
	0x29, 0x98, 0xa0, 0xf6, 0x73, 0x3a, 0xed, 0xfe, 0xb7, 0x91, 0x92, 0x1d, 0x39, 0xc9, 0xf1, 0xe3,
	0x3f, 0x83, 0xf2, 0x99, 0x88, 0xd9, 0x04, 0x6b, 0xfb, 0x70, 0x30, 0xea, 0xf6, 0x07, 0x3d, 0xde,
	0x32, 0xb0, 0x6a, 0xc4, 0xca, 0xb2, 0x3f, 0xd8, 0x6b, 0x95, 0x90, 0x6a, 0x38, 0xea, 0x8e, 0x5a,
	0xe6, 0xe3, 0x27, 0x60, 0x65, 0x8f, 0xe2, 0x88, 0xc6, 0x3a, 0x53, 0x9e, 0x95, 0xf6, 0xf8, 0xe1,
	0xf3, 0xa3, 0x56, 0x09, 0x19, 0x8f, 0xf8, 0xe1, 0x6f, 0x7a, 0xdb, 0x48, 0xfe, 0x11, 0xac, 0xa9,
	0xd2, 0x8e, 0xad, 0x81, 0xb9, 0xd7, 0x1b, 0xb5, 0xae, 0x61, 0x63, 0xd8, 0x1b, 0xb5, 0x0c, 0x56,
	0x85, 0x12, 0x3f, 0x68, 0x95, 0xb0, 0xa0, 0xe5, 0x07, 0x83, 0xc3, 0x9d, 0x1e, 0xc9, 0x87, 0xbc,
	0x5c, 0x2b, 0x16, 0xbd, 0xdf, 0x1d, 0xee, 0x3f, 0x3f, 0xc0, 0xd3, 0x98, 0x05, 0x95, 0x3e, 0x91,
	0x97, 0x1e, 0xff, 0xde, 0x80, 0x1b, 0x4b, 0x5c, 0x84, 0xb5, 0xa0, 0x21, 0x8f, 0xe7, 0xe3, 0xe1,
	0xb3, 0x2e, 0x9d, 0xe6, 0x5a, 0x2a, 0x55, 0xa4, 0x18, 0x03, 0x31, 0xbd, 0x17, 0xa3, 0xde, 0x60,
	0x47, 0x61, 0x4a, 0x88, 0x19, 0x3e, 0xe3, 0xfd, 0xc1, 0x37, 0x0a, 0x63, 0xb2, 0x1b, 0xb0, 0x71,
	0xd0, 0x1d, 0x74, 0xf7, 0x7a, 0xe3, 0xde, 0x0b, 0xa5, 0x8d, 0x32, 0x95, 0xd7, 0x03, 0x89, 0x6e,
	0x55, 0x18, 0x83, 0xf5, 0xbd, 0xde, 0x68, 0xbc, 0xdd, 0x3d, 0xea, 0x6e, 0xf7, 0x47, 0xfd, 0xde,
	0xb0, 0x55, 0x7d, 0xfa, 0x3f, 0x26, 0x98, 0xbd, 0x30, 0x66, 0x4f, 0xa1, 0x7c, 0xe4, 0x05, 0x53,
	0x96, 0x3f, 0x44, 0x68, 0xff, 0xd2, 0x3a, 0xec, 0x0c, 0x76, 0x3e, 0x3b, 0xb5, 0xaf, 0xb1, 0x8f,
	0xa1, 0x74, 0xb0, 0xc3, 0x98, 0x96, 0xb0, 0x53, 0xfa, 0x1b, 0x05, 0x9c, 0x34, 0x41, 0xfb, 0xda,
	0xaf, 0x0c, 0xf6, 0x09, 0x94, 0x77, 0xbd, 0xc0, 0x65, 0xfa, 0xbb, 0x4f, 0xf6, 0x6a, 0x73, 0x31,
	0xdb, 0x17, 0x50, 0x95, 0xa9, 0x83, 0xdd, 0xca, 0xb3, 0xb3, 0x9e, 0x77, 0x3a, 0xef, 0x9c, 0xc3,
	0xa7, 0xec, 0xec, 0x37, 0xb0, 0x71, 0xe6, 0xe3, 0x1b, 0xbb, 0x77, 0xfe, 0x39, 0xa9, 0xf0, 0x17,
	0xad, 0x93, 0xcf, 0x4f, 0xfb, 0x4c, 0x66, 0x5f, 0x63, 0x7f, 0x01, 0x90, 0x7f, 0x5c, 0x63, 0x9d,
	0xc2, 0xeb, 0xd5, 0xd5, 0x24, 0x7c, 0x0c, 0xe5, 0xde, 0x89, 0x98, 0x68, 0x6a, 0xcb, 0x8e, 0x5d,
	0xda, 0xfa, 0xf3, 0xd2, 0xc3, 0xbe, 0xc6, 0x9e, 0xc1, 0x0d, 0xe9, 0xcd, 0x43, 0x11, 0xbd, 0x11,
	0xd9, 0x61, 0x3e, 0x57, 0x45, 0x21, 0x50, 0x6b, 0xaa, 0x28, 0xc6, 0x00, 0xfb, 0xda, 0xd7, 0x1f,
	0xc1, 0x86, 0x17, 0x6e, 0x4d, 0xb1, 0x4f, 0xd1, 0x7c, 0x5d, 0xeb, 0x85, 0x31, 0xa5, 0xf5, 0x23,
	0xe3, 0x2f, 0x61, 0xeb, 0x0b, 0x11, 0xc6, 0x63, 0xec, 0xff, 0xfb, 0x92, 0xd9, 0x3b, 0x1c, 0x7e,
	0x5f, 0xa5, 0x30, 0xfc, 0x27, 0xff, 0x17, 0x00, 0x00, 0xff, 0xff, 0x4e, 0xb8, 0x3c, 0xd9, 0xbc,
	0x28, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// EosClient is the client API for Eos service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type EosClient interface {
	// Replies to a ping
	Ping(ctx context.Context, in *PingRequest, opts ...grpc.CallOption) (*PingReply, error)
	// Replies to MD requests with a stream
	MD(ctx context.Context, in *MDRequest, opts ...grpc.CallOption) (Eos_MDClient, error)
	// Replies to Find requests with a stream
	Find(ctx context.Context, in *FindRequest, opts ...grpc.CallOption) (Eos_FindClient, error)
	// Replies to a NsStat operation
	NsStat(ctx context.Context, in *NsStatRequest, opts ...grpc.CallOption) (*NsStatResponse, error)
	// Replies to an insert
	ContainerInsert(ctx context.Context, in *ContainerInsertRequest, opts ...grpc.CallOption) (*InsertReply, error)
	FileInsert(ctx context.Context, in *FileInsertRequest, opts ...grpc.CallOption) (*InsertReply, error)
	// Replies to a NsRequest operation
	Exec(ctx context.Context, in *NSRequest, opts ...grpc.CallOption) (*NSResponse, error)
	// Manila Driver
	ManilaServerRequest(ctx context.Context, in *ManilaRequest, opts ...grpc.CallOption) (*ManilaResponse, error)
}

type eosClient struct {
	cc *grpc.ClientConn
}

func NewEosClient(cc *grpc.ClientConn) EosClient {
	return &eosClient{cc}
}

func (c *eosClient) Ping(ctx context.Context, in *PingRequest, opts ...grpc.CallOption) (*PingReply, error) {
	out := new(PingReply)
	err := c.cc.Invoke(ctx, "/eos.rpc.Eos/Ping", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eosClient) MD(ctx context.Context, in *MDRequest, opts ...grpc.CallOption) (Eos_MDClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Eos_serviceDesc.Streams[0], "/eos.rpc.Eos/MD", opts...)
	if err != nil {
		return nil, err
	}
	x := &eosMDClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Eos_MDClient interface {
	Recv() (*MDResponse, error)
	grpc.ClientStream
}

type eosMDClient struct {
	grpc.ClientStream
}

func (x *eosMDClient) Recv() (*MDResponse, error) {
	m := new(MDResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *eosClient) Find(ctx context.Context, in *FindRequest, opts ...grpc.CallOption) (Eos_FindClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Eos_serviceDesc.Streams[1], "/eos.rpc.Eos/Find", opts...)
	if err != nil {
		return nil, err
	}
	x := &eosFindClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Eos_FindClient interface {
	Recv() (*MDResponse, error)
	grpc.ClientStream
}

type eosFindClient struct {
	grpc.ClientStream
}

func (x *eosFindClient) Recv() (*MDResponse, error) {
	m := new(MDResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *eosClient) NsStat(ctx context.Context, in *NsStatRequest, opts ...grpc.CallOption) (*NsStatResponse, error) {
	out := new(NsStatResponse)
	err := c.cc.Invoke(ctx, "/eos.rpc.Eos/NsStat", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eosClient) ContainerInsert(ctx context.Context, in *ContainerInsertRequest, opts ...grpc.CallOption) (*InsertReply, error) {
	out := new(InsertReply)
	err := c.cc.Invoke(ctx, "/eos.rpc.Eos/ContainerInsert", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eosClient) FileInsert(ctx context.Context, in *FileInsertRequest, opts ...grpc.CallOption) (*InsertReply, error) {
	out := new(InsertReply)
	err := c.cc.Invoke(ctx, "/eos.rpc.Eos/FileInsert", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eosClient) Exec(ctx context.Context, in *NSRequest, opts ...grpc.CallOption) (*NSResponse, error) {
	out := new(NSResponse)
	err := c.cc.Invoke(ctx, "/eos.rpc.Eos/Exec", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eosClient) ManilaServerRequest(ctx context.Context, in *ManilaRequest, opts ...grpc.CallOption) (*ManilaResponse, error) {
	out := new(ManilaResponse)
	err := c.cc.Invoke(ctx, "/eos.rpc.Eos/ManilaServerRequest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EosServer is the server API for Eos service.
type EosServer interface {
	// Replies to a ping
	Ping(context.Context, *PingRequest) (*PingReply, error)
	// Replies to MD requests with a stream
	MD(*MDRequest, Eos_MDServer) error
	// Replies to Find requests with a stream
	Find(*FindRequest, Eos_FindServer) error
	// Replies to a NsStat operation
	NsStat(context.Context, *NsStatRequest) (*NsStatResponse, error)
	// Replies to an insert
	ContainerInsert(context.Context, *ContainerInsertRequest) (*InsertReply, error)
	FileInsert(context.Context, *FileInsertRequest) (*InsertReply, error)
	// Replies to a NsRequest operation
	Exec(context.Context, *NSRequest) (*NSResponse, error)
	// Manila Driver
	ManilaServerRequest(context.Context, *ManilaRequest) (*ManilaResponse, error)
}

// UnimplementedEosServer can be embedded to have forward compatible implementations.
type UnimplementedEosServer struct {
}

func (*UnimplementedEosServer) Ping(ctx context.Context, req *PingRequest) (*PingReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Ping not implemented")
}
func (*UnimplementedEosServer) MD(req *MDRequest, srv Eos_MDServer) error {
	return status.Errorf(codes.Unimplemented, "method MD not implemented")
}
func (*UnimplementedEosServer) Find(req *FindRequest, srv Eos_FindServer) error {
	return status.Errorf(codes.Unimplemented, "method Find not implemented")
}
func (*UnimplementedEosServer) NsStat(ctx context.Context, req *NsStatRequest) (*NsStatResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method NsStat not implemented")
}
func (*UnimplementedEosServer) ContainerInsert(ctx context.Context, req *ContainerInsertRequest) (*InsertReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ContainerInsert not implemented")
}
func (*UnimplementedEosServer) FileInsert(ctx context.Context, req *FileInsertRequest) (*InsertReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FileInsert not implemented")
}
func (*UnimplementedEosServer) Exec(ctx context.Context, req *NSRequest) (*NSResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Exec not implemented")
}
func (*UnimplementedEosServer) ManilaServerRequest(ctx context.Context, req *ManilaRequest) (*ManilaResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ManilaServerRequest not implemented")
}

func RegisterEosServer(s *grpc.Server, srv EosServer) {
	s.RegisterService(&_Eos_serviceDesc, srv)
}

func _Eos_Ping_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EosServer).Ping(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/eos.rpc.Eos/Ping",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EosServer).Ping(ctx, req.(*PingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eos_MD_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(MDRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(EosServer).MD(m, &eosMDServer{stream})
}

type Eos_MDServer interface {
	Send(*MDResponse) error
	grpc.ServerStream
}

type eosMDServer struct {
	grpc.ServerStream
}

func (x *eosMDServer) Send(m *MDResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Eos_Find_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(EosServer).Find(m, &eosFindServer{stream})
}

type Eos_FindServer interface {
	Send(*MDResponse) error
	grpc.ServerStream
}

type eosFindServer struct {
	grpc.ServerStream
}

func (x *eosFindServer) Send(m *MDResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _Eos_NsStat_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NsStatRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EosServer).NsStat(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/eos.rpc.Eos/NsStat",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EosServer).NsStat(ctx, req.(*NsStatRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eos_ContainerInsert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ContainerInsertRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EosServer).ContainerInsert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/eos.rpc.Eos/ContainerInsert",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EosServer).ContainerInsert(ctx, req.(*ContainerInsertRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eos_FileInsert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FileInsertRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EosServer).FileInsert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/eos.rpc.Eos/FileInsert",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EosServer).FileInsert(ctx, req.(*FileInsertRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eos_Exec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NSRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EosServer).Exec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/eos.rpc.Eos/Exec",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EosServer).Exec(ctx, req.(*NSRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eos_ManilaServerRequest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ManilaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EosServer).ManilaServerRequest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/eos.rpc.Eos/ManilaServerRequest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EosServer).ManilaServerRequest(ctx, req.(*ManilaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Eos_serviceDesc = grpc.ServiceDesc{
	ServiceName: "eos.rpc.Eos",
	HandlerType: (*EosServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Ping",
			Handler:    _Eos_Ping_Handler,
		},
		{
			MethodName: "NsStat",
			Handler:    _Eos_NsStat_Handler,
		},
		{
			MethodName: "ContainerInsert",
			Handler:    _Eos_ContainerInsert_Handler,
		},
		{
			MethodName: "FileInsert",
			Handler:    _Eos_FileInsert_Handler,
		},
		{
			MethodName: "Exec",
			Handler:    _Eos_Exec_Handler,
		},
		{
			MethodName: "ManilaServerRequest",
			Handler:    _Eos_ManilaServerRequest_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "MD",
			Handler:       _Eos_MD_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Find",
			Handler:       _Eos_Find_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "Rpc.proto",
}

// Fri Mar 12 13:49:00 UTC 2021
