/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.common.reflection.GetDeclaredField;
import co.paralleluniverse.common.util.UtilUnsafe;
import co.paralleluniverse.strands.queues.BasicQueue;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import sun.misc.Unsafe;

public class BoxQueue<E>
implements BasicQueue<E> {
    private final boolean replaceOnWrite;
    private final boolean singleConsumer;
    private volatile E value;
    static final Unsafe unsafe = UtilUnsafe.getUnsafe();
    private static final long valueOffset;

    public BoxQueue(boolean replaceOnWrite, boolean singleConsumer) {
        this.replaceOnWrite = replaceOnWrite;
        this.singleConsumer = singleConsumer;
    }

    @Override
    public int capacity() {
        return 1;
    }

    @Override
    public int size() {
        return this.value != null ? 1 : 0;
    }

    @Override
    public boolean isEmpty() {
        return this.value == null;
    }

    @Override
    public boolean enq(E element) {
        assert (element != null);
        if (this.replaceOnWrite) {
            this.value = element;
            return true;
        }
        return this.casValue(null, element);
    }

    @Override
    public E poll() {
        E v;
        if (this.singleConsumer) {
            v = this.value;
            if (v != null) {
                if (this.replaceOnWrite) {
                    this.casValue(v, null);
                } else {
                    this.value = null;
                }
            }
        } else {
            while ((v = this.value) != null && !this.casValue(v, null)) {
            }
        }
        return v;
    }

    boolean casValue(Object expected, Object update) {
        return unsafe.compareAndSwapObject(this, valueOffset, expected, update);
    }

    static {
        try {
            valueOffset = unsafe.objectFieldOffset(AccessController.doPrivileged(new GetDeclaredField(BoxQueue.class, "value")));
        }
        catch (PrivilegedActionException ex) {
            throw new Error(ex.getCause());
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }
}

