/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.channels;

import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.Strand;
import co.paralleluniverse.strands.channels.ReceivePort;
import java.util.concurrent.TimeUnit;

public class ThreadReceivePort<Message> {
    private final ReceivePort<Message> p;

    public ThreadReceivePort(ReceivePort<Message> p) {
        this.p = p;
    }

    public Message receive() throws InterruptedException {
        if (Strand.isCurrentFiber()) {
            throw new IllegalStateException("This method cannot be called on a fiber");
        }
        try {
            return this.p.receive();
        }
        catch (SuspendExecution e) {
            throw new AssertionError((Object)e);
        }
    }

    public Message receive(long timeout, TimeUnit unit) throws InterruptedException {
        if (Strand.isCurrentFiber()) {
            throw new IllegalStateException("This method cannot be called on a fiber");
        }
        try {
            return this.p.receive(timeout, unit);
        }
        catch (SuspendExecution e) {
            throw new AssertionError((Object)e);
        }
    }

    public Message tryReceive() {
        return this.p.tryReceive();
    }

    public void close() {
        this.p.close();
    }

    public boolean isClosed() {
        return this.p.isClosed();
    }

    public final int hashCode() {
        return this.p.hashCode();
    }

    public final boolean equals(Object obj) {
        return this.p.equals(obj);
    }

    public final String toString() {
        return this.p.toString();
    }
}

