/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.channels;

import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.channels.ReceivePort;
import java.util.Map;
import java.util.Objects;

public interface Mix<M>
extends ReceivePort<M> {
    public <T extends ReceivePort<? extends M>> void add(T ... var1) throws SuspendExecution, InterruptedException;

    public <T extends ReceivePort<? extends M>> void remove(T ... var1) throws SuspendExecution, InterruptedException;

    public <T extends ReceivePort<? extends M>> Map<T, State> getState(T ... var1);

    public <T extends ReceivePort<? extends M>> void setState(State var1, T ... var2) throws SuspendExecution, InterruptedException;

    public <T extends ReceivePort<? extends M>> void setState(Map<T, State> var1) throws SuspendExecution, InterruptedException;

    public SoloEffect getSoloEffect();

    public void setSoloEffect(SoloEffect var1) throws SuspendExecution, InterruptedException;

    public static class State {
        public final Mode mode;
        public final Boolean solo;

        public State(Mode mode, Boolean solo) {
            this.mode = mode;
            this.solo = solo;
        }

        public State(Mode mode) {
            this(mode, null);
        }

        public State(boolean solo) {
            this(null, solo);
        }

        public Mode getMode() {
            return this.mode;
        }

        public Boolean getSolo() {
            return this.solo;
        }

        public int hashCode() {
            int hash = 3;
            hash = 79 * hash + Objects.hashCode((Object)this.mode);
            hash = 79 * hash + Objects.hashCode(this.solo);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            State other = (State)obj;
            if (this.mode != other.mode) {
                return false;
            }
            return Objects.equals(this.solo, other.solo);
        }

        public String toString() {
            return "State{solo=" + this.solo + ", mode=" + (Object)((Object)this.mode) + '}';
        }
    }

    public static enum Mode {
        NORMAL,
        PAUSE,
        MUTE;

    }

    public static enum SoloEffect {
        PAUSE_OTHERS,
        MUTE_OTHERS;

    }
}

