/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMEGenerator;
import org.bouncycastle.mail.smime.SMIMEStreamingProcessor;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.mail.smime.util.CRLFOutputStream;
import org.bouncycastle.util.Store;
import org.bouncycastle.x509.X509Store;

public class SMIMESignedGenerator
extends SMIMEGenerator {
    public static final String DIGEST_SHA1 = OIWObjectIdentifiers.idSHA1.getId();
    public static final String DIGEST_MD5 = PKCSObjectIdentifiers.md5.getId();
    public static final String DIGEST_SHA224 = NISTObjectIdentifiers.id_sha224.getId();
    public static final String DIGEST_SHA256 = NISTObjectIdentifiers.id_sha256.getId();
    public static final String DIGEST_SHA384 = NISTObjectIdentifiers.id_sha384.getId();
    public static final String DIGEST_SHA512 = NISTObjectIdentifiers.id_sha512.getId();
    public static final String DIGEST_GOST3411 = CryptoProObjectIdentifiers.gostR3411.getId();
    public static final String DIGEST_RIPEMD128 = TeleTrusTObjectIdentifiers.ripemd128.getId();
    public static final String DIGEST_RIPEMD160 = TeleTrusTObjectIdentifiers.ripemd160.getId();
    public static final String DIGEST_RIPEMD256 = TeleTrusTObjectIdentifiers.ripemd256.getId();
    public static final String ENCRYPTION_RSA = PKCSObjectIdentifiers.rsaEncryption.getId();
    public static final String ENCRYPTION_DSA = X9ObjectIdentifiers.id_dsa_with_sha1.getId();
    public static final String ENCRYPTION_ECDSA = X9ObjectIdentifiers.ecdsa_with_SHA1.getId();
    public static final String ENCRYPTION_RSA_PSS = PKCSObjectIdentifiers.id_RSASSA_PSS.getId();
    public static final String ENCRYPTION_GOST3410 = CryptoProObjectIdentifiers.gostR3410_94.getId();
    public static final String ENCRYPTION_ECGOST3410 = CryptoProObjectIdentifiers.gostR3410_2001.getId();
    private static final String CERTIFICATE_MANAGEMENT_CONTENT = "application/pkcs7-mime; name=smime.p7c; smime-type=certs-only";
    private static final String DETACHED_SIGNATURE_TYPE = "application/pkcs7-signature; name=smime.p7s; smime-type=signed-data";
    private static final String ENCAPSULATED_SIGNED_CONTENT_TYPE = "application/pkcs7-mime; name=smime.p7m; smime-type=signed-data";
    private final String _defaultContentTransferEncoding;
    private List _certStores = new ArrayList();
    private List certStores = new ArrayList();
    private List crlStores = new ArrayList();
    private List attrCertStores = new ArrayList();
    private List signerInfoGens = new ArrayList();
    private List _signers = new ArrayList();
    private List _oldSigners = new ArrayList();
    private List _attributeCerts = new ArrayList();
    private Map _digests = new HashMap();

    private static MailcapCommandMap addCommands(CommandMap commandMap) {
        MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)commandMap;
        mailcapCommandMap.addMailcap("application/pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_signature");
        mailcapCommandMap.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
        mailcapCommandMap.addMailcap("application/x-pkcs7-signature;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_signature");
        mailcapCommandMap.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
        mailcapCommandMap.addMailcap("multipart/signed;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.multipart_signed");
        return mailcapCommandMap;
    }

    public SMIMESignedGenerator() {
        this._defaultContentTransferEncoding = "7bit";
    }

    public SMIMESignedGenerator(String string) {
        this._defaultContentTransferEncoding = string;
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string) throws IllegalArgumentException {
        this._signers.add(new Signer(privateKey, x509Certificate, string, null, null));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2) throws IllegalArgumentException {
        this._signers.add(new Signer(privateKey, x509Certificate, string, string2, null, null));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, AttributeTable attributeTable, AttributeTable attributeTable2) throws IllegalArgumentException {
        this._signers.add(new Signer(privateKey, x509Certificate, string, attributeTable, attributeTable2));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, AttributeTable attributeTable, AttributeTable attributeTable2) throws IllegalArgumentException {
        this._signers.add(new Signer(privateKey, x509Certificate, string, string2, attributeTable, attributeTable2));
    }

    public void addSigners(SignerInformationStore signerInformationStore) {
        Iterator iterator = signerInformationStore.getSigners().iterator();
        while (iterator.hasNext()) {
            this._oldSigners.add(iterator.next());
        }
    }

    public void addSignerInfoGenerator(SignerInfoGenerator signerInfoGenerator) {
        this.signerInfoGens.add(signerInfoGenerator);
    }

    public void addCertificatesAndCRLs(CertStore certStore) throws CertStoreException, SMIMEException {
        this._certStores.add(certStore);
    }

    public void addCertificates(Store store) {
        this.certStores.add(store);
    }

    public void addCRLs(Store store) {
        this.crlStores.add(store);
    }

    public void addAttributeCertificates(Store store) {
        this.attrCertStores.add(store);
    }

    public void addAttributeCertificates(X509Store x509Store) throws CMSException {
        this._attributeCerts.add(x509Store);
    }

    private void addHashHeader(StringBuffer stringBuffer, List list) {
        int n = 0;
        Iterator iterator = list.iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            String string = object instanceof Signer ? ((Signer)object).getDigestOID() : (object instanceof SignerInformation ? ((SignerInformation)object).getDigestAlgOID() : ((SignerInfoGenerator)object).getDigestAlgorithm().getAlgorithm().getId());
            if (string.equals(DIGEST_SHA1)) {
                hashSet.add("sha1");
                continue;
            }
            if (string.equals(DIGEST_MD5)) {
                hashSet.add("md5");
                continue;
            }
            if (string.equals(DIGEST_SHA224)) {
                hashSet.add("sha224");
                continue;
            }
            if (string.equals(DIGEST_SHA256)) {
                hashSet.add("sha256");
                continue;
            }
            if (string.equals(DIGEST_SHA384)) {
                hashSet.add("sha384");
                continue;
            }
            if (string.equals(DIGEST_SHA512)) {
                hashSet.add("sha512");
                continue;
            }
            if (string.equals(DIGEST_GOST3411)) {
                hashSet.add("gostr3411-94");
                continue;
            }
            hashSet.add("unknown");
        }
        for (String string : hashSet) {
            if (n == 0) {
                if (hashSet.size() != 1) {
                    stringBuffer.append("; micalg=\"");
                } else {
                    stringBuffer.append("; micalg=");
                }
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append(string);
            ++n;
        }
        if (n != 0 && hashSet.size() != 1) {
            stringBuffer.append('\"');
        }
    }

    private MimeMultipart make(MimeBodyPart mimeBodyPart, Provider provider) throws NoSuchAlgorithmException, SMIMEException {
        try {
            MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
            mimeBodyPart2.setContent((Object)new ContentSigner(mimeBodyPart, false, provider), DETACHED_SIGNATURE_TYPE);
            mimeBodyPart2.addHeader("Content-Type", DETACHED_SIGNATURE_TYPE);
            mimeBodyPart2.addHeader("Content-Disposition", "attachment; filename=\"smime.p7s\"");
            mimeBodyPart2.addHeader("Content-Description", "S/MIME Cryptographic Signature");
            mimeBodyPart2.addHeader("Content-Transfer-Encoding", this.encoding);
            StringBuffer stringBuffer = new StringBuffer("signed; protocol=\"application/pkcs7-signature\"");
            ArrayList arrayList = new ArrayList(this._signers);
            arrayList.addAll(this._oldSigners);
            arrayList.addAll(this.signerInfoGens);
            this.addHashHeader(stringBuffer, arrayList);
            MimeMultipart mimeMultipart = new MimeMultipart(stringBuffer.toString());
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart2);
            return mimeMultipart;
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception putting multi-part together.", (Exception)((Object)messagingException));
        }
    }

    private MimeMultipart make(MimeBodyPart mimeBodyPart) throws SMIMEException {
        try {
            MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
            mimeBodyPart2.setContent((Object)new ContentSigner(mimeBodyPart, false), DETACHED_SIGNATURE_TYPE);
            mimeBodyPart2.addHeader("Content-Type", DETACHED_SIGNATURE_TYPE);
            mimeBodyPart2.addHeader("Content-Disposition", "attachment; filename=\"smime.p7s\"");
            mimeBodyPart2.addHeader("Content-Description", "S/MIME Cryptographic Signature");
            mimeBodyPart2.addHeader("Content-Transfer-Encoding", this.encoding);
            StringBuffer stringBuffer = new StringBuffer("signed; protocol=\"application/pkcs7-signature\"");
            ArrayList arrayList = new ArrayList(this._signers);
            arrayList.addAll(this._oldSigners);
            arrayList.addAll(this.signerInfoGens);
            this.addHashHeader(stringBuffer, arrayList);
            MimeMultipart mimeMultipart = new MimeMultipart(stringBuffer.toString());
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart2);
            return mimeMultipart;
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception putting multi-part together.", (Exception)((Object)messagingException));
        }
    }

    private MimeBodyPart makeEncapsulated(MimeBodyPart mimeBodyPart, Provider provider) throws NoSuchAlgorithmException, SMIMEException {
        try {
            MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
            mimeBodyPart2.setContent((Object)new ContentSigner(mimeBodyPart, true, provider), ENCAPSULATED_SIGNED_CONTENT_TYPE);
            mimeBodyPart2.addHeader("Content-Type", ENCAPSULATED_SIGNED_CONTENT_TYPE);
            mimeBodyPart2.addHeader("Content-Disposition", "attachment; filename=\"smime.p7m\"");
            mimeBodyPart2.addHeader("Content-Description", "S/MIME Cryptographic Signed Data");
            mimeBodyPart2.addHeader("Content-Transfer-Encoding", this.encoding);
            return mimeBodyPart2;
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception putting body part together.", (Exception)((Object)messagingException));
        }
    }

    private MimeBodyPart makeEncapsulated(MimeBodyPart mimeBodyPart) throws SMIMEException {
        try {
            MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
            mimeBodyPart2.setContent((Object)new ContentSigner(mimeBodyPart, true), ENCAPSULATED_SIGNED_CONTENT_TYPE);
            mimeBodyPart2.addHeader("Content-Type", ENCAPSULATED_SIGNED_CONTENT_TYPE);
            mimeBodyPart2.addHeader("Content-Disposition", "attachment; filename=\"smime.p7m\"");
            mimeBodyPart2.addHeader("Content-Description", "S/MIME Cryptographic Signed Data");
            mimeBodyPart2.addHeader("Content-Transfer-Encoding", this.encoding);
            return mimeBodyPart2;
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception putting body part together.", (Exception)((Object)messagingException));
        }
    }

    public Map getGeneratedDigests() {
        return new HashMap(this._digests);
    }

    public MimeMultipart generate(MimeBodyPart mimeBodyPart, String string) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.make(this.makeContentBodyPart(mimeBodyPart), SMIMEUtil.getProvider(string));
    }

    public MimeMultipart generate(MimeBodyPart mimeBodyPart, Provider provider) throws NoSuchAlgorithmException, SMIMEException {
        return this.make(this.makeContentBodyPart(mimeBodyPart), provider);
    }

    public MimeMultipart generate(MimeMessage mimeMessage, String string) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.generate(mimeMessage, SMIMEUtil.getProvider(string));
    }

    public MimeMultipart generate(MimeMessage mimeMessage, Provider provider) throws NoSuchAlgorithmException, SMIMEException {
        try {
            mimeMessage.saveChanges();
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("unable to save message", (Exception)((Object)messagingException));
        }
        return this.make(this.makeContentBodyPart(mimeMessage), provider);
    }

    public MimeMultipart generate(MimeBodyPart mimeBodyPart) throws SMIMEException {
        return this.make(this.makeContentBodyPart(mimeBodyPart));
    }

    public MimeBodyPart generateEncapsulated(MimeBodyPart mimeBodyPart) throws SMIMEException {
        return this.makeEncapsulated(this.makeContentBodyPart(mimeBodyPart));
    }

    public MimeBodyPart generateEncapsulated(MimeBodyPart mimeBodyPart, String string) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.makeEncapsulated(this.makeContentBodyPart(mimeBodyPart), SMIMEUtil.getProvider(string));
    }

    public MimeBodyPart generateEncapsulated(MimeBodyPart mimeBodyPart, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.makeEncapsulated(this.makeContentBodyPart(mimeBodyPart), provider);
    }

    public MimeBodyPart generateEncapsulated(MimeMessage mimeMessage, String string) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.generateEncapsulated(mimeMessage, SMIMEUtil.getProvider(string));
    }

    public MimeBodyPart generateEncapsulated(MimeMessage mimeMessage, Provider provider) throws NoSuchAlgorithmException, SMIMEException {
        try {
            mimeMessage.saveChanges();
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("unable to save message", (Exception)((Object)messagingException));
        }
        return this.makeEncapsulated(this.makeContentBodyPart(mimeMessage), provider);
    }

    public MimeBodyPart generateCertificateManagement(String string) throws SMIMEException, NoSuchProviderException {
        return this.generateCertificateManagement(SMIMEUtil.getProvider(string));
    }

    public MimeBodyPart generateCertificateManagement(Provider provider) throws SMIMEException {
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setContent((Object)new ContentSigner(null, true, provider), CERTIFICATE_MANAGEMENT_CONTENT);
            mimeBodyPart.addHeader("Content-Type", CERTIFICATE_MANAGEMENT_CONTENT);
            mimeBodyPart.addHeader("Content-Disposition", "attachment; filename=\"smime.p7c\"");
            mimeBodyPart.addHeader("Content-Description", "S/MIME Certificate Management Message");
            mimeBodyPart.addHeader("Content-Transfer-Encoding", this.encoding);
            return mimeBodyPart;
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception putting body part together.", (Exception)((Object)messagingException));
        }
    }

    static {
        CommandMap.setDefaultCommandMap((CommandMap)SMIMESignedGenerator.addCommands(CommandMap.getDefaultCommandMap()));
    }

    private class ContentSigner
    implements SMIMEStreamingProcessor {
        private final MimeBodyPart content;
        private final boolean encapsulate;
        private final Provider provider;
        private final boolean noProvider;

        ContentSigner(MimeBodyPart mimeBodyPart, boolean bl, Provider provider) {
            this.content = mimeBodyPart;
            this.encapsulate = bl;
            this.provider = provider;
            this.noProvider = false;
        }

        ContentSigner(MimeBodyPart mimeBodyPart, boolean bl) {
            this.content = mimeBodyPart;
            this.encapsulate = bl;
            this.provider = null;
            this.noProvider = true;
        }

        protected CMSSignedDataStreamGenerator getGenerator() throws CMSException, CertStoreException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
            CMSSignedDataStreamGenerator cMSSignedDataStreamGenerator = new CMSSignedDataStreamGenerator();
            Iterator iterator = SMIMESignedGenerator.this._certStores.iterator();
            while (iterator.hasNext()) {
                cMSSignedDataStreamGenerator.addCertificatesAndCRLs((CertStore)iterator.next());
            }
            iterator = SMIMESignedGenerator.this.certStores.iterator();
            while (iterator.hasNext()) {
                cMSSignedDataStreamGenerator.addCertificates((Store)iterator.next());
            }
            iterator = SMIMESignedGenerator.this.crlStores.iterator();
            while (iterator.hasNext()) {
                cMSSignedDataStreamGenerator.addCRLs((Store)iterator.next());
            }
            iterator = SMIMESignedGenerator.this.attrCertStores.iterator();
            while (iterator.hasNext()) {
                cMSSignedDataStreamGenerator.addAttributeCertificates((Store)iterator.next());
            }
            iterator = SMIMESignedGenerator.this._attributeCerts.iterator();
            while (iterator.hasNext()) {
                cMSSignedDataStreamGenerator.addAttributeCertificates((X509Store)iterator.next());
            }
            for (Signer signer : SMIMESignedGenerator.this._signers) {
                if (signer.getEncryptionOID() != null) {
                    cMSSignedDataStreamGenerator.addSigner(signer.getKey(), signer.getCert(), signer.getEncryptionOID(), signer.getDigestOID(), signer.getSignedAttr(), signer.getUnsignedAttr(), this.provider);
                    continue;
                }
                cMSSignedDataStreamGenerator.addSigner(signer.getKey(), signer.getCert(), signer.getDigestOID(), signer.getSignedAttr(), signer.getUnsignedAttr(), this.provider);
            }
            iterator = SMIMESignedGenerator.this.signerInfoGens.iterator();
            while (iterator.hasNext()) {
                cMSSignedDataStreamGenerator.addSignerInfoGenerator((SignerInfoGenerator)iterator.next());
            }
            cMSSignedDataStreamGenerator.addSigners(new SignerInformationStore(SMIMESignedGenerator.this._oldSigners));
            return cMSSignedDataStreamGenerator;
        }

        private void writeBodyPart(OutputStream outputStream, MimeBodyPart mimeBodyPart) throws IOException, MessagingException {
            if (mimeBodyPart.getContent() instanceof Multipart) {
                Multipart multipart = (Multipart)mimeBodyPart.getContent();
                ContentType contentType = new ContentType(multipart.getContentType());
                String string = "--" + contentType.getParameter("boundary");
                SMIMEUtil.LineOutputStream lineOutputStream = new SMIMEUtil.LineOutputStream(outputStream);
                Enumeration enumeration = mimeBodyPart.getAllHeaderLines();
                while (enumeration.hasMoreElements()) {
                    lineOutputStream.writeln((String)enumeration.nextElement());
                }
                lineOutputStream.writeln();
                SMIMEUtil.outputPreamble(lineOutputStream, mimeBodyPart, string);
                for (int i = 0; i < multipart.getCount(); ++i) {
                    lineOutputStream.writeln(string);
                    this.writeBodyPart(outputStream, (MimeBodyPart)multipart.getBodyPart(i));
                    lineOutputStream.writeln();
                }
                lineOutputStream.writeln(string + "--");
            } else {
                if (SMIMEUtil.isCanonicalisationRequired(mimeBodyPart, SMIMESignedGenerator.this._defaultContentTransferEncoding)) {
                    outputStream = new CRLFOutputStream(outputStream);
                }
                mimeBodyPart.writeTo(outputStream);
            }
        }

        public void write(OutputStream outputStream) throws IOException {
            try {
                CMSSignedDataStreamGenerator cMSSignedDataStreamGenerator = this.getGenerator();
                OutputStream outputStream2 = cMSSignedDataStreamGenerator.open(outputStream, this.encapsulate);
                if (this.content != null) {
                    if (!this.encapsulate) {
                        this.writeBodyPart(outputStream2, this.content);
                    } else {
                        this.content.getDataHandler().setCommandMap((CommandMap)SMIMESignedGenerator.addCommands(CommandMap.getDefaultCommandMap()));
                        this.content.writeTo(outputStream2);
                    }
                }
                outputStream2.close();
                SMIMESignedGenerator.this._digests = cMSSignedDataStreamGenerator.getGeneratedDigests();
            }
            catch (MessagingException messagingException) {
                throw new IOException(messagingException.toString());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IOException(noSuchAlgorithmException.toString());
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new IOException(noSuchProviderException.toString());
            }
            catch (CMSException cMSException) {
                throw new IOException(cMSException.toString());
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IOException(invalidKeyException.toString());
            }
            catch (CertStoreException certStoreException) {
                throw new IOException(certStoreException.toString());
            }
        }
    }

    private class Signer {
        final PrivateKey key;
        final X509Certificate cert;
        final String encryptionOID;
        final String digestOID;
        final AttributeTable signedAttr;
        final AttributeTable unsignedAttr;

        Signer(PrivateKey privateKey, X509Certificate x509Certificate, String string, AttributeTable attributeTable, AttributeTable attributeTable2) {
            this(privateKey, x509Certificate, null, string, attributeTable, attributeTable2);
        }

        Signer(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, AttributeTable attributeTable, AttributeTable attributeTable2) {
            this.key = privateKey;
            this.cert = x509Certificate;
            this.encryptionOID = string;
            this.digestOID = string2;
            this.signedAttr = attributeTable;
            this.unsignedAttr = attributeTable2;
        }

        public X509Certificate getCert() {
            return this.cert;
        }

        public String getEncryptionOID() {
            return this.encryptionOID;
        }

        public String getDigestOID() {
            return this.digestOID;
        }

        public PrivateKey getKey() {
            return this.key;
        }

        public AttributeTable getSignedAttr() {
            return this.signedAttr;
        }

        public AttributeTable getUnsignedAttr() {
            return this.unsignedAttr;
        }
    }
}

