/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.krypt.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.ext.krypt.Errors;
import org.jruby.ext.krypt.asn1.RubyAsn1;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class Asn1Codecs {
    static final RubyAsn1.Asn1Codec DEFAULT = new RubyAsn1.Asn1Codec(){

        @Override
        public byte[] encode(RubyAsn1.EncodeContext ctx) {
            IRubyObject value = ctx.getValue();
            if (value == null || value.isNil()) {
                return null;
            }
            return ctx.getValue().convertToString().getBytes();
        }

        @Override
        public IRubyObject decode(RubyAsn1.DecodeContext ctx) {
            byte[] value = ctx.getValue();
            Ruby runtime = ctx.getRuntime();
            if (value == null || value.length == 0) {
                return runtime.newString();
            }
            return runtime.newString(new ByteList(value, false));
        }

        @Override
        public void validate(RubyAsn1.ValidateContext ctx) {
            IRubyObject value = ctx.getValue();
            if (value == null || value.isNil()) {
                return;
            }
            if (!(value instanceof RubyString)) {
                throw Errors.newASN1Error(ctx.getRuntime(), "Value must be a string");
            }
        }
    };
    private static final RubyAsn1.Asn1Codec END_OF_CONTENTS = new RubyAsn1.Asn1Codec(){

        @Override
        public byte[] encode(RubyAsn1.EncodeContext ctx) {
            return null;
        }

        @Override
        public IRubyObject decode(RubyAsn1.DecodeContext ctx) {
            byte[] value = ctx.getValue();
            Ruby runtime = ctx.getRuntime();
            if (value != null && value.length != 0) {
                throw Errors.newASN1Error(runtime, "Invalid end of contents encoding");
            }
            return runtime.getNil();
        }

        @Override
        public void validate(RubyAsn1.ValidateContext ctx) {
            if (!ctx.getValue().isNil()) {
                throw Errors.newASN1Error(ctx.getRuntime(), "Value for END_OF_CONTENTS must be nil");
            }
        }
    };
    private static final RubyAsn1.Asn1Codec BOOLEAN = new RubyAsn1.Asn1Codec(){

        @Override
        public byte[] encode(RubyAsn1.EncodeContext ctx) {
            IRubyObject value = ctx.getValue();
            byte[] b = new byte[]{!value.isTrue() ? (byte)0 : -1};
            return b;
        }

        @Override
        public IRubyObject decode(RubyAsn1.DecodeContext ctx) {
            byte[] value = ctx.getValue();
            Ruby runtime = ctx.getRuntime();
            if (value == null || value.length != 1) {
                throw Errors.newASN1Error(runtime, "Boolean value with length != 1 found");
            }
            if (value[0] == 0) {
                return runtime.getFalse();
            }
            return runtime.getTrue();
        }

        @Override
        public void validate(RubyAsn1.ValidateContext ctx) {
            IRubyObject value = ctx.getValue();
            if (!(value instanceof RubyBoolean)) {
                throw Errors.newASN1Error(ctx.getRuntime(), "Value for BOOLEAN must be either true or false");
            }
        }
    };
    private static final RubyAsn1.Asn1Codec INTEGER = new RubyAsn1.Asn1Codec(){

        @Override
        public byte[] encode(RubyAsn1.EncodeContext ctx) {
            IRubyObject value = ctx.getValue();
            Ruby runtime = ctx.getRuntime();
            if (value instanceof RubyFixnum) {
                return BigInteger.valueOf(RubyNumeric.num2long((IRubyObject)value)).toByteArray();
            }
            if (value instanceof RubyBignum) {
                BigInteger big = ((RubyBignum)value).getValue();
                return big.toByteArray();
            }
            throw Errors.newASN1Error(runtime, "Value is not a number");
        }

        @Override
        public IRubyObject decode(RubyAsn1.DecodeContext ctx) {
            byte[] value = ctx.getValue();
            Ruby runtime = ctx.getRuntime();
            if (value == null) {
                throw Errors.newASN1Error(runtime, "Invalid integer encoding");
            }
            return RubyBignum.newBignum((Ruby)runtime, (BigInteger)new BigInteger(value));
        }

        @Override
        public void validate(RubyAsn1.ValidateContext ctx) {
            IRubyObject value = ctx.getValue();
            if (!(value instanceof RubyFixnum) && !(value instanceof RubyBignum)) {
                throw Errors.newASN1Error(ctx.getRuntime(), "Value for integer type must be an integer Number");
            }
        }
    };
    private static final RubyAsn1.Asn1Codec BIT_STRING = new RubyAsn1.Asn1Codec(){

        @Override
        public byte[] encode(RubyAsn1.EncodeContext ctx) {
            IRubyObject recv = ctx.getReceiver();
            IRubyObject value = ctx.getValue();
            IRubyObject unusedBitsIv = recv.getInstanceVariables().getInstanceVariable("unused_bits");
            int unusedBits = RubyNumeric.fix2int((IRubyObject)unusedBitsIv);
            Asn1Codecs.checkUnusedBits(ctx.getRuntime(), unusedBits);
            byte[] bytes = value.convertToString().getBytes();
            byte[] ret = new byte[bytes.length + 1];
            ret[0] = (byte)(unusedBits & 0xFF);
            System.arraycopy(bytes, 0, ret, 1, bytes.length);
            return ret;
        }

        @Override
        public IRubyObject decode(RubyAsn1.DecodeContext ctx) {
            byte[] value = ctx.getValue();
            Ruby runtime = ctx.getRuntime();
            IRubyObject recv = ctx.getReceiver();
            if (value == null) {
                throw Errors.newASN1Error(runtime, "Invalid BIT STRING encoding");
            }
            int unusedBits = value[0] & 0xFF;
            Asn1Codecs.checkUnusedBits(runtime, unusedBits);
            RubyString ret = runtime.newString(new ByteList(value, 1, value.length - 1, false));
            recv.getInstanceVariables().setInstanceVariable("unused_bits", (IRubyObject)RubyNumeric.int2fix((Ruby)runtime, (long)unusedBits));
            return ret;
        }

        @Override
        public void validate(RubyAsn1.ValidateContext ctx) {
            if (ctx.getValue().isNil()) {
                throw Errors.newASN1Error(ctx.getRuntime(), "BIT STRING value cannot be empty");
            }
            DEFAULT.validate(ctx);
        }
    };
    private static final RubyAsn1.Asn1Codec OCTET_STRING = DEFAULT;
    private static final RubyAsn1.Asn1Codec NULL = new RubyAsn1.Asn1Codec(){

        @Override
        public byte[] encode(RubyAsn1.EncodeContext ctx) {
            return null;
        }

        @Override
        public IRubyObject decode(RubyAsn1.DecodeContext ctx) {
            byte[] value = ctx.getValue();
            Ruby runtime = ctx.getRuntime();
            if (value != null && value.length != 0) {
                throw Errors.newASN1Error(runtime, "Invalid null encoding");
            }
            return runtime.getNil();
        }

        @Override
        public void validate(RubyAsn1.ValidateContext ctx) {
            IRubyObject value = ctx.getValue();
            if (value != null && !value.isNil()) {
                throw Errors.newASN1Error(ctx.getRuntime(), "Value must be nil for NULL");
            }
        }
    };
    private static final RubyAsn1.Asn1Codec OBJECT_ID = new RubyAsn1.Asn1Codec(){

        @Override
        public byte[] encode(RubyAsn1.EncodeContext ctx) {
            Ruby runtime = ctx.getRuntime();
            IRubyObject value = ctx.getValue();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectIdEncodeContext oidctx = new ObjectIdEncodeContext(value.convertToString().getBytes(), runtime);
            long first = oidctx.nextSubId();
            if (first == -1L) {
                throw Errors.newASN1Error(runtime, "Error while encoding object identifier");
            }
            long second = oidctx.nextSubId();
            if (second == -1L) {
                throw Errors.newASN1Error(runtime, "Error while encoding object identifier");
            }
            this.checkFirstSubId(runtime, first);
            this.checkSecondSubId(runtime, second);
            long cur = 40L * first + second;
            try {
                Asn1Codecs.writeLong(baos, cur);
                while ((cur = oidctx.nextSubId()) != -1L) {
                    Asn1Codecs.writeLong(baos, cur);
                }
            }
            catch (IOException ex) {
                throw Errors.newASN1Error(runtime, ex.getMessage());
            }
            return baos.toByteArray();
        }

        @Override
        public IRubyObject decode(RubyAsn1.DecodeContext ctx) {
            byte[] value = ctx.getValue();
            Ruby runtime = ctx.getRuntime();
            if (value == null) {
                throw Errors.newASN1Error(runtime, "Invalid object id encoding");
            }
            ObjectIdParseContext oidctx = new ObjectIdParseContext(value, runtime);
            StringBuilder builder = new StringBuilder();
            long cur = oidctx.parseNext();
            if (cur == -1L) {
                throw Errors.newASN1Error(runtime, "Error while parsing object identifier");
            }
            if (cur > 119L) {
                throw Errors.newASN1Error(runtime, "Illegal first octet, value too large");
            }
            long first = this.determineFirst(cur);
            long second = cur - 40L * first;
            this.checkFirstSubId(runtime, first);
            this.checkSecondSubId(runtime, second);
            builder.append(String.valueOf(first));
            this.appendNumber(builder, second);
            while ((cur = oidctx.parseNext()) != -1L) {
                this.appendNumber(builder, cur);
            }
            return runtime.newString(new ByteList(builder.toString().getBytes()));
        }

        private void appendNumber(StringBuilder b, long cur) {
            b.append('.').append(String.valueOf(cur));
        }

        private long determineFirst(long combined) {
            long f = 1L;
            while (40L * f <= combined) {
                ++f;
            }
            return f - 1L;
        }

        private void checkFirstSubId(Ruby runtime, long first) {
            if (first > 2L) {
                throw Errors.newASN1Error(runtime, "First sub id must be 0..2");
            }
        }

        private void checkSecondSubId(Ruby runtime, long second) {
            if (second > 39L) {
                throw Errors.newASN1Error(runtime, "Second sub id must be 0..39");
            }
        }

        @Override
        public void validate(RubyAsn1.ValidateContext ctx) {
            if (!(ctx.getValue() instanceof RubyString)) {
                throw Errors.newASN1Error(ctx.getRuntime(), "Value for OBJECT IDENTIFIER must be a String");
            }
        }
    };
    private static final RubyAsn1.Asn1Codec ENUMERATED = INTEGER;
    private static final RubyAsn1.Asn1Codec UTF8_STRING = new RubyAsn1.Asn1Codec(){

        @Override
        public byte[] encode(RubyAsn1.EncodeContext ctx) {
            IRubyObject value = ctx.getValue();
            if (value.isNil()) {
                return null;
            }
            RubyString s = value.convertToString();
            s.associateEncoding((Encoding)UTF8Encoding.INSTANCE);
            return s.getBytes();
        }

        @Override
        public IRubyObject decode(RubyAsn1.DecodeContext ctx) {
            IRubyObject obj = DEFAULT.decode(ctx);
            obj.asString().associateEncoding((Encoding)UTF8Encoding.INSTANCE);
            return obj;
        }

        @Override
        public void validate(RubyAsn1.ValidateContext ctx) {
            DEFAULT.validate(ctx);
        }
    };
    private static final DateTimeFormatter UTC_FORMATTER = DateTimeFormat.forPattern((String)"yyMMddHHmmss'Z'").withZone(DateTimeZone.UTC);
    private static final DateTimeFormatter GT_FORMATTER = DateTimeFormat.forPattern((String)"yyyyMMddHHmmss'Z'").withZone(DateTimeZone.UTC);
    private static final RubyAsn1.Asn1Codec UTC_TIME = new RubyAsn1.Asn1Codec(){

        @Override
        public byte[] encode(RubyAsn1.EncodeContext ctx) {
            return Asn1Codecs.encodeTime(ctx.getRuntime(), ctx.getValue(), UTC_FORMATTER);
        }

        @Override
        public IRubyObject decode(RubyAsn1.DecodeContext ctx) {
            return Asn1Codecs.decodeTime(ctx.getRuntime(), ctx.getValue(), UTC_FORMATTER);
        }

        @Override
        public void validate(RubyAsn1.ValidateContext ctx) {
            Asn1Codecs.validateTime(ctx);
        }
    };
    private static final RubyAsn1.Asn1Codec GENERALIZED_TIME = new RubyAsn1.Asn1Codec(){

        @Override
        public byte[] encode(RubyAsn1.EncodeContext ctx) {
            return Asn1Codecs.encodeTime(ctx.getRuntime(), ctx.getValue(), GT_FORMATTER);
        }

        @Override
        public IRubyObject decode(RubyAsn1.DecodeContext ctx) {
            return Asn1Codecs.decodeTime(ctx.getRuntime(), ctx.getValue(), GT_FORMATTER);
        }

        @Override
        public void validate(RubyAsn1.ValidateContext ctx) {
            Asn1Codecs.validateTime(ctx);
        }
    };
    static RubyAsn1.Asn1Codec[] CODECS = new RubyAsn1.Asn1Codec[]{END_OF_CONTENTS, BOOLEAN, INTEGER, BIT_STRING, OCTET_STRING, NULL, OBJECT_ID, null, null, null, ENUMERATED, null, UTF8_STRING, null, null, null, null, null, OCTET_STRING, OCTET_STRING, OCTET_STRING, OCTET_STRING, OCTET_STRING, UTC_TIME, GENERALIZED_TIME, OCTET_STRING, OCTET_STRING, OCTET_STRING, OCTET_STRING, OCTET_STRING, OCTET_STRING};

    private Asn1Codecs() {
    }

    private static void checkUnusedBits(Ruby runtime, int unusedBits) {
        if (unusedBits < 0 || unusedBits > 7) {
            throw Errors.newASN1Error(runtime, "Unused bits must be 0..7");
        }
    }

    static int determineNumberOfShifts(long value, int shiftBy) {
        int i = 0;
        while (value > 0L) {
            value >>= shiftBy;
            ++i;
        }
        return i;
    }

    private static void writeLong(ByteArrayOutputStream baos, long cur) throws IOException {
        if (cur == 0L) {
            baos.write(0);
            return;
        }
        int numShifts = Asn1Codecs.determineNumberOfShifts(cur, 7);
        byte[] bytes = new byte[numShifts];
        for (int i = numShifts - 1; i >= 0; --i) {
            byte b = (byte)(cur & 0x7FL);
            if (i < numShifts - 1) {
                b = (byte)(b | 0x80);
            }
            bytes[i] = b;
            cur >>= 7;
        }
        baos.write(bytes);
    }

    private static byte[] encodeTime(Ruby runtime, IRubyObject value, DateTimeFormatter formatter) {
        if (value instanceof RubyTime) {
            return Asn1Codecs.encodeRubyTime(runtime, value, formatter);
        }
        return Asn1Codecs.encodeFixnumTime(runtime, value, formatter);
    }

    private static byte[] encodeRubyTime(Ruby runtime, IRubyObject value, DateTimeFormatter formatter) {
        try {
            return ((RubyTime)value).getDateTime().toString(formatter).getBytes();
        }
        catch (Exception ex) {
            throw Errors.newASN1Error(runtime, "Error while encoding time value: " + ex.getMessage());
        }
    }

    private static byte[] encodeFixnumTime(Ruby runtime, IRubyObject value, DateTimeFormatter formatter) {
        try {
            long val = RubyNumeric.num2long((IRubyObject)value);
            if (val < 0L) {
                throw Errors.newASN1Error(runtime, "Negative time value given");
            }
            DateTime dt = new DateTime(val * 1000L, DateTimeZone.UTC);
            return dt.toString(formatter).getBytes();
        }
        catch (Exception ex) {
            throw Errors.newASN1Error(runtime, "Error while encoding time value: " + ex.getMessage());
        }
    }

    private static IRubyObject decodeTime(Ruby runtime, byte[] value, DateTimeFormatter formatter) {
        if (value == null) {
            throw Errors.newASN1Error(runtime, "Invalid time encoding");
        }
        try {
            DateTime dateTime = formatter.parseDateTime(new String(value, Charset.forName("US-ASCII")));
            return RubyTime.newTime((Ruby)runtime, (DateTime)dateTime);
        }
        catch (Exception ex) {
            throw Errors.newASN1Error(runtime, "Error while decoding time value: " + ex.getMessage());
        }
    }

    private static void validateTime(RubyAsn1.ValidateContext ctx) {
        IRubyObject value = ctx.getValue();
        if (!(value instanceof RubyTime || value instanceof RubyFixnum || value instanceof RubyString)) {
            throw Errors.newASN1Error(ctx.getRuntime(), "Time type must be either a Time, a Fixnum or a String");
        }
    }

    private static class ObjectIdParseContext {
        private final byte[] raw;
        private final Ruby runtime;
        int offset = 0;
        private static long LIMIT_PARSE = 0xFFFFFFFFFFFFFFL;

        public ObjectIdParseContext(byte[] raw, Ruby runtime) {
            this.raw = raw;
            this.runtime = runtime;
        }

        public long parseNext() {
            long num = 0L;
            if (this.offset >= this.raw.length) {
                return -1L;
            }
            while ((this.raw[this.offset] & 0x80) > 0) {
                if (num > LIMIT_PARSE) {
                    throw Errors.newASN1Error(this.runtime, "Sub identifier too large");
                }
                num <<= 7;
                num |= (long)(this.raw[this.offset++] & 0x7F);
                if (this.offset < this.raw.length) continue;
                throw Errors.newASN1Error(this.runtime, "Invalid object identifier encoding");
            }
            num <<= 7;
            return num |= (long)(this.raw[this.offset++] & 0x7F);
        }
    }

    private static class ObjectIdEncodeContext {
        private final byte[] raw;
        private final Ruby runtime;
        private int offset = 0;
        private static long ENCODE_LIMIT = 0xCCCCCCCCCCCCCCCL;

        public ObjectIdEncodeContext(byte[] raw, Ruby runtime) {
            this.raw = raw;
            this.runtime = runtime;
        }

        public final long nextSubId() {
            if (this.offset >= this.raw.length) {
                return -1L;
            }
            long ret = 0L;
            char c = (char)(this.raw[this.offset] & 0xFF);
            if (c == '.') {
                throw Errors.newASN1Error(this.runtime, "Sub identifier cannot start with '.'");
            }
            while (this.offset < this.raw.length && (c = (char)(this.raw[this.offset] & 0xFF)) != '.') {
                if (c < '0' || c > '9') {
                    throw Errors.newASN1Error(this.runtime, "Invalid character in object identifer: " + c);
                }
                if (ret > ENCODE_LIMIT) {
                    throw Errors.newASN1Error(this.runtime, "Sub object identifier too large");
                }
                if ((long)(this.offset + 1) == Long.MAX_VALUE) {
                    throw Errors.newASN1Error(this.runtime, "Object id value too large");
                }
                ret *= 10L;
                ret += (long)(c - 48);
                ++this.offset;
            }
            ++this.offset;
            return ret;
        }
    }
}

