/*
 * Decompiled with CFR 0.152.
 */
package impl.krypt.asn1.parser;

import impl.krypt.asn1.ParseException;
import impl.krypt.asn1.ParsedHeader;
import impl.krypt.asn1.Parser;
import impl.krypt.asn1.Tag;
import impl.krypt.asn1.TagClass;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class ChunkInputStream
extends FilterInputStream {
    private final Parser parser;
    private final boolean valuesOnly;
    private ParsedHeader currentHeader;
    private int headerOffset;
    private State state;

    ChunkInputStream(InputStream in, Parser parser, boolean valuesOnly) {
        super(in);
        if (parser == null) {
            throw new NullPointerException();
        }
        this.parser = parser;
        this.valuesOnly = valuesOnly;
        this.headerOffset = 0;
        this.state = State.NEW_HEADER;
    }

    @Override
    public int read() throws IOException {
        if (State.DONE == this.state) {
            return -1;
        }
        return this.readSingleByte();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (State.DONE == this.state) {
            return -1;
        }
        return this.readMultipleBytes(b, off, len);
    }

    private int readSingleByte() throws IOException {
        switch (this.state) {
            case NEW_HEADER: {
                this.readNewHeader();
            }
            case PROCESS_TAG: {
                int b = this.readSingleHeaderByte(this.currentHeader.getTag().getEncoding(), State.PROCESS_LENGTH);
                if (!this.valuesOnly) {
                    return b;
                }
            }
            case PROCESS_LENGTH: {
                int b = this.readSingleHeaderByte(this.currentHeader.getLength().getEncoding(), State.PROCESS_VALUE);
                this.checkDone();
                if (!this.valuesOnly) {
                    return b;
                }
            }
            case PROCESS_VALUE: {
                return this.readSingleValueByte();
            }
        }
        throw new UnsupportedOperationException(this.state.name());
    }

    private void checkDone() {
        Tag tag = this.currentHeader.getTag();
        if (tag.getTag() == 0 && tag.getTagClass().equals((Object)TagClass.UNIVERSAL) && this.state == State.PROCESS_VALUE) {
            this.state = State.DONE;
        }
    }

    private int readSingleHeaderByte(byte[] headerPart, State nextState) {
        byte ret = headerPart[this.headerOffset];
        ++this.headerOffset;
        if (this.headerOffset == headerPart.length) {
            this.headerOffset = 0;
            this.state = nextState;
        }
        return ret & 0xFF;
    }

    private int readSingleValueByte() throws IOException {
        int b = this.currentHeader.getValueStream(this.valuesOnly).read();
        if (b == -1) {
            this.state = State.NEW_HEADER;
            b = this.readSingleByte();
        }
        return b;
    }

    private int readMultipleBytes(byte[] b, int off, int len) throws IOException {
        int totalRead = 0;
        while (totalRead != len && this.state != State.DONE) {
            int read = this.readMultipleBytesSingleElement(b, off, len);
            totalRead += read;
            off += read;
        }
        return totalRead;
    }

    private int readMultipleBytesSingleElement(byte[] b, int off, int len) throws IOException {
        int totalRead = 0;
        switch (this.state) {
            case NEW_HEADER: {
                this.readNewHeader();
            }
            case PROCESS_TAG: {
                int read = this.readHeaderBytes(this.currentHeader.getTag().getEncoding(), State.PROCESS_LENGTH, b, off, len);
                if (!this.valuesOnly) {
                    if ((totalRead += read) == len) {
                        return totalRead;
                    }
                    off += read;
                }
            }
            case PROCESS_LENGTH: {
                int read = this.readHeaderBytes(this.currentHeader.getLength().getEncoding(), State.PROCESS_VALUE, b, off, len);
                this.checkDone();
                if (!this.valuesOnly) {
                    if ((totalRead += read) == len || this.state == State.DONE) {
                        return totalRead;
                    }
                    off += read;
                }
            }
            case PROCESS_VALUE: {
                return totalRead += this.readValueBytes(b, off, len);
            }
        }
        throw new UnsupportedOperationException(this.state.name());
    }

    private int readHeaderBytes(byte[] headerPart, State nextState, byte[] b, int off, int len) {
        int toRead;
        int available = headerPart.length - this.headerOffset;
        if (len < available) {
            this.headerOffset += len;
            toRead = len;
        } else {
            this.state = nextState;
            this.headerOffset = 0;
            toRead = available;
        }
        System.arraycopy(headerPart, this.headerOffset, b, off, toRead);
        return toRead;
    }

    private int readValueBytes(byte[] b, int off, int len) throws IOException {
        int read = this.currentHeader.getValueStream(this.valuesOnly).read(b, off, len);
        if (read == -1) {
            if (this.state != State.DONE) {
                this.state = State.NEW_HEADER;
            }
            read = 0;
        }
        return read;
    }

    private void readNewHeader() {
        this.currentHeader = this.parser.next(this.in);
        if (this.currentHeader == null) {
            throw new ParseException("Premature end of value detected.");
        }
        this.state = State.PROCESS_TAG;
        this.headerOffset = 0;
    }

    @Override
    public void close() throws IOException {
    }

    private static enum State {
        NEW_HEADER,
        PROCESS_TAG,
        PROCESS_LENGTH,
        PROCESS_VALUE,
        DONE;

    }
}

