/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.Foreign;
import com.kenai.jffi.Function;
import com.kenai.jffi.InvocationBuffer;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.ObjectBuffer;
import com.kenai.jffi.ObjectParameterInfo;
import com.kenai.jffi.ObjectParameterStrategy;
import com.kenai.jffi.Platform;
import com.kenai.jffi.Type;
import java.math.BigDecimal;
import java.nio.Buffer;
import java.nio.ByteOrder;

public final class HeapInvocationBuffer
extends InvocationBuffer {
    static final int FFI_SIZEOF_ARG = Platform.getPlatform().addressSize() / 8;
    private static final int PARAM_SIZE = 8;
    static final Encoder encoder = HeapInvocationBuffer.getEncoder();
    private final CallContext callContext;
    private final byte[] buffer;
    private ObjectBuffer objectBuffer;
    private int paramOffset = 0;
    private int paramIndex = 0;

    public HeapInvocationBuffer(Function function) {
        this.callContext = function.getCallContext();
        this.buffer = new byte[encoder.getBufferSize(this.callContext)];
    }

    public HeapInvocationBuffer(CallContext callContext) {
        this.callContext = callContext;
        this.buffer = new byte[encoder.getBufferSize(callContext)];
    }

    public HeapInvocationBuffer(CallContext context, int objectCount) {
        this.callContext = context;
        this.buffer = new byte[encoder.getBufferSize(context)];
        this.objectBuffer = new ObjectBuffer(objectCount);
    }

    byte[] array() {
        return this.buffer;
    }

    ObjectBuffer objectBuffer() {
        return this.objectBuffer;
    }

    public final void putByte(int value) {
        this.paramOffset = encoder.putByte(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putShort(int value) {
        this.paramOffset = encoder.putShort(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putInt(int value) {
        this.paramOffset = encoder.putInt(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putLong(long value) {
        this.paramOffset = encoder.putLong(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putFloat(float value) {
        this.paramOffset = encoder.putFloat(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putDouble(double value) {
        this.paramOffset = encoder.putDouble(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putLongDouble(double value) {
        if (encoder.isRaw()) {
            Foreign.getInstance().longDoubleFromDouble(value, this.buffer, this.paramOffset, Type.LONGDOUBLE.size());
            this.paramOffset += HeapInvocationBuffer.FFI_ALIGN(Type.LONGDOUBLE.size(), FFI_SIZEOF_ARG);
        } else {
            byte[] ld = new byte[Type.LONGDOUBLE.size()];
            Foreign.getInstance().longDoubleFromDouble(value, ld, 0, Type.LONGDOUBLE.size());
            this.getObjectBuffer().putArray(this.paramIndex, ld, 0, ld.length, 1);
            this.paramOffset += 8;
        }
        ++this.paramIndex;
    }

    public final void putLongDouble(BigDecimal value) {
        if (encoder.isRaw()) {
            Foreign.getInstance().longDoubleFromString(value.toEngineeringString(), this.buffer, this.paramOffset, Type.LONGDOUBLE.size());
            this.paramOffset += HeapInvocationBuffer.FFI_ALIGN(Type.LONGDOUBLE.size(), FFI_SIZEOF_ARG);
        } else {
            byte[] ld = new byte[Type.LONGDOUBLE.size()];
            Foreign.getInstance().longDoubleFromString(value.toEngineeringString(), ld, 0, Type.LONGDOUBLE.size());
            this.getObjectBuffer().putArray(this.paramIndex, ld, 0, ld.length, 1);
            this.paramOffset += 8;
        }
        ++this.paramIndex;
    }

    public final void putAddress(long value) {
        this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    private final ObjectBuffer getObjectBuffer() {
        if (this.objectBuffer == null) {
            this.objectBuffer = new ObjectBuffer();
        }
        return this.objectBuffer;
    }

    public final void putArray(byte[] array, int offset, int length, int flags) {
        this.paramOffset = encoder.skipAddress(this.paramOffset);
        this.getObjectBuffer().putArray(this.paramIndex++, array, offset, length, flags);
    }

    public final void putArray(short[] array, int offset, int length, int flags) {
        this.paramOffset = encoder.skipAddress(this.paramOffset);
        this.getObjectBuffer().putArray(this.paramIndex++, array, offset, length, flags);
    }

    public final void putArray(int[] array, int offset, int length, int flags) {
        this.paramOffset = encoder.skipAddress(this.paramOffset);
        this.getObjectBuffer().putArray(this.paramIndex++, array, offset, length, flags);
    }

    public final void putArray(long[] array, int offset, int length, int flags) {
        this.paramOffset = encoder.skipAddress(this.paramOffset);
        this.getObjectBuffer().putArray(this.paramIndex++, array, offset, length, flags);
    }

    public final void putArray(float[] array, int offset, int length, int flags) {
        this.paramOffset = encoder.skipAddress(this.paramOffset);
        this.getObjectBuffer().putArray(this.paramIndex++, array, offset, length, flags);
    }

    public final void putArray(double[] array, int offset, int length, int flags) {
        this.paramOffset = encoder.skipAddress(this.paramOffset);
        this.getObjectBuffer().putArray(this.paramIndex++, array, offset, length, flags);
    }

    public final void putDirectBuffer(Buffer value, int offset, int length) {
        this.paramOffset = encoder.skipAddress(this.paramOffset);
        this.getObjectBuffer().putDirectBuffer(this.paramIndex++, value, offset, length);
    }

    public final void putStruct(byte[] struct, int offset) {
        Type type = this.callContext.getParameterType(this.paramIndex);
        if (encoder.isRaw()) {
            this.paramOffset = HeapInvocationBuffer.FFI_ALIGN(this.paramOffset, type.alignment());
            System.arraycopy(struct, offset, this.buffer, this.paramOffset, type.size());
            this.paramOffset = HeapInvocationBuffer.FFI_ALIGN(this.paramOffset + type.size(), FFI_SIZEOF_ARG);
        } else {
            this.paramOffset = encoder.skipAddress(this.paramOffset);
            this.getObjectBuffer().putArray(this.paramIndex, struct, offset, type.size(), 1);
        }
        ++this.paramIndex;
    }

    public final void putStruct(long struct) {
        Type type = this.callContext.getParameterType(this.paramIndex);
        if (encoder.isRaw()) {
            this.paramOffset = HeapInvocationBuffer.FFI_ALIGN(this.paramOffset, type.alignment());
            MemoryIO.getInstance().getByteArray(struct, this.buffer, this.paramOffset, type.size());
            this.paramOffset = HeapInvocationBuffer.FFI_ALIGN(this.paramOffset + type.size(), FFI_SIZEOF_ARG);
        } else {
            this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, struct);
        }
        ++this.paramIndex;
    }

    public final void putObject(Object o, ObjectParameterStrategy strategy, ObjectParameterInfo info) {
        if (strategy.isDirect()) {
            this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, strategy.address(o));
        } else {
            this.paramOffset = encoder.skipAddress(this.paramOffset);
            this.getObjectBuffer().putObject(strategy.object(o), strategy.offset(o), strategy.length(o), ObjectBuffer.makeObjectFlags(info.ioflags(), strategy.typeInfo, this.paramIndex));
        }
        ++this.paramIndex;
    }

    public final void putObject(Object o, ObjectParameterStrategy strategy, int flags) {
        if (strategy.isDirect()) {
            this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, strategy.address(o));
        } else {
            this.paramOffset = encoder.skipAddress(this.paramOffset);
            this.getObjectBuffer().putObject(strategy.object(o), strategy.offset(o), strategy.length(o), ObjectBuffer.makeObjectFlags(flags, strategy.typeInfo, this.paramIndex));
        }
        ++this.paramIndex;
    }

    public final void putJNIEnvironment() {
        this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putJNI(this.paramIndex++, null, 0x1000000);
    }

    public final void putJNIObject(Object obj) {
        this.paramOffset = encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putJNI(this.paramIndex++, obj, 0x2000000);
    }

    private static Encoder getEncoder() {
        Foreign foreign = Foreign.getInstance();
        Platform platform = Platform.getPlatform();
        if (platform.getCPU() == Platform.CPU.I386 && foreign.isRawParameterPackingEnabled()) {
            return HeapInvocationBuffer.newI386RawEncoder();
        }
        ArrayIO io = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? (platform.addressSize() == 64 ? HeapInvocationBuffer.getBE64IO() : HeapInvocationBuffer.getBE32IO()) : (platform.addressSize() == 64 ? HeapInvocationBuffer.getLE64IO() : HeapInvocationBuffer.getLE32IO());
        return foreign.isRawParameterPackingEnabled() ? HeapInvocationBuffer.newRawEncoder(io) : HeapInvocationBuffer.newDefaultEncoder(io);
    }

    static ArrayIO getBE32IO() {
        return BE32ArrayIO.INSTANCE;
    }

    static ArrayIO getLE32IO() {
        return LE32ArrayIO.INSTANCE;
    }

    static ArrayIO getLE64IO() {
        return LE64ArrayIO.INSTANCE;
    }

    static ArrayIO getBE64IO() {
        return BE64ArrayIO.INSTANCE;
    }

    private static Encoder newI386RawEncoder() {
        return new I386RawEncoder();
    }

    private static Encoder newRawEncoder(ArrayIO io) {
        return new RawEncoder(io);
    }

    private static Encoder newDefaultEncoder(ArrayIO io) {
        return new DefaultEncoder(io);
    }

    static int FFI_ALIGN(int v, int a) {
        return (v - 1 | a - 1) + 1;
    }

    private static final class BE64ArrayIO
    extends BigEndianArrayIO {
        static final ArrayIO INSTANCE = new BE64ArrayIO();

        private BE64ArrayIO() {
        }

        public void putAddress(byte[] buffer, int offset, long value) {
            this.putLong(buffer, offset, value);
        }
    }

    private static final class BE32ArrayIO
    extends BigEndianArrayIO {
        static final ArrayIO INSTANCE = new BE32ArrayIO();

        private BE32ArrayIO() {
        }

        public void putAddress(byte[] buffer, int offset, long value) {
            buffer[offset + 0] = (byte)(value >> 24);
            buffer[offset + 1] = (byte)(value >> 16);
            buffer[offset + 2] = (byte)(value >> 8);
            buffer[offset + 3] = (byte)value;
        }
    }

    private static abstract class BigEndianArrayIO
    extends ArrayIO {
        private BigEndianArrayIO() {
        }

        public final void putByte(byte[] buffer, int offset, int value) {
            buffer[offset] = (byte)value;
        }

        public final void putShort(byte[] buffer, int offset, int value) {
            buffer[offset + 0] = (byte)(value >> 8);
            buffer[offset + 1] = (byte)value;
        }

        public final void putInt(byte[] buffer, int offset, int value) {
            buffer[offset + 0] = (byte)(value >> 24);
            buffer[offset + 1] = (byte)(value >> 16);
            buffer[offset + 2] = (byte)(value >> 8);
            buffer[offset + 3] = (byte)value;
        }

        public final void putLong(byte[] buffer, int offset, long value) {
            buffer[offset + 0] = (byte)(value >> 56);
            buffer[offset + 1] = (byte)(value >> 48);
            buffer[offset + 2] = (byte)(value >> 40);
            buffer[offset + 3] = (byte)(value >> 32);
            buffer[offset + 4] = (byte)(value >> 24);
            buffer[offset + 5] = (byte)(value >> 16);
            buffer[offset + 6] = (byte)(value >> 8);
            buffer[offset + 7] = (byte)value;
        }
    }

    private static final class LE64ArrayIO
    extends LittleEndianArrayIO {
        static final ArrayIO INSTANCE = new LE64ArrayIO();

        private LE64ArrayIO() {
        }

        public final void putAddress(byte[] buffer, int offset, long value) {
            this.putLong(buffer, offset, value);
        }
    }

    private static final class LE32ArrayIO
    extends LittleEndianArrayIO {
        static final ArrayIO INSTANCE = new LE32ArrayIO();

        private LE32ArrayIO() {
        }

        public final void putAddress(byte[] buffer, int offset, long value) {
            buffer[offset] = (byte)value;
            buffer[offset + 1] = (byte)(value >> 8);
            buffer[offset + 2] = (byte)(value >> 16);
            buffer[offset + 3] = (byte)(value >> 24);
        }
    }

    private static abstract class LittleEndianArrayIO
    extends ArrayIO {
        private LittleEndianArrayIO() {
        }

        public final void putByte(byte[] buffer, int offset, int value) {
            buffer[offset] = (byte)value;
        }

        public final void putShort(byte[] buffer, int offset, int value) {
            buffer[offset] = (byte)value;
            buffer[offset + 1] = (byte)(value >> 8);
        }

        public final void putInt(byte[] buffer, int offset, int value) {
            buffer[offset] = (byte)value;
            buffer[offset + 1] = (byte)(value >> 8);
            buffer[offset + 2] = (byte)(value >> 16);
            buffer[offset + 3] = (byte)(value >> 24);
        }

        public final void putLong(byte[] buffer, int offset, long value) {
            buffer[offset] = (byte)value;
            buffer[offset + 1] = (byte)(value >> 8);
            buffer[offset + 2] = (byte)(value >> 16);
            buffer[offset + 3] = (byte)(value >> 24);
            buffer[offset + 4] = (byte)(value >> 32);
            buffer[offset + 5] = (byte)(value >> 40);
            buffer[offset + 6] = (byte)(value >> 48);
            buffer[offset + 7] = (byte)(value >> 56);
        }
    }

    private static abstract class ArrayIO {
        private ArrayIO() {
        }

        public abstract void putByte(byte[] var1, int var2, int var3);

        public abstract void putShort(byte[] var1, int var2, int var3);

        public abstract void putInt(byte[] var1, int var2, int var3);

        public abstract void putLong(byte[] var1, int var2, long var3);

        public final void putFloat(byte[] buffer, int offset, float value) {
            this.putInt(buffer, offset, Float.floatToRawIntBits(value));
        }

        public final void putDouble(byte[] buffer, int offset, double value) {
            this.putLong(buffer, offset, Double.doubleToRawLongBits(value));
        }

        public abstract void putAddress(byte[] var1, int var2, long var3);
    }

    private static final class DefaultEncoder
    extends Encoder {
        private final ArrayIO io;

        public DefaultEncoder(ArrayIO io) {
            this.io = io;
        }

        public final boolean isRaw() {
            return false;
        }

        public final int getBufferSize(CallContext callContext) {
            return callContext.getParameterCount() * 8;
        }

        public final int putByte(byte[] buffer, int offset, int value) {
            this.io.putByte(buffer, offset, value);
            return offset + 8;
        }

        public final int putShort(byte[] buffer, int offset, int value) {
            this.io.putShort(buffer, offset, value);
            return offset + 8;
        }

        public final int putInt(byte[] buffer, int offset, int value) {
            this.io.putInt(buffer, offset, value);
            return offset + 8;
        }

        public final int putLong(byte[] buffer, int offset, long value) {
            this.io.putLong(buffer, offset, value);
            return offset + 8;
        }

        public final int putFloat(byte[] buffer, int offset, float value) {
            this.io.putFloat(buffer, offset, value);
            return offset + 8;
        }

        public final int putDouble(byte[] buffer, int offset, double value) {
            this.io.putDouble(buffer, offset, value);
            return offset + 8;
        }

        public final int putAddress(byte[] buffer, int offset, long value) {
            this.io.putAddress(buffer, offset, value);
            return offset + 8;
        }

        public int skipAddress(int offset) {
            return offset + 8;
        }
    }

    private static final class RawEncoder
    extends Encoder {
        private final ArrayIO io;

        private RawEncoder(ArrayIO io) {
            this.io = io;
        }

        public final boolean isRaw() {
            return true;
        }

        public final int getBufferSize(CallContext callContext) {
            return callContext.getRawParameterSize();
        }

        public final int putByte(byte[] buffer, int offset, int value) {
            offset = HeapInvocationBuffer.FFI_ALIGN(offset, FFI_SIZEOF_ARG);
            this.io.putByte(buffer, offset, value);
            return offset + BYTE_SIZE;
        }

        public final int putShort(byte[] buffer, int offset, int value) {
            offset = HeapInvocationBuffer.FFI_ALIGN(offset, FFI_SIZEOF_ARG);
            this.io.putShort(buffer, offset, value);
            return offset + SHORT_SIZE;
        }

        public final int putInt(byte[] buffer, int offset, int value) {
            offset = HeapInvocationBuffer.FFI_ALIGN(offset, FFI_SIZEOF_ARG);
            this.io.putInt(buffer, offset, value);
            return offset + INT_SIZE;
        }

        public final int putLong(byte[] buffer, int offset, long value) {
            offset = HeapInvocationBuffer.FFI_ALIGN(offset, FFI_SIZEOF_ARG);
            this.io.putLong(buffer, offset, value);
            return offset + LONG_SIZE;
        }

        public final int putFloat(byte[] buffer, int offset, float value) {
            offset = HeapInvocationBuffer.FFI_ALIGN(offset, FFI_SIZEOF_ARG);
            this.io.putFloat(buffer, offset, value);
            return offset + FLOAT_SIZE;
        }

        public final int putDouble(byte[] buffer, int offset, double value) {
            offset = HeapInvocationBuffer.FFI_ALIGN(offset, FFI_SIZEOF_ARG);
            this.io.putDouble(buffer, offset, value);
            return offset + DOUBLE_SIZE;
        }

        public final int putAddress(byte[] buffer, int offset, long value) {
            offset = HeapInvocationBuffer.FFI_ALIGN(offset, FFI_SIZEOF_ARG);
            this.io.putAddress(buffer, offset, value);
            return offset + ADDRESS_SIZE;
        }

        public final int skipAddress(int offset) {
            return HeapInvocationBuffer.FFI_ALIGN(offset, FFI_SIZEOF_ARG) + ADDRESS_SIZE;
        }
    }

    private static final class I386RawEncoder
    extends Encoder {
        private static final ArrayIO IO = LE32ArrayIO.INSTANCE;

        private I386RawEncoder() {
        }

        public final boolean isRaw() {
            return true;
        }

        public final int getBufferSize(CallContext callContext) {
            return callContext.getRawParameterSize();
        }

        public final int putByte(byte[] buffer, int offset, int value) {
            IO.putByte(buffer, offset, value);
            return offset + 4;
        }

        public final int putShort(byte[] buffer, int offset, int value) {
            IO.putShort(buffer, offset, value);
            return offset + 4;
        }

        public final int putInt(byte[] buffer, int offset, int value) {
            IO.putInt(buffer, offset, value);
            return offset + 4;
        }

        public final int putLong(byte[] buffer, int offset, long value) {
            IO.putLong(buffer, offset, value);
            return offset + 8;
        }

        public final int putFloat(byte[] buffer, int offset, float value) {
            IO.putFloat(buffer, offset, value);
            return offset + 4;
        }

        public final int putDouble(byte[] buffer, int offset, double value) {
            IO.putDouble(buffer, offset, value);
            return offset + 8;
        }

        public final int putAddress(byte[] buffer, int offset, long value) {
            IO.putAddress(buffer, offset, value);
            return offset + 4;
        }

        public final int skipAddress(int offset) {
            return offset + 4;
        }
    }

    static abstract class Encoder {
        static final int BYTE_ALIGN = Type.SINT8.alignment();
        static final int BYTE_SIZE = Type.SINT8.size();
        static final int SHORT_ALIGN = Type.SSHORT.alignment();
        static final int SHORT_SIZE = Type.SSHORT.size();
        static final int INT_ALIGN = Type.SINT.alignment();
        static final int INT_SIZE = Type.SINT.size();
        static final int LONG_ALIGN = Type.SINT64.alignment();
        static final int LONG_SIZE = Type.SINT64.size();
        static final int FLOAT_ALIGN = Type.FLOAT.alignment();
        static final int FLOAT_SIZE = Type.FLOAT.size();
        static final int DOUBLE_ALIGN = Type.DOUBLE.alignment();
        static final int DOUBLE_SIZE = Type.DOUBLE.size();
        static final int LONGDOUBLE_ALIGN = Type.LONGDOUBLE.alignment();
        static final int LONGDOUBLE_SIZE = Type.LONGDOUBLE.size();
        static final int ADDRESS_ALIGN = Type.POINTER.alignment();
        static final int ADDRESS_SIZE = Type.POINTER.size();
        static final int FFI_SIZEOF_ARG = Platform.getPlatform().longSize() == 32 ? 4 : 8;

        Encoder() {
        }

        public abstract boolean isRaw();

        public abstract int getBufferSize(CallContext var1);

        public abstract int putByte(byte[] var1, int var2, int var3);

        public abstract int putShort(byte[] var1, int var2, int var3);

        public abstract int putInt(byte[] var1, int var2, int var3);

        public abstract int putLong(byte[] var1, int var2, long var3);

        public abstract int putFloat(byte[] var1, int var2, float var3);

        public abstract int putDouble(byte[] var1, int var2, double var3);

        public abstract int putAddress(byte[] var1, int var2, long var3);

        public abstract int skipAddress(int var1);
    }
}

