package org.jruby.parser;

public class Ripper19YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

          200,  200,  273,   91,  276,  375,  275,  256,  256,  118, 
          118,  256,  260,  260,  418,  574,  260,  633,  213,  118, 
          215,  200,  199,  101,  438,   78,   78,  609,  621,  544, 
          545,  269,  582,  650,  473,  520,  650,  474,  213,  639, 
          215,  608,  270,  651,  293,  296,  200,  503,  291,  295, 
          234,  237,  557,  557,  118,  302,  516,  564,  570,  272, 
          577,  578,  630,  522,  386,    8,  558,  557,  312,  796, 
          236,  803,  801,  557,  325,    8,  644,  861,  651,  503, 
          378,  503,  236,  603,  380,  326,  272,  497,  259,  259, 
          379,  708,  259,  684,  503,   81,  503,  118,  509,  677, 
          674,  557,  864,  280,  564,  570,  464,  287,  489,  520, 
          492,  286,  495,  509,  323,  517,  269,  497,  603,  235, 
          292,  739,  557,  323,    8,  325,  236,  711,  240,  673, 
          522,  235,  790,  470,  306,  236,  373,  696,  557,   72, 
           73,   71,  594,  761,  313,  926,   81,  497,  811,  517, 
           79,  603,  250,  910,  252,  557,  822,  768,  335,  336, 
          557,  251,  827,  357,  517,  557,  236,  469,  616,  497, 
          350,  603,  373,   84,  268,  235,  343,  348,  351,  522, 
          286,  346,  349,  407,  235,  344,  777,  347,  345,  373, 
           70,   73,   69,  313,  589,  324,  497,  470,  451,  557, 
          764,   79,  938,  406,  324,  373,  697,  557,  733,  557, 
          438,  926,  477,  407,  557,  235,  240,  263,  419,  520, 
          384,  403,  265,  864,  385,  779,  780,   77,  781,   95, 
          959,  472,  407,   74,  390,  738,   82,   75,  294,  801, 
          688,  268,  401,  803,  796,   91,  744,  272,  557,  552, 
          278,  881,   80,  650,  650,  801,  762,  256,  703,  256, 
          256,  651,  260,   95,  260,  452,  453,  552,  557,  444, 
          684,  787,  557,  557,   78,  284,  815,  317,   77,   91, 
           95,  423,  424,   76,   74,  282,  283,   82,   75,  319, 
          678,  704,   59,   60,  368,  397,   91,  557,  370,   84, 
           53,  369,  398,   80,  118,  367,   83,   83,  119,  119, 
          283,  371,   83,  228,  228,  228,   70,  557,  244,  228, 
          228,  557,  557,  228,  520,   78,  397,  557,  387,  363, 
          498,  557,  557,  372,   76,  499,  754,  620,  259,  240, 
          259,  636,  503,  607,  458,  742,  557,  287,  271,   83, 
          228,  286,  833,  300,  240,  228,  393,  531,  376,  256, 
          572,  377,  522,  497,   81,  400,  335,  336,  444,  497, 
          527,  528,  529,  530,  684,  566,  684,   97,  503,  118, 
          591,  381,  382,  409,  857,  256,  572,  557,  786,  271, 
          582,  544,  545,  503,  444,  477,  300,  558,  557,  598, 
          558,  566,   78,  619,  557,  622,  256,  572,  775,   73, 
          517,  503,  509,  771,  765,  444,  228,  810,   83,   79, 
          256,  572,  566,  409,  277,  522,   81,    8,  388,  444, 
          623,  649,  497,  658,  280,  287,  566,  483,  484,  286, 
          407,  430,  431,  432,  486,  588,  517,  956,  200,  588, 
          684,  912,  905,  579,  572,  583,  557,  650,   91,  593, 
          596,  522,  357,  517,  651,  213,  667,  215,  895,  566, 
           72,   73,   71,  256,  572,  588,  624,  402,  903,  517, 
           78,   79,  444,  250,  632,  252,  250,  118,  252,  566, 
           14,  557,  251,  634,  522,  251,   77,  684,   95,  684, 
          497,  350,   74,  477,  600,   82,   75,  343,  348,  351, 
          414,  407,  346,  349,   91,  397,  344,  694,  347,  345, 
          428,   80,  557,   83,  707,  707,  557,  684,  847,  929, 
          557,  557,  405,  557,   70,  710,  771,  557,  414,   14, 
          638,  638,  365,   78,  481,  228,  228,  283,  934,  366, 
          723,  557,   76,  520,  283,  620,  557,  420,   77,  536, 
           95,  707,  586,  397,   74,  717,  595,   82,   75,  228, 
          397,  228,  228,  415,  714,  228,   91,  228,  717,  717, 
          720,  776,   83,   80,  723,  715,  557,  714,  714,   83, 
          603,  721,  617,  391,  746,  118,  397,  432,  724,  726, 
          392,  557,  432,  300,  717,   78,  723,  100,  200,  200, 
          586,  408,  106,  714,   76,  416,  720,  557,  557,  749, 
          723,   16,  753,  646,  648,  622,  213,  294,  215,  902, 
          745,  417,  900,  622,  228,  228,  228,  228,   83,  228, 
          228,  737,  106,  420,  422,  425,  101,  477,  429,  723, 
          681,  772,  501,  502,  503,  504,  100,  557,  557,  648, 
          433,  277,  294,  557,  226,  226,  226,  434,  277,  437, 
           16,  228,  457,  118,  228,  393,  228,   83,  300,  337, 
          228,  228,  461,   83,  337,  769,  750,  462,  397,  694, 
          463,  106,  725,  727,  468,  101,  465,  228,   83,  228, 
          337,  289,  475,  257,  263,  694,  476,  264,   91,  482, 
          707,   83,  525,  493,   83,  352,  736,  497,  228,  354, 
          355,  592,   83,  277,  455,  620,  625,  535,  635,  743, 
          557,  352,  228,  653,  654,  354,  355,  356,  357,  118, 
          655,  778,   14,   14,   14,  668,  679,  412,   14,   14, 
           15,   14,  118,  661,  413,  397,  680,  426,   97,  228, 
          689,   83,  797,  798,  427,  691,  911,  383,  690,  104, 
          449,  728,  813,  699,  814,  459,  693,  817,  712,  557, 
          701,  479,  460,  713,  730,  228,  300,  466,  480,  718, 
          557,  557,   97,  731,  849,  818,  820,   64,   64,   15, 
          719,  823,  825,   64,   64,   64,   64,  734,  694,   97, 
           64,   64,   95,  583,   64,  740,  747,  848,  104,  751, 
          757,   14,  758,  759,   87,   87,  120,  120,  483,  484, 
           87,  854,  855,  856,  760,  486,  245,  770,  491,  277, 
           64,   64,   14,  774,  648,  294,   64,  763,  788,  816, 
          283,   89,  828,  829,  836,  622,  837,  839,  850,  283, 
          851,  799,  852,  802,  100,  859,  806,   87,  858,  898, 
          784,  301,  862,   16,   16,   16,  899,  397,  865,   16, 
           16,  889,   16,  118,  866,  681,  638,  501,  502,  503, 
          504,  868,  256,  572,  300,  869,  226,  226,  471,  106, 
           92,  444,  403,  101,  870,  228,   83,   64,  566,   64, 
          723,  892,  391,  901,  301,  871,  535,   83,  682,  946, 
          873,  832,  875,  878,   83,  397,  448,  886,  450,  879, 
          539,  882,  397,  884,   92,  887,   87,  622,  652,  888, 
          572,  909,  891,  100,  397,  539,  656,  657,  897,  228, 
          906,   92,   16,  439,  853,  442,  907,  921,  397,  939, 
          277,  928,  927,  665,  535,  941,  666,  277,  936,  945, 
          948,  535,  300,   16,  937,  950,  535,  539,  952,   83, 
          955,  535,  557,  557,  557,  226,  226,  226,  226,  557, 
          532,  533,  397,  969,  958,  544,  557,  535,   90,  397, 
           83,   83,   15,   15,   15,  557,  546,   96,   15,   15, 
           83,   15,   83,  545,   64,   83,  228,  228,  550,  550, 
          546,  894,  228,  228,  552,  397,  104,   97,  681,  546, 
          501,  502,  503,  504,  228,  915,   64,   64,  300,   49, 
          557,   87,   98,  546,  922,  472,  924,  104,  294,   49, 
          610,  842,  557,  328,  284,   83,  557,  315,  228,  123, 
           64,  202,   64,   64,  957,  923,   64,  800,   64,   83, 
           83,   83,  896,   64,  329,  558,  277,  483,  484,  485, 
           64,   15,   89,  277,  486,  558,   98,  283,  732,   97, 
          247,   98,   99,  935,  283,  785,  283,  913,   49,  536, 
           87,  660,   15,  283,  483,  484,  488,   87,  536,  741, 
          659,  486,  964,   94,    0,    0,   89,    0,    0,   83, 
            0,  301,    0,  471,    0,   64,   64,   64,   64,   64, 
           64,   64,  228,   89,  558,  471,  103,    0,  105,   83, 
            0,   99,  471,    0,    0,    0,    0,   94,    0,    0, 
           92,   83,  483,  484,  490,    0,   87,    0,  773,  486, 
            0,    0,   64,  471,   94,   64,  539,   64,   64,   92, 
          535,   64,   64,  472,   64,    0,  483,  484,  494,    0, 
            0,    0,  919,  486,    0,  103,  789,  105,   64,   64, 
           64,  436,  436,  436,  536,   87,  301,  535,  436,    0, 
           83,   87,   64,    0,  228,   64,   83,    0,    0,   64, 
            0,    0,   83,   64,  539,    0,   87,  536,  535,  284, 
            0,  539,    0,   64,    0,  535,  535,    0,    0,   87, 
          535,   92,   87,   99,  681,    0,  501,  502,  503,  504, 
           87,  838,  105,    0,  539,  102,    0,  539,    0,    0, 
           64,  535,   64,  426,  426,  426,  226,    0,    0,    0, 
          426,    0,   96,   96,  121,  121,  121,  505,   96,  330, 
          331,  332,  333,  334,  249,    0,   64,  509,  510,   87, 
            0,  283,  472,  793,  860,  501,  502,  503,  504,  472, 
            0,  284,    0,    0,  102,    0,  283,   93,  284,   98, 
          226,   49,   49,   49,  301,   96,   49,   49,   49,  303, 
           49,    0,    0,   90,    0,   97,   97,  122,  122,  122, 
           49,   97,    0,    0,    0,    0,  539,  250,  283,   49, 
           49,   93,   49,   49,   49,   49,   49,  558,  558,  558, 
            0,    0,  558,  558,  558,   94,  558,   90,   93,   99, 
            0,   89,  303,    0,    0,    0,  558,  558,   97,    0, 
          471,    0,  304,    0,   90,  558,  558,  471,  558,  558, 
          558,  558,  558,    0,   96,    0,  183,    0,  539,    0, 
           49,    0,   94,  536,    0,  101,  535,    0,    0,    0, 
            0,    0,  536,  103,  472,  105,   64,   64,    0,    0, 
          471,   49,    0,    0,    0,  304,  536,  471,   64,  226, 
          472,    0,  301,   89,    0,   64,  558,  472,    0,  558, 
            0,  558,    0,    0,   87,  183,    0,   97,    0,    0, 
            0,  536,    0,    0,  535,   87,    0,  558,  536,    0, 
           64,  535,   87,  536,   94,  681,  535,  501,  502,  503, 
          504,    0,    0,    0,  536,    0,  284,    0,    0,  700, 
          702,  536,    0,  284,  536,  195,  536,  535,    0,    0, 
           64,    0,    0,  176,    0,  195,    0,    0,  682,   96, 
            0,    0,    0,   96,    0,    0,  683,  536,    0,    0, 
          301,   64,   64,    0,    0,    0,    0,   87,  783,    0, 
            0,   64,  102,   64,   90,   90,   64,   64,   64,  240, 
           90,    0,    0,   64,   64,  539,  246,   96,   87,   87, 
            0,    0,  176,    0,  195,   64,    0,    0,   87,    0, 
           87,    0,   97,   87,   96,  544,  544,  544,   96,    0, 
            0,  544,  544,    0,  544,   96,   64,   90,    0,   64, 
            0,    0,    0,   93,    0,    0,  301,    0,    0,  303, 
           64,   64,   64,  539,  284,  283,   93,  539,  337,  843, 
          539,    0,  283,   87,    0,  535,    0,  536,    0,    0, 
          103,  536,   90,    0,  350,  351,    0,   87,   87,   87, 
            0,   97,    0,    0,   96,  283,  539,    0,   97,  352, 
          539,  353,    0,  354,  355,  356,  357,   95,   95,  360, 
           64,  361,  304,   95,  544,  539,   90,    0,    0,    0, 
            0,    0,  539,   64,    0,    0,    0,  535,   93,  536, 
           64,  472,    0,   96,  303,  544,  536,   87,  472,   96, 
            0,  536,   64,    0,   90,    0,    0,   97,  539,    0, 
           95,    0,    0,    0,   96,    0,    0,   87,    0,    0, 
            0,    0,  536,    0,    0,    0,    0,   96,    0,   87, 
           96,    0,  183,    0,  183,  183,  183,  183,   96,   51, 
            0,    0,    0,    0,    0,    0,   97,  304,    0,   51, 
            0,   64,   97,    0,  465,   64,    0,   64,    0,    0, 
          120,  465,  693,   64,    0,  183,  183,   97,    0,    0, 
            0,    0,    0,  183,  183,  183,  183,   96,   87,   95, 
           97,   90,    0,   97,   87,    0,    0,  195,  195,  195, 
           87,   97,  867,  195,  195,    0,  195,    0,   51,    0, 
          872,  874,  303,  876,    0,  877,    0,  880,    0,  883, 
          885,    0,   96,    0,    0,  195,  195,    0,  195,  195, 
          195,  195,    0,  681,    0,  501,  502,  503,  504,  176, 
           97,  176,  176,  176,  176,  263,    0,    0,    0,    0, 
           90,    0,    0,    0,    0,  263,    0,   90,  102,  539, 
            0,  464,    0,    0,    0,  304,  682,    0,  464,    0, 
            0,  284,  176,  176,  863,    0,  195,    0,  284,    0, 
          176,  176,  176,  176,   96,    0,  545,  545,  545,  263, 
            0,    0,  545,  545,   95,  545,    0,  195,    0,    0, 
            0,    0,    0,    0,  263,    0,   90,  539,    0,    0, 
            0,    0,    0,  500,  539,  501,  502,  503,  504,  535, 
          303,    0,    0,    0,    0,  940,  942,  943,  944,    0, 
            0,  947,   96,  949,  951,  953,  954,    0,    0,    0, 
          539,    0,    0,   96,  587,   90,  505,  506,    0,    0, 
           96,   90,    0,   95,  507,  508,  509,  510,    0,    0, 
           95,    0,    0,    0,    0,  545,   90,    0,    0,    0, 
            0,  967,    0,  304,  968,  970,  971,  972,    0,   90, 
            0,    0,   90,    0,  974,   97,  545,  791,    0,    0, 
           90,    0,    0,    0,    0,    0,   97,  804,  303,    0, 
          808,    0,    0,   97,    0,   96,    0,    0,    0,   95, 
            0,   51,   51,   51,    0,    0,   51,   51,   51,  805, 
           51,  501,  502,  503,  504,    0,   96,   96,    0,   90, 
           51,    0,    0,    0,    0,    0,   96,    0,   96,   51, 
           51,   96,   51,   51,   51,   51,   51,    0,   95,    0, 
            0,  304,  505,    0,   95,    0,    0,    0,   97,    0, 
          507,  508,  509,  510,  303,   58,    0,  337,    0,   95, 
            0,    0,    0,    0,    0,   58,    0,  845,    0,   97, 
           97,   96,   95,  350,  351,   95,    0,    0,    0,   97, 
           51,   97,    0,   95,   97,   96,   96,   96,  352,    0, 
          353,    0,  354,  355,  356,  357,    0,  263,  263,  263, 
            0,   51,  263,  263,  263,    0,  263,  304,  500,    0, 
          501,  502,  503,  504,   58,    0,  263,  263,    0,    0, 
          846,    0,   95,    0,   97,  263,  263,    0,  263,  263, 
          263,  263,  263,    0,    0,   96,    0,    0,   97,   97, 
           97,  505,  611,  221,    0,    0,    0,    0,    0,  507, 
          508,  509,  510,  221,    0,   96,    0,  914,    0,  916, 
            0,  917,    0,    0,   90,  920,    0,   96,    0,    0, 
          925,    0,    0,    0,  337,   90,  263,    0,    0,  263, 
            0,  263,   90,    0,    0,    0,    0,  221,   97,    0, 
          350,  351,    0,    0,    0,    0,    0,  263,  121,    0, 
            0,  221,  221,    0,    0,  352,  221,    0,   97,  354, 
          355,  356,  357,  255,  255,    0,   96,  255,    0,    0, 
           97,  500,   96,  501,  502,  503,  504,  960,   96,    0, 
            0,    0,    0,    0,  963,    0,  965,   90,  966,  279, 
          281,    0,    0,    0,    0,  255,  255,    0,  305,  307, 
            0,  122,    0,    0,  505,  973,    0,    0,   90,   90, 
            0,    0,  507,  508,  509,  510,    0,   95,   90,   97, 
           90,    0,    0,   90,    0,   97,    0,    0,   95,    0, 
            0,   97,    0,    0,    0,   95,    0,    0,    0,    0, 
            0,    0,  587,    0,    0,    0,    0,    0,    0,    0, 
          805,    0,  501,  502,  503,  504,    0,    0,    0,  844, 
            0,    0,    0,   90,    0,    0,    0,   58,   58,   58, 
            0,    0,   58,   58,   58,    0,   58,   90,   90,   90, 
            0,    0,    0,  505,    0,    0,   58,   58,    0,    0, 
           95,  507,  508,  509,  510,   58,   58,    0,   58,   58, 
           58,   58,   58,    0,    0,    0,    0,    0,    0,    0, 
            0,   95,   95,    0,    0,    0,    0,    0,    0,    0, 
            0,   95,    0,   95,    0,    0,   95,   90,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   58,   90,    0,   58, 
            0,    0,    0,    0,    0,  221,  221,  221,    0,   90, 
          221,  221,  221,    0,  221,    0,   95,   58,    0,  557, 
            0,    0,    0,    0,  221,  221,    0,    0,    0,  557, 
           95,   95,   95,  221,  221,    0,  221,  221,  221,  221, 
          221,    0,    0,    0,    0,    0,    0,    0,  221,  255, 
          255,  255,  307,    0,    0,    0,    0,    0,   90,    0, 
            0,    0,    0,  255,   90,  255,  255,  221,  221,    0, 
           90,    0,  221,  221,  456,    0,    0,    0,  557,    0, 
           95,  221,    0,    0,  221,  337,    0,  221,    0,  221, 
          342,  343,    0,    0,    0,    0,    0,    0,    0,    0, 
           95,  350,  351,    0,    0,  221,    0,    0,    0,    0, 
            0,    0,   95,    0,    0,    0,  352,  221,  353,    0, 
          354,  355,  356,  357,  358,  359,  360,    0,  361,    0, 
            0,    0,    0,    0,    0,  534,  535,  536,  537,  538, 
          539,  540,  541,  542,  543,  544,  545,  546,  547,  548, 
          549,  550,  551,  552,  553,  554,  555,  556,  557,  558, 
          559,   95,    0,    0,    0,  255,    0,   95,  580,    0, 
          584,    0,    0,   95,  255,  597,    0,    0,    0,   53, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   53, 
            0,  255,    0,    0,    0,    0,    0,    0,    0,    0, 
          255,    0,    0,    0,    0,    0,    0,  186,    0,    0, 
            0,    0,  255,  580,  631,  597,    0,    0,  255,    0, 
            0,    0,    0,    0,    0,    0,  255,    0,    0,    0, 
            0,  255,  255,    0,    0,  255,    0,    0,   53,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  186,    0,    0,  662, 
          663,  664,    0,    0,    0,    0,    0,  255,    0,    0, 
          255,  171,    0,    0,    0,    0,  258,  258,  258,  255, 
          258,  557,  557,  557,  258,  258,  557,  557,  557,  258, 
          557,  258,  258,  258,  258,  258,  258,  258,    0,    0, 
          557,    0,  258,  258,  258,  258,  258,  258,  258,  557, 
          557,  258,  557,  557,  557,  557,  557,    0,  258,    0, 
          171,  258,  258,  258,    0,  258,  258,  258,  258,  258, 
          258,  258,  258,  258,  258,  258,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  557,    0,    0, 
            0,    0,    0,    0,  557,  258,    0,    0,  258,    0, 
          557,  258,  258,    0,  258,    0,  258,    0,  258,    0, 
          258,    0,    0,    0,    0,    0,    0,    0,  258,  255, 
            0,  557,    0,  258,  258,  258,  258,  258,  258,    0, 
            0,    0,  258,    0,  258,  258,    0,  258,  258,    0, 
          459,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          459,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   53,   53,   53,  459,  255,   53,   53,   53,    0, 
           53,    0,  255,  255,    0,    0,    0,    0,  459,  459, 
           53,  459,    0,  459,    0,    0,    0,    0,    0,   53, 
           53,    0,   53,   53,   53,   53,   53,    0,  255,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  459,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  186,    0,  186,  186,  186,  186,    0, 
          819,  821,    0,    0,    0,    0,  824,  826,    0,    0, 
           53,    0,    0,    0,  462,  466,    0,  830,  631,  255, 
            0,    0,  466,  834,  462,    0,  186,  186,    0,    0, 
            0,   53,    0,    0,  186,  186,  186,  186,    0,    0, 
            0,    0,    0,    0,    0,  819,  821,  824,  826,    0, 
            0,    0,  255,    0,    0,    0,    0,  171,  462,  171, 
          171,  171,  171,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  462,  462,    0,  462,    0,  462,    0,  467, 
            0,    0,    0,    0,    0,    0,  467,    0,    0,  272, 
          171,  171,    0,    0,    0,    0,    0,    0,  171,  171, 
          171,  171,    0,    0,  890,  462,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  893,    0,    0,  255, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  893, 
            0,    0,  362,    0,    0,    0,  255,  532,  532,  532, 
            0,  532,  459,  459,  459,  532,  532,  459,  459,  459, 
          532,  459,  532,  532,  532,  532,  532,  532,  532,  459, 
          532,  459,  459,  532,  532,  532,  532,  532,  532,  532, 
          459,  459,  532,  459,  459,  459,  459,  459,  255,  532, 
            0,    0,  532,  532,  532,  459,  532,  532,  532,  532, 
          532,  532,  532,  532,  532,  532,  532,  459,  459,  459, 
          459,  459,  459,  459,  459,  459,  459,  459,  459,  459, 
          459,    0,    0,  459,  459,  459,  532,  459,  459,  532, 
          532,  459,  532,  532,  459,  532,  459,  532,  459,  532, 
          459,  532,  459,  459,  459,  459,  459,  459,  459,  532, 
          459,  532,  459,    0,  532,  532,  532,  532,  532,  532, 
            0,    0,    0,  532,  459,  532,  532,  362,  532,  532, 
            0,  533,  533,  533,    0,  533,  462,  462,  462,  533, 
          533,  462,  462,  462,  533,  462,  533,  533,  533,  533, 
          533,  533,  533,  462,  533,  462,  462,  533,  533,  533, 
          533,  533,  533,  533,  462,  462,  533,  462,  462,  462, 
          462,  462,    0,  533,    0,    0,  533,  533,  533,  462, 
          533,  533,  533,  533,  533,  533,  533,  533,  533,  533, 
          533,  462,  462,  462,  462,  462,  462,  462,  462,  462, 
          462,  462,  462,  462,  462,    0,    0,  462,  462,  462, 
          533,  462,  462,  533,  533,  462,  533,  533,  462,  533, 
          462,  533,  462,  533,  462,  533,  462,  462,  462,  462, 
          462,  462,  462,  533,  462,  533,  462,    0,  533,  533, 
          533,  533,  533,  533,  535,    0,    0,  533,  462,  533, 
          533,    0,  533,  533,  535,    0,  337,  338,  339,  340, 
          341,  342,  343,  344,  345,  346,  347,    0,  348,  349, 
            0,    0,  350,  351,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  352,  535,  353, 
            0,  354,  355,  356,  357,  358,  359,  360,    0,  361, 
          561,  562,  535,  535,  563,  101,    0,  535,  169,  170, 
            0,  171,  172,  173,  174,  175,  176,  177,    0,    0, 
          178,  179,    0,    0,    0,  180,  181,  182,  183,    0, 
            0,    0,    0,    0,  268,  535,    0,    0,    0,    0, 
            0,  185,  186,    0,  187,  188,  189,  190,  191,  192, 
          193,  194,  195,  196,  197,    0,    0,  198,    0,    0, 
            0,  729,    0,    0,    0,    0,    0,  536,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  536,    0,    0, 
            0,  337,  338,  339,  340,  341,  342,  343,  344,  345, 
          346,  347,    0,  348,  349,    0,    0,  350,  351,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  536,  352,    0,  353,    0,  354,  355,  356,  357, 
          358,  359,  360,    0,  361,  536,  536,    0,  103,    0, 
          536,    0,    0,    0,  567,  568,    0,    0,  569,    0, 
            0,    0,  169,  170,    0,  171,  172,  173,  174,  175, 
          176,  177,    0,    0,  178,  179,    0,    0,  536,  180, 
          181,  182,  183,    0,    0,    0,    0,    0,  268,    0, 
            0,    0,    0,    0,  153,  185,  186,    0,  187,  188, 
          189,  190,  191,  192,  193,  194,  195,  196,  197,    0, 
            0,  198,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  535,  535,  535,    0,  535,  535,  535,  535,  535, 
          535,  535,  535,  535,  535,  535,  535,  535,  535,  535, 
          535,  535,  535,  153,  535,  535,  535,  535,  535,  535, 
          535,  535,  535,  535,  535,  535,  535,  535,  535,  535, 
          535,  535,    0,  535,    0,    0,  535,  535,  535,  535, 
          535,  535,  535,  535,  535,  535,  535,  535,  535,  535, 
          535,  535,  535,  535,  535,  535,  535,  535,  535,  535, 
          535,  535,  535,  535,  535,    0,    0,  535,  535,  535, 
          535,    0,  535,  535,  535,  535,  535,  535,  535,  535, 
          535,  535,  535,  535,  535,  535,  535,  535,  535,  535, 
          535,  535,  535,  535,  535,  535,  535,    0,  535,  535, 
          535,  535,  535,  535,    0,    0,  154,  535,  535,  535, 
          535,    0,  535,  535,  536,  536,  536,    0,  536,  536, 
          536,  536,  536,  536,  536,  536,  536,  536,  536,  536, 
          536,  536,  536,  536,  536,  536,    0,  536,  536,  536, 
          536,  536,  536,  536,  536,  536,  536,  536,  536,  536, 
          536,  536,  536,  536,  536,  154,  536,    0,    0,  536, 
          536,  536,  536,  536,  536,  536,  536,  536,  536,  536, 
          536,  536,  536,  536,  536,  536,  536,  536,  536,  536, 
          536,  536,  536,  536,  536,  536,  536,  536,    0,    0, 
          536,  536,  536,  536,    0,  536,  536,  536,  536,  536, 
          536,  536,  536,  536,  536,  536,  536,  536,  536,  536, 
          536,  536,  536,  536,  536,  536,  536,  536,  536,  536, 
            0,  536,  536,  536,  536,  536,  536,  539,    0,    0, 
          536,  536,  536,  536,    0,  536,  536,  539,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          153,    0,  153,  153,  153,  153,    0,    0,    0,    0, 
            0,  539,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  469,    0,    0,  539,  539,    0,  102,  469, 
          539,    0,    0,  153,  153,    0,    0,    0,    0,    0, 
            0,  153,  153,  153,  153,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  539,    0, 
          575,  562,    0,    0,  576,    0,    0,    0,  169,  170, 
            0,  171,  172,  173,  174,  175,  176,  177,    0,    0, 
          178,  179,    0,    0,    0,  180,  181,  182,  183,    0, 
          278,    0,    0,    0,  268,    0,    0,    0,    0,    0, 
          278,  185,  186,    0,  187,  188,  189,  190,  191,  192, 
          193,  194,  195,  196,  197,    0,    0,  198,    0,  337, 
          338,  339,  340,  341,  342,  343,  344,  345,  346,  347, 
            0,    0,    0,    0,  278,  350,  351,    0,    0,    0, 
            0,    0,  154,    0,  154,  154,  154,  154,  278,  278, 
          352,    0,  353,  278,  354,  355,  356,  357,  358,  359, 
          360,    0,  361,    0,  468,    0,    0,    0,    0,    0, 
            0,  468,    0,    0,    0,  154,  154,    0,    0,    0, 
            0,  278,    0,  154,  154,  154,  154,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  535,  535,  535,    0,  535,  539, 
          539,  539,  535,  535,  539,  539,  539,  535,  539,  535, 
          535,  535,  535,  535,  535,  535,    0,  539,  539,  539, 
          535,  535,  535,  535,  535,  535,  535,  539,  539,  535, 
          539,  539,  539,  539,  539,  272,  535,    0,    0,  535, 
          535,  535,  539,  535,  535,  535,  535,  535,  535,  535, 
          535,  535,  535,  535,  539,  539,  539,  539,  539,  539, 
          539,  539,  539,  539,  539,  539,  539,  539,    0,    0, 
          539,  539,  539,  535,    0,  539,  535,  535,  539,  535, 
          535,  539,  535,  539,  535,  539,  535,  539,  535,  539, 
          539,  539,  539,  539,  539,  539,  535,  539,  539,  539, 
            0,  535,  535,  535,  535,  535,  535,    0,    0,  155, 
          535,  539,  535,  535,    0,  535,  535,  534,  534,  534, 
            0,  534,  278,  278,  278,  534,  534,  278,  278,  278, 
          534,  278,  534,  534,  534,  534,  534,  534,  534,    0, 
          534,  278,  278,  534,  534,  534,  534,  534,  534,  534, 
          278,  278,  534,  278,  278,  278,  278,  278,  155,  534, 
            0,    0,  534,  534,  534,  278,  534,  534,  534,  534, 
          534,  534,  534,  534,  534,  534,  534,  278,  278,  278, 
          278,  278,  278,  278,  278,  278,  278,  278,  278,  278, 
          278,    0,    0,  278,  278,  278,  534,    0,  278,  534, 
          534,  278,  534,  534,  278,  534,  278,  534,  278,  534, 
          278,  534,  278,  278,  278,  278,  278,  278,  278,  534, 
          278,  534,  278,    0,  534,  534,  534,  534,  534,  534, 
          540,    0,    0,  534,  278,  534,  534,    0,  534,  534, 
          540,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  540,    0,    0,    0,    0,    0, 
            0,    0,    4,    5,    6,    0,    8,    0,  540,  540, 
            9,   10,    0,  540,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,  107,    0,    0, 
            0,  540,    0,    0,   28,    0,    0,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,  251,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  541,    0,    0,    0,    0,    0,    0, 
            0,  225,    0,  541,  114,    0,    0,   46,   47,    0, 
           48,    0,  252,    0,  253,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  254,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,  541,   58,    0, 
           59,   60,    0,   61,   62,  155,    0,  155,  155,  155, 
          155,  541,  541,    0,    0,    0,  541,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  470,    0,    0, 
            0,    0,    0,    0,  470,    0,    0,    0,  155,  155, 
            0,    0,    0,    0,  541,    0,  155,  155,  155,  155, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          112,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  537,  537,  537, 
            0,  537,  540,  540,  540,  537,  537,  540,  540,  540, 
          537,  540,  537,  537,  537,  537,  537,  537,  537,  112, 
          540,  540,  540,  537,  537,  537,  537,  537,  537,  537, 
          540,  540,  537,  540,  540,  540,  540,  540,    0,  537, 
            0,    0,  537,  537,  537,  540,  537,  537,  537,  537, 
          537,  537,  537,  537,  537,  537,  537,  540,  540,  540, 
          540,  540,  540,  540,  540,  540,  540,  540,  540,  540, 
          540,    0,    0,  540,  540,  540,  537,    0,  540,  537, 
          537,  540,  537,  537,  540,  537,  540,  537,  540,  537, 
          540,  537,  540,  540,  540,  540,  540,  540,  540,  537, 
          540,  540,  540,    0,  537,  537,  537,  537,  537,  537, 
            0,    0,  113,  537,  540,  537,  537,    0,  537,  537, 
          538,  538,  538,    0,  538,  541,  541,  541,  538,  538, 
          541,  541,  541,  538,  541,  538,  538,  538,  538,  538, 
          538,  538,    0,  541,  541,  541,  538,  538,  538,  538, 
          538,  538,  538,  541,  541,  538,  541,  541,  541,  541, 
          541,  113,  538,    0,    0,  538,  538,  538,  541,  538, 
          538,  538,  538,  538,  538,  538,  538,  538,  538,  538, 
          541,  541,  541,  541,  541,  541,  541,  541,  541,  541, 
          541,  541,  541,  541,    0,    0,  541,  541,  541,  538, 
            0,  541,  538,  538,  541,  538,  538,  541,  538,  541, 
          538,  541,  538,  541,  538,  541,  541,  541,  541,  541, 
          541,  541,  538,  541,  541,  541,    0,  538,  538,  538, 
          538,  538,  538,  283,    0,    0,  538,  541,  538,  538, 
            0,  538,  538,  283,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  112,    0,  112,  112, 
          112,  112,    0,    0,    0,    0,    0,  283,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  459,    0, 
            0,  283,  283,    0,  104,  459,  283,    0,    0,  112, 
          112,    0,    0,    0,    0,    0,    0,  112,  112,  112, 
          112,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  283,    0,  604,  568,    0,    0, 
          605,    0,    0,    0,  169,  170,    0,  171,  172,  173, 
          174,  175,  176,  177,    0,    0,  178,  179,    0,    0, 
            0,  180,  181,  182,  183,    0,  396,    0,    0,    0, 
          268,    0,    0,    0,    0,    0,  396,  185,  186,    0, 
          187,  188,  189,  190,  191,  192,  193,  194,  195,  196, 
          197,    0,    0,  198,    0,  337,  338,  339,  340,  341, 
          342,  343,  344,    0,  346,  347,    0,    0,    0,    0, 
          396,  350,  351,    0,    0,    0,    0,    0,  113,    0, 
          113,  113,  113,  113,    0,  396,  352,    0,  353,  396, 
          354,  355,  356,  357,  358,  359,  360,    0,  361,    0, 
          462,    0,    0,    0,    0,    0,    0,  462,    0,    0, 
            0,  113,  113,    0,    0,    0,    0,  396,    0,  113, 
          113,  113,  113,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          536,  536,  536,    0,  536,  283,  283,  283,  536,  536, 
          283,  283,  283,  536,  283,  536,  536,  536, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

          536,  536,  536,  536,    0,    0,  283,  283,  536,  536, 
          536,  536,  536,  536,  536,  283,  283,  536,  283,  283, 
          283,  283,  283,  272,  536,    0,    0,  536,  536,  536, 
          283,  536,  536,  536,  536,  536,  536,  536,  536,  536, 
          536,  536,  283,  283,  283,  283,  283,  283,  283,  283, 
          283,  283,  283,  283,  283,  283,    0,    0,  283,  283, 
          283,  536,    0,  283,  536,  536,  283,  536,  536,  283, 
          536,  283,  536,  283,  536,  283,  536,  283,  283,  283, 
          283,  283,  283,  283,  536,  283,    0,  283,    0,  536, 
          536,  536,  536,  536,  536,    0,    0,    0,  536,  283, 
          536,  536,    0,  536,  536,  258,  258,  258,    0,  258, 
          396,  396,  396,  258,  258,  396,  396,  396,  258,  396, 
          258,  258,  258,  258,  258,  258,  258,    0,  396,  396, 
          396,  258,  258,  258,  258,  258,  258,  258,  396,  396, 
          258,  396,  396,  396,  396,  396,    0,  258,    0,    0, 
          258,  258,  258,  362,  258,  258,  258,  258,  258,  258, 
          258,  258,  258,  258,  258,  396,  396,  396,  396,  396, 
          396,  396,  396,  396,  396,  396,  396,  396,  396,    0, 
            0,  396,  396,  396,  258,    0,  396,  258,    0,  396, 
          258,  258,  396,  258,  396,  258,  396,  258,  396,  258, 
          396,  396,  396,  396,  396,  396,  396,  258,  396,  396, 
          396,    0,  258,  258,  258,  258,  258,  258,  557,    0, 
            0,  258,    0,  258,  258,    0,  258,  258,  557,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  557,    0,    0,    0,    0,    0,    0,    0, 
            4,    5,    6,    0,    8,    0,    0,  557,    9,   10, 
            0,  557,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,   22, 
           23,   24,   25,    0,    0,   26,    0,    0,    0,  557, 
            0,    0,   28,    0,    0,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  290,    0,    0,    0,    0,    0,    0,    0,  225, 
            0,  290,  114,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,   51,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,  290,   58,  735,   59,   60, 
            0,   61,   62,    0,    0,    0,    0,    0,    0,    0, 
          290,    0,    0,    0,  290,    0,    0,  337,  338,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,    0,  348, 
          349,    0,    0,  350,  351,    0,    0,    0,    0,    0, 
            0,    0,  290,    0,    0,    0,    0,    0,  352,    0, 
          353,    0,  354,  355,  356,  357,  358,  359,  360,    0, 
          361,    0,    0,    0,    0,    0,    0,    0,    0,   60, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   60, 
            0,    0,    0,    0,    0,  258,  258,  258,    0,  258, 
          557,  557,  557,  258,  258,  557,  557,  557,  258,  557, 
          258,  258,  258,  258,  258,  258,  258,    0,  557,  557, 
          557,  258,  258,  258,  258,  258,  258,  258,  557,  557, 
          258,  557,  557,  557,  557,  557,    0,  258,   60,  362, 
          258,  258,  258,    0,  258,  258,  258,  258,  258,  258, 
          258,  258,  258,  258,  258,  557,  557,  557,  557,  557, 
          557,  557,  557,  557,  557,  557,  557,  557,  557,    0, 
            0,  557,  557,  557,  258,    0,  557,  258,    0,  557, 
          258,  258,  557,  258,  557,  258,  557,  258,  557,  258, 
          557,  557,  557,  557,  557,  557,  557,  258,  557,  557, 
          557,    0,  258,  258,  258,  258,  258,  258,    0,    0, 
            0,  258,    0,  258,  258,    0,  258,  258,  258,  258, 
          258,    0,  258,  290,  290,  290,  258,  258,  290,  290, 
          290,  258,  290,  258,  258,  258,  258,  258,  258,  258, 
            0,    0,  290,  290,  258,  258,  258,  258,  258,  258, 
          258,  290,  290,  258,  290,  290,  290,  290,  290,    0, 
          258,    0,    0,  258,  258,  258,    0,  258,  258,  258, 
          258,  258,  258,  258,  258,  258,  258,  258,  290,  290, 
          290,  290,  290,  290,  290,  290,  290,  290,  290,  290, 
          290,  290,    0,    0,  290,  290,  290,  258,    0,  290, 
          258,    0,  290,  258,  258,  290,  258,  290,  258,  290, 
          258,  290,  258,  290,  290,  290,  290,  290,  290,  290, 
          258,  290,  535,  290,    0,  258,  258,  258,  258,  258, 
          258,    0,  535,    0,  258,    0,  258,  258,    0,  258, 
          258,   60,   60,   60,    0,    0,   60,   60,   60,    0, 
           60,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           60,   60,    0,    0,    0,    0,   92,    0,    0,   60, 
           60,    0,   60,   60,   60,   60,   60,    0,    0,    0, 
            0,  535,    0,  101,    0,  535,    0,    0,    0,    0, 
            0,    0,    0,  337,  338,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,    0,  348,  349,    0,    0,  350, 
          351,    0,    0,  535,    0,    0,    0,    0,    0,    0, 
           60,    0,    0,   60,  352,    0,  353,    0,  354,  355, 
          356,  357,  358,  359,  360,    0,  361,    0,    0,    0, 
            0,   60,    0,    0,    0,  536,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  536,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  626,  562,    0,    0,  627,    0,    0,    0,  169, 
          170,    0,  171,  172,  173,  174,  175,  176,  177,   94, 
            0,  178,  179,    0,    0,    0,  180,  181,  182,  183, 
            0,    0,    0,    0,  536,  268,  103,    0,  536,    0, 
            0,    0,  185,  186,    0,  187,  188,  189,  190,  191, 
          192,  193,  194,  195,  196,  197,    0,    0,  198,    0, 
            0,    0,    0,    0,    0,    0,  536,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   50,  535, 
          535,  535,    0,  535,  535,  535,  535,  535,  535,    0, 
          535,  535,  535,  535,  535,  535,  535,  535,  535,  535, 
          535,    0,  535,    0,    0,  535,  535,  535,  535,  535, 
          535,  535,  535,  535,  535,  535,  535,  535,  535,  535, 
            0,  535,    0,    0,  535,  535,  535,   50,  535,  535, 
          535,  535,  535,  535,  535,  535,  535,  535,  535,  535, 
          535,  535,  535,  535,  535,  535,  535,  535,  535,  535, 
          535,  535,  535,    0,    0,  535,  535,  535,  535,    0, 
            0,  535,  535,  535,  535,  535,    0,  535,    0,  535, 
          535,  535,  535,  535,  535,  535,  535,  535,  535,  535, 
          535,  535,  535,  535,  535,    0,  535,  535,  535,  535, 
          535,  535,    0,    0,    0,  535,    0,  535,  535,    0, 
          535,  535,  536,  536,  536,    0,  536,  536,  536,  536, 
          536,  536,    0,  536,  536,  536,  536,  536,  536,  536, 
          536,  536,  536,  536,    0,  536,    0,    0,  536,  536, 
          536,  536,  536,  536,  536,  536,  536,  536,  536,  536, 
          536,  536,  536,    0,  536,    0,    0,  536,  536,  536, 
            0,  536,  536,  536,  536,  536,  536,  536,  536,  536, 
          536,  536,  536,  536,  536,  536,  536,  536,  536,  536, 
          536,  536,  536,  536,  536,  536,    0,    0,  536,  536, 
          536,  536,    0,    0,  536,  536,  536,  536,  536,    0, 
          536,    0,  536,  536,  536,  536,  536,  536,  536,  536, 
          536,  536,  536,  536,  536,  536,  536,  536,    0,  536, 
          536,  536,  536,  536,  536,  539,    0,    0,  536,    0, 
          536,  536,    0,  536,  536,  539,    0,    0,    0,    0, 
           50,   50,   50,    0,    0,   50,   50,   50,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   93, 
            0,   50,   50,   50,   50,   50,    0,    0,    0,    0, 
            0,    0,    0,    0,  539,    0,  102,    0,  539,  337, 
          338,  339,  340,  341,  342,  343,    0,    0,  346,  347, 
            0,    0,    0,    0,    0,  350,  351,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  539,    0,    0,   50, 
          352,    0,  353,    0,  354,  355,  356,  357,  358,  359, 
          360,    0,  361,    0,    4,    5,    6,    0,    8,    0, 
           50,    0,    9,   10,    0,    0,    0,   11,  283,   12, 
           13,   14,  102,  103,   17,   18,    0,    0,  283,    0, 
          104,  105,  106,   22,   23,   24,   25,    0,    0,  107, 
            0,    0,    0,    0,    0,    0,  108,    0,    0,   31, 
           32,   33,    0,  109,   35,   36,   37,  110,   39,    0, 
           40,    0,   95,  111,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  283,    0,  104, 
          112,  283,    0,  113,    0,    0,  114,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  283, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   62,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   62,    0,    0, 
            0,    0,  535,  535,  535,    0,  535,  539,  539,  539, 
          535,  535,    0,  539,  539,  535,  539,  535,  535,  535, 
          535,  535,  535,  535,    0,  539,    0,    0,  535,  535, 
          535,  535,  535,  535,  535,  539,  539,  535,  539,  539, 
          539,  539,  539,    0,  535,    0,   62,  535,  535,  535, 
            0,  535,  535,  535,  535,  535,  535,  535,  535,  535, 
          535,  535,  539,  539,  539,  539,  539,  539,  539,  539, 
          539,  539,  539,  539,  539,  539,    0,    0,  539,  539, 
          539,  535,    0,    0,  535,  535,  539,  535,  535,    0, 
          535,    0,  535,  539,  535,  539,  535,  539,  539,  539, 
          539,  539,  539,  539,  535,  539,  539,  539,    0,  535, 
          535,  535,  535,  535,  535,    0,    0,    0,  535,    0, 
          535,  535,    0,  535,  535,  536,  536,  536,    0,  536, 
          283,  283,  283,  536,  536,    0,  283,  283,  536,  283, 
          536,  536,  536,  536,  536,  536,  536,    0,    0,    0, 
            0,  536,  536,  536,  536,  536,  536,  536,  283,  283, 
          536,  283,  283,  283,  283,  283,    0,  536,    0,    0, 
          536,  536,  536,    0,  536,  536,  536,  536,  536,  536, 
          536,  536,  536,  536,  536,  283,  283,  283,  283,  283, 
          283,  283,  283,  283,  283,  283,  283,  283,  283,    0, 
            0,  283,  283,  283,  536,    0,    0,  536,  536,  283, 
          536,  536,    0,  536,    0,  536,  283,  536,  283,  536, 
          283,  283,  283,  283,  283,  283,  283,  536,  283,  397, 
          283,    0,  536,  536,  536,  536,  536,  536,    0,  397, 
            0,  536,    0,  536,  536,    0,  536,  536,    0,   62, 
           62,   62,    0,    0,   62,   62,   62,    0,   62,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   62,   62, 
            0,    0,    0,  397,    0,    0,    0,   62,   62,    0, 
           62,   62,   62,   62,   62,    0,    0,  397,  397,    0, 
          100,    0,  397,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          397,    0,    0,    0,    0,    0,    0,    0,   62,    0, 
          396,   62,    0,    0,    0,    0,    0,    0,    0,    0, 
          396,    0,    0,    0,    0,    0,    0,    0,    0,   62, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  102,  103, 
           17,   18,    0,    0,  396,    0,  104,  105,  106,   22, 
           23,   24,   25,    0,    0,  107,    0,    0,  396,  396, 
            0,    0,  108,  396,    0,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,    0,    0,  111, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  396,    0,    0,    0,    0,    0,    0,    0,  243, 
            0,    0,   45,    0,    0,   46,   47,    0,   48,    0, 
           49,    0,    0,    0,  471,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  471,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  471,    0, 
            0,  397,  397,  397,    0,    0,  397,  397,  397,    0, 
          397,    0,  471,  471,    0,   98,    0,  471,    0,  397, 
          397,  397,    0,    0,    0,    0,    0,    0,    0,  397, 
          397,    0,  397,  397,  397,  397,  397,    0,    0,    0, 
            0,    0,    0,    0,  397,  471,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  397,  397,  397,  397, 
          397,  397,  397,  397,  397,  397,  397,  397,  397,  397, 
            0,    0,  397,  397,  397,    0,    0,  397,    0,    0, 
          397,    0,    0,  397,    0,  397,    0,  397,  472,  397, 
            0,  397,  397,  397,  397,  397,  397,  397,  472,  397, 
          397,  397,  396,  396,  396,    0,    0,  396,  396,  396, 
            0,  396,    0,  397,    0,    0,    0,    0,    0,    0, 
          396,  396,  396,    0,    0,    0,    0,    0,    0,    0, 
          396,  396,  472,  396,  396,  396,  396,  396,    0,    0, 
            0,    0,    0,    0,    0,  396,  472,  472,    0,   99, 
            0,  472,    0,    0,    0,    0,    0,  396,  396,  396, 
          396,  396,  396,  396,  396,  396,  396,  396,  396,  396, 
          396,    0,    0,  396,  396,  396,    0,    0,  396,  472, 
            0,  396,    0,    0,  396,    0,  396,    0,  396,    0, 
          396,    0,  396,  396,  396,  396,  396,  396,  396,    0, 
          396,  396,  396,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  396,    0,  471,  471,  471,    0, 
            0,  471,  471,  471,    0,  471,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  471,  471,    0,    0,    0, 
            0,    0,    0,    0,  471,  471,    0,  471,  471,  471, 
          471,  471,    0,    0,    0,    0,    0,    0,    0,  471, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  471,  471,  471,  471,  471,  471,  471,  471,  471, 
          471,  471,  471,  471,  471,    0,  557,  471,  471,  471, 
            0,  473,  471,    0,    0,  471,  557,    0,  471,    0, 
          471,    0,  471,    0,  471,    0,  471,  471,  471,  471, 
          471,  471,  471,    0,  471,    0,  471,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  471,    0, 
          557,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  557,  557,    0,    0,    0,  557, 
          472,  472,  472,    0,    0,  472,  472,  472,    0,  472, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  472, 
          472,    0,    0,    0,    0,    0,    0,  557,  472,  472, 
            0,  472,  472,  472,  472,  472,    0,    0,    0,    0, 
            0,    0,    0,  472,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  472,  472,  472,  472,  472, 
          472,  472,  472,  472,  472,  472,  472,  472,  472,    0, 
          277,  472,  472,  472,    0,  474,  472,    0,    0,  472, 
          277,    0,  472,    0,  472,    0,  472,    0,  472,    0, 
          472,  472,  472,  472,  472,  472,  472,    0,  472,    0, 
          472,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  472,    0,  277,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  628,  568,  277,  277, 
          629,  106,    0,  277,  169,  170,    0,  171,  172,  173, 
          174,  175,  176,  177,    0,    0,  178,  179,    0,    0, 
            0,  180,  181,  182,  183,    0,    0,    0,    0,    0, 
          268,  277,    0,    0,    0,    0,    0,  185,  186,    0, 
          187,  188,  189,  190,  191,  192,  193,  194,  195,  196, 
          197,    0,    0,  198,  284,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  284,    0,    0,    0,  557,  557, 
          557,    0,    0,  557,  557,  557,    0,  557,    0,    0, 
            0,    0,    0,    0,    0,    0,  557,  557,  557,    0, 
            0,    0,    0,    0,    0,    0,  557,  557,  284,  557, 
          557,  557,  557,  557,    0,    0,    0,    0,    0,    0, 
            0,  557,  284,  284,    0,  105,    0,  284,    0,    0, 
            0,    0,    0,  557,  557,  557,  557,  557,  557,  557, 
          557,  557,  557,  557,  557,  557,  557,    0,    0,  557, 
          557,  557,    0,    0,  557,  284,    0,  557,    0,    0, 
          557,    0,  557,    0,  557,  417,  557,    0,  557,  557, 
          557,  557,  557,  557,  557,  417,  557,  557,  557,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          557,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  417, 
            0,    0,  277,  277,  277,    0,    0,  277,  277,  277, 
            0,  277,    0,  417,  417,    0,    0,    0,  417,    0, 
            0,  277,  277,    0,    0,    0,    0,    0,    0,    0, 
          277,  277,    0,  277,  277,  277,  277,  277,    0,    0, 
            0,    0,    0,    0,    0,  277,  417,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  277,  277,  277, 
          277,  277,  277,  277,  277,  277,  277,  277,  277,  277, 
          277,    0,    0,  277,  277,  277,    0,    0,  277,    0, 
            0,  277,    0,    0,  277,    0,  277,    0,  277,    0, 
          277,    0,  277,  277,  277,  277,  277,  277,  277,  295, 
          277,    0,  277,    0,    0,    0,    0,    0,    0,  295, 
            0,    0,    0,    0,  277,    0,  284,  284,  284,    0, 
            0,  284,  284,  284,    0,  284,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  284,  284,    0,    0,    0, 
            0,    0,    0,  295,  284,  284,    0,  284,  284,  284, 
          284,  284,    0,    0,    0,    0,    0,  295,  295,  284, 
            0,    0,  295,    0,    0,    0,    0,    0,    0,    0, 
            0,  284,  284,  284,  284,  284,  284,  284,  284,  284, 
          284,  284,  284,  284,  284,    0,    0,  284,  284,  284, 
          295,    0,  284,    0,    0,  284,    0,    0,  284,    0, 
          284,    0,  284,  239,  284,    0,  284,  284,  284,  284, 
          284,  284,  284,  239,  284,    0,  284,  417,  417,  417, 
            0,    0,  417,  417,  417,    0,  417,    0,  284,    0, 
            0,    0,    0,    0,    0,    0,  417,  417,    0,    0, 
            0,    0,    0,    0,    0,  417,  417,  239,  417,  417, 
          417,  417,  417,    0,    0,    0,    0,    0,    0,    0, 
          417,  239,  239,    0,    0,    0,  239,    0,    0,    0, 
            0,    0,  417,  417,  417,  417,  417,  417,  417,  417, 
          417,  417,  417,  417,  417,  417,    0,    0,  417,  417, 
          417,    0,    0,  417,  327,    0,  417,    0,    0,  417, 
            0,  417,    0,  417,    0,  417,    0,  417,  417,  417, 
          417,  417,  417,  417,    0,  417,  290,  417,    0,    0, 
            0,    0,    0,    0,    0,    0,  290,    0,    0,  417, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          290,  295,  295,  295,    0,    0,  295,  295,  295,    0, 
          295,    0,    0,    0,  290,  290,    0,    0,    0,  290, 
          295,  295,    0,    0,    0,    0,    0,    0,    0,  295, 
          295,    0,  295,  295,  295,  295,  295,    0,    0,    0, 
            0,    0,    0,    0,  295,    0,    0,  290,    0,    0, 
            0,    0,    0,    0,    0,    0,  295,  295,  295,  295, 
          295,  295,  295,  295,  295,  295,  295,  295,  295,  295, 
            0,    0,  295,  295,  295,    0,    0,  295,    0,    0, 
          295,    0,    0,  295,    0,  295,    0,  295,  457,  295, 
            0,  295,  295,  295,  295,  295,  295,  295,  457,  295, 
            0,  295,    0,    0,    0,  239,  239,  239,    0,    0, 
          239,  239,  239,  295,  239,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  239,  239,    0,    0,    0,    0, 
            0,    0,  457,  239,  239,    0,  239,  239,  239,  239, 
          239,    0,    0,    0,    0,    0,  457,  457,  239,    0, 
            0,  457,    0,    0,    0,    0,    0,    0,    0,    0, 
          239,  239,  239,  239,  239,  239,  239,  239,  239,  239, 
          239,  327,  239,  239,    0,    0,  239,  239,  327,  457, 
            0,  239,    0,    0,  239,    0,    0,  239,    0,  239, 
            0,  239,    0,  239,    0,  239,  239,  239,  239,  239, 
          239,  239,    0,  239,  458,  239,    0,    0,    0,    0, 
            0,    0,    0,    0,  458,    0,    0,  239,  290,  290, 
          290,    0,    0,  290,  290,  290,    0,  290,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  290,  290,    0, 
            0,    0,    0,    0,    0,    0,  290,  290,  458,  290, 
          290,  290,  290,  290,    0,    0,    0,    0,    0,    0, 
            0,  290,  458,  458,    0,    0,    0,  458,    0,    0, 
            0,    0,    0,  290,  290,  290,  290,  290,  290,  290, 
          290,  290,  290,  290,  290,  290,  290,    0,    0,  290, 
          290,  290,    0,    0,  290,  458,    0,  290,    0,    0, 
          290,    0,  290,    0,  290,  217,  290,    0,  290,  290, 
          290,  290,  290,  290,  290,  217,  290,    0,  290,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          290,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  217, 
          457,  457,  457,    0,    0,  457,  457,  457,    0,  457, 
            0,    0,    0,  217,  217,    0,    0,    0,  217,  457, 
          457,    0,    0,    0,    0,    0,    0,    0,  457,  457, 
            0,  457,  457,  457,  457,  457,    0,    0,    0,    0, 
            0,    0,    0,  457,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  457,  457,  457,  457, 
          457,  457,  457,  457,  457,  457,  457,  457,  457,    0, 
          213,  457,  457,  457,    0,    0,  457,    0,    0,  457, 
          213,    0,  457,    0,  457,    0,  457,    0,  457,    0, 
          457,  457,  457,  457,  457,  457,  457,    0,  457,    0, 
          457,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  457,    0,  213,    0,  458,  458,  458,    0, 
            0,  458,  458,  458,    0,  458,    0,    0,  213,  213, 
            0,    0,    0,  213,    0,  458,  458,    0,    0,    0, 
            0,    0,    0,    0,  458,  458,    0,  458,  458,  458, 
          458,  458,    0,    0,    0,    0,    0,    0,    0,  458, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  458,  458,  458,  458,  458,  458,  458,  458, 
          458,  458,  458,  458,  458,    0,    0,  458,  458,  458, 
            0,    0,  458,    0,    0,  458,    0,    0,  458,    0, 
          458,    0,  458,  210,  458,    0,  458,  458,  458,  458, 
          458,  458,  458,  210,  458,    0,  458,  217,  217,  217, 
            0,    0,  217,  217,  217,    0,  217,    0,  458,    0, 
            0,    0,    0,    0,    0,    0,  217,  217,    0,    0, 
            0,    0,    0,    0,    0,  217,  217,  210,  217,  217, 
          217,  217,  217,    0,    0,    0,    0,    0,    0,    0, 
          217,  210,  210,    0,    0,    0,  210,    0,    0,    0, 
            0,    0,    0,  217,  217,  217,  217,  217,  217,  217, 
          217,  217,  217,    0,  217,  217,    0,    0,  217,  217, 
            0,    0,    0,  217,    0,    0,  217,    0,    0,  217, 
            0,  217,    0,  217,    0,  217,    0,  217,  217,  217, 
          217,  217,  217,  217,    0,  217,    0,  217,  212,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  212,  217, 
            0,    0,  213,  213,  213,    0,    0,  213,  213,  213, 
            0,  213,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  213,  213,    0,    0,    0,    0,    0,    0,    0, 
          213,  213,  212,  213,  213,  213,  213,  213,    0,    0, 
            0,    0,    0,    0,    0,  213,  212,  212,    0,    0, 
            0,  212,    0,    0,    0,    0,    0,    0,  213,  213, 
          213,  213,  213,  213,  213,  213,  213,  213,    0,  213, 
          213,    0,    0,  213,  213,    0,    0,    0,  213,    0, 
            0,  213,    0,    0,  213,    0,  213,    0,  213,  211, 
          213,    0,  213,  213,  213,  213,  213,  213,  213,  211, 
          213,    0,  213,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  213,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  211,    0,  210,  210,  210,    0,    0, 
          210,  210,  210,    0,  210,    0,    0,  211,  211,    0, 
            0,    0,  211,    0,  210,  210,    0,    0,    0,    0, 
            0,    0,    0,  210,  210,    0,  210,  210,  210,  210, 
          210,    0,    0,    0,    0,    0,    0,    0,  210,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  210,  210,  210,  210,  210,  210,  210,  210,  210, 
          210,    0,  210,  210,    0,  214,  210,  210,    0,    0, 
            0,  210,    0,    0,  210,  214,    0,  210,    0,  210, 
            0,  210,    0,  210,    0,  210,  210,  210,  210,  210, 
          210,  210,    0,  210,    0,  210,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  210,    0,  214, 
          212,  212,  212,    0,    0,  212,  212,  212,    0,  212, 
            0,    0,    0,  214,  214,    0,    0,    0,  214,  212, 
          212,    0,    0,    0,    0,    0,    0,    0,  212,  212, 
            0,  212,  212,  212,  212,  212,    0,    0,    0,    0, 
            0,    0,    0,  212,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  212,  212,  212,  212, 
          212,  212,  212,  212,  212,  212,    0,  212,  212,    0, 
            0,  212,  212,    0,    0,    0,  212,    0,    0,  212, 
            0,    0,  212,    0,  212,    0,  212,  215,  212,    0, 
          212,  212,  212,  212,  212,  212,  212,  215,  212,    0, 
          212,  211,  211,  211,    0,    0,  211,  211,  211,    0, 
          211,    0,  212,    0,    0,    0,    0,    0,    0,    0, 
          211,  211,    0,    0,    0,    0,    0,    0,    0,  211, 
          211,  215,  211,  211,  211,  211,  211,    0,    0,    0, 
            0,    0,    0,    0,  211,  215,  215,    0,    0,    0, 
          215,    0,    0,    0,    0,    0,    0,  211,  211,  211, 
          211,  211,  211,  211,  211,  211,  211,    0,  211,  211, 
            0,    0,  211,  211,    0,    0,    0,  211,    0,    0, 
          211,    0,    0,  211,    0,  211,    0,  211,    0,  211, 
            0,  211,  211,  211,  211,  211,  211,  211,    0,  211, 
          208,  211,    0,    0,    0,    0,    0,    0,    0,    0, 
          208,    0,    0,  211,    0,    0,    0,  214,  214,  214, 
            0,    0,  214,  214,  214,    0,  214,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  214,  214,    0,    0, 
            0,    0,    0,    0,  208,  214,  214,    0,  214,  214, 
          214,  214,  214,    0,    0,    0,    0,    0,  208,  208, 
          214,    0,    0,  208,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  214,  214,  214,  214,  214,  214,  214, 
          214,  214,  214,    0,  214,  214,    0,    0,  214,  214, 
            0,    0,    0,  214,    0,    0,  214,    0,    0,  214, 
            0,  214,    0,  214,  209,  214,    0,  214,  214,  214, 
          214,  214,  214,  214,  209,  214,    0,  214,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  214, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  209,  215, 
          215,  215,    0,    0,  215,  215,  215,    0,  215,    0, 
            0,    0,  209,  209,    0,    0,    0,  209,  215,  215, 
            0,    0,    0,    0,    0,    0,    0,  215,  215,    0, 
          215,  215,  215,  215,  215,    0,    0,    0,    0,    0, 
            0,    0,  215,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  215,  215,  215,  215,  215, 
          215,  215,  215,  215,  215,    0,  215,  215,    0,    0, 
          215,  215,    0,    0,    0,  215,  233,    0,  215,    0, 
            0,  215,    0,  215,    0,  215,  233,  215,    0,  215, 
          215,  215,  215,  215,  215,  215,    0,  215,    0,  215, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  215,  208,  208,  208,    0,    0,  208,  208,  208, 
          233,  208,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  208,  208,    0,  233,  233,    0,    0,    0,  233, 
          208,  208,    0,  208,  208,  208,  208,  208,    0,    0, 
            0,    0,    0,    0,    0,  208,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  208,  208, 
          208,  208,  208,  208,  208,  208,  208,  208,    0,  208, 
          208,    0,    0,  208,  208,    0,    0,    0,  208,    0, 
            0,  208,    0,    0,  208,    0,  208,    0,    0,  234, 
          208,    0,    0,    0,  208,  208,  208,  208,  208,  234, 
          208,    0,  208,    0,    0,    0,  209,  209,  209,    0, 
            0,  209,  209,  209,  208,  209,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  209,  209,    0,    0,    0, 
            0,    0,    0,  234,  209,  209,    0,  209,  209,  209, 
          209,  209,    0,    0,    0,    0,    0,  234,  234,  209, 
            0,    0,  234,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  209,  209,  209,  209,  209,  209,  209,  209, 
          209,  209,    0,  209,  209,    0,    0,  209,  209,    0, 
            0,    0,  209,    0,    0,  209,    0,    0,  209,    0, 
          209,    0,    0,    0,  209,    0,    0,    0,  209,  209, 
          209,  209,  209,    0,  209,    0,  209,  220,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  220,  209,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  233,  233, 
          233,    0,    0,  233,  233,  233,    0,  233,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  233,  233,    0, 
            0,  220,    0,    0,    0,    0,  233,  233,    0,  233, 
          233,  233,  233,  233,    0,  220,  220,    0,    0,    0, 
          220,  233,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  233,  233,  233,  233,  233,  233, 
          233,  233,  233,  233,    0,  233,  233,    0,    0,  233, 
          233,    0,    0,    0,  233,    0,    0,  233,    0,    0, 
          233,    0,  233,    0,    0,  218,  233,    0,    0,    0, 
            0,    0,  233,  233,  233,  218,  233,    0,  233,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          233,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  234,  234,  234,    0,    0,  234,  234,  234,  218, 
          234,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          234,  234,    0,  218,  218,    0,    0,    0,  218,  234, 
          234,    0,  234,  234,  234,  234,  234,    0,    0,    0, 
            0,    0,    0,    0,  234,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  234,  234,  234, 
          234,  234,  234,  234,  234,  234,  234,    0,  234,  234, 
            0,    0,  234,  234,  219,    0,    0,  234,    0,    0, 
          234,    0,    0,  234,  219,  234,    0,    0,    0,  234, 
            0,    0,    0,    0,    0,  234,  234,  234,    0,  234, 
            0,  234,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  234,    0,    0,    0,    0,  219,  220, 
          220,  220,    0,    0,  220,  220,  220,    0,  220,    0, 
            0,    0,  219,  219,    0,    0,    0,  219,  220,  220, 
            0,    0,    0,    0,    0,    0,    0,  220,  220,    0, 
          220,  220,  220,  220,  220,    0,    0,    0,    0,    0, 
            0,    0,  220,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  220,  220,  220,  220,  220, 
          220,  220,  220,  220,  220,    0,  220,  220,    0,    0, 
            0,    0,    0,    0,  223,  220,    0,    0,  220,    0, 
            0,  220,    0,  220,  223,    0,    0,  220,    0,    0, 
            0,    0,    0,  220,  220,  220,    0,  220,    0,  220, 
            0,    0,    0,    0,    0,    0,    0,  218,  218,  218, 
            0,  220,  218,  218,  218,    0,  218,    0,  223,    0, 
            0,    0,    0,    0,    0,    0,  218,  218,    0,    0, 
            0,    0,  223,  223,    0,  218,  218,  223,  218,  218, 
          218,  218,  218,    0,    0,    0,    0,    0, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

            0,    0,  218,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  218,  218,  218,  218,  218, 
          218,  218,  218,  218,  218,    0,  218,  218,    0,    0, 
            0,    0,    0,    0,    0,  218,    0,    0,  218,    0, 
            0,  218,    0,  218,    0,    0,  225,    0,    0,    0, 
            0,    0,    0,  218,  218,  218,  225,  218,    0,  218, 
            0,    0,    0,    0,    0,    0,    0,    0,  219,  219, 
          219,  218,    0,  219,  219,  219,    0,  219,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  219,  219,    0, 
          225,    0,    0,    0,    0,    0,  219,  219,    0,  219, 
          219,  219,  219,  219,  225,  225,    0,    0,    0,  225, 
            0,  219,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  219,  219,  219,  219,  219,  219, 
          219,  219,  219,  219,    0,  219,  219,    0,    0,    0, 
            0,    0,    0,  224,  219,    0,    0,  219,    0,    0, 
          219,    0,  219,  224,    0,    0,    0,    0,    0,    0, 
            0,    0,  219,  219,  219,    0,  219,    0,  219,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          219,    0,    0,    0,    0,    0,    0,  224,  223,  223, 
          223,    0,    0,  223,  223,  223,    0,  223,    0,    0, 
            0,  224,  224,    0,    0,    0,  224,  223,  223,    0, 
            0,    0,    0,    0,    0,    0,  223,  223,    0,  223, 
          223,  223,  223,  223,    0,    0,    0,    0,    0,    0, 
            0,  223,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  223,  223,  223,  223,  223,  223, 
          223,  223,  223,  223,    0,  223,  223,    0,    0,    0, 
            0,  222,    0,    0,  223,    0,    0,  223,    0,    0, 
          223,  222,  223,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  223,  223,    0,    0,    0,    0,  223,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          223,    0,    0,    0,    0,  222,    0,    0,  225,  225, 
          225,    0,    0,  225,  225,  225,    0,  225,    0,  222, 
          222,    0,    0,    0,  222,    0,    0,  225,  225,    0, 
            0,    0,    0,    0,    0,    0,  225,  225,    0,  225, 
          225,  225,  225,  225,    0,    0,    0,    0,    0,    0, 
            0,  225,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  225,  225,  225,  225,  225,  225, 
          225,  225,  225,  225,    0,  225,  225,    0,    0,    0, 
            0,    0,    0,  226,  225,    0,    0,  225,    0,    0, 
          225,    0,  225,  226,    0,    0,    0,    0,    0,    0, 
            0,    0,  225,  225,    0,  224,  224,  224,  225,    0, 
          224,  224,  224,    0,  224,    0,    0,    0,    0,    0, 
          225,    0,    0,    0,  224,  224,    0,  226,    0,    0, 
            0,    0,    0,  224,  224,    0,  224,  224,  224,  224, 
          224,  226,  226,    0,    0,    0,  226,    0,  224,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  224,  224,  224,  224,  224,  224,  224,  224,  224, 
          224,    0,  224,  224,    0,    0,    0,    0,    0,    0, 
            0,  224,    0,    0,  224,    0,    0,  224,    0,  224, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  224, 
          224,  227,    0,    0,    0,  224,    0,    0,    0,    0, 
            0,  227,    0,    0,    0,    0,    0,  224,    0,    0, 
            0,    0,    0,  222,  222,  222,    0,    0,  222,  222, 
          222,    0,  222,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  222,  222,    0,  227,    0,    0,    0,    0, 
            0,  222,  222,    0,  222,  222,  222,  222,  222,  227, 
          227,    0,    0,    0,  227,    0,  222,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  222, 
          222,  222,  222,  222,  222,  222,  222,  222,  222,    0, 
          222,  222,    0,    0,    0,    0,    0,    0,  228,  222, 
            0,    0,  222,    0,    0,  222,    0,  222,  228,    0, 
            0,    0,    0,    0,    0,    0,    0,  222,  222,    0, 
            0,    0,    0,  222,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  222,    0,    0,    0,    0, 
            0,    0,  228,    0,    0,  226,  226,  226,    0,    0, 
          226,  226,  226,    0,  226,    0,  228,  228,    0,    0, 
            0,  228,    0,    0,  226,  226,    0,    0,    0,    0, 
            0,    0,    0,  226,  226,    0,  226,  226,  226,  226, 
          226,    0,    0,    0,  235,    0,    0,    0,  226,    0, 
            0,    0,    0,    0,  235,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  226,  226,    0, 
            0,    0,  226,  226,    0,    0,    0,    0,    0,    0, 
            0,  226,    0,    0,  226,    0,    0,  226,  235,  226, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  235,  235,    0,  226,    0,  235,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  226,    0,    0, 
            0,    0,    0,  227,  227,  227,    0,    0,  227,  227, 
          227,    0,  227,    0,  229,    0,    0,    0,    0,    0, 
            0,    0,  227,  227,  229,    0,    0,    0,    0,    0, 
            0,  227,  227,    0,  227,  227,  227,  227,  227,    0, 
            0,    0,    0,    0,    0,    0,  227,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  229,    0, 
            0,    0,    0,    0,    0,  227,  227,    0,    0,    0, 
          227,  227,  229,  229,    0,    0,    0,  229,    0,  227, 
            0,    0,  227,    0,    0,  227,    0,  227,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          228,  228,  228,  227,    0,  228,  228,  228,    0,  228, 
            0,  230,    0,    0,    0,  227,    0,    0,    0,  228, 
          228,  230,    0,    0,    0,    0,    0,    0,  228,  228, 
            0,  228,  228,  228,  228,  228,    0,    0,    0,    0, 
            0,    0,    0,  228,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  230,    0,    0,    0,    0, 
            0,    0,  228,  228,    0,    0,    0,  228,  228,  230, 
          230,    0,    0,    0,  230,    0,  228,    0,    0,  228, 
            0,    0,  228,    0,  228,    0,  235,  235,  235,    0, 
            0,  235,  235,  235,    0,  235,    0,  236,    0,    0, 
          228,    0,    0,    0,    0,  235,  235,  236,    0,    0, 
            0,    0,  228,    0,  235,  235,    0,  235,  235,  235, 
          235,  235,    0,    0,    0,    0,    0,    0,    0,  235, 
            0,    0,    0,    0,    0,   39,    0,    0,    0,    0, 
            0,  236,    0,    0,    0,   39,    0,    0,  235,  235, 
            0,    0,    0,  235,  235,  236,  236,    0,    0,    0, 
          236,    0,  235,    0,    0,  235,    0,    0,  235,    0, 
          235,    0,    0,    0,    0,    0,  229,  229,  229,  263, 
            0,  229,  229,  229,    0,  229,  235,  206,    0,    0, 
            0,    0,    0,    0,   39,  229,  229,  206,  235,    0, 
            0,    0,    0,    0,  229,  229,    0,  229,  229,  229, 
          229,  229,    0,    0,    0,    0,    0,    0,    0,  229, 
            0,    0,    0,    0,    0,    0,    0,  207,    0,    0, 
            0,  206,    0,    0,    0,    0,    0,  207,  229,  229, 
            0,    0,    0,  229,  229,  206,  206,    0,    0,    0, 
          206,    0,  229,    0,    0,  229,    0,    0,  229,    0, 
          229,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  207,    0,  230,  230,  230,  229,    0,  230,  230, 
          230,    0,  230,    0,    0,  207,  207,    0,  229,    0, 
          207,    0,  230,  230,    0,    0,    0,    0,    0,    0, 
            0,  230,  230,    0,  230,  230,  230,  230,  230,    0, 
            0,    0,  237,    0,    0,    0,  230,    0,    0,    0, 
            0,    0,  237,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  230,  230,    0,    0,    0, 
          230,  230,    0,    0,    0,    0,    0,    0,    0,  230, 
            0,    0,  230,    0,    0,  230,  237,  230,    0,  236, 
          236,  236,    0,    0,  236,  236,  236,    0,  236,    0, 
          237,  237,    0,  230,    0,    0,    0,    0,  236,  236, 
            0,    0,    0,    0,    0,  230,    0,  236,  236,    0, 
          236,  236,  236,  236,  236,    0,    0,   39,   39,   39, 
            0,    0,  236,   39,   39,    0,   39,    0,  205,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  205,    0, 
            0,    0,  236,    0,    0,    0,  236,  236,   39,   39, 
           39,   39,   39,    0,    0,  236,    0,    0,  236,    0, 
            0,  236,    0,  236,    0,    0,    0,    0,    0,  206, 
          206,  206,  205,    0,  206,  206,  206,    0,  206,  236, 
            0,    0,    0,    0,    0,    0,  205,  205,  206,  206, 
            0,  236,    0,    0,    0,    0,   39,  206,  206,    0, 
          206,  206,  206,  206,  206,    0,    0,    0,    0,  207, 
          207,  207,  206,  204,  207,  207,  207,   39,  207,    0, 
            0,    0,    0,  204,    0,    0,    0,    0,  207,  207, 
            0,    0,    0,    0,    0,    0,    0,  207,  207,    0, 
          207,  207,  207,  207,  207,  206,    0,    0,  206,    0, 
            0,  206,  207,  206,    0,    0,    0,  204,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  206, 
            0,  204,  204,    0,  200,    0,    0,    0,    0,    0, 
            0,  206,    0,    0,  200,  207,    0,    0,  207,    0, 
            0,  207,    0,  207,  237,  237,  237,    0,    0,  237, 
          237,  237,    0,  237,    0,    0,    0,    0,    0,  207, 
            0,    0,    0,  237,  237,    0,    0,    0,  200,    0, 
            0,  207,  237,  237,    0,  237,  237,  237,  237,  237, 
            0,    0,  200,  200,    0,    0,    0,  237,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          237,  201,    0,  237,    0,    0,  237,    0,  237,    0, 
            0,  201,    0,    0,    0,    0,    0,    0,    0,    0, 
          205,  205,  205,    0,  237,  205,  205,  205,    0,  205, 
            0,    0,    0,    0,    0,    0,  237,    0,    0,  205, 
          205,    0,    0,    0,    0,  201,    0,    0,  205,  205, 
            0,  205,  205,  205,  205,  205,    0,    0,    0,  201, 
          201,    0,    0,  205,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  202,    0,    0, 
            0,    0,    0,    0,    0,    0,  205,  202,    0,  205, 
            0,    0,  205,    0,  205,  204,  204,  204,    0,    0, 
          204,  204,  204,    0,  204,    0,    0,    0,    0,    0, 
          205,    0,    0,    0,  204,  204,    0,    0,    0,    0, 
            0,  202,  205,  204,  204,    0,  204,  204,  204,  204, 
          204,    0,    0,    0,    0,  202,  202,    0,  204,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  200,  200,  200,    0, 
            0,  200,  200,  200,    0,  200,    0,    0,    0,    0, 
            0,  204,    0,    0,  204,  200,  200,  204,    0,  204, 
            0,    0,    0,    0,  200,  200,  203,  200,  200,  200, 
          200,  200,    0,    0,    0,  204,  203,    0,    0,  200, 
            0,    0,    0,    0,    0,    0,    0,  204,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          203,    0,  200,    0,    0,  200,    0,    0,  200,    0, 
          200,    0,    0,    0,  203,  203,    0,  196,    0,    0, 
            0,    0,    0,  201,  201,  201,  200,  196,  201,  201, 
          201,    0,  201,    0,    0,    0,    0,    0,  200,    0, 
            0,    0,  201,  201,    0,    0,    0,    0,    0,    0, 
            0,  201,  201,    0,  201,  201,  201,  201,  201,    0, 
            0,  196,    0,    0,    0,    0,  201,    0,    0,    0, 
            0,    0,    0,    0,    0,  196,  196,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  201, 
            0,    0,  201,  198,    0,  201,    0,  201,    0,  202, 
          202,  202,    0,  198,  202,  202,  202,    0,  202,    0, 
            0,    0,    0,  201,    0,    0,    0,    0,  202,  202, 
            0,    0,    0,    0,    0,  201,    0,  202,  202,    0, 
          202,  202,  202,  202,  202,    0,    0,  198,    0,    0, 
            0,    0,  202,    0,    0,    0,    0,    0,    0,    0, 
            0,  198,  198,  269,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  269,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  202,    0,    0,  202,    0, 
            0,  202,    0,  202,    0,    0,    0,    0,    0,    0, 
          238,    0,    0,    0,    0,    0,    0,  264,    0,  202, 
          238,    0,    0,    0,    0,    0,    0,    0,  203,  203, 
          203,  202,  269,  203,  203,  203,    0,  203,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  203,  203,    0, 
            0,    0,    0,    0,  238,    0,  203,  203,    0,  203, 
          203,  203,  203,  203,    0,    0,    0,    0,  238,  238, 
            0,  203,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  196, 
          196,  196,    0,    0,  196,  196,  196,    0,  196,    0, 
            0,    0,    0,    0,  203,    0,    0,  203,  196,  196, 
          203,    0,  203,    0,    0,    0,    0,  196,  196,    0, 
          196,  196,  196,  196,  196,    0,    0,    0,  203,    0, 
            0,    0,  196,    0,  199,    0,    0,    0,    0,    0, 
          203,    0,    0,    0,  199,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  196,    0,    0,  196,    0, 
            0,  196,    0,  196,    0,  198,  198,  198,  199,    0, 
          198,  198,  198,    0,  198,    0,    0,    0,    0,  196, 
            0,    0,  199,  199,  198,  198,    0,    0,    0,    0, 
            0,  196,    0,  198,  198,    0,  198,  198,  198,  198, 
          198,    0,    0,    0,    0,    0,    0,    0,  198,    0, 
            0,  240,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  240,    0,    0,    0,  269,  269,  269,    0,    0, 
          269,  269,  269,    0,  269,    0,    0,    0,    0,    0, 
            0,  198,    0,    0,  198,    0,    0,  198,    0,  198, 
            0,    0,    0,    0,    0,  240,  269,  269,  269,  269, 
          269,    0,  238,  238,  238,  198,    0,  238,  238,  238, 
          240,  238,    0,    0,    0,    0,    0,  198,    0,    0, 
            0,  238,  238,    0,    0,    0,    0,    0,    0,    0, 
          238,  238,    0,  238,  238,  238,  238,  238,  197,    0, 
            0,  269,    0,    0,  269,  238,    0,    0,  197,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  269,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  238,    0, 
            0,  238,  197,    0,  238,    0,  238,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  197,  197,    0,    0, 
            0,    0,  238,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  238,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  195,    0,  199,  199,  199,    0, 
            0,  199,  199,  199,  195,  199,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  199,  199,    0,    0,    0, 
            0,    0,    0,    0,  199,  199,    0,  199,  199,  199, 
          199,  199,    0,    0,    0,    0,    0,    0,  195,  199, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  195,  195,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  199,    0,    0,  199,    0,    0,  199,    0, 
          199,    0,    0,  240,  240,  240,    0,    0,  240,  240, 
          240,    0,  240,    0,    0,    0,  199,    0,    0,  107, 
            0,    0,  240,  240,    0,    0,    0,    0,  199,    0, 
            0,  240,  240,    0,  240,  240,  240,  240,  240,    0, 
            0,    0,    0,    0,    0,    0,  240,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  107,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  240, 
            0,    0,  240,    0,    0,  240,    0,  240,    0,    0, 
          197,  197,  197,    0,    0,  197,  197,  197,    0,  197, 
          459,    0,    0,  240,    0,    0,    0,    0,    0,  197, 
          197,    0,    0,    0,    0,  240,    0,    0,  197,  197, 
            0,  197,  197,  197,  197,    0,    0,    0,    0,    0, 
            0,    0,    0,  197,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  108,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  197,    0,    0,  197, 
            0,    0,  197,    0,  197,    0,  195,  195,  195,    0, 
            0,  195,  195,  195,    0,  195,    0,    0,    0,    0, 
          197,    0,  108,    0,    0,  195,  195,    0,    0,    0, 
            0,    0,  197,    0,  195,  195,    0,  195,  195,  195, 
          195,    0,    0,    0,    0,    0,    0,    0,    0,  195, 
            0,    0,    0,    0,  462,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  195,    0,    0,  195,    0,    0,  195,    0, 
          195,    0,    0,    0,    0,  107,  107,  107,  107,  107, 
          107,  107,  107,  107,  107,  107,  195,  107,  107,  107, 
            0,  107,  107,  107,  107,  107,  107,  107,  195,  532, 
            0,    0,  107,  107,  107,  107,  107,  107,  107,    0, 
            0,  107,    0,    0,    0,    0,    0,  107,  107,    0, 
          107,  107,  107,  107,    0,  107,  107,  107,  107,  107, 
          107,    0,  107,  107,  107,  107,  107,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  459,    0,    0, 
            0,    0,    0,    0,  459,  107,    0,    0,  107,  532, 
            0,  107,  107,    0,  107,    0,  107,    0,  539,    0, 
          107,    0,    0,    0,    0,  107,    0,    0,  107,    0, 
          532,    0,    0,  107,  107,  107,  107,  107,  107,    0, 
            0,    0,  107,    0,  107,  107,    0,  107,  107,  108, 
          108,  108,  108,  108,  108,  108,  108,  108,  108,  108, 
            0,  108,  108,  108,    0,  108,  108,  108,  108,  108, 
          108,  108,    0,  533,    0,    0,  108,  108,  108,  108, 
          108,  108,  108,    0,    0,  108,    0,    0,    0,    0, 
            0,  108,  108,    0,  108,  108,  108,  108,    0,  108, 
          108,  108,  108,  108,  108,    0,  108,  108,  108,  108, 
          108,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  462,    0,    0,    0,    0,    0,    0,  462,  108, 
            0,    0,  108,  533,    0,  108,  108,    0,  108,    0, 
          108,    0,  283,    0,  108,    0,    0,    0,    0,  108, 
            0,    0,  108,    0,  533,    0,    0,  108,  108,  108, 
          108,  108,  108,    0,    0,    0,  108,    0,  108,  108, 
            0,  108,  108,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  107,  107,  107,  107,  107,  107,  107, 
          107,  107,  107,  107,    0,  108,  107,  107,    0,  107, 
          107,  107,  107,  107,  107,  107,    0,  539,    0,    0, 
          107,  107,  107,  107,  107,  107,  107,    0,    0,  107, 
            0,    0,    0,    0,    0,  107,  107,    0,  107,  107, 
          107,  107,    0,  107,  107,  107,  107,  107,  107,    0, 
          107,  107,  107,  107,  108,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  539,    0,    0,    0,    0, 
            0,    0,  539,  107,    0,    0,  107,  535,    0,  107, 
          107,    0,  107,    0,  107,    0,  284,    0,  107,    0, 
            0,    0,    0,  107,    0,    0,  107,    0,  539,    0, 
            0,  107,  107,  107,  107,  107,  107,    0,    0,    0, 
          107,    0,  107,  107,    0,  107,  107,  108,  108,  108, 
          108,  108,  108,  108,  108,  108,  108,  108,    0,  328, 
          108,  108,    0,  108,  108,  108,  108,  108,  108,  108, 
            0,    0,    0,    0,  108,  108,  108,  108,  108,  108, 
          108,    0,    0,  108,    0,    0,    0,    0,    0,  108, 
          108,    0,  108,  108,  108,  108,    0,  108,  108,  108, 
          108,  108,  108,    0,  108,  108,  108,  108,  328,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  283, 
            0,    0,    0,    0,    0,    0,  283,  108,    0,    0, 
          108,  536,    0,  108,  108,    0,  108,    0,  108,    0, 
            0,    0,  108,    0,    0,    0,    0,  108,    0,    0, 
          108,    0,    0,    0,    0,  108,  108,  108,  108,  108, 
          108,    0,    0,    0,  108,    0,  108,  108,    0,  108, 
          108,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  108,  108,  108,  108,  108,  108,  108,  108,  108, 
          108,  108,    0,  557,  108,  108,    0,  108,  108,  108, 
          108,  108,  108,  108,    0,    0,    0,    0,  108,  108, 
          108,  108,  108,  108,  108,    0,    0,  108,    0,    0, 
            0,    0,    0,  108,  108,    0,  108,  108,  108,  108, 
            0,  108,  108,  108,  108,  108,  108,    0,  108,  108, 
          108,  108,  557,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  284,    0,    0,    0,    0,    0,    0, 
          284,  108,    0,    0,  108,    0,    0,  108,  108,    0, 
          108,    0,  108,    0,    0,    0,  108,    0,    0,    0, 
            0,  108,    0,    0,  108,    0,    0,    0,    0,  108, 
          108,  108,  108,  108,  108,    0,    0,    0,  108,    0, 
          108,  108,    0,  108,  108,  328,  328,  328,  328,  328, 
          328,  328,  328,  328,  328,  328,    0,  328,  328,  328, 
          328,  328,  328,  328,  328,  328,  328,  328,  557,    0, 
            0,    0,  328,  328,  328,  328,  328,  328,  328,    0, 
            0,  328,    0,    0,    0,    0,    0,  328,  328,    0, 
          328,  328,  328,  328,    0,  328,  328,  328,  328,  328, 
          328,    0,  328,  328,  328,  328,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  557,    0,    0, 
            0,    0,    0,    0,    0,  328,    0,    0,  328,    0, 
            0,  328,  328,    0,  328,    0,  328,    0,    0,    0, 
          328,    0,    0,    0,    0,    0,    0,    0,  328,    0, 
            0,    0,    0,  328,  328,  328,  328,  328,  328,    0, 
            0,    0,  328,    0,  328,  328,    0,  328,  328,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  557, 
          557,  557,  557,  557,  557,    0,    0,  557,  557,  557, 
            0,  236,    0,  557,    0,  557,  557,  557,  557,  557, 
          557,  557,    0,    0,    0,    0,  557,  557,  557,  557, 
          557,  557,  557,    0,    0,  557,    0,    0,    0,    0, 
            0,  557,  557,    0,  557,  557,  557,  557,    0,  557, 
          557,  557,  557,  557,  557,    0,  557,  557,  557,  557, 
          235,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  557, 
            0,    0,  557,    0,    0,  557,  557,    0,  557,    0, 
          557,    0,    0,    0,  557,    0,    0,    0,    0,    0, 
            0,    0,  557,    0,    0,    0,    0,  557,  557,  557, 
          557,  557,  557,    0,    0,    0,  557,    0,  557,  557, 
            0,  557,  557,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  557,  557,  557,  557,  557,  557, 
            0,    0,    0,  557,  557,    0,    0,    0,  557,    0, 
          557,  557,  557,  557,  557,  557,  557,    0,    0,  323, 
            0,  557,  557,  557,  557,  557,  557,  557,    0,  323, 
          557,    0,    0,    0,    0,    0,  557,  557,    0,  557, 
          557,  557,  557,    0,  557,  557,  557,  557,  557,  557, 
            0,  557,  557,  557,  557,    0,    0,    0,    0,    0, 
            0,    0,    0,  323,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  557,    0,    0,  557,  323,    0, 
          557,  557,  323,  557,    0,  557,    0,    0,    0,  557, 
            0,    0,    0,    0,    0,    0,    0,  557,    0,    0, 
          557,    0,  557,  557,  557,  557,  557,  557,    0,    0, 
          323,  557,    0,  557,  557,    0,  557,  557,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,  324,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,  324,   26,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,  324,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  225,    0,    0, 
          114,  324,    0,   46,   47,  324,   48,    0,    0,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
           51,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,  324,   58,    0,   59,   60,    0,   61, 
           62,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  287, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  287, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  323,  323,  323,    0,    0,  323,  323,  323,    0, 
          323,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          323,  323,    0,  287,    0,    0,    0,    0,    0,  323, 
          323,    0,  323,  323,  323,  323,  323,    0,  287,    0, 
            0,    0,  287,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  323,  323,  323,  323, 
          323,  323,  323,  323,  323,  323,  323,  323,  323,  323, 
          287,    0,  323,  323,  323,    0,    0,  323,    0,    0, 
          323,    0,    0,  323,    0,  323,    0,  323,    0,  323, 
            0,  323,  323,  323,  323,  323,  323,  323,    0,  323, 
            0,  323,  397,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  397,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  324,  324,  324,    0,    0,  324, 
          324,  324,    0,  324,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  324,  324,    0,   91,    0,    0,    0, 
            0,    0,  324,  324,    0,  324,  324,  324,  324,  324, 
            0,  397,    0,  100,    0,  397,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  324, 
          324,  324,  324,  324,  324,  324,  324,  324,  324,  324, 
          324,  324,  324,  397,    0,  324,  324,  324,    0,    0, 
          324,    0,    0,  324,    0,    0,  324,    0,  324,    0, 
          324,    0,  324,    0,  324,  324,  324,  324,  324,  324, 
          324,    0,  324,    0,  324,    0,    0,  471,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  471,    0,    0, 
            0,  287,  287,  287,    0,    0,  287,  287,  287,    0, 
          287,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          287,  287,    0,    0,    0,    0,    0,    0,    0,  287, 
          287,   89,  287,  287,  287,  287,  287,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  471,    0,   98,    0, 
          471,    0,    0,    0,    0,    0,  287,  287,  287,  287, 
          287,  287,  287,  287,  287,  287,  287,  287,  287,  287, 
            0,    0,  287,  287,  287,    0,    0,  287,  471,    0, 
          287,    0,    0,  287,    0,  287,    0,  287,    0,  287, 
            0,  287,  287,  287,  287,  287,  287,  287,    0,  287, 
            0,  287,  472,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  472,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  397,  397,  397,    0,    0,    0, 
          397,  397,    0,  397,    0,    0,    0,    0,    0,    0, 
            0,    0,  397,    0,    0,    0,   90,    0,    0,    0, 
            0,    0,  397,  397,    0,  397,  397,  397,  397,  397, 
            0,  472,    0,   99,    0,  472,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  397, 
          397,  397,  397,  397,  397,  397,  397,  397,  397,  397, 
          397,  397,  397,  472,    0,  397,  397,  397,    0,    0, 
            0,    0,    0,  397,    0,    0,    0,    0,    0,    0, 
          397,    0,  397,    0,  397,  397,  397,  397,  397,  397, 
          397,    0,  397,  397,  397,    0,    0,  277,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  277,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  471, 
          471,  471,    0,    0,    0,  471,  471,    0,  471,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   97,    0,    0,    0,    0,    0,  471,  471,    0, 
          471,  471,  471,  471,  471,    0,  277,    0,  106,    0, 
          277,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  471,  471,  471,  471,  471,  471, 
          471,  471,  471,  471,  471,  471,  471,  471,  277,    0, 
          471,  471,  471,    0,  473,    0,    0,    0,  471,    0, 
            0,    0,    0,    0,    0,  471,    0,  471,    0,  471, 
          471,  471,  471,  471,  471,  471,    0,  471,    0,  471, 
          284,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          284,    0,    0,    0,  472,  472,  472,    0,    0,    0, 
          472,  472,    0,  472,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  472,  472,   96,  472,  472,  472,  472,  472, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  284, 
            0,  105,    0,  284,    0,    0,    0,    0,    0,  472, 
          472,  472,  472,  472,  472,  472,  472,  472,  472,  472, 
          472,  472,  472,    0,    0,  472,  472,  472,    0,  474, 
            0,  284,    0,  472,    0,    0,    0,    0,    0,    0, 
          472,    0,  472,  265,  472,  472,  472,  472,  472,  472, 
          472,    0,  472,  265,  472,    0,    0,    0,    0,  267, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  267, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  277, 
          277,  277,    0,    0,    0,  277,  277,  265,  277,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  265,  265,    0,    0,    0,  277,  277,    0, 
          277,  277,  277,  277,  277,    0,    0,   41,  267,    0, 
            0,    0,    0,    0,    0,    0,    0,   41,    0,    0, 
            0,    0,    0,    0,  277,  277,  277,  277,  277,  277, 
          277,  277,  277,  277,  277,  277,  277,  277,    0,    0, 
          277,  277,  277,    0,    0,    0,  268,    0,  277,    0, 
            0,    0,    0,    0,    0,  277,  268,  277,   22,  277, 
          277,  277,  277,  277,  277,  277,   41,  277,   22,  277, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          266,    0,  284,  284,  284,    0,    0,    0,  284,  284, 
            0,  284,    0,    0,    0,  268,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   22,    0,    0, 
          284,  284,    0,  284,  284,  284,  284,  284,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  284,  284,  284, 
          284,  284,  284,  284,  284,  284,  284,  284,  284,  284, 
          284,    0,    0,  284,  284,  284,    0,    0,    0,    0, 
            0,  284,    0,    0,    0,    0,    0,    0,  284,    0, 
          284,    0,  284,  284,  284,  284,  284,  284,  284,    0, 
          284,    0,  284,    0,    0,  265,  265,  265,    0,    0, 
          265,  265,  265,    0,  265,    0,    0,    0,  299,    0, 
            0,  267,  267,  267,  265,  265,  267,  267,  267,    0, 
          267,    0,    0,  265,  265,    0,  265,  265,  265,  265, 
          265,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  267,  267,  267,  267,  267,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   41, 
           41,   41,    0,    0,  265,   41,   41,  265,   41,  265, 
            0,    0,    0,    0,    0,    0,    0,  267,    0,    0, 
          267,    0,    0,    0,    0,  265,    0,    0,    0,    0, 
           41,   41,   41,   41,   41,    0,    0,    0,  268,  268, 
          268,  267,    0,  268,  268,  268,    0,  268,    0,    0, 
           22,   22,   22,    0,    0,    0,   22,   22,    0,   22, 
            0,  590,    0,    0,    0,    0,    0,    0,    0,  268, 
          268,  268,  268,  268,    0,    0,    0,    0, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

           41,    0,    0,   22,   22,   22,   22,   22,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   41,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  268,    0,    0,  268, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   22,    0,    0,    0,    0,    0,    0,    0,    0, 
          268,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   22,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  102,  103,   17,   18,    0,    0,    0,    0,  104, 
          105,  106,   22,   23,   24,   25,    0,    0,  107,    0, 
            0,    0,    0,    0,    0,  108,    0,    0,   31,   32, 
           33,  422,   34,   35,   36,   37,   38,   39,    0,   40, 
            0,    0,  111,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  298,    0,    0,  114,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  102,  103,   17,   18,    0,    0, 
            0,    0,  104,  105,  106,   22,   23,   24,   25,    0, 
            0,  107,    0,    0,    0,    0,    0,    0,  108,    0, 
            0,   31,   32,   33,  422,   34,   35,   36,   37,   38, 
           39,    0,   40,    0,    0,  111,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  298,    0,    0,  114,    0, 
            0,   46,   47,    0,   48,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,    4, 
            5,    6,    7,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,   26,    0,    0,    0,    0,    0, 
           27,   28,   29,   30,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   44,    0, 
            0,   45,    0,    0,   46,   47,    0,   48,    0,   49, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,    4,    5,    6,    7,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,   26,    0,    0, 
            0,    0,    0,   27,   28,    0,   30,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   44,    0,    0,   45,    0,    0,   46,   47,    0, 
           48,    0,   49,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,    3,    4,    5,    6,    7, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,   22,   23,   24,   25,    0, 
            0,   26,    0,    0,    0,    0,    0,   27,   28,   29, 
           30,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   44,    0,    0,   45,    0, 
            0,   46,   47,    0,   48,    0,   49,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,   51,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,  219, 
            4,    5,    6,    7,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,   22, 
           23,   24,   25,    0,    0,   26,    0,    0,    0,    0, 
            0,   27,   28,    0,   30,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   44, 
            0,    0,   45,    0,    0,   46,   47,    0,   48,    0, 
           49,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,   51,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,  219,    4,    5,    6,    7,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,   26, 
            0,    0,    0,    0,    0,   27,   28,    0,   30,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   44,    0,    0,  285,    0,    0,   46, 
           47,    0,   48,    0,   49,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,   51,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,    4,    5,    6, 
            7,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,    0,    0,   19,   20,   21,   22,   23,   24,   25, 
            0,    0,   26,    0,    0,    0,    0,    0,   27,   28, 
           29,   30,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   44,    0,    0,   45, 
            0,    0,   46,   47,    0,   48,    0,   49,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,   51, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
            4,    5,    6,    7,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,   22, 
           23,   24,   25,    0,    0,   26,    0,    0,    0,    0, 
            0,   27,   28,    0,   30,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   44, 
            0,    0,   45,    0,    0,   46,   47,    0,   48,    0, 
           49,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,   51,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,    0,    0,    0,   19, 
           20,   21,   22,   23,   24,   25,    0,    0,  107,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,  251,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  225,    0,    0,  114,    0,    0,   46,   47, 
            0,   48,    0,  252,    0,  253,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,  254,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  102,  103,   17,   18,    0,    0, 
            0,    0,  104,  105,  106,   22,   23,   24,   25,    0, 
            0,  107,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,  251,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  225,    0,    0,  114,    0, 
            0,   46,   47,    0,   48,    0,  647,    0,  253,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,  254,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,  258, 
          258,  258,    0,  258,    0,    0,    0,  258,  258,    0, 
            0,    0,  258,    0,  258,  258,  258,  258,  258,  258, 
          258,    0,    0,    0,    0,  258,  258,  258,  258,  258, 
          258,  258,    0,    0,  258,    0,    0,    0,    0,    0, 
            0,  258,    0,    0,  258,  258,  258,    0,  258,  258, 
          258,  258,  258,  258,  258,  258,  258,  258,  258,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  258,    0, 
            0,  258,    0,    0,  258,  258,    0,  258,    0,  258, 
            0,  258,    0,  258,    0,    0,    0,    0,    0,    0, 
            0,  258,    0,    0,    0,    0,  258,  258,  258,  258, 
          258,  258,    0,    0,    0,  258,    0,  258,  258,    0, 
          258,  258,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          102,  103,   17,   18,    0,    0,    0,    0,  104,  105, 
          106,   22,   23,   24,   25,    0,    0,  107,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,  251,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  225,    0,    0,  114,    0,    0,   46,   47,    0, 
           48,    0,  252,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  254,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  102,  103,   17,   18,    0,    0,    0, 
            0,  104,  105,  106,   22,   23,   24,   25,    0,    0, 
          107,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
          251,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  225,    0,    0,  114,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,  253,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  254,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  102,  103,   17,   18, 
            0,    0,    0,    0,  104,  105,  106,   22,   23,   24, 
           25,    0,    0,  107,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,  251,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  225,    0,    0, 
          114,    0,    0,   46,   47,    0,   48,    0,  647,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          254,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  102, 
          103,   17,   18,    0,    0,    0,    0,  104,  105,  106, 
           22,   23,   24,   25,    0,    0,  107,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,  251,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          225,    0,    0,  114,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  254,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  102,  103,   17,   18,    0,    0,    0,    0, 
          104,  105,  106,   22,   23,   24,   25,    0,    0,  107, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  225,    0,    0,  114,  455,    0,   46, 
           47,    0,   48,    0,    0,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  254,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,    0,    0,   19,   20,   21,   22,   23,   24,   25, 
            0,    0,  107,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  225,    0,    0,  114, 
            0,    0,   46,   47,    0,   48,    0,  581,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  254, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  102,  103, 
           17,   18,    0,    0,    0,    0,  104,  105,  106,   22, 
           23,   24,   25,    0,    0,  107,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  225, 
            0,    0,  114,    0,    0,   46,   47,    0,   48,    0, 
          581,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,  254,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  102,  103,   17,   18,    0,    0,    0,    0,  104, 
          105,  106,   22,   23,   24,   25,    0,    0,  107,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  225,    0,    0,  114,    0,    0,   46,   47, 
            0,   48,    0,  252,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,  254,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  102,  103,   17,   18,    0,    0, 
            0,    0,  104,  105,  106,   22,   23,   24,   25,    0, 
            0,  107,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  225,    0,    0,  114,    0, 
            0,   46,   47,    0,   48,    0,  831,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,  254,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  102,  103,   17, 
           18,    0,    0,    0,    0,  104,  105,  106,   22,   23, 
           24,   25,    0,    0,  107,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  225,    0, 
            0,  114,    0,    0,   46,   47,    0,   48,    0,  647, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,  254,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,  546,  546,  546,    0,  546,    0,    0,    0, 
          546,  546,    0,    0,    0,  546,    0,  546,  546,  546, 
          546,  546,  546,  546,    0,    0,    0,    0,  546,  546, 
          546,  546,  546,  546,  546,    0,    0,  546,    0,    0, 
            0,    0,    0,    0,  546,    0,    0,  546,  546,  546, 
            0,  546,  546,  546,  546,  546,  546,    0,  546,  546, 
          546,  546,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  546,    0,    0,  546,  546,    0,  546,  546,    0, 
          546,    0,    0,    0,    0,    0,  546,    0,    0,    0, 
            0,    0,    0,    0,  546,    0,    0,    0,    0,  546, 
          546,  546,  546,  546,  546,    0,    0,    0,  546,    0, 
          546,  546,    0,  546,  546,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  225,    0,    0,  114,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,   51,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  102,  103,   17,   18, 
            0,    0,    0,    0,  104,  105,  106,   22,   23,   24, 
           25,    0,    0,  107,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  225,    0,    0, 
          114,    0,    0,   46,   47,    0,   48,    0,    0,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          254,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,  107,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          225,    0,    0,  114,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  254,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,  546,  546,  546,    0,  546,    0, 
            0,    0,  546,  546,    0,    0,    0,  546,    0,  546, 
          546,  546,  546,  546,  546,  546,    0,    0,    0,    0, 
          546,  546,  546,  546,  546,  546,  546,    0,    0,  546, 
            0,    0,    0,    0,    0,    0,  546,    0,    0,  546, 
          546,  546,    0,  546,  546,  546,  546,  546,  546,    0, 
          546,  546,  546,  546,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  546,    0,    0,  546,    0,    0,  546, 
          546,    0,  546,    0,    0,    0,    0,    0,  546,    0, 
            0,    0,    0,    0,    0,    0,  546,    0,    0,    0, 
            0,  546,  546,  546,  546,  546,  546,    0,    0,    0, 
          546,    0,  546,  546,    0,  546,  546,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  102,  103,   17,   18,    0, 
            0,    0,    0,  104,  105,  106,   22,   23,   24,   25, 
            0,    0,  107,    0,    0,    0,    0,    0,    0,  108, 
            0,    0,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,    0,    0,  111,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  298,    0,    0,  373, 
            0,    0,   46,   47,    0,   48,    0,  374,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  102,  103, 
           17,   18,    0,    0,    0,    0,  104,  105,  106,   22, 
           23,   24,   25,    0,    0,  107,    0,    0,    0,    0, 
            0,    0,  108,    0,    0,   31,   32,   33,    0,  109, 
           35,   36,   37,  110,   39,    0,   40,    0,    0,  111, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  113, 
            0,    0,  114,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  102,  103,   17,   18,    0,    0,    0,    0,  104, 
          105,  106,   22,   23,   24,   25,    0,    0,  107,    0, 
            0,    0,    0,    0,    0,  108,    0,    0,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,    0,   40, 
            0,    0,  111,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  298,    0,    0,  373,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  102,  103,   17,   18,    0,    0, 
            0,    0,  104,  105,  106,   22,   23,   24,   25,    0, 
            0,  107,    0,    0,    0,    0,    0,    0,  108,    0, 
            0,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,    0,   40,    0,    0,  111,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  841,    0,    0,  114,    0, 
            0,   46,   47,    0,   48,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  102,  103,   17, 
           18,    0,    0,    0,    0,  104,  105,  106,   22,   23, 
           24,   25,    0,    0,  107,    0,    0,    0,    0,    0, 
            0,  108,    0,    0,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,    0,    0,  111,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  918,    0, 
            0,  114,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,  124,  125,  126,  127,  128,  129,  130,  131, 
            0,    0,  132,  133,  134,  135,  136,    0,    0,  137, 
          138,  139,  140,  141,  142,  143,    0,    0,  144,  145, 
          146,  204,  205,  206,  207,  151,  152,  153,  154,  155, 
          156,  157,  158,  159,  160,  161,  162,  208,  209,  210, 
            0,  211,  167,  274,    0,  212,    0,    0,    0,  169, 
          170,    0,  171,  172,  173,  174,  175,  176,  177,    0, 
            0,  178,  179,    0,    0,    0,  180,  181,  182,  183, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  185,  186,    0,  187,  188,  189,  190,  191, 
          192,  193,  194,  195,  196,  197,    0,    0,  198,   52, 
          124,  125,  126,  127,  128,  129,  130,  131,    0,    0, 
          132,  133,  134,  135,  136,    0,    0,  137,  138,  139, 
          140,  141,  142,  143,    0,    0,  144,  145,  146,  204, 
          205,  206,  207,  151,  152,  153,  154,  155,  156,  157, 
          158,  159,  160,  161,  162,  208,  209,  210,    0,  211, 
          167,    0,    0,  212,    0,    0,    0,  169,  170,    0, 
          171,  172,  173,  174,  175,  176,  177,    0,    0,  178, 
          179,    0,    0,    0,  180,  181,  182,  183,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          185,  186,    0,  187,  188,  189,  190,  191,  192,  193, 
          194,  195,  196,  197,    0,    0,  198,   52,  124,  125, 
          126,  127,  128,  129,  130,  131,    0,    0,  132,  133, 
          134,  135,  136,    0,    0,  137,  138,  139,  140,  141, 
          142,  143,    0,    0,  144,  145,  146,  147,  148,  149, 
          150,  151,  152,  153,  154,  155,  156,  157,  158,  159, 
          160,  161,  162,  163,  164,  165,    0,  166,  167,   36, 
           37,  168,   39,    0,    0,  169,  170,    0,  171,  172, 
          173,  174,  175,  176,  177,    0,    0,  178,  179,    0, 
            0,    0,  180,  181,  182,  183,    0,    0,    0,    0, 
            0,  184,    0,    0,    0,    0,    0,    0,  185,  186, 
            0,  187,  188,  189,  190,  191,  192,  193,  194,  195, 
          196,  197,    0,    0,  198,  124,  125,  126,  127,  128, 
          129,  130,  131,    0,    0,  132,  133,  134,  135,  136, 
            0,    0,  137,  138,  139,  140,  141,  142,  143,    0, 
            0,  144,  145,  146,  204,  205,  206,  207,  151,  152, 
          153,  154,  155,  156,  157,  158,  159,  160,  161,  162, 
          208,  209,  210,    0,  211,  167,  308,  309,  212,  310, 
            0,    0,  169,  170,    0,  171,  172,  173,  174,  175, 
          176,  177,    0,    0,  178,  179,    0,    0,    0,  180, 
          181,  182,  183,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  185,  186,    0,  187,  188, 
          189,  190,  191,  192,  193,  194,  195,  196,  197,    0, 
            0,  198,  124,  125,  126,  127,  128,  129,  130,  131, 
            0,    0,  132,  133,  134,  135,  136,    0,    0,  137, 
          138,  139,  140,  141,  142,  143,    0,    0,  144,  145, 
          146,  204,  205,  206,  207,  151,  152,  153,  154,  155, 
          156,  157,  158,  159,  160,  161,  162,  208,  209,  210, 
            0,  211,  167,    0,    0,  212,    0,    0,    0,  169, 
          170,    0,  171,  172,  173,  174,  175,  176,  177,    0, 
            0,  178,  179,    0,    0,    0,  180,  181,  182,  183, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  185,  186,    0,  187,  188,  189,  190,  191, 
          192,  193,  194,  195,  196,  197,  640,  562,  198,    0, 
          641,    0,    0,    0,  169,  170,    0,  171,  172,  173, 
          174,  175,  176,  177,    0,    0,  178,  179,    0,    0, 
            0,  180,  181,  182,  183,    0,    0,    0,    0,    0, 
          268,    0,    0,    0,    0,    0,    0,  185,  186,    0, 
          187,  188,  189,  190,  191,  192,  193,  194,  195,  196, 
          197,  642,  568,  198,    0,  643,    0,    0,    0,  169, 
          170,    0,  171,  172,  173,  174,  175,  176,  177,    0, 
            0,  178,  179,    0,    0,    0,  180,  181,  182,  183, 
            0,    0,    0,    0,    0,  268,    0,    0,    0,    0, 
            0,    0,  185,  186,    0,  187,  188,  189,  190,  191, 
          192,  193,  194,  195,  196,  197,  669,  562,  198,    0, 
          670,    0,    0,    0,  169,  170,    0,  171,  172,  173, 
          174,  175,  176,  177,    0,    0,  178,  179,    0,    0, 
            0,  180,  181,  182,  183,    0,    0,    0,    0,    0, 
          268,    0,    0,    0,    0,    0,    0,  185,  186,    0, 
          187,  188,  189,  190,  191,  192,  193,  194,  195,  196, 
          197,  671,  568,  198,    0,  672,    0,    0,    0,  169, 
          170,    0,  171,  172,  173,  174,  175,  176,  177,    0, 
            0,  178,  179,    0,    0,    0,  180,  181,  182,  183, 
            0,    0,    0,    0,    0,  268,    0,    0,    0,    0, 
            0,    0,  185,  186,    0,  187,  188,  189,  190,  191, 
          192,  193,  194,  195,  196,  197,  930,  562,  198,    0, 
          931,    0,    0,    0,  169,  170,    0,  171,  172,  173, 
          174,  175,  176,  177,    0,    0,  178,  179,    0,    0, 
            0,  180,  181,  182,  183,    0,    0,    0,    0,    0, 
          268,    0,    0,    0,    0,    0,    0,  185,  186,    0, 
          187,  188,  189,  190,  191,  192,  193,  194,  195,  196, 
          197,  932,  568,  198,    0,  933,    0,    0,    0,  169, 
          170,    0,  171,  172,  173,  174,  175,  176,  177,    0, 
            0,  178,  179,    0,    0,    0,  180,  181,  182,  183, 
            0,    0,    0,    0,    0,  268,    0,    0,    0,    0, 
            0,    0,  185,  186,    0,  187,  188,  189,  190,  191, 
          192,  193,  194,  195,  196,  197,  961,  568,  198,    0, 
          962,    0,    0,    0,  169,  170,    0,  171,  172,  173, 
          174,  175,  176,  177,    0,    0,  178,  179,    0,    0, 
            0,  180,  181,  182,  183,    0,    0,    0,    0,    0, 
          268,    0,    0,    0,    0,    0,    0,  185,  186,    0, 
          187,  188,  189,  190,  191,  192,  193,  194,  195,  196, 
          197,  575,  562,  198,    0,  576,    0,    0,    0,  169, 
          170,    0,  171,  172,  173,  174,  175,  176,  177,    0, 
            0,  178,  179,    0,    0,    0,  180,  181,  182,  183, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  185,  186,    0,  187,  188,  189,  190,  191, 
          192,  193,  194,  195,  196,  197,    0,    0,  198, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

            6,    7,   26,    2,   28,   92,   27,   15,   16,    4, 
            5,   19,   15,   16,  234,  367,   19,  419,    7,   14, 
            7,   27,    6,    3,  260,    2,    3,  394,  404,    0, 
            0,   21,  372,  434,  293,  322,  437,  296,   27,  424, 
           27,  393,   21,  437,   47,   48,   52,   10,   47,   48, 
           10,   11,   10,   10,   49,   49,  322,  365,  366,   10, 
          368,  369,  414,   59,  113,    0,   10,   10,   52,  693, 
           10,  701,  699,   10,   64,   10,  428,  786,  472,   44, 
           99,   44,   10,  391,  108,   64,   10,   59,   15,   16, 
           99,  524,   19,  505,   59,   10,   59,   92,   44,   32, 
          482,   59,  788,   10,  412,  413,  285,   45,  314,  396, 
          316,   45,  318,   59,  280,   10,  106,   59,  426,   59, 
           47,  608,   59,  280,   59,  115,   10,  560,   11,  481, 
           10,   59,  688,   10,   51,   10,  305,  305,  305,   10, 
           10,   10,  376,  630,   10,  884,   61,   10,  704,   44, 
           10,  459,   10,  862,   10,    0,  715,  644,  290,  291, 
           10,   10,  721,   59,   59,   10,   10,   44,  402,   10, 
           10,  479,  341,   44,  340,   59,   10,   10,   10,   59, 
          114,   10,   10,   10,   59,   10,  673,   10,   10,  358, 
           61,   61,   61,   59,  373,  361,   59,   10,  308,   10, 
           44,   61,  911,  222,  361,  374,  374,  374,  590,   59, 
          446,  950,  299,  222,   59,   59,   99,   44,  237,  506, 
          306,  220,  340,  909,  310,  308,  309,   10,  311,   10, 
          939,   44,   59,   10,  117,  602,   10,   10,   48,  866, 
          506,  340,  219,  873,  868,   10,  613,   10,   59,  344, 
          361,  807,   10,  654,  655,  882,  632,  265,  325,  267, 
          268,  655,  265,   44,  267,  375,  376,  362,   10,  268, 
          682,  683,   10,   10,   10,  310,  709,   32,   61,   44, 
           61,  241,  242,   10,   61,  378,  379,   61,   61,   32, 
          496,  358,  375,  376,  328,  328,   61,   10,  337,   44, 
          365,  335,  335,   61,  299,   91,    2,    3,    4,    5, 
           91,   44,    8,    9,   10,   11,   61,   59,   14,   15, 
           16,   59,   59,   19,  611,   61,   91,  264,  256,  282, 
          372,  268,  269,   61,   61,  377,  268,  269,  265,  222, 
          267,  281,  305,  392,  278,  611,   59,  285,  340,   45, 
           46,  285,  734,   49,  237,   51,   91,  334,   61,  367, 
          366,  337,  358,  305,  279,   44,  290,  291,  367,  341, 
          330,  331,  332,  333,  786,  365,  788,   44,  341,  374, 
          374,  378,  379,  267,  769,  393,  392,  344,   44,  340, 
          730,  362,  362,  358,  393,  482,   92,  341,  341,  379, 
          344,  391,  379,  402,  362,  404,  414,  413,  667,  279, 
          305,  374,  358,  649,  634,  414,  112,  704,  114,  279, 
          428,  427,  412,  267,   91,  305,  341,  362,  356,  428, 
          407,  434,  374,  454,  341,  373,  426,  370,  371,  373, 
          267,  251,  252,  253,  377,  372,  341,  934,  454,  376, 
          862,  863,  854,  370,  460,  372,  267,  858,  457,  376, 
          377,  341,  358,  358,  858,  454,  469,  454,  835,  459, 
          341,  341,  341,  481,  480,  402,  410,  262,  854,  374, 
          457,  341,  481,  341,  418,  341,  344,  482,  344,  479, 
           10,  341,  341,  420,  374,  344,  279,  909,  279,  911, 
          341,  341,  279,  590,  387,  279,  279,  341,  341,  341, 
           91,  338,  341,  341,  279,  280,  341,  516,  341,  341, 
           91,  279,  264,  219,  523,  524,  264,  939,  748,  896, 
          267,  269,  264,  271,  279,  559,  772,   10,   91,   59, 
          423,  424,  328,  279,   91,  241,  242,  328,  900,  335, 
          574,  264,  279,  840,  335,  269,  269,  271,  341,  340, 
          341,  560,  372,  328,  341,  564,  376,  341,  341,  265, 
          335,  267,  268,  337,  564,  271,  341,  273,  577,  578, 
          570,  668,  278,  341,  608,  564,   59,  577,  578,  285, 
          898,  570,  402,  328,  615,  590,  361,  372,  577,  578, 
          335,  338,  377,  299,  603,  341,  630,   10,  614,  615, 
          420,  310,  279,  603,  341,   61,  606,  263,  264,  618, 
          644,   10,  621,  433,  434,  624,  615,  437,  615,  849, 
          614,  337,   91,  632,  330,  331,  332,  333,  334,  335, 
          336,  601,   10,  271,   59,  310,   10,  734,  279,  673, 
          306,  654,  308,  309,  310,  311,   59,  263,  264,  469, 
          338,  328,  472,  269,    9,   10,   11,   44,  335,   44, 
           59,  367,  361,  668,  370,   91,  372,  373,  374,  317, 
          376,  377,  317,  379,  317,  645,  620,  317,   91,  688, 
          337,   59,  577,  578,  344,   59,  341,  393,  394,  395, 
          317,   46,  362,   15,   16,  704,  310,   19,   44,   44, 
          709,  407,  346,  372,  410,  348,  599,  372,  414,  352, 
          353,   44,  418,   91,  340,  269,  267,   91,  264,  612, 
           10,  348,  428,  341,   44,  352,  353,  354,  355,  734, 
           44,  675,  262,  263,  264,   44,   32,  328,  268,  269, 
           10,  271,  747,  362,  335,   91,   61,  328,   10,  455, 
          306,  457,  696,  697,  335,   44,   44,  112,  306,   10, 
          271,  581,  706,   44,  708,  328,   59,  711,  337,   59, 
           44,  328,  335,  337,   61,  481,  482,  288,  335,  337, 
          263,  264,   44,   44,  754,  712,  713,    2,    3,   59, 
          337,  718,  719,    8,    9,   10,   11,   44,  807,   61, 
           15,   16,   44,  730,   19,  264,  338,  751,   59,  263, 
          337,  341,  337,  337,    2,    3,    4,    5,  370,  371, 
            8,  765,  766,  767,  337,  377,   14,  647,  380,   91, 
           45,   46,  362,  362,  654,  655,   51,  264,   44,   58, 
           91,   44,  337,  344,  737,  854,  264,  264,  264,   91, 
          337,  699,  264,  701,  267,  362,  704,   45,   44,  328, 
          680,   49,   44,  262,  263,  264,  335,  280,  341,  268, 
          269,  815,  271,  878,   44,  306,  769,  308,  309,  310, 
          311,   44,  900,  899,  590,  264,  241,  242,   91,  267, 
           10,  900,  901,  267,  362,  601,  602,  112,  898,  114, 
          934,  828,  328,  847,   92,   44,  280,  613,  339,  335, 
           44,  731,   44,   61,  620,  328,  271,  358,  273,   44, 
           44,   44,  335,   44,   44,  264,  114,  936,  439,  362, 
          946,   44,  264,  279,  280,   59,  447,  448,  310,  645, 
          264,   61,  341,  265,  764,  267,  264,  358,  361,   44, 
          328,  264,  362,  464,  328,   44,  467,  335,  902,  310, 
           44,  335,  668,  362,  908,   44,  340,   91,   44,  675, 
          264,   91,  262,  263,  264,  330,  331,  332,  333,  269, 
          335,  336,  328,   44,  264,  271,  344,  361,   44,  335, 
          696,  697,  262,  263,  264,  362,  340,   44,  268,  269, 
          706,  271,  708,  271,  219,  711,  712,  713,  344,  362, 
          341,  831,  718,  719,  344,  361,  267,  279,  306,   58, 
          308,  309,  310,  311,  730,  873,  241,  242,  734,    0, 
          264,  219,   10,  344,  882,   91,  884,  279,  858,   10, 
          395,  747,  341,   66,   91,  751,  358,   54,  754,    5, 
          265,    6,  267,  268,  936,  882,  271,  699,  273,  765, 
          766,  767,  840,  278,   70,    0,  328,  370,  371,  372, 
          285,  341,   10,  335,  377,   10,  279,  328,  589,  341, 
           14,   59,   10,  901,  335,  682,  328,  868,   59,  340, 
          278,  457,  362,  335,  370,  371,  372,  285,  340,  610, 
          455,  377,  950,   10,   -1,   -1,   44,   -1,   -1,  815, 
           -1,  299,   -1,   91,   -1,  330,  331,  332,  333,  334, 
          335,  336,  828,   61,   59,  328,   10,   -1,   10,  835, 
           -1,   59,  335,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           44,  847,  370,  371,  372,   -1,  334,   -1,  659,  377, 
           -1,   -1,  367,   91,   61,  370,  280,  372,  373,  279, 
          280,  376,  377,   91,  379,   -1,  370,  371,  372,   -1, 
           -1,   -1,  878,  377,   -1,   59,  687,   59,  393,  394, 
          395,  370,  371,  372,   91,  373,  374,   91,  377,   -1, 
          896,  379,  407,   -1,  900,  410,  902,   -1,   -1,  414, 
           -1,   -1,  908,  418,  328,   -1,  394,   91,  328,   91, 
           -1,  335,   -1,  428,   -1,  335,  340,   -1,   -1,  407, 
          340,  341,  410,  279,  306,   -1,  308,  309,  310,  311, 
          418,  742,  279,   -1,  358,   10,   -1,  361,   -1,   -1, 
          455,  361,  457,  370,  371,  372,  601,   -1,   -1,   -1, 
          377,   -1,    2,    3,    4,    5,    6,  339,    8,  293, 
          294,  295,  296,  297,   14,   -1,  481,  349,  350,  457, 
           -1,   44,  328,  306,  785,  308,  309,  310,  311,  335, 
           -1,  328,   -1,   -1,   59,   -1,   59,   10,  335,  267, 
          645,  262,  263,  264,  482,   45,  267,  268,  269,   49, 
          271,   -1,   -1,   10,   -1,    2,    3,    4,    5,    6, 
          281,    8,   -1,   -1,   -1,   -1,   91,   14,   91,  290, 
          291,   44,  293,  294,  295,  296,  297,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   44,  271,   44,   61,  267, 
           -1,  279,   92,   -1,   -1,   -1,  281,  282,   45,   -1, 
          328,   -1,   49,   -1,   61,  290,  291,  335,  293,  294, 
          295,  296,  297,   -1,  114,   -1,   10,   -1,   91,   -1, 
          341,   -1,  279,  280,   -1,  279,  280,   -1,   -1,   -1, 
           -1,   -1,   91,  267,   91,  267,  601,  602,   -1,   -1, 
          328,  362,   -1,   -1,   -1,   92,  280,  335,  613,  754, 
          328,   -1,  590,  341,   -1,  620,  341,  335,   -1,  344, 
           -1,  346,   -1,   -1,  602,   59,   -1,  114,   -1,   -1, 
           -1,  328,   -1,   -1,  328,  613,   -1,  362,  335,   -1, 
          645,  335,  620,  340,  341,  306,  340,  308,  309,  310, 
          311,   -1,   -1,   -1,  328,   -1,  328,   -1,   -1,  518, 
          519,  335,   -1,  335,  361,    0,  340,  361,   -1,   -1, 
          675,   -1,   -1,   10,   -1,   10,   -1,   -1,  339,  219, 
           -1,   -1,   -1,   10,   -1,   -1,  347,  361,   -1,   -1, 
          668,  696,  697,   -1,   -1,   -1,   -1,  675,  676,   -1, 
           -1,  706,  267,  708,    2,    3,  711,  712,  713,   44, 
            8,   -1,   -1,  718,  719,  280,   14,   44,  696,  697, 
           -1,   -1,   59,   -1,   59,  730,   -1,   -1,  706,   -1, 
          708,   -1,  219,  711,   61,  262,  263,  264,  278,   -1, 
           -1,  268,  269,   -1,  271,  285,  751,   45,   -1,  754, 
           -1,   -1,   -1,   44,   -1,   -1,  734,   -1,   -1,  299, 
          765,  766,  767,  328,   91,  328,  279,  280,  317,  747, 
          335,   -1,  335,  751,   -1,  340,   -1,  340,   -1,   -1, 
          279,  280,  279,   -1,  333,  334,   -1,  765,  766,  767, 
           -1,  278,   -1,   -1,  334,  358,  361,   -1,  285,  348, 
           91,  350,   -1,  352,  353,  354,  355,    2,    3,  358, 
          815,  360,  299,    8,  341,  328,  114,   -1,   -1,   -1, 
           -1,   -1,  335,  828,   -1,   -1,   -1,  340,  341,  328, 
          835,  328,   -1,  373,  374,  362,  335,  815,  335,  379, 
           -1,  340,  847,   -1,  341,   -1,   -1,  334,  361,   -1, 
           45,   -1,   -1,   -1,  394,   -1,   -1,  835,   -1,   -1, 
           -1,   -1,  361,   -1,   -1,   -1,   -1,  407,   -1,  847, 
          410,   -1,  306,   -1,  308,  309,  310,  311,  418,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,  373,  374,   -1,   10, 
           -1,  896,  379,   -1,  328,  900,   -1,  902,   -1,   -1, 
          878,  335,   59,  908,   -1,  339,  340,  394,   -1,   -1, 
           -1,   -1,   -1,  347,  348,  349,  350,  457,  896,  114, 
          407,  219,   -1,  410,  902,   -1,   -1,  262,  263,  264, 
          908,  418,  791,  268,  269,   -1,  271,   -1,   59,   -1, 
          799,  800,  482,  802,   -1,  804,   -1,  806,   -1,  808, 
          809,   -1,  279,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,   -1,  306,   -1,  308,  309,  310,  311,  306, 
          457,  308,  309,  310,  311,    0,   -1,   -1,   -1,   -1, 
          278,   -1,   -1,   -1,   -1,   10,   -1,  285,  279,  280, 
           -1,  328,   -1,   -1,   -1,  482,  339,   -1,  335,   -1, 
           -1,  328,  339,  340,  347,   -1,  341,   -1,  335,   -1, 
          347,  348,  349,  350,  341,   -1,  262,  263,  264,   44, 
           -1,   -1,  268,  269,  219,  271,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   -1,  334,  328,   -1,   -1, 
           -1,   -1,   -1,  306,  335,  308,  309,  310,  311,  340, 
          590,   -1,   -1,   -1,   -1,  914,  915,  916,  917,   -1, 
           -1,  920,  602,  922,  923,  924,  925,   -1,   -1,   -1, 
          361,   -1,   -1,  613,  372,  373,  339,  340,   -1,   -1, 
          620,  379,   -1,  278,  347,  348,  349,  350,   -1,   -1, 
          285,   -1,   -1,   -1,   -1,  341,  394,   -1,   -1,   -1, 
           -1,  960,   -1,  590,  963,  964,  965,  966,   -1,  407, 
           -1,   -1,  410,   -1,  973,  602,  362,  691,   -1,   -1, 
          418,   -1,   -1,   -1,   -1,   -1,  613,  701,  668,   -1, 
          704,   -1,   -1,  620,   -1,  675,   -1,   -1,   -1,  334, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,  306, 
          271,  308,  309,  310,  311,   -1,  696,  697,   -1,  457, 
          281,   -1,   -1,   -1,   -1,   -1,  706,   -1,  708,  290, 
          291,  711,  293,  294,  295,  296,  297,   -1,  373,   -1, 
           -1,  668,  339,   -1,  379,   -1,   -1,   -1,  675,   -1, 
          347,  348,  349,  350,  734,    0,   -1,  317,   -1,  394, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,  747,   -1,  696, 
          697,  751,  407,  333,  334,  410,   -1,   -1,   -1,  706, 
          341,  708,   -1,  418,  711,  765,  766,  767,  348,   -1, 
          350,   -1,  352,  353,  354,  355,   -1,  262,  263,  264, 
           -1,  362,  267,  268,  269,   -1,  271,  734,  306,   -1, 
          308,  309,  310,  311,   59,   -1,  281,  282,   -1,   -1, 
          747,   -1,  457,   -1,  751,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,  815,   -1,   -1,  765,  766, 
          767,  339,  340,    0,   -1,   -1,   -1,   -1,   -1,  347, 
          348,  349,  350,   10,   -1,  835,   -1,  871,   -1,  873, 
           -1,  875,   -1,   -1,  602,  879,   -1,  847,   -1,   -1, 
          884,   -1,   -1,   -1,  317,  613,  341,   -1,   -1,  344, 
           -1,  346,  620,   -1,   -1,   -1,   -1,   44,  815,   -1, 
          333,  334,   -1,   -1,   -1,   -1,   -1,  362,  878,   -1, 
           -1,   58,   59,   -1,   -1,  348,   63,   -1,  835,  352, 
          353,  354,  355,   15,   16,   -1,  896,   19,   -1,   -1, 
          847,  306,  902,  308,  309,  310,  311,  941,  908,   -1, 
           -1,   -1,   -1,   -1,  948,   -1,  950,  675,  952,   41, 
           42,   -1,   -1,   -1,   -1,   47,   48,   -1,   50,   51, 
           -1,  878,   -1,   -1,  339,  969,   -1,   -1,  696,  697, 
           -1,   -1,  347,  348,  349,  350,   -1,  602,  706,  896, 
          708,   -1,   -1,  711,   -1,  902,   -1,   -1,  613,   -1, 
           -1,  908,   -1,   -1,   -1,  620,   -1,   -1,   -1,   -1, 
           -1,   -1,  730,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          306,   -1,  308,  309,  310,  311,   -1,   -1,   -1,  747, 
           -1,   -1,   -1,  751,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,  765,  766,  767, 
           -1,   -1,   -1,  339,   -1,   -1,  281,  282,   -1,   -1, 
          675,  347,  348,  349,  350,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  696,  697,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  706,   -1,  708,   -1,   -1,  711,  815,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  341,  835,   -1,  344, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,  847, 
          267,  268,  269,   -1,  271,   -1,  751,  362,   -1,    0, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   10, 
          765,  766,  767,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,  251, 
          252,  253,  254,   -1,   -1,   -1,   -1,   -1,  896,   -1, 
           -1,   -1,   -1,  265,  902,  267,  268,  324,  325,   -1, 
          908,   -1,  329,  330,  276,   -1,   -1,   -1,   59,   -1, 
          815,  338,   -1,   -1,  341,  317,   -1,  344,   -1,  346, 
          322,  323,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          835,  333,  334,   -1,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,  847,   -1,   -1,   -1,  348,  374,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,  338,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  896,   -1,   -1,   -1,  367,   -1,  902,  370,   -1, 
          372,   -1,   -1,  908,  376,  377,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,  393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          402,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,  414,  415,  416,  417,   -1,   -1,  420,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  428,   -1,   -1,   -1, 
           -1,  433,  434,   -1,   -1,  437,   -1,   -1,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,  461, 
          462,  463,   -1,   -1,   -1,   -1,   -1,  469,   -1,   -1, 
          472,   10,   -1,   -1,   -1,   -1,  257,  258,  259,  481, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
          281,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           59,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,  336,   -1,   -1,  339,   -1, 
          341,  342,  343,   -1,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  581, 
           -1,  362,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   44,  647,  267,  268,  269,   -1, 
          271,   -1,  654,  655,   -1,   -1,   -1,   -1,   58,   59, 
          281,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,  680,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  306,   -1,  308,  309,  310,  311,   -1, 
          712,  713,   -1,   -1,   -1,   -1,  718,  719,   -1,   -1, 
          341,   -1,   -1,   -1,    0,  328,   -1,  729,  730,  731, 
           -1,   -1,  335,  735,   10,   -1,  339,  340,   -1,   -1, 
           -1,  362,   -1,   -1,  347,  348,  349,  350,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  757,  758,  759,  760,   -1, 
           -1,   -1,  764,   -1,   -1,   -1,   -1,  306,   44,  308, 
          309,  310,  311,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   61,   -1,   63,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,   -1,   -1,   10, 
          339,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
          349,  350,   -1,   -1,  816,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  828,   -1,   -1,  831, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  851, 
           -1,   -1,   63,   -1,   -1,   -1,  858,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,  279, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,  900,  299, 
           -1,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,  337,  338,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,  374,  375,  376,   63,  378,  379, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,  279,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,  337,  338,  339,  340,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,   -1,  364,  365, 
          366,  367,  368,  369,    0,   -1,   -1,  373,  374,  375, 
          376,   -1,  378,  379,   10,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,   44,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
          306,  307,   58,   59,  310,   61,   -1,   63,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,  340,   91,   -1,   -1,   -1,   -1, 
           -1,  347,  348,   -1,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,   -1,   -1,  363,   -1,   -1, 
           -1,  297,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   58,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,  306,  307,   -1,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,   91,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   10,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,   -1, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   59,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,  338,  339,  340,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   10,  373,  374,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   59,  299,   -1,   -1,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,  338,  339,  340,  341,  342, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
           -1,  364,  365,  366,  367,  368,  369,    0,   -1,   -1, 
          373,  374,  375,  376,   -1,  378,  379,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          306,   -1,  308,  309,  310,  311,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  328,   -1,   -1,   58,   59,   -1,   61,  335, 
           63,   -1,   -1,  339,  340,   -1,   -1,   -1,   -1,   -1, 
           -1,  347,  348,  349,  350,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
          306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,  331,  332,  333,  334,   -1, 
            0,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1, 
           10,  347,  348,   -1,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,   -1,   -1,  363,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,   -1,   -1,   -1,   44,  333,  334,   -1,   -1,   -1, 
           -1,   -1,  306,   -1,  308,  309,  310,  311,   58,   59, 
          348,   -1,  350,   63,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,   -1,   -1,   -1,  339,  340,   -1,   -1,   -1, 
           -1,   91,   -1,  347,  348,  349,  350,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   10,  299,   -1,   -1,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,  338,  339,  340,  341,  342, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   10, 
          373,  374,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   59,  299, 
           -1,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,   -1,  364,  365,  366,  367,  368,  369, 
            0,   -1,   -1,  373,  374,  375,  376,   -1,  378,  379, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,   -1,   58,   59, 
          265,  266,   -1,   63,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   91,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   10,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,  349,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   44,  373,   -1, 
          375,  376,   -1,  378,  379,  306,   -1,  308,  309,  310, 
          311,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,   -1,   -1,   -1,  339,  340, 
           -1,   -1,   -1,   -1,   91,   -1,  347,  348,  349,  350, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   59, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           -1,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   10,  373,  374,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   59,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,   -1,  364,  365,  366, 
          367,  368,  369,    0,   -1,   -1,  373,  374,  375,  376, 
           -1,  378,  379,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  306,   -1,  308,  309, 
          310,  311,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1, 
           -1,   58,   59,   -1,   61,  335,   63,   -1,   -1,  339, 
          340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348,  349, 
          350,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,  306,  307,   -1,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,    0,   -1,   -1,   -1, 
          340,   -1,   -1,   -1,   -1,   -1,   10,  347,  348,   -1, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,   -1,   -1,  363,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,   -1,  326,  327,   -1,   -1,   -1,   -1, 
           44,  333,  334,   -1,   -1,   -1,   -1,   -1,  306,   -1, 
          308,  309,  310,  311,   -1,   59,  348,   -1,  350,   63, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
          328,   -1,   -1,   -1,   -1,   -1,   -1,  335,   -1,   -1, 
           -1,  339,  340,   -1,   -1,   -1,   -1,   91,   -1,  347, 
          348,  349,  350,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

          275,  276,  277,  278,   -1,   -1,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   10,  299,   -1,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,  339,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,   -1,  362,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,  374, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,   63,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,  339,   -1,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,   -1,  364,  365,  366,  367,  368,  369,    0,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,   -1,   -1,   59,  265,  266, 
           -1,   63,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   91, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   10,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
           -1,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   44,  373,  297,  375,  376, 
           -1,  378,  379,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   63,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   59,   63, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,  339,   -1,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,  338, 
          339,   -1,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,    0,  362,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   10,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   44,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,  344,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   44, 
           -1,  326,  327,   -1,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   59,  340,   61,   -1,   63,   -1, 
           -1,   -1,  347,  348,   -1,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,   -1,   -1,  363,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,   -1, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,  304,   59,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
           -1,  339,  340,  341,  342,  343,   -1,  345,   -1,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,   -1,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,   -1,  339,  340,  341,  342,  343,   -1, 
          345,   -1,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,   -1,  364, 
          365,  366,  367,  368,  369,    0,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,   10,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,   -1,   -1,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,  341, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   -1,  257,  258,  259,   -1,  261,   -1, 
          362,   -1,  265,  266,   -1,   -1,   -1,  270,    0,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   10,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   44,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61, 
          333,   63,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,   -1,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   59,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,   -1,  339,  340,  341,  342,  343,   -1, 
          345,   -1,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,   -1,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,   -1,  339,  340,  341, 
          342,  343,   -1,  345,   -1,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,    0, 
          362,   -1,  364,  365,  366,  367,  368,  369,   -1,   10, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   58,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1, 
            0,  344,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   44,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   58,   59, 
           -1,   -1,  299,   63,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,   -1,   -1,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   58,   59,   -1,   61,   -1,   63,   -1,  280, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,    0,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   10,  360, 
          361,  362,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1, 
          280,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   44,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   58,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,   -1,   -1,  338,   91, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,  361,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  374,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,    0,  333,  334,  335, 
           -1,  337,  338,   -1,   -1,  341,   10,   -1,  344,   -1, 
          346,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   91,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
            0,  333,  334,  335,   -1,  337,  338,   -1,   -1,  341, 
           10,   -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  374,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  306,  307,   58,   59, 
          310,   61,   -1,   63,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
          340,   91,   -1,   -1,   -1,   -1,   -1,  347,  348,   -1, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,   -1,   -1,  363,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  280,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   44,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   58,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,   -1,   -1,  338,   91,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,  348,    0,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   10,  360,  361,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,    0, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,  374,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   58,   59,  305, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
           91,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,  348,    0,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   10,  360,   -1,  362,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,  374,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   44,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,   -1,   -1,  338,   91,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   -1,  360,    0,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  374, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,    0,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   10,  360, 
           -1,  362,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,  374,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   58,   59,  305,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,   91, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,    0,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,  374,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   44,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,   -1,   -1,  338,   91,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,  348,    0,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   10,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
            0,  333,  334,  335,   -1,   -1,  338,   -1,   -1,  341, 
           10,   -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  374,   -1,   44,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   63,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,  348,    0,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   10,  360,   -1,  362,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,  374,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   44,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,  333,  334, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   -1,  360,   -1,  362,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  374, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   44,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,  333,  334,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348,    0, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   10, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,    0,  333,  334,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   10,   -1,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   44, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,   -1, 
          362,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   44,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
            0,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,  374,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   58,   59, 
          305,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,  333,  334, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  348,    0,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   10,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,   -1,   -1,   -1,  338,    0,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,   10,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           44,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   58,   59,   -1,   -1,   -1,   63, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,  333,  334,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1,    0, 
          350,   -1,   -1,   -1,  354,  355,  356,  357,  358,   10, 
          360,   -1,  362,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,  374,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   58,   59,  305, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   -1,  350,   -1,   -1,   -1,  354,  355, 
          356,  357,  358,   -1,  360,   -1,  362,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  374,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   58,   59,   -1,   -1,   -1, 
           63,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,   -1,    0,  350,   -1,   -1,   -1, 
           -1,   -1,  356,  357,  358,   10,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   44, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   58,   59,   -1,   -1,   -1,   63,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,  333,  334,    0,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   10,  346,   -1,   -1,   -1,  350, 
           -1,   -1,   -1,   -1,   -1,  356,  357,  358,   -1,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   44,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   10,   -1,   -1,  350,   -1,   -1, 
           -1,   -1,   -1,  356,  357,  358,   -1,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,  374,  267,  268,  269,   -1,  271,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   58,   59,   -1,  290,  291,   63,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,  356,  357,  358,   10,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  374,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,   -1,   63, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  356,  357,  358,   -1,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,   -1,   -1,   -1,   44,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   10,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  356,  357,   -1,   -1,   -1,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,   -1,   44,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  356,  357,   -1,  262,  263,  264,  362,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,   -1,   63,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  356, 
          357,    0,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,   -1,   -1,   -1,   -1,    0,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  356,  357,   -1, 
           -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,    0,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1, 
           -1,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   44,  346, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,  362,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1,   -1, 
          329,  330,   58,   59,   -1,   -1,   -1,   63,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,  362,   -1,  267,  268,  269,   -1,  271, 
           -1,    0,   -1,   -1,   -1,  374,   -1,   -1,   -1,  281, 
          282,   10,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330,   58, 
           59,   -1,   -1,   -1,   63,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,    0,   -1,   -1, 
          362,   -1,   -1,   -1,   -1,  281,  282,   10,   -1,   -1, 
           -1,   -1,  374,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   10,   -1,   -1,  324,  325, 
           -1,   -1,   -1,  329,  330,   58,   59,   -1,   -1,   -1, 
           63,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   44, 
           -1,  267,  268,  269,   -1,  271,  362,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,  281,  282,   10,  374,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   10,  324,  325, 
           -1,   -1,   -1,  329,  330,   58,   59,   -1,   -1,   -1, 
           63,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,  262,  263,  264,  362,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   58,   59,   -1,  374,   -1, 
           63,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1,   -1, 
          329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   44,  346,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           58,   59,   -1,  362,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,  374,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,  262,  263,  264, 
           -1,   -1,  305,  268,  269,   -1,  271,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,  325,   -1,   -1,   -1,  329,  330,  293,  294, 
          295,  296,  297,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   44,   -1,  267,  268,  269,   -1,  271,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,  281,  282, 
           -1,  374,   -1,   -1,   -1,   -1,  341,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,  262, 
          263,  264,  305,    0,  267,  268,  269,  362,  271,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,  338,   -1,   -1,  341,   -1, 
           -1,  344,  305,  346,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362, 
           -1,   58,   59,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,   -1,   10,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   44,   -1, 
           -1,  374,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   58,   59,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          338,    0,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,  362,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   44,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   58, 
           59,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   10,   -1,  341, 
           -1,   -1,  344,   -1,  346,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
          362,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   44,  374,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   58,   59,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,  281,  282,  344,   -1,  346, 
           -1,   -1,   -1,   -1,  290,  291,    0,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,  362,   10,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   -1,   58,   59,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,  362,   10,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,    0,   -1,  344,   -1,  346,   -1,  262, 
          263,  264,   -1,   10,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,  374,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,  362, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  374,   59,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   58,   59, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,  281,  282, 
          344,   -1,  346,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,  362,   -1, 
           -1,   -1,  305,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  262,  263,  264,   44,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   58,   59,  281,  282,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,   44,  293,  294,  295,  296, 
          297,   -1,  262,  263,  264,  362,   -1,  267,  268,  269, 
           59,  271,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,    0,   -1, 
           -1,  338,   -1,   -1,  341,  305,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   44,   -1,  344,   -1,  346,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   10,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   44,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,  362,   -1,   -1,   10, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           91,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,  374,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
          362,   -1,   59,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,  374,   -1,  290,  291,   -1,  293,  294,  295, 
          296,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   -1,   -1,  256,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,  362,   10,  269,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,  374,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,  336,   -1,   -1,  339,  340, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   91,   -1, 
          351,   -1,   -1,   -1,   -1,  356,   -1,   -1,  359,   -1, 
          361,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  256, 
          257,  258,  259,  260,  261,  262,  263,  264,  265,  266, 
           -1,   10,  269,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,   -1,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336, 
           -1,   -1,  339,  340,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   91,   -1,  351,   -1,   -1,   -1,   -1,  356, 
           -1,   -1,  359,   -1,  361,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   10,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
           -1,   -1,  335,  336,   -1,   -1,  339,  340,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   91,   -1,  351,   -1, 
           -1,   -1,   -1,  356,   -1,   -1,  359,   -1,  361,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  256,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,   -1,   10, 
          269,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,   -1,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1, 
          339,  340,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,  356,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  256,  257,  258,  259,  260,  261,  262,  263,  264, 
          265,  266,   -1,   10,  269,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1, 
          335,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,  356,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  256,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,   -1,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   10,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256, 
          257,  258,  259,  260,  261,   -1,   -1,  264,  265,  266, 
           -1,   10,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,   -1,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  256,  257,  258,  259,  260,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,    0, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   10, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   59,   -1, 
          342,  343,   63,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
          362,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           91,  373,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,    0,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   10,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   59,   -1,  342,  343,   63,  345,   -1,   -1,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   91,  373,   -1,  375,  376,   -1,  378, 
          379,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           91,   -1,  333,  334,  335,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
           -1,  362,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   91,   -1,  333,  334,  335,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   -1,  362,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   44,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,   -1,   -1,  338,   91,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
           -1,  362,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,   -1, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  280,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   91,   -1,  333,  334,  335,   -1,   -1, 
           -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,  361,  362,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   91,   -1, 
          333,  334,  335,   -1,  337,   -1,   -1,   -1,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   -1,  362, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,   -1, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   44,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,   -1,  337, 
           -1,   91,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,   -1,  350,    0,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   10,  362,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   44,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   44,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,    0,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,   -1,   -1,   -1,    0,   -1,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,   10,  350,    0,  352, 
          353,  354,  355,  356,  357,  358,   59,  360,   10,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,  262,  263,  264,   -1,   -1,   -1,  268,  269, 
           -1,  271,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,   -1,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,   -1,  362,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   44,   -1, 
           -1,  262,  263,  264,  281,  282,  267,  268,  269,   -1, 
          271,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  341,  268,  269,  344,  271,  346, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,  262,  263, 
          264,  362,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

          341,   -1,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  362,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   59,  306,  307,  308,  309,  310,  311,   -1,  313, 
           -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   59,  306,  307,  308,  309,  310, 
          311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,  260,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,  300,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,  260,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  256,  257,  258,  259,  260, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  256, 
          257,  258,  259,  260,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,   -1,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  256,  257,  258,  259,  260,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
          260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
          300,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,  260,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,   -1,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,  349,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,  349,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,  349,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,  340,   -1,  342, 
          343,   -1,  345,   -1,   -1,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,  340,   -1,  342,  343,   -1, 
          345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,   -1,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,   -1,   -1,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
           -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,   -1,   -1,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,  260,  261,  262,  263,  264, 
           -1,   -1,  267,  268,  269,  270,  271,   -1,   -1,  274, 
          275,  276,  277,  278,  279,  280,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,  298,  299,  300,  301,  302,  303,  304, 
           -1,  306,  307,  308,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,  348,   -1,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,   -1,   -1,  363,  364, 
          257,  258,  259,  260,  261,  262,  263,  264,   -1,   -1, 
          267,  268,  269,  270,  271,   -1,   -1,  274,  275,  276, 
          277,  278,  279,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,  298,  299,  300,  301,  302,  303,  304,   -1,  306, 
          307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,   -1,  363,  364,  257,  258, 
          259,  260,  261,  262,  263,  264,   -1,   -1,  267,  268, 
          269,  270,  271,   -1,   -1,  274,  275,  276,  277,  278, 
          279,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,  298, 
          299,  300,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,   -1,   -1,  363,  257,  258,  259,  260,  261, 
          262,  263,  264,   -1,   -1,  267,  268,  269,  270,  271, 
           -1,   -1,  274,  275,  276,  277,  278,  279,  280,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,  298,  299,  300,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,   -1, 
           -1,  363,  257,  258,  259,  260,  261,  262,  263,  264, 
           -1,   -1,  267,  268,  269,  270,  271,   -1,   -1,  274, 
          275,  276,  277,  278,  279,  280,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,  298,  299,  300,  301,  302,  303,  304, 
           -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,  348,   -1,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  306,  307,  363,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
          340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348,   -1, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  306,  307,  363,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,  348,   -1,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  306,  307,  363,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
          340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348,   -1, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  306,  307,  363,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,  348,   -1,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  306,  307,  363,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
          340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348,   -1, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  306,  307,  363,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,  348,   -1,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  306,  307,  363,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
          340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348,   -1, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  306,  307,  363,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,  348,   -1,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,   -1,   -1,  363, 
      };
   }

}
