/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.krypt.asn1;

import impl.krypt.asn1.Asn1Object;
import impl.krypt.asn1.TagClass;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.krypt.Errors;
import org.jruby.ext.krypt.asn1.RubyAsn1;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Asn1DataClasses {
    private Asn1DataClasses() {
    }

    private static TagAndClass validateArgs(Ruby runtime, IRubyObject[] args, int defaultTag) {
        RubySymbol tagClass;
        IRubyObject tag;
        switch (args.length) {
            case 3: {
                if (!args[2].isNil() && args[1].isNil()) {
                    throw Errors.newASN1Error(runtime, "Tag must be specified if tag class is");
                }
                tag = args[1];
                tagClass = args[2];
                break;
            }
            case 2: {
                tag = args[1];
                tagClass = runtime.newSymbol(TagClass.CONTEXT_SPECIFIC.name());
                break;
            }
            case 1: {
                tag = runtime.newFixnum(defaultTag);
                tagClass = runtime.newSymbol(TagClass.UNIVERSAL.name());
                break;
            }
            default: {
                throw new IllegalStateException("caller must restrict number of args <= 3");
            }
        }
        return new TagAndClass(tag, (IRubyObject)tagClass);
    }

    private static IRubyObject init(RubyAsn1.Asn1Data data, ThreadContext ctx, IRubyObject[] args, int defaultTag) {
        Ruby runtime = ctx.getRuntime();
        IRubyObject value = args[0];
        TagAndClass tac = Asn1DataClasses.validateArgs(runtime, args, defaultTag);
        IRubyObject tag = tac.tag;
        IRubyObject tagClass = tac.tagClass;
        RubyAsn1.defaultInitialize(runtime, data, value, tag, tagClass);
        data.setCodec(RubyAsn1.codecFor(defaultTag, TagClass.UNIVERSAL));
        return data;
    }

    public static class Asn1BmpString
    extends RubyAsn1.Asn1Primitive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1BmpString(runtime, type);
            }
        };

        private Asn1BmpString(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1BmpString(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=1, optional=2)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            return Asn1DataClasses.init(this, ctx, args, this.getDefaultTag());
        }

        @Override
        protected int getDefaultTag() {
            return 30;
        }
    }

    public static class Asn1UniversalString
    extends RubyAsn1.Asn1Primitive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1UniversalString(runtime, type);
            }
        };

        private Asn1UniversalString(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1UniversalString(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=1, optional=2)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            return Asn1DataClasses.init(this, ctx, args, this.getDefaultTag());
        }

        @Override
        protected int getDefaultTag() {
            return 28;
        }
    }

    public static class Asn1GeneralString
    extends RubyAsn1.Asn1Primitive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1GeneralString(runtime, type);
            }
        };

        private Asn1GeneralString(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1GeneralString(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=1, optional=2)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            return Asn1DataClasses.init(this, ctx, args, this.getDefaultTag());
        }

        @Override
        protected int getDefaultTag() {
            return 27;
        }
    }

    public static class Asn1Iso64String
    extends RubyAsn1.Asn1Primitive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1Iso64String(runtime, type);
            }
        };

        private Asn1Iso64String(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1Iso64String(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=1, optional=2)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            return Asn1DataClasses.init(this, ctx, args, this.getDefaultTag());
        }

        @Override
        protected int getDefaultTag() {
            return 26;
        }
    }

    public static class Asn1GraphicString
    extends RubyAsn1.Asn1Primitive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1GraphicString(runtime, type);
            }
        };

        private Asn1GraphicString(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1GraphicString(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=1, optional=2)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            return Asn1DataClasses.init(this, ctx, args, this.getDefaultTag());
        }

        @Override
        protected int getDefaultTag() {
            return 25;
        }
    }

    public static class Asn1GeneralizedTime
    extends RubyAsn1.Asn1Primitive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1GeneralizedTime(runtime, type);
            }
        };

        private Asn1GeneralizedTime(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1GeneralizedTime(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=1, optional=2)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            return Asn1DataClasses.init(this, ctx, args, this.getDefaultTag());
        }

        @Override
        protected int getDefaultTag() {
            return 24;
        }
    }

    public static class Asn1UtcTime
    extends RubyAsn1.Asn1Primitive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1UtcTime(runtime, type);
            }
        };

        private Asn1UtcTime(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1UtcTime(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=1, optional=2)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            return Asn1DataClasses.init(this, ctx, args, this.getDefaultTag());
        }

        @Override
        protected int getDefaultTag() {
            return 23;
        }
    }

    public static class Asn1Ia5String
    extends RubyAsn1.Asn1Primitive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1Ia5String(runtime, type);
            }
        };

        private Asn1Ia5String(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1Ia5String(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=1, optional=2)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            return Asn1DataClasses.init(this, ctx, args, this.getDefaultTag());
        }

        @Override
        protected int getDefaultTag() {
            return 22;
        }
    }

    public static class Asn1VideotexString
    extends RubyAsn1.Asn1Primitive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1VideotexString(runtime, type);
            }
        };

        private Asn1VideotexString(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1VideotexString(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=1, optional=2)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            return Asn1DataClasses.init(this, ctx, args, this.getDefaultTag());
        }

        @Override
        protected int getDefaultTag() {
            return 21;
        }
    }

    public static class Asn1T61String
    extends RubyAsn1.Asn1Primitive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1T61String(runtime, type);
            }
        };

        private Asn1T61String(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1T61String(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=1, optional=2)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            return Asn1DataClasses.init(this, ctx, args, this.getDefaultTag());
        }

        @Override
        protected int getDefaultTag() {
            return 20;
        }
    }

    public static class Asn1PrintableString
    extends RubyAsn1.Asn1Primitive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1PrintableString(runtime, type);
            }
        };

        private Asn1PrintableString(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1PrintableString(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=1, optional=2)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            return Asn1DataClasses.init(this, ctx, args, this.getDefaultTag());
        }

        @Override
        protected int getDefaultTag() {
            return 19;
        }
    }

    public static class Asn1NumericString
    extends RubyAsn1.Asn1Primitive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1NumericString(runtime, type);
            }
        };

        private Asn1NumericString(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1NumericString(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=1, optional=2)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            return Asn1DataClasses.init(this, ctx, args, this.getDefaultTag());
        }

        @Override
        protected int getDefaultTag() {
            return 18;
        }
    }

    public static class Asn1Set
    extends RubyAsn1.Asn1Constructive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1Set(runtime, type);
            }
        };

        private Asn1Set(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1Set(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=1, optional=2)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            return Asn1DataClasses.init(this, ctx, args, this.getDefaultTag());
        }

        @Override
        protected int getDefaultTag() {
            return 17;
        }
    }

    public static class Asn1Sequence
    extends RubyAsn1.Asn1Constructive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1Sequence(runtime, type);
            }
        };

        private Asn1Sequence(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1Sequence(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=1, optional=2)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            return Asn1DataClasses.init(this, ctx, args, this.getDefaultTag());
        }

        @Override
        protected int getDefaultTag() {
            return 16;
        }
    }

    public static class Asn1Utf8String
    extends RubyAsn1.Asn1Primitive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1Utf8String(runtime, type);
            }
        };

        private Asn1Utf8String(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1Utf8String(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=1, optional=2)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            return Asn1DataClasses.init(this, ctx, args, this.getDefaultTag());
        }

        @Override
        protected int getDefaultTag() {
            return 12;
        }
    }

    public static class Asn1Enumerated
    extends RubyAsn1.Asn1Primitive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1Enumerated(runtime, type);
            }
        };

        private Asn1Enumerated(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1Enumerated(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=1, optional=2)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            return Asn1DataClasses.init(this, ctx, args, this.getDefaultTag());
        }

        @Override
        protected int getDefaultTag() {
            return 10;
        }
    }

    public static class Asn1ObjectId
    extends RubyAsn1.Asn1Primitive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1ObjectId(runtime, type);
            }
        };

        private Asn1ObjectId(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1ObjectId(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=1, optional=2)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            return Asn1DataClasses.init(this, ctx, args, this.getDefaultTag());
        }

        @Override
        protected int getDefaultTag() {
            return 6;
        }
    }

    public static class Asn1Null
    extends RubyAsn1.Asn1Primitive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1Null(runtime, type);
            }
        };

        private Asn1Null(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1Null(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=0, optional=3)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            Ruby runtime = ctx.getRuntime();
            if (args.length == 0) {
                RubyAsn1.defaultInitialize(runtime, this, runtime.getNil(), (IRubyObject)runtime.newFixnum(5), (IRubyObject)runtime.newSymbol(TagClass.UNIVERSAL.name()));
                return this;
            }
            if (!args[0].isNil()) {
                throw runtime.newArgumentError("Value for ASN.1 NULL must be nil");
            }
            return Asn1DataClasses.init(this, ctx, args, this.getDefaultTag());
        }

        @Override
        protected int getDefaultTag() {
            return 5;
        }
    }

    public static class Asn1OctetString
    extends RubyAsn1.Asn1Primitive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1OctetString(runtime, type);
            }
        };

        private Asn1OctetString(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1OctetString(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=1, optional=2)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            return Asn1DataClasses.init(this, ctx, args, this.getDefaultTag());
        }

        @Override
        protected int getDefaultTag() {
            return 4;
        }
    }

    public static class Asn1BitString
    extends RubyAsn1.Asn1Primitive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1BitString(runtime, type);
            }
        };

        private Asn1BitString(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1BitString(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=1, optional=2)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            IRubyObject val = Asn1DataClasses.init(this, ctx, args, this.getDefaultTag());
            val.getInstanceVariables().setInstanceVariable("unused_bits", (IRubyObject)RubyFixnum.zero((Ruby)ctx.getRuntime()));
            return val;
        }

        @Override
        protected int getDefaultTag() {
            return 3;
        }

        @JRubyMethod(name={"unused_bits="})
        public IRubyObject set_unused_bits(ThreadContext ctx, IRubyObject value) {
            this.getInstanceVariables().setInstanceVariable("unused_bits", value);
            return value;
        }

        @JRubyMethod
        public IRubyObject unused_bits(ThreadContext ctx) {
            if (!this.isDecoded()) {
                this.decodeValue(ctx);
            }
            return this.getInstanceVariables().getInstanceVariable("unused_bits");
        }
    }

    public static class Asn1Integer
    extends RubyAsn1.Asn1Primitive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1Integer(runtime, type);
            }
        };

        private Asn1Integer(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1Integer(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=1, optional=2)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            return Asn1DataClasses.init(this, ctx, args, this.getDefaultTag());
        }

        @Override
        protected int getDefaultTag() {
            return 2;
        }
    }

    public static class Asn1Boolean
    extends RubyAsn1.Asn1Primitive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1Boolean(runtime, type);
            }
        };

        private Asn1Boolean(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1Boolean(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=1, optional=2)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            return Asn1DataClasses.init(this, ctx, args, this.getDefaultTag());
        }

        @Override
        protected int getDefaultTag() {
            return 1;
        }
    }

    public static class Asn1EndOfContents
    extends RubyAsn1.Asn1Primitive {
        static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass type) {
                return new Asn1EndOfContents(runtime, type);
            }
        };

        private Asn1EndOfContents(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public Asn1EndOfContents(Ruby runtime, RubyClass type, Asn1Object object) {
            super(runtime, type, object);
        }

        @JRubyMethod(required=0, optional=1)
        public IRubyObject initialize(ThreadContext ctx, IRubyObject[] args) {
            IRubyObject value;
            Ruby runtime = ctx.getRuntime();
            if (args.length == 1 && !(value = args[0]).isNil()) {
                throw runtime.newArgumentError("Value must be nil for END_OF_CONTENTS");
            }
            RubyAsn1.defaultInitialize(runtime, this, runtime.getNil(), (IRubyObject)runtime.newFixnum(this.getDefaultTag()), (IRubyObject)runtime.newSymbol(TagClass.UNIVERSAL.name()));
            return this;
        }

        @Override
        protected int getDefaultTag() {
            return 0;
        }

        public static Asn1EndOfContents newInstance(ThreadContext ctx, RubyClass type) {
            Asn1EndOfContents eoc = new Asn1EndOfContents(ctx.getRuntime(), type);
            eoc.initialize(ctx, NULL_ARRAY);
            return eoc;
        }
    }

    private static class TagAndClass {
        private final IRubyObject tag;
        private final IRubyObject tagClass;

        public TagAndClass(IRubyObject tag, IRubyObject tagClass) {
            this.tag = tag;
            this.tagClass = tagClass;
        }
    }
}

