/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.krypt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class Base64 {
    private static final char[] B64TABLE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final byte[] B64TABLEINV = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final byte[] SEPARATOR = new byte[]{13, 10};

    private Base64() {
    }

    private static void writeInt(int n, OutputStream out) throws IOException {
        out.write(B64TABLE[n >> 18 & 0x3F]);
        out.write(B64TABLE[n >> 12 & 0x3F]);
        out.write(B64TABLE[n >> 6 & 0x3F]);
        out.write(B64TABLE[n & 0x3F]);
    }

    private static int computeInt(byte[] bytes, int i) {
        return (bytes[i] & 0xFF) << 16 | (bytes[i + 1] & 0xFF) << 8 | bytes[i + 2] & 0xFF;
    }

    private static void encodeUpdate(byte[] bytes, int off, int until, OutputStream out, int cols) throws IOException {
        int linePos = 0;
        for (int i = 0; i < until; i += 3) {
            Base64.writeInt(Base64.computeInt(bytes, off + i), out);
            if ((linePos += 4) < cols) continue;
            out.write(SEPARATOR);
            linePos = 0;
        }
    }

    private static void encodeUpdate(byte[] bytes, int off, int until, OutputStream out) throws IOException {
        for (int i = 0; i < until; i += 3) {
            Base64.writeInt(Base64.computeInt(bytes, off + i), out);
        }
    }

    private static void encodeFinal(byte[] bytes, int off, int len, OutputStream out, int remainder, boolean crlf) throws IOException {
        off = off + len - remainder;
        if (remainder != 0) {
            int n = bytes[off] << 16 | (remainder == 2 ? bytes[off + 1] << 8 : 0);
            out.write(B64TABLE[n >> 18 & 0x3F]);
            out.write(B64TABLE[n >> 12 & 0x3F]);
            out.write(remainder == 2 ? B64TABLE[n >> 6 & 0x3F] : 61);
            out.write(61);
        }
        if (crlf) {
            out.write(SEPARATOR);
        }
    }

    public static void encodeTo(byte[] bytes, int off, int len, OutputStream out, int cols) throws IOException {
        if (bytes == null) {
            throw new NullPointerException("bytes null");
        }
        int remainder = bytes.length % 3;
        if (cols < 0) {
            Base64.encodeUpdate(bytes, off, len - remainder, out);
        } else {
            Base64.encodeUpdate(bytes, off, len - remainder, out, cols);
        }
        Base64.encodeFinal(bytes, off, len, out, remainder, cols > 0);
    }

    public static String encodeAsString(byte[] bytes, int cols) throws IOException {
        try {
            return new String(Base64.encode(bytes, cols), "US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static byte[] encode(byte[] bytes, int cols) throws IOException {
        if (bytes == null) {
            throw new NullPointerException("bytes null");
        }
        long retlen = (long)(4.0 * Math.ceil((double)bytes.length / 3.0));
        if (cols > 0) {
            retlen += (long)(bytes.length / cols * 2);
        }
        if (retlen > Integer.MAX_VALUE) {
            retlen = Integer.MAX_VALUE;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream((int)retlen);
        Base64.encodeTo(bytes, 0, bytes.length, baos, cols);
        return baos.toByteArray();
    }

    private static void decodeInt(int n, OutputStream out) throws IOException {
        out.write(n >> 16 & 0xFF);
        out.write(n >> 8 & 0xFF);
        out.write(n & 0xFF);
    }

    private static void decodeFinalInt(int n, OutputStream out, int remainder) throws IOException {
        switch (remainder) {
            case 2: {
                out.write(n >> 4 & 0xFF);
                break;
            }
            case 3: {
                out.write((n >>= 2) >> 8 & 0xFF);
                out.write(n & 0xFF);
            }
        }
    }

    public static void decodeTo(byte[] in, int off, int len, OutputStream out) throws IOException {
        byte b;
        int n = 0;
        int remainder = 0;
        for (int i = 0; i < len && (b = in[off + i]) != 61; ++i) {
            byte inv;
            int idx = b & 0xFF;
            if (idx >= B64TABLEINV.length || (inv = B64TABLEINV[idx]) < 0) continue;
            n = n << 6 | inv;
            if ((remainder = (remainder + 1) % 4) != 0) continue;
            Base64.decodeInt(n, out);
        }
        Base64.decodeFinalInt(n, out, remainder);
    }

    public static byte[] decodeString(String b64String) throws IOException {
        try {
            return Base64.decode(b64String.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static byte[] decode(byte[] bytes) throws IOException {
        if (bytes == null) {
            throw new NullPointerException("bytes null");
        }
        int retlen = bytes.length / 4 * 3;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(retlen);
        Base64.decodeTo(bytes, 0, bytes.length, baos);
        return baos.toByteArray();
    }
}

