<?php


/**
 * Base class that represents a row from the 'folder' table.
 *
 *
 *
 * @package    propel.generator.datawrapper.om
 */
abstract class BaseFolder extends BaseObject implements Persistent
{
    /**
     * Peer class name
     */
    const PEER = 'FolderPeer';

    /**
     * The Peer class.
     * Instance provides a convenient way of calling static methods on a class
     * that calling code may not be able to identify.
     * @var        FolderPeer
     */
    protected static $peer;

    /**
     * The flag var to prevent infinit loop in deep copy
     * @var       boolean
     */
    protected $startCopy = false;

    /**
     * The value for the folder_id field.
     * @var        int
     */
    protected $folder_id;

    /**
     * The value for the parent_id field.
     * @var        int
     */
    protected $parent_id;

    /**
     * The value for the folder_name field.
     * @var        string
     */
    protected $folder_name;

    /**
     * The value for the user_id field.
     * @var        int
     */
    protected $user_id;

    /**
     * The value for the org_id field.
     * @var        string
     */
    protected $org_id;

    /**
     * @var        Folder
     */
    protected $aFolderRelatedByParentId;

    /**
     * @var        User
     */
    protected $aUser;

    /**
     * @var        Organization
     */
    protected $aOrganization;

    /**
     * @var        PropelObjectCollection|Chart[] Collection to store aggregation of Chart objects.
     */
    protected $collCharts;
    protected $collChartsPartial;

    /**
     * @var        PropelObjectCollection|Folder[] Collection to store aggregation of Folder objects.
     */
    protected $collFoldersRelatedByFolderId;
    protected $collFoldersRelatedByFolderIdPartial;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInSave = false;

    /**
     * Flag to prevent endless validation loop, if this object is referenced
     * by another object which falls in this transaction.
     * @var        boolean
     */
    protected $alreadyInValidation = false;

    /**
     * Flag to prevent endless clearAllReferences($deep=true) loop, if this object is referenced
     * @var        boolean
     */
    protected $alreadyInClearAllReferencesDeep = false;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $chartsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var		PropelObjectCollection
     */
    protected $foldersRelatedByFolderIdScheduledForDeletion = null;

    /**
     * Get the [folder_id] column value.
     *
     * @return int
     */
    public function getFolderId()
    {
        return $this->folder_id;
    }

    /**
     * Get the [parent_id] column value.
     *
     * @return int
     */
    public function getParentId()
    {
        return $this->parent_id;
    }

    /**
     * Get the [folder_name] column value.
     *
     * @return string
     */
    public function getFolderName()
    {
        return $this->folder_name;
    }

    /**
     * Get the [user_id] column value.
     *
     * @return int
     */
    public function getUserId()
    {
        return $this->user_id;
    }

    /**
     * Get the [org_id] column value.
     *
     * @return string
     */
    public function getOrgId()
    {
        return $this->org_id;
    }

    /**
     * Set the value of [folder_id] column.
     *
     * @param int $v new value
     * @return Folder The current object (for fluent API support)
     */
    public function setFolderId($v)
    {
        if ($v !== null && is_numeric($v)) {
            $v = (int) $v;
        }

        if ($this->folder_id !== $v) {
            $this->folder_id = $v;
            $this->modifiedColumns[] = FolderPeer::FOLDER_ID;
        }


        return $this;
    } // setFolderId()

    /**
     * Set the value of [parent_id] column.
     *
     * @param int $v new value
     * @return Folder The current object (for fluent API support)
     */
    public function setParentId($v)
    {
        if ($v !== null && is_numeric($v)) {
            $v = (int) $v;
        }

        if ($this->parent_id !== $v) {
            $this->parent_id = $v;
            $this->modifiedColumns[] = FolderPeer::PARENT_ID;
        }

        if ($this->aFolderRelatedByParentId !== null && $this->aFolderRelatedByParentId->getFolderId() !== $v) {
            $this->aFolderRelatedByParentId = null;
        }


        return $this;
    } // setParentId()

    /**
     * Set the value of [folder_name] column.
     *
     * @param string $v new value
     * @return Folder The current object (for fluent API support)
     */
    public function setFolderName($v)
    {
        if ($v !== null && is_numeric($v)) {
            $v = (string) $v;
        }

        if ($this->folder_name !== $v) {
            $this->folder_name = $v;
            $this->modifiedColumns[] = FolderPeer::FOLDER_NAME;
        }


        return $this;
    } // setFolderName()

    /**
     * Set the value of [user_id] column.
     *
     * @param int $v new value
     * @return Folder The current object (for fluent API support)
     */
    public function setUserId($v)
    {
        if ($v !== null && is_numeric($v)) {
            $v = (int) $v;
        }

        if ($this->user_id !== $v) {
            $this->user_id = $v;
            $this->modifiedColumns[] = FolderPeer::USER_ID;
        }

        if ($this->aUser !== null && $this->aUser->getId() !== $v) {
            $this->aUser = null;
        }


        return $this;
    } // setUserId()

    /**
     * Set the value of [org_id] column.
     *
     * @param string $v new value
     * @return Folder The current object (for fluent API support)
     */
    public function setOrgId($v)
    {
        if ($v !== null && is_numeric($v)) {
            $v = (string) $v;
        }

        if ($this->org_id !== $v) {
            $this->org_id = $v;
            $this->modifiedColumns[] = FolderPeer::ORG_ID;
        }

        if ($this->aOrganization !== null && $this->aOrganization->getId() !== $v) {
            $this->aOrganization = null;
        }


        return $this;
    } // setOrgId()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
        // otherwise, everything was equal, so return true
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by PDOStatement->fetch(PDO::FETCH_NUM)
     * @param int $startcol 0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false)
    {
        try {

            $this->folder_id = ($row[$startcol + 0] !== null) ? (int) $row[$startcol + 0] : null;
            $this->parent_id = ($row[$startcol + 1] !== null) ? (int) $row[$startcol + 1] : null;
            $this->folder_name = ($row[$startcol + 2] !== null) ? (string) $row[$startcol + 2] : null;
            $this->user_id = ($row[$startcol + 3] !== null) ? (int) $row[$startcol + 3] : null;
            $this->org_id = ($row[$startcol + 4] !== null) ? (string) $row[$startcol + 4] : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }
            $this->postHydrate($row, $startcol, $rehydrate);
            return $startcol + 5; // 5 = FolderPeer::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException("Error populating Folder object", $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {

        if ($this->aFolderRelatedByParentId !== null && $this->parent_id !== $this->aFolderRelatedByParentId->getFolderId()) {
            $this->aFolderRelatedByParentId = null;
        }
        if ($this->aUser !== null && $this->user_id !== $this->aUser->getId()) {
            $this->aUser = null;
        }
        if ($this->aOrganization !== null && $this->org_id !== $this->aOrganization->getId()) {
            $this->aOrganization = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param boolean $deep (optional) Whether to also de-associated any related objects.
     * @param PropelPDO $con (optional) The PropelPDO connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getConnection(FolderPeer::DATABASE_NAME, Propel::CONNECTION_READ);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $stmt = FolderPeer::doSelectStmt($this->buildPkeyCriteria(), $con);
        $row = $stmt->fetch(PDO::FETCH_NUM);
        $stmt->closeCursor();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aFolderRelatedByParentId = null;
            $this->aUser = null;
            $this->aOrganization = null;
            $this->collCharts = null;

            $this->collFoldersRelatedByFolderId = null;

        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param PropelPDO $con
     * @return void
     * @throws PropelException
     * @throws Exception
     * @see        BaseObject::setDeleted()
     * @see        BaseObject::isDeleted()
     */
    public function delete(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(FolderPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        try {
            $deleteQuery = FolderQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $con->commit();
                $this->setDeleted(true);
            } else {
                $con->commit();
            }
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @throws Exception
     * @see        doSave()
     */
    public function save(PropelPDO $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($con === null) {
            $con = Propel::getConnection(FolderPeer::DATABASE_NAME, Propel::CONNECTION_WRITE);
        }

        $con->beginTransaction();
        $isInsert = $this->isNew();
        try {
            $ret = $this->preSave($con);
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                FolderPeer::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }
            $con->commit();

            return $affectedRows;
        } catch (Exception $e) {
            $con->rollBack();
            throw $e;
        }
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param PropelPDO $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see        save()
     */
    protected function doSave(PropelPDO $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aFolderRelatedByParentId !== null) {
                if ($this->aFolderRelatedByParentId->isModified() || $this->aFolderRelatedByParentId->isNew()) {
                    $affectedRows += $this->aFolderRelatedByParentId->save($con);
                }
                $this->setFolderRelatedByParentId($this->aFolderRelatedByParentId);
            }

            if ($this->aUser !== null) {
                if ($this->aUser->isModified() || $this->aUser->isNew()) {
                    $affectedRows += $this->aUser->save($con);
                }
                $this->setUser($this->aUser);
            }

            if ($this->aOrganization !== null) {
                if ($this->aOrganization->isModified() || $this->aOrganization->isNew()) {
                    $affectedRows += $this->aOrganization->save($con);
                }
                $this->setOrganization($this->aOrganization);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                } else {
                    $this->doUpdate($con);
                }
                $affectedRows += 1;
                $this->resetModified();
            }

            if ($this->chartsScheduledForDeletion !== null) {
                if (!$this->chartsScheduledForDeletion->isEmpty()) {
                    foreach ($this->chartsScheduledForDeletion as $chart) {
                        // need to save related object because we set the relation to null
                        $chart->save($con);
                    }
                    $this->chartsScheduledForDeletion = null;
                }
            }

            if ($this->collCharts !== null) {
                foreach ($this->collCharts as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->foldersRelatedByFolderIdScheduledForDeletion !== null) {
                if (!$this->foldersRelatedByFolderIdScheduledForDeletion->isEmpty()) {
                    foreach ($this->foldersRelatedByFolderIdScheduledForDeletion as $folderRelatedByFolderId) {
                        // need to save related object because we set the relation to null
                        $folderRelatedByFolderId->save($con);
                    }
                    $this->foldersRelatedByFolderIdScheduledForDeletion = null;
                }
            }

            if ($this->collFoldersRelatedByFolderId !== null) {
                foreach ($this->collFoldersRelatedByFolderId as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param PropelPDO $con
     *
     * @throws PropelException
     * @see        doSave()
     */
    protected function doInsert(PropelPDO $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[] = FolderPeer::FOLDER_ID;
        if (null !== $this->folder_id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . FolderPeer::FOLDER_ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(FolderPeer::FOLDER_ID)) {
            $modifiedColumns[':p' . $index++]  = '`folder_id`';
        }
        if ($this->isColumnModified(FolderPeer::PARENT_ID)) {
            $modifiedColumns[':p' . $index++]  = '`parent_id`';
        }
        if ($this->isColumnModified(FolderPeer::FOLDER_NAME)) {
            $modifiedColumns[':p' . $index++]  = '`folder_name`';
        }
        if ($this->isColumnModified(FolderPeer::USER_ID)) {
            $modifiedColumns[':p' . $index++]  = '`user_id`';
        }
        if ($this->isColumnModified(FolderPeer::ORG_ID)) {
            $modifiedColumns[':p' . $index++]  = '`org_id`';
        }

        $sql = sprintf(
            'INSERT INTO `folder` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`folder_id`':
                        $stmt->bindValue($identifier, $this->folder_id, PDO::PARAM_INT);
                        break;
                    case '`parent_id`':
                        $stmt->bindValue($identifier, $this->parent_id, PDO::PARAM_INT);
                        break;
                    case '`folder_name`':
                        $stmt->bindValue($identifier, $this->folder_name, PDO::PARAM_STR);
                        break;
                    case '`user_id`':
                        $stmt->bindValue($identifier, $this->user_id, PDO::PARAM_INT);
                        break;
                    case '`org_id`':
                        $stmt->bindValue($identifier, $this->org_id, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', $e);
        }
        $this->setFolderId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param PropelPDO $con
     *
     * @see        doSave()
     */
    protected function doUpdate(PropelPDO $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();
        BasePeer::doUpdate($selectCriteria, $valuesCriteria, $con);
    }

    /**
     * Array of ValidationFailed objects.
     * @var        array ValidationFailed[]
     */
    protected $validationFailures = array();

    /**
     * Gets any ValidationFailed objects that resulted from last call to validate().
     *
     *
     * @return array ValidationFailed[]
     * @see        validate()
     */
    public function getValidationFailures()
    {
        return $this->validationFailures;
    }

    /**
     * Validates the objects modified field values and all objects related to this table.
     *
     * If $columns is either a column name or an array of column names
     * only those columns are validated.
     *
     * @param mixed $columns Column name or an array of column names.
     * @return boolean Whether all columns pass validation.
     * @see        doValidate()
     * @see        getValidationFailures()
     */
    public function validate($columns = null)
    {
        $res = $this->doValidate($columns);
        if ($res === true) {
            $this->validationFailures = array();

            return true;
        }

        $this->validationFailures = $res;

        return false;
    }

    /**
     * This function performs the validation work for complex object models.
     *
     * In addition to checking the current object, all related objects will
     * also be validated.  If all pass then <code>true</code> is returned; otherwise
     * an aggreagated array of ValidationFailed objects will be returned.
     *
     * @param array $columns Array of column names to validate.
     * @return mixed <code>true</code> if all validations pass; array of <code>ValidationFailed</code> objets otherwise.
     */
    protected function doValidate($columns = null)
    {
        if (!$this->alreadyInValidation) {
            $this->alreadyInValidation = true;
            $retval = null;

            $failureMap = array();


            // We call the validate method on the following object(s) if they
            // were passed to this object by their coresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aFolderRelatedByParentId !== null) {
                if (!$this->aFolderRelatedByParentId->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aFolderRelatedByParentId->getValidationFailures());
                }
            }

            if ($this->aUser !== null) {
                if (!$this->aUser->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aUser->getValidationFailures());
                }
            }

            if ($this->aOrganization !== null) {
                if (!$this->aOrganization->validate($columns)) {
                    $failureMap = array_merge($failureMap, $this->aOrganization->getValidationFailures());
                }
            }


            if (($retval = FolderPeer::doValidate($this, $columns)) !== true) {
                $failureMap = array_merge($failureMap, $retval);
            }


                if ($this->collCharts !== null) {
                    foreach ($this->collCharts as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }

                if ($this->collFoldersRelatedByFolderId !== null) {
                    foreach ($this->collFoldersRelatedByFolderId as $referrerFK) {
                        if (!$referrerFK->validate($columns)) {
                            $failureMap = array_merge($failureMap, $referrerFK->getValidationFailures());
                        }
                    }
                }


            $this->alreadyInValidation = false;
        }

        return (!empty($failureMap) ? $failureMap : true);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *               one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *               BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *               Defaults to BasePeer::TYPE_PHPNAME
     * @return mixed Value of field.
     */
    public function getByName($name, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = FolderPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getFolderId();
                break;
            case 1:
                return $this->getParentId();
                break;
            case 2:
                return $this->getFolderName();
                break;
            case 3:
                return $this->getUserId();
                break;
            case 4:
                return $this->getOrgId();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     *                    BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                    Defaults to BasePeer::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to true.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = BasePeer::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {
        if (isset($alreadyDumpedObjects['Folder'][$this->getPrimaryKey()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Folder'][$this->getPrimaryKey()] = true;
        $keys = FolderPeer::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getFolderId(),
            $keys[1] => $this->getParentId(),
            $keys[2] => $this->getFolderName(),
            $keys[3] => $this->getUserId(),
            $keys[4] => $this->getOrgId(),
        );
        if ($includeForeignObjects) {
            if (null !== $this->aFolderRelatedByParentId) {
                $result['FolderRelatedByParentId'] = $this->aFolderRelatedByParentId->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aUser) {
                $result['User'] = $this->aUser->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aOrganization) {
                $result['Organization'] = $this->aOrganization->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collCharts) {
                $result['Charts'] = $this->collCharts->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collFoldersRelatedByFolderId) {
                $result['FoldersRelatedByFolderId'] = $this->collFoldersRelatedByFolderId->toArray(null, true, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name peer name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME
     *                     BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     *                     Defaults to BasePeer::TYPE_PHPNAME
     * @return void
     */
    public function setByName($name, $value, $type = BasePeer::TYPE_PHPNAME)
    {
        $pos = FolderPeer::translateFieldName($name, $type, BasePeer::TYPE_NUM);

        $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return void
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setFolderId($value);
                break;
            case 1:
                $this->setParentId($value);
                break;
            case 2:
                $this->setFolderName($value);
                break;
            case 3:
                $this->setUserId($value);
                break;
            case 4:
                $this->setOrgId($value);
                break;
        } // switch()
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants BasePeer::TYPE_PHPNAME, BasePeer::TYPE_STUDLYPHPNAME,
     * BasePeer::TYPE_COLNAME, BasePeer::TYPE_FIELDNAME, BasePeer::TYPE_NUM.
     * The default key type is the column's BasePeer::TYPE_PHPNAME
     *
     * @param array  $arr     An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = BasePeer::TYPE_PHPNAME)
    {
        $keys = FolderPeer::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) $this->setFolderId($arr[$keys[0]]);
        if (array_key_exists($keys[1], $arr)) $this->setParentId($arr[$keys[1]]);
        if (array_key_exists($keys[2], $arr)) $this->setFolderName($arr[$keys[2]]);
        if (array_key_exists($keys[3], $arr)) $this->setUserId($arr[$keys[3]]);
        if (array_key_exists($keys[4], $arr)) $this->setOrgId($arr[$keys[4]]);
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(FolderPeer::DATABASE_NAME);

        if ($this->isColumnModified(FolderPeer::FOLDER_ID)) $criteria->add(FolderPeer::FOLDER_ID, $this->folder_id);
        if ($this->isColumnModified(FolderPeer::PARENT_ID)) $criteria->add(FolderPeer::PARENT_ID, $this->parent_id);
        if ($this->isColumnModified(FolderPeer::FOLDER_NAME)) $criteria->add(FolderPeer::FOLDER_NAME, $this->folder_name);
        if ($this->isColumnModified(FolderPeer::USER_ID)) $criteria->add(FolderPeer::USER_ID, $this->user_id);
        if ($this->isColumnModified(FolderPeer::ORG_ID)) $criteria->add(FolderPeer::ORG_ID, $this->org_id);

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = new Criteria(FolderPeer::DATABASE_NAME);
        $criteria->add(FolderPeer::FOLDER_ID, $this->folder_id);

        return $criteria;
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getFolderId();
    }

    /**
     * Generic method to set the primary key (folder_id column).
     *
     * @param  int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setFolderId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {

        return null === $this->getFolderId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of Folder (or compatible) type.
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setParentId($this->getParentId());
        $copyObj->setFolderName($this->getFolderName());
        $copyObj->setUserId($this->getUserId());
        $copyObj->setOrgId($this->getOrgId());

        if ($deepCopy && !$this->startCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);
            // store object hash to prevent cycle
            $this->startCopy = true;

            foreach ($this->getCharts() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addChart($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getFoldersRelatedByFolderId() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addFolderRelatedByFolderId($relObj->copy($deepCopy));
                }
            }

            //unflag object copy
            $this->startCopy = false;
        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setFolderId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return Folder Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Returns a peer instance associated with this om.
     *
     * Since Peer classes are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     *
     * @return FolderPeer
     */
    public function getPeer()
    {
        if (self::$peer === null) {
            self::$peer = new FolderPeer();
        }

        return self::$peer;
    }

    /**
     * Declares an association between this object and a Folder object.
     *
     * @param             Folder $v
     * @return Folder The current object (for fluent API support)
     * @throws PropelException
     */
    public function setFolderRelatedByParentId(Folder $v = null)
    {
        if ($v === null) {
            $this->setParentId(NULL);
        } else {
            $this->setParentId($v->getFolderId());
        }

        $this->aFolderRelatedByParentId = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Folder object, it will not be re-added.
        if ($v !== null) {
            $v->addFolderRelatedByFolderId($this);
        }


        return $this;
    }


    /**
     * Get the associated Folder object
     *
     * @param PropelPDO $con Optional Connection object.
     * @param $doQuery Executes a query to get the object if required
     * @return Folder The associated Folder object.
     * @throws PropelException
     */
    public function getFolderRelatedByParentId(PropelPDO $con = null, $doQuery = true)
    {
        if ($this->aFolderRelatedByParentId === null && ($this->parent_id !== null) && $doQuery) {
            $this->aFolderRelatedByParentId = FolderQuery::create()->findPk($this->parent_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aFolderRelatedByParentId->addFoldersRelatedByFolderId($this);
             */
        }

        return $this->aFolderRelatedByParentId;
    }

    /**
     * Declares an association between this object and a User object.
     *
     * @param             User $v
     * @return Folder The current object (for fluent API support)
     * @throws PropelException
     */
    public function setUser(User $v = null)
    {
        if ($v === null) {
            $this->setUserId(NULL);
        } else {
            $this->setUserId($v->getId());
        }

        $this->aUser = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the User object, it will not be re-added.
        if ($v !== null) {
            $v->addFolder($this);
        }


        return $this;
    }


    /**
     * Get the associated User object
     *
     * @param PropelPDO $con Optional Connection object.
     * @param $doQuery Executes a query to get the object if required
     * @return User The associated User object.
     * @throws PropelException
     */
    public function getUser(PropelPDO $con = null, $doQuery = true)
    {
        if ($this->aUser === null && ($this->user_id !== null) && $doQuery) {
            $this->aUser = UserQuery::create()->findPk($this->user_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aUser->addFolders($this);
             */
        }

        return $this->aUser;
    }

    /**
     * Declares an association between this object and a Organization object.
     *
     * @param             Organization $v
     * @return Folder The current object (for fluent API support)
     * @throws PropelException
     */
    public function setOrganization(Organization $v = null)
    {
        if ($v === null) {
            $this->setOrgId(NULL);
        } else {
            $this->setOrgId($v->getId());
        }

        $this->aOrganization = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Organization object, it will not be re-added.
        if ($v !== null) {
            $v->addFolder($this);
        }


        return $this;
    }


    /**
     * Get the associated Organization object
     *
     * @param PropelPDO $con Optional Connection object.
     * @param $doQuery Executes a query to get the object if required
     * @return Organization The associated Organization object.
     * @throws PropelException
     */
    public function getOrganization(PropelPDO $con = null, $doQuery = true)
    {
        if ($this->aOrganization === null && (($this->org_id !== "" && $this->org_id !== null)) && $doQuery) {
            $this->aOrganization = OrganizationQuery::create()->findPk($this->org_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aOrganization->addFolders($this);
             */
        }

        return $this->aOrganization;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('Chart' == $relationName) {
            $this->initCharts();
        }
        if ('FolderRelatedByFolderId' == $relationName) {
            $this->initFoldersRelatedByFolderId();
        }
    }

    /**
     * Clears out the collCharts collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return Folder The current object (for fluent API support)
     * @see        addCharts()
     */
    public function clearCharts()
    {
        $this->collCharts = null; // important to set this to null since that means it is uninitialized
        $this->collChartsPartial = null;

        return $this;
    }

    /**
     * reset is the collCharts collection loaded partially
     *
     * @return void
     */
    public function resetPartialCharts($v = true)
    {
        $this->collChartsPartial = $v;
    }

    /**
     * Initializes the collCharts collection.
     *
     * By default this just sets the collCharts collection to an empty array (like clearcollCharts());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initCharts($overrideExisting = true)
    {
        if (null !== $this->collCharts && !$overrideExisting) {
            return;
        }
        $this->collCharts = new PropelObjectCollection();
        $this->collCharts->setModel('Chart');
    }

    /**
     * Gets an array of Chart objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Folder is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|Chart[] List of Chart objects
     * @throws PropelException
     */
    public function getCharts($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collChartsPartial && !$this->isNew();
        if (null === $this->collCharts || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collCharts) {
                // return empty collection
                $this->initCharts();
            } else {
                $collCharts = ChartQuery::create(null, $criteria)
                    ->filterByFolder($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collChartsPartial && count($collCharts)) {
                      $this->initCharts(false);

                      foreach($collCharts as $obj) {
                        if (false == $this->collCharts->contains($obj)) {
                          $this->collCharts->append($obj);
                        }
                      }

                      $this->collChartsPartial = true;
                    }

                    $collCharts->getInternalIterator()->rewind();
                    return $collCharts;
                }

                if($partial && $this->collCharts) {
                    foreach($this->collCharts as $obj) {
                        if($obj->isNew()) {
                            $collCharts[] = $obj;
                        }
                    }
                }

                $this->collCharts = $collCharts;
                $this->collChartsPartial = false;
            }
        }

        return $this->collCharts;
    }

    /**
     * Sets a collection of Chart objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $charts A Propel collection.
     * @param PropelPDO $con Optional connection object
     * @return Folder The current object (for fluent API support)
     */
    public function setCharts(PropelCollection $charts, PropelPDO $con = null)
    {
        $chartsToDelete = $this->getCharts(new Criteria(), $con)->diff($charts);

        $this->chartsScheduledForDeletion = unserialize(serialize($chartsToDelete));

        foreach ($chartsToDelete as $chartRemoved) {
            $chartRemoved->setFolder(null);
        }

        $this->collCharts = null;
        foreach ($charts as $chart) {
            $this->addChart($chart);
        }

        $this->collCharts = $charts;
        $this->collChartsPartial = false;

        return $this;
    }

    /**
     * Returns the number of related Chart objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related Chart objects.
     * @throws PropelException
     */
    public function countCharts(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collChartsPartial && !$this->isNew();
        if (null === $this->collCharts || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collCharts) {
                return 0;
            }

            if($partial && !$criteria) {
                return count($this->getCharts());
            }
            $query = ChartQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByFolder($this)
                ->count($con);
        }

        return count($this->collCharts);
    }

    /**
     * Method called to associate a Chart object to this object
     * through the Chart foreign key attribute.
     *
     * @param    Chart $l Chart
     * @return Folder The current object (for fluent API support)
     */
    public function addChart(Chart $l)
    {
        if ($this->collCharts === null) {
            $this->initCharts();
            $this->collChartsPartial = true;
        }
        if (!in_array($l, $this->collCharts->getArrayCopy(), true)) { // only add it if the **same** object is not already associated
            $this->doAddChart($l);
        }

        return $this;
    }

    /**
     * @param	Chart $chart The chart object to add.
     */
    protected function doAddChart($chart)
    {
        $this->collCharts[]= $chart;
        $chart->setFolder($this);
    }

    /**
     * @param	Chart $chart The chart object to remove.
     * @return Folder The current object (for fluent API support)
     */
    public function removeChart($chart)
    {
        if ($this->getCharts()->contains($chart)) {
            $this->collCharts->remove($this->collCharts->search($chart));
            if (null === $this->chartsScheduledForDeletion) {
                $this->chartsScheduledForDeletion = clone $this->collCharts;
                $this->chartsScheduledForDeletion->clear();
            }
            $this->chartsScheduledForDeletion[]= $chart;
            $chart->setFolder(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Folder is new, it will return
     * an empty collection; or if this Folder has previously
     * been saved, it will retrieve related Charts from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Folder.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Chart[] List of Chart objects
     */
    public function getChartsJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ChartQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getCharts($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Folder is new, it will return
     * an empty collection; or if this Folder has previously
     * been saved, it will retrieve related Charts from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Folder.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Chart[] List of Chart objects
     */
    public function getChartsJoinOrganization($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ChartQuery::create(null, $criteria);
        $query->joinWith('Organization', $join_behavior);

        return $this->getCharts($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Folder is new, it will return
     * an empty collection; or if this Folder has previously
     * been saved, it will retrieve related Charts from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Folder.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Chart[] List of Chart objects
     */
    public function getChartsJoinChartRelatedByForkedFrom($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = ChartQuery::create(null, $criteria);
        $query->joinWith('ChartRelatedByForkedFrom', $join_behavior);

        return $this->getCharts($query, $con);
    }

    /**
     * Clears out the collFoldersRelatedByFolderId collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return Folder The current object (for fluent API support)
     * @see        addFoldersRelatedByFolderId()
     */
    public function clearFoldersRelatedByFolderId()
    {
        $this->collFoldersRelatedByFolderId = null; // important to set this to null since that means it is uninitialized
        $this->collFoldersRelatedByFolderIdPartial = null;

        return $this;
    }

    /**
     * reset is the collFoldersRelatedByFolderId collection loaded partially
     *
     * @return void
     */
    public function resetPartialFoldersRelatedByFolderId($v = true)
    {
        $this->collFoldersRelatedByFolderIdPartial = $v;
    }

    /**
     * Initializes the collFoldersRelatedByFolderId collection.
     *
     * By default this just sets the collFoldersRelatedByFolderId collection to an empty array (like clearcollFoldersRelatedByFolderId());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initFoldersRelatedByFolderId($overrideExisting = true)
    {
        if (null !== $this->collFoldersRelatedByFolderId && !$overrideExisting) {
            return;
        }
        $this->collFoldersRelatedByFolderId = new PropelObjectCollection();
        $this->collFoldersRelatedByFolderId->setModel('Folder');
    }

    /**
     * Gets an array of Folder objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this Folder is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @return PropelObjectCollection|Folder[] List of Folder objects
     * @throws PropelException
     */
    public function getFoldersRelatedByFolderId($criteria = null, PropelPDO $con = null)
    {
        $partial = $this->collFoldersRelatedByFolderIdPartial && !$this->isNew();
        if (null === $this->collFoldersRelatedByFolderId || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collFoldersRelatedByFolderId) {
                // return empty collection
                $this->initFoldersRelatedByFolderId();
            } else {
                $collFoldersRelatedByFolderId = FolderQuery::create(null, $criteria)
                    ->filterByFolderRelatedByParentId($this)
                    ->find($con);
                if (null !== $criteria) {
                    if (false !== $this->collFoldersRelatedByFolderIdPartial && count($collFoldersRelatedByFolderId)) {
                      $this->initFoldersRelatedByFolderId(false);

                      foreach($collFoldersRelatedByFolderId as $obj) {
                        if (false == $this->collFoldersRelatedByFolderId->contains($obj)) {
                          $this->collFoldersRelatedByFolderId->append($obj);
                        }
                      }

                      $this->collFoldersRelatedByFolderIdPartial = true;
                    }

                    $collFoldersRelatedByFolderId->getInternalIterator()->rewind();
                    return $collFoldersRelatedByFolderId;
                }

                if($partial && $this->collFoldersRelatedByFolderId) {
                    foreach($this->collFoldersRelatedByFolderId as $obj) {
                        if($obj->isNew()) {
                            $collFoldersRelatedByFolderId[] = $obj;
                        }
                    }
                }

                $this->collFoldersRelatedByFolderId = $collFoldersRelatedByFolderId;
                $this->collFoldersRelatedByFolderIdPartial = false;
            }
        }

        return $this->collFoldersRelatedByFolderId;
    }

    /**
     * Sets a collection of FolderRelatedByFolderId objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param PropelCollection $foldersRelatedByFolderId A Propel collection.
     * @param PropelPDO $con Optional connection object
     * @return Folder The current object (for fluent API support)
     */
    public function setFoldersRelatedByFolderId(PropelCollection $foldersRelatedByFolderId, PropelPDO $con = null)
    {
        $foldersRelatedByFolderIdToDelete = $this->getFoldersRelatedByFolderId(new Criteria(), $con)->diff($foldersRelatedByFolderId);

        $this->foldersRelatedByFolderIdScheduledForDeletion = unserialize(serialize($foldersRelatedByFolderIdToDelete));

        foreach ($foldersRelatedByFolderIdToDelete as $folderRelatedByFolderIdRemoved) {
            $folderRelatedByFolderIdRemoved->setFolderRelatedByParentId(null);
        }

        $this->collFoldersRelatedByFolderId = null;
        foreach ($foldersRelatedByFolderId as $folderRelatedByFolderId) {
            $this->addFolderRelatedByFolderId($folderRelatedByFolderId);
        }

        $this->collFoldersRelatedByFolderId = $foldersRelatedByFolderId;
        $this->collFoldersRelatedByFolderIdPartial = false;

        return $this;
    }

    /**
     * Returns the number of related Folder objects.
     *
     * @param Criteria $criteria
     * @param boolean $distinct
     * @param PropelPDO $con
     * @return int             Count of related Folder objects.
     * @throws PropelException
     */
    public function countFoldersRelatedByFolderId(Criteria $criteria = null, $distinct = false, PropelPDO $con = null)
    {
        $partial = $this->collFoldersRelatedByFolderIdPartial && !$this->isNew();
        if (null === $this->collFoldersRelatedByFolderId || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collFoldersRelatedByFolderId) {
                return 0;
            }

            if($partial && !$criteria) {
                return count($this->getFoldersRelatedByFolderId());
            }
            $query = FolderQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByFolderRelatedByParentId($this)
                ->count($con);
        }

        return count($this->collFoldersRelatedByFolderId);
    }

    /**
     * Method called to associate a Folder object to this object
     * through the Folder foreign key attribute.
     *
     * @param    Folder $l Folder
     * @return Folder The current object (for fluent API support)
     */
    public function addFolderRelatedByFolderId(Folder $l)
    {
        if ($this->collFoldersRelatedByFolderId === null) {
            $this->initFoldersRelatedByFolderId();
            $this->collFoldersRelatedByFolderIdPartial = true;
        }
        if (!in_array($l, $this->collFoldersRelatedByFolderId->getArrayCopy(), true)) { // only add it if the **same** object is not already associated
            $this->doAddFolderRelatedByFolderId($l);
        }

        return $this;
    }

    /**
     * @param	FolderRelatedByFolderId $folderRelatedByFolderId The folderRelatedByFolderId object to add.
     */
    protected function doAddFolderRelatedByFolderId($folderRelatedByFolderId)
    {
        $this->collFoldersRelatedByFolderId[]= $folderRelatedByFolderId;
        $folderRelatedByFolderId->setFolderRelatedByParentId($this);
    }

    /**
     * @param	FolderRelatedByFolderId $folderRelatedByFolderId The folderRelatedByFolderId object to remove.
     * @return Folder The current object (for fluent API support)
     */
    public function removeFolderRelatedByFolderId($folderRelatedByFolderId)
    {
        if ($this->getFoldersRelatedByFolderId()->contains($folderRelatedByFolderId)) {
            $this->collFoldersRelatedByFolderId->remove($this->collFoldersRelatedByFolderId->search($folderRelatedByFolderId));
            if (null === $this->foldersRelatedByFolderIdScheduledForDeletion) {
                $this->foldersRelatedByFolderIdScheduledForDeletion = clone $this->collFoldersRelatedByFolderId;
                $this->foldersRelatedByFolderIdScheduledForDeletion->clear();
            }
            $this->foldersRelatedByFolderIdScheduledForDeletion[]= $folderRelatedByFolderId;
            $folderRelatedByFolderId->setFolderRelatedByParentId(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Folder is new, it will return
     * an empty collection; or if this Folder has previously
     * been saved, it will retrieve related FoldersRelatedByFolderId from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Folder.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Folder[] List of Folder objects
     */
    public function getFoldersRelatedByFolderIdJoinUser($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = FolderQuery::create(null, $criteria);
        $query->joinWith('User', $join_behavior);

        return $this->getFoldersRelatedByFolderId($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Folder is new, it will return
     * an empty collection; or if this Folder has previously
     * been saved, it will retrieve related FoldersRelatedByFolderId from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Folder.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param PropelPDO $con optional connection object
     * @param string $join_behavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return PropelObjectCollection|Folder[] List of Folder objects
     */
    public function getFoldersRelatedByFolderIdJoinOrganization($criteria = null, $con = null, $join_behavior = Criteria::LEFT_JOIN)
    {
        $query = FolderQuery::create(null, $criteria);
        $query->joinWith('Organization', $join_behavior);

        return $this->getFoldersRelatedByFolderId($query, $con);
    }

    /**
     * Clears the current object and sets all attributes to their default values
     */
    public function clear()
    {
        $this->folder_id = null;
        $this->parent_id = null;
        $this->folder_name = null;
        $this->user_id = null;
        $this->org_id = null;
        $this->alreadyInSave = false;
        $this->alreadyInValidation = false;
        $this->alreadyInClearAllReferencesDeep = false;
        $this->clearAllReferences();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references to other model objects or collections of model objects.
     *
     * This method is a user-space workaround for PHP's inability to garbage collect
     * objects with circular references (even in PHP 5.3). This is currently necessary
     * when using Propel in certain daemon or large-volumne/high-memory operations.
     *
     * @param boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep && !$this->alreadyInClearAllReferencesDeep) {
            $this->alreadyInClearAllReferencesDeep = true;
            if ($this->collCharts) {
                foreach ($this->collCharts as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collFoldersRelatedByFolderId) {
                foreach ($this->collFoldersRelatedByFolderId as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->aFolderRelatedByParentId instanceof Persistent) {
              $this->aFolderRelatedByParentId->clearAllReferences($deep);
            }
            if ($this->aUser instanceof Persistent) {
              $this->aUser->clearAllReferences($deep);
            }
            if ($this->aOrganization instanceof Persistent) {
              $this->aOrganization->clearAllReferences($deep);
            }

            $this->alreadyInClearAllReferencesDeep = false;
        } // if ($deep)

        if ($this->collCharts instanceof PropelCollection) {
            $this->collCharts->clearIterator();
        }
        $this->collCharts = null;
        if ($this->collFoldersRelatedByFolderId instanceof PropelCollection) {
            $this->collFoldersRelatedByFolderId->clearIterator();
        }
        $this->collFoldersRelatedByFolderId = null;
        $this->aFolderRelatedByParentId = null;
        $this->aUser = null;
        $this->aOrganization = null;
    }

    /**
     * return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(FolderPeer::DEFAULT_STRING_FORMAT);
    }

    /**
     * return true is the object is in saving state
     *
     * @return boolean
     */
    public function isAlreadyInSave()
    {
        return $this->alreadyInSave;
    }

}
