We're proud to announce the new feature release of darktable, 5.2.0!

The github release is here: [https://github.com/darktable-org/darktable/releases/tag/release-5.2.0](https://github.com/darktable-org/darktable/releases/tag/release-5.2.0).

To build from source, do not use the autogenerated tarball provided by GitHub on the release page, download our tar.xz file instead. If you're just building for yourself without creating a package for some distribution, then using source code cloning in git is an even more convenient way.

The checksums are:

```
$ sha256sum darktable-5.2.0.tar.xz
??? darktable-5.2.0.tar.xz

$ sha256sum darktable-5.2.0-x86_64.dmg
??? darktable-5.2.0-x86_64.dmg

$ sha256sum darktable-5.2.0-arm64.dmg
??? darktable-5.2.0-arm64.dmg

$ sha256sum darktable-5.2.0-arm64-13.5.dmg
??? darktable-5.2.0-arm64-13.5.dmg

$ sha256sum darktable-5.2.0-win64.exe
??? darktable-5.2.0-win64.exe

$ sha256sum darktable-4.8.1-x86_64.AppImage
???  darktable-5.2.0-x86_64.AppImage
```

When updating from the stable 5.0 series, please bear in mind that your edits will be preserved during this process, but the new library and configuration will no longer be usable with 5.0.

You are strongly advised to take a backup first.

#### Important note: to make sure that darktable can keep on supporting the raw file format for your camera, *please* read [this post](https://discuss.pixls.us/t/raw-samples-wanted/5420?u=lebedevri) on how/what raw samples you can contribute to ensure that we have the *full* raw sample set for your camera under CC0 license!

Since darktable 5.0:

- 1099 commits to darktable+rawspeed
- 386 pull requests handled
- 49 issues closed

_Please note that the darktable documentation is not currently complete for release 5.2
and contributions are greatly appreciated. Please see the
[project documentation](https://github.com/darktable-org/dtdocs#contributing)
for more information on how to contribute._

## The Big Ones

The following is a summary of the main features added to darktable
5.2. Please see the user manual for more details of the individual
changes (where available).

- View snapshots side-by-side with the current image, instead of as a
  partial overlay, by clicking the button next to "take snapshot". The
  center viewport is divided in two equal panels and can be zoomed and
  panned (by dragging while holding the "a" key) as before. The
  dividing line can not be moved and any click without "a" rotates the
  layout.

- The metadata module is now fully configurable and allows to add and
  maintain any tags which are supported by exiv2.

- Added a new module "raster mask import". After setting up a root
  folder containing PFM files, a file can be selected to be used as a
  raster mask, it is scaled to full image size. You can also define
  what combination of the RGB channels of that PFM file will be used
  for the raster mask.

- Sigmoid module is now the default tone-mapper selected for new
  installation.

- The export module has got a new section multi-preset export which
  allows to export the selected images with multiple presets in one
  single export run.

## UI/UX Improvements

- Replaced the zoom range widget, which controls the number of
  thumbnails displayed on the thumbnail table, with a spin
  button. This makes it easier to set the exact value.

- In the 4 ways tab in Color Balance RGB, <kbd>ctrl+click</kbd> now
  picks the actual color while regular click continues to pick the
  opposite color. This gives users more flexibility and control when
  selecting hues.


## Performance Improvements

- Eliminated unnecessary GUI refreshes.

- Improved user interface responsiveness for blending operations.

## Other Changes

- Removed the levels and contrast brightness saturation modules (which
  were deprecated in 2023) from the deprecated modules group. Since
  this group would be empty after that, it has also been removed for
  now.

- Due to an upstream issue, exporting JPEG XL in 16-bit float at
  quality 100 is not currently mathematically lossless.

- Allow reading of files in Cineon format (developed by Kodak) and DPX
  format (developed by SMPTE) with .cin and .dpx file extensions.

- The "prefer performance over quality" preference setting has been
  removed.

- A workaround for old broken AMD OpenCL drivers that has been in
  place for 12 years has been disabled by default. Hopefully more
  recent drivers don't need it anymore and it caused problems with the
  translation of the user interface during startup, causing part of it
  to appear in English.  If you have problems with OpenCL that you
  believe may be caused by this change, please do two things:

    - Add the line opencl_force_c_locale=anything to your
      ~/.config/darktable/darktablerc file.

    - If that solves your problem, please report the issue to GiHhub
      PR #18342, including information on the make of your GPU and the
      version of your drivers. We can then for the next release either
      by default re-enable the workaround for drivers that need them,
      or warn people with antiquated drivers that they need to update.

- Presets can now be arranged in sub menus, like styles can, by
  inserting | in their name between levels. The shortcuts
  dialog/preferences tab now show these collapsible hierarchies for
  styles and presets too (and the bug that style shortcuts were not
  translated is fixed).

- Give a hint for pending background work when darktable is closing.

- Improved rendering output of Denoise Profile, Dither and Astrophoto
  Denoise on second window or in high quality processing mode.

- Hide "reduce resolution of preview image" preference setting. This
  was a way to get better responsiveness on slow systems introduced in
  2020, but at the same time it was making the color picker and mask
  support inaccurate (quality loss).

- Improved quality of inpaint opposed highlight recovery algorithm for
  sRAW images.

- Reduced haze removal visible difference between exports and HQ
  darkroom processing.
  For some images the algorithm fails to calculate correction
  parameters, this is reported via control log.

- Lens info is now read from OM-System/Olympus image files taken with
  lenses without electronic data if this info is entered in the
  camera lens info settings dialog. The lens correction module will
  automatically find the lens, if it is supported by lensfun and the
  entered name matches the lensfun name, which can be seen in the lens
  selection drop down list.

- Raster masks got internal improvements and now support the same refinement
  tools as all other masks including details threshold, feathering guide and
  radius, blurring radius and contrast. Some UI refinements for raster-masks.

- The highlights module offers a raster mask with information about level above
  clip level.

- Changing orientation (via the flip module) respects changes done in
  crop module.

- The shown dimension while cropping now matches the default export
  dimension and keeps the exact chosen ratio.

- In the history module item tooltip, fixed the formatting and scaling
  of the changes to match the values as seen in the modules
  themselves.

- Added auto login to the piwigo export module. This can be enabled in
  the security section of the preferences.

- Add 45x35 aspect ratio to the crop module, which is popular on IDs
  and passports.

- Color assessment conditions: Changed total border width to relative
  scaling which should work well on small and big screens, independent
  of physical screen resolution, added pop-up window for
  parameterization and removed ISO12464 reference.

- Attach export ICC profile to JP2 images.

- Improved visibility of masks in darkroom. This is controlled by the
  new hidden "darkroom/ui/develop_mask_mix" configuration option.

- Add a new setting to change which images are taken into account for
  actions: By default, the image under the cursor takes priority. With
  this parameter enabled, the selected images will take priority, and
  the image under the cursor will only be taken into account to feed
  the information modules.

- Added a tag icon on thumbnails to display the list of attached tags
  when hovering over it.

- In the map view, it is possible to pan the entire track in one of
  the following ways: by double-clicking on the track segment list, by
  left-clicking on the list header, or by shortcut option.

## Bug Fixes

- Fixed sidecar writing if quitting from darkroom.

- Fixed some rare race conditions while processing the pixelpipes.

- Fixed collection filter presets based on capture time creating an
  empty widget.

- Proper high quality demosaicing and details blending support for
  second window.

- Fixed a bug that allowed NULL pointer dereference in tethering mode
  under certain conditions, which resulted in a crash.

- Fixed darktable shutdown code so pending background jobs are properly finished
  and give a control log if there is pending work.

- Fixed a crash in the import dialog when trying to add a new place to
  an empty places list.

- Fixed bit-depth setting not saved in AVIF export presets.

- Fixed reset button not working in the geotagging module. Also a
  loaded GPX track in the geotagging module is now properly removed.

- Fixed darktable-cli crashing if the darktable database is locked.

- Fixed image not properly layout in the print module after being
  rotated from Lighttable.

- Fixed a bug where the changes in various edit fields are not saved
  correctly when the field loses the input focus.

- Fixed incorrect reporting of whether a flash was fired in expansion
  variables $(EXIF.FLASH.ICON) and $(EXIF.FLASH) under certain
  conditions.

- Fixed the edit style dialog to show all module's duplicates. Also,
  when creating a new style we don't show the whole history but only
  the last version of each module.

- Fixed a bug in xtrans demosaicers that could feed NaNs into the
  pixelpipe.

- Fixed display of image using a composite module when the modules are
  reordered.

## Lua

### API Version

- API version is now 9.5.0

### New Features

- Added apply_sidecar to dt_lua_image_t so that a sidecar file can be loaded
  and applied to an image in lighttable.

### Bug Fixes

- Expanded width of preference boxes Lua Options so that long input is visible.

- N/A

### Add action support for Lua

### Other Lua changes

- N/A

## Notes

- When exporting to AVIF, EXR, JPEG XL, or XCF, selecting specific
  metadata (e.g. geo-tag or creator) is not currently possible. For
  AVIF, EXR, JPEG XL, and XCF formats, darktable will not include any
  metadata fields unless the user selects all of the checkboxes in the
  export module's preference options.

- Starting with release 4.8, macOS versions older than 13.5 are not
  supported.

## Changed Dependencies

### Mandatory

- N/A

### Optional

- n/a

## RawSpeed changes

- OM System 14-bit high-resolution ORFs are now supported.
- Canon EOS 5D Mark II crop was updated.
- Fujifilm FinePix X100 crop was updated.
- Samsung EX1 crop and white level were updated.
- Sony ILCE-1M2 color matrix was updated.

## Camera support, compared to 5.0

### Base Support

- Canon EOS R5 C (requires LibRaw 202502 and later)
- Fujifilm GFX100RF (compressed)
- Fujifilm GFX100S II (compressed)
- Nikon 1 J5
- Nikon 1 V3
- Nikon COOLPIX P1100 (12bit-uncompressed)
- Nikon Coolpix P340
- Nikon D100
- Nikon D200
- Nikon D2Hs
- Nikon D2X
- Nikon D3300
- Nikon D3X
- Nikon D40
- Nikon D40X
- Nikon D5
- Nikon D5000
- Nikon D5300
- Nikon D5500
- Nikon D5600
- Nikon D60
- Nikon D80
- Nikon D800
- Nikon D800E
- Nikon D90
- Nikon Z5_2 (14bit-compressed)
- OM System OM-3
- Olympus SP510UZ
- Panasonic DC-G97 (4:3)
- Panasonic DC-G9M2 (4:3)
- Panasonic DC-GH6 (4:3)
- Panasonic DC-S1RM2 (3:2)
- Panasonic DC-S5M2 (3:2)
- Panasonic DC-S5M2X (3:2)
- Panasonic DC-S9 (3:2)
- Panasonic DC-TZ99 (4:3)
- Panasonic DC-ZS99 (4:3)
- Phase One IQ150
- Phase One P40+
- Samsung GX20
- Sigma BF (DNG)
- Sigma DP1 (DNG)
- Sigma DP1 Merrill (DNG)
- Sinar Hy6 (DNG)
- Sony DSC-RX100M7A
- Sony ILCE-6100A
- Sony ILCE-6400A
- Sony ILME-FX3A
- Sony ZV-1A
- Sony ZV-E10M2

### White Balance Presets

- Fujifilm GFX100 II
- OM System OM-3
- Panasonic DC-S9

### Noise Profiles

- Fujifilm GFX 100
- Leica SL2
- OM System OM-3
- Panasonic DC-S1RM2
- Panasonic DC-S9
- Sony ILCE-1M2

### Missing Compression Mode Support

- Apple ProRAW DNGs
- CinemaDNG lossless (Blackmagic, some DJI, etc.) and lossy (Blackmagic)
- DNG 1.7 using JPEG XL (Adobe enhanced, Samsung Expert RAW)
- Fujifilm lossy RAFs
- Nikon high efficiency NEFs
- Phase One other than IIQ L
- Sony downsized lossless ARWs ("M" for full-frame, "S" for full-frame & APS-C)

### Suspended Support

Support for the following cameras is suspended because no samples are available on https://raw.pixls.us:

- Creo/Leaf Aptus 22(LF3779)/Hasselblad H1
- Fujifilm IS-1
- Kodak EasyShare Z980
- Leaf Aptus-II 5(LI300059)/Mamiya 645 AFD
- Leaf Credo 60
- Leaf Credo 80
- Olympus SP320
- Phase One IQ250
- ST Micro STV680

## Translations

- ???
