We're proud to announce the new feature release of darktable, 5.4.0!

The github release is here: [https://github.com/darktable-org/darktable/releases/tag/release-5.4.0](https://github.com/darktable-org/darktable/releases/tag/release-5.4.0).

To build from source, do not use the autogenerated tarball provided by GitHub on the release page, download our tar.xz file instead. If you're just building for yourself without creating a package for some distribution, then using source code cloning in git is an even more convenient way.

The checksums are:

```
$ sha256sum darktable-5.4.0.tar.xz
??? darktable-5.4.0.tar.xz

$ sha256sum darktable-5.4.0-x86_64.dmg
??? darktable-5.4.0-x86_64.dmg

$ sha256sum darktable-5.4.0-arm64.dmg
??? darktable-5.4.0-arm64.dmg

$ sha256sum darktable-5.4.0-arm64-13.5.dmg
??? darktable-5.4.0-arm64-13.5.dmg

$ sha256sum darktable-5.4.0-win64.exe
??? darktable-5.4.0-win64.exe

$ sha256sum darktable-5.4.0-x86_64.AppImage
???  darktable-5.4.0-x86_64.AppImage
```

When updating from the stable 5.2 series, please bear in mind that your edits will be preserved during this process, but the new library and configuration will no longer be usable with 5.2.

You are strongly advised to take a backup first.

#### Important note: to make sure that darktable can keep on supporting the raw file format for your camera, *please* read [this post](https://discuss.pixls.us/t/raw-samples-wanted/5420?u=lebedevri) on how/what raw samples you can contribute to ensure that we have the *full* raw sample set for your camera under CC0 license!

Since darktable 5.2:

- 995 commits to darktable+rawspeed
- 385 pull requests handled
-  56 issues closed

_Please note that the darktable documentation is not currently complete for release 5.4
and contributions are greatly appreciated. Please see the
[project documentation](https://github.com/darktable-org/dtdocs#contributing)
for more information on how to contribute._

## The Big Ones

The following is a summary of the main features added to darktable
5.4. Please see the user manual for more details of the individual
changes (where available).

- A new section Capture Sharpening is added into the demosaic
  module. The capture sharpening tries to recover details lost due to
  in-camera blurring, which can be caused by diffraction, the
  anti-aliasing filter or other sources of Gaussian-type blur.

- Added a new tone mapper implementation based on Blender's AgX
  display transform. The new module's color output is similar to that
  of Sigmoid, but the provided set of controls is more extensive. It
  allows for setting exposure white and black points explicitly,
  similar to Filmic RGB. The implementation includes a user-adjustable
  pivot point for the tone curve, with the default set at 18%
  mid-gray. Contrast around this pivot is adjustable. Controls are
  provided to create a section of constant contrast, and independent
  sliders are available to control the contrast in shadows and
  highlights (the "toe" and "shoulder" of the curve). The resulting
  output is characterized by a gradual color desaturation in
  highlights, similar to film, and a natural-looking color
  representation in mid-tones and highlights.

- Added support for multiple workspace. When the corresponding option
  is activated on the preferences, Darktable opens a dialog when
  starting. From this dialog one can select the default workspace (the
  one created the first time and currently used by everyone by
  default) or to create a new one. Each workspace has it's own
  database and configuration file (collection, last UI defaults...).

  An in memory workspace can also be selected in the dialog. In this
  case there is no database created in disk, a configuration file is
  created though.

## UI/UX Improvements

- Many GNU/Linux distributions have dropped support for X11 leaving
  only Wayland. Darktable has received many fixes to work properly on
  Wayland including display ICC profiles. This version 5.4 should work
  on Wayland as good as it was on X11.

- Show a busy cursor when changing views. This provides immediate
  feedback when, for example, double-clicking an image in the
  lighttable instead of simply freezing the UI until the darkroom has
  finished opening.

- Added the standard "Window" menu to the application menu bar on
  macOS.

- In Tone Equalizer module move controls for mask exposure and
  contrast compensation to the advanced tab.

- In the navigation windows, the zoom dropdown is now better behaving. After a
  free zoom over the darkroom, using the scroll over the zoom level
  indicator of the navigation window, the selected zoom will be the
  closest match (above or below depending on the scroll
  direction). This is better than previous behavior where the zoom level
  was always set to "small".

- When moving around in a (zoomed) center view in the darkroom, we now
  pre-calculate a slightly larger area so that it might not always be
  necessary to immediately recalculate after further moves. The
  initial 1px mouse move is generally not final, after all. This does
  mean longer calculation times, so you can switch this off by setting
  darkroom/ui/anticipate_move in darktablerc to 1.0. If you use cursor
  keys to move around, you might want to increase it to >1.4 to
  anticipate at least one further 20% move on either side. When the
  recalculation is triggered by a module parameter change, say
  exposure increase, only the exact area shown is calculated as
  before, for optimal responsiveness.

- When applying a rotation or flip, the transformation will be immediately
  applied to the part of the image currently shown in the center view while
  waiting for a full recalc. It used to be only repositioned but not rotated
  which would lead to weird overlays for a brief period.

- The popup (that you get when right-clicking) for sliders with a 360°
  range now shows a color wheel or compass. If the slider is
  soft-limited to a smaller range (for example in rotate&perspective)
  you can toggle zooming out to the full range by
  middle-clicking. Another middle click will restore the soft range
  (and the normal fine-tuning mechanism).

- When the slider range has been zoomed out beyond soft limits, the
  now visible "extreme" areas have a slightly different color.

- To make the rotation in the wheel match the rotation effect in the
  image, most slider directions for angles have been reversed. You may
  want to add a "-1" speed to any shortcuts you have gotten used to.

- Added new default shortcut keys. These will take effect only if the
  keys do not yet have user-defined assignments.

  - <kbd>c</kbd> - toggle crop box.

  - <kbd>e</kbd> - set exposure compensation (equivalent to
    right-clicking on the exposure slider).

  - <kbd>alt-r</kbd> - set image rotation (equivalent to
    right-clicking on the rotation slider).

  - <kbd>alt-[ and alt- ]</kbd> - fine rotation adjustment.

- Different shapes for the indicator on sliders can now be selected in
  preferences/misc/interface (triangle, circle, diamond, bar).

- All toolbar buttons on the lighttable and darkroom have their
  enabled state recovered across sessions. The visibility of the
  enabled buttons has been improved to avoid confusions when
  restarting Darktable and seeing artifacts due to some tools being
  activate like Gamut check.

- Make the cursor indicating the selected thumbs more visible. It is
  now bigger and has a border to ensure better visibility on dark
  thumbs.

## Performance Improvements

- Tune performance for the Lut3D module (5% to 20% speed-up).

- Dramatically speed up first startup of a new installation when the
  library is stored on a hard drive or NAS rather than SSD.

- When zooming or panning the center view, transformations in the liquify
  module are ignored. This leads to much improved responsiveness when
  that module is active.

## Other Changes

- Allow using <kbd>Shift</kbd> modifier to select only the feather
  points on blend masks. This is sometime needed when the path point
  and the feather point are too close to each others.

- Hierarchical presets are now supported for utility modules as well
  as processing modules.

- Dual demosaicing now works also in tiling mode for possibly better
  OpenCL performance and smaller CPU memory pressure.

- Added automatic compensation of camera's hidden underexposure for
  Canon Lighting Optimizer mode, Nikon Active D-Lighting and HLG tone
  modes, Olympus Gradation mode, Pentax Dynamic Range Expansion mode,
  and Fujifilm DR200/DR400 modes. This affects both the "exposure" and
  "denoise (profiled)" modules.

- Add a RGB percent display in the color picker module.

- Allow far smaller crop area to be created (crop up to 99% of the
  image size).

- Allow the variable `$(ROLL.NAME)` to have optional levels,
  `$(ROLL.NAME[n])`, where 1 <= n <= 5, the levels follow the same
  rules as film roll, the default value `n=1`, this keep the previous
  behavior of `$(ROLL.NAME)`.

- Added optional collection of shortcut assignments using
  keyboard+mouse combinations to control image processing
  modules. Install these by clicking on the new "import extras" button
  on the Shortcuts tab under Preferences.

- Remove the "overwrite" option from the lighttable history stack
  module. This option is used when pasting history to delete the
  current history stack before pasting the new one. It is rarely used
  and was confusing people when working copying/pasting on darkroom
  from the filmstrip as this option was only visible on
  lighttable. The option has been moved into the paste parts dialog.

- Added manual chroma subsampling control for AVIF export. Users can now
  choose between auto, 4:4:4, 4:2:2, and 4:2:0 chroma subsampling modes
  independently of the quality setting, allowing better optimization of the
  quality-vs-size tradeoff for AVIF files.

- The processing modules/`<focused>` shortcuts also work if the quick
  access panel is "focused", addressing the first 20 sliders or
  dropdowns.

- If only the first rotor on a midi controller is assigned, the higher
  numbered ones automatically address increasing elements of the same
  action or subsequent actions. This allows quick (re) assignment to
  the `<focused>` action or to the mimics set up with for example the
  x-touch Lua script.

- Added the ability to calculate crop factor for Olympus cameras.

- When creating styles with multiple images selected, clicking Cancel
  button or typing <kbd>ESC</kbd> on the style dialog now ends the
  whole process instead of continuing with the next image.

## Bug Fixes

- Fixed some issues with the hierarchical styles handling in the
  styles module.

- Fixed moving additional extra audio or text sidecar files when
  an image is moved.

- Fixed module based collection restoring. After quitting darktable with a
  module based collection, the lighttable was empty after restarting it.

- Fixed some reset issues of the export module. The format and storage
  sections were not reset properly.

- Fixed corruption of sidecars during large imports of images with XMP
  sidecars.

- Fixed a bug where changing the image scaling in the export module
  influences the result of a running export job.

- Make sure we always fill the complete main darkroom canvas while
  zooming at large scales.

- When zoomed to 1600% don't ignore sub-pixel panning/dragging, which
  made it almost impossible to move around at all.

- Make sure image changed_timestamp is updated when a sidecar file
  is applied.

- Fixed drag and drop of images on the map gives wrong location
  assignment on macOS.

- Fixed auto applied presets for sraws and true monochromes.

- Fixed a bug in details threshold mask for monochrome raw files
  leading to crashes.

- Fixed an issue when positioning the main darkroom windows due to
  precision in computation. The precision is now to the pixel and
  avoid a displacement in some cases.

- Fixed issue in darktable-cli that prevented input files from being
  detected.

- Fixed out of memory issue which could kill Darktable on small
  systems when processing large images.

- Fixed toast message translation displayed when scrolling over the
  module's preset buttons.

- Fixed issue in darktable-cli that prevented input files from being
  detected.

- Fixed an issue with reading TIFF files that (incorrectly) contain
  metadata specific to the raw files they were made from.

- Fixed an issue where imported styles that didn't have a name could
  cause darktable to crash when starting.

- Fixed a bug leading to wrong colors in main darkroom window (mostly
  after using a module picker) due to bad color coeffs in colorin
  module.

- Fix support for Wayland. The UI is now working as expected and
  Darktable will handle ICC profile from colord.

- Fixed processing module naming based on the presets when the used
  preset is renamed or deleted.

- Fixed a bug in darktable-cli where exporting a duplicate version of
  an image would use the tags attached to the base version instead of
  the tags attached to it.

- Fixed a bug in darktable-cli where synonyms for tags attached to an
  image were ignored when exporting it.

- Fixed auto-applied user's presets when <kbd>Ctrl+click</kbd> on a
  processing module after restarting Dartkable.

- Fixed a bug where adding an image to a group in lighttable could
  merge multiple group together.

- Fixed a print issue which is probably happening only on macOS. When
  printing in landscape mode, the rotation of the picture is not done
  on the printer. So only a part of the image is printed at the bottom
  of the page. This issue is not fully understood at this stage and
  has only been reported twice. If you encounter this issue then you
  can set the following variable in your darktablerc to force the
  landscape CUPS option to be generated:

     plugins/print/cups/force_landscape=TRUE

- Fixed possible display of double thumbs cursor on filmstrip when in
  darkroom. Also the thumbs background could look as selected on
  multiple pictures.

- Fixed darkroom processing after changing any of the colour profiles.

- For module toggle shortcuts (like enable, show and focus) the "on" and
  "off" effects are now respected (they dont simply always toggle
  anymore, like they did before).

- Fix too strict restriction for filename length in watermark module.

## Lua

### API Version

- API version is now 9.6.0

### New Features

- Added darktable.query_event() to check if an event is registered.

- Added collection-changed event that fires when the collection changes.

- Added darktable.configuration.share_dir and darktable.configuration.data_dir
  to expose the darktable data and share directories.

### Bug Fixes

- Check added to ensure view has changed before processing GUI events
  preventing hang on start.

- return a nil value instead of throwing a Lua error if the indexed element of
  the following Lua tables does not exist or if the table is empty:

  - `dt_lua_tag_t.#`

  - `dt_lua_film_t.#`

  - `dt_style_t.#`

  - `darktable.films.#`

  - `darktable.styles.#`

  - `darktable.database.#`

  - `darktable.collection.#`

- Ensure `darktable.database.get_image()` returns a nil, in all conditions,
  for an image that doesn't exist.

- Ensure translations are displayed in UTF-8 under Windows


### Add action support for Lua

### Other Lua changes

- N/A

## Notes

- When exporting to AVIF, EXR, JPEG XL, or XCF, selecting specific
  metadata (e.g. geo-tag or creator) is not currently possible. For
  AVIF, EXR, JPEG XL, and XCF formats, darktable will not include any
  metadata fields unless the user selects all of the checkboxes in the
  export module's preference options.

- Starting with release 5.4, Intel Macs and macOS versions older than 14.0
  are no longer supported.

## Changed Dependencies

### Mandatory

- N/A

### Optional

- N/A

## RawSpeed changes

- Canon EOS 2000D/1500D/Rebel T7/Kiss X90 color matrix was updated.
- Nikon Z 7 color matrix was updated.
- Nikon Z5_2 color matrix was updated.
- Sony ILCE-1M2 color matrix was updated.

## Camera support, compared to 5.2

### Base Support

- Canon EOS R1 (requires LibRaw 0.22-PreRC1 and later)
- Canon EOS R5 Mark II (requires LibRaw 0.22-PreRC1 and later)
- Canon PowerShot D10 (DNG)
- Canon PowerShot S100V
- Canon PowerShot S2 IS (DNG)
- Fujifilm FinePix HS33EXR
- Fujifilm X-E5 (compressed)
- Kodak DCS Pro SLR/c
- Kodak P712
- Leica D-Lux 8
- Leica M EV1 (DNG)
- Leica Q3 Monochrom (DNG)
- Leica X-E (Typ 102) (DNG)
- Nikon Z fc (14bit-uncompressed, 12bit-uncompressed)
- OM System OM-5 Mark II
- Olympus SP550UZ
- Olympus SP565UZ
- Panasonic DC-S1M2 (3:2)
- Panasonic DC-S1M2ES (3:2)
- Ricoh GR IV (DNG)
- Ricoh GX200 (DNG)
- Sony DSC-RX1RM3
- Sony ZV-1M2

### White Balance Presets

- Canon EOS R5 Mark II
- Nikon D2H
- Nikon Z5_2

### Noise Profiles

- Canon EOS R1
- Canon EOS R5 Mark II
- Fujifilm X-E5
- Fujifilm X-M5
- Nikon Z fc
- Sony ILCA-99M2

### Missing Compression Mode Support

- Apple ProRAW DNGs
- CinemaDNG lossless (Blackmagic, some DJI, etc.) and lossy (Blackmagic)
- DNG 1.7 using JPEG XL (Adobe enhanced, Samsung Expert RAW)
- Fujifilm lossy RAFs
- Nikon high efficiency NEFs
- Phase One other than IIQ L
- Sony ARW 4.0/5.0 downsized lossless ("M" for full-frame, "S" for full-frame & APS-C) and ARW 6.0 lossy

### Suspended Support

Support for the following cameras is suspended because no samples are available on https://raw.pixls.us:

- Creo/Leaf Aptus 22(LF3779)/Hasselblad H1
- Fujifilm IS-1
- Kodak EasyShare Z980
- Leaf Aptus-II 5(LI300059)/Mamiya 645 AFD
- Leaf Credo 60
- Leaf Credo 80
- Olympus SP320
- Phase One IQ250
- ST Micro STV680

## Translations

- ???
