# Contributing
Contributions of all types are welcome. We use GitHub as our bug and feature tracker both for code and for other
aspects of the library (documentation, the wiki etc.)

## Asking Questions
The best way to ask general questions is to send an email to our [mailing list][2], or join [#glide-library on
freenode.org.][3]

## Filing issues
To file an issue, please use our [issue template link][1] and fill out the template as much as possible. The more
information you can provide, the more likely we are to be able help.

When in doubt, file an issue. We'd rather close a few duplicate issues than let a problem go unnoticed. Similarly if
you support a particular feature request, feel free to let us know by commenting on the issue.

## Contributing code
Pull requests are welcome for all parts of the codebase, especially the integration libraries. You can find
instructions on building the project in our README. Our code style is defined in Intellij project files in the repo
and also by our Checkstyle config. If you'd like to submit code, but can't get the style checks to pass, feel
free to put up your pull request anyway and we can help you fix the style issues. If you'd like to
contribute code, you will need to sign [Google's individual contributor license agreement][4].

[1]: https://github.com/bumptech/glide/issues/new?body=**Glide%20Version/Integration%20library%20(if%20any)**:%0A**Device/Android%20Version**:%0A**Issue%20details/Repro%20steps**:%0A%0A**Glide%20load%20line**:%0A```%0AGlide.with(context)...%3B%0A```%0A%0A**Stack%20trace**:%0A```%0Apaste%20stack%20trace%20here%0A```
[2]: https://groups.google.com/forum/#!forum/glidelibrary
[3]: http://webchat.freenode.net/?channels=glide-library
[4]: https://developers.google.com/open-source/cla/individual.
