package com.bumptech.glide.load.engine.cache;

import com.bumptech.glide.load.Key;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;

/**
 * A {@link com.bumptech.glide.load.Key} that wraps a single {@link java.lang.String}.
 */
public class StringKey implements Key {
    private String key;

    public StringKey(String key) {
        this.key = key;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        StringKey stringKey = (StringKey) o;

        if (!key.equals(stringKey.key)) {
            return false;
        }

        return true;
    }

    @Override
    public int hashCode() {
        return key.hashCode();
    }

    @Override
    public String toString() {
        return key;
    }

    @Override
    public void updateDiskCacheKey(MessageDigest messageDigest) throws UnsupportedEncodingException {
        messageDigest.update(key.getBytes("UTF-8"));
    }
}
