import classnames from 'classnames'
import useTranslation from 'next-translate/useTranslation'
import React from 'react'
import { Emojis } from '~/interfaces'

const emojiCSS: Emojis = {
  /* anywhere out there */
  coffee: 'em-coffee',
  'flag-ar': 'em-flag-ar',
  earth_americas: 'em-earth_americas',
  us: 'em-us',
  /* room code */
  deciduous_tree: 'em-deciduous_tree',
  snail: 'em-snail',
  game_die: 'em-game_die',
  tornado: 'em-tornado',
  airplane: 'em-airplane',
  rainbow: 'em-rainbow',
  basketball: 'em-basketball',
  volcano: 'em-volcano',
  banana: 'em-banana',
  /* in the last numbers section */
  sweat_drops: 'em-sweat_drops',
  boy: 'em-boy',
  pray: 'em-pray',
  bed: 'em-bed',
  cat: 'em-cat',
  dog: 'em-dog',
  gun: 'em-gun',
  fire: 'em-fire',
  ocean: 'em-ocean',
  glass_of_milk: 'em-glass_of_milk',
  chopsticks: 'em-chopsticks',
  'male-guard': 'em-male-guard',
  cold_face: 'em-cold_face',
  beers: 'em-beers',
  girl: 'em-girl',
  ring: 'em-ring',
  'man-facepalming': 'em-man-facepalming',
  syringe: 'em-syringe',
  fish: 'em-fish',
  partying_face: 'em-partying_face',
  woman: 'em-woman',
  smirk: 'em-smirk',
  butterfly: 'em-butterfly',
  horse: 'em-horse',
  chicken: 'em-chicken',
  church: 'em-church',
  'man-getting-haircut': 'em-man-getting-haircut',
  mountain: 'em-mountain',
  rain_cloud: 'em-rain_cloud',
  bulb: 'em-bulb',
  moneybag: 'em-moneybag',
  exploding_head: 'em-exploding_head',
  bird: 'em-bird',
  bread: 'em-bread',
  tooth: 'em-tooth',
  oil_drum: 'em-oil_drum',
  thunder_cloud_and_rain: 'em-thunder_cloud_and_rain',
  hocho: 'em-hocho',
  athletic_shoe: 'em-athletic_shoe',
  frame_with_picture: 'em-frame_with_picture',
  x: 'em-x',
  wine_glass: 'em-wine_glass',
  tomato: 'em-tomato',
  zombie: 'em-zombie',
  male_zombie: 'em-male_zombie',
  cut_of_meat: 'em-cut_of_meat',
  baguette_bread: 'em-baguette_bread',
  toolbox: 'em-toolbox',
  pregnant_woman: 'em-pregnant_woman',
  ship: 'em-ship',
  cow: 'em-cow',
  es: 'em-es',
  hole: 'em-hole',
  dromedary_camel: 'em-dromedary_camel',
  ambulance: 'em-ambulance',
  cactus: 'em-cactus',
  angel: 'em-angel',
  couple_with_heart: 'em-couple_with_heart',
  sob: 'em-sob',
  bow_and_arrow: 'em-bow_and_arrow',
  bug: 'em-bug',
  snake: 'em-snake',
  'man-boy': 'em-man-boy',
  pill: 'em-pill',
  female_zombie: 'em-female_zombie',
  hankey: 'em-hankey',
  gift: 'em-gift',
  hospital: 'em-hospital',
  '8ball': 'em-8ball',
  clown_face: 'em-clown_face',
  llama: 'em-llama',
  leg: 'em-leg',
  lips: 'em-lips',
  chains: 'em-chains',
  soccer: 'em-soccer',
  bouquet: 'em-bouquet',
  boxing_glove: 'em-boxing_glove',
  cloud: 'em-cloud',
  flashlight: 'em-flashlight',
  wind_blowing_face: 'em-wind_blowing_face',
  guitar: 'em-guitar',
  potato: 'em-potato',
  rat: 'em-rat',
  scream: 'em-scream',
}

const emojiLabel: Emojis = {
  /* anywhere out there */
  coffee: 'common:coffee',
  'flag-ar': 'playerId:flag-ar',
  earth_americas: 'playerId:world',
  us: 'playerId:flag-us',
  /* room code */
  deciduous_tree: 'playerId:deciduous_tree',
  snail: 'playerId:snail',
  game_die: 'playerId:game_die',
  tornado: 'playerId:tornado',
  airplane: 'playerId:airplane',
  rainbow: 'playerId:rainbow',
  basketball: 'playerId:basketball',
  volcano: 'playerId:volcano',
  banana: 'playerId:banana',
  /* in the last numbers section */
  sweat_drops: 'playerId:dreams.1',
  boy: 'playerId:dreams.2',
  pray: 'playerId:dreams.3',
  bed: 'playerId:dreams.4',
  cat: 'playerId:dreams.5',
  dog: 'playerId:dreams.6',
  gun: 'playerId:dreams.7',
  fire: 'playerId:dreams.8',
  ocean: 'playerId:dreams.9',
  glass_of_milk: 'playerId:dreams.10',
  chopsticks: 'playerId:dreams.11',
  'male-guard': 'playerId:dreams.12',
  cold_face: 'playerId:dreams.13',
  beers: 'playerId:dreams.14',
  girl: 'playerId:dreams.15',
  ring: 'playerId:dreams.16',
  'man-facepalming': 'playerId:dreams.17',
  syringe: 'playerId:dreams.18',
  fish: 'playerId:dreams.19',
  partying_face: 'playerId:dreams.20',
  woman: 'playerId:dreams.21',
  smirk: 'playerId:dreams.22',
  butterfly: 'playerId:dreams.23',
  horse: 'playerId:dreams.24',
  chicken: 'playerId:dreams.25',
  church: 'playerId:dreams.26',
  'man-getting-haircut': 'playerId:dreams.27',
  mountain: 'playerId:dreams.28',
  rain_cloud: 'playerId:dreams.30',
  bulb: 'playerId:dreams.31',
  moneybag: 'playerId:dreams.32',
  exploding_head: 'playerId:dreams.34',
  bird: 'playerId:dreams.35',
  bread: 'playerId:dreams.36',
  tooth: 'playerId:dreams.37',
  oil_drum: 'playerId:dreams.38',
  thunder_cloud_and_rain: 'playerId:dreams.39',
  hocho: 'playerId:dreams.41',
  athletic_shoe: 'playerId:dreams.42',
  frame_with_picture: 'playerId:dreams.43',
  x: 'playerId:dreams.44',
  wine_glass: 'playerId:dreams.45',
  tomato: 'playerId:dreams.46',
  zombie: 'playerId:dreams.47',
  male_zombie: 'playerId:dreams.48',
  cut_of_meat: 'playerId:dreams.49',
  baguette_bread: 'playerId:dreams.50',
  toolbox: 'playerId:dreams.51',
  pregnant_woman: 'playerId:dreams.52',
  ship: 'playerId:dreams.53',
  cow: 'playerId:dreams.54',
  es: 'playerId:dreams.55',
  hole: 'playerId:dreams.56',
  dromedary_camel: 'playerId:dreams.57',
  ambulance: 'playerId:dreams.58',
  cactus: 'playerId:dreams.59',
  angel: 'playerId:dreams.60',
  couple_with_heart: 'playerId:dreams.63',
  sob: 'playerId:dreams.64',
  bow_and_arrow: 'playerId:dreams.65',
  bug: 'playerId:dreams.66',
  snake: 'playerId:dreams.67',
  'man-boy': 'playerId:dreams.68',
  pill: 'playerId:dreams.69',
  female_zombie: 'playerId:dreams.70',
  hankey: 'playerId:dreams.71',
  gift: 'playerId:dreams.72',
  hospital: 'playerId:dreams.73',
  '8ball': 'playerId:dreams.74',
  clown_face: 'playerId:dreams.75',
  llama: 'playerId:dreams.76',
  leg: 'playerId:dreams.77',
  lips: 'playerId:dreams.78',
  chains: 'playerId:dreams.79',
  soccer: 'playerId:dreams.80',
  bouquet: 'playerId:dreams.81',
  boxing_glove: 'playerId:dreams.82',
  cloud: 'playerId:dreams.83',
  flashlight: 'playerId:dreams.85',
  wind_blowing_face: 'playerId:dreams.86',
  guitar: 'playerId:dreams.87',
  potato: 'playerId:dreams.88',
  rat: 'playerId:dreams.89',
  scream: 'playerId:dreams.90',
}

interface Props {
  name: keyof Emojis
}

export default function Emoji({ name }: Props) {
  const { t } = useTranslation()

  return (
    <i
      className={classnames(['em outline-none', emojiCSS[name]])}
      tabIndex={-1}
      aria-label={t(emojiLabel[name])}
    ></i>
  )
}
