// Code generated by applyconfiguration-gen. DO NOT EDIT.

package internal

import (
	"fmt"
	"sync"

	typed "sigs.k8s.io/structured-merge-diff/v4/typed"
)

func Parser() *typed.Parser {
	parserOnce.Do(func() {
		var err error
		parser, err = typed.NewParser(schemaYAML)
		if err != nil {
			panic(fmt.Sprintf("Failed to parse schema: %v", err))
		}
	})
	return parser
}

var parserOnce sync.Once
var parser *typed.Parser
var schemaYAML = typed.YAMLObject(`types:
- name: com.github.openshift.api.config.v1.APIServer
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.APIServerSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.APIServerStatus
      default: {}
- name: com.github.openshift.api.config.v1.APIServerEncryption
  map:
    fields:
    - name: type
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.APIServerNamedServingCert
  map:
    fields:
    - name: names
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: servingCertificate
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
- name: com.github.openshift.api.config.v1.APIServerServingCerts
  map:
    fields:
    - name: namedCertificates
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.APIServerNamedServingCert
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.APIServerSpec
  map:
    fields:
    - name: additionalCORSAllowedOrigins
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: audit
      type:
        namedType: com.github.openshift.api.config.v1.Audit
      default: {}
    - name: clientCA
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: encryption
      type:
        namedType: com.github.openshift.api.config.v1.APIServerEncryption
      default: {}
    - name: servingCerts
      type:
        namedType: com.github.openshift.api.config.v1.APIServerServingCerts
      default: {}
    - name: tlsSecurityProfile
      type:
        namedType: com.github.openshift.api.config.v1.TLSSecurityProfile
- name: com.github.openshift.api.config.v1.APIServerStatus
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.AWSIngressSpec
  map:
    fields:
    - name: type
      type:
        scalar: string
    unions:
    - discriminator: type
- name: com.github.openshift.api.config.v1.AWSPlatformSpec
  map:
    fields:
    - name: serviceEndpoints
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.AWSServiceEndpoint
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.AWSPlatformStatus
  map:
    fields:
    - name: region
      type:
        scalar: string
      default: ""
    - name: resourceTags
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.AWSResourceTag
          elementRelationship: atomic
    - name: serviceEndpoints
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.AWSServiceEndpoint
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.AWSResourceTag
  map:
    fields:
    - name: key
      type:
        scalar: string
      default: ""
    - name: value
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.AWSServiceEndpoint
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
    - name: url
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.AlibabaCloudPlatformSpec
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.AlibabaCloudPlatformStatus
  map:
    fields:
    - name: region
      type:
        scalar: string
      default: ""
    - name: resourceGroupID
      type:
        scalar: string
    - name: resourceTags
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.AlibabaCloudResourceTag
          elementRelationship: associative
          keys:
          - key
- name: com.github.openshift.api.config.v1.AlibabaCloudResourceTag
  map:
    fields:
    - name: key
      type:
        scalar: string
      default: ""
    - name: value
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.Audit
  map:
    fields:
    - name: customRules
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.AuditCustomRule
          elementRelationship: associative
          keys:
          - group
    - name: profile
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.AuditCustomRule
  map:
    fields:
    - name: group
      type:
        scalar: string
      default: ""
    - name: profile
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.Authentication
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.AuthenticationSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.AuthenticationStatus
      default: {}
- name: com.github.openshift.api.config.v1.AuthenticationSpec
  map:
    fields:
    - name: oauthMetadata
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: serviceAccountIssuer
      type:
        scalar: string
      default: ""
    - name: type
      type:
        scalar: string
      default: ""
    - name: webhookTokenAuthenticator
      type:
        namedType: com.github.openshift.api.config.v1.WebhookTokenAuthenticator
    - name: webhookTokenAuthenticators
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.DeprecatedWebhookTokenAuthenticator
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.AuthenticationStatus
  map:
    fields:
    - name: integratedOAuthMetadata
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
- name: com.github.openshift.api.config.v1.AzurePlatformSpec
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.AzurePlatformStatus
  map:
    fields:
    - name: armEndpoint
      type:
        scalar: string
    - name: cloudName
      type:
        scalar: string
    - name: networkResourceGroupName
      type:
        scalar: string
    - name: resourceGroupName
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.BareMetalPlatformSpec
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.BareMetalPlatformStatus
  map:
    fields:
    - name: apiServerInternalIP
      type:
        scalar: string
    - name: apiServerInternalIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: ingressIP
      type:
        scalar: string
    - name: ingressIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: nodeDNSIP
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.BasicAuthIdentityProvider
  map:
    fields:
    - name: ca
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: tlsClientCert
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: tlsClientKey
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: url
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.Build
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.BuildSpec
      default: {}
- name: com.github.openshift.api.config.v1.BuildDefaults
  map:
    fields:
    - name: defaultProxy
      type:
        namedType: com.github.openshift.api.config.v1.ProxySpec
    - name: env
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.EnvVar
          elementRelationship: atomic
    - name: gitProxy
      type:
        namedType: com.github.openshift.api.config.v1.ProxySpec
    - name: imageLabels
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ImageLabel
          elementRelationship: atomic
    - name: resources
      type:
        namedType: io.k8s.api.core.v1.ResourceRequirements
      default: {}
- name: com.github.openshift.api.config.v1.BuildOverrides
  map:
    fields:
    - name: forcePull
      type:
        scalar: boolean
    - name: imageLabels
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ImageLabel
          elementRelationship: atomic
    - name: nodeSelector
      type:
        map:
          elementType:
            scalar: string
    - name: tolerations
      type:
        list:
          elementType:
            namedType: io.k8s.api.core.v1.Toleration
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.BuildSpec
  map:
    fields:
    - name: additionalTrustedCA
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: buildDefaults
      type:
        namedType: com.github.openshift.api.config.v1.BuildDefaults
      default: {}
    - name: buildOverrides
      type:
        namedType: com.github.openshift.api.config.v1.BuildOverrides
      default: {}
- name: com.github.openshift.api.config.v1.ClusterCondition
  map:
    fields:
    - name: promql
      type:
        namedType: com.github.openshift.api.config.v1.PromQLClusterCondition
    - name: type
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.ClusterNetworkEntry
  map:
    fields:
    - name: cidr
      type:
        scalar: string
      default: ""
    - name: hostPrefix
      type:
        scalar: numeric
- name: com.github.openshift.api.config.v1.ClusterOperator
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.ClusterOperatorSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.ClusterOperatorStatus
      default: {}
- name: com.github.openshift.api.config.v1.ClusterOperatorSpec
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.ClusterOperatorStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ClusterOperatorStatusCondition
          elementRelationship: associative
          keys:
          - type
    - name: extension
      type:
        namedType: __untyped_atomic_
      default: {}
    - name: relatedObjects
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ObjectReference
          elementRelationship: atomic
    - name: versions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.OperandVersion
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.ClusterOperatorStatusCondition
  map:
    fields:
    - name: lastTransitionTime
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
      default: {}
    - name: message
      type:
        scalar: string
    - name: reason
      type:
        scalar: string
    - name: status
      type:
        scalar: string
      default: ""
    - name: type
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.ClusterVersion
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.ClusterVersionSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.ClusterVersionStatus
      default: {}
- name: com.github.openshift.api.config.v1.ClusterVersionCapabilitiesSpec
  map:
    fields:
    - name: additionalEnabledCapabilities
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: baselineCapabilitySet
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.ClusterVersionCapabilitiesStatus
  map:
    fields:
    - name: enabledCapabilities
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: knownCapabilities
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.ClusterVersionSpec
  map:
    fields:
    - name: capabilities
      type:
        namedType: com.github.openshift.api.config.v1.ClusterVersionCapabilitiesSpec
    - name: channel
      type:
        scalar: string
    - name: clusterID
      type:
        scalar: string
      default: ""
    - name: desiredUpdate
      type:
        namedType: com.github.openshift.api.config.v1.Update
    - name: overrides
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ComponentOverride
          elementRelationship: atomic
    - name: upstream
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.ClusterVersionStatus
  map:
    fields:
    - name: availableUpdates
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.Release
          elementRelationship: atomic
    - name: capabilities
      type:
        namedType: com.github.openshift.api.config.v1.ClusterVersionCapabilitiesStatus
      default: {}
    - name: conditionalUpdates
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ConditionalUpdate
          elementRelationship: atomic
    - name: conditions
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ClusterOperatorStatusCondition
          elementRelationship: atomic
    - name: desired
      type:
        namedType: com.github.openshift.api.config.v1.Release
      default: {}
    - name: history
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.UpdateHistory
          elementRelationship: atomic
    - name: observedGeneration
      type:
        scalar: numeric
      default: 0
    - name: versionHash
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.ComponentOverride
  map:
    fields:
    - name: group
      type:
        scalar: string
      default: ""
    - name: kind
      type:
        scalar: string
      default: ""
    - name: name
      type:
        scalar: string
      default: ""
    - name: namespace
      type:
        scalar: string
      default: ""
    - name: unmanaged
      type:
        scalar: boolean
      default: false
- name: com.github.openshift.api.config.v1.ComponentRouteSpec
  map:
    fields:
    - name: hostname
      type:
        scalar: string
      default: ""
    - name: name
      type:
        scalar: string
      default: ""
    - name: namespace
      type:
        scalar: string
      default: ""
    - name: servingCertKeyPairSecret
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
- name: com.github.openshift.api.config.v1.ComponentRouteStatus
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Condition
          elementRelationship: associative
          keys:
          - type
    - name: consumingUsers
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: currentHostnames
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: defaultHostname
      type:
        scalar: string
      default: ""
    - name: name
      type:
        scalar: string
      default: ""
    - name: namespace
      type:
        scalar: string
      default: ""
    - name: relatedObjects
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ObjectReference
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.ConditionalUpdate
  map:
    fields:
    - name: conditions
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Condition
          elementRelationship: associative
          keys:
          - type
    - name: release
      type:
        namedType: com.github.openshift.api.config.v1.Release
      default: {}
    - name: risks
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ConditionalUpdateRisk
          elementRelationship: associative
          keys:
          - name
- name: com.github.openshift.api.config.v1.ConditionalUpdateRisk
  map:
    fields:
    - name: matchingRules
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ClusterCondition
          elementRelationship: atomic
    - name: message
      type:
        scalar: string
      default: ""
    - name: name
      type:
        scalar: string
      default: ""
    - name: url
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.ConfigMapFileReference
  map:
    fields:
    - name: key
      type:
        scalar: string
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.ConfigMapNameReference
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.Console
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.ConsoleSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.ConsoleStatus
      default: {}
- name: com.github.openshift.api.config.v1.ConsoleAuthentication
  map:
    fields:
    - name: logoutRedirect
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.ConsoleSpec
  map:
    fields:
    - name: authentication
      type:
        namedType: com.github.openshift.api.config.v1.ConsoleAuthentication
      default: {}
- name: com.github.openshift.api.config.v1.ConsoleStatus
  map:
    fields:
    - name: consoleURL
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.CustomFeatureGates
  map:
    fields:
    - name: disabled
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: enabled
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.CustomTLSProfile
  map:
    fields:
    - name: ciphers
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: minTLSVersion
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.DNS
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.DNSSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.DNSStatus
      default: {}
- name: com.github.openshift.api.config.v1.DNSSpec
  map:
    fields:
    - name: baseDomain
      type:
        scalar: string
      default: ""
    - name: privateZone
      type:
        namedType: com.github.openshift.api.config.v1.DNSZone
    - name: publicZone
      type:
        namedType: com.github.openshift.api.config.v1.DNSZone
- name: com.github.openshift.api.config.v1.DNSStatus
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.DNSZone
  map:
    fields:
    - name: id
      type:
        scalar: string
    - name: tags
      type:
        map:
          elementType:
            scalar: string
- name: com.github.openshift.api.config.v1.DeprecatedWebhookTokenAuthenticator
  map:
    fields:
    - name: kubeConfig
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
- name: com.github.openshift.api.config.v1.EquinixMetalPlatformSpec
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.EquinixMetalPlatformStatus
  map:
    fields:
    - name: apiServerInternalIP
      type:
        scalar: string
    - name: ingressIP
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.ExternalIPConfig
  map:
    fields:
    - name: autoAssignCIDRs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: policy
      type:
        namedType: com.github.openshift.api.config.v1.ExternalIPPolicy
- name: com.github.openshift.api.config.v1.ExternalIPPolicy
  map:
    fields:
    - name: allowedCIDRs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: rejectedCIDRs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.FeatureGate
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.FeatureGateSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.FeatureGateStatus
      default: {}
- name: com.github.openshift.api.config.v1.FeatureGateSpec
  map:
    fields:
    - name: customNoUpgrade
      type:
        namedType: com.github.openshift.api.config.v1.CustomFeatureGates
    - name: featureSet
      type:
        scalar: string
    unions:
    - discriminator: featureSet
      fields:
      - fieldName: customNoUpgrade
        discriminatorValue: CustomNoUpgrade
- name: com.github.openshift.api.config.v1.FeatureGateStatus
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.GCPPlatformSpec
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.GCPPlatformStatus
  map:
    fields:
    - name: projectID
      type:
        scalar: string
      default: ""
    - name: region
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.GitHubIdentityProvider
  map:
    fields:
    - name: ca
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: clientID
      type:
        scalar: string
      default: ""
    - name: clientSecret
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: hostname
      type:
        scalar: string
      default: ""
    - name: organizations
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: teams
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.GitLabIdentityProvider
  map:
    fields:
    - name: ca
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: clientID
      type:
        scalar: string
      default: ""
    - name: clientSecret
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: url
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.GoogleIdentityProvider
  map:
    fields:
    - name: clientID
      type:
        scalar: string
      default: ""
    - name: clientSecret
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: hostedDomain
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.HTPasswdIdentityProvider
  map:
    fields:
    - name: fileData
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
- name: com.github.openshift.api.config.v1.HubSource
  map:
    fields:
    - name: disabled
      type:
        scalar: boolean
      default: false
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.HubSourceStatus
  map:
    fields:
    - name: message
      type:
        scalar: string
    - name: status
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.IBMCloudPlatformSpec
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.IBMCloudPlatformStatus
  map:
    fields:
    - name: cisInstanceCRN
      type:
        scalar: string
    - name: dnsInstanceCRN
      type:
        scalar: string
    - name: location
      type:
        scalar: string
    - name: providerType
      type:
        scalar: string
    - name: resourceGroupName
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.IdentityProvider
  map:
    fields:
    - name: basicAuth
      type:
        namedType: com.github.openshift.api.config.v1.BasicAuthIdentityProvider
    - name: github
      type:
        namedType: com.github.openshift.api.config.v1.GitHubIdentityProvider
    - name: gitlab
      type:
        namedType: com.github.openshift.api.config.v1.GitLabIdentityProvider
    - name: google
      type:
        namedType: com.github.openshift.api.config.v1.GoogleIdentityProvider
    - name: htpasswd
      type:
        namedType: com.github.openshift.api.config.v1.HTPasswdIdentityProvider
    - name: keystone
      type:
        namedType: com.github.openshift.api.config.v1.KeystoneIdentityProvider
    - name: ldap
      type:
        namedType: com.github.openshift.api.config.v1.LDAPIdentityProvider
    - name: mappingMethod
      type:
        scalar: string
    - name: name
      type:
        scalar: string
      default: ""
    - name: openID
      type:
        namedType: com.github.openshift.api.config.v1.OpenIDIdentityProvider
    - name: requestHeader
      type:
        namedType: com.github.openshift.api.config.v1.RequestHeaderIdentityProvider
    - name: type
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.Image
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.ImageSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.ImageStatus
      default: {}
- name: com.github.openshift.api.config.v1.ImageContentPolicy
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.ImageContentPolicySpec
      default: {}
- name: com.github.openshift.api.config.v1.ImageContentPolicySpec
  map:
    fields:
    - name: repositoryDigestMirrors
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.RepositoryDigestMirrors
          elementRelationship: associative
          keys:
          - source
- name: com.github.openshift.api.config.v1.ImageDigestMirrorSet
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.ImageDigestMirrorSetSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.ImageDigestMirrorSetStatus
      default: {}
- name: com.github.openshift.api.config.v1.ImageDigestMirrorSetSpec
  map:
    fields:
    - name: imageDigestMirrors
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ImageDigestMirrors
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.ImageDigestMirrorSetStatus
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.ImageDigestMirrors
  map:
    fields:
    - name: mirrorSourcePolicy
      type:
        scalar: string
    - name: mirrors
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: source
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.ImageLabel
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
    - name: value
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.ImageSpec
  map:
    fields:
    - name: additionalTrustedCA
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: allowedRegistriesForImport
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.RegistryLocation
          elementRelationship: atomic
    - name: externalRegistryHostnames
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: registrySources
      type:
        namedType: com.github.openshift.api.config.v1.RegistrySources
      default: {}
- name: com.github.openshift.api.config.v1.ImageStatus
  map:
    fields:
    - name: externalRegistryHostnames
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: internalRegistryHostname
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.ImageTagMirrorSet
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.ImageTagMirrorSetSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.ImageTagMirrorSetStatus
      default: {}
- name: com.github.openshift.api.config.v1.ImageTagMirrorSetSpec
  map:
    fields:
    - name: imageTagMirrors
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ImageTagMirrors
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.ImageTagMirrorSetStatus
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.ImageTagMirrors
  map:
    fields:
    - name: mirrorSourcePolicy
      type:
        scalar: string
    - name: mirrors
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: source
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.Infrastructure
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.InfrastructureSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.InfrastructureStatus
      default: {}
- name: com.github.openshift.api.config.v1.InfrastructureSpec
  map:
    fields:
    - name: cloudConfig
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapFileReference
      default: {}
    - name: platformSpec
      type:
        namedType: com.github.openshift.api.config.v1.PlatformSpec
      default: {}
- name: com.github.openshift.api.config.v1.InfrastructureStatus
  map:
    fields:
    - name: apiServerInternalURI
      type:
        scalar: string
      default: ""
    - name: apiServerURL
      type:
        scalar: string
      default: ""
    - name: controlPlaneTopology
      type:
        scalar: string
      default: ""
    - name: etcdDiscoveryDomain
      type:
        scalar: string
      default: ""
    - name: infrastructureName
      type:
        scalar: string
      default: ""
    - name: infrastructureTopology
      type:
        scalar: string
      default: ""
    - name: platform
      type:
        scalar: string
    - name: platformStatus
      type:
        namedType: com.github.openshift.api.config.v1.PlatformStatus
- name: com.github.openshift.api.config.v1.Ingress
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.IngressSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.IngressStatus
      default: {}
- name: com.github.openshift.api.config.v1.IngressPlatformSpec
  map:
    fields:
    - name: aws
      type:
        namedType: com.github.openshift.api.config.v1.AWSIngressSpec
    - name: type
      type:
        scalar: string
      default: ""
    unions:
    - discriminator: type
      fields:
      - fieldName: aws
        discriminatorValue: AWS
- name: com.github.openshift.api.config.v1.IngressSpec
  map:
    fields:
    - name: appsDomain
      type:
        scalar: string
    - name: componentRoutes
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ComponentRouteSpec
          elementRelationship: associative
          keys:
          - namespace
          - name
    - name: domain
      type:
        scalar: string
      default: ""
    - name: loadBalancer
      type:
        namedType: com.github.openshift.api.config.v1.LoadBalancer
      default: {}
    - name: requiredHSTSPolicies
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.RequiredHSTSPolicy
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.IngressStatus
  map:
    fields:
    - name: componentRoutes
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ComponentRouteStatus
          elementRelationship: associative
          keys:
          - namespace
          - name
    - name: defaultPlacement
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.IntermediateTLSProfile
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.KeystoneIdentityProvider
  map:
    fields:
    - name: ca
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: domainName
      type:
        scalar: string
      default: ""
    - name: tlsClientCert
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: tlsClientKey
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: url
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.KubevirtPlatformSpec
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.KubevirtPlatformStatus
  map:
    fields:
    - name: apiServerInternalIP
      type:
        scalar: string
    - name: ingressIP
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.LDAPAttributeMapping
  map:
    fields:
    - name: email
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: id
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: name
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: preferredUsername
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.LDAPIdentityProvider
  map:
    fields:
    - name: attributes
      type:
        namedType: com.github.openshift.api.config.v1.LDAPAttributeMapping
      default: {}
    - name: bindDN
      type:
        scalar: string
      default: ""
    - name: bindPassword
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: ca
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: insecure
      type:
        scalar: boolean
      default: false
    - name: url
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.LoadBalancer
  map:
    fields:
    - name: platform
      type:
        namedType: com.github.openshift.api.config.v1.IngressPlatformSpec
      default: {}
- name: com.github.openshift.api.config.v1.MTUMigration
  map:
    fields:
    - name: machine
      type:
        namedType: com.github.openshift.api.config.v1.MTUMigrationValues
    - name: network
      type:
        namedType: com.github.openshift.api.config.v1.MTUMigrationValues
- name: com.github.openshift.api.config.v1.MTUMigrationValues
  map:
    fields:
    - name: from
      type:
        scalar: numeric
    - name: to
      type:
        scalar: numeric
- name: com.github.openshift.api.config.v1.MaxAgePolicy
  map:
    fields:
    - name: largestMaxAge
      type:
        scalar: numeric
    - name: smallestMaxAge
      type:
        scalar: numeric
- name: com.github.openshift.api.config.v1.ModernTLSProfile
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.Network
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.NetworkSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.NetworkStatus
      default: {}
- name: com.github.openshift.api.config.v1.NetworkMigration
  map:
    fields:
    - name: mtu
      type:
        namedType: com.github.openshift.api.config.v1.MTUMigration
    - name: networkType
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.NetworkSpec
  map:
    fields:
    - name: clusterNetwork
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ClusterNetworkEntry
          elementRelationship: atomic
    - name: externalIP
      type:
        namedType: com.github.openshift.api.config.v1.ExternalIPConfig
    - name: networkType
      type:
        scalar: string
      default: ""
    - name: serviceNetwork
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: serviceNodePortRange
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.NetworkStatus
  map:
    fields:
    - name: clusterNetwork
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.ClusterNetworkEntry
          elementRelationship: atomic
    - name: clusterNetworkMTU
      type:
        scalar: numeric
    - name: migration
      type:
        namedType: com.github.openshift.api.config.v1.NetworkMigration
    - name: networkType
      type:
        scalar: string
    - name: serviceNetwork
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.Node
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.NodeSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.NodeStatus
      default: {}
- name: com.github.openshift.api.config.v1.NodeSpec
  map:
    fields:
    - name: cgroupMode
      type:
        scalar: string
    - name: workerLatencyProfile
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.NodeStatus
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.NutanixPlatformSpec
  map:
    fields:
    - name: prismCentral
      type:
        namedType: com.github.openshift.api.config.v1.NutanixPrismEndpoint
      default: {}
    - name: prismElements
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.NutanixPrismElementEndpoint
          elementRelationship: associative
          keys:
          - name
- name: com.github.openshift.api.config.v1.NutanixPlatformStatus
  map:
    fields:
    - name: apiServerInternalIP
      type:
        scalar: string
    - name: apiServerInternalIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: ingressIP
      type:
        scalar: string
    - name: ingressIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.NutanixPrismElementEndpoint
  map:
    fields:
    - name: endpoint
      type:
        namedType: com.github.openshift.api.config.v1.NutanixPrismEndpoint
      default: {}
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.NutanixPrismEndpoint
  map:
    fields:
    - name: address
      type:
        scalar: string
      default: ""
    - name: port
      type:
        scalar: numeric
      default: 0
- name: com.github.openshift.api.config.v1.OAuth
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.OAuthSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.OAuthStatus
      default: {}
- name: com.github.openshift.api.config.v1.OAuthSpec
  map:
    fields:
    - name: identityProviders
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.IdentityProvider
          elementRelationship: atomic
    - name: templates
      type:
        namedType: com.github.openshift.api.config.v1.OAuthTemplates
      default: {}
    - name: tokenConfig
      type:
        namedType: com.github.openshift.api.config.v1.TokenConfig
      default: {}
- name: com.github.openshift.api.config.v1.OAuthStatus
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.OAuthTemplates
  map:
    fields:
    - name: error
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: login
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: providerSelection
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
- name: com.github.openshift.api.config.v1.ObjectReference
  map:
    fields:
    - name: group
      type:
        scalar: string
      default: ""
    - name: name
      type:
        scalar: string
      default: ""
    - name: namespace
      type:
        scalar: string
    - name: resource
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.OldTLSProfile
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.OpenIDClaims
  map:
    fields:
    - name: email
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: groups
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: name
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: preferredUsername
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.OpenIDIdentityProvider
  map:
    fields:
    - name: ca
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: claims
      type:
        namedType: com.github.openshift.api.config.v1.OpenIDClaims
      default: {}
    - name: clientID
      type:
        scalar: string
      default: ""
    - name: clientSecret
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
    - name: extraAuthorizeParameters
      type:
        map:
          elementType:
            scalar: string
    - name: extraScopes
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: issuer
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.OpenStackPlatformSpec
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.OpenStackPlatformStatus
  map:
    fields:
    - name: apiServerInternalIP
      type:
        scalar: string
    - name: apiServerInternalIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: cloudName
      type:
        scalar: string
    - name: ingressIP
      type:
        scalar: string
    - name: ingressIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: nodeDNSIP
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.OperandVersion
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
    - name: version
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.OperatorHub
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.OperatorHubSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.OperatorHubStatus
      default: {}
- name: com.github.openshift.api.config.v1.OperatorHubSpec
  map:
    fields:
    - name: disableAllDefaultSources
      type:
        scalar: boolean
    - name: sources
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.HubSource
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.OperatorHubStatus
  map:
    fields:
    - name: sources
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.HubSourceStatus
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.OvirtPlatformSpec
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.OvirtPlatformStatus
  map:
    fields:
    - name: apiServerInternalIP
      type:
        scalar: string
    - name: apiServerInternalIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: ingressIP
      type:
        scalar: string
    - name: ingressIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: nodeDNSIP
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.PlatformSpec
  map:
    fields:
    - name: alibabaCloud
      type:
        namedType: com.github.openshift.api.config.v1.AlibabaCloudPlatformSpec
    - name: aws
      type:
        namedType: com.github.openshift.api.config.v1.AWSPlatformSpec
    - name: azure
      type:
        namedType: com.github.openshift.api.config.v1.AzurePlatformSpec
    - name: baremetal
      type:
        namedType: com.github.openshift.api.config.v1.BareMetalPlatformSpec
    - name: equinixMetal
      type:
        namedType: com.github.openshift.api.config.v1.EquinixMetalPlatformSpec
    - name: gcp
      type:
        namedType: com.github.openshift.api.config.v1.GCPPlatformSpec
    - name: ibmcloud
      type:
        namedType: com.github.openshift.api.config.v1.IBMCloudPlatformSpec
    - name: kubevirt
      type:
        namedType: com.github.openshift.api.config.v1.KubevirtPlatformSpec
    - name: nutanix
      type:
        namedType: com.github.openshift.api.config.v1.NutanixPlatformSpec
    - name: openstack
      type:
        namedType: com.github.openshift.api.config.v1.OpenStackPlatformSpec
    - name: ovirt
      type:
        namedType: com.github.openshift.api.config.v1.OvirtPlatformSpec
    - name: powervs
      type:
        namedType: com.github.openshift.api.config.v1.PowerVSPlatformSpec
    - name: type
      type:
        scalar: string
      default: ""
    - name: vsphere
      type:
        namedType: com.github.openshift.api.config.v1.VSpherePlatformSpec
- name: com.github.openshift.api.config.v1.PlatformStatus
  map:
    fields:
    - name: alibabaCloud
      type:
        namedType: com.github.openshift.api.config.v1.AlibabaCloudPlatformStatus
    - name: aws
      type:
        namedType: com.github.openshift.api.config.v1.AWSPlatformStatus
    - name: azure
      type:
        namedType: com.github.openshift.api.config.v1.AzurePlatformStatus
    - name: baremetal
      type:
        namedType: com.github.openshift.api.config.v1.BareMetalPlatformStatus
    - name: equinixMetal
      type:
        namedType: com.github.openshift.api.config.v1.EquinixMetalPlatformStatus
    - name: gcp
      type:
        namedType: com.github.openshift.api.config.v1.GCPPlatformStatus
    - name: ibmcloud
      type:
        namedType: com.github.openshift.api.config.v1.IBMCloudPlatformStatus
    - name: kubevirt
      type:
        namedType: com.github.openshift.api.config.v1.KubevirtPlatformStatus
    - name: nutanix
      type:
        namedType: com.github.openshift.api.config.v1.NutanixPlatformStatus
    - name: openstack
      type:
        namedType: com.github.openshift.api.config.v1.OpenStackPlatformStatus
    - name: ovirt
      type:
        namedType: com.github.openshift.api.config.v1.OvirtPlatformStatus
    - name: powervs
      type:
        namedType: com.github.openshift.api.config.v1.PowerVSPlatformStatus
    - name: type
      type:
        scalar: string
      default: ""
    - name: vsphere
      type:
        namedType: com.github.openshift.api.config.v1.VSpherePlatformStatus
- name: com.github.openshift.api.config.v1.PowerVSPlatformSpec
  map:
    fields:
    - name: serviceEndpoints
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.PowerVSServiceEndpoint
          elementRelationship: associative
          keys:
          - name
- name: com.github.openshift.api.config.v1.PowerVSPlatformStatus
  map:
    fields:
    - name: cisInstanceCRN
      type:
        scalar: string
    - name: dnsInstanceCRN
      type:
        scalar: string
    - name: region
      type:
        scalar: string
      default: ""
    - name: serviceEndpoints
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.PowerVSServiceEndpoint
          elementRelationship: atomic
    - name: zone
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.PowerVSServiceEndpoint
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
    - name: url
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.Project
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.ProjectSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.ProjectStatus
      default: {}
- name: com.github.openshift.api.config.v1.ProjectSpec
  map:
    fields:
    - name: projectRequestMessage
      type:
        scalar: string
      default: ""
    - name: projectRequestTemplate
      type:
        namedType: com.github.openshift.api.config.v1.TemplateReference
      default: {}
- name: com.github.openshift.api.config.v1.ProjectStatus
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.PromQLClusterCondition
  map:
    fields:
    - name: promql
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.Proxy
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.ProxySpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.ProxyStatus
      default: {}
- name: com.github.openshift.api.config.v1.ProxySpec
  map:
    fields:
    - name: httpProxy
      type:
        scalar: string
    - name: httpsProxy
      type:
        scalar: string
    - name: noProxy
      type:
        scalar: string
    - name: readinessEndpoints
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: trustedCA
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
- name: com.github.openshift.api.config.v1.ProxyStatus
  map:
    fields:
    - name: httpProxy
      type:
        scalar: string
    - name: httpsProxy
      type:
        scalar: string
    - name: noProxy
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.RegistryLocation
  map:
    fields:
    - name: domainName
      type:
        scalar: string
      default: ""
    - name: insecure
      type:
        scalar: boolean
- name: com.github.openshift.api.config.v1.RegistrySources
  map:
    fields:
    - name: allowedRegistries
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: blockedRegistries
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: containerRuntimeSearchRegistries
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: insecureRegistries
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.Release
  map:
    fields:
    - name: channels
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: image
      type:
        scalar: string
      default: ""
    - name: url
      type:
        scalar: string
    - name: version
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.RepositoryDigestMirrors
  map:
    fields:
    - name: allowMirrorByTags
      type:
        scalar: boolean
    - name: mirrors
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: source
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.RequestHeaderIdentityProvider
  map:
    fields:
    - name: ca
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: challengeURL
      type:
        scalar: string
      default: ""
    - name: clientCommonNames
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: emailHeaders
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: headers
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: loginURL
      type:
        scalar: string
      default: ""
    - name: nameHeaders
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: preferredUsernameHeaders
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.RequiredHSTSPolicy
  map:
    fields:
    - name: domainPatterns
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: includeSubDomainsPolicy
      type:
        scalar: string
    - name: maxAge
      type:
        namedType: com.github.openshift.api.config.v1.MaxAgePolicy
      default: {}
    - name: namespaceSelector
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector
    - name: preloadPolicy
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.Scheduler
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1.SchedulerSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1.SchedulerStatus
      default: {}
- name: com.github.openshift.api.config.v1.SchedulerSpec
  map:
    fields:
    - name: defaultNodeSelector
      type:
        scalar: string
    - name: mastersSchedulable
      type:
        scalar: boolean
      default: false
    - name: policy
      type:
        namedType: com.github.openshift.api.config.v1.ConfigMapNameReference
      default: {}
    - name: profile
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.SchedulerStatus
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: com.github.openshift.api.config.v1.SecretNameReference
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.TLSSecurityProfile
  map:
    fields:
    - name: custom
      type:
        namedType: com.github.openshift.api.config.v1.CustomTLSProfile
    - name: intermediate
      type:
        namedType: com.github.openshift.api.config.v1.IntermediateTLSProfile
    - name: modern
      type:
        namedType: com.github.openshift.api.config.v1.ModernTLSProfile
    - name: old
      type:
        namedType: com.github.openshift.api.config.v1.OldTLSProfile
    - name: type
      type:
        scalar: string
      default: ""
    unions:
    - discriminator: type
      fields:
      - fieldName: custom
        discriminatorValue: Custom
      - fieldName: intermediate
        discriminatorValue: Intermediate
      - fieldName: modern
        discriminatorValue: Modern
      - fieldName: old
        discriminatorValue: Old
- name: com.github.openshift.api.config.v1.TemplateReference
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.TokenConfig
  map:
    fields:
    - name: accessTokenInactivityTimeout
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
    - name: accessTokenInactivityTimeoutSeconds
      type:
        scalar: numeric
    - name: accessTokenMaxAgeSeconds
      type:
        scalar: numeric
- name: com.github.openshift.api.config.v1.Update
  map:
    fields:
    - name: force
      type:
        scalar: boolean
      default: false
    - name: image
      type:
        scalar: string
      default: ""
    - name: version
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.UpdateHistory
  map:
    fields:
    - name: acceptedRisks
      type:
        scalar: string
    - name: completionTime
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: image
      type:
        scalar: string
      default: ""
    - name: startedTime
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
      default: {}
    - name: state
      type:
        scalar: string
      default: ""
    - name: verified
      type:
        scalar: boolean
      default: false
    - name: version
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.VSpherePlatformFailureDomainSpec
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
    - name: region
      type:
        scalar: string
      default: ""
    - name: server
      type:
        scalar: string
      default: ""
    - name: topology
      type:
        namedType: com.github.openshift.api.config.v1.VSpherePlatformTopology
      default: {}
    - name: zone
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.VSpherePlatformNodeNetworking
  map:
    fields:
    - name: external
      type:
        namedType: com.github.openshift.api.config.v1.VSpherePlatformNodeNetworkingSpec
      default: {}
    - name: internal
      type:
        namedType: com.github.openshift.api.config.v1.VSpherePlatformNodeNetworkingSpec
      default: {}
- name: com.github.openshift.api.config.v1.VSpherePlatformNodeNetworkingSpec
  map:
    fields:
    - name: excludeNetworkSubnetCidr
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: network
      type:
        scalar: string
    - name: networkSubnetCidr
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.VSpherePlatformSpec
  map:
    fields:
    - name: failureDomains
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.VSpherePlatformFailureDomainSpec
          elementRelationship: atomic
    - name: nodeNetworking
      type:
        namedType: com.github.openshift.api.config.v1.VSpherePlatformNodeNetworking
      default: {}
    - name: vcenters
      type:
        list:
          elementType:
            namedType: com.github.openshift.api.config.v1.VSpherePlatformVCenterSpec
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1.VSpherePlatformStatus
  map:
    fields:
    - name: apiServerInternalIP
      type:
        scalar: string
    - name: apiServerInternalIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: ingressIP
      type:
        scalar: string
    - name: ingressIPs
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: nodeDNSIP
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.VSpherePlatformTopology
  map:
    fields:
    - name: computeCluster
      type:
        scalar: string
      default: ""
    - name: datacenter
      type:
        scalar: string
      default: ""
    - name: datastore
      type:
        scalar: string
      default: ""
    - name: folder
      type:
        scalar: string
    - name: networks
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: resourcePool
      type:
        scalar: string
- name: com.github.openshift.api.config.v1.VSpherePlatformVCenterSpec
  map:
    fields:
    - name: datacenters
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
    - name: port
      type:
        scalar: numeric
    - name: server
      type:
        scalar: string
      default: ""
- name: com.github.openshift.api.config.v1.WebhookTokenAuthenticator
  map:
    fields:
    - name: kubeConfig
      type:
        namedType: com.github.openshift.api.config.v1.SecretNameReference
      default: {}
- name: com.github.openshift.api.config.v1alpha1.GatherConfig
  map:
    fields:
    - name: dataPolicy
      type:
        scalar: string
    - name: disabledGatherers
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: com.github.openshift.api.config.v1alpha1.InsightsDataGather
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: kind
      type:
        scalar: string
    - name: metadata
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
      default: {}
    - name: spec
      type:
        namedType: com.github.openshift.api.config.v1alpha1.InsightsDataGatherSpec
      default: {}
    - name: status
      type:
        namedType: com.github.openshift.api.config.v1alpha1.InsightsDataGatherStatus
      default: {}
- name: com.github.openshift.api.config.v1alpha1.InsightsDataGatherSpec
  map:
    fields:
    - name: gatherConfig
      type:
        namedType: com.github.openshift.api.config.v1alpha1.GatherConfig
      default: {}
- name: com.github.openshift.api.config.v1alpha1.InsightsDataGatherStatus
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: io.k8s.api.core.v1.ConfigMapKeySelector
  map:
    fields:
    - name: key
      type:
        scalar: string
      default: ""
    - name: name
      type:
        scalar: string
    - name: optional
      type:
        scalar: boolean
    elementRelationship: atomic
- name: io.k8s.api.core.v1.EnvVar
  map:
    fields:
    - name: name
      type:
        scalar: string
      default: ""
    - name: value
      type:
        scalar: string
    - name: valueFrom
      type:
        namedType: io.k8s.api.core.v1.EnvVarSource
- name: io.k8s.api.core.v1.EnvVarSource
  map:
    fields:
    - name: configMapKeyRef
      type:
        namedType: io.k8s.api.core.v1.ConfigMapKeySelector
    - name: fieldRef
      type:
        namedType: io.k8s.api.core.v1.ObjectFieldSelector
    - name: resourceFieldRef
      type:
        namedType: io.k8s.api.core.v1.ResourceFieldSelector
    - name: secretKeyRef
      type:
        namedType: io.k8s.api.core.v1.SecretKeySelector
- name: io.k8s.api.core.v1.ObjectFieldSelector
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: fieldPath
      type:
        scalar: string
      default: ""
    elementRelationship: atomic
- name: io.k8s.api.core.v1.ResourceFieldSelector
  map:
    fields:
    - name: containerName
      type:
        scalar: string
    - name: divisor
      type:
        namedType: io.k8s.apimachinery.pkg.api.resource.Quantity
      default: {}
    - name: resource
      type:
        scalar: string
      default: ""
    elementRelationship: atomic
- name: io.k8s.api.core.v1.ResourceRequirements
  map:
    fields:
    - name: limits
      type:
        map:
          elementType:
            namedType: io.k8s.apimachinery.pkg.api.resource.Quantity
    - name: requests
      type:
        map:
          elementType:
            namedType: io.k8s.apimachinery.pkg.api.resource.Quantity
- name: io.k8s.api.core.v1.SecretKeySelector
  map:
    fields:
    - name: key
      type:
        scalar: string
      default: ""
    - name: name
      type:
        scalar: string
    - name: optional
      type:
        scalar: boolean
    elementRelationship: atomic
- name: io.k8s.api.core.v1.Toleration
  map:
    fields:
    - name: effect
      type:
        scalar: string
    - name: key
      type:
        scalar: string
    - name: operator
      type:
        scalar: string
    - name: tolerationSeconds
      type:
        scalar: numeric
    - name: value
      type:
        scalar: string
- name: io.k8s.apimachinery.pkg.api.resource.Quantity
  scalar: untyped
- name: io.k8s.apimachinery.pkg.apis.meta.v1.Condition
  map:
    fields:
    - name: lastTransitionTime
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
      default: {}
    - name: message
      type:
        scalar: string
      default: ""
    - name: observedGeneration
      type:
        scalar: numeric
    - name: reason
      type:
        scalar: string
      default: ""
    - name: status
      type:
        scalar: string
      default: ""
    - name: type
      type:
        scalar: string
      default: ""
- name: io.k8s.apimachinery.pkg.apis.meta.v1.Duration
  scalar: string
- name: io.k8s.apimachinery.pkg.apis.meta.v1.FieldsV1
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector
  map:
    fields:
    - name: matchExpressions
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement
          elementRelationship: atomic
    - name: matchLabels
      type:
        map:
          elementType:
            scalar: string
    elementRelationship: atomic
- name: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement
  map:
    fields:
    - name: key
      type:
        scalar: string
      default: ""
    - name: operator
      type:
        scalar: string
      default: ""
    - name: values
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: atomic
- name: io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
    - name: fieldsType
      type:
        scalar: string
    - name: fieldsV1
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.FieldsV1
    - name: manager
      type:
        scalar: string
    - name: operation
      type:
        scalar: string
    - name: subresource
      type:
        scalar: string
    - name: time
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
- name: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta
  map:
    fields:
    - name: annotations
      type:
        map:
          elementType:
            scalar: string
    - name: creationTimestamp
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
      default: {}
    - name: deletionGracePeriodSeconds
      type:
        scalar: numeric
    - name: deletionTimestamp
      type:
        namedType: io.k8s.apimachinery.pkg.apis.meta.v1.Time
    - name: finalizers
      type:
        list:
          elementType:
            scalar: string
          elementRelationship: associative
    - name: generateName
      type:
        scalar: string
    - name: generation
      type:
        scalar: numeric
    - name: labels
      type:
        map:
          elementType:
            scalar: string
    - name: managedFields
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry
          elementRelationship: atomic
    - name: name
      type:
        scalar: string
    - name: namespace
      type:
        scalar: string
    - name: ownerReferences
      type:
        list:
          elementType:
            namedType: io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference
          elementRelationship: associative
          keys:
          - uid
    - name: resourceVersion
      type:
        scalar: string
    - name: selfLink
      type:
        scalar: string
    - name: uid
      type:
        scalar: string
- name: io.k8s.apimachinery.pkg.apis.meta.v1.OwnerReference
  map:
    fields:
    - name: apiVersion
      type:
        scalar: string
      default: ""
    - name: blockOwnerDeletion
      type:
        scalar: boolean
    - name: controller
      type:
        scalar: boolean
    - name: kind
      type:
        scalar: string
      default: ""
    - name: name
      type:
        scalar: string
      default: ""
    - name: uid
      type:
        scalar: string
      default: ""
    elementRelationship: atomic
- name: io.k8s.apimachinery.pkg.apis.meta.v1.Time
  scalar: untyped
- name: io.k8s.apimachinery.pkg.runtime.RawExtension
  map:
    elementType:
      scalar: untyped
      list:
        elementType:
          namedType: __untyped_atomic_
        elementRelationship: atomic
      map:
        elementType:
          namedType: __untyped_deduced_
        elementRelationship: separable
- name: __untyped_atomic_
  scalar: untyped
  list:
    elementType:
      namedType: __untyped_atomic_
    elementRelationship: atomic
  map:
    elementType:
      namedType: __untyped_atomic_
    elementRelationship: atomic
- name: __untyped_deduced_
  scalar: untyped
  list:
    elementType:
      namedType: __untyped_atomic_
    elementRelationship: atomic
  map:
    elementType:
      namedType: __untyped_deduced_
    elementRelationship: separable
`)
