export function formatBytes(bytes: number, decimals = 2, withSizes = true) {
    if (bytes === 0) return '0 Bytes';

    const k = 1024;
    const dm = decimals < 0 ? 0 : decimals;
    const sizes = [
        'Bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB',
    ];

    const i = Math.floor(Math.log(bytes) / Math.log(k));

    const numbersResult = parseFloat((bytes / Math.pow(k, i)).toFixed(dm));
    return withSizes ? `${numbersResult} ${sizes[i]}` : `${numbersResult}`;
}
