<?php

use Appwrite\Auth\Auth;

$member = [
    'global',
    'public',
    'home',
    'console',
    'graphql',
    'sessions.write',
    'account',
    'teams.read',
    'teams.write',
    'documents.read',
    'documents.write',
    'files.read',
    'files.write',
    'projects.read',
    'locale.read',
    'avatars.read',
    'execution.read',
    'execution.write',
    'targets.read',
    'targets.write',
    'subscribers.write',
    'subscribers.read',
    'assistant.read',
    'rules.read'
];

$admins = [
    'global',
    'graphql',
    'sessions.write',
    'teams.read',
    'teams.write',
    'documents.read',
    'documents.write',
    'files.read',
    'files.write',
    'buckets.read',
    'buckets.write',
    'users.read',
    'users.write',
    'databases.read',
    'databases.write',
    'collections.read',
    'collections.write',
    'platforms.read',
    'platforms.write',
    'projects.write',
    'keys.read',
    'keys.write',
    'webhooks.read',
    'webhooks.write',
    'locale.read',
    'avatars.read',
    'health.read',
    'functions.read',
    'functions.write',
    'sites.read',
    'sites.write',
    'log.read',
    'log.write',
    'execution.read',
    'execution.write',
    'rules.read',
    'rules.write',
    'migrations.read',
    'migrations.write',
    'vcs.read',
    'vcs.write',
    'targets.read',
    'targets.write',
    'providers.write',
    'providers.read',
    'messages.write',
    'messages.read',
    'topics.write',
    'topics.read',
    'subscribers.write',
    'subscribers.read',
    'tokens.read',
    'tokens.write',
];

return [
    Auth::USER_ROLE_GUESTS => [
        'label' => 'Guests',
        'scopes' => [
            'global',
            'public',
            'home',
            'console',
            'graphql',
            'sessions.write',
            'documents.read',
            'documents.write',
            'files.read',
            'files.write',
            'locale.read',
            'avatars.read',
            'execution.write',
        ],
    ],
    Auth::USER_ROLE_USERS => [
        'label' => 'Users',
        'scopes' => \array_merge($member),
    ],
    Auth::USER_ROLE_ADMIN => [
        'label' => 'Admin',
        'scopes' => \array_merge($admins),
    ],
    Auth::USER_ROLE_DEVELOPER => [
        'label' => 'Developer',
        'scopes' => \array_merge($admins),
    ],
    Auth::USER_ROLE_OWNER => [
        'label' => 'Owner',
        'scopes' => \array_merge($member, $admins),
    ],
    Auth::USER_ROLE_APPS => [
        'label' => 'Applications',
        'scopes' => ['global', 'health.read', 'graphql'],
    ],
];
