<?php

/**
 * ISO 3166 standard country codes with country names and coordinates
 * https://www.iso.org/iso-3166-country-codes.html
 *
 * Source:
 * https://www.iso.org/obp/ui/#search/code/
 * Coordinates source: Natural Earth Data (approximate country centroids)
 */

return [
    'AF' => ['name' => 'Afghanistan', 'latitude' => 33.0, 'longitude' => 66.0],
    'AO' => ['name' => 'Angola', 'latitude' => -12.5, 'longitude' => 18.5],
    'AL' => ['name' => 'Albania', 'latitude' => 41.0, 'longitude' => 20.0],
    'AD' => ['name' => 'Andorra', 'latitude' => 42.5, 'longitude' => 1.6],
    'AE' => ['name' => 'United Arab Emirates', 'latitude' => 24.0, 'longitude' => 54.0],
    'AR' => ['name' => 'Argentina', 'latitude' => -34.0, 'longitude' => -64.0],
    'AM' => ['name' => 'Armenia', 'latitude' => 40.0, 'longitude' => 45.0],
    'AG' => ['name' => 'Antigua and Barbuda', 'latitude' => 17.05, 'longitude' => -61.8],
    'AU' => ['name' => 'Australia', 'latitude' => -25.0, 'longitude' => 135.0],
    'AT' => ['name' => 'Austria', 'latitude' => 47.3, 'longitude' => 13.3],
    'AZ' => ['name' => 'Azerbaijan', 'latitude' => 40.5, 'longitude' => 47.5],
    'BI' => ['name' => 'Burundi', 'latitude' => -3.5, 'longitude' => 30.0],
    'BE' => ['name' => 'Belgium', 'latitude' => 50.8, 'longitude' => 4.0],
    'BJ' => ['name' => 'Benin', 'latitude' => 9.5, 'longitude' => 2.25],
    'BF' => ['name' => 'Burkina Faso', 'latitude' => 13.0, 'longitude' => -2.0],
    'BD' => ['name' => 'Bangladesh', 'latitude' => 24.0, 'longitude' => 90.0],
    'BG' => ['name' => 'Bulgaria', 'latitude' => 43.0, 'longitude' => 25.0],
    'BH' => ['name' => 'Bahrain', 'latitude' => 26.0, 'longitude' => 50.5],
    'BS' => ['name' => 'Bahamas', 'latitude' => 24.25, 'longitude' => -76.0],
    'BA' => ['name' => 'Bosnia and Herzegovina', 'latitude' => 44.0, 'longitude' => 18.0],
    'BY' => ['name' => 'Belarus', 'latitude' => 53.0, 'longitude' => 28.0],
    'BZ' => ['name' => 'Belize', 'latitude' => 17.25, 'longitude' => -88.75],
    'BO' => ['name' => 'Bolivia', 'latitude' => -17.0, 'longitude' => -65.0],
    'BR' => ['name' => 'Brazil', 'latitude' => -10.0, 'longitude' => -55.0],
    'BB' => ['name' => 'Barbados', 'latitude' => 13.17, 'longitude' => -59.53],
    'BN' => ['name' => 'Brunei', 'latitude' => 4.5, 'longitude' => 114.67],
    'BT' => ['name' => 'Bhutan', 'latitude' => 27.5, 'longitude' => 90.5],
    'BW' => ['name' => 'Botswana', 'latitude' => -22.0, 'longitude' => 24.0],
    'CF' => ['name' => 'Central African Republic', 'latitude' => 7.0, 'longitude' => 21.0],
    'CA' => ['name' => 'Canada', 'latitude' => 60.0, 'longitude' => -95.0],
    'CH' => ['name' => 'Switzerland', 'latitude' => 47.0, 'longitude' => 8.0],
    'CL' => ['name' => 'Chile', 'latitude' => -30.0, 'longitude' => -71.0],
    'CN' => ['name' => 'China', 'latitude' => 35.0, 'longitude' => 105.0],
    'CI' => ['name' => 'Côte d\'Ivoire', 'latitude' => 8.0, 'longitude' => -5.0],
    'CM' => ['name' => 'Cameroon', 'latitude' => 6.0, 'longitude' => 12.0],
    'CD' => ['name' => 'Democratic Republic of the Congo', 'latitude' => -2.5, 'longitude' => 23.5],
    'CG' => ['name' => 'Republic of the Congo', 'latitude' => -1.0, 'longitude' => 15.0],
    'CO' => ['name' => 'Colombia', 'latitude' => 4.0, 'longitude' => -72.0],
    'KM' => ['name' => 'Comoros', 'latitude' => -12.17, 'longitude' => 44.25],
    'CV' => ['name' => 'Cape Verde', 'latitude' => 16.0, 'longitude' => -24.0],
    'CR' => ['name' => 'Costa Rica', 'latitude' => 10.0, 'longitude' => -84.0],
    'CU' => ['name' => 'Cuba', 'latitude' => 21.5, 'longitude' => -80.0],
    'CY' => ['name' => 'Cyprus', 'latitude' => 35.0, 'longitude' => 33.0],
    'CZ' => ['name' => 'Czech Republic', 'latitude' => 49.75, 'longitude' => 15.5],
    'DE' => ['name' => 'Germany', 'latitude' => 51.0, 'longitude' => 9.0],
    'DJ' => ['name' => 'Djibouti', 'latitude' => 11.5, 'longitude' => 43.0],
    'DM' => ['name' => 'Dominica', 'latitude' => 15.42, 'longitude' => -61.33],
    'DK' => ['name' => 'Denmark', 'latitude' => 56.0, 'longitude' => 10.0],
    'DO' => ['name' => 'Dominican Republic', 'latitude' => 19.0, 'longitude' => -70.67],
    'DZ' => ['name' => 'Algeria', 'latitude' => 28.0, 'longitude' => 3.0],
    'EC' => ['name' => 'Ecuador', 'latitude' => -2.0, 'longitude' => -77.5],
    'EG' => ['name' => 'Egypt', 'latitude' => 27.0, 'longitude' => 30.0],
    'ER' => ['name' => 'Eritrea', 'latitude' => 15.0, 'longitude' => 39.0],
    'ES' => ['name' => 'Spain', 'latitude' => 40.0, 'longitude' => -4.0],
    'EE' => ['name' => 'Estonia', 'latitude' => 59.0, 'longitude' => 26.0],
    'ET' => ['name' => 'Ethiopia', 'latitude' => 8.0, 'longitude' => 38.0],
    'FI' => ['name' => 'Finland', 'latitude' => 64.0, 'longitude' => 26.0],
    'FJ' => ['name' => 'Fiji', 'latitude' => -18.0, 'longitude' => 175.0],
    'FR' => ['name' => 'France', 'latitude' => 46.0, 'longitude' => 2.0],
    'FM' => ['name' => 'Micronesia', 'latitude' => 6.92, 'longitude' => 158.25],
    'GA' => ['name' => 'Gabon', 'latitude' => -1.0, 'longitude' => 11.75],
    'GB' => ['name' => 'United Kingdom', 'latitude' => 54.0, 'longitude' => -2.0],
    'GE' => ['name' => 'Georgia', 'latitude' => 42.0, 'longitude' => 43.5],
    'GH' => ['name' => 'Ghana', 'latitude' => 8.0, 'longitude' => -2.0],
    'GN' => ['name' => 'Guinea', 'latitude' => 11.0, 'longitude' => -10.0],
    'GM' => ['name' => 'Gambia', 'latitude' => 13.47, 'longitude' => -16.57],
    'GW' => ['name' => 'Guinea-Bissau', 'latitude' => 12.0, 'longitude' => -15.0],
    'GQ' => ['name' => 'Equatorial Guinea', 'latitude' => 2.0, 'longitude' => 10.0],
    'GR' => ['name' => 'Greece', 'latitude' => 39.0, 'longitude' => 22.0],
    'GD' => ['name' => 'Grenada', 'latitude' => 12.12, 'longitude' => -61.67],
    'GT' => ['name' => 'Guatemala', 'latitude' => 15.5, 'longitude' => -90.25],
    'GY' => ['name' => 'Guyana', 'latitude' => 5.0, 'longitude' => -59.0],
    'HK' => ['name' => 'Hong Kong', 'latitude' => 22.25, 'longitude' => 114.17],
    'HN' => ['name' => 'Honduras', 'latitude' => 15.0, 'longitude' => -86.5],
    'HR' => ['name' => 'Croatia', 'latitude' => 45.17, 'longitude' => 15.5],
    'HT' => ['name' => 'Haiti', 'latitude' => 19.0, 'longitude' => -72.42],
    'HU' => ['name' => 'Hungary', 'latitude' => 47.0, 'longitude' => 20.0],
    'ID' => ['name' => 'Indonesia', 'latitude' => -5.0, 'longitude' => 120.0],
    'IN' => ['name' => 'India', 'latitude' => 20.0, 'longitude' => 77.0],
    'IE' => ['name' => 'Ireland', 'latitude' => 53.0, 'longitude' => -8.0],
    'IR' => ['name' => 'Iran', 'latitude' => 32.0, 'longitude' => 53.0],
    'IQ' => ['name' => 'Iraq', 'latitude' => 33.0, 'longitude' => 44.0],
    'IS' => ['name' => 'Iceland', 'latitude' => 65.0, 'longitude' => -18.0],
    'IL' => ['name' => 'Israel', 'latitude' => 31.5, 'longitude' => 34.75],
    'IT' => ['name' => 'Italy', 'latitude' => 42.83, 'longitude' => 12.83],
    'JM' => ['name' => 'Jamaica', 'latitude' => 18.25, 'longitude' => -77.5],
    'JO' => ['name' => 'Jordan', 'latitude' => 31.0, 'longitude' => 36.0],
    'JP' => ['name' => 'Japan', 'latitude' => 36.0, 'longitude' => 138.0],
    'KZ' => ['name' => 'Kazakhstan', 'latitude' => 48.0, 'longitude' => 68.0],
    'KE' => ['name' => 'Kenya', 'latitude' => 1.0, 'longitude' => 38.0],
    'KG' => ['name' => 'Kyrgyzstan', 'latitude' => 41.0, 'longitude' => 75.0],
    'KH' => ['name' => 'Cambodia', 'latitude' => 13.0, 'longitude' => 105.0],
    'KI' => ['name' => 'Kiribati', 'latitude' => 1.42, 'longitude' => 173.0],
    'KN' => ['name' => 'Saint Kitts and Nevis', 'latitude' => 17.33, 'longitude' => -62.75],
    'KR' => ['name' => 'South Korea', 'latitude' => 37.0, 'longitude' => 127.5],
    'KW' => ['name' => 'Kuwait', 'latitude' => 29.34, 'longitude' => 47.66],
    'LA' => ['name' => 'Laos', 'latitude' => 18.0, 'longitude' => 105.0],
    'LB' => ['name' => 'Lebanon', 'latitude' => 33.83, 'longitude' => 35.83],
    'LR' => ['name' => 'Liberia', 'latitude' => 6.5, 'longitude' => -9.5],
    'LY' => ['name' => 'Libya', 'latitude' => 25.0, 'longitude' => 17.0],
    'LC' => ['name' => 'Saint Lucia', 'latitude' => 13.88, 'longitude' => -61.13],
    'LI' => ['name' => 'Liechtenstein', 'latitude' => 47.17, 'longitude' => 9.53],
    'LK' => ['name' => 'Sri Lanka', 'latitude' => 7.0, 'longitude' => 81.0],
    'LS' => ['name' => 'Lesotho', 'latitude' => -29.5, 'longitude' => 28.5],
    'LT' => ['name' => 'Lithuania', 'latitude' => 56.0, 'longitude' => 24.0],
    'LU' => ['name' => 'Luxembourg', 'latitude' => 49.75, 'longitude' => 6.17],
    'LV' => ['name' => 'latitudevia', 'latitude' => 57.0, 'longitude' => 25.0],
    'MA' => ['name' => 'Morocco', 'latitude' => 32.0, 'longitude' => -5.0],
    'MC' => ['name' => 'Monaco', 'latitude' => 43.73, 'longitude' => 7.4],
    'MD' => ['name' => 'Moldova', 'latitude' => 47.0, 'longitude' => 29.0],
    'MG' => ['name' => 'Madagascar', 'latitude' => -20.0, 'longitude' => 47.0],
    'MV' => ['name' => 'Maldives', 'latitude' => 3.25, 'longitude' => 73.0],
    'MX' => ['name' => 'Mexico', 'latitude' => 23.0, 'longitude' => -102.0],
    'MH' => ['name' => 'Marshall Islands', 'latitude' => 9.0, 'longitude' => 168.0],
    'MK' => ['name' => 'North Macedonia', 'latitude' => 41.83, 'longitude' => 22.0],
    'ML' => ['name' => 'Mali', 'latitude' => 17.0, 'longitude' => -4.0],
    'MT' => ['name' => 'Malta', 'latitude' => 35.83, 'longitude' => 14.58],
    'MM' => ['name' => 'Myanmar', 'latitude' => 22.0, 'longitude' => 98.0],
    'ME' => ['name' => 'Montenegro', 'latitude' => 42.5, 'longitude' => 19.3],
    'MN' => ['name' => 'Mongolia', 'latitude' => 46.0, 'longitude' => 105.0],
    'MZ' => ['name' => 'Mozambique', 'latitude' => -18.25, 'longitude' => 35.0],
    'MR' => ['name' => 'Mauritania', 'latitude' => 20.0, 'longitude' => -12.0],
    'MU' => ['name' => 'Mauritius', 'latitude' => -20.28, 'longitude' => 57.55],
    'MW' => ['name' => 'Malawi', 'latitude' => -13.5, 'longitude' => 34.0],
    'MY' => ['name' => 'Malaysia', 'latitude' => 2.5, 'longitude' => 112.5],
    'NA' => ['name' => 'Namibia', 'latitude' => -22.0, 'longitude' => 17.0],
    'NE' => ['name' => 'Niger', 'latitude' => 16.0, 'longitude' => 8.0],
    'NG' => ['name' => 'Nigeria', 'latitude' => 10.0, 'longitude' => 8.0],
    'NI' => ['name' => 'Nicaragua', 'latitude' => 13.0, 'longitude' => -85.0],
    'NL' => ['name' => 'Netherlands', 'latitude' => 52.5, 'longitude' => 5.75],
    'NO' => ['name' => 'Norway', 'latitude' => 62.0, 'longitude' => 10.0],
    'NP' => ['name' => 'Nepal', 'latitude' => 28.0, 'longitude' => 84.0],
    'NR' => ['name' => 'Nauru', 'latitude' => -0.53, 'longitude' => 166.92],
    'NZ' => ['name' => 'New Zealand', 'latitude' => -41.0, 'longitude' => 174.0],
    'OM' => ['name' => 'Oman', 'latitude' => 21.0, 'longitude' => 57.0],
    'PK' => ['name' => 'Pakistan', 'latitude' => 30.0, 'longitude' => 70.0],
    'PS' => ['name' => 'Palestine', 'latitude' => 31.9, 'longitude' => 35.2],
    'PA' => ['name' => 'Panama', 'latitude' => 9.0, 'longitude' => -80.0],
    'PE' => ['name' => 'Peru', 'latitude' => -10.0, 'longitude' => -76.0],
    'PH' => ['name' => 'Philippines', 'latitude' => 13.0, 'longitude' => 122.0],
    'PW' => ['name' => 'Palau', 'latitude' => 7.5, 'longitude' => 134.5],
    'PG' => ['name' => 'Papua New Guinea', 'latitude' => -6.0, 'longitude' => 147.0],
    'PL' => ['name' => 'Poland', 'latitude' => 52.0, 'longitude' => 20.0],
    'KP' => ['name' => 'North Korea', 'latitude' => 40.0, 'longitude' => 127.0],
    'PT' => ['name' => 'Portugal', 'latitude' => 39.5, 'longitude' => -8.0],
    'PY' => ['name' => 'Paraguay', 'latitude' => -23.0, 'longitude' => -58.0],
    'QA' => ['name' => 'Qatar', 'latitude' => 25.5, 'longitude' => 51.25],
    'RO' => ['name' => 'Romania', 'latitude' => 46.0, 'longitude' => 25.0],
    'RU' => ['name' => 'Russia', 'latitude' => 60.0, 'longitude' => 100.0],
    'RW' => ['name' => 'Rwanda', 'latitude' => -2.0, 'longitude' => 30.0],
    'SA' => ['name' => 'Saudi Arabia', 'latitude' => 25.0, 'longitude' => 45.0],
    'SD' => ['name' => 'Sudan', 'latitude' => 15.0, 'longitude' => 30.0],
    'SN' => ['name' => 'Senegal', 'latitude' => 14.0, 'longitude' => -14.0],
    'SG' => ['name' => 'Singapore', 'latitude' => 1.37, 'longitude' => 103.8],
    'SB' => ['name' => 'Solomon Islands', 'latitude' => -8.0, 'longitude' => 159.0],
    'SL' => ['name' => 'Sierra Leone', 'latitude' => 8.5, 'longitude' => -11.5],
    'SV' => ['name' => 'El Salvador', 'latitude' => 13.83, 'longitude' => -88.92],
    'SM' => ['name' => 'San Marino', 'latitude' => 43.77, 'longitude' => 12.42],
    'SO' => ['name' => 'Somalia', 'latitude' => 10.0, 'longitude' => 49.0],
    'RS' => ['name' => 'Serbia', 'latitude' => 44.0, 'longitude' => 21.0],
    'SS' => ['name' => 'South Sudan', 'latitude' => 8.0, 'longitude' => 30.0],
    'ST' => ['name' => 'São Tomé and Príncipe', 'latitude' => 1.0, 'longitude' => 7.0],
    'SR' => ['name' => 'Suriname', 'latitude' => 4.0, 'longitude' => -56.0],
    'SK' => ['name' => 'Slovakia', 'latitude' => 48.67, 'longitude' => 19.5],
    'SI' => ['name' => 'Slovenia', 'latitude' => 46.0, 'longitude' => 15.0],
    'SE' => ['name' => 'Sweden', 'latitude' => 62.0, 'longitude' => 15.0],
    'SZ' => ['name' => 'Eswatini', 'latitude' => -26.5, 'longitude' => 31.5],
    'SC' => ['name' => 'Seychelles', 'latitude' => -4.58, 'longitude' => 55.67],
    'SY' => ['name' => 'Syria', 'latitude' => 35.0, 'longitude' => 38.0],
    'TD' => ['name' => 'Chad', 'latitude' => 15.0, 'longitude' => 19.0],
    'TG' => ['name' => 'Togo', 'latitude' => 8.0, 'longitude' => 1.17],
    'TH' => ['name' => 'Thailand', 'latitude' => 15.0, 'longitude' => 100.0],
    'TJ' => ['name' => 'Tajikistan', 'latitude' => 39.0, 'longitude' => 71.0],
    'TM' => ['name' => 'Turkmenistan', 'latitude' => 40.0, 'longitude' => 60.0],
    'TL' => ['name' => 'Timor-Leste', 'latitude' => -8.83, 'longitude' => 125.92],
    'TO' => ['name' => 'Tonga', 'latitude' => -20.0, 'longitude' => -175.0],
    'TT' => ['name' => 'Trinidad and Tobago', 'latitude' => 11.0, 'longitude' => -61.0],
    'TN' => ['name' => 'Tunisia', 'latitude' => 34.0, 'longitude' => 9.0],
    'TR' => ['name' => 'Turkey', 'latitude' => 39.0, 'longitude' => 35.0],
    'TV' => ['name' => 'Tuvalu', 'latitude' => -8.0, 'longitude' => 178.0],
    'TZ' => ['name' => 'Tanzania', 'latitude' => -6.0, 'longitude' => 35.0],
    'TW' => ['name' => 'Taiwan', 'latitude' => 23.5, 'longitude' => 121.0],
    'UG' => ['name' => 'Uganda', 'latitude' => 1.0, 'longitude' => 32.0],
    'UA' => ['name' => 'Ukraine', 'latitude' => 49.0, 'longitude' => 32.0],
    'UY' => ['name' => 'Uruguay', 'latitude' => -33.0, 'longitude' => -56.0],
    'US' => ['name' => 'United States', 'latitude' => 38.0, 'longitude' => -97.0],
    'UZ' => ['name' => 'Uzbekistan', 'latitude' => 41.0, 'longitude' => 64.0],
    'VA' => ['name' => 'Vatican City', 'latitude' => 41.9, 'longitude' => 12.45],
    'VC' => ['name' => 'Saint Vincent and the Grenadines', 'latitude' => 13.25, 'longitude' => -61.2],
    'VE' => ['name' => 'Venezuela', 'latitude' => 8.0, 'longitude' => -66.0],
    'VN' => ['name' => 'Vietnam', 'latitude' => 16.0, 'longitude' => 106.0],
    'VU' => ['name' => 'Vanuatu', 'latitude' => -16.0, 'longitude' => 167.0],
    'WS' => ['name' => 'Samoa', 'latitude' => -13.58, 'longitude' => -172.33],
    'YE' => ['name' => 'Yemen', 'latitude' => 15.0, 'longitude' => 48.0],
    'ZA' => ['name' => 'South Africa', 'latitude' => -29.0, 'longitude' => 24.0],
    'ZM' => ['name' => 'Zambia', 'latitude' => -15.0, 'longitude' => 30.0],
    'ZW' => ['name' => 'Zimbabwe', 'latitude' => -20.0, 'longitude' => 30.0],
];
