# Appwrite hacktoberfest contribution

Welcome to the Appwrite Hacktoberfest contribution! We appreciate your interest in contributing to our open-source project. Please read this carefully to understand how to get started and make your contributions count.

## Familiarize with the project

Before you start contributing, familiarize yourself with our project by reading the [main README](https://github.com/appwrite/appwrite/blob/main/README.md).

## Code of conduct

Please ensure that you always follow our [Code of Conduct](https://github.com/appwrite/awesome-appwrite/blob/master/CODE_OF_CONDUCT.md). We aim to maintain a respectful and inclusive community.

## Contributing guide

Please review our [Contributing Guide](https://github.com/appwrite/appwrite/blob/main/CONTRIBUTING.md) before contributing. It will help you learn about the architecture, instructions on how to update code, run tests, and submit a PR.

## Hacktoberfest contribution guidelines

To participate in Hacktoberfest with Appwrite, follow these guidelines:

1. **Valid issues**: To make your contribution count, please look for issues labeled with `hacktoberfest`. Only issues labeled with `hacktoberfest` will count as a valid contribution.

2. **Wait for issue assignment**: After you have identified an issue to work on, please wait for it to be assigned to you by our team. We assign issues on a first-come, first-serve basis.

3. **Knowing about labels**:  We do not have the `hacktoberfest` label in our repositories, but we use it on specific issues. For your pull request to be valid, our team will review and add the `hacktoberfest-accepted` label once it meets the criteria.

4. **Discuss new issues**: If you're interested in finding and adding new issues for Hacktoberfest, please discuss it with the team on our [Discord server](https://appwrite.io/discord) in the `#hacktoberfest` channel.

5. **Be patient with pull request reviews**: PR reviews may take up to 15 days due to the volume of contributions. However, we also host PR review parties every week where you can add your PRs for instant review.

6. **Regular updates**: If you've been assigned an issue, it's essential to share updates every 3 days. Failure to do so may result in being unassigned from the issue.

## Getting started

1. Fork the Appwrite repository you'd like to contribute to.

2. Clone your forked repository to your local machine.

   ```bash
   git clone https://github.com/your-username/repository-name.git
   ```

3. Create a new branch for your contribution.

   ```bash
   git checkout -b TYPE-ISSUE_ID-DESCRIPTION
   ```
4. Make your changes, commit them, and push them to your forked repository.

   ```bash
   git commit -m "Add your commit message here"
   git push origin TYPE-ISSUE_ID-DESCRIPTION
   ```
 
5. Create a Pull Request (PR) from your forked repository to the Appwrite repository. Be sure to reference the issue you are addressing in your PR description.

Thank you for contributing to Appwrite, and we look forward to your Hacktoberfest contributions! If you have any questions or need assistance, feel free to ask on our Discord server or in the issue discussion. Happy hacking!
