<?php

declare(strict_types=1);

/*
 * CoreShop
 *
 * This source file is available under two different licenses:
 *  - GNU General Public License version 3 (GPLv3)
 *  - CoreShop Commercial License (CCL)
 * Full copyright and license information is available in
 * LICENSE.md which is distributed with this source code.
 *
 * @copyright  Copyright (c) CoreShop GmbH (https://www.coreshop.com)
 * @license    https://www.coreshop.com/license     GPLv3 and CCL
 *
 */

namespace CoreShop\Bundle\ShippingBundle\Form\Type\Rule\Common;

use CoreShop\Bundle\ShippingBundle\Form\Type\ShippingRuleChoiceType;
use CoreShop\Component\Shipping\Model\ShippingRuleInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\CallbackTransformer;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Validator\Constraints\NotBlank;

final class ShippingRuleConfigurationType extends AbstractType
{
    /**
     * @param string[] $validationGroups
     */
    public function __construct(
        protected array $validationGroups,
    ) {
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('shippingRule', ShippingRuleChoiceType::class, [
                'constraints' => [
                    new NotBlank(['groups' => $this->validationGroups]),
                ],
            ])
        ;

        $builder->get('shippingRule')->addModelTransformer(new CallbackTransformer(
            function (mixed $shippingRule) {
                if ($shippingRule instanceof ShippingRuleInterface) {
                    return $shippingRule->getId();
                }

                return null;
            },
            function (mixed $shippingRule) {
                if ($shippingRule instanceof ShippingRuleInterface) {
                    return $shippingRule->getId();
                }

                return null;
            },
        ));
    }

    public function getBlockPrefix(): string
    {
        return 'coreshop_shipping_rule_condition_shipping_rule';
    }
}
