pimcore.registerNS('pimcore.object.gridcolumn.operator.coreshop_order_state');

pimcore.object.gridcolumn.operator.coreshop_order_state = Class.create(pimcore.object.gridcolumn.Abstract, {
    type: 'operator',
    class: 'coreshop_order_state',
    iconCls: 'coreshop_icon_operator_orderstate',
    defaultText: 'coreshop_operator_orderstate',
    group: 'coreshop',

    getConfigTreeNode: function (configAttributes) {
        if (configAttributes) {
            var nodeLabel = this.getNodeLabel(configAttributes);
            var node = {
                draggable: true,
                iconCls: this.iconCls,
                text: nodeLabel,
                configAttributes: configAttributes,
                isTarget: true,
                isChildAllowed: this.allowChild,
                expanded: true,
                leaf: false,
                expandable: false
            };
        } else {

            //For building up operator list
            var configAttributes = {type: this.type, class: this.class};

            var node = {
                draggable: true,
                iconCls: this.iconCls,
                text: t(this.defaultText),
                configAttributes: configAttributes,
                isTarget: true,
                leaf: true,
                isChildAllowed: this.allowChild
            };
        }
        node.isOperator = true;
        return node;
    },


    getCopyNode: function (source) {
        var copy = source.createNode({
            iconCls: this.iconCls,
            text: source.data.text,
            isTarget: true,
            leaf: false,
            expandable: false,
            isOperator: true,
            isChildAllowed: this.allowChild,
            configAttributes: {
                label: source.data.text,
                type: this.type,
                class: this.class
            }
        });

        return copy;
    },

    getConfigDialog: function (node) {
        this.node = node;

        this.textField = new Ext.form.TextField({
            fieldLabel: t('label'),
            length: 255,
            width: 200,
            value: this.node.data.configAttributes.label
        });

        var options = {
            fieldLabel: t('coreshop_operator_orderstate_highlight'),
            width: 200,
            padding: 10,
            value: this.node.data.configAttributes.highlightLabel
        };

        this.highlightLabelField = new Ext.form.Checkbox(options);

        this.configPanel = new Ext.Panel({
            layout: 'form',
            bodyStyle: 'padding: 10px;',
            items: [this.textField, this.highlightLabelField],
            buttons: [{
                text: t('apply'),
                iconCls: 'pimcore_icon_apply',
                handler: function () {
                    this.commitData();
                }.bind(this)
            }]
        });

        this.window = new Ext.Window({
            width: 400,
            height: 200,
            modal: true,
            title: t('localeswitcher_operator_settings'),
            layout: 'fit',
            items: [this.configPanel]
        });

        this.window.show();
        return this.window;
    },

    commitData: function () {
        this.node.data.configAttributes.label = this.textField.getValue();
        this.node.data.configAttributes.highlightLabel = this.highlightLabelField.getValue();

        var nodeLabel = this.getNodeLabel(this.node.data.configAttributes);
        this.node.set('text', nodeLabel);
        this.node.set('isOperator', true);

        this.window.close();
    },

    allowChild: function (targetNode, dropNode) {
        if (targetNode.childNodes.length > 0) {
            return false;
        }
        return true;
    },

    getNodeLabel: function (configAttributes) {
        return configAttributes.label;
    }
});
