# SPDX-FileCopyrightText: 2024 Google LLC
# SPDX-License-Identifier: Apache-2.0

""" Plot the stats contained in the .csv file generated by the test_kraepelin_algorithm
unit test (when STATS_FILE_NAME is defined).
"""

import argparse
import csv
import datetime
import json
import logging
import os
import struct
import sys
import matplotlib.pyplot as pyplot


##################################################################################################
if __name__ == '__main__':
    values = [73, 75, 39, 41, 90, 128, 105, 156, 212, 23, 92, 78, 57, 46, 44, 52, 31, 26, 23, 13,
              22, 11, 20, 25, 12, 13, 10, 25, 17, 23, 16, 15, 12, 20, 12, 21, 40, 38, 20, 21, 21,
              41, 52, 35, 33, 23, 26, 21, 32, 23, 20, 16, 24, 23, 40, 46, 89, 152, 88, 33, 53, 11,
              36, 45]

    x_axis = range(64)
    x_labels = [str(x) for x in x_axis]

    pyplot.bar(x_axis, values, align='center')
    pyplot.xticks(x_axis, x_labels, rotation='vertical')
    pyplot.xlim(x_axis[0] - .5, x_axis[-1] + .5)
    pyplot.show()
