/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */

#include <stdint.h>
#include <string.h>

#include "services/normal/activity/activity_algorithm.h"
#include "util/size.h"


// ----------------------------------------------------------------
// Sample captured at: 2015-08-18 22:15:00 local, 2015-08-19 05:15:00 GMT
// According to Misfit:
//  Total sleep from 10:42 pm to 4:06am (325 minutes)
//  Deep sleep 182 min.
//  Breakdown (very approximate):
//   10:15 - 10:42 awake (27 min)
//   10:42 - 10:50 light (8 min)
//   10:50 - 11:20 deep (30 min)
//   11:20 - 11:30 light (10 min)
//   11:30 - 11:40 deep (10 min)
//   11:40 - 12:30 light (50 min)
//   12:30 - 2:45 deep (135 min)
//    2:45 - 3:15 light (30 min)
//    3:15 - 3:35 deep (20 min)
//    3:35 - 4:06 light (30 min)
//    4:06 - 5:00 awake
AlgMinuteFileSampleV5 *activity_sample_sleep_v1_1(int *len) {
  // list of: {steps, orientation, vmc}
  static AlgMinuteFileSampleV5 samples[] = {
    {0, 0x8f, 6},
    {0, 0x8f, 0},
    {0, 0x8f, 0},
    {0, 0x8f, 0},
    {0, 0x8f, 0},
    {0, 0x8f, 0},
    {0, 0x8f, 4},
    {0, 0x8f, 0},
    {0, 0x8f, 0},
    {0, 0x65, 47},
    {0, 0x44, 5},
    {8, 0x63, 36},
    {10, 0x52, 68},
    {8, 0x53, 61},
    {0, 0x63, 83},
    // 15: Local time: 10:30:00 PM
    {0, 0x64, 107},
    {0, 0x79, 35},
    {0, 0x78, 0},
    {0, 0x78, 37},
    {0, 0x68, 4},
    {0, 0x68, 0},
    {0, 0x68, 0},
    {0, 0x69, 17},
    {0, 0x69, 0},
    {0, 0x68, 10},
    {0, 0x67, 0},
    {0, 0x68, 12},
    {0, 0x68, 0},    // start light
    {0, 0x68, 0},
    {0, 0x67, 41},
    // 30: Local time: 10:45:00 PM
    {0, 0x64, 26},
    {0, 0x54, 0},
    {0, 0x54, 12},
    {0, 0x64, 0},
    {0, 0x64, 0},
    {0, 0x64, 0},    // start deep (30 min)
    {0, 0x64, 0},
    {0, 0x64, 0},
    {0, 0x64, 0},
    {0, 0x64, 0},
    {0, 0x54, 12},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    // 45: Local time: 11:00:00 PM
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    // 60: Local time: 11:15:00 PM
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},    // start light
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 19},
    {0, 0x54, 0},
    {0, 0x54, 6},
    {0, 0x64, 0},
    {0, 0x64, 0},
    {0, 0x64, 0},
    {0, 0x64, 0},
    {0, 0x64, 0},
    // 75: Local time: 11:30:00 PM
    {0, 0x64, 0},     // start deep
    {0, 0x64, 0},
    {0, 0x64, 0},
    {0, 0x64, 0},
    {0, 0x64, 0},
    {0, 0x64, 0},
    {0, 0x64, 0},
    {0, 0x64, 0},
    {0, 0x64, 0},
    {0, 0x64, 0},     // start light
    {0, 0x64, 0},
    {0, 0x64, 0},
    {0, 0x54, 16},
    {0, 0x64, 0},
    {0, 0x64, 0},
    // 90: Local time: 11:45:00 PM
    {0, 0x64, 0},
    {0, 0x54, 2},
    {0, 0x54, 0},
    {0, 0x54, 7},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 14},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x64, 16},
    {0, 0x64, 0},
    {0, 0x54, 13},
    {0, 0x44, 0},
    // 105: Local time: 12:00:00 AM
    {0, 0x44, 0},
    {0, 0x44, 0},
    {0, 0x44, 8},
    {0, 0x44, 0},
    {0, 0x44, 0},
    {0, 0x44, 0},
    {0, 0x44, 0},
    {0, 0x44, 0},
    {0, 0x44, 0},
    {0, 0x44, 0},
    {0, 0x44, 6},
    {0, 0x44, 0},
    {0, 0x44, 0},
    {0, 0x44, 0},
    {0, 0x44, 0},
    // 120: Local time: 12:15:00 AM
    {0, 0x44, 2},
    {0, 0x44, 8},
    {0, 0x44, 0},
    {0, 0x44, 12},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x54, 0},
    {0, 0x64, 28},
    {0, 0x65, 28},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    // 135: Local time: 12:30:00 AM
    {0, 0x16, 0},   // start deep
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    // 150: Local time: 12:45:00 AM
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 18},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    // 165: Local time: 01:00:00 AM
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    // 180: Local time: 01:15:00 AM
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x16, 0},
    {0, 0x36, 14},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    // 195: Local time: 01:30:00 AM
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    // 210: Local time: 01:45:00 AM
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    // 225: Local time: 02:00:00 AM
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    // 240: Local time: 02:15:00 AM
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    // 255: Local time: 02:30:00 AM
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x55, 18},
    {0, 0x15, 0},
    {0, 0x15, 0},
    {0, 0x15, 0},
    {0, 0x15, 0},
    {0, 0x15, 5},
    // 270: Local time: 02:45:00 AM
    {0, 0x26, 26},  // start light
    {0, 0x26, 0},
    {0, 0x26, 0},
    {0, 0x26, 0},
    {0, 0x26, 0},
    {0, 0x26, 0},
    {0, 0x26, 0},
    {0, 0x26, 0},
    {0, 0x26, 0},
    {0, 0x26, 0},
    {0, 0x26, 0},
    {0, 0x26, 0},
    {0, 0x35, 20},
    {0, 0x55, 0},
    {0, 0x55, 0},
    // 285: Local time: 03:00:00 AM
    {0, 0x55, 0},
    {0, 0x55, 0},
    {0, 0x55, 0},
    {0, 0x55, 0},
    {0, 0x55, 0},
    {0, 0x65, 9},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    // 300: Local time: 03:15:00 AM
    {0, 0x65, 0},  // start deep
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    // 315: Local time: 03:30:00 AM
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},  // start light
    {0, 0x65, 0},
    {0, 0x66, 17},
    {0, 0x2a, 0},
    {0, 0x2a, 0},
    {0, 0x2a, 0},
    {0, 0x2a, 0},
    {0, 0x2b, 0},
    {0, 0x2a, 0},
    {0, 0x2a, 0},
    {0, 0x2a, 0},
    // 330: Local time: 03:45:00 AM
    {0, 0x2a, 0},
    {0, 0x57, 19},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x65, 0},
    {0, 0x66, 20},
    {0, 0x77, 8},
    {0, 0x66, 6},
    {0, 0x67, 18},
    {0, 0x68, 0},
    {0, 0x68, 11},
    {0, 0x23, 44},
    {0, 0x42, 62},
    {0, 0x64, 0},
    {0, 0x64, 0},
    // 345: Local time: 04:00:00 AM
    {0, 0x64, 0},
    {0, 0x64, 0},
    {0, 0x64, 0},
    {0, 0x64, 0},
    {0, 0x64, 0},
    {0, 0x64, 0},   // wake up
    {0, 0x64, 0},
    {0, 0x64, 0},
    {0, 0x64, 0},
    {0, 0x64, 7},
    {0, 0x63, 29},
    {0, 0x64, 0},
    {0, 0x7f, 37},
    {0, 0x82, 21},
    {0, 0x75, 17},
    // 360: Local time: 04:15:00 AM
    {12, 0x43, 63},
    {31, 0x32, 55},
    {0, 0x63, 40},
    {0, 0x71, 42},
    {0, 0x7f, 0},
    {0, 0x7f, 0},
    {0, 0x7f, 0},
    {0, 0x7f, 0},
    {0, 0x7f, 0},
    {0, 0x7f, 0},
    {0, 0x7f, 0},
    {0, 0x70, 42},
    {0, 0x65, 20},
    {0, 0x77, 17},
    {0, 0x77, 26},
    // 375: Local time: 04:30:00 AM
    {0, 0x77, 18},
    {0, 0x67, 22},
    {0, 0x65, 30},
    {0, 0x68, 36},
    {0, 0x68, 14},
    {0, 0x68, 18},
    {0, 0x76, 30},
    {0, 0x75, 30},
    {0, 0x65, 31},
    {0, 0x65, 38},
    {9, 0x70, 48},
    {0, 0x71, 0},
    {0, 0x6f, 30},
    {0, 0x6f, 4},
    {0, 0x6f, 0},
    // 390: Local time: 04:45:00 AM
    {0, 0x6f, 0},
    {0, 0x6f, 0},
    {0, 0x6f, 0},
    {0, 0x6f, 0},
    {0, 0x6f, 0},
    {0, 0x6f, 0},
    {0, 0x6f, 2},
    {0, 0x6f, 0},
    {0, 0x6f, 0},
    {0, 0x6f, 0},
    {0, 0x64, 48},
    {0, 0x55, 0},
    {0, 0x55, 36},
    {0, 0x67, 32},
    {0, 0x55, 0},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

