/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */




// ----------------------------------------------------------------
// Sample captured: 2015-10-16 17:11:10 local
AccelRawData *activity_sample_walk_100_pbl_28394_1(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_28394_1
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 60
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -96, -24, -1008},
    { -184, -80, -1000},
    { -184, -136, -976},
    { -168, -72, -976},
    { -128, -128, -1032},
    { -184, -8, -992},
    { -120, -200, -952},
    { -264, -200, -968},
    { -272, -136, -1008},
    { -168, -232, -1024},
    { -144, -16, -1088},
    { -208, -272, -1024},
    { -104, -232, -1072},
    { -64, -272, -1032},
    { -200, -248, -1048},
    { -48, -288, -1024},
    { -40, -248, -1016},
    { 104, -296, -960},
    { 48, -344, -936},
    { 88, -344, -912},
    { 184, -336, -912},
    { 64, -464, -832},
    { 72, -440, -856},
    { 144, -424, -848},
    { 96, -456, -888},
    // 1 seconds
    { 96, -424, -896},
    { 96, -464, -880},
    { 32, -488, -920},
    { 64, -488, -904},
    { 96, -448, -904},
    { 56, -504, -896},
    { 64, -504, -880},
    { 96, -432, -904},
    { 72, -480, -904},
    { 72, -480, -888},
    { 80, -480, -896},
    { 64, -560, -896},
    { 248, -440, -912},
    { 168, -552, -1016},
    { 80, -240, -968},
    { 32, -368, -968},
    { 72, -280, -952},
    { 128, -304, -984},
    { 144, -328, -992},
    { 176, -248, -928},
    { 200, -224, -968},
    { 168, -240, -960},
    { 128, -216, -944},
    { 112, -216, -952},
    { 128, -280, -936},
    // 2 seconds
    { 168, -72, -784},
    { 168, 40, -776},
    { 176, 280, -608},
    { 152, 616, -504},
    { 72, 720, -504},
    { 24, 800, -408},
    { 80, 640, -296},
    { -72, 720, -80},
    { -80, 912, 32},
    { -136, 936, 296},
    { -144, 960, 432},
    { -72, 864, 544},
    { -88, 840, 520},
    { -16, 744, 520},
    { -24, 744, 528},
    { 16, 760, 456},
    { 24, 816, 560},
    { 16, 904, 664},
    { 8, 1000, 632},
    { -40, 968, 664},
    { -88, 984, 600},
    { -136, 832, 560},
    { -192, 872, 464},
    { -184, 752, 448},
    { -240, 800, 352},
    // 3 seconds
    { -240, 760, 416},
    { -208, 688, 392},
    { -192, 656, 368},
    { -200, 560, 312},
    { -224, 560, 232},
    { -192, 544, 160},
    { -288, 472, 0},
    { -576, 384, 0},
    { -1176, 192, -56},
    { -2312, 272, -712},
    { -1984, 336, -264},
    { -1392, 240, -216},
    { -1048, 168, -280},
    { -1112, 184, -48},
    { -944, 216, 0},
    { -792, 248, 72},
    { -704, 248, 80},
    { -672, 248, 40},
    { -640, 272, -48},
    { -744, 248, -64},
    { -936, 304, -200},
    { -1168, 112, -224},
    { -1224, 112, -152},
    { -1296, 472, -416},
    { -1544, 608, -240},
    // 4 seconds
    { -1112, 320, -352},
    { -1200, 368, -296},
    { -1352, 344, -40},
    { -1328, 144, 48},
    { -1000, 264, -48},
    { -920, 40, -24},
    { -888, 176, -32},
    { -912, 232, 16},
    { -816, 176, 40},
    { -720, 152, 24},
    { -848, 128, 16},
    { -1120, 160, -24},
    { -1432, 200, -112},
    { -1432, 40, -136},
    { -1040, 48, -392},
    { -848, 16, -456},
    { -1184, 32, -312},
    { -1336, 64, -240},
    { -1224, 120, -200},
    { -1056, 248, -112},
    { -960, 368, -144},
    { -896, 392, -184},
    { -824, 328, -264},
    { -776, 336, -288},
    { -880, 528, -320},
    // 5 seconds
    { -1144, 512, -336},
    { -1680, 712, -304},
    { -1688, 352, -192},
    { -1544, 144, -200},
    { -1544, 176, -200},
    { -1680, 272, -104},
    { -1552, 240, -16},
    { -1240, 128, 40},
    { -1064, 160, 8},
    { -1024, 56, -8},
    { -952, 24, 16},
    { -816, 40, 24},
    { -736, 56, 32},
    { -736, 48, 88},
    { -656, 0, 64},
    { -864, 72, -56},
    { -1224, 120, -288},
    { -1000, 216, -344},
    { -1456, 32, -664},
    { -1656, -328, -264},
    { -1920, -224, -376},
    { -1528, 368, -160},
    { -1168, 480, -328},
    { -1056, 344, -248},
    { -1104, 280, -256},
    // 6 seconds
    { -1032, 224, -248},
    { -864, 264, -352},
    { -1008, 472, -464},
    { -896, 512, -504},
    { -1264, 136, -392},
    { -1464, 256, -248},
    { -1192, 368, -360},
    { -1592, 360, -240},
    { -1856, 232, -112},
    { -1632, 176, -104},
    { -1504, 184, -48},
    { -1528, 184, -56},
    { -1384, 168, 40},
    { -1184, 152, 96},
    { -952, 56, 40},
    { -888, 40, 104},
    { -744, -480, 536},
    { -408, -664, 120},
    { -1176, 32, -224},
    { -1456, -56, -224},
    { -1616, -120, -232},
    { -1672, -392, -248},
    { -1504, -232, -416},
    { -1304, 120, -280},
    { -1136, 248, -216},
    // 7 seconds
    { -1080, 272, -304},
    { -1168, 200, -240},
    { -1176, 272, -584},
    { -928, 168, -592},
    { -944, 56, -608},
    { -1056, 16, -568},
    { -1304, 224, -624},
    { -1472, 344, -552},
    { -1312, 240, -408},
    { -1592, 208, -296},
    { -1864, 200, -128},
    { -1456, 136, -80},
    { -1328, 80, -16},
    { -1320, 88, 0},
    { -1312, 64, 8},
    { -1168, 32, 56},
    { -1064, 56, 88},
    { -1008, 40, 120},
    { -856, 48, 112},
    { -720, 128, 152},
    { -840, 168, -128},
    { -888, 1096, -504},
    { -960, 2984, -904},
    { -816, 1480, -456},
    { -328, 1488, -536},
    // 8 seconds
    { -128, 536, -304},
    { 16, 112, -160},
    { 40, -32, 24},
    { 72, -144, 120},
    { 72, -192, 88},
    { 64, 0, 176},
    { 16, -72, 192},
    { -128, -8, 296},
    { -512, 376, -104},
    { -816, 624, 1304},
    { -2120, 4000, 1528},
    { -536, 2664, 1344},
    { 448, 1808, 656},
    { -136, 1376, 552},
    { -200, 736, 312},
    { -328, 600, 288},
    { -320, 376, 208},
    { -288, 216, 184},
    { -264, 184, 136},
    { -256, 104, 176},
    { -296, -80, 256},
    { -480, 240, 120},
    { -752, 568, 128},
    { -1024, 1016, 96},
    { -1256, 1160, 48},
    // 9 seconds
    { -1480, 1320, -776},
    { -1176, 1456, -880},
    { -832, 1168, -784},
    { -584, 992, -616},
    { -208, 912, -280},
    { 40, 832, -40},
    { 48, 1168, 0},
    { -96, 856, 176},
    { -128, 616, 24},
    { -72, 816, 256},
    { -56, 848, 408},
    { -96, 976, 480},
    { -104, 1064, 648},
    { -176, 992, 680},
    { -184, 936, 568},
    { -64, 824, 568},
    { 0, 624, 568},
    { -8, 856, 336},
    { 120, 832, 168},
    { 200, 632, 88},
    { 168, 504, 0},
    { 200, 576, -136},
    { 248, 616, -168},
    { 224, 880, -264},
    { 104, 800, -256},
    // 10 seconds
    { 192, 960, -384},
    { 184, 1168, -376},
    { 40, 1104, -344},
    { 64, 984, -408},
    { 96, 760, -304},
    { 56, 688, -272},
    { 88, 576, -240},
    { 144, 512, -216},
    { 208, 552, -216},
    { 304, 592, -232},
    { 320, 704, -216},
    { 344, 880, -208},
    { 304, 1248, -184},
    { 368, 1408, -144},
    { 200, 1560, -104},
    { 144, 1120, -96},
    { 168, 1048, -40},
    { 128, 992, -24},
    { 48, 840, -32},
    { 24, 712, -104},
    { 48, 544, -104},
    { 72, 464, -144},
    { 64, 584, -200},
    { 72, 632, -216},
    { 120, 792, -272},
    // 11 seconds
    { 16, 896, -240},
    { 216, 1032, -312},
    { 80, 1480, -224},
    { 0, 1232, -304},
    { 40, 968, -304},
    { 88, 840, -232},
    { 72, 696, -192},
    { 96, 592, -144},
    { 152, 568, -112},
    { 160, 584, -112},
    { 200, 624, -104},
    { 216, 736, -144},
    { 272, 872, -176},
    { 296, 1152, -184},
    { 352, 1176, -192},
    { 360, 1456, -144},
    { 256, 1288, -136},
    { 224, 1168, -80},
    { 168, 1144, -56},
    { 72, 992, -80},
    { 0, 712, -96},
    { 24, 608, -136},
    { 32, 488, -128},
    { 32, 416, -136},
    { 56, 544, -200},
    // 12 seconds
    { 80, 704, -216},
    { 24, 800, -288},
    { 184, 920, -416},
    { 184, 1136, -320},
    { 128, 1352, -456},
    { 120, 1144, -408},
    { 96, 912, -384},
    { 104, 800, -304},
    { 104, 656, -272},
    { 144, 536, -208},
    { 168, 576, -168},
    { 232, 568, -144},
    { 264, 656, -160},
    { 320, 776, -160},
    { 360, 1024, -160},
    { 312, 1176, -136},
    { 400, 1392, -136},
    { 264, 1336, -104},
    { 184, 1008, -96},
    { 224, 1016, -48},
    { 176, 1032, -72},
    { 80, 792, -120},
    { 48, 560, -152},
    { 56, 456, -192},
    { 80, 336, -176},
    // 13 seconds
    { 72, 240, -184},
    { 24, 208, -184},
    { -104, 256, -208},
    { -480, 240, -200},
    { -904, 176, -136},
    { -1896, 40, -72},
    { -2976, 176, 192},
    { -3080, 1736, -288},
    { -1344, 1432, -160},
    { -1440, 1360, 224},
    { -896, 1184, 272},
    { -568, 656, 360},
    { -224, 384, 328},
    { -104, 128, 320},
    { -32, 80, 288},
    { 16, 32, 296},
    { 8, -56, 360},
    { -272, 240, 536},
    { -616, 240, 464},
    { -1512, 712, 696},
    { -2376, 2032, 624},
    { -1232, 784, 976},
    { -1232, 1224, 344},
    { -1368, 816, 296},
    { -1112, 568, 384},
    // 14 seconds
    { -1024, 576, 440},
    { -976, 616, 464},
    { -848, 368, 432},
    { -736, 504, 200},
    { -592, 640, 64},
    { -424, 552, 24},
    { -280, 576, -216},
    { -112, 816, -264},
    { 88, 984, -280},
    { -16, 1304, -544},
    { 24, 912, -480},
    { 40, 544, -496},
    { 272, 528, -352},
    { 368, 416, -136},
    { 368, 216, -56},
    { 376, 416, 792},
    { 216, 736, 192},
    { 288, 752, 112},
    { 408, 1088, 192},
    { 336, 1168, 24},
    { 648, 936, 384},
    { 472, 1064, 312},
    { 416, 912, 504},
    { 416, 656, 536},
    { 416, 776, 552},
    // 15 seconds
    { 328, 584, 448},
    { 360, 496, 304},
    { 384, 456, 256},
    { 408, 544, 56},
    { 392, 560, 216},
    { 464, 616, 360},
    { 552, 776, 416},
    { 568, 832, 448},
    { 680, 760, 528},
    { 688, 904, 616},
    { 368, 904, 568},
    { 304, 648, 648},
    { 336, 600, 648},
    { 384, 504, 560},
    { 384, 472, 424},
    { 448, 328, 344},
    { 432, 344, 312},
    { 448, 336, 248},
    { 456, 456, 336},
    { 400, 472, 368},
    { 496, 712, 440},
    { 472, 640, 712},
    { 696, 640, 936},
    { 640, 720, 888},
    { 600, 496, 664},
    // 16 seconds
    { 632, 448, 672},
    { 584, 480, 704},
    { 472, 560, 488},
    { 312, 448, 336},
    { 312, 592, 128},
    { 304, 496, 48},
    { 448, 608, -24},
    { 296, 584, 96},
    { 320, 672, 48},
    { 400, 768, 144},
    { 176, 840, -168},
    { 120, 408, 544},
    { -296, 1616, 616},
    { -400, 1480, 800},
    { -368, 1200, 720},
    { -272, 768, 448},
    { -160, 560, 248},
    { -24, 616, 264},
    { 0, 568, 256},
    { 16, 512, 344},
    { 48, 656, 376},
    { -8, 736, 200},
    { 72, 472, 936},
    { 8, 1304, 584},
    { 16, 472, 720},
    // 17 seconds
    { 0, 1128, 944},
    { -48, 824, 880},
    { -88, 664, 536},
    { -56, 880, 880},
    { -216, 736, 760},
    { -120, 864, 624},
    { -200, 928, 176},
    { -40, 600, 192},
    { -88, 712, 320},
    { -24, 536, 280},
    { -32, 488, 192},
    { -72, 568, 272},
    { -176, 896, 600},
    { -288, 1168, 480},
    { -216, 1192, 712},
    { -184, 1232, 744},
    { -224, 1080, 376},
    { -216, 864, 368},
    { -320, 768, 304},
    { -288, 576, 296},
    { -192, 440, 280},
    { -112, 344, 304},
    { -104, 272, 344},
    { -144, 280, 288},
    { -152, 128, 304},
    // 18 seconds
    { -248, 592, 456},
    { -568, 968, 776},
    { -960, 1312, 1440},
    { -1240, 1496, 1320},
    { -816, 1264, 1192},
    { -496, 984, 840},
    { -312, 600, 720},
    { -184, 576, 624},
    { -168, 320, 528},
    { -136, 296, 416},
    { -128, 352, 376},
    { -136, 72, 392},
    { -224, 96, 264},
    { -344, 248, 376},
    { -592, 136, 392},
    { -880, 480, 384},
    { -1232, 440, 280},
    { -1880, 544, 96},
    { -1944, 800, -168},
    { -1232, 520, -704},
    { -1184, 168, -680},
    { -1320, -248, -144},
    { -1112, -168, -56},
    { -888, 152, -176},
    { -696, 184, -192},
    // 19 seconds
    { -752, 264, -152},
    { -904, 240, -152},
    { -808, 208, -176},
    { -952, 424, -256},
    { -1176, 568, -344},
    { -1264, 608, -320},
    { -1736, 640, -432},
    { -1352, 432, -368},
    { -1136, 344, -384},
    { -1360, 360, -256},
    { -1592, 392, -184},
    { -1520, 280, 0},
    { -1360, 208, 72},
    { -1184, 104, 72},
    { -1040, 48, 80},
    { -888, 56, 104},
    { -760, 96, 32},
    { -752, 112, 40},
    { -816, 56, 80},
    { -808, 96, 16},
    { -1120, 216, -272},
    { -1104, 256, -448},
    { -1168, 8, -368},
    { -1744, -88, -504},
    { -1784, -56, -320},
    // 20 seconds
    { -1448, 56, -208},
    { -1072, 280, -280},
    { -928, 208, -192},
    { -1088, 320, -32},
    { -1048, 224, -176},
    { -808, 232, -184},
    { -1104, 432, -264},
    { -1032, 352, -200},
    { -1352, 680, -344},
    { -1304, 392, -304},
    { -952, 288, -384},
    { -1312, 312, -304},
    { -1568, 256, -312},
    { -1424, 224, -280},
    { -1280, 120, -176},
    { -1200, 40, -64},
    { -1224, 56, -80},
    { -1144, 64, -80},
    { -1024, 96, -72},
    { -1096, 72, -24},
    { -1048, -56, 56},
    { -784, -88, -48},
    { -1064, 16, -152},
    { -1176, 72, -288},
    { -1024, 48, -384},
    // 21 seconds
    { -1240, -16, -368},
    { -1376, -24, -336},
    { -1240, -16, -216},
    { -1040, 112, -152},
    { -968, 264, -136},
    { -1072, 304, -168},
    { -1184, 376, -200},
    { -1032, 352, -216},
    { -1040, 344, -248},
    { -1128, 384, -256},
    { -1424, 344, -320},
    { -1440, 240, -248},
    { -1128, 272, -312},
    { -1320, 264, -240},
    { -1344, 224, -168},
    { -1144, 168, -192},
    { -992, -24, -152},
    { -1040, 8, -168},
    { -1104, 88, -120},
    { -1088, 96, -96},
    { -1040, 112, -104},
    { -1208, 128, 0},
    { -1104, -72, 72},
    { -1152, 0, 24},
    { -1168, 200, -272},
    // 22 seconds
    { -1136, 72, -448},
    { -1256, -24, -272},
    { -1200, -208, -176},
    { -1096, -24, -272},
    { -936, 144, -256},
    { -840, 200, -168},
    { -960, 184, -112},
    { -1048, 296, -120},
    { -1024, 224, -184},
    { -1112, 256, -232},
    { -1296, 488, -264},
    { -1240, 400, -320},
    { -1472, 440, -288},
    { -1144, 272, -264},
    { -1000, 264, -256},
    { -1248, 288, -128},
    { -1320, 232, -96},
    { -1208, 216, -96},
    { -1072, 136, -40},
    { -1056, 80, -24},
    { -1032, 24, -8},
    { -1008, 48, -24},
    { -912, 48, 8},
    { -896, 56, 24},
    { -1016, 96, 24},
    // 23 seconds
    { -1056, 120, -72},
    { -1304, 112, -168},
    { -1368, 72, -360},
    { -1056, 168, -456},
    { -1120, -336, -416},
    { -1200, -112, -328},
    { -1088, 32, -280},
    { -896, 152, -168},
    { -856, 184, -152},
    { -920, 240, -104},
    { -960, 224, -136},
    { -872, 216, -152},
    { -1000, 264, -168},
    { -1344, 424, -48},
    { -1400, 616, -96},
    { -1512, 480, -88},
    { -1000, 408, -208},
    { -1208, 400, -184},
    { -1248, 296, -120},
    { -1096, 264, -104},
    { -1008, 208, -104},
    { -984, 96, -16},
    { -1040, 96, 8},
    { -1016, 128, 16},
    { -904, 80, 0},
    // 24 seconds
    { -808, 72, 8},
    { -816, 72, 32},
    { -1016, 600, -208},
    { -1072, 1056, -32},
    { -1496, 1568, -16},
    { -808, 1800, -104},
    { -720, 1232, 0},
    { -544, 896, 64},
    { -360, 504, 16},
    { -184, 200, 8},
    { -48, -40, 40},
    { -16, -48, 80},
    { -16, -80, 80},
    { -56, -64, 104},
    { -112, 0, 104},
    { -192, 64, 312},
    { -688, 192, 136},
    { -1424, 720, 832},
    { -2368, 1776, 1712},
    { -1080, 2304, 1496},
    { -496, 1880, 992},
    { -648, 1008, 904},
    { -408, 880, 712},
    { -408, 704, 664},
    { -384, 472, 504},
    // 25 seconds
    { -368, 320, 392},
    { -384, 192, 368},
    { -392, 184, 280},
    { -416, 208, 248},
    { -544, 56, 248},
    { -808, 208, 248},
    { -1248, 280, 352},
    { -1432, 808, 232},
    { -1304, 912, 120},
    { -1296, 664, 48},
    { -1352, 624, 56},
    { -1224, 544, 32},
    { -960, 504, 80},
    { -744, 240, 56},
    { -840, 312, 104},
    { -968, 360, 80},
    { -904, 432, -8},
    { -944, 592, -16},
    { -1168, 656, 112},
    { -1024, 664, 112},
    { -1504, 824, -32},
    { -1272, 696, -16},
    { -1344, 600, -176},
    { -1464, 376, -88},
    { -1472, 528, -16},
    // 26 seconds
    { -1536, 616, -16},
    { -1496, 616, -16},
    { -1560, 1096, -56},
    { -1552, 936, -24},
    { -1288, 1136, -280},
    { -1112, 1000, -352},
    { -680, 536, -496},
    { -264, 344, -520},
    { 56, -192, -464},
    { 424, -344, -528},
    { 320, -208, -552},
    { 304, -408, -408},
    { 184, -480, -344},
    { 320, -552, -224},
    { 344, -672, -152},
    { 336, -632, -264},
    { 544, -568, -360},
    { 552, -512, -496},
    { 608, -648, -528},
    { 624, -856, -624},
    { 664, -560, -776},
    { 888, -696, -768},
    { 832, -888, -536},
    { 824, -568, -480},
    { 792, -736, -416},
    // 27 seconds
    { 640, -656, -496},
    { 584, -608, -528},
    { 432, -664, -472},
    { 344, -576, -288},
    { 312, -608, -176},
    { 296, -544, -320},
    { 352, -840, -256},
    { 408, -920, -288},
    { 296, -976, -448},
    { 536, -1040, -376},
    { 504, -1280, -320},
    { 688, -1144, -624},
    { 528, -872, -624},
    { 344, -760, -472},
    { 272, -728, -432},
    { 288, -776, -344},
    { 328, -728, -200},
    { 376, -848, -248},
    { 336, -800, 0},
    { 296, -888, -136},
    { 376, -728, -168},
    { 320, -976, -424},
    { 472, -912, -488},
    { 648, -1240, -472},
    { 512, -1312, -168},
    // 28 seconds
    { 464, -1200, -160},
    { 576, -984, -328},
    { 464, -784, -592},
    { 368, -736, -432},
    { 176, -888, -136},
    { 200, -912, -432},
    { 208, -584, -296},
    { 272, -672, -152},
    { 328, -560, -184},
    { 416, -608, 48},
    { 64, -808, -280},
    { -112, -1232, -376},
    { -72, -1224, -616},
    { -40, -912, -616},
    { -216, -496, -512},
    { -400, -104, -472},
    { -496, 136, -432},
    { -600, 240, -272},
    { -720, 552, -592},
    { -752, 552, -392},
    { -1064, 792, -552},
    { -1232, 696, -432},
    { -1448, 872, -352},
    { -1920, 768, -288},
    { -2568, 928, -168},
    // 29 seconds
    { -1808, 1144, 24},
    { -1368, 712, -528},
    { -1272, 696, -232},
    { -752, 464, -240},
    { -992, 368, -176},
    { -1088, 688, -136},
    { -872, 488, -104},
    { -808, 512, 24},
    { -880, 440, 64},
    { -960, 320, 152},
    { -1072, 416, 168},
    { -1216, 344, 264},
    { -1320, 368, 288},
    { -1240, 808, 96},
    { -1544, 936, 320},
    { -1344, 1488, 160},
    { -760, 1416, -80},
    { -648, 1192, -24},
    { -488, 704, -64},
    { -248, 144, -24},
    { -136, 168, -176},
    { -96, -80, -32},
    { -24, -104, -8},
    { -8, -48, -8},
    { -8, -56, 48},
    // 30 seconds
    { -16, 32, 224},
    { -168, 96, 104},
    { -760, 560, 232},
    { -1856, 1112, 1664},
    { -2904, 3560, 2176},
    { -472, 1040, 1768},
    { -704, 1480, 720},
    { -232, 600, 704},
    { -288, 672, 512},
    { -288, 472, 424},
    { -312, 256, 376},
    { -368, 224, 352},
    { -424, 184, 280},
    { -512, 168, 208},
    { -696, 136, 200},
    { -1024, 152, 248},
    { -1368, 216, 88},
    { -1920, 368, -168},
    { -1848, 424, 32},
    { -1240, 312, -192},
    { -1208, 656, -536},
    { -1136, 240, -552},
    { -1040, 256, -152},
    { -720, 264, -56},
    { -648, 248, -48},
    // 31 seconds
    { -800, 240, 0},
    { -840, 248, 120},
    { -824, 432, 32},
    { -1088, 392, 136},
    { -1248, 576, 176},
    { -1224, 616, 8},
    { -1432, 584, 40},
    { -1120, 560, -16},
    { -1368, 488, 56},
    { -1584, 344, 64},
    { -1320, 272, -40},
    { -1072, 248, -8},
    { -960, 128, 56},
    { -936, 144, 88},
    { -896, 112, 64},
    { -872, 72, 64},
    { -904, 88, 112},
    { -1032, 72, 216},
    { -1040, 80, 184},
    { -1376, 240, 144},
    { -1136, 448, -360},
    { -1104, 368, -280},
    { -1368, 432, -312},
    { -1256, 376, -248},
    { -1008, 368, -96},
    // 32 seconds
    { -720, 400, -64},
    { -736, 336, -104},
    { -856, 344, -16},
    { -944, 312, -24},
    { -944, 344, -48},
    { -1240, 352, -48},
    { -1200, 472, 16},
    { -1552, 680, -56},
    { -1184, 576, -80},
    { -1008, 608, -216},
    { -1184, 456, -152},
    { -1248, 384, -112},
    { -1072, 312, -96},
    { -952, 224, -72},
    { -936, 200, -16},
    { -984, 152, 16},
    { -976, 176, 48},
    { -928, 96, 48},
    { -1096, 120, 144},
    { -1144, 80, 120},
    { -1216, 152, 64},
    { -1464, 336, -120},
    { -1040, 344, -336},
    { -1192, 232, -320},
    { -1224, 224, -240},
    // 33 seconds
    { -1104, 208, -152},
    { -832, 256, -32},
    { -696, 240, 16},
    { -744, 304, 24},
    { -872, 280, -8},
    { -904, 288, -48},
    { -1160, 464, -32},
    { -1352, 480, 128},
    { -1104, 568, -80},
    { -1432, 512, -152},
    { -896, 568, -304},
    { -1136, 528, -248},
    { -1440, 488, -200},
    { -1392, 376, -208},
    { -1016, 224, -248},
    { -1000, 152, -128},
    { -1112, 72, -48},
    { -1048, 32, -32},
    { -936, 72, -56},
    { -912, 96, -24},
    { -968, 72, 40},
    { -936, 104, -40},
    { -1224, 120, -40},
    { -1408, 264, -360},
    { -1072, 280, -608},
    // 34 seconds
    { -1216, 8, -264},
    { -1360, -280, -128},
    { -1232, -40, -128},
    { -896, 176, -120},
    { -760, 248, -48},
    { -864, 288, -88},
    { -992, 312, -64},
    { -936, 312, -40},
    { -1184, 336, -40},
    { -1352, 368, 40},
    { -1320, 568, -224},
    { -1552, 360, -184},
    { -840, 368, -360},
    { -992, 424, -440},
    { -1304, 224, -376},
    { -1376, 160, -328},
    { -1080, 96, -296},
    { -1016, 104, -232},
    { -1032, 72, -128},
    { -1000, 32, -80},
    { -936, 112, -40},
    { -952, 56, -72},
    { -1072, 56, -32},
    { -984, 168, -96},
    { -1192, 440, -192},
    // 35 seconds
    { -1240, 1008, -608},
    { -920, 1224, -816},
    { -992, 896, -656},
    { -816, 704, -448},
    { -472, 536, -296},
    { -184, 344, -96},
    { -64, 256, -56},
    { -56, 200, 112},
    { -48, 112, 104},
    { -48, 232, 208},
    { -80, 192, 152},
    { -248, 336, 240},
    { -576, 720, 368},
    { -1648, 1952, 776},
    { -1464, 1968, 928},
    { -688, 1824, 152},
    { -736, 1264, 104},
    { -616, 864, 40},
    { -360, 768, 176},
    { -384, 624, 184},
    { -392, 496, 216},
    { -400, 392, 264},
    { -416, 496, 232},
    { -456, 448, 272},
    { -480, 592, 384},
    // 36 seconds
    { -440, 920, 344},
    { -320, 728, 344},
    { -152, 1328, 352},
    { -64, 1440, 192},
    { -208, 1384, 40},
    { -192, 1040, 96},
    { -104, 688, 32},
    { -80, 592, -24},
    { 0, 344, 56},
    { 104, 392, 24},
    { 176, 520, 80},
    { 216, 576, 64},
    { 432, 816, -40},
    { 184, 968, 200},
    { 184, 1168, 256},
    { 56, 1928, 200},
    { 0, 1264, 112},
    { 152, 1048, 64},
    { 88, 984, 104},
    { 40, 832, -16},
    { -8, 608, -96},
    { 16, 392, -96},
    { 16, 248, -112},
    { 16, 120, -64},
    { -80, 216, -88},
    // 37 seconds
    { -256, 104, -80},
    { -728, 224, -120},
    { -1264, 112, 104},
    { -2344, 328, 200},
    { -3264, 608, -360},
    { -1816, 680, -400},
    { -864, 32, -448},
    { -1464, 8, -56},
    { -1080, 208, -88},
    { -896, 272, -104},
    { -712, 136, -56},
    { -720, 184, -16},
    { -688, 296, -96},
    { -704, 432, -216},
    { -928, 424, -288},
    { -1088, 368, -208},
    { -1568, 368, -200},
    { -1608, 352, -152},
    { -1344, 416, -296},
    { -1536, 400, -208},
    { -1672, 384, -112},
    { -1416, 296, -40},
    { -1264, 192, 48},
    { -1152, 40, 104},
    { -1056, 24, 64},
    // 38 seconds
    { -960, 56, 0},
    { -848, 16, 8},
    { -792, 24, 64},
    { -752, 16, 72},
    { -832, 80, 8},
    { -1096, 160, -88},
    { -1096, 240, -304},
    { -1512, 440, -552},
    { -1688, 64, -376},
    { -1520, -200, -304},
    { -1048, -56, -392},
    { -840, 200, -360},
    { -880, 208, -504},
    { -920, 8, -512},
    { -888, 120, -560},
    { -1104, 192, -728},
    { -1240, 416, -672},
    { -1480, 232, -824},
    { -1776, 64, -536},
    { -1272, 88, -632},
    { -1688, 96, -496},
    { -1880, -24, -296},
    { -1592, 40, -304},
    { -1304, -8, -256},
    { -1136, -16, -248},
    // 39 seconds
    { -952, 88, -360},
    { -840, -104, -368},
    { -632, -224, -440},
    { -376, -448, -488},
    { -368, -464, -704},
    { -184, -632, -632},
    { -184, -544, -912},
    { -264, -488, -960},
    { -304, -480, -896},
    { -336, -416, -896},
    { -176, -440, -752},
    { -80, -464, -712},
    { -16, -496, -616},
    { 32, -496, -608},
    { 32, -520, -624},
    { 56, -536, -672},
    { 136, -544, -816},
    { 32, -584, -976},
    { -56, -576, -1064},
    { 72, -616, -1208},
    { 16, -528, -1304},
    { 104, -496, -1064},
    { 120, -352, -1104},
    { 24, -344, -992},
    { -56, -360, -872},
    // 40 seconds
    { -72, -384, -752},
    { -32, -440, -640},
    { 32, -448, -608},
    { 16, -488, -632},
    { 16, -464, -712},
    { 24, -496, -912},
    { -8, -560, -992},
    { 80, -624, -1072},
    { -16, -760, -1216},
    { -152, -760, -1320},
    { -152, -568, -1272},
    { -272, -320, -1040},
    { -224, 40, -768},
    { -144, 104, -536},
    { -64, 128, -320},
    { 16, 176, -184},
    { 32, 176, -96},
    { -40, 192, -112},
    { -40, 136, -24},
    { -176, 168, 8},
    { -400, 64, 160},
    { -1448, 1208, 272},
    { -2656, 2616, 816},
    { -1384, 2792, 320},
    { -440, 2096, 120},
    // 41 seconds
    { -392, 1288, 240},
    { -400, 1288, 128},
    { -512, 1000, 112},
    { -496, 792, 272},
    { -568, 728, 160},
    { -520, 456, 216},
    { -504, 592, 104},
    { -464, 560, 64},
    { -368, 528, 96},
    { -200, 752, -56},
    { -48, 944, -88},
    { 8, 1008, -32},
    { 80, 1280, -328},
    { -8, 1048, -320},
    { -56, 912, -344},
    { -80, 656, -344},
    { -120, 376, -224},
    { -88, 152, -184},
    { -32, 136, -144},
    { -32, 96, -128},
    { -120, 144, -128},
    { -344, 536, -136},
    { -704, 1112, -304},
    { -936, 984, -384},
    { -1256, 608, -288},
    // 42 seconds
    { -1872, 616, -216},
    { -1976, 632, -416},
    { -1776, 688, -312},
    { -1224, 688, -352},
    { -904, -80, -224},
    { -728, 48, -296},
    { -592, 168, -312},
    { -600, 184, -264},
    { -688, 144, -192},
    { -832, 8, -104},
    { -1256, 136, -168},
    { -1680, 80, -88},
    { -1392, 88, -224},
    { -1872, 168, -272},
    { -1240, 40, -352},
    { -824, -208, -232},
    { -1112, -352, 16},
    { -992, -336, -8},
    { -776, -128, -88},
    { -464, -88, -80},
    { -496, -32, -104},
    { -688, 32, -72},
    { -840, 56, -104},
    { -960, 120, -200},
    { -1248, 176, -288},
    // 43 seconds
    { -1432, 248, -360},
    { -1960, 240, -400},
    { -1496, 120, -608},
    { -968, 192, -872},
    { -1256, 256, -520},
    { -1152, 176, -336},
    { -944, 120, -280},
    { -768, 120, -216},
    { -744, 40, -56},
    { -832, 160, -32},
    { -920, 120, 0},
    { -992, 80, 16},
    { -1216, 96, 88},
    { -1232, 104, 104},
    { -1208, 80, -40},
    { -1512, 32, -168},
    { -1056, -48, -328},
    { -1032, -128, -440},
    { -1248, -152, -328},
    { -1032, -112, -328},
    { -816, 16, -232},
    { -752, 112, -120},
    { -896, 208, -104},
    { -1016, 272, -176},
    { -1032, 320, -200},
    // 44 seconds
    { -1096, 400, -328},
    { -1296, 360, -368},
    { -1232, 264, -440},
    { -1632, 224, -472},
    { -1384, 176, -432},
    { -1360, 224, -384},
    { -1432, 216, -296},
    { -1504, 176, -176},
    { -1280, 96, -120},
    { -1056, 56, -64},
    { -952, 56, -48},
    { -920, 48, -40},
    { -920, 40, -8},
    { -904, 16, 24},
    { -960, 56, 48},
    { -864, 48, -24},
    { -1072, 104, -40},
    { -1072, 112, -272},
    { -936, 72, -456},
    { -1264, -40, -416},
    { -1608, -136, -288},
    { -1536, -72, -248},
    { -1264, 96, -256},
    { -992, 224, -88},
    { -1040, 392, -136},
    // 45 seconds
    { -1064, 304, -152},
    { -1040, 256, -208},
    { -1128, 296, -232},
    { -1216, 400, -152},
    { -1272, 536, -272},
    { -1560, 392, -224},
    { -1056, 336, -312},
    { -1328, 440, -208},
    { -1472, 280, -136},
    { -1440, 160, -136},
    { -1216, 72, -104},
    { -1152, 0, -16},
    { -1184, 16, -8},
    { -1144, 56, -56},
    { -1016, 56, -8},
    { -904, 176, 64},
    { -1040, 200, -40},
    { -880, 616, -304},
    { -1344, 1408, -296},
    { -752, 1464, -272},
    { -576, 1520, -504},
    { -456, 1080, -256},
    { -144, 624, -432},
    { -8, 248, -272},
    { 8, -16, -40},
    // 46 seconds
    { 16, -48, -16},
    { 0, -40, 24},
    { -8, -96, 112},
    { -16, 80, 104},
    { -80, 408, -56},
    { -344, 608, 64},
    { -1144, 1488, 968},
    { -1544, 2640, 912},
    { -832, 2168, 864},
    { -160, 1552, 424},
    { -40, 1416, 64},
    { -64, 960, 96},
    { -240, 704, -24},
    { -216, 424, -16},
    { -320, 272, 24},
    { -312, 208, 24},
    { -440, 256, 48},
    { -744, 952, 240},
    { -768, 1264, 136},
    { -368, 1632, 144},
    { -152, 1384, 112},
    { -96, 1480, -160},
    { -240, 1216, -136},
    { -256, 904, -80},
    { -120, 656, -72},
    // 47 seconds
    { -24, 480, -32},
    { 96, 408, 56},
    { 184, 368, -16},
    { 368, 472, 0},
    { 312, 536, -48},
    { 368, 696, -88},
    { 440, 856, -72},
    { 536, 912, -56},
    { 568, 1136, 56},
    { 496, 1144, 64},
    { 504, 1128, 72},
    { 408, 1032, -64},
    { 288, 616, -232},
    { 144, 304, -280},
    { 40, 232, -208},
    { -32, 96, -96},
    { -184, 32, -64},
    { -392, 208, -168},
    { -768, 448, -144},
    { -1264, 280, -72},
    { -1752, 168, -168},
    { -2552, 80, -40},
    { -2632, 208, -392},
    { -1680, 264, -672},
    { -1160, 0, -512},
    // 48 seconds
    { -1280, 32, -88},
    { -960, 176, -88},
    { -728, 280, -128},
    { -656, 240, -152},
    { -688, 248, -160},
    { -768, 192, -112},
    { -768, 208, -208},
    { -1104, 296, -312},
    { -1320, 304, -320},
    { -1488, 248, -464},
    { -1448, 120, -400},
    { -1136, 64, -376},
    { -1384, 240, -344},
    { -1560, 256, -224},
    { -1472, 152, -136},
    { -1192, 96, -72},
    { -1072, 24, -8},
    { -1008, 0, 8},
    { -992, 16, 24},
    { -944, 16, 32},
    { -1056, 48, 88},
    { -1080, 88, 32},
    { -1168, 128, -72},
    { -1312, 136, -216},
    { -960, 216, -480},
    // 49 seconds
    { -1088, 24, -384},
    { -1264, -224, -248},
    { -1160, -304, -248},
    { -1000, -56, -224},
    { -952, 160, -112},
    { -1048, 272, -64},
    { -1176, 384, -264},
    { -1216, 368, -280},
    { -1448, 496, -384},
    { -1352, 520, -288},
    { -1520, 80, -392},
    { -1408, 368, -168},
    { -840, 600, -248},
    { -1168, 584, -168},
    { -1464, 440, -32},
    { -1416, 296, -88},
    { -1112, 208, -48},
    { -1032, -136, 112},
    { -1064, 72, 32},
    { -1128, 8, 8},
    { -1104, 56, -8},
    { -1168, 64, 40},
    { -1184, 48, -48},
    { -968, -56, -160},
    { -1256, -8, -200},
    // 50 seconds
    { -1088, 96, -304},
    { -1096, 8, -328},
    { -1320, -72, -288},
    { -1208, -80, -248},
    { -992, 40, -120},
    { -944, 192, 8},
    { -1104, 304, -64},
    { -1216, 384, -136},
    { -1184, 392, -96},
    { -1272, 576, -248},
    { -1144, 608, -240},
    { -1688, 480, -392},
    { -1232, 480, -424},
    { -904, 408, -520},
    { -1360, 352, -352},
    { -1632, 232, -128},
    { -1384, 104, -168},
    { -1184, 80, -104},
    { -1144, 192, -64},
    { -1232, 176, 0},
    { -1184, 112, 0},
    { -1088, 152, 16},
    { -1096, 184, -32},
    { -1096, 304, -184},
    { -1144, 600, -216},
    // 51 seconds
    { -832, 768, -352},
    { -336, 1152, -520},
    { -416, 1248, -416},
    { -488, 928, -200},
    { -280, 784, -64},
    { -120, 472, -24},
    { -32, 304, 64},
    { 8, 184, 88},
    { 40, 120, 104},
    { 64, -80, 288},
    { -184, 456, -32},
    { -304, 456, 648},
    { -960, 1664, 904},
    { -1776, 2440, 1112},
    { -728, 1648, 808},
    { -272, 1376, 128},
    { -176, 984, 40},
    { -208, 832, 176},
    { -400, 840, 144},
    { -504, 1008, 192},
    { -576, 912, 272},
    { -576, 1200, 160},
    { -544, 1088, 112},
    { -496, 1304, -128},
    { -320, 1128, -272},
    // 52 seconds
    { -56, 1120, -472},
    { 344, 784, -520},
    { 656, 504, -576},
    { 536, 208, 168},
    { 632, -80, -400},
    { 360, -160, -464},
    { 296, -296, -256},
    { 288, -400, -240},
    { 320, -320, -344},
    { 400, -400, -280},
    { 472, -584, -392},
    { 560, -648, -456},
    { 560, -696, -664},
    { 728, -832, -512},
    { 920, -728, -632},
    { 816, -864, -504},
    { 784, -792, -416},
    { 896, -584, -328},
    { 776, -624, -344},
    { 592, -560, -120},
    { 504, -384, -352},
    { 408, -408, -440},
    { 416, -512, -416},
    { 440, -416, -456},
    { 472, -440, -488},
    // 53 seconds
    { 528, -624, -680},
    { 880, -680, -872},
    { 872, -952, -904},
    { 736, -936, -720},
    { 672, -496, -736},
    { 360, -416, -536},
    { 304, -392, -352},
    { 368, -400, -360},
    { 320, -424, -184},
    { 248, -384, -184},
    { 256, -336, -184},
    { 264, -272, -216},
    { 192, -152, -248},
    { 144, 720, -352},
    { 448, 1424, -552},
    { 400, 1552, -704},
    { 696, 1992, -376},
    { 448, 1992, -616},
    { 456, 1304, -648},
    { 376, 1144, -560},
    { 224, 856, -496},
    { 32, 520, -432},
    { -48, 288, -328},
    { -96, 208, -208},
    { -184, 168, -152},
    // 54 seconds
    { -328, 136, -128},
    { -576, 144, -136},
    { -952, 96, 0},
    { -1536, 232, -64},
    { -2696, 344, -208},
    { -2416, 584, -896},
    { -1368, 200, -480},
    { -1336, -656, -184},
    { -1328, -96, -112},
    { -1080, 208, -112},
    { -840, 296, -88},
    { -728, 272, -144},
    { -704, 304, -200},
    { -672, 312, -200},
    { -816, 384, -456},
    { -1312, 320, -520},
    { -1584, 488, -520},
    { -1456, -312, -520},
    { -1208, 0, -384},
    { -1184, 464, -384},
    { -1408, 472, -264},
    { -1400, 200, -248},
    { -1168, 80, -96},
    { -1016, 0, -16},
    { -1024, -40, -8},
    // 55 seconds
    { -1072, 0, -24},
    { -1120, -16, -208},
    { -1152, -72, -96},
    { -1184, -32, -152},
    { -1168, 144, -288},
    { -1232, 120, -304},
    { -888, 288, -504},
    { -696, 256, -368},
    { -1016, 136, -192},
    { -1040, -56, -104},
    { -1048, -96, -104},
    { -1048, 8, -88},
    { -1112, 152, -24},
    { -1264, 280, -72},
    { -1320, 304, -240},
    { -1096, 152, -256},
    { -1096, 488, -480},
    { -1160, 480, -336},
    { -1264, 240, -464},
    { -1576, 496, -472},
    { -1152, 408, -456},
    { -1248, 312, -352},
    { -1424, 264, -264},
    { -1592, 216, -176},
    { -1304, 120, -152},
    // 56 seconds
    { -1184, 72, -48},
    { -1144, 56, 0},
    { -1072, 32, 8},
    { -952, 72, 0},
    { -936, 216, -96},
    { -1112, 408, -256},
    { -976, 736, -552},
    { -928, 856, -576},
    { -440, 584, -736},
    { -64, 840, -920},
    { -368, 496, -832},
    { -240, 368, -664},
    { -112, 336, -472},
    { 16, 208, -296},
    { 24, 112, -120},
    { 32, 160, -80},
    { 0, 160, -48},
    { -24, 152, 16},
    { -200, 440, -56},
    { -544, 968, -24},
    { -632, 808, 288},
    { -1480, 1656, 520},
    { -1224, 2624, 168},
    { -824, 1624, 296},
    { -672, 1488, 0},
    // 57 seconds
    { -536, 1144, -88},
    { -472, 1024, -64},
    { -488, 816, -176},
    { -416, 560, -8},
    { -456, 552, 80},
    { -464, 544, 72},
    { -368, 544, 48},
    { -352, 520, 112},
    { -240, 672, 0},
    { -64, 824, 16},
    { 120, 1064, 0},
    { 368, 1280, -144},
    { 208, 1352, -160},
    { 88, 1296, -152},
    { 8, 928, -32},
    { 88, 752, -120},
    { 248, 536, 48},
    { 112, 640, -224},
    { 328, 568, 112},
    { 424, 512, 24},
    { 456, 480, -72},
    { 560, 576, -112},
    { 544, 736, -104},
    { 712, 904, -128},
    { 704, 1088, -168},
    // 58 seconds
    { 560, 976, -168},
    { 552, 912, -136},
    { 488, 800, -48},
    { 416, 712, -56},
    { 344, 608, -112},
    { 288, 512, -152},
    { 304, 432, -120},
    { 304, 392, -104},
    { 272, 352, -112},
    { 296, 256, -80},
    { 296, 272, -136},
    { 192, 208, -96},
    { 80, 608, -16},
    { -608, 2824, -464},
    { -776, 1992, -920},
    { -400, 1392, -1128},
    { -400, 792, -1072},
    { -440, 440, -880},
    { -416, 248, -808},
    { -320, 216, -880},
    { -280, 56, -728},
    { -288, 72, -904},
    { -264, 16, -952},
    { -184, -256, -864},
    { -224, -176, -928},
    // 59 seconds
    { -168, -232, -952},
    { -160, -328, -856},
    { -112, -304, -896},
    { -120, -368, -936},
    { -120, -352, -912},
    { -104, -368, -936},
    { -48, -384, -896},
    { -48, -416, -880},
    { -24, -416, -872},
    { 40, -368, -920},
    { 32, -464, -912},
    { 16, -456, -928},
    { 8, -488, -888},
    { 16, -480, -912},
    { 8, -464, -920},
    { 8, -456, -928},
    { 0, -472, -920},
    { -16, -464, -928},
    { -16, -456, -904},
    { -24, -472, -904},
    { -8, -448, -920},
    { -8, -456, -904},
    { 0, -448, -912},
    { -8, -440, -904},
    { 8, -432, -904},
    // 60 seconds
    // elapsed: 1 minutes
    { 0, -432, -912},
    { 0, -432, -888},
    { 0, -424, -872},
    { -8, -416, -864},
    { -16, -464, -856},
    { -48, -400, -920},
    { -40, -432, -960},
    { -48, -384, -976},
    { -24, -408, -992},
    { -16, -352, -968},
    { -32, -376, -968},
    { -56, -384, -944},
    { -48, -336, -976},
    { -64, -312, -976},
    { -72, -320, -1032},
    { -88, -256, -952},
    { -136, -240, -872},
    { -120, -144, -824},
    { -40, 88, -896},
    { -56, 248, -888},
    { 24, 512, -840},
    { 104, 672, -632},
    { 200, 920, -304},
    { 176, 1328, 80},
    { 232, 1224, -48},
    // 61 seconds
    { 136, 1232, -200},
    { 104, 1224, -176},
    { 152, 768, -200},
    { 144, 232, -320},
    { -8, -368, -680},
    { -48, -504, -1000},
    { -56, -104, -1072},
    { -56, -224, -960},
    { -40, -304, -920},
    { -48, -256, -928},
    { -56, -312, -936},
    { -32, -328, -960},
    { -32, -296, -968},
    { -32, -312, -984},
    { -24, -304, -976},
    { -16, -304, -984},
    { -16, -304, -976},
    { -24, -304, -960},
    { -16, -296, -960},
    { -24, -336, -952},
    { -32, -288, -968},
    { -32, -320, -976},
    { -40, -328, -960},
    { -32, -304, -968},
    { -24, -336, -968},
    // 62 seconds
    { -32, -360, -928},
    { -32, -328, -928},
    { -72, -400, -912},
    { -104, -496, -816},
    { -128, -272, -872},
    { -168, 48, -888},
    { -80, 240, -888},
    { -32, 344, -656},
    { 104, 640, -272},
    { 144, 1152, -168},
    { 104, 1408, -136},
    { 64, 976, 96},
    { -24, 1056, 16},
    { -56, 1016, -48},
    { -112, 992, -56},
    { -160, 848, -48},
    { -128, 1024, -32},
    { -32, 880, 56},
    { -24, 984, 176},
    { -24, 840, 64},
    { -136, 1008, -8},
    { 96, 760, 48},
    { -16, 904, -8},
    { 32, 928, -96},
    { 64, 968, -240},
    // 63 seconds
    { -8, 888, -296},
    { 16, 928, -400},
    { 40, 968, -464},
    { 128, 728, -488},
    { 96, 512, -696},
    { 88, 648, -816},
    { 64, 376, -880},
    { 24, 168, -856},
    { -24, 24, -880},
    { -24, 48, -1000},
    { -8, -176, -888},
    { 0, -200, -880},
    { 8, -144, -928},
    { 88, -304, -856},
    { 112, -320, -856},
    { 8, -344, -952},
    { -48, -88, -960},
    { -64, -288, -1016},
    { 72, -208, -1016},
    { -56, -264, -1032},
    { -152, -256, -976},
    { -56, -360, -976},
    { -80, -304, -1024},
    { -152, -320, -960},
    { -88, -344, -976},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-16 17:12:28 local
AccelRawData *activity_sample_walk_100_pbl_28394_2(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_28394_2
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -48, -384, -944},
    { -40, -392, -952},
    { -48, -384, -936},
    { -48, -384, -944},
    { -32, -384, -960},
    { -32, -368, -952},
    { -32, -376, -952},
    { -40, -368, -968},
    { -32, -376, -960},
    { -40, -368, -952},
    { -48, -360, -960},
    { -40, -376, -952},
    { -56, -376, -960},
    { -72, -376, -936},
    { -56, -376, -968},
    { -80, -408, -936},
    { -56, -408, -968},
    { -40, -368, -944},
    { -32, -320, -984},
    { -24, -320, -976},
    { -16, -328, -952},
    { -24, -336, -968},
    { 0, -328, -960},
    { -16, -328, -952},
    { -16, -328, -960},
    // 1 seconds
    { -32, -312, -944},
    { -24, -328, -976},
    { -32, -328, -968},
    { -32, -320, -976},
    { -16, -328, -976},
    { -8, -328, -968},
    { -16, -320, -968},
    { -24, -304, -976},
    { -8, -320, -976},
    { -8, -320, -976},
    { 0, -320, -976},
    { 56, -376, -968},
    { 40, -312, -944},
    { 80, -280, -936},
    { 88, -248, -968},
    { 80, -232, -952},
    { -88, -288, -992},
    { 56, -272, -928},
    { 8, -32, -880},
    { 8, 96, -832},
    { 96, 248, -760},
    { 32, 496, -480},
    { 104, 896, -296},
    { 160, 1072, -168},
    { 112, 976, 0},
    // 2 seconds
    { 120, 1096, -120},
    { 128, 936, -184},
    { 80, 888, -184},
    { 16, 832, -88},
    { -8, 864, -72},
    { -96, 936, 168},
    { -32, 880, -64},
    { -56, 952, 64},
    { -56, 904, 80},
    { -64, 840, -24},
    { -120, 808, 32},
    { -184, 824, 80},
    { -104, 888, 80},
    { -176, 904, 0},
    { -160, 824, -40},
    { -120, 1160, -48},
    { -56, 920, -72},
    { 64, 1000, -96},
    { 152, 776, -136},
    { 168, 864, -104},
    { 72, 752, -56},
    { 160, 640, -32},
    { -136, 1224, 48},
    { -248, 1704, -64},
    { -192, 1392, -176},
    // 3 seconds
    { -232, 1368, -384},
    { -40, 904, -344},
    { 112, 600, -24},
    { -136, 200, 168},
    { -248, 144, 392},
    { -280, 456, 264},
    { -184, 584, 120},
    { -96, 424, -72},
    { 8, 1040, -136},
    { -456, 1744, -136},
    { -280, 1640, -360},
    { -224, 1480, -416},
    { 104, 1368, -528},
    { 136, 1128, -496},
    { 192, 1072, -520},
    { 144, 680, -80},
    { 56, 528, -96},
    { 40, 320, -56},
    { 0, 384, -32},
    { 32, 624, -184},
    { 80, 736, -288},
    { 32, 992, -224},
    { 56, 1080, -352},
    { 112, 952, -456},
    { 208, 768, -384},
    // 4 seconds
    { 176, 784, -328},
    { 176, 768, -240},
    { 200, 776, -216},
    { 208, 840, -248},
    { 224, 824, -280},
    { 232, 928, -216},
    { 248, 712, -224},
    { 256, 816, -248},
    { 272, 776, -200},
    { 280, 800, -240},
    { 248, 840, -192},
    { 240, 944, -272},
    { 272, 800, -264},
    { 288, 840, -336},
    { 344, 768, -264},
    { 320, 744, -256},
    { 320, 752, -192},
    { 416, 808, -344},
    { 320, 832, -352},
    { 336, 808, -248},
    { 344, 792, -384},
    { 336, 672, -336},
    { 344, 696, -440},
    { 368, 728, -416},
    { 384, 688, -424},
    // 5 seconds
    { 392, 680, -440},
    { 400, 608, -416},
    { 392, 680, -448},
    { 392, 696, -408},
    { 384, 680, -416},
    { 368, 672, -408},
    { 360, 648, -384},
    { 328, 688, -392},
    { 328, 552, -200},
    { 264, 624, -272},
    { 184, 856, -64},
    { 168, 1104, 16},
    { 208, 984, 96},
    { 208, 1040, -24},
    { 200, 936, -40},
    { 160, 840, -24},
    { 128, 880, -24},
    { 104, 840, 80},
    { 144, 808, 104},
    { 152, 936, 240},
    { 144, 800, 168},
    { 136, 952, 248},
    { 176, 728, 96},
    { 160, 784, 160},
    { 128, 632, 80},
    // 6 seconds
    { 80, 616, 48},
    { -80, 832, 168},
    { -152, 1280, 240},
    { -8, 1216, 416},
    { 0, 1144, 160},
    { 72, 960, 88},
    { -8, 944, 168},
    { -96, 1008, 8},
    { -72, 936, 64},
    { -40, 920, -40},
    { 32, 848, 0},
    { 88, 784, -24},
    { 120, 704, -24},
    { 184, 664, -64},
    { 192, 712, -88},
    { 200, 712, -88},
    { 168, 808, -80},
    { 120, 888, -88},
    { 72, 896, -40},
    { 144, 1064, 32},
    { 32, 1416, 112},
    { 0, 1192, 128},
    { 40, 1072, 112},
    { 32, 1000, 112},
    { -24, 992, 80},
    // 7 seconds
    { -32, 800, 8},
    { -24, 600, -72},
    { -8, 480, -160},
    { -16, 392, -168},
    { -32, 312, -144},
    { -112, 272, -104},
    { -360, 344, -128},
    { -808, 392, -144},
    { -1208, 656, -456},
    { -1640, 392, -216},
    { -2160, 608, -200},
    { -1568, 560, -496},
    { -1344, 296, -400},
    { -1192, 184, -176},
    { -840, 240, -104},
    { -736, 296, -16},
    { -688, 288, -16},
    { -760, 208, 56},
    { -736, 176, 48},
    { -688, 168, 80},
    { -960, 376, -8},
    { -1152, 360, 0},
    { -1984, 672, -144},
    { -1088, 536, -360},
    { -1440, 528, -512},
    // 8 seconds
    { -1480, 448, -496},
    { -1320, 360, -464},
    { -1088, 144, -328},
    { -920, -56, -160},
    { -768, -80, -128},
    { -664, -8, -152},
    { -712, 48, -112},
    { -784, 48, -40},
    { -896, 24, 32},
    { -976, 64, 24},
    { -1536, 160, 56},
    { -1664, 320, -288},
    { -1144, 256, -600},
    { -1296, -16, -344},
    { -1160, -136, -296},
    { -824, -8, -232},
    { -728, 160, -96},
    { -792, 248, -120},
    { -888, 264, -88},
    { -928, 288, -120},
    { -1016, 408, -232},
    { -1344, 312, -176},
    { -1400, 528, -264},
    { -1784, 192, -368},
    { -1104, 352, -384},
    // 9 seconds
    { -944, 408, -392},
    { -1360, 336, -240},
    { -1576, 200, -96},
    { -1208, 112, -96},
    { -1032, 72, -56},
    { -1008, 32, -40},
    { -952, 24, -32},
    { -928, 56, -56},
    { -1056, 64, -32},
    { -1240, 48, 40},
    { -1024, 16, 32},
    { -1192, 64, -40},
    { -1192, 168, -256},
    { -1016, 176, -336},
    { -1160, -8, -272},
    { -1200, -192, -176},
    { -1096, -96, -152},
    { -936, 120, -48},
    { -888, 232, -8},
    { -1016, 352, -112},
    { -1024, 376, -240},
    { -1080, 416, -256},
    { -1376, 344, -240},
    { -1168, 752, -480},
    { -1656, 40, -424},
    // 10 seconds
    { -1168, 184, -416},
    { -1128, 296, -440},
    { -1472, 272, -232},
    { -1560, 176, -96},
    { -1232, 128, -120},
    { -992, 120, -88},
    { -992, 104, -16},
    { -1040, 56, 32},
    { -1088, 72, 8},
    { -1112, 112, 0},
    { -1184, 112, 8},
    { -984, -64, 8},
    { -1024, -128, -80},
    { -1064, 40, -344},
    { -960, 32, -504},
    { -1272, -136, -392},
    { -1384, -240, -160},
    { -1424, -32, -136},
    { -1192, 248, 8},
    { -984, 376, -16},
    { -1016, 360, -96},
    { -1088, 320, -104},
    { -968, 320, -160},
    { -1168, 392, -312},
    { -1216, 856, -560},
    // 11 seconds
    { -1328, 360, -752},
    { -1576, 152, -568},
    { -1216, 336, -528},
    { -1416, 256, -400},
    { -1680, 176, -168},
    { -1672, 128, -32},
    { -1296, 96, -32},
    { -1144, 112, -16},
    { -1160, 120, 24},
    { -1128, 104, 40},
    { -1024, 80, 16},
    { -912, 80, 0},
    { -928, 64, -64},
    { -744, -8, -264},
    { -816, -80, -216},
    { -1120, 0, -248},
    { -968, -56, -472},
    { -1296, 8, -552},
    { -1608, -128, -232},
    { -1760, -144, -88},
    { -1608, 176, -136},
    { -1352, 488, -24},
    { -1272, 488, -176},
    { -1304, 280, -144},
    { -1144, 304, -176},
    // 12 seconds
    { -1160, 392, -208},
    { -1040, 544, -160},
    { -1016, 400, -312},
    { -1448, 440, -184},
    { -1216, 456, -280},
    { -1352, 416, -296},
    { -1544, 408, -216},
    { -1752, 312, -128},
    { -1560, 168, -88},
    { -1440, 72, 40},
    { -1496, 16, 48},
    { -1432, 16, 56},
    { -1200, 72, 32},
    { -1072, 32, 32},
    { -1024, -64, 88},
    { -744, -200, 16},
    { -1000, -24, 0},
    { -1000, 176, -112},
    { -928, -16, -320},
    { -1296, 176, -184},
    { -1544, -144, -160},
    { -1712, 72, -152},
    { -1544, 440, -40},
    { -1272, 624, -192},
    { -1048, 488, -216},
    // 13 seconds
    { -1248, 424, -168},
    { -1072, 248, -152},
    { -1192, 488, -184},
    { -1096, 744, -232},
    { -1560, 552, -104},
    { -1160, 376, -176},
    { -1112, 360, -312},
    { -1264, 328, -240},
    { -1448, 328, -128},
    { -1424, 304, -152},
    { -1248, 192, -56},
    { -1272, 144, 64},
    { -1288, -24, 88},
    { -1176, 8, 40},
    { -1144, 32, 8},
    { -1144, 16, 64},
    { -936, -152, 56},
    { -1032, -96, -32},
    { -1248, 72, -296},
    { -1008, 8, -536},
    { -1200, -112, -392},
    { -1216, -296, -240},
    { -1128, -80, -248},
    { -1008, 184, -152},
    { -976, 280, -56},
    // 14 seconds
    { -1120, 312, -72},
    { -1272, 360, -128},
    { -1216, 336, -160},
    { -1336, 480, -136},
    { -1152, 440, 8},
    { -1512, 904, -208},
    { -1232, 616, -168},
    { -1024, 608, -272},
    { -1280, 464, -136},
    { -1376, 304, -64},
    { -1128, 232, -120},
    { -976, 208, -112},
    { -1056, 168, -72},
    { -1200, 136, 8},
    { -1280, 88, 48},
    { -1168, 72, 24},
    { -1184, 56, 24},
    { -1112, -48, -48},
    { -1136, -96, -56},
    { -1272, 32, -448},
    { -848, 96, -608},
    { -1120, -56, -392},
    { -1304, -320, -176},
    { -1200, -176, -128},
    { -1080, 128, -72},
    // 15 seconds
    { -928, 296, 16},
    { -968, 320, -8},
    { -1072, 416, -80},
    { -1016, 344, -104},
    { -1112, 408, -248},
    { -1272, 720, -168},
    { -1264, 744, -360},
    { -1536, 696, -248},
    { -968, 648, -352},
    { -1336, 616, -176},
    { -1624, 384, 24},
    { -1672, 272, 40},
    { -1272, 192, 48},
    { -1080, 128, 32},
    { -1088, 152, 88},
    { -1104, 104, 80},
    { -1032, 72, 96},
    { -1056, 48, 104},
    { -1120, -72, 96},
    { -816, -200, -40},
    { -1072, -64, -104},
    { -1328, 264, -384},
    { -1168, 136, -384},
    { -1512, -48, -344},
    { -1488, -168, -216},
    // 16 seconds
    { -1392, 8, -184},
    { -1160, 256, -32},
    { -1184, 392, -16},
    { -1216, 368, -40},
    { -1152, 352, -96},
    { -912, 352, -88},
    { -1152, 480, -152},
    { -1056, 760, -16},
    { -1160, 728, -304},
    { -1312, 744, -136},
    { -1064, 648, -256},
    { -1416, 616, -248},
    { -1864, 400, -48},
    { -1928, 240, -40},
    { -1584, 152, 0},
    { -1464, 104, 32},
    { -1408, 72, 72},
    { -1248, 40, 88},
    { -1088, 48, 24},
    { -952, 8, 128},
    { -1080, 88, -232},
    { -392, -728, 80},
    { -920, -184, -64},
    { -1456, 72, -208},
    { -1496, 224, -512},
    // 17 seconds
    { -1664, 168, -448},
    { -1624, -40, -144},
    { -1472, 168, -248},
    { -1264, 304, -112},
    { -1256, 344, -64},
    { -1248, 376, -72},
    { -1320, 336, -112},
    { -1152, 328, -64},
    { -1208, 536, -144},
    { -1080, 648, -56},
    { -1200, 464, -104},
    { -1240, 544, -80},
    { -1040, 600, -216},
    { -1240, 488, -224},
    { -1424, 400, -120},
    { -1680, 304, -56},
    { -1504, 160, -24},
    { -1456, 88, 32},
    { -1464, 64, 72},
    { -1376, 24, 56},
    { -1224, 40, 40},
    { -1192, 8, 48},
    { -1056, -768, 296},
    { -824, -208, -56},
    { -1264, -248, 136},
    // 18 seconds
    { -1688, -136, -176},
    { -1536, -16, -208},
    { -1464, -272, -88},
    { -1208, -208, -208},
    { -1040, -8, -280},
    { -1000, 112, -168},
    { -1104, 152, -88},
    { -1216, 192, -152},
    { -1312, 240, -224},
    { -1352, 448, -320},
    { -1336, 1136, -320},
    { -1000, 8, -432},
    { -1568, 592, -344},
    { -1176, 304, -416},
    { -1016, 128, -368},
    { -1360, 224, -328},
    { -1504, 168, -224},
    { -1416, 96, -136},
    { -1256, 88, -64},
    { -1248, 80, 0},
    { -1288, 80, 8},
    { -1240, 32, 48},
    { -1096, 104, -16},
    { -1144, 56, -56},
    { -1136, -72, -104},
    // 19 seconds
    { -1192, -192, 48},
    { -1120, -128, -224},
    { -1088, -72, -304},
    { -1208, -128, -104},
    { -1160, -144, -128},
    { -1088, -32, -168},
    { -968, 64, -112},
    { -992, 160, -136},
    { -1160, 232, -96},
    { -1344, 280, -200},
    { -1320, 288, -240},
    { -1584, 544, -416},
    { -1200, 208, -440},
    { -1808, 288, -472},
    { -1352, 272, -440},
    { -944, 224, -600},
    { -1232, 288, -544},
    { -1504, 432, -368},
    { -1664, 416, -248},
    { -1632, 472, -184},
    { -1712, 672, -232},
    { -1640, 752, -144},
    { -1544, 888, -288},
    { -1424, 1096, -416},
    { -1232, 1120, -712},
    // 20 seconds
    { -608, 296, -512},
    { -136, 80, -608},
    { 224, -464, -480},
    { 240, -544, -432},
    { 312, -456, -392},
    { 208, -496, -328},
    { 224, -448, -264},
    { 336, -472, -296},
    { 376, -360, -328},
    { 392, -384, -248},
    { 480, -568, -928},
    { 176, -592, -424},
    { 472, -616, -680},
    { 728, -480, -776},
    { 792, -592, -928},
    { 1064, -472, -920},
    { 1064, -552, -568},
    { 1072, -504, -408},
    { 840, -400, -344},
    { 680, -152, -488},
    { 472, -96, -568},
    { 336, -328, -584},
    { 328, -288, -416},
    { 384, -168, -488},
    { 432, -344, -496},
    // 21 seconds
    { 496, -296, -672},
    { 624, -448, -640},
    { 560, -376, -680},
    { 728, -368, -592},
    { 560, -296, -464},
    { 288, -200, -488},
    { -104, -128, -320},
    { -552, 96, -200},
    { -1000, 912, -592},
    { -848, 1192, -696},
    { -736, 680, -600},
    { -784, 624, -528},
    { -992, 664, -440},
    { -1104, 480, -312},
    { -1744, 536, -24},
    { -3344, 1544, -256},
    { -1320, 1064, 336},
    { -1664, 1616, 296},
    { -600, 936, -128},
    { -632, 1064, -8},
    { -1104, 832, 240},
    { -1264, 816, 352},
    { -1160, 512, 272},
    { -1152, 296, 296},
    { -1088, 256, 184},
    // 22 seconds
    { -1080, 280, 184},
    { -1024, 160, 232},
    { -936, 312, 304},
    { -1168, -48, 560},
    { -816, 48, -224},
    { -1288, -152, -40},
    { -1384, 368, -304},
    { -1192, 328, -440},
    { -1384, 416, -432},
    { -1256, 336, -264},
    { -1048, 344, -248},
    { -960, 320, -128},
    { -1000, 296, -16},
    { -1152, 328, 104},
    { -1256, 408, 88},
    { -1064, 488, 80},
    { -1208, 528, 32},
    { -1272, 520, 40},
    { -1376, 592, -40},
    { -1336, 712, -72},
    { -864, 512, -240},
    { -984, 520, -272},
    { -1280, 448, -72},
    { -1576, 336, 80},
    { -1416, 104, 88},
    // 23 seconds
    { -1328, 72, 48},
    { -1296, 104, 48},
    { -1240, 136, 48},
    { -1152, 32, 80},
    { -1320, -152, 208},
    { -1128, -392, 32},
    { -928, -304, 80},
    { -1304, -168, -16},
    { -1192, 80, -16},
    { -1256, 344, -312},
    { -1304, 152, -168},
    { -1168, 280, -288},
    { -984, 368, -288},
    { -928, 256, -64},
    { -1024, 392, 56},
    { -1120, 368, 0},
    { -1152, 520, 56},
    { -1160, 496, 56},
    { -1264, 624, 56},
    { -1328, 736, 24},
    { -1368, 648, 112},
    { -944, 560, -24},
    { -1120, 568, 8},
    { -1344, 408, 64},
    { -1456, 320, 88},
    // 24 seconds
    { -1280, 256, 96},
    { -1160, 200, 120},
    { -1184, 184, 80},
    { -1200, 176, 56},
    { -1160, 96, 80},
    { -1144, 48, 72},
    { -1056, -200, 192},
    { -752, -296, 16},
    { -1072, -192, -200},
    { -1296, -32, -256},
    { -1288, 64, -456},
    { -1488, -64, -408},
    { -1400, -40, -288},
    { -1248, 56, -272},
    { -1024, 160, -88},
    { -1096, 312, -72},
    { -1120, 304, -120},
    { -1136, 328, -176},
    { -1088, 360, -216},
    { -1240, 368, -184},
    { -1224, 616, -272},
    { -1592, 608, -192},
    { -1008, 432, -280},
    { -1064, 384, -264},
    { -1304, 336, -208},
    // 25 seconds
    { -1512, 360, -176},
    { -1264, 184, -104},
    { -1176, 136, -40},
    { -1192, 80, -8},
    { -1208, 80, 24},
    { -1160, 120, 40},
    { -1144, 72, 72},
    { -1144, 8, 128},
    { -936, -24, 80},
    { -1232, 104, 56},
    { -1336, 352, -112},
    { -936, 504, -56},
    { -1184, 488, 16},
    { -1000, 272, -96},
    { -856, 192, -48},
    { -776, 216, 32},
    { -808, 224, 152},
    { -976, 224, 200},
    { -1224, 456, 192},
    { -1256, 504, 280},
    { -1392, 536, 472},
    { -1144, 616, 368},
    { -1600, 792, 400},
    { -1120, 664, 240},
    { -928, 624, 184},
    // 26 seconds
    { -1208, 416, 256},
    { -1312, 400, 240},
    { -1064, 320, 240},
    { -920, 256, 272},
    { -952, 168, 168},
    { -1064, 136, 232},
    { -1112, 80, 232},
    { -1144, 128, 240},
    { -1216, 88, 336},
    { -1008, 192, 240},
    { -1168, 232, 192},
    { -1232, 376, 384},
    { -848, 544, 240},
    { -840, 480, 344},
    { -976, 384, 216},
    { -944, 384, 200},
    { -808, 176, 272},
    { -776, 224, 312},
    { -864, 200, 336},
    { -968, 264, 368},
    { -960, 328, 384},
    { -1096, 416, 472},
    { -1144, 496, 528},
    { -1248, 600, 480},
    { -1504, 712, 368},
    // 27 seconds
    { -1000, 600, 240},
    { -1128, 648, 168},
    { -1400, 400, 208},
    { -1328, 328, 208},
    { -1016, 256, 192},
    { -912, 224, 96},
    { -944, 256, 160},
    { -992, 112, 184},
    { -976, 152, 136},
    { -992, 80, 224},
    { -1112, 280, -48},
    { -840, 152, 72},
    { -1136, 208, 64},
    { -1312, 384, -144},
    { -1096, 520, -312},
    { -1272, 536, -136},
    { -1216, 328, -40},
    { -1032, 352, -88},
    { -856, 408, -16},
    { -880, 328, 40},
    { -968, 344, 8},
    { -1040, 296, 80},
    { -936, 432, 40},
    { -1184, 496, 208},
    { -1216, 576, 376},
    // 28 seconds
    { -1544, 632, 80},
    { -1232, 664, 144},
    { -848, 616, -8},
    { -1104, 528, 24},
    { -1360, 408, 128},
    { -1304, 344, 104},
    { -1112, 208, 48},
    { -1096, 144, 56},
    { -1208, 248, 88},
    { -1224, 112, 80},
    { -1200, 176, 64},
    { -1168, -8, 0},
    { -896, -224, -16},
    { -1280, -176, 8},
    { -1384, -64, -104},
    { -1176, 56, -296},
    { -1296, 64, -256},
    { -1280, 112, -208},
    { -1104, 168, -320},
    { -928, 216, -240},
    { -848, 208, -160},
    { -992, 264, -184},
    { -1104, 304, -232},
    { -1168, 504, -392},
    { -1328, 760, -264},
    // 29 seconds
    { -1176, 600, -216},
    { -1360, 560, -240},
    { -1304, 464, -104},
    { -1016, 480, -200},
    { -1240, 384, -136},
    { -1408, 296, -24},
    { -1344, 264, 16},
    { -1008, 176, -48},
    { -928, 144, -32},
    { -984, 144, -16},
    { -1064, 160, 72},
    { -1112, 88, 56},
    { -1240, 128, 64},
    { -1184, -16, -40},
    { -1064, -184, -104},
    { -1320, 72, -280},
    { -1240, 280, -448},
    { -1352, 80, -416},
    { -1432, -80, -240},
    { -1264, -16, -216},
    { -1016, 168, -192},
    { -824, 232, -32},
    { -944, 288, -24},
    { -1104, 384, -72},
    { -1008, 384, -104},
    // 30 seconds
    { -1040, 344, -64},
    { -1336, 368, 32},
    { -1216, 744, -48},
    { -1584, 800, -96},
    { -1096, 480, -208},
    { -944, 560, -240},
    { -1152, 408, -112},
    { -1216, 288, -64},
    { -1096, 200, -40},
    { -1064, 112, -24},
    { -1104, 112, 8},
    { -1160, 112, 32},
    { -1128, 8, 16},
    { -1088, 80, 40},
    { -1376, -64, 56},
    { -1192, -72, 72},
    { -1440, -80, -40},
    { -1184, 152, -464},
    { -992, 160, -480},
    { -1128, -80, -288},
    { -1024, -232, -120},
    { -976, 96, -136},
    { -928, 264, -112},
    { -1000, 272, -72},
    { -1096, 344, -32},
    // 31 seconds
    { -1144, 464, -184},
    { -1016, 456, -272},
    { -1296, 632, -336},
    { -1120, 536, -352},
    { -1672, 544, -288},
    { -1128, 328, -304},
    { -872, 336, -368},
    { -1416, 240, -232},
    { -1768, 136, -56},
    { -1296, 120, -224},
    { -1080, 184, -200},
    { -1144, 144, -72},
    { -1144, -32, -48},
    { -1056, 24, -152},
    { -1320, -320, -224},
    { -1144, -496, 192},
    { -808, -128, -168},
    { -784, -72, -272},
    { -1336, 80, -344},
    { -1464, 152, -224},
    { -1512, 112, -160},
    { -1616, 72, 64},
    { -1256, 8, 16},
    { -1064, 80, -104},
    { -976, 240, -136},
    // 32 seconds
    { -1008, 296, -144},
    { -1008, 288, -144},
    { -992, 416, -264},
    { -1000, 720, -352},
    { -1112, 472, -336},
    { -1256, 256, -448},
    { -1776, 496, -304},
    { -1168, 320, -368},
    { -1512, 264, -256},
    { -1872, 200, -96},
    { -1848, 112, -88},
    { -1528, 88, -72},
    { -1320, -96, 72},
    { -1168, 152, 24},
    { -1088, 16, 96},
    { -856, 112, 152},
    { -1040, 320, -128},
    { -744, -264, 32},
    { -560, -256, -168},
    { -1048, -136, -16},
    { -1392, 296, -152},
    { -1312, 520, -272},
    { -1368, 360, -104},
    { -1392, 136, -8},
    { -1336, 352, -136},
    // 33 seconds
    { -1152, 376, -152},
    { -1136, 320, -40},
    { -1192, 320, -8},
    { -1208, 440, -80},
    { -1040, 360, -32},
    { -1072, 528, -8},
    { -1144, 824, 16},
    { -1128, 424, -160},
    { -1440, 712, 112},
    { -1000, 528, -16},
    { -1032, 592, -48},
    { -1336, 496, 72},
    { -1520, 344, 152},
    { -1360, 168, 96},
    { -1280, 32, 80},
    { -1216, 96, 88},
    { -1216, 112, 64},
    { -1168, 216, 104},
    { -1176, 144, 88},
    { -1184, -88, 64},
    { -776, -232, -8},
    { -1176, 104, -72},
    { -1432, 288, -192},
    { -992, 80, -264},
    { -1240, 48, -208},
    // 34 seconds
    { -1216, 56, -232},
    { -1120, 120, -208},
    { -928, 208, -64},
    { -936, 264, -16},
    { -1088, 328, -8},
    { -1184, 440, -16},
    { -1104, 464, 80},
    { -1160, 664, 72},
    { -1160, 424, 24},
    { -1688, 656, 136},
    { -1080, 512, 56},
    { -976, 536, -80},
    { -1240, 448, 8},
    { -1264, 376, -24},
    { -1040, 256, -40},
    { -920, 248, -32},
    { -992, 144, -8},
    { -1072, 104, 32},
    { -1080, 120, 0},
    { -1192, 192, 96},
    { -1336, 152, 128},
    { -1160, -56, -96},
    { -1272, -144, -40},
    { -1264, 144, -144},
    { -944, 216, -248},
    // 35 seconds
    { -1096, 160, -224},
    { -1264, 40, -88},
    { -1120, 32, 16},
    { -936, 216, 80},
    { -920, 232, 96},
    { -1080, 320, 40},
    { -1160, 408, -40},
    { -984, 512, -120},
    { -1152, 704, -112},
    { -1096, 592, -80},
    { -1680, 504, -72},
    { -1184, 512, -216},
    { -1112, 544, -200},
    { -1440, 432, -32},
    { -1544, 240, 48},
    { -1304, 288, 24},
    { -1152, 224, 80},
    { -1136, 96, 96},
    { -1152, 88, 120},
    { -1144, 88, 112},
    { -1096, 96, 120},
    { -1176, 160, 176},
    { -1088, -160, 224},
    { -1304, -328, 160},
    { -1184, 64, -128},
    // 36 seconds
    { -1024, 64, -328},
    { -1368, 72, -296},
    { -1488, 0, -176},
    { -1440, 216, -184},
    { -1208, 464, 56},
    { -1024, 488, 8},
    { -1064, 328, -120},
    { -1160, 336, -40},
    { -1128, 408, -72},
    { -1232, 480, -64},
    { -1104, 576, -64},
    { -1400, 672, -104},
    { -1376, 416, -72},
    { -1048, 448, -192},
    { -1280, 432, -56},
    { -1544, 288, 40},
    { -1496, 240, 40},
    { -1208, 144, 56},
    { -1184, 120, 96},
    { -1320, 104, 80},
    { -1304, 48, -24},
    { -1208, 64, 56},
    { -1192, -120, 96},
    { -952, -432, 200},
    { -856, -336, 152},
    // 37 seconds
    { -1336, -40, -96},
    { -1376, 80, -280},
    { -1656, -112, -440},
    { -1472, -144, -160},
    { -1384, 72, -328},
    { -1216, 152, -272},
    { -1168, 248, -56},
    { -1240, 264, -56},
    { -1264, 360, -96},
    { -928, 384, -120},
    { -960, 408, -184},
    { -1000, 456, -80},
    { -1496, 688, -144},
    { -1400, 560, -120},
    { -1048, 504, -424},
    { -1264, 424, -320},
    { -1608, 384, -264},
    { -1480, 312, -184},
    { -1328, 272, -144},
    { -1336, 208, -40},
    { -1360, 176, 16},
    { -1248, 152, 72},
    { -1152, 216, -32},
    { -1352, -40, 64},
    { -944, -104, 112},
    // 38 seconds
    { -1112, -248, 40},
    { -1232, 32, -112},
    { -1232, 360, -384},
    { -1400, 408, -328},
    { -1296, 272, -176},
    { -1120, 288, -216},
    { -1024, 352, -160},
    { -1088, 280, 32},
    { -1280, 280, 160},
    { -1448, 440, 88},
    { -1216, 568, 40},
    { -1208, 736, 40},
    { -1064, 664, 16},
    { -1168, 656, 0},
    { -1256, 640, 24},
    { -1024, 632, -56},
    { -1224, 584, -72},
    { -1512, 512, 8},
    { -1440, 376, 0},
    { -1216, 288, -24},
    { -1152, 200, 8},
    { -1256, 176, 24},
    { -1328, 120, 112},
    { -1256, 128, -16},
    { -1160, 80, 16},
    // 39 seconds
    { -1048, -56, 48},
    { -808, -128, -56},
    { -1128, 8, -128},
    { -1248, 64, -232},
    { -1048, 136, -368},
    { -1288, -32, -320},
    { -1384, -144, -160},
    { -1288, -48, -176},
    { -1184, 232, -176},
    { -1120, 256, -48},
    { -1312, 424, -112},
    { -1264, 456, -168},
    { -1120, 472, -208},
    { -1160, 488, -240},
    { -1000, 584, -232},
    { -1568, 576, -184},
    { -1120, 448, -208},
    { -1144, 416, -248},
    { -1416, 328, -128},
    { -1600, 344, -72},
    { -1424, 192, -48},
    { -1288, 112, -8},
    { -1256, 56, 48},
    { -1240, 24, 24},
    { -1160, 16, -8},
    // 40 seconds
    { -1112, 80, 72},
    { -1176, -24, 48},
    { -936, -256, 88},
    { -1168, -80, -48},
    { -1120, 72, -264},
    { -1168, 80, -288},
    { -1328, -272, -48},
    { -1328, -128, -96},
    { -1152, 120, -360},
    { -976, 312, -240},
    { -1016, 208, -128},
    { -1096, 288, -200},
    { -1184, 352, -144},
    { -1232, 416, -328},
    { -1328, 480, -224},
    { -1192, 416, -456},
    { -1736, 440, -408},
    { -1272, 368, -392},
    { -1008, 320, -488},
    { -1288, 320, -288},
    { -1576, 216, -128},
    { -1432, 144, -96},
    { -1112, -24, 56},
    { -1056, -24, -16},
    { -1048, 32, -16},
    // 41 seconds
    { -1072, 40, -16},
    { -1096, 64, 0},
    { -1136, -112, 104},
    { -784, -184, -48},
    { -1120, 24, -160},
    { -1312, 144, -400},
    { -1248, 16, -416},
    { -1392, -296, -264},
    { -1440, -240, -224},
    { -1288, 48, -192},
    { -1088, 128, -40},
    { -992, 152, 72},
    { -1176, 232, 40},
    { -1296, 392, -80},
    { -1312, 352, 56},
    { -1312, 536, -8},
    { -1096, 1128, -56},
    { -1488, 208, -224},
    { -1024, 360, -360},
    { -1048, 552, -424},
    { -1312, 448, -176},
    { -1488, 288, -120},
    { -1360, 144, -128},
    { -1288, 136, -48},
    { -1344, 104, 24},
    // 42 seconds
    { -1392, 64, 48},
    { -1344, 40, 40},
    { -1240, 48, 72},
    { -1280, -352, 288},
    { -816, -872, 360},
    { -1168, -504, 288},
    { -1616, -376, -144},
    { -1832, -232, -272},
    { -2112, -192, -352},
    { -1880, -160, -360},
    { -1520, 136, -184},
    { -1088, 440, -248},
    { -1016, 400, -232},
    { -1112, 272, -136},
    { -1224, 328, -72},
    { -856, 216, -224},
    { -896, 536, -352},
    { -856, 456, -208},
    { -1512, 568, -320},
    { -1144, 568, -560},
    { -1472, 608, -552},
    { -2208, 296, -232},
    { -2128, 168, -240},
    { -1888, 160, -152},
    { -1696, 128, -64},
    // 43 seconds
    { -1568, 152, 56},
    { -1360, 96, 88},
    { -1120, 80, 80},
    { -896, 56, 112},
    { -840, 56, 40},
    { -800, -328, -120},
    { -392, -608, -32},
    { -1080, -128, 32},
    { -1496, 312, -192},
    { -1520, 448, -512},
    { -1608, 96, 176},
    { -1832, 184, 16},
    { -1696, 456, -160},
    { -1456, 504, -120},
    { -1376, 512, -104},
    { -1392, 472, -176},
    { -1272, 456, -160},
    { -1152, 536, -128},
    { -1120, 648, -56},
    { -936, 584, -136},
    { -1352, 800, -8},
    { -848, 504, -136},
    { -1184, 552, -144},
    { -1448, 480, -72},
    { -1712, 400, 24},
    // 44 seconds
    { -1536, 200, 56},
    { -1392, 88, 56},
    { -1408, 104, 24},
    { -1400, 104, 32},
    { -1328, 104, 72},
    { -1264, 104, 64},
    { -1384, -248, 240},
    { -984, -360, 192},
    { -1240, -280, 208},
    { -1320, -96, -200},
    { -1216, -8, -296},
    { -1384, -128, -240},
    { -1448, -96, -384},
    { -1432, 112, -328},
    { -1368, 224, -176},
    { -1224, 328, 32},
    { -1248, 432, -104},
    { -1240, 424, -88},
    { -1024, 376, -112},
    { -1120, 416, -72},
    { -1112, 440, -32},
    { -1464, 600, -8},
    { -1128, 528, -80},
    { -864, 504, -312},
    { -1256, 504, -208},
    // 45 seconds
    { -1552, 400, -120},
    { -1584, 264, -96},
    { -1416, 112, -48},
    { -1400, 56, 16},
    { -1360, 48, 24},
    { -1296, 64, 0},
    { -1240, 104, -24},
    { -1336, -160, 176},
    { -1072, -320, 208},
    { -1184, -264, 160},
    { -1168, -72, -160},
    { -1152, 24, -360},
    { -1408, 8, -344},
    { -1320, -312, -112},
    { -1376, -184, -136},
    { -1352, 136, -104},
    { -1288, 288, 32},
    { -1328, 416, -64},
    { -1336, 440, -104},
    { -1136, 536, -144},
    { -1224, 488, -160},
    { -976, 280, -208},
    { -1656, 440, -72},
    { -976, 472, -200},
    { -1040, 392, -272},
    // 46 seconds
    { -1352, 336, -184},
    { -1528, 288, -152},
    { -1280, 152, -152},
    { -1248, 96, -80},
    { -1352, 48, -16},
    { -1448, 48, 24},
    { -1392, 56, 24},
    { -1352, 80, 16},
    { -1504, -120, 112},
    { -1112, -288, 64},
    { -1264, -32, 80},
    { -1040, 696, -360},
    { -944, 1072, -368},
    { -856, 720, -232},
    { -560, 768, -224},
    { -120, 752, -288},
    { -48, 544, -184},
    { -8, 664, -144},
    { 88, 672, -96},
    { 72, 768, -88},
    { 56, 872, -96},
    { -120, 1024, -112},
    { -184, 1096, -80},
    { -320, 1368, -192},
    { -320, 1312, -112},
    // 47 seconds
    { -192, 1096, -152},
    { -176, 960, -96},
    { -192, 840, -144},
    { -152, 648, -176},
    { -24, 392, -240},
    { -32, 216, -248},
    { -120, 152, -200},
    { -240, 112, -168},
    { -488, 64, -96},
    { -1120, 112, -112},
    { -1952, 112, 56},
    { -2584, 264, 168},
    { -2360, 432, -192},
    { -1136, 792, -376},
    { -888, -232, -432},
    { -1224, 232, -216},
    { -1016, 176, -192},
    { -728, 120, -136},
    { -640, 96, -104},
    { -704, 192, -112},
    { -752, 528, -56},
    { -704, 1184, -144},
    { -968, 1080, 168},
    { -1472, 1304, 88},
    { -1968, 1080, 264},
    // 48 seconds
    { -1680, 936, 160},
    { -1808, 848, 192},
    { -1872, 648, 216},
    { -1456, 440, 160},
    { -1080, 216, 88},
    { -824, 136, -32},
    { -656, 104, -16},
    { -592, 48, -32},
    { -408, 112, 8},
    { -456, 112, -136},
    { -192, 344, 40},
    { 56, 1192, 64},
    { -176, 1560, 296},
    { -64, 1952, 488},
    { -24, 1480, 88},
    { -96, 1000, -24},
    { -72, 760, -112},
    { -48, 528, -96},
    { 48, 376, -96},
    { 56, 288, -48},
    { 104, 272, 16},
    { 96, 328, 16},
    { 72, 456, 88},
    { 32, 760, 136},
    { -216, 1408, 176},
    // 49 seconds
    { -224, 1712, 296},
    { -336, 1792, 304},
    { -192, 1536, 96},
    { -48, 1328, -104},
    { -80, 1008, -80},
    { -120, 760, -56},
    { -56, 656, -120},
    { -88, 536, -88},
    { -80, 400, -56},
    { -120, 336, -72},
    { -440, 304, -72},
    { -1136, 712, 192},
    { -1216, 272, 40},
    { -1192, 336, 32},
    { -1600, 544, -360},
    { -1544, 520, -896},
    { -1504, 248, -408},
    { -1528, -152, -136},
    { -1280, -48, 56},
    { -1016, 352, 144},
    { -848, 496, -24},
    { -928, 376, -88},
    { -928, 312, -80},
    { -960, 336, -104},
    { -1064, 360, -192},
    // 50 seconds
    { -1112, 328, -232},
    { -1744, 512, -208},
    { -1064, 280, -400},
    { -1352, 216, -344},
    { -1560, 272, -240},
    { -1616, 208, -168},
    { -1296, 112, -136},
    { -1256, 64, -32},
    { -1208, 24, 24},
    { -1136, 24, 0},
    { -1120, 56, -24},
    { -1128, 16, 24},
    { -1168, -88, 88},
    { -1040, -144, 72},
    { -1240, 24, 0},
    { -968, 144, -312},
    { -1136, 120, -280},
    { -1232, -8, -248},
    { -1080, -160, -256},
    { -1000, -72, -288},
    { -1024, 96, -176},
    { -1136, 200, -264},
    { -1336, 352, -424},
    { -1352, 424, -392},
    { -1504, 712, -488},
    // 51 seconds
    { -1200, -80, -344},
    { -1576, 160, -264},
    { -1176, 480, -264},
    { -1160, 384, -368},
    { -1368, 280, -296},
    { -1448, 208, -232},
    { -1120, 128, -224},
    { -1024, 64, -136},
    { -1128, 96, -168},
    { -1136, 112, 8},
    { -1088, 176, -48},
    { -1232, 128, -88},
    { -1312, -144, 288},
    { -1096, -120, 160},
    { -1384, -56, 80},
    { -1216, 32, -208},
    { -1416, 200, -336},
    { -1488, -16, -248},
    { -1152, -232, -128},
    { -1008, 32, -288},
    { -1016, 120, -288},
    { -1088, 272, -312},
    { -1120, 200, -288},
    { -1280, 360, -392},
    { -1536, 336, -184},
    // 52 seconds
    { -1304, 768, -384},
    { -1216, 440, -608},
    { -1136, 376, -488},
    { -1128, 288, -472},
    { -1528, 216, -392},
    { -1856, 168, -288},
    { -1672, 104, -192},
    { -1448, 72, -96},
    { -1288, 40, -40},
    { -1168, 48, -48},
    { -1056, 88, -16},
    { -1000, 72, -8},
    { -1120, 48, 64},
    { -1152, -104, 152},
    { -1056, -64, 80},
    { -1256, 40, 0},
    { -1032, 72, -344},
    { -1232, 120, -328},
    { -1328, -152, -312},
    { -1200, -320, -200},
    { -1240, -56, -248},
    { -1352, 112, -152},
    { -1432, 336, -72},
    { -1568, 432, -144},
    { -1520, 720, -296},
    // 53 seconds
    { -1304, 656, -328},
    { -1008, 384, -456},
    { -1568, 584, -440},
    { -1208, 320, -328},
    { -1288, 400, -384},
    { -1520, 352, -144},
    { -1696, 376, -72},
    { -1352, 328, -32},
    { -1312, 352, 16},
    { -1320, 232, 88},
    { -1304, 248, 112},
    { -1144, 160, 136},
    { -1096, 304, 64},
    { -1136, -136, -176},
    { -736, 264, 104},
    { -1048, 848, 16},
    { -784, 1184, -200},
    { -360, 1296, -248},
    { -328, 1184, -216},
    { -192, 968, -232},
    { 16, 720, -232},
    { 144, 536, -176},
    { 216, 320, -248},
    { 208, 464, -104},
    { 152, 568, -136},
    // 54 seconds
    { 144, 680, -104},
    { 96, 848, -64},
    { 120, 1160, 0},
    { 272, 1568, 0},
    { 88, 1816, -56},
    { 104, 1192, -80},
    { 136, 888, -120},
    { 112, 568, -112},
    { 0, 560, -264},
    { -32, 360, -296},
    { -48, 128, -200},
    { -152, 8, -120},
    { -256, -112, -96},
    { -464, -56, -128},
    { -1040, 8, -192},
    { -1704, 96, -8},
    { -2688, -24, 368},
    { -3248, 432, -200},
    { -2104, 776, -608},
    { -872, -384, -400},
    { -1424, -264, 32},
    { -1080, 128, -48},
    { -856, 320, -8},
    { -776, 280, -16},
    { -808, 240, -32},
    // 55 seconds
    { -664, 272, -72},
    { -832, 240, 40},
    { -1128, 328, 120},
    { -1544, 712, -56},
    { -1512, 1176, 24},
    { -1128, 168, -560},
    { -1704, 496, -304},
    { -2072, 128, -320},
    { -1544, -88, -336},
    { -1400, -32, -160},
    { -1304, -56, -40},
    { -1224, -16, -80},
    { -1176, 40, -64},
    { -1288, -112, 24},
    { -1264, -440, 456},
    { -1192, -360, 480},
    { -1520, -152, 288},
    { -1384, 120, -368},
    { -1344, 48, -48},
    { -1584, 160, -216},
    { -1376, -120, -336},
    { -1312, -240, -24},
    { -1472, 112, 64},
    { -1448, 608, -384},
    { -1344, 392, -440},
    // 56 seconds
    { -1344, 440, -464},
    { -1280, 496, -320},
    { -1120, 424, -584},
    { -1568, 608, -408},
    { -1120, 304, -432},
    { -1504, 280, -296},
    { -1848, 192, -192},
    { -1608, 80, -112},
    { -1408, 24, -56},
    { -1312, 24, 0},
    { -1296, 32, 16},
    { -1296, 56, 8},
    { -1464, 56, 80},
    { -1480, -280, 360},
    { -904, -384, 200},
    { -1344, -248, 264},
    { -1144, -96, -24},
    { -1320, -80, -40},
    { -1448, -32, -16},
    { -1488, -88, -56},
    { -1360, -48, -112},
    { -1288, 24, 0},
    { -1520, 152, -16},
    { -1728, 360, -200},
    { -1520, 648, -272},
    // 57 seconds
    { -1376, 448, -528},
    { -1336, 264, -336},
    { -1168, 480, -504},
    { -1480, 624, -408},
    { -1320, 312, -168},
    { -1568, 136, -8},
    { -1784, 48, 96},
    { -1552, 72, 80},
    { -1232, 64, -56},
    { -1056, 112, 24},
    { -960, 80, 56},
    { -1024, 232, 40},
    { -1304, 272, 208},
    { -1240, 128, 240},
    { -976, 264, 224},
    { -1296, 408, 368},
    { -888, 1064, 432},
    { -864, 1328, 152},
    { -616, 984, 552},
    { -288, 1008, 448},
    { -24, 728, 320},
    { 72, 552, 392},
    { 32, 480, 280},
    { 80, 400, 424},
    { 184, 584, 320},
    // 58 seconds
    { 72, 536, 520},
    { 56, 672, 568},
    { 48, 944, 680},
    { -168, 1016, 872},
    { -176, 1176, 872},
    { -216, 1048, 824},
    { -136, 840, 592},
    { 8, 688, 304},
    { 152, 520, 200},
    { 88, 408, 280},
    { 112, 448, 168},
    { 56, 576, 152},
    { -96, 608, 232},
    { -192, 1064, 336},
    { -192, 1136, 632},
    { -288, 1408, 672},
    { -224, 1376, 424},
    { -160, 1064, 248},
    { -184, 912, 176},
    { -264, 872, 120},
    { -208, 704, 120},
    { -120, 640, 136},
    { -136, 736, 136},
    { -72, 696, 152},
    { -200, 872, 112},
    // 59 seconds
    { -56, 840, 24},
    { -56, 944, -112},
    { -40, 1208, -384},
    { 64, 888, -576},
    { 200, 1096, -544},
    { 112, -104, -456},
    { -56, 56, -1368},
    { -272, 40, -1192},
    { -272, -144, -1176},
    { -344, -120, -1088},
    { -352, -232, -944},
    { -288, -224, -968},
    { -240, -240, -856},
    { -264, -232, -896},
    { -240, -288, -848},
    { -224, -288, -864},
    { -216, -352, -888},
    { -216, -392, -840},
    { -192, -440, -872},
    { -168, -464, -840},
    { -160, -464, -864},
    { -128, -496, -896},
    { -128, -480, -904},
    { -120, -480, -928},
    { -128, -456, -952},
    // 60 seconds
    // elapsed: 1 minutes
    { -144, -456, -944},
    { -136, -480, -912},
    { -112, -440, -888},
    { -112, -480, -880},
    { -160, -424, -920},
    { -144, -408, -904},
    { -152, -392, -856},
    { -128, -488, -712},
    { -216, -296, -800},
    { -368, -24, -880},
    { -152, -208, -736},
    { -56, 664, -680},
    { 112, 1256, -648},
    { 40, 936, -480},
    { -32, 912, -520},
    { -120, 696, -400},
    { -168, 936, -440},
    { -112, 992, -320},
    { -200, 832, -472},
    { -344, 864, -400},
    { 16, 888, -328},
    { -64, 448, -232},
    { -8, 704, -416},
    { -8, 896, -488},
    { 56, 968, -216},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-16 17:13:51 local
AccelRawData *activity_sample_walk_100_pbl_28394_3(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_28394_3
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 70
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -264, -488, -888},
    { -160, -456, -904},
    { -224, -384, -888},
    { -208, -416, -912},
    { -216, -456, -896},
    { -232, -392, -912},
    { -192, -416, -920},
    { -288, -424, -856},
    { -104, -464, -920},
    { -264, -464, -896},
    { -232, -456, -880},
    { -296, -544, -936},
    { -272, -512, -904},
    { -264, -264, -1032},
    { 336, -856, -1112},
    { -80, -384, -976},
    { -112, -400, -920},
    { -112, -368, -928},
    { -72, -400, -928},
    { -40, -400, -920},
    { -40, -400, -936},
    { -48, -352, -912},
    { -56, -416, -888},
    { -88, -400, -872},
    { -120, -440, -864},
    // 1 seconds
    { -160, -472, -872},
    { -184, -520, -904},
    { -168, -656, -984},
    { -240, -704, -856},
    { -224, -376, -960},
    { -248, -384, -920},
    { -288, -456, -936},
    { -272, -496, -880},
    { -208, -448, -888},
    { -184, -632, -896},
    { -176, -608, -848},
    { -176, -648, -776},
    { -176, -560, -808},
    { -240, -560, -848},
    { -184, -664, -952},
    { -176, -560, -856},
    { -88, -576, -936},
    { -56, -608, -856},
    { -72, -568, -784},
    { -72, -456, -880},
    { -72, -440, -864},
    { -48, -400, -920},
    { -56, -280, -1072},
    { -96, -48, -1136},
    { -192, 184, -1120},
    // 2 seconds
    { -72, 296, -952},
    { -96, 376, -936},
    { -112, 456, -816},
    { -120, 472, -632},
    { -216, 344, -592},
    { -128, 112, -496},
    { -160, 88, -432},
    { -256, 112, -376},
    { -400, 112, -256},
    { -624, 8, -216},
    { -992, -152, -232},
    { -1680, -64, -96},
    { -2704, 168, 208},
    { -2480, 408, 80},
    { -1664, 56, -328},
    { -1304, 64, -288},
    { -1304, 448, 8},
    { -1088, 336, -40},
    { -896, 24, -160},
    { -688, -24, -312},
    { -664, 104, -240},
    { -728, 176, -248},
    { -904, 304, -352},
    { -1072, 256, -424},
    { -1304, 248, -448},
    // 3 seconds
    { -1232, 128, -496},
    { -1984, 80, -304},
    { -1216, 56, -416},
    { -1528, 216, -352},
    { -1688, 128, -144},
    { -1512, 64, -112},
    { -1224, -8, -40},
    { -1024, 0, -16},
    { -968, 32, -16},
    { -952, 48, 8},
    { -896, 32, 32},
    { -1136, 8, 80},
    { -960, -192, 176},
    { -1192, -184, 160},
    { -1128, 128, -216},
    { -1296, -96, -320},
    { -1624, -80, -240},
    { -1352, -384, -200},
    { -1280, -72, -280},
    { -1160, 168, -200},
    { -1056, 224, 72},
    { -1160, 256, -40},
    { -1264, 384, -200},
    { -1416, 512, -136},
    { -1416, 704, -288},
    // 4 seconds
    { -1064, 456, -496},
    { -1568, 248, -448},
    { -912, 352, -496},
    { -1488, 384, -304},
    { -1680, 248, -168},
    { -1568, 144, -144},
    { -1384, 128, -104},
    { -1400, 128, 16},
    { -1464, 104, 80},
    { -1376, 80, 72},
    { -1264, 48, 80},
    { -1368, 64, 88},
    { -1008, -432, 320},
    { -1112, -424, 216},
    { -1144, -80, -272},
    { -1328, -120, -24},
    { -1512, -112, -168},
    { -1272, -160, -232},
    { -1112, -48, -208},
    { -1104, 32, -32},
    { -1352, 168, 144},
    { -1504, 392, -80},
    { -1584, 504, -144},
    { -1600, 1224, -264},
    { -1184, 88, -312},
    // 5 seconds
    { -1480, 280, -448},
    { -1304, 656, -344},
    { -1200, 504, -504},
    { -1544, 296, -280},
    { -1712, 288, -112},
    { -1568, 136, -56},
    { -1360, 88, -8},
    { -1480, 176, -272},
    { -1384, 32, 80},
    { -1344, 104, 104},
    { -1328, -40, 184},
    { -1144, -32, 80},
    { -904, 216, 64},
    { -1208, 432, 16},
    { -840, 800, -336},
    { -672, 720, -496},
    { -696, 384, -304},
    { -680, 272, -240},
    { -496, 256, -160},
    { -384, 280, -128},
    { -440, 216, 8},
    { -616, 664, -80},
    { -704, 1096, -8},
    { -792, 1504, -40},
    { -944, 1416, 192},
    // 6 seconds
    { -832, 1480, 152},
    { -1288, 1456, 192},
    { -904, 1224, 176},
    { -1152, 1176, 96},
    { -1112, 1056, 184},
    { -888, 904, 80},
    { -640, 704, -24},
    { -480, 384, -96},
    { -400, 216, 24},
    { -344, 72, -24},
    { -336, 48, 48},
    { -560, 56, -16},
    { -648, -192, -72},
    { -872, 264, -112},
    { -1472, 264, 48},
    { -2000, 616, -344},
    { -2216, 752, -576},
    { -1856, 192, 136},
    { -1376, 600, -232},
    { -1080, 536, -160},
    { -976, 432, -32},
    { -976, 328, 0},
    { -984, 368, -8},
    { -936, 456, -96},
    { -1128, 424, -8},
    // 7 seconds
    { -1120, 640, 88},
    { -1160, 792, -56},
    { -1520, 496, -112},
    { -1056, 576, -312},
    { -1424, 448, -224},
    { -1576, 464, -160},
    { -1704, 8, -64},
    { -1464, -56, -16},
    { -1352, -24, 32},
    { -1288, -32, 24},
    { -1136, 8, 56},
    { -1080, 64, 8},
    { -1112, 128, 80},
    { -968, -192, 192},
    { -904, -392, 152},
    { -1176, -96, -152},
    { -1208, -160, -200},
    { -1512, -32, -304},
    { -1312, -176, -224},
    { -1208, -88, -248},
    { -1104, -24, -200},
    { -1128, 88, -160},
    { -1224, 208, -104},
    { -1320, 256, -64},
    { -1336, 432, -216},
    // 8 seconds
    { -1384, 528, -320},
    { -1400, 512, -312},
    { -1616, 240, -320},
    { -1440, 272, -352},
    { -1144, 304, -432},
    { -1424, 264, -280},
    { -1536, 128, -216},
    { -1352, 96, -200},
    { -1192, 72, -144},
    { -1152, 80, -40},
    { -1184, 48, -8},
    { -1184, 56, 56},
    { -1224, 96, 144},
    { -1320, -80, 256},
    { -952, -232, 80},
    { -920, -296, -8},
    { -1408, -144, -48},
    { -1304, 16, -184},
    { -1464, 104, -152},
    { -1512, -120, -216},
    { -1312, -208, -152},
    { -1168, -32, -144},
    { -1208, 152, -72},
    { -1344, 248, 32},
    { -1256, 320, -136},
    // 9 seconds
    { -1216, 384, -216},
    { -1432, 632, -176},
    { -1192, 488, -288},
    { -1776, 528, -256},
    { -1024, 416, -344},
    { -1272, 400, -336},
    { -1392, 296, -200},
    { -1632, 176, -72},
    { -1384, 192, -80},
    { -1248, 216, -24},
    { -1328, 272, 32},
    { -1344, 232, 56},
    { -1344, 152, 112},
    { -1424, -80, 264},
    { -1184, -432, 232},
    { -1152, -424, 224},
    { -1440, -96, -88},
    { -1400, 48, -296},
    { -1544, 144, -200},
    { -1304, -72, 0},
    { -1176, -8, -40},
    { -1088, 72, -8},
    { -1136, 328, -112},
    { -1232, 272, 16},
    { -1384, 328, -56},
    // 10 seconds
    { -1424, 544, -224},
    { -1392, 824, -224},
    { -1208, 352, -360},
    { -1256, 680, -376},
    { -1256, 672, -200},
    { -1240, 432, -320},
    { -1536, 336, -176},
    { -1856, 344, -40},
    { -1688, 176, 24},
    { -1472, 112, 24},
    { -1344, 104, 24},
    { -1312, 112, 16},
    { -1256, 128, 32},
    { -1200, 80, 56},
    { -1112, -32, 200},
    { -920, -192, 160},
    { -896, -248, 24},
    { -1168, -16, -24},
    { -1232, 64, -216},
    { -1472, 80, -440},
    { -1432, 0, -224},
    { -1360, -80, -112},
    { -1368, 104, -280},
    { -1328, 336, -184},
    { -1296, 296, -40},
    // 11 seconds
    { -1504, 368, -88},
    { -1464, 672, -160},
    { -1120, 1048, -240},
    { -904, 808, -208},
    { -1016, 1000, -280},
    { -1424, 928, -8},
    { -1400, 736, -64},
    { -1680, 560, 0},
    { -1968, 240, 56},
    { -1808, 320, 72},
    { -1560, 136, 80},
    { -1448, 192, 104},
    { -1368, 112, 168},
    { -1184, 80, 168},
    { -1176, 424, 48},
    { -952, -512, -312},
    { -568, -392, -40},
    { -512, -296, -192},
    { -1160, -48, -96},
    { -1448, 0, -200},
    { -1560, 504, -584},
    { -1608, 184, -408},
    { -1528, 32, -80},
    { -1408, 224, -168},
    { -1248, 272, -136},
    // 12 seconds
    { -1264, 288, -32},
    { -1360, 328, -56},
    { -1400, 336, -24},
    { -1256, 624, -104},
    { -1248, 872, -16},
    { -936, 520, -56},
    { -1384, 720, -32},
    { -1224, 720, -88},
    { -1232, 504, -192},
    { -1520, 352, -48},
    { -1680, 248, 8},
    { -1592, 160, 16},
    { -1432, -32, 32},
    { -1336, -136, -8},
    { -1296, -136, -32},
    { -1288, 280, -80},
    { -1208, 64, -184},
    { -1128, -216, 64},
    { -904, -248, 8},
    { -1280, -216, 0},
    { -1272, -16, -144},
    { -1328, 88, -192},
    { -1328, 72, -224},
    { -1168, -64, -136},
    { -1096, 56, -216},
    // 13 seconds
    { -1128, 128, -200},
    { -1304, 192, -120},
    { -1488, 320, -184},
    { -1448, 528, -328},
    { -1304, 848, -448},
    { -1384, 0, -256},
    { -1496, 232, -440},
    { -1456, 592, -456},
    { -1032, 272, -312},
    { -1408, 312, -232},
    { -1552, 304, -184},
    { -1432, 160, -136},
    { -1232, 72, -48},
    { -1192, 56, -24},
    { -1184, 48, 8},
    { -1176, 8, 48},
    { -1136, 24, 40},
    { -1120, -152, 120},
    { -912, -384, -32},
    { -1120, -328, 24},
    { -1312, -56, -256},
    { -1272, -32, -464},
    { -1472, -208, -376},
    { -1360, -216, -272},
    { -1168, -80, -216},
    // 14 seconds
    { -1040, 72, -152},
    { -1000, 200, -64},
    { -1040, 200, -152},
    { -1192, 176, -144},
    { -1288, 304, -208},
    { -1552, 696, -360},
    { -1032, 736, -280},
    { -1768, -40, -120},
    { -984, 288, -376},
    { -1288, 408, -376},
    { -1544, 352, -184},
    { -1536, 216, -184},
    { -1240, 168, -184},
    { -1176, 80, -72},
    { -1136, 56, 112},
    { -1256, 24, -16},
    { -1280, 128, -16},
    { -1368, -48, 144},
    { -1272, -488, 248},
    { -824, -368, 80},
    { -1296, -232, -40},
    { -1312, 8, -224},
    { -1392, -24, -192},
    { -1496, -288, -168},
    { -1312, -184, -152},
    // 15 seconds
    { -1272, 32, -216},
    { -1128, 224, -136},
    { -1104, 320, -144},
    { -1120, 320, -280},
    { -1144, 368, -304},
    { -1160, 376, -328},
    { -1160, 440, -376},
    { -1192, 464, -440},
    { -1712, 480, -288},
    { -1112, 344, -416},
    { -1520, 304, -312},
    { -1760, 200, -232},
    { -1752, 88, -152},
    { -1576, 8, -104},
    { -1400, 32, 8},
    { -1200, 40, 16},
    { -1064, 24, -24},
    { -1032, 24, 16},
    { -1000, -48, 88},
    { -776, -136, 48},
    { -720, -8, -120},
    { -1136, 56, -168},
    { -1088, 392, -464},
    { -864, -360, -312},
    { -1520, -584, -88},
    // 16 seconds
    { -1584, 24, -272},
    { -1368, 136, -368},
    { -1224, 296, -424},
    { -1080, 416, -432},
    { -1152, 128, -168},
    { -1248, -40, -168},
    { -1128, 8, -312},
    { -1272, 200, -384},
    { -1328, 408, -496},
    { -1768, 448, -416},
    { -976, 328, -464},
    { -1176, 328, -432},
    { -1400, 312, -264},
    { -1560, 216, -184},
    { -1392, 168, -160},
    { -1232, 40, -80},
    { -1160, 48, -32},
    { -1152, 64, -8},
    { -1064, 88, -48},
    { -976, 104, 24},
    { -1128, -56, 200},
    { -640, -496, 16},
    { -1184, -80, -64},
    { -1528, 136, -248},
    { -1336, 72, -264},
    // 17 seconds
    { -1472, -40, -368},
    { -1336, -56, -280},
    { -1200, 72, -320},
    { -1016, 224, -264},
    { -952, 240, -128},
    { -1048, 288, -120},
    { -1136, 352, -176},
    { -1008, 320, -184},
    { -1040, 448, -264},
    { -1040, 640, -256},
    { -1272, 448, -304},
    { -1488, 424, -144},
    { -944, 368, -280},
    { -1392, 400, -200},
    { -1544, 304, -112},
    { -1480, 208, -72},
    { -1272, 144, -56},
    { -1240, 96, 8},
    { -1232, 96, 8},
    { -1136, 96, 16},
    { -1032, 64, -8},
    { -976, 104, -8},
    { -880, -176, 208},
    { -976, -224, 64},
    { -944, -96, 0},
    // 18 seconds
    { -1256, 88, -376},
    { -1504, 0, -320},
    { -1560, -208, -56},
    { -1440, -120, -136},
    { -1232, 136, -288},
    { -1008, 240, -312},
    { -968, 192, -280},
    { -1040, 144, -224},
    { -1000, 152, -248},
    { -944, 184, -304},
    { -1104, 200, -280},
    { -1152, 344, -192},
    { -1728, 432, -232},
    { -1224, 280, -208},
    { -1008, 256, -272},
    { -1264, 248, -192},
    { -1304, 184, -160},
    { -1168, 120, -128},
    { -1096, 56, -72},
    { -1056, 16, -56},
    { -1048, 40, -40},
    { -1016, 48, -24},
    { -992, 56, -16},
    { -1016, 64, 8},
    { -1192, -48, 104},
    // 19 seconds
    { -1152, -80, 8},
    { -1328, -32, 0},
    { -1176, 56, -272},
    { -1136, 72, -280},
    { -1208, -88, -152},
    { -1104, -128, -136},
    { -1024, 16, -232},
    { -872, 96, -200},
    { -848, 144, -112},
    { -944, 184, -56},
    { -1040, 296, -152},
    { -976, 392, -200},
    { -1248, 600, -224},
    { -1176, 536, -184},
    { -1744, 304, -320},
    { -1304, 312, -296},
    { -1056, 376, -344},
    { -1496, 288, -176},
    { -1560, 160, -88},
    { -1232, 120, -136},
    { -944, 48, -96},
    { -896, 56, -56},
    { -920, 40, -32},
    { -936, 48, 8},
    { -1000, 40, 112},
    // 20 seconds
    { -1072, -368, 368},
    { -1048, -240, 264},
    { -1440, 80, 256},
    { -1456, 256, -240},
    { -1256, 208, -384},
    { -1448, -56, -456},
    { -1344, -32, -472},
    { -1224, 120, -344},
    { -904, 208, -200},
    { -800, 200, -136},
    { -888, 248, -112},
    { -1048, 256, 0},
    { -984, 240, 8},
    { -1160, 280, -40},
    { -1152, 360, 24},
    { -1712, 520, -32},
    { -1232, 408, -120},
    { -1088, 400, -216},
    { -1392, 376, -80},
    { -1456, 176, -48},
    { -1264, 88, -104},
    { -1112, 104, -120},
    { -1048, 136, -16},
    { -1168, 192, 32},
    { -1200, 256, 40},
    // 21 seconds
    { -1192, 480, 104},
    { -1208, 448, 192},
    { -912, 544, 160},
    { -816, 640, 184},
    { -528, 800, 296},
    { -64, 1096, -24},
    { -304, 1016, 8},
    { -216, 904, 64},
    { -216, 704, 16},
    { -56, 536, 8},
    { 0, 440, 48},
    { 72, 360, 40},
    { 352, 368, 80},
    { 216, 384, 80},
    { 328, 528, 128},
    { 64, 1064, 344},
    { 16, 1608, 520},
    { -424, 1688, 696},
    { -216, 1720, 552},
    { 80, 1000, 576},
    { 0, 984, 472},
    { -32, 848, 336},
    { -40, 568, 224},
    { -40, 440, 96},
    { 0, 304, 24},
    // 22 seconds
    { 0, 200, 8},
    { -32, 128, 32},
    { -224, 184, -56},
    { -448, 40, 208},
    { -1112, 720, -48},
    { -1920, 1320, 240},
    { -1792, 1328, 296},
    { -1128, 1144, -72},
    { -1016, 752, -184},
    { -976, 624, -208},
    { -896, 400, 88},
    { -728, 360, 64},
    { -624, 304, 56},
    { -664, 296, 24},
    { -752, 376, 16},
    { -800, 432, -128},
    { -1120, 408, -64},
    { -1648, 448, 128},
    { -1528, 848, -72},
    { -1336, 104, -376},
    { -1096, 664, -240},
    { -1248, 440, -208},
    { -1320, 224, -176},
    { -1304, 128, -136},
    { -1024, 64, -96},
    // 23 seconds
    { -920, 0, -104},
    { -920, 40, -48},
    { -952, 8, 16},
    { -952, 160, 32},
    { -1000, 88, 40},
    { -1152, 56, 176},
    { -1024, -64, -64},
    { -1248, -32, -48},
    { -1232, 176, -376},
    { -1168, 104, -432},
    { -1328, -192, -360},
    { -1248, -224, -304},
    { -1056, -32, -264},
    { -904, 144, -144},
    { -896, 136, -16},
    { -1056, 304, 32},
    { -1128, 440, -8},
    { -976, 552, -32},
    { -1304, 576, -8},
    { -1088, 648, -56},
    { -1584, 600, -104},
    { -1184, 400, -200},
    { -984, 520, -280},
    { -1312, 432, -152},
    { -1480, 312, -64},
    // 24 seconds
    { -1328, 240, -56},
    { -1264, 136, 16},
    { -1184, 32, 48},
    { -1112, 56, -8},
    { -1032, 88, 0},
    { -984, 64, 32},
    { -1104, 64, 32},
    { -1056, -8, -16},
    { -1056, -40, -144},
    { -1232, 24, -240},
    { -944, 96, -384},
    { -1064, 8, -376},
    { -1336, -120, -240},
    { -1168, -104, -152},
    { -1064, 32, -72},
    { -1056, 216, 56},
    { -1184, 208, -8},
    { -1336, 192, -96},
    { -1392, 416, -32},
    { -1304, 720, -128},
    { -968, 1032, -248},
    { -1424, 976, -104},
    { -1024, 784, -112},
    { -1064, 664, -136},
    { -1408, 512, 64},
    // 25 seconds
    { -1720, 416, 152},
    { -1392, 328, 40},
    { -1304, 160, 96},
    { -1224, 48, 96},
    { -1176, 136, 64},
    { -1144, 216, 24},
    { -1160, 176, 40},
    { -1224, 120, 72},
    { -984, -208, -176},
    { -1024, -168, -272},
    { -1240, -56, -464},
    { -1280, -40, -392},
    { -1544, -48, -312},
    { -1560, 72, -128},
    { -1208, 160, 32},
    { -1072, 304, 16},
    { -1192, 400, 48},
    { -1264, 408, 48},
    { -1192, 464, -40},
    { -1288, 504, -32},
    { -1312, 784, 24},
    { -896, 776, -232},
    { -1600, 728, 32},
    { -1064, 536, -192},
    { -1144, 560, -240},
    // 26 seconds
    { -1416, 528, -120},
    { -1616, 280, -32},
    { -1320, 152, -40},
    { -1184, 200, -96},
    { -1296, 192, 24},
    { -1336, 168, 112},
    { -1248, 160, 80},
    { -1088, 136, 104},
    { -1136, 32, 144},
    { -1048, -88, 8},
    { -1104, -160, 48},
    { -1224, 0, -96},
    { -1136, 168, -312},
    { -1312, -16, -264},
    { -1384, -360, -136},
    { -1312, -152, -312},
    { -1104, 72, -352},
    { -1008, 104, -240},
    { -1120, 192, -232},
    { -1168, 264, -312},
    { -1072, 336, -368},
    { -1288, 296, -576},
    { -1240, 544, -656},
    { -1504, 288, -752},
    { -1480, 312, -512},
    // 27 seconds
    { -1192, 152, -488},
    { -1544, 224, -424},
    { -1888, 144, -280},
    { -1704, 144, -176},
    { -1656, 392, -96},
    { -1560, 296, -48},
    { -1176, 168, 56},
    { -792, 104, 104},
    { -696, 192, 32},
    { -392, 120, 80},
    { -544, 448, -88},
    { -336, 864, 48},
    { -104, 1080, 56},
    { -128, 1216, -24},
    { 40, 1136, -168},
    { 64, 904, -168},
    { -8, 760, -168},
    { -8, 536, -144},
    { 40, 488, -192},
    { 48, 496, -136},
    { 32, 440, -40},
    { 16, 496, -64},
    { 8, 544, -64},
    { 32, 616, -8},
    { -8, 992, -40},
    // 28 seconds
    { -112, 1568, 0},
    { -32, 1800, 72},
    { -64, 1888, -160},
    { 136, 1264, -184},
    { 176, 1048, -88},
    { 112, 952, -8},
    { -24, 824, 16},
    { -96, 664, 16},
    { -96, 416, 0},
    { -96, 264, 0},
    { -144, 216, -8},
    { -256, 200, 0},
    { -592, 280, 0},
    { -1072, 296, 8},
    { -1568, 120, 88},
    { -2600, 280, -40},
    { -2096, 216, -56},
    { -1344, 48, -192},
    { -1232, -72, -224},
    { -1360, 80, -184},
    { -1080, 176, -80},
    { -808, 240, -80},
    { -760, 240, -104},
    { -808, 280, -184},
    { -840, 296, -272},
    // 29 seconds
    { -888, 304, -288},
    { -1248, 288, -392},
    { -1416, 328, -112},
    { -1768, 160, -288},
    { -1096, 152, -296},
    { -1344, 560, -232},
    { -1720, 440, -56},
    { -1504, 144, -160},
    { -1224, 192, -168},
    { -1112, 168, 32},
    { -1072, 88, 32},
    { -968, 56, 16},
    { -896, 40, 48},
    { -816, -104, 128},
    { -824, -264, 192},
    { -824, -8, 32},
    { -1392, 96, 56},
    { -1776, 312, -136},
    { -1312, 232, -344},
    { -1400, -56, -240},
    { -1280, -248, -248},
    { -1168, 8, -240},
    { -984, 192, -96},
    { -976, 288, -64},
    { -1080, 336, -144},
    // 30 seconds
    { -1088, 288, -136},
    { -1040, 304, -224},
    { -1296, 376, -112},
    { -1208, 736, -256},
    { -1592, 424, -352},
    { -1032, 320, -344},
    { -1224, 408, -192},
    { -1536, 320, -56},
    { -1568, 168, -32},
    { -1248, 88, -72},
    { -1168, 128, -56},
    { -1224, 112, 0},
    { -1200, 80, 16},
    { -1152, 88, 64},
    { -1136, 88, 64},
    { -1112, 72, 96},
    { -1088, -24, 32},
    { -1160, 56, -80},
    { -928, 224, -464},
    { -1016, 216, -344},
    { -1168, -184, -168},
    { -1184, -360, -136},
    { -1152, -112, -224},
    { -1112, 224, -144},
    { -1136, 304, -128},
    // 31 seconds
    { -1264, 368, -160},
    { -1280, 528, -224},
    { -1152, 712, -352},
    { -1280, 536, -264},
    { -1240, 632, -432},
    { -1616, 592, -280},
    { -1024, 272, -400},
    { -1320, 256, -312},
    { -1576, 296, -136},
    { -1648, 224, -72},
    { -1256, 120, -88},
    { -1120, 96, 0},
    { -1144, 72, 32},
    { -1120, 48, 40},
    { -1136, 64, 48},
    { -1232, -32, 112},
    { -1064, -176, 168},
    { -872, -184, 80},
    { -1208, 24, -32},
    { -1160, 144, -232},
    { -1232, 160, -304},
    { -1464, -96, -328},
    { -1320, -264, -168},
    { -1112, -64, -184},
    { -1080, 232, -80},
    // 32 seconds
    { -1192, 344, 16},
    { -1272, 416, -128},
    { -1176, 360, 0},
    { -1240, 528, -120},
    { -1056, 696, -56},
    { -1304, 400, -296},
    { -1424, 416, -280},
    { -1200, 312, -448},
    { -1512, 304, -448},
    { -1664, 320, -312},
    { -1528, 120, -208},
    { -2064, -632, -256},
    { -1408, -128, 48},
    { -1248, 168, -80},
    { -1128, 216, 8},
    { -992, 104, -24},
    { -968, 48, 64},
    { -944, -56, 208},
    { -1208, 112, 0},
    { -1144, -560, -48},
    { -1376, 168, -280},
    { -1440, 128, -592},
    { -1600, -8, -648},
    { -1840, -8, -416},
    { -1960, 1304, 104},
    // 33 seconds
    { -1136, 1000, -192},
    { -1072, 624, -168},
    { -1224, 488, -96},
    { -968, 224, 8},
    { -944, 328, 0},
    { -1136, 416, 128},
    { -1088, 640, 104},
    { -1352, 664, 168},
    { -928, 632, -120},
    { -1040, 616, -160},
    { -1280, 552, -48},
    { -1592, 424, 56},
    { -1528, 128, 96},
    { -1360, 72, 56},
    { -1368, 24, 24},
    { -1304, 56, 40},
    { -1328, 96, 72},
    { -1296, 80, 80},
    { -1328, 16, 104},
    { -1040, -200, -24},
    { -872, -376, -240},
    { -1160, -216, -488},
    { -1216, -408, -312},
    { -1336, -280, -304},
    { -1248, -96, -192},
    // 34 seconds
    { -1080, 96, -144},
    { -976, 184, -40},
    { -1040, 256, -32},
    { -1200, 288, -48},
    { -1352, 248, -88},
    { -1336, 272, -120},
    { -1520, 808, -72},
    { -1152, 624, -296},
    { -1560, 976, -168},
    { -1080, 632, -168},
    { -1152, 544, -168},
    { -1496, 360, -32},
    { -1560, 256, 32},
    { -1296, 192, -56},
    { -1160, 120, -8},
    { -1168, 96, 48},
    { -1200, 96, 72},
    { -1168, 72, 96},
    { -1168, 88, 80},
    { -1176, -56, -8},
    { -808, -272, -160},
    { -1088, -96, -136},
    { -1072, -16, -448},
    { -1272, 48, -544},
    { -1304, -192, -152},
    // 35 seconds
    { -1232, -352, -80},
    { -1128, -64, -152},
    { -984, 216, -192},
    { -952, 296, -152},
    { -1040, 224, -176},
    { -1112, 168, -208},
    { -1208, 240, -464},
    { -1480, 272, -384},
    { -1392, 728, -496},
    { -1784, 112, -464},
    { -1136, 264, -496},
    { -1072, 392, -456},
    { -1320, 256, -264},
    { -1432, 104, -120},
    { -1264, 48, -96},
    { -1032, 32, -136},
    { -1000, 48, -48},
    { -1000, 64, -8},
    { -1048, 72, -24},
    { -1024, 64, 0},
    { -1144, -336, 136},
    { -864, -304, -184},
    { -1032, -200, 32},
    { -1408, 32, -136},
    { -1264, 96, -176},
    // 36 seconds
    { -1600, -16, -136},
    { -1768, 64, -232},
    { -1328, -8, -120},
    { -976, 40, -88},
    { -1008, 168, -144},
    { -1104, 224, -152},
    { -1144, 224, -248},
    { -1096, 320, -480},
    { -1112, 544, -456},
    { -1016, 440, -376},
    { -1728, 352, -280},
    { -1328, 224, -312},
    { -1552, 296, -192},
    { -1800, 320, -56},
    { -1952, 216, 48},
    { -1544, 24, 32},
    { -1272, -32, 64},
    { -1112, -72, 56},
    { -1064, -8, -8},
    { -1048, -8, -16},
    { -1080, 104, 24},
    { -1064, -288, 168},
    { -752, -296, 104},
    { -1064, -192, 80},
    { -1216, 64, -232},
    // 37 seconds
    { -1232, 96, -256},
    { -1584, 48, -280},
    { -1768, -48, -216},
    { -1632, 88, -256},
    { -1400, 232, -256},
    { -1312, 384, -184},
    { -1352, 560, -320},
    { -1280, 408, -336},
    { -1008, 616, -456},
    { -880, 736, -392},
    { -808, 528, -264},
    { -1392, 744, -304},
    { -1432, 656, -296},
    { -2112, 496, -136},
    { -2112, 296, -368},
    { -1952, 248, -488},
    { -1696, 192, -336},
    { -1464, 120, -240},
    { -1152, 144, -32},
    { -824, 64, -96},
    { -712, 64, -64},
    { -744, 48, 88},
    { -688, 16, 136},
    { -608, 16, 168},
    { -928, 208, -168},
    // 38 seconds
    { -1104, -48, 16},
    { -1632, 536, -440},
    { -1872, 496, -776},
    { -1800, 216, -488},
    { -1176, 120, -208},
    { -1128, 248, -232},
    { -1288, 512, -296},
    { -1368, 472, -256},
    { -1232, 472, -240},
    { -1136, 600, -400},
    { -1088, 792, -360},
    { -1016, 664, -344},
    { -1312, 624, -208},
    { -1272, 616, -216},
    { -1296, 528, -280},
    { -1440, 424, -232},
    { -1600, 336, -104},
    { -1384, 200, -40},
    { -1248, 184, -40},
    { -1304, 72, -160},
    { -1272, 168, -32},
    { -1240, 120, 16},
    { -1184, 32, 72},
    { -1280, -56, 168},
    { -1048, -312, 176},
    // 39 seconds
    { -1216, -128, -48},
    { -1208, 48, -264},
    { -1232, 152, -424},
    { -1448, -120, -176},
    { -1224, -248, -64},
    { -1080, -64, -168},
    { -952, 216, -192},
    { -920, 120, -88},
    { -1064, 216, -72},
    { -1160, 328, -168},
    { -1216, 280, -176},
    { -1528, 264, -184},
    { -1256, 576, -296},
    { -1528, 568, -464},
    { -1200, 296, -480},
    { -920, 256, -488},
    { -1360, 304, -232},
    { -1568, 200, -64},
    { -1240, 112, -160},
    { -1072, 112, -136},
    { -1080, 128, -40},
    { -1152, 72, 8},
    { -1112, 64, 40},
    { -1120, 88, 88},
    { -1264, 104, 80},
    // 40 seconds
    { -1296, -160, 136},
    { -1400, -200, 56},
    { -1296, 24, -384},
    { -1160, 104, -440},
    { -1128, -248, -232},
    { -984, -328, -96},
    { -856, -64, -176},
    { -808, 152, -144},
    { -912, 208, -112},
    { -1088, 248, -168},
    { -1392, 320, -256},
    { -1344, 400, -216},
    { -1352, 1080, -312},
    { -1224, -40, -472},
    { -1656, 280, -400},
    { -1088, 384, -448},
    { -1160, 352, -440},
    { -1392, 312, -248},
    { -1352, 232, -128},
    { -1168, 120, -104},
    { -1056, 96, -64},
    { -1056, 88, -24},
    { -1040, 88, -16},
    { -1040, 104, 16},
    { -1072, 80, 112},
    // 41 seconds
    { -1376, -184, 192},
    { -1152, -208, -16},
    { -1312, -8, -152},
    { -1176, 200, -560},
    { -1224, -8, -408},
    { -1240, -448, -240},
    { -1208, -312, -144},
    { -1040, 80, -240},
    { -888, 248, -192},
    { -888, 224, -144},
    { -1048, 208, -168},
    { -1136, 232, -272},
    { -1240, 248, -224},
    { -1304, 696, -320},
    { -1352, 120, -408},
    { -1608, 256, -288},
    { -976, 336, -440},
    { -1296, 320, -368},
    { -1392, 224, -224},
    { -1376, 176, -176},
    { -1168, 104, -104},
    { -1064, 24, -56},
    { -1056, 16, 8},
    { -1024, 32, 24},
    { -1024, 80, -64},
    // 42 seconds
    { -1176, -48, 40},
    { -1080, -256, 88},
    { -968, -232, 16},
    { -1320, -64, -152},
    { -1296, 128, -472},
    { -1360, 8, -408},
    { -1408, -288, -176},
    { -1288, -216, -136},
    { -1112, 64, -160},
    { -896, 208, -96},
    { -888, 328, -80},
    { -960, 344, -208},
    { -976, 248, -184},
    { -1240, 576, -416},
    { -1128, 608, -176},
    { -1520, 736, -504},
    { -1488, 560, -384},
    { -1136, 552, -504},
    { -1400, 448, -480},
    { -1632, 336, -376},
    { -1600, 328, -328},
    { -1352, 200, -200},
    { -1240, 88, -88},
    { -1024, 88, -64},
    { -816, 56, -16},
    // 43 seconds
    { -688, 8, 24},
    { -672, 8, 88},
    { -760, -144, 240},
    { -840, -272, -152},
    { -1312, 176, 104},
    { -1376, 384, -264},
    { -1472, 448, -584},
    { -1720, 256, -496},
    { -1776, 360, -488},
    { -1280, 208, -312},
    { -1160, 416, -280},
    { -1144, 520, -216},
    { -1064, 456, -168},
    { -920, 480, -224},
    { -800, 504, -216},
    { -912, 688, -176},
    { -872, 584, -168},
    { -1616, 696, -40},
    { -1336, 608, -264},
    { -1376, 600, -352},
    { -1808, 440, -368},
    { -1952, 288, -272},
    { -1696, 184, -168},
    { -1432, 144, -72},
    { -1120, 256, -64},
    // 44 seconds
    { -912, 264, 48},
    { -832, 400, 96},
    { -760, 408, 56},
    { -680, 472, 16},
    { -464, 544, -216},
    { -360, 688, -216},
    { 0, 1032, -544},
    { 40, 1216, -704},
    { -16, 1000, -624},
    { 72, 744, -520},
    { 176, 440, -432},
    { 224, 248, -320},
    { 232, 160, -216},
    { 368, 176, -120},
    { 320, 336, -120},
    { 336, 568, -32},
    { 208, 960, 16},
    { 216, 1248, 40},
    { 16, 1824, -72},
    { 0, 1768, -304},
    { 40, 1456, -432},
    { 16, 1072, -496},
    { 8, 528, -400},
    { -88, 160, -328},
    { -96, 24, -216},
    // 45 seconds
    { -104, 0, -192},
    { -224, 64, -216},
    { -464, 104, -240},
    { -928, 72, -112},
    { -1504, -24, 56},
    { -2024, -8, 160},
    { -3112, 48, 360},
    { -2200, 296, -656},
    { -1376, 464, -448},
    { -1232, -40, -104},
    { -1088, -56, 24},
    { -768, 64, -64},
    { -608, 120, -88},
    { -584, 232, -128},
    { -656, 312, -96},
    { -656, 328, -200},
    { -944, 680, -248},
    { -1136, 640, -224},
    { -1320, 624, -488},
    { -1848, 248, -320},
    { -1784, 304, -592},
    { -2704, 456, -368},
    { -2384, 424, -344},
    { -1960, 512, -280},
    { -1488, 416, -24},
    // 46 seconds
    { -1064, 408, 104},
    { -680, 552, 104},
    { -416, 528, 136},
    { -352, 560, 184},
    { -96, 512, 112},
    { 128, 576, 40},
    { 280, 472, -304},
    { 96, 776, -520},
    { -144, 640, -584},
    { -400, 568, -680},
    { -416, 600, -680},
    { -480, 288, -736},
    { -280, 512, -472},
    { -232, 560, -456},
    { -192, 216, -664},
    { -160, 336, -584},
    { -288, 424, -704},
    { -576, 632, -640},
    { -368, 496, -496},
    { -808, 552, -1328},
    { -592, 1304, -792},
    { -200, 1224, -576},
    { -152, 688, -512},
    { -328, 368, -544},
    { -632, 712, -760},
    // 47 seconds
    { -784, 656, -672},
    { -664, 648, -368},
    { -560, 520, -392},
    { -440, 56, -536},
    { -320, 104, -488},
    { -480, -552, -592},
    { -440, -720, -640},
    { -1056, -928, -1024},
    { -728, -912, -1096},
    { -296, -272, -448},
    { -184, 464, -24},
    { -328, 608, -112},
    { -440, 784, -32},
    { -184, 216, 80},
    { 96, 248, -104},
    { -40, 680, -72},
    { 120, 240, 312},
    { 408, 864, 144},
    { 128, 880, -184},
    { 208, 1104, 88},
    { 216, 1680, 1040},
    { 880, 2648, 1392},
    { 64, 2152, 1856},
    { 360, 1152, 1112},
    { 224, 824, 864},
    // 48 seconds
    { 120, 560, 720},
    { 72, 376, 608},
    { 24, 400, 392},
    { 24, 240, 384},
    { 16, 152, 328},
    { -24, 80, 192},
    { -16, 0, 488},
    { -216, 168, 304},
    { -480, 448, 336},
    { -632, 1000, 480},
    { -1120, 2024, 896},
    { -656, 1856, 832},
    { -296, 1728, -40},
    { -552, 1160, -184},
    { -464, 856, -64},
    { -512, 432, 96},
    { -480, 384, 72},
    { -512, 184, 200},
    { -616, 440, 224},
    { -696, 360, 184},
    { -728, 448, 232},
    { -968, 544, 224},
    { -1352, 776, 232},
    { -1736, 872, 424},
    { -1624, 744, 656},
    // 49 seconds
    { -808, 800, -72},
    { -1040, 848, -64},
    { -1104, 520, 64},
    { -1056, 360, -8},
    { -888, 296, -8},
    { -832, 232, 0},
    { -904, 112, 56},
    { -936, 32, 64},
    { -992, 16, 40},
    { -1128, -8, 72},
    { -1296, -248, 248},
    { -1144, -280, 192},
    { -1528, 144, 24},
    { -1216, 328, -264},
    { -1296, 224, -424},
    { -1280, -80, -88},
    { -968, -248, -56},
    { -936, 0, -88},
    { -864, 280, -32},
    { -904, 384, -32},
    { -1016, 392, -64},
    { -952, 384, -168},
    { -944, 400, -208},
    { -1240, 248, -160},
    { -1576, 256, -368},
    // 50 seconds
    { -1592, 384, -248},
    { -1048, 272, -368},
    { -1416, 320, -200},
    { -1632, 272, -64},
    { -1296, 168, -56},
    { -1056, 96, -16},
    { -1000, 24, 40},
    { -1008, 16, 32},
    { -1008, 24, 32},
    { -976, 40, 56},
    { -1136, -160, 280},
    { -984, -144, 256},
    { -1256, -16, 56},
    { -1432, 88, -168},
    { -1360, 224, -312},
    { -1320, -184, -208},
    { -1216, -432, -192},
    { -1120, -160, -256},
    { -968, 152, -96},
    { -1000, 304, -56},
    { -1144, 424, -120},
    { -1088, 400, -216},
    { -1056, 400, -256},
    { -1184, 528, -248},
    { -1136, 48, -272},
    // 51 seconds
    { -1784, 216, -104},
    { -1256, 448, -104},
    { -1192, 456, -200},
    { -1584, 336, -80},
    { -1640, 216, -56},
    { -1280, 144, -152},
    { -1208, 24, -24},
    { -1288, -112, 80},
    { -1192, -152, -16},
    { -1024, -32, 0},
    { -984, 56, 16},
    { -1048, 72, 32},
    { -872, 64, -32},
    { -1104, 64, -32},
    { -1024, 144, -392},
    { -928, 144, -368},
    { -1192, -96, -392},
    { -1248, -392, -168},
    { -1296, -168, -176},
    { -1248, 224, -184},
    { -1168, 344, -88},
    { -1216, 360, -64},
    { -1232, 288, -88},
    { -1168, 96, -152},
    { -1296, 448, -176},
    // 52 seconds
    { -1168, 640, -144},
    { -1416, 704, -88},
    { -1232, 592, -96},
    { -856, 632, -208},
    { -1176, 560, -88},
    { -1352, 448, 24},
    { -1368, 296, 88},
    { -1176, 208, 88},
    { -1136, 144, 120},
    { -1176, 64, 144},
    { -1208, 56, 104},
    { -1168, 48, 120},
    { -1232, 32, 144},
    { -1160, 32, 120},
    { -1128, -288, 216},
    { -1224, 160, -496},
    { -1120, 200, -552},
    { -1216, -248, -272},
    { -1376, -760, -64},
    { -1192, -424, -184},
    { -1040, -8, -280},
    { -944, 48, -152},
    { -1008, 176, -16},
    { -1088, 264, -32},
    { -1064, 392, -168},
    // 53 seconds
    { -1088, 464, -200},
    { -1288, 720, -256},
    { -1088, 552, -336},
    { -1816, 208, -112},
    { -1040, 272, -400},
    { -1048, 416, -464},
    { -1256, 392, -368},
    { -1376, 280, -280},
    { -1232, 184, -232},
    { -1184, 88, -136},
    { -1240, 72, -80},
    { -1240, 88, -32},
    { -1080, 344, -136},
    { -1040, 240, -208},
    { -904, 224, 72},
    { -752, 216, -8},
    { -1072, 464, 8},
    { -856, 656, -264},
    { -632, 1000, -224},
    { -816, 1024, -472},
    { -800, 1096, -392},
    { -640, 904, -448},
    { -424, 760, -448},
    { -232, 672, -296},
    { -120, 608, -248},
    // 54 seconds
    { -56, 776, -120},
    { -8, 704, -72},
    { 64, 808, -40},
    { 80, 856, -120},
    { 104, 808, -152},
    { 104, 752, -208},
    { 152, 672, -208},
    { 192, 720, -192},
    { 160, 840, -256},
    { 120, 1040, -304},
    { 112, 1168, -496},
    { 128, 1008, -608},
    { 152, 752, -688},
    { 184, 352, -568},
    { 152, 136, -792},
    { 56, -96, -872},
    { 48, -160, -1056},
    { 24, -240, -960},
    { -32, -304, -936},
    { -8, -336, -896},
    { -16, -336, -920},
    { -32, -336, -920},
    { -48, -448, -888},
    { -64, -336, -960},
    { -40, -400, -856},
    // 55 seconds
    { 40, -320, -936},
    { 96, -224, -832},
    { 120, 184, -840},
    { 104, 528, -872},
    { 128, 592, -856},
    { 72, 616, -872},
    { 40, 552, -696},
    { 8, 264, -808},
    { 8, 760, -720},
    { 96, 608, -736},
    { 80, 768, -680},
    { 64, 560, -592},
    { 0, 600, -576},
    { 40, 552, -752},
    { 96, 776, -408},
    { 136, 600, -584},
    { 168, 872, -296},
    { 88, 888, -360},
    { 152, 776, -272},
    { 152, 904, -224},
    { 88, 840, -232},
    { 24, 968, -264},
    { 56, 1032, -352},
    { 168, 768, -312},
    { 152, 1008, -344},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-16 17:15:04 local
AccelRawData *activity_sample_walk_100_pbl_28394_4(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_28394_4
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -96, 992, 88},
    { -64, 936, -56},
    { -24, 952, -120},
    { -32, 912, -376},
    { -104, 904, -368},
    { -120, 800, -568},
    { -160, 760, -632},
    { -152, 576, -720},
    { -168, 376, -848},
    { -136, 352, -856},
    { -72, 256, -912},
    { -16, 256, -904},
    { 56, 240, -800},
    { -32, 160, -904},
    { -40, 56, -928},
    { -48, 80, -968},
    { -40, 56, -1000},
    { 0, 112, -1000},
    { -48, -32, -984},
    { 0, 88, -1056},
    { -48, -104, -968},
    { -184, -40, -1008},
    { -168, -160, -1000},
    { -64, -136, -1112},
    { 32, -472, -1000},
    // 1 seconds
    { 40, -48, -1056},
    { 96, 88, -968},
    { 64, 48, -984},
    { 88, 72, -944},
    { 120, 80, -952},
    { 160, 128, -936},
    { 224, 128, -936},
    { 224, 56, -944},
    { 200, 88, -928},
    { 184, 0, -952},
    { 208, 8, -936},
    { 184, -48, -904},
    { 216, -72, -888},
    { 144, -120, -936},
    { 256, 104, -872},
    { 208, 240, -856},
    { 208, 232, -824},
    { 256, 240, -784},
    { 144, 216, -808},
    { 192, 352, -800},
    { 152, 296, -752},
    { 40, 824, -704},
    { 112, 904, -792},
    { 8, 872, -800},
    { 128, 656, -936},
    // 2 seconds
    { 136, 296, -912},
    { 136, 176, -864},
    { 112, -64, -864},
    { 72, -24, -896},
    { 80, -80, -928},
    { 40, -40, -936},
    { 32, -16, -984},
    { 32, -88, -984},
    { 88, -16, -1000},
    { 104, -96, -984},
    { 112, -56, -976},
    { 88, -88, -960},
    { 80, -144, -944},
    { 56, -200, -888},
    { 40, -224, -784},
    { 24, -272, -672},
    { -48, -248, -600},
    { -64, -80, -584},
    { -144, -216, -592},
    { -320, -168, -584},
    { -536, -216, -368},
    { -904, -88, -248},
    { -1320, -128, -96},
    { -2072, -136, -48},
    { -2320, -40, 16},
    // 3 seconds
    { -1832, 112, -24},
    { -1600, 192, -96},
    { -1528, 352, -40},
    { -1408, 392, -16},
    { -1272, 304, -112},
    { -1120, 136, 8},
    { -1120, 240, -80},
    { -1104, 264, -128},
    { -1040, 264, -192},
    { -1016, 328, -280},
    { -1056, 280, -552},
    { -960, 296, -464},
    { -1016, 272, -520},
    { -1200, 272, -568},
    { -1600, 296, -568},
    { -1464, 160, -360},
    { -1568, 184, -240},
    { -1976, 296, -40},
    { -2024, 144, 88},
    { -1776, 80, 120},
    { -1512, 72, 112},
    { -1296, 72, 96},
    { -1024, 80, 72},
    { -808, 96, 16},
    { -736, 96, -32},
    // 4 seconds
    { -736, 72, 0},
    { -600, -80, 40},
    { -376, -136, -160},
    { -696, -72, -120},
    { -920, -56, -144},
    { -1384, 40, -336},
    { -1520, 40, -352},
    { -1976, -40, -80},
    { -1856, 8, -64},
    { -1632, 96, -320},
    { -1368, 184, -128},
    { -1352, 288, 96},
    { -1344, 344, 72},
    { -1216, 328, -152},
    { -952, 280, -224},
    { -1176, 272, -336},
    { -1192, 376, -224},
    { -1560, 760, -232},
    { -1208, 352, -232},
    { -864, 408, -472},
    { -1256, 560, -344},
    { -1640, 512, -128},
    { -1904, 336, 72},
    { -1776, 8, 264},
    { -1584, -184, 320},
    // 5 seconds
    { -1416, -256, 248},
    { -1328, -56, 0},
    { -1232, 32, 8},
    { -1224, 80, 120},
    { -936, -32, -152},
    { -1064, -160, -248},
    { -1280, -144, -664},
    { -960, -168, -520},
    { -1040, -440, -224},
    { -1152, -176, -288},
    { -1096, 80, -152},
    { -1072, 176, -48},
    { -1224, 232, -32},
    { -1400, 336, -16},
    { -1656, 464, -64},
    { -1656, 552, -568},
    { -1088, 1128, -648},
    { -1240, 664, -520},
    { -1336, 496, -600},
    { -1312, 544, -448},
    { -1144, 504, -432},
    { -1376, 384, -240},
    { -1584, 320, -112},
    { -1480, 240, -128},
    { -1328, 208, -96},
    // 6 seconds
    { -1304, 120, -16},
    { -1320, 72, 32},
    { -1280, 40, -8},
    { -1184, 104, 48},
    { -1248, 168, 48},
    { -1112, -128, 88},
    { -1000, -376, 96},
    { -1136, -96, -384},
    { -1072, -264, -456},
    { -1264, -272, -280},
    { -1296, -248, -272},
    { -1200, -56, -216},
    { -1144, 136, -72},
    { -1184, 256, 64},
    { -1384, 416, -80},
    { -1448, 600, -120},
    { -1224, 944, -272},
    { -1296, -24, -320},
    { -1160, 488, -208},
    { -1320, 904, -256},
    { -1496, 648, -176},
    { -1208, 280, -344},
    { -1496, 376, -224},
    { -1704, 336, -72},
    { -1424, 160, -64},
    // 7 seconds
    { -1200, 144, -40},
    { -1232, 112, 80},
    { -1264, 80, 112},
    { -1208, 72, 112},
    { -1096, 96, 96},
    { -1168, 144, 16},
    { -880, -360, 104},
    { -1136, -184, 0},
    { -1112, -32, -408},
    { -1056, -72, -320},
    { -1408, -208, -248},
    { -1352, -208, -168},
    { -1304, 16, -136},
    { -1328, 320, -80},
    { -1296, 416, 0},
    { -1368, 472, -104},
    { -1352, 720, -232},
    { -1168, 616, -216},
    { -1216, 576, -296},
    { -1152, 704, -464},
    { -1624, 800, -400},
    { -1264, 464, -400},
    { -1544, 352, -264},
    { -1816, 296, -88},
    { -1776, 240, -32},
    // 8 seconds
    { -1352, 136, -32},
    { -1200, 120, 0},
    { -1152, 72, 48},
    { -1088, 96, 24},
    { -1000, 112, 32},
    { -1016, 40, 56},
    { -848, -192, 112},
    { -952, -168, 24},
    { -1112, -24, -96},
    { -1224, 176, -328},
    { -1400, 160, -344},
    { -1576, -72, -96},
    { -1712, -40, -80},
    { -1584, 184, -136},
    { -1248, 304, 128},
    { -1224, 456, -32},
    { -1304, 288, 32},
    { -1208, 296, 0},
    { -1216, 320, -8},
    { -1232, 392, 8},
    { -1352, 608, -56},
    { -1384, 632, -144},
    { -1000, 624, -288},
    { -1112, 680, -336},
    { -1440, 568, -216},
    // 9 seconds
    { -1664, 392, -120},
    { -1504, 208, -24},
    { -1424, 40, 104},
    { -1304, -24, 288},
    { -1296, -56, 0},
    { -1240, 88, 16},
    { -1392, 128, 112},
    { -1328, -128, 264},
    { -1120, -152, 328},
    { -1496, -72, 160},
    { -1152, 0, -80},
    { -1216, 40, -136},
    { -1048, -168, -48},
    { -1024, 80, -216},
    { -1152, 224, -216},
    { -1432, 400, -112},
    { -1584, 448, 152},
    { -1600, 760, 288},
    { -1040, 728, -288},
    { -1296, 680, -360},
    { -1088, 840, -32},
    { -1192, 904, -344},
    { -1376, 632, -272},
    { -1096, 512, -344},
    { -1392, 480, -248},
    // 10 seconds
    { -1784, 312, 0},
    { -1880, 264, 64},
    { -1656, 232, 64},
    { -1456, 176, 80},
    { -1272, 192, 80},
    { -1136, 112, 88},
    { -1016, 16, -56},
    { -1024, -72, 88},
    { -816, -344, 80},
    { -808, -296, -128},
    { -1136, -248, 0},
    { -1288, -80, -352},
    { -1224, -80, -552},
    { -1424, -136, -296},
    { -1488, -136, -248},
    { -1456, 40, -304},
    { -1384, 168, -264},
    { -1368, 272, -152},
    { -1352, 544, -376},
    { -1080, 600, -560},
    { -1072, 528, -712},
    { -1048, 408, -640},
    { -1104, 448, -632},
    { -1704, 488, -496},
    { -1424, 440, -336},
    // 11 seconds
    { -1200, 328, -344},
    { -1488, 296, -160},
    { -1568, 344, -56},
    { -1416, 184, -64},
    { -1192, 120, -80},
    { -1152, 128, -48},
    { -1216, 128, -48},
    { -1208, 120, -32},
    { -1056, 128, -104},
    { -968, 48, -136},
    { -616, -296, -288},
    { -776, -104, -352},
    { -1232, -248, -384},
    { -1488, -256, -552},
    { -1352, -360, -184},
    { -1304, -184, -248},
    { -1184, 104, -248},
    { -1144, 352, -168},
    { -1232, 368, -88},
    { -1384, 560, -64},
    { -1296, 968, -152},
    { -1040, 824, -184},
    { -1088, 896, -328},
    { -928, 1008, -304},
    { -1592, 928, -256},
    // 12 seconds
    { -1152, 632, -368},
    { -1368, 552, -256},
    { -1608, 440, -72},
    { -1472, 256, -64},
    { -1096, 176, -96},
    { -1040, 192, -96},
    { -1136, 136, -80},
    { -1184, 80, -80},
    { -1120, 208, 96},
    { -1160, 136, 0},
    { -984, -200, 96},
    { -640, -272, -168},
    { -1128, -8, -112},
    { -1248, 312, -328},
    { -1432, 472, -536},
    { -1432, 160, -328},
    { -1288, -24, -160},
    { -1128, 152, -80},
    { -976, 352, 48},
    { -1056, 440, -88},
    { -992, 320, -16},
    { -840, 256, 40},
    { -1216, 536, -56},
    { -1416, 672, 112},
    { -1280, 976, -96},
    // 13 seconds
    { -1408, 880, -192},
    { -1136, 792, -440},
    { -1280, 752, -312},
    { -1544, 432, -128},
    { -1512, 368, -64},
    { -1264, 376, -88},
    { -1224, 400, -8},
    { -1248, 328, 72},
    { -1192, 280, 16},
    { -1000, 160, 136},
    { -936, 168, 64},
    { -944, -64, 264},
    { -704, -960, -336},
    { -1280, -400, -272},
    { -1848, 408, -160},
    { -1640, 632, -328},
    { -1792, 776, -128},
    { -1568, 632, -16},
    { -1360, 416, 296},
    { -1160, 528, 224},
    { -1248, 600, 32},
    { -1280, 600, 48},
    { -1152, 528, 80},
    { -928, 544, 104},
    { -896, 656, 224},
    // 14 seconds
    { -760, 624, 280},
    { -912, 728, 368},
    { -1176, 760, 352},
    { -1408, 664, 392},
    { -1720, 648, 416},
    { -1696, 624, 200},
    { -1448, 480, 200},
    { -1544, 192, 352},
    { -1576, 32, 296},
    { -1424, 112, 128},
    { -1344, 192, 96},
    { -1032, 32, 0},
    { -1064, -256, 112},
    { -952, -464, -16},
    { -1448, -176, 152},
    { -1552, -16, -224},
    { -1536, 128, -24},
    { -1544, 368, 104},
    { -1264, 512, -24},
    { -1248, 568, 8},
    { -1200, 432, 256},
    { -1208, 368, 192},
    { -1280, 440, 168},
    { -1368, 400, 72},
    { -1224, 568, 288},
    // 15 seconds
    { -920, 968, 176},
    { -912, 848, 152},
    { -1488, 648, 552},
    { -928, 648, 96},
    { -1264, 600, 208},
    { -1352, 504, 264},
    { -1240, 384, 208},
    { -1088, 248, 152},
    { -1144, 48, 208},
    { -1288, 216, 248},
    { -1360, 240, 64},
    { -1376, 176, 88},
    { -1376, -24, -48},
    { -1296, -144, -480},
    { -1176, -256, -208},
    { -1472, 16, -504},
    { -1616, 296, -472},
    { -1624, 80, -160},
    { -1400, -16, -96},
    { -1192, 88, -232},
    { -1008, 336, -88},
    { -872, 320, 40},
    { -1088, 272, 24},
    { -1376, 288, -112},
    { -1296, 552, -104},
    // 16 seconds
    { -1160, 1280, -128},
    { -904, 88, -224},
    { -1408, 656, -144},
    { -1328, 584, -128},
    { -1200, 416, -192},
    { -1432, 336, -48},
    { -1632, 328, -120},
    { -1488, 176, -176},
    { -1448, 232, -128},
    { -1400, 8, -72},
    { -1392, 40, -16},
    { -1360, 56, 8},
    { -1264, -16, -8},
    { -1104, -312, 256},
    { -872, -344, 120},
    { -1096, -256, 48},
    { -1264, -48, -80},
    { -1304, 56, -200},
    { -1432, -112, -248},
    { -1336, -264, -176},
    { -1240, -152, -176},
    { -1224, 16, -208},
    { -1264, 56, -64},
    { -1328, 208, -24},
    { -1440, 344, -160},
    // 17 seconds
    { -1304, 328, -128},
    { -1384, 672, -224},
    { -1136, 384, -208},
    { -1520, 568, -184},
    { -1048, 384, -264},
    { -1128, 408, -360},
    { -1400, 352, -216},
    { -1656, 248, -104},
    { -1416, 96, -80},
    { -1264, 88, -40},
    { -1240, 72, 8},
    { -1240, 56, 32},
    { -1224, 112, 56},
    { -1232, 40, 48},
    { -1312, -152, 104},
    { -952, -368, 144},
    { -800, -432, 40},
    { -1320, -80, -96},
    { -1488, -16, -72},
    { -1576, 120, -312},
    { -1384, -200, -112},
    { -1304, -168, -56},
    { -1176, 72, -120},
    { -1056, 232, -104},
    { -1112, 256, 16},
    // 18 seconds
    { -1168, 304, -40},
    { -1072, 360, -224},
    { -1024, 464, -232},
    { -1120, 864, -552},
    { -1008, 232, -272},
    { -1544, 296, -440},
    { -1472, 320, -392},
    { -1688, 328, -336},
    { -2192, 264, -192},
    { -1952, 56, -136},
    { -1576, 8, -56},
    { -1424, -8, 0},
    { -1240, 72, 40},
    { -976, 8, -56},
    { -904, 16, -40},
    { -816, 0, 8},
    { -776, -16, 112},
    { -576, -64, -24},
    { -912, -24, -64},
    { -1088, -336, -192},
    { -1368, 56, -624},
    { -1560, -8, -536},
    { -1704, -208, -416},
    { -1736, -40, -544},
    { -1576, 136, -304},
    // 19 seconds
    { -1376, 208, -24},
    { -1376, 464, -184},
    { -1360, 400, -160},
    { -1168, 336, -136},
    { -1040, 280, -184},
    { -1152, 392, -144},
    { -992, 480, -128},
    { -1360, 632, -184},
    { -1272, 544, -176},
    { -1008, 496, -512},
    { -1232, 416, -320},
    { -1640, 368, -176},
    { -1592, 136, -56},
    { -1512, 120, 0},
    { -1552, 136, 8},
    { -1480, 72, 40},
    { -1360, 16, 64},
    { -1264, 40, 88},
    { -1288, 16, 168},
    { -1032, -160, 320},
    { -1176, -104, 192},
    { -1168, -72, -160},
    { -1064, -240, -448},
    { -1232, -184, -296},
    { -1200, -432, -88},
    // 20 seconds
    { -1160, -240, -120},
    { -1224, 24, -80},
    { -1280, 168, 8},
    { -1416, 432, 112},
    { -1456, 584, -104},
    { -1168, 568, -72},
    { -1272, 392, -144},
    { -1168, 288, -56},
    { -1616, 424, -96},
    { -1296, 488, -248},
    { -880, 448, -352},
    { -1192, 400, -256},
    { -1360, 304, -176},
    { -1320, 200, -160},
    { -1200, 72, -64},
    { -1200, 16, -24},
    { -1296, 32, 24},
    { -1248, 24, 64},
    { -1176, 80, 64},
    { -1272, 112, 104},
    { -1264, 80, -256},
    { -1408, -224, 184},
    { -1248, -96, -320},
    { -904, -80, -320},
    { -1224, -368, -200},
    // 21 seconds
    { -1064, -264, -56},
    { -912, -32, -72},
    { -768, 64, -152},
    { -856, 136, -16},
    { -1080, 176, 48},
    { -1392, 424, 0},
    { -1432, 512, -40},
    { -1392, 1312, -56},
    { -1088, 232, -408},
    { -1928, 664, -136},
    { -1184, 712, -304},
    { -1072, 584, -392},
    { -1504, 376, -168},
    { -1352, 304, -144},
    { -1112, 240, -120},
    { -992, 96, -40},
    { -1000, 32, 24},
    { -1048, 96, 88},
    { -1088, 96, 112},
    { -1240, 72, 160},
    { -1360, -224, 96},
    { -880, -248, -80},
    { -1472, -184, -64},
    { -1216, 184, -552},
    { -984, 144, -464},
    // 22 seconds
    { -1232, -248, -120},
    { -1152, -368, -112},
    { -1120, 16, -120},
    { -1080, 352, -152},
    { -1136, 440, -216},
    { -1152, 400, -232},
    { -1064, 448, -352},
    { -800, 728, -456},
    { -1240, 264, -312},
    { -1072, 544, -360},
    { -1896, 696, -192},
    { -1304, 352, -224},
    { -1552, 336, -136},
    { -1632, 296, -32},
    { -1504, 184, -128},
    { -1144, 112, -168},
    { -1088, 136, -72},
    { -1064, 80, -24},
    { -960, 112, -16},
    { -912, 216, -32},
    { -936, 40, -32},
    { -792, -96, 72},
    { -688, -288, -88},
    { -1200, -160, -168},
    { -1472, 48, -368},
    // 23 seconds
    { -1592, 40, -496},
    { -1920, -24, -224},
    { -1568, 72, -104},
    { -1152, 400, -216},
    { -984, 384, -184},
    { -1048, 328, -136},
    { -1064, 312, -96},
    { -968, 288, -48},
    { -848, 488, -24},
    { -832, 1272, -64},
    { -1088, 920, -200},
    { -1416, 816, -200},
    { -1432, 856, -376},
    { -1472, 552, -432},
    { -1720, 384, -240},
    { -1776, 496, -200},
    { -1640, 360, -16},
    { -1416, 216, 72},
    { -1248, 160, 72},
    { -1128, 152, 72},
    { -968, -24, 104},
    { -776, 0, 72},
    { -664, -104, 0},
    { -592, -520, 64},
    { -688, -80, -152},
    // 24 seconds
    { -1328, 96, 48},
    { -1784, 376, -168},
    { -1664, 552, -536},
    { -1808, 216, -32},
    { -1520, 368, -168},
    { -1264, 624, -280},
    { -1152, 344, -168},
    { -1120, 280, -16},
    { -1088, 280, 16},
    { -1072, 304, -56},
    { -920, 352, -40},
    { -1128, 432, 8},
    { -1072, 576, 24},
    { -1328, 792, 24},
    { -1456, 696, -56},
    { -1080, 520, -280},
    { -1256, 560, -248},
    { -1496, 424, -120},
    { -1544, 112, -104},
    { -1432, 128, -48},
    { -1408, 152, -32},
    { -1328, 56, 8},
    { -1288, 96, 8},
    { -1200, 104, 72},
    { -1160, 64, 88},
    // 25 seconds
    { -1056, -152, 184},
    { -1080, -232, 64},
    { -1168, -48, -184},
    { -1096, 32, -368},
    { -1304, 8, -272},
    { -1344, -296, 48},
    { -1344, -16, -272},
    { -1224, 232, -288},
    { -1176, 264, -248},
    { -1304, 376, -160},
    { -1328, 440, -56},
    { -1264, 672, -216},
    { -1264, 840, -256},
    { -1168, 328, -248},
    { -1440, 432, -376},
    { -1512, 376, -176},
    { -1064, 360, -288},
    { -1288, 264, -240},
    { -1360, 232, -152},
    { -1336, 264, -112},
    { -1192, 168, -56},
    { -1128, 112, -56},
    { -1208, 80, 8},
    { -1184, 112, 40},
    { -1216, 120, 0},
    // 26 seconds
    { -1208, 96, 40},
    { -1264, -208, 208},
    { -1064, -224, -48},
    { -1216, -184, -96},
    { -1272, 40, -472},
    { -1384, 8, -360},
    { -1344, -144, -80},
    { -1280, -112, -72},
    { -1256, 208, -168},
    { -1128, 280, -40},
    { -1136, 376, -40},
    { -1128, 400, -160},
    { -1040, 368, -184},
    { -1072, 360, -104},
    { -1320, 504, -144},
    { -1376, 832, -248},
    { -1528, 392, -184},
    { -1048, 440, -368},
    { -1192, 392, -336},
    { -1416, 296, -152},
    { -1472, 232, -72},
    { -1248, 96, -32},
    { -1208, 80, 32},
    { -1240, 40, 112},
    { -1248, 32, 56},
    // 27 seconds
    { -1120, 80, 104},
    { -1160, 80, 64},
    { -1208, -64, 160},
    { -1152, -216, 144},
    { -1376, 72, -200},
    { -1152, 96, -496},
    { -1224, -96, -432},
    { -1192, -352, -232},
    { -1112, -224, -232},
    { -1024, -8, -200},
    { -928, 176, -128},
    { -968, 208, -112},
    { -1144, 280, -104},
    { -1256, 392, -184},
    { -1392, 632, -232},
    { -1200, 584, -88},
    { -1432, 240, -192},
    { -1520, 432, 24},
    { -880, 528, -344},
    { -1232, 536, -264},
    { -1368, 392, -152},
    { -1248, 360, -216},
    { -1056, 312, -168},
    { -1048, 176, -48},
    { -1128, 80, 48},
    // 28 seconds
    { -1136, 72, 48},
    { -1144, -88, 72},
    { -1208, -336, 144},
    { -1120, -352, 144},
    { -1032, -384, 112},
    { -1800, 0, -232},
    { -1360, 136, -464},
    { -1472, -216, -128},
    { -1384, -400, 104},
    { -1304, -32, -16},
    { -1064, 264, 96},
    { -920, 520, -72},
    { -912, 376, -40},
    { -992, 344, -56},
    { -984, 456, -40},
    { -944, 664, -104},
    { -1056, 632, -128},
    { -1312, 648, -144},
    { -1536, 696, -24},
    { -1288, 464, -128},
    { -1528, 512, -184},
    { -1712, 416, -88},
    { -1568, 360, -56},
    { -1368, 264, 48},
    { -1360, 224, 104},
    // 29 seconds
    { -1288, 176, 136},
    { -1136, 168, 136},
    { -952, 160, 168},
    { -808, 184, 112},
    { -832, -72, 384},
    { -872, -456, -536},
    { -832, -112, -112},
    { -1376, 120, -8},
    { -1776, 504, -264},
    { -1816, 808, -256},
    { -1536, 360, -88},
    { -1320, 456, -248},
    { -1112, 480, -304},
    { -1024, 400, -192},
    { -1056, 368, -104},
    { -1096, 448, -104},
    { -1088, 504, -96},
    { -1064, 728, 8},
    { -1024, 704, 24},
    { -1112, 696, -64},
    { -1328, 656, 56},
    { -1064, 632, -80},
    { -1352, 568, -8},
    { -1512, 424, 80},
    { -1504, 360, 48},
    // 30 seconds
    { -1336, 344, 24},
    { -1296, 256, 56},
    { -1280, 128, 80},
    { -1216, 104, 72},
    { -1104, 80, 24},
    { -1128, 56, 0},
    { -1128, -16, -64},
    { -1096, -160, 128},
    { -1160, -48, -104},
    { -1096, 264, -328},
    { -1144, 192, -232},
    { -1376, 32, -192},
    { -1344, 104, -120},
    { -1208, 120, -136},
    { -1112, 240, -80},
    { -1104, 304, -80},
    { -1272, 384, -216},
    { -1248, 472, -224},
    { -1168, 568, -408},
    { -1248, 416, -328},
    { -1200, 376, -376},
    { -1712, 536, -216},
    { -1048, 376, -272},
    { -1240, 376, -296},
    { -1344, 368, -136},
    // 31 seconds
    { -1488, 304, -72},
    { -1320, 216, -56},
    { -1184, 144, 0},
    { -1184, 112, 56},
    { -1192, 64, 80},
    { -1144, 80, 72},
    { -1192, 104, 56},
    { -1264, -112, 176},
    { -1056, -248, 120},
    { -1120, -96, 72},
    { -1336, 176, -296},
    { -1344, 208, -408},
    { -1360, -176, -240},
    { -1288, -400, -136},
    { -1216, -104, -120},
    { -1120, 224, -24},
    { -1064, 352, 40},
    { -1184, 448, -48},
    { -1104, 440, -104},
    { -1032, 376, -88},
    { -1176, 480, -72},
    { -1024, 608, -144},
    { -1920, 496, 8},
    { -1160, 328, -176},
    { -1040, 464, -200},
    // 32 seconds
    { -1368, 280, -56},
    { -1296, 200, -40},
    { -1184, 176, -48},
    { -1136, 72, -40},
    { -1168, 72, 72},
    { -1240, 112, 88},
    { -1256, 104, 88},
    { -1224, 112, 88},
    { -1344, 96, 48},
    { -1128, -88, 32},
    { -1312, -216, 72},
    { -1168, 0, -384},
    { -1040, -56, -256},
    { -1208, -200, -144},
    { -1200, -200, -152},
    { -1008, -56, -72},
    { -912, 104, 56},
    { -984, 232, 128},
    { -1312, 432, -24},
    { -1336, 568, -152},
    { -1064, 448, -216},
    { -1168, 576, -160},
    { -1160, 392, -144},
    { -1752, 616, 112},
    { -1280, 496, -56},
    // 33 seconds
    { -952, 440, -320},
    { -1192, 464, -160},
    { -1312, 344, 0},
    { -1296, 328, 64},
    { -1104, 104, 80},
    { -1072, 40, 88},
    { -1072, 32, 96},
    { -1000, 104, 104},
    { -968, 120, 88},
    { -1128, -8, 96},
    { -1008, -144, -8},
    { -1128, -120, -88},
    { -1312, 72, -184},
    { -1264, 200, -400},
    { -1416, 72, -344},
    { -1320, -64, -144},
    { -1216, 104, -160},
    { -976, 248, -8},
    { -880, 320, 0},
    { -984, 328, -80},
    { -1072, 368, -96},
    { -952, 448, -104},
    { -1016, 552, -176},
    { -1024, 552, -120},
    { -1456, 600, -192},
    // 34 seconds
    { -1520, 536, -112},
    { -936, 520, -304},
    { -1264, 424, -192},
    { -1480, 272, 0},
    { -1376, 344, -48},
    { -1168, 328, -40},
    { -1184, 296, 40},
    { -1192, 256, 72},
    { -1088, 200, 112},
    { -896, 192, 88},
    { -784, 176, 192},
    { -872, 448, 112},
    { -656, -112, -360},
    { -880, 560, 40},
    { -912, 960, 216},
    { -728, 1664, 8},
    { -744, 1352, 72},
    { -480, 1088, 40},
    { -296, 800, -8},
    { -128, 560, 8},
    { -24, 424, 64},
    { 32, 368, 88},
    { -40, 544, 96},
    { 0, 648, 128},
    { -152, 680, 280},
    // 35 seconds
    { 16, 872, 104},
    { -152, 992, 160},
    { -288, 1392, 192},
    { -544, 1784, 160},
    { -456, 1328, 48},
    { -272, 1064, -72},
    { -232, 992, -160},
    { -296, 848, -200},
    { -312, 648, -208},
    { -256, 368, -192},
    { -208, 208, -160},
    { -216, 152, -136},
    { -304, 160, -88},
    { -600, 144, 80},
    { -1128, 184, 160},
    { -1816, 112, 96},
    { -2688, 384, -224},
    { -1848, 240, -32},
    { -1056, -16, -344},
    { -1136, -56, -320},
    { -1216, 160, -184},
    { -904, 136, -120},
    { -696, 32, 0},
    { -672, 120, 0},
    { -720, 224, -80},
    // 36 seconds
    { -656, 328, -192},
    { -776, 360, -200},
    { -1200, 400, -240},
    { -1720, 328, -48},
    { -1624, 1168, 88},
    { -1176, -152, -456},
    { -1440, 352, -160},
    { -1584, 352, -56},
    { -1256, 136, -96},
    { -1064, 96, -48},
    { -1008, 64, 24},
    { -984, 16, 24},
    { -936, 0, 24},
    { -960, 0, 56},
    { -1152, 8, 120},
    { -1112, -144, 312},
    { -1224, -96, 256},
    { -1336, 240, -256},
    { -1168, 248, -592},
    { -1296, 40, -336},
    { -1112, -592, -152},
    { -1120, -312, -200},
    { -1064, 112, -216},
    { -1000, 280, -120},
    { -1032, 296, -64},
    // 37 seconds
    { -1128, 320, -96},
    { -1016, 304, -152},
    { -1064, 352, -192},
    { -1144, 520, -128},
    { -1552, 200, -152},
    { -1608, 280, -136},
    { -1088, 264, -336},
    { -1248, 384, -240},
    { -1408, 312, -128},
    { -1256, 168, -160},
    { -1096, 72, -88},
    { -1080, -88, 96},
    { -1096, -64, -8},
    { -1072, 0, 0},
    { -1032, 40, 24},
    { -1104, 0, 128},
    { -1112, -200, 176},
    { -1112, -144, 16},
    { -1344, 16, -120},
    { -1288, 112, -456},
    { -1432, 8, -280},
    { -1208, -360, -120},
    { -1120, -288, -136},
    { -1032, 56, -48},
    { -952, 256, 8},
    // 38 seconds
    { -1008, 320, -48},
    { -1152, 360, -144},
    { -1048, 272, -184},
    { -1104, 376, -192},
    { -1080, 536, -136},
    { -1560, 552, -200},
    { -1848, 408, -24},
    { -1056, 320, -272},
    { -1296, 344, -200},
    { -1344, 232, -104},
    { -1152, 184, -128},
    { -1120, 136, -48},
    { -1192, 64, 64},
    { -1216, 0, 56},
    { -1112, -8, 48},
    { -928, 24, 16},
    { -816, 32, 40},
    { -920, 40, 88},
    { -864, 56, -16},
    { -1216, 104, -48},
    { -1416, 160, -424},
    { -1064, 120, -568},
    { -1184, -344, -352},
    { -1272, -472, -200},
    { -1112, -152, -200},
    // 39 seconds
    { -1000, 304, -136},
    { -928, 296, -80},
    { -976, 320, -112},
    { -1016, 272, -152},
    { -872, 288, -224},
    { -976, 272, -296},
    { -1080, 520, -336},
    { -1576, 400, -304},
    { -1528, 256, -224},
    { -976, 272, -400},
    { -1240, 576, -368},
    { -1568, 592, -176},
    { -1392, 592, -192},
    { -1288, 592, -96},
    { -1240, 488, 16},
    { -1016, 464, 72},
    { -752, 224, 96},
    { -536, 120, 104},
    { -448, 128, 128},
    { -608, 360, 128},
    { -392, 72, -40},
    { -752, 744, -16},
    { -744, 1248, 96},
    { -496, 2016, -48},
    { -240, 1336, -160},
    // 40 seconds
    { -248, 952, -104},
    { -168, 632, -72},
    { -96, 456, -96},
    { -56, 288, -80},
    { -64, 184, -8},
    { -120, 184, 32},
    { -216, 192, -24},
    { -360, 200, 0},
    { -840, 576, 80},
    { -1624, 1232, 24},
    { -1776, 1128, -48},
    { -1688, 1128, 96},
    { -1080, 896, -536},
    { -1136, 784, -304},
    { -1088, 504, 32},
    { -880, 392, -88},
    { -712, 352, -72},
    { -608, 264, -64},
    { -752, 208, -160},
    { -864, 56, -40},
    { -1112, -208, 304},
    { -1024, -312, 176},
    { -1216, 112, 16},
    { -1128, 176, -272},
    { -1744, 192, -120},
    // 41 seconds
    { -1320, 360, -280},
    { -840, 88, -288},
    { -992, -88, -152},
    { -1088, 8, -176},
    { -840, 136, -128},
    { -640, 208, -72},
    { -632, 192, -80},
    { -720, 200, -144},
    { -800, 208, -128},
    { -880, 288, -296},
    { -1184, 328, -400},
    { -1440, 376, -336},
    { -1888, 408, -248},
    { -1096, 424, -248},
    { -1168, 256, -360},
    { -1296, 312, -128},
    { -1184, 208, -32},
    { -952, 192, -56},
    { -864, 112, -32},
    { -864, 16, 32},
    { -936, 248, 88},
    { -968, 64, 112},
    { -920, 88, 88},
    { -1008, 88, 120},
    { -1112, 56, 80},
    // 42 seconds
    { -1568, 144, 88},
    { -1240, 328, -360},
    { -1040, 312, -488},
    { -1232, -56, -384},
    { -1176, -224, -176},
    { -984, -112, -152},
    { -832, 88, -104},
    { -840, 176, -8},
    { -1000, 328, 16},
    { -960, 440, -200},
    { -968, 576, -168},
    { -1232, 472, -48},
    { -1344, 1096, -80},
    { -1936, 288, -152},
    { -1024, 232, -296},
    { -1160, 440, -264},
    { -1384, 264, -112},
    { -1416, 128, -72},
    { -1072, 80, -64},
    { -936, 136, -16},
    { -920, 72, 64},
    { -952, 80, 64},
    { -968, 88, 88},
    { -1024, 96, 96},
    { -1112, 24, 136},
    // 43 seconds
    { -944, -24, 48},
    { -1288, 64, 152},
    { -1272, 304, -264},
    { -1152, 368, -304},
    { -1344, 136, -208},
    { -1304, 48, -216},
    { -1016, 88, -264},
    { -776, 200, -160},
    { -808, 248, -136},
    { -928, 248, -112},
    { -928, 296, -144},
    { -984, 288, -136},
    { -1264, 376, -120},
    { -1488, 704, -64},
    { -1688, 384, -104},
    { -1128, 368, -240},
    { -1048, 312, -216},
    { -1184, 288, -120},
    { -1256, 176, -72},
    { -1040, 200, -120},
    { -864, 168, -88},
    { -920, 112, -120},
    { -960, 136, 0},
    { -984, 112, 0},
    { -1088, 136, 16},
    // 44 seconds
    { -1288, -8, 152},
    { -1048, 8, 16},
    { -1288, 64, 0},
    { -1152, 184, -144},
    { -1064, 232, -296},
    { -1368, 160, -216},
    { -1256, 56, -96},
    { -1000, 80, -144},
    { -744, 200, -72},
    { -736, 240, -104},
    { -848, 240, -112},
    { -1016, 264, -168},
    { -984, 376, -96},
    { -1144, 416, -136},
    { -1328, 656, -104},
    { -1704, 800, -8},
    { -1128, 656, -368},
    { -1064, 472, -352},
    { -1368, 424, -184},
    { -1488, 384, -144},
    { -1224, 264, -120},
    { -1048, 160, -32},
    { -888, 296, 16},
    { -904, 288, 104},
    { -816, 200, 104},
    // 45 seconds
    { -776, 232, 136},
    { -760, 152, 232},
    { -984, 376, -160},
    { -768, -72, 192},
    { -1200, 184, 104},
    { -1384, 568, -136},
    { -1288, 584, -296},
    { -1488, 456, 64},
    { -1376, 408, -24},
    { -1152, 576, -160},
    { -928, 408, -80},
    { -888, 368, -24},
    { -952, 360, 40},
    { -904, 384, 24},
    { -800, 392, 16},
    { -1112, 488, 144},
    { -1128, 536, 312},
    { -1272, 736, 192},
    { -1296, 704, 144},
    { -1016, 608, -32},
    { -1208, 544, 32},
    { -1384, 376, 144},
    { -1352, 232, 128},
    { -1152, 112, 128},
    { -1024, 176, 48},
    // 46 seconds
    { -952, 200, 0},
    { -1112, 168, 136},
    { -1120, 176, 128},
    { -1120, 136, 152},
    { -1200, 8, 168},
    { -992, 120, -88},
    { -1256, 152, -96},
    { -1112, 32, -288},
    { -1056, 8, -312},
    { -1408, 96, -144},
    { -1296, 168, -56},
    { -1056, 216, -48},
    { -864, 304, 32},
    { -960, 336, 16},
    { -1080, 304, 56},
    { -1120, 264, -8},
    { -1056, 304, -16},
    { -1360, 512, 88},
    { -1192, 696, 64},
    { -1616, 552, -72},
    { -1120, 488, -152},
    { -1040, 464, -232},
    { -1240, 456, -72},
    { -1416, 256, 48},
    { -1248, 200, 8},
    // 47 seconds
    { -1064, 160, -8},
    { -1096, 112, -24},
    { -1152, 40, -8},
    { -1136, 16, -24},
    { -1128, 32, 0},
    { -1288, 80, -24},
    { -1216, -200, -104},
    { -1096, -208, -104},
    { -1080, 216, -384},
    { -968, 96, -248},
    { -1376, 64, -160},
    { -1168, -216, -72},
    { -1088, -96, -120},
    { -1080, 160, -120},
    { -1120, 296, -64},
    { -1152, 344, -176},
    { -1192, 288, -240},
    { -1088, 504, -448},
    { -1232, 496, -472},
    { -1184, 48, -424},
    { -1784, 312, -312},
    { -1336, 272, -296},
    { -1272, 256, -312},
    { -1528, 352, -80},
    { -1496, 184, 32},
    // 48 seconds
    { -1144, 48, 8},
    { -976, 48, -40},
    { -1040, 344, -48},
    { -1160, 160, 96},
    { -1176, 64, 104},
    { -1192, -136, 296},
    { -1128, -208, 248},
    { -896, -144, -48},
    { -1256, -216, 88},
    { -1336, -64, -336},
    { -1144, -32, -368},
    { -1296, -80, -224},
    { -1408, -152, -128},
    { -1304, -48, -40},
    { -1112, 184, -8},
    { -1056, 368, 0},
    { -1176, 408, -88},
    { -1088, 400, -224},
    { -920, 336, -384},
    { -1184, 704, -408},
    { -1208, 528, -336},
    { -1712, 296, -232},
    { -1128, 304, -336},
    { -1456, 400, -192},
    { -1600, 328, -8},
    // 49 seconds
    { -1504, 272, -24},
    { -1256, 216, -48},
    { -1168, 112, 16},
    { -1168, 40, 80},
    { -1144, 24, 64},
    { -1128, 32, 48},
    { -1176, -64, 96},
    { -1120, -120, 56},
    { -1040, -136, 80},
    { -1200, -232, -112},
    { -1128, -64, -416},
    { -1232, -328, -208},
    { -1440, -280, -200},
    { -1432, -88, -152},
    { -1368, 152, -144},
    { -1256, 272, -40},
    { -1232, 376, 56},
    { -1264, 568, -56},
    { -1152, 480, -16},
    { -1160, 536, -128},
    { -1152, 584, -48},
    { -1112, 800, -184},
    { -1648, 848, -40},
    { -1160, 512, -176},
    { -1328, 464, -192},
    // 50 seconds
    { -1704, 440, -24},
    { -1784, 88, 8},
    { -1504, 272, 56},
    { -1320, 0, 104},
    { -1256, 152, 112},
    { -1264, 200, 160},
    { -1208, 56, 64},
    { -1128, -80, 72},
    { -928, -240, -232},
    { -640, -512, -40},
    { -1272, -144, 0},
    { -1440, 152, -296},
    { -1352, 360, -416},
    { -1320, 104, -224},
    { -1376, 200, -232},
    { -1232, 248, -168},
    { -1120, 184, -144},
    { -1248, 232, 16},
    { -1336, 320, -8},
    { -1376, 368, -40},
    { -1272, 488, -176},
    { -1320, 616, -120},
    { -1232, 528, -232},
    { -1640, 616, -112},
    { -872, 360, -232},
    // 51 seconds
    { -1168, 424, -232},
    { -1360, 368, -88},
    { -1320, 256, -80},
    { -1176, 208, -80},
    { -1136, 96, -32},
    { -1192, 40, 0},
    { -1272, 40, 0},
    { -1344, 40, 32},
    { -1384, -16, 80},
    { -1216, -160, 88},
    { -1176, -208, -48},
    { -1440, -96, -160},
    { -1224, 88, -440},
    { -1352, -80, -312},
    { -1176, -416, -80},
    { -1000, -368, -80},
    { -824, -24, -120},
    { -848, 232, -56},
    { -976, 304, -112},
    { -1224, 304, -96},
    { -1232, 352, -160},
    { -1424, 376, -264},
    { -1296, 1128, -168},
    { -1504, -56, -448},
    { -1528, 320, -368},
    // 52 seconds
    { -944, 384, -520},
    { -1216, 344, -424},
    { -1424, 256, -208},
    { -1320, 136, -152},
    { -1144, 56, -80},
    { -1160, 32, 0},
    { -1200, 16, 0},
    { -1232, 72, 16},
    { -1248, 40, 0},
    { -1416, -200, 136},
    { -1152, -360, 112},
    { -1072, -256, 8},
    { -1256, -64, -152},
    { -1136, -16, -200},
    { -1312, -40, -88},
    { -1248, -152, -48},
    { -1144, -72, -48},
    { -1088, 104, -56},
    { -1128, 208, 0},
    { -1200, 264, 96},
    { -1192, 288, -24},
    { -1176, 392, -216},
    { -1392, 488, -176},
    { -1312, 424, -232},
    { -1624, 296, -336},
    // 53 seconds
    { -1032, 360, -368},
    { -1000, 424, -376},
    { -1376, 336, -176},
    { -1528, 184, -72},
    { -1248, 104, -56},
    { -1184, 96, -16},
    { -1240, 64, 16},
    { -1272, 64, 32},
    { -1248, 64, 48},
    { -1304, 40, 80},
    { -1368, -136, 208},
    { -1104, -264, 232},
    { -1200, -24, -8},
    { -1016, 48, -344},
    { -1160, 24, -176},
    { -1256, -16, -152},
    { -1056, -224, -216},
    { -920, -96, -264},
    { -952, 96, -144},
    { -1120, 216, 0},
    { -1352, 280, 0},
    { -1256, 280, 16},
    { -1248, 360, -216},
    { -1408, 608, -184},
    { -1088, 528, -336},
    // 54 seconds
    { -1560, 544, -320},
    { -936, 408, -256},
    { -1144, 456, -208},
    { -1400, 320, -72},
    { -1448, 232, -40},
    { -1208, 168, -40},
    { -1144, 144, 0},
    { -1160, 112, 8},
    { -1136, 88, 40},
    { -1128, 88, 48},
    { -1208, 56, 48},
    { -1408, -56, 192},
    { -1096, -152, 136},
    { -1392, -40, 0},
    { -1032, 64, -336},
    { -1024, -48, -272},
    { -1144, -176, -208},
    { -1128, -184, -184},
    { -1056, 0, -208},
    { -1056, 208, -120},
    { -1160, 256, -40},
    { -1288, 288, -32},
    { -1296, 512, -96},
    { -1064, 592, -288},
    { -1088, 368, -360},
    // 55 seconds
    { -992, 280, -320},
    { -1128, 392, -488},
    { -1536, 440, -288},
    { -1344, 304, -288},
    { -1640, 448, -216},
    { -1912, 288, -96},
    { -1544, 344, -224},
    { -1304, 216, -152},
    { -1160, 64, 8},
    { -984, 80, -32},
    { -808, 88, 24},
    { -632, -56, 144},
    { -584, -160, 96},
    { -848, -312, -32},
    { -1144, -232, 280},
    { -1712, 264, 80},
    { -1760, 568, -344},
    { -1896, 472, -296},
    { -1376, 520, -592},
    { -1200, 816, -384},
    { -744, 760, -80},
    { -656, 856, -120},
    { -696, 744, 176},
    { -576, 840, 192},
    { -432, 824, 200},
    // 56 seconds
    { -376, 744, 248},
    { -512, 752, 304},
    { -816, 864, 448},
    { -1112, 1168, 512},
    { -864, 960, 376},
    { -952, 1040, 272},
    { -904, 848, 256},
    { -832, 776, 160},
    { -728, 616, 56},
    { -624, 424, 8},
    { -520, 304, -56},
    { -480, 256, 0},
    { -536, 424, -24},
    { -664, 480, 96},
    { -672, 528, 96},
    { -680, 672, 120},
    { -752, 816, 152},
    { -552, 1064, 8},
    { -792, 1104, -8},
    { -880, 944, 120},
    { -776, 776, 160},
    { -776, 768, 144},
    { -640, 656, 160},
    { -632, 592, 192},
    { -680, 632, 168},
    // 57 seconds
    { -816, 768, 264},
    { -816, 800, 336},
    { -744, 760, 224},
    { -648, 848, 176},
    { -568, 784, 128},
    { -448, 792, 96},
    { -480, 1000, -24},
    { -424, 952, -112},
    { -352, 1168, -216},
    { -288, 864, -256},
    { -288, 616, -408},
    { -336, 8, -816},
    { -392, 160, -936},
    { -272, -40, -856},
    { -192, -120, -776},
    { -176, -104, -752},
    { -16, -216, -1136},
    { -328, -96, -1040},
    { -112, -152, -1024},
    { -40, -200, -1040},
    { -88, -256, -928},
    { -40, -304, -920},
    { 32, -280, -928},
    { -8, -320, -912},
    { -48, -280, -952},
    // 58 seconds
    { -32, -328, -920},
    { -24, -288, -976},
    { -16, -352, -960},
    { -16, -344, -952},
    { -24, -368, -968},
    { -40, -368, -960},
    { -48, -376, -952},
    { -56, -368, -920},
    { -72, -400, -864},
    { -40, -344, -896},
    { 16, -336, -936},
    { -8, -304, -976},
    { -32, -368, -976},
    { -48, -368, -968},
    { -40, -360, -952},
    { -16, -376, -920},
    { 0, -352, -968},
    { -8, -376, -960},
    { -8, -360, -976},
    { -32, -376, -984},
    { -32, -392, -952},
    { -40, -392, -944},
    { -32, -384, -920},
    { -16, -392, -944},
    { -32, -376, -952},
    // 59 seconds
    { -32, -368, -944},
    { -32, -368, -952},
    { -40, -368, -944},
    { -32, -360, -960},
    { -24, -376, -936},
    { -32, -368, -952},
    { -32, -384, -944},
    { -40, -376, -960},
    { -56, -384, -968},
    { -56, -384, -968},
    { -48, -384, -960},
    { -56, -384, -944},
    { -48, -384, -944},
    { -48, -376, -944},
    { -48, -376, -952},
    { -56, -384, -960},
    { -56, -368, -952},
    { -56, -368, -952},
    { -64, -368, -960},
    { -64, -368, -960},
    { -72, -352, -960},
    { -64, -352, -960},
    { -48, -360, -952},
    { -48, -368, -960},
    { -56, -352, -960},
    // 60 seconds
    // elapsed: 1 minutes
    { -48, -360, -952},
    { -40, -336, -960},
    { -32, -336, -944},
    { -32, -336, -960},
    { -40, -304, -976},
    { -48, -312, -976},
    { -48, -320, -976},
    { -48, -304, -976},
    { -40, -304, -984},
    { -56, -304, -976},
    { -40, -304, -976},
    { -48, -304, -976},
    { -48, -304, -976},
    { -48, -288, -984},
    { -48, -288, -992},
    { -48, -288, -976},
    { -40, -264, -976},
    { -48, -280, -976},
    { -40, -280, -976},
    { -40, -280, -984},
    { -48, -288, -976},
    { -48, -296, -976},
    { -56, -296, -984},
    { -48, -288, -976},
    { -56, -280, -992},
    // 61 seconds
    { -56, -280, -984},
    { -48, -280, -976},
    { -64, -288, -960},
    { -56, -280, -968},
    { -64, -280, -960},
    { -56, -272, -960},
    { -56, -280, -968},
    { -64, -264, -984},
    { -64, -280, -984},
    { -56, -280, -984},
    { -64, -288, -976},
    { -64, -296, -976},
    { -72, -288, -968},
    { -72, -280, -968},
    { -80, -264, -952},
    { -88, -248, -952},
    { -88, -232, -952},
    { -96, -208, -936},
    { -88, -200, -944},
    { -80, -192, -952},
    { -88, -192, -968},
    { -128, -200, -952},
    { -112, -232, -936},
    { -136, -168, -952},
    { -136, 0, -968},
    // 62 seconds
    { -72, 248, -880},
    { -32, 552, -776},
    { 56, 888, -480},
    { 128, 880, -408},
    { 152, 1168, -32},
    { 232, 1080, 80},
    { 168, 1008, 120},
    { 144, 872, 144},
    { 88, 928, 176},
    { 72, 800, 152},
    { 40, 856, 112},
    { 40, 904, 136},
    { 32, 848, 136},
    { 64, 864, 144},
    { 64, 848, 96},
    { 64, 872, 208},
    { 112, 864, 128},
    { 80, 912, 184},
    { 112, 872, 176},
    { 112, 848, 208},
    { 88, 1016, 208},
    { 104, 920, 120},
    { 112, 840, 160},
    { 88, 824, 72},
    { 120, 936, 256},
    // 63 seconds
    { 152, 952, 224},
    { 128, 824, 144},
    { 128, 880, 192},
    { 96, 864, 144},
    { 112, 904, 216},
    { 144, 968, 256},
    { 144, 832, 240},
    { 200, 984, 224},
    { 136, 904, 192},
    { 160, 880, 240},
    { 160, 888, 232},
    { 176, 864, 200},
    { 168, 760, 72},
    { 192, 888, 152},
    { 184, 896, 128},
    { 216, 864, 88},
    { 208, 832, 72},
    { 224, 848, 88},
    { 240, 840, 88},
    { 248, 840, 120},
    { 256, 880, 96},
    { 256, 872, 120},
    { 272, 872, 96},
    { 288, 864, 88},
    { 296, 808, 56},
    // 64 seconds
    { 296, 880, 24},
    { 296, 784, 40},
    { 296, 824, -32},
    { 304, 840, -24},
    { 320, 832, -48},
    { 312, 808, -48},
    { 320, 792, -56},
    { 320, 792, -64},
    { 352, 776, -72},
    { 352, 824, -64},
    { 352, 808, -48},
    { 344, 824, -56},
    { 368, 808, -48},
    { 344, 784, -104},
    { 352, 792, -16},
    { 360, 768, -24},
    { 352, 808, -40},
    { 368, 880, -80},
    { 368, 800, -96},
    { 360, 832, -32},
    { 360, 840, -72},
    { 368, 784, -16},
    { 352, 808, -48},
    { 352, 776, -56},
    { 368, 904, -56},
    // 65 seconds
    { 344, 800, -80},
    { 376, 840, -48},
    { 368, 832, -40},
    { 352, 776, -56},
    { 376, 800, -56},
    { 360, 840, -56},
    { 352, 776, -72},
    { 376, 816, -40},
    { 376, 792, -32},
    { 376, 808, -40},
    { 376, 848, -72},
    { 360, 824, -48},
    { 376, 816, -64},
    { 376, 816, -24},
    { 368, 784, -80},
    { 368, 792, -32},
    { 360, 872, -48},
    { 360, 792, -72},
    { 368, 816, -56},
    { 352, 848, -64},
    { 368, 784, -48},
    { 352, 784, -56},
    { 368, 808, -72},
    { 352, 816, -64},
    { 344, 832, -64},
    // 66 seconds
    { 392, 792, -48},
    { 392, 784, -48},
    { 376, 800, -48},
    { 368, 816, -40},
    { 352, 800, -88},
    { 376, 824, -72},
    { 376, 816, -72},
    { 360, 784, -56},
    { 376, 832, -64},
    { 368, 824, -72},
    { 376, 784, -48},
    { 352, 800, -48},
    { 352, 808, -40},
    { 376, 800, -40},
    { 376, 792, -64},
    { 360, 784, -96},
    { 336, 792, -88},
    { 368, 864, -32},
    { 344, 768, -80},
    { 336, 800, -24},
    { 336, 808, -136},
    { 336, 840, 80},
    { 352, 856, 56},
    { 344, 816, 88},
    { 360, 848, 128},
    // 67 seconds
    { 344, 816, 152},
    { 344, 816, 232},
    { 336, 760, 264},
    { 304, 720, 216},
    { 248, 784, 344},
    { 264, 912, 336},
    { 264, 736, 400},
    { 240, 768, 328},
    { 232, 784, 496},
    { 216, 848, 392},
    { 280, 856, 504},
    { 272, 736, 480},
    { 264, 816, 496},
    { 256, 816, 464},
    { 248, 800, 488},
    { 248, 792, 464},
    { 232, 760, 432},
    { 240, 760, 344},
    { 272, 752, 296},
    { 280, 824, 272},
    { 264, 792, 248},
    { 280, 832, 240},
    { 288, 816, 240},
    { 304, 776, 240},
    { 312, 840, 200},
    // 68 seconds
    { 336, 768, 264},
    { 296, 800, 256},
    { 288, 840, 240},
    { 296, 792, 232},
    { 288, 816, 216},
    { 312, 824, 200},
    { 312, 792, 208},
    { 328, 816, 208},
    { 336, 808, 224},
    { 320, 808, 208},
    { 328, 816, 208},
    { 328, 824, 216},
    { 320, 824, 208},
    { 320, 832, 200},
    { 320, 824, 184},
    { 320, 808, 160},
    { 328, 824, 168},
    { 320, 824, 152},
    { 304, 824, 136},
    { 296, 824, 144},
    { 296, 848, 136},
    { 296, 816, 128},
    { 304, 848, 112},
    { 312, 856, 112},
    { 304, 856, 112},
    // 69 seconds
    { 296, 848, 104},
    { 312, 856, 104},
    { 304, 832, 104},
    { 304, 840, 112},
    { 320, 832, 112},
    { 320, 824, 112},
    { 320, 816, 96},
    { 328, 808, 104},
    { 320, 808, 112},
    { 320, 816, 104},
    { 328, 832, 112},
    { 328, 832, 112},
    { 328, 832, 104},
    { 312, 824, 72},
    { 288, 808, 72},
    { 280, 824, 120},
    { 280, 840, 112},
    { 280, 864, 88},
    { 272, 864, 80},
    { 280, 880, 80},
    { 264, 864, 64},
    { 264, 856, 80},
    { 272, 856, 96},
    { 264, 856, 112},
    { 280, 856, 160},
    // 70 seconds
    { 296, 864, 184},
    { 296, 840, 192},
    { 296, 824, 216},
    { 312, 800, 200},
    { 288, 800, 216},
    { 288, 824, 224},
    { 280, 800, 208},
    { 272, 824, 176},
    { 272, 832, 176},
    { 288, 872, 144},
    { 280, 928, 112},
    { 320, 872, 96},
    { 336, 936, 112},
    { 392, 920, 16},
    { 360, 920, -88},
    { 360, 816, -272},
    { 296, 816, -424},
    { 272, 584, -608},
    { 256, 440, -776},
    { 168, 192, -840},
    { 128, 80, -904},
    { 64, -32, -904},
    { 40, -112, -896},
    { -40, -208, -912},
    { -32, -256, -944},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-16 17:16:25 local
AccelRawData *activity_sample_walk_100_pbl_28394_5(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_28394_5
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 48, 960, -48},
    { 40, 984, -64},
    { -48, 840, -320},
    { -56, 888, -448},
    { -48, 800, -528},
    { -40, 736, -728},
    { 0, 560, -800},
    { -8, 400, -896},
    { -32, 56, -896},
    { -96, -24, -952},
    { -112, -136, -880},
    { -136, -256, -912},
    { -200, -72, -960},
    { -160, -248, -968},
    { -152, -192, -984},
    { -176, -216, -920},
    { -64, -224, -976},
    { -168, -280, -920},
    { -144, -280, -840},
    { -176, -280, -1032},
    { -48, -336, -984},
    { -144, -304, -928},
    { -176, -448, -920},
    { -184, -272, -992},
    { -264, -288, -1064},
    // 1 seconds
    { -240, -256, -1064},
    { -120, -256, -1072},
    { -56, -296, -976},
    { -72, -240, -952},
    { -112, -288, -936},
    { -48, -280, -944},
    { -80, -280, -944},
    { -40, -280, -968},
    { -72, -288, -968},
    { -40, -288, -984},
    { -64, -296, -976},
    { -40, -304, -976},
    { -24, -272, -976},
    { 0, -320, -944},
    { 8, -296, -936},
    { 16, -280, -960},
    { 24, -296, -944},
    { -8, -312, -952},
    { -24, -304, -984},
    { 0, -328, -960},
    { 0, -296, -976},
    { 24, -352, -1016},
    { -56, -272, -1056},
    { 40, -320, -1000},
    { 88, -288, -944},
    // 2 seconds
    { 80, -304, -1016},
    { 24, -312, -952},
    { 40, -312, -960},
    { 48, -312, -968},
    { 64, -320, -928},
    { 48, -296, -952},
    { 40, -296, -960},
    { 40, -304, -936},
    { 64, -312, -928},
    { 56, -312, -920},
    { 96, -296, -952},
    { 104, -208, -944},
    { 104, -192, -920},
    { 112, -208, -936},
    { 64, -152, -952},
    { 16, -48, -920},
    { 8, -8, -928},
    { 16, 72, -920},
    { -8, 160, -920},
    { -16, 416, -824},
    { -24, 576, -784},
    { -32, 856, -632},
    { 48, 800, -600},
    { 128, 824, -480},
    { 176, 800, -360},
    // 3 seconds
    { 184, 784, -288},
    { 240, 816, -192},
    { 224, 816, -160},
    { 232, 792, -184},
    { 232, 800, -112},
    { 216, 848, -136},
    { 224, 840, -128},
    { 232, 888, -64},
    { 224, 944, -96},
    { 232, 1072, -16},
    { 200, 1224, 88},
    { 88, 1112, -48},
    { 232, 1000, -16},
    { 160, 928, 24},
    { 112, 856, 88},
    { 88, 792, 24},
    { 104, 696, 0},
    { 96, 656, -88},
    { 56, 608, -88},
    { 88, 592, -96},
    { 80, 720, -128},
    { 64, 864, -152},
    { 32, 1000, -152},
    { 32, 1192, -192},
    { -32, 1248, -136},
    // 4 seconds
    { -184, 1400, -120},
    { -376, 1496, -240},
    { -304, 896, -304},
    { -352, 648, -264},
    { -344, 552, -160},
    { -200, 408, -128},
    { -136, 344, -96},
    { -128, 312, -128},
    { -96, 376, -72},
    { -168, 736, 16},
    { -144, 1224, 48},
    { -80, 1224, -112},
    { -392, 1256, -448},
    { -432, 1632, -616},
    { -560, 1696, -448},
    { -368, 1072, -296},
    { -320, 984, -416},
    { -360, 888, -400},
    { -376, 592, -296},
    { -288, 392, -296},
    { -248, 224, -264},
    { -224, 168, -232},
    { -256, 152, -200},
    { -360, 168, -304},
    { -744, -16, -56},
    // 5 seconds
    { -1320, 40, 40},
    { -2160, -104, 248},
    { -2424, 264, -328},
    { -1896, -8, -432},
    { -1568, -176, -96},
    { -1432, -72, -56},
    { -1080, 160, -32},
    { -928, 264, 64},
    { -728, 224, 0},
    { -760, 272, -16},
    { -776, 240, -56},
    { -808, 272, -232},
    { -1184, 280, -256},
    { -1232, 280, -256},
    { -1744, 440, -432},
    { -1432, 232, -424},
    { -1344, 304, -352},
    { -1512, 392, -208},
    { -1616, 224, -104},
    { -1400, -8, -56},
    { -1152, -32, -72},
    { -1064, 0, -8},
    { -1032, 24, 72},
    { -1072, 80, 96},
    { -1080, 64, 104},
    // 6 seconds
    { -1200, 88, 80},
    { -1048, -208, 80},
    { -1208, -152, 32},
    { -1032, -144, -336},
    { -992, -336, -272},
    { -1440, -272, -328},
    { -1448, -232, -280},
    { -1216, -112, -176},
    { -1048, 48, -128},
    { -1080, 208, 80},
    { -1216, 344, 56},
    { -1208, 432, -104},
    { -1168, 376, -152},
    { -1440, 520, -288},
    { -1024, 536, -336},
    { -1928, 280, -256},
    { -920, 280, -400},
    { -1328, 520, -304},
    { -1504, 336, -152},
    { -1432, 248, -104},
    { -1208, 152, -32},
    { -1048, 176, -16},
    { -1048, 96, 0},
    { -1104, 96, 24},
    { -1272, 88, 72},
    // 7 seconds
    { -1416, 72, 104},
    { -1352, -72, 104},
    { -816, -304, -8},
    { -1328, 360, -176},
    { -1168, -192, -568},
    { -1216, -264, -408},
    { -1392, -264, -288},
    { -1200, -160, -248},
    { -984, -16, -104},
    { -880, 128, 8},
    { -968, 224, 128},
    { -1168, 424, 48},
    { -1160, 520, -120},
    { -1184, 624, -152},
    { -1120, 1112, -88},
    { -1200, 368, -440},
    { -1520, 672, -208},
    { -952, 536, -280},
    { -1328, 488, -192},
    { -1576, 360, 40},
    { -1336, 288, -24},
    { -1024, 192, -112},
    { -1000, 192, -56},
    { -1128, 184, 24},
    { -1176, 160, 8},
    // 8 seconds
    { -1120, 120, 8},
    { -1336, -32, 80},
    { -1216, -600, 8},
    { -1112, -536, 632},
    { -1528, -232, -232},
    { -1784, 304, -864},
    { -1760, 264, -264},
    { -1248, -208, -32},
    { -1104, -120, -8},
    { -928, 320, -48},
    { -824, 304, -120},
    { -864, 152, -88},
    { -992, 144, -40},
    { -976, 208, -8},
    { -1240, 576, 8},
    { -1088, 1272, 16},
    { -1112, 400, -440},
    { -1496, 616, -232},
    { -1456, 624, -184},
    { -1568, 368, -176},
    { -1728, 248, -168},
    { -1456, 368, -112},
    { -1424, 352, 0},
    { -1456, 168, -256},
    { -1096, 256, 64},
    // 9 seconds
    { -992, 264, 80},
    { -880, 32, 96},
    { -600, -384, -48},
    { -736, 0, 24},
    { -848, 8, -104},
    { -1224, -128, 264},
    { -1328, 368, -304},
    { -1360, 376, -408},
    { -1656, 232, -120},
    { -1688, 328, -8},
    { -1432, 424, -168},
    { -1216, 512, -96},
    { -1160, 456, -96},
    { -1208, 408, -88},
    { -1168, 424, -112},
    { -1000, 440, -104},
    { -1096, 608, -104},
    { -1008, 608, -16},
    { -1536, 744, -24},
    { -1160, 592, -104},
    { -1136, 504, -160},
    { -1408, 480, -72},
    { -1648, 336, 24},
    { -1456, 296, 0},
    { -1368, 192, 32},
    // 10 seconds
    { -1376, 280, 72},
    { -1368, 96, 64},
    { -1280, 120, 96},
    { -1216, 176, 64},
    { -1304, 296, -32},
    { -1040, 296, -128},
    { -1104, 456, -120},
    { -800, 688, -376},
    { -432, 968, -576},
    { -432, 952, -584},
    { -288, 752, -456},
    { -72, 632, -320},
    { 128, 520, -184},
    { 200, 464, -136},
    { 208, 632, -80},
    { 520, 416, 104},
    { 400, 640, 0},
    { 448, 736, -128},
    { 296, 1048, -96},
    { 256, 1392, -304},
    { -104, 1632, -416},
    { -112, 1216, -464},
    { -136, 992, -432},
    { -88, 680, -480},
    { -24, 352, -408},
    // 11 seconds
    { -48, 104, -344},
    { -104, -8, -256},
    { -200, -56, -200},
    { -304, -80, -176},
    { -632, -32, -88},
    { -1176, -80, -24},
    { -2104, 56, 200},
    { -3328, 80, 608},
    { -2680, 584, -168},
    { -1224, 312, -256},
    { -1064, -120, -272},
    { -1264, 168, 104},
    { -1232, 336, 176},
    { -624, 96, 160},
    { -568, 272, -24},
    { -656, 432, -232},
    { -768, 400, -72},
    { -1080, 896, -168},
    { -1128, 248, -104},
    { -1656, 72, -352},
    { -1744, 480, -216},
    { -1328, 280, -240},
    { -1560, 224, -192},
    { -1744, 168, -8},
    { -1560, 88, 32},
    // 12 seconds
    { -1312, 72, 56},
    { -1192, 72, 64},
    { -1096, 32, 40},
    { -1048, 128, 72},
    { -952, 80, 64},
    { -968, 16, 120},
    { -744, -56, 72},
    { -856, 0, -8},
    { -920, 184, -328},
    { -1192, 280, -600},
    { -1632, 280, -336},
    { -1568, -416, 56},
    { -1312, -224, -104},
    { -1024, 224, -136},
    { -912, 408, -120},
    { -1032, 264, 8},
    { -1040, 208, 0},
    { -1096, 128, -208},
    { -1480, 296, 48},
    { -1696, 904, 800},
    { -1432, 1528, 144},
    { -728, 712, -496},
    { -824, 704, -240},
    { -1216, 616, 296},
    { -1448, 336, 320},
    // 13 seconds
    { -1176, 312, -8},
    { -1032, 360, 16},
    { -1072, 296, 152},
    { -1064, 336, 64},
    { -1048, 464, 16},
    { -1192, 624, 80},
    { -1216, 504, 40},
    { -896, 512, -168},
    { -848, 360, -152},
    { -640, 400, -216},
    { -560, 600, -480},
    { -816, 528, -376},
    { -816, 224, -152},
    { -760, 56, -56},
    { -752, 168, -24},
    { -904, 256, 80},
    { -1200, 312, 176},
    { -1440, 432, 256},
    { -1496, 608, 336},
    { -1384, 600, 152},
    { -1336, 960, 120},
    { -1544, 944, -224},
    { -1248, 1048, 24},
    { -696, 1128, -40},
    { -648, 1096, -144},
    // 14 seconds
    { -904, 824, 8},
    { -1256, 848, 272},
    { -1248, 488, 208},
    { -1248, 328, 176},
    { -1256, 272, 280},
    { -1224, 248, 216},
    { -1096, 224, 168},
    { -1008, 176, 168},
    { -1096, 128, 24},
    { -1016, 144, 128},
    { -1192, -88, 48},
    { -1264, 192, -288},
    { -1024, 384, -328},
    { -1112, 128, -280},
    { -1264, -80, -128},
    { -1168, -32, -176},
    { -1032, 120, -144},
    { -1000, 232, -104},
    { -1112, 392, -152},
    { -1168, 464, -96},
    { -1096, 592, -168},
    { -1104, 984, -328},
    { -1104, 448, -224},
    { -1344, 472, -176},
    { -1520, 528, -80},
    // 15 seconds
    { -1128, 360, -160},
    { -1248, 400, -88},
    { -1424, 400, -24},
    { -1432, 336, -16},
    { -1216, 240, 16},
    { -1056, 24, 88},
    { -1000, -24, 96},
    { -936, 96, 16},
    { -960, 192, 24},
    { -1088, -72, 168},
    { -1112, -320, 184},
    { -1064, -136, 56},
    { -1376, -128, 200},
    { -1352, 320, -288},
    { -1464, 216, -224},
    { -1736, 104, -160},
    { -1544, 200, -264},
    { -1304, 360, -144},
    { -1048, 344, 40},
    { -992, 288, 72},
    { -984, 264, 72},
    { -864, 240, -64},
    { -664, 368, -40},
    { -920, 512, -208},
    { -1072, 672, 72},
    // 16 seconds
    { -1552, 744, -88},
    { -1416, 352, -288},
    { -1272, 80, -272},
    { -1624, 136, -176},
    { -1664, 56, -136},
    { -1464, 8, -208},
    { -1176, -88, -184},
    { -1112, -168, -168},
    { -1240, 320, -120},
    { -1128, 56, -72},
    { -1024, 32, 24},
    { -928, -80, 208},
    { -664, -392, 344},
    { -672, -168, -40},
    { -1280, -304, 48},
    { -1568, 136, 24},
    { -1512, 248, -264},
    { -1488, -184, 8},
    { -1536, -48, -88},
    { -1360, 224, -96},
    { -1120, 320, 24},
    { -1080, 392, -88},
    { -1088, 432, -144},
    { -1056, 464, -160},
    { -1024, 416, -232},
    // 17 seconds
    { -1096, 496, -360},
    { -1064, 560, -296},
    { -1344, 424, -280},
    { -1248, 720, -104},
    { -888, 696, -328},
    { -1208, 616, -296},
    { -1488, 496, -128},
    { -1408, 328, 0},
    { -1232, 304, 40},
    { -1176, 296, 40},
    { -1216, 288, 88},
    { -1160, 176, 152},
    { -1032, 128, 88},
    { -976, -56, 72},
    { -912, -144, 16},
    { -952, -184, -40},
    { -1408, 96, -208},
    { -1344, 152, -496},
    { -1296, 240, -440},
    { -1304, 112, -256},
    { -1224, -152, -56},
    { -1136, -8, 16},
    { -960, 312, -40},
    { -872, 208, -48},
    { -984, 248, -96},
    // 18 seconds
    { -1056, 288, -120},
    { -1040, 264, -152},
    { -1208, 392, -176},
    { -1056, 664, -112},
    { -1448, 552, -208},
    { -1496, 592, -96},
    { -1104, 472, -120},
    { -1256, 408, -80},
    { -1416, 384, -8},
    { -1296, 328, 0},
    { -1120, 200, 48},
    { -1080, 120, 88},
    { -1056, 72, 120},
    { -976, 88, 104},
    { -952, 80, 88},
    { -1032, 64, 176},
    { -968, 16, 192},
    { -1024, 64, 248},
    { -1288, 104, 160},
    { -1232, 648, -608},
    { -1032, 432, -432},
    { -1312, 144, -392},
    { -1200, 152, -264},
    { -952, 144, -136},
    { -880, 184, -104},
    // 19 seconds
    { -928, 256, -16},
    { -936, 296, -40},
    { -888, 288, -112},
    { -960, 248, -128},
    { -1224, 520, -40},
    { -1024, 440, 16},
    { -1256, 720, -96},
    { -1432, 448, -256},
    { -1144, 736, -216},
    { -1024, 576, -232},
    { -1200, 464, -64},
    { -1280, 440, 96},
    { -1264, 448, 56},
    { -1120, 296, 136},
    { -992, 200, 136},
    { -992, 240, 104},
    { -904, 208, 88},
    { -784, 184, 40},
    { -808, 96, 72},
    { -784, -72, 80},
    { -824, 24, -32},
    { -1256, 152, -24},
    { -1600, 304, -248},
    { -1472, 176, -424},
    { -1536, -72, -72},
    // 20 seconds
    { -1416, 0, -112},
    { -1160, 192, -216},
    { -960, 224, -120},
    { -856, 224, -40},
    { -880, 176, -32},
    { -840, 232, -216},
    { -800, 248, -168},
    { -1096, 240, -48},
    { -1408, 384, 88},
    { -1304, 1216, -224},
    { -1400, -200, -336},
    { -1096, 184, -312},
    { -1240, 488, -120},
    { -1496, 408, 40},
    { -1400, 144, -48},
    { -1080, 120, -88},
    { -1056, 80, 48},
    { -1120, 40, 160},
    { -1096, 8, 112},
    { -992, 24, 120},
    { -1096, 96, 160},
    { -1176, 32, 144},
    { -1032, -136, 232},
    { -1272, 88, -48},
    { -1136, 232, -472},
    // 21 seconds
    { -1144, 80, -368},
    { -1176, -400, -272},
    { -1160, -328, -184},
    { -1040, 96, -184},
    { -904, 224, -88},
    { -904, 272, 0},
    { -1000, 272, 24},
    { -976, 224, 0},
    { -1008, 192, 0},
    { -1320, 264, 48},
    { -1296, 832, -80},
    { -1760, 504, 0},
    { -1328, -136, -152},
    { -1032, 136, -248},
    { -1296, 376, -40},
    { -1328, 344, 32},
    { -1096, 248, -48},
    { -952, 80, 0},
    { -976, 16, 96},
    { -1056, 56, 104},
    { -1080, 72, 112},
    { -1104, 64, 160},
    { -1224, 40, 240},
    { -1240, -216, 152},
    { -1360, 56, -64},
    // 22 seconds
    { -1080, 256, -504},
    { -1040, 8, -128},
    { -1272, -136, 120},
    { -1272, -240, 40},
    { -1128, 88, -64},
    { -1016, 248, -16},
    { -944, 224, 72},
    { -1000, 216, 128},
    { -976, 224, 112},
    { -816, 208, 72},
    { -968, 280, -72},
    { -1360, 312, 40},
    { -1864, 976, -8},
    { -1448, 144, -120},
    { -968, 336, -448},
    { -1224, 576, -256},
    { -1488, 552, -40},
    { -1408, 192, -16},
    { -1184, 48, 56},
    { -1176, 24, 120},
    { -1176, 64, 160},
    { -1144, 128, 136},
    { -1080, 104, 136},
    { -1024, 104, 176},
    { -1032, -56, 208},
    // 23 seconds
    { -1192, -56, 128},
    { -1208, 8, 32},
    { -1216, 264, -296},
    { -1080, 256, -264},
    { -1208, 80, -216},
    { -1208, -416, 88},
    { -1296, -256, 40},
    { -1328, 120, 96},
    { -1272, 432, 152},
    { -1256, 520, 96},
    { -1232, 288, 96},
    { -1088, 256, 8},
    { -1200, 424, -40},
    { -1216, 680, -48},
    { -1408, 536, 56},
    { -1320, 248, 40},
    { -1056, 232, -136},
    { -1216, 424, -112},
    { -1464, 408, 0},
    { -1488, 280, 32},
    { -1352, 112, 72},
    { -1296, 48, 128},
    { -1240, -32, 112},
    { -1112, 40, 120},
    { -1056, 56, 128},
    // 24 seconds
    { -1072, 184, 232},
    { -1104, 120, 152},
    { -1040, -88, 104},
    { -1184, -104, 64},
    { -1120, 8, -320},
    { -1152, 24, -240},
    { -1320, -96, -208},
    { -1224, -80, -136},
    { -1016, -16, -184},
    { -984, 56, -144},
    { -1024, 112, 64},
    { -1112, 208, 56},
    { -1080, 216, 152},
    { -1136, 456, -160},
    { -1328, 680, -416},
    { -944, 1152, -240},
    { -1472, 872, -376},
    { -1376, 648, -184},
    { -1176, 624, -208},
    { -1208, 584, -144},
    { -1352, 432, 72},
    { -1368, 512, 216},
    { -1208, 424, 232},
    { -1136, 344, 272},
    { -1120, 248, 352},
    // 25 seconds
    { -1056, 176, 336},
    { -880, 216, 168},
    { -760, 192, 208},
    { -784, 200, 72},
    { -640, 416, -360},
    { -1048, 280, 136},
    { -1112, 552, -112},
    { -1128, 624, -136},
    { -1032, 320, 152},
    { -1056, 384, 56},
    { -992, 400, 24},
    { -808, 240, 120},
    { -872, 352, -24},
    { -992, 416, 16},
    { -1208, 520, -152},
    { -1312, 456, 32},
    { -1520, 1128, 208},
    { -1032, 1080, -120},
    { -1448, 848, -144},
    { -1032, 712, 176},
    { -1104, 584, 168},
    { -1352, 400, 240},
    { -1296, 328, 200},
    { -1064, 296, 104},
    { -984, 272, 104},
    // 26 seconds
    { -992, 192, 160},
    { -1072, 208, 176},
    { -1096, 240, 80},
    { -1296, 384, 56},
    { -1368, -112, 192},
    { -1048, -360, 192},
    { -1200, -40, -136},
    { -1176, 48, -456},
    { -1344, 16, -248},
    { -1424, -96, -248},
    { -1320, 96, -144},
    { -1120, 304, -96},
    { -880, 312, -8},
    { -888, 256, 112},
    { -1032, 368, 72},
    { -1032, 424, -8},
    { -1064, 336, 16},
    { -1384, 584, 104},
    { -1128, 1192, 96},
    { -1624, 528, -104},
    { -976, 512, -176},
    { -1176, 560, -112},
    { -1368, 408, 40},
    { -1424, 296, 56},
    { -1200, 248, 40},
    // 27 seconds
    { -1080, 216, 96},
    { -1096, 152, 136},
    { -1128, 120, 144},
    { -1144, 120, 176},
    { -1192, 96, 224},
    { -1288, 0, 240},
    { -1128, -24, 64},
    { -1208, 0, 0},
    { -1096, 152, -264},
    { -1136, 128, -192},
    { -1248, -48, -40},
    { -1184, -136, 0},
    { -1080, 48, -40},
    { -1048, 232, 24},
    { -1112, 296, 176},
    { -1232, 352, 112},
    { -1248, 472, 0},
    { -1256, 552, -8},
    { -1304, 888, -56},
    { -1344, 304, -160},
    { -1480, 520, -208},
    { -1024, 448, -216},
    { -1160, 440, -136},
    { -1384, 352, 56},
    { -1448, 264, 72},
    // 28 seconds
    { -1200, 192, 32},
    { -1112, 160, 80},
    { -1152, 136, 112},
    { -1200, 104, 152},
    { -1208, 80, 88},
    { -1360, 104, 120},
    { -1304, -232, 256},
    { -1168, -272, 216},
    { -1192, -112, -40},
    { -904, -32, -264},
    { -1136, -104, -48},
    { -1392, -64, 72},
    { -1344, -32, 48},
    { -1200, 56, 32},
    { -1096, 192, 88},
    { -1256, 328, 64},
    { -1360, 432, 0},
    { -1288, 568, -96},
    { -1272, 440, -112},
    { -1440, 256, -112},
    { -1168, 512, -104},
    { -1256, 744, -248},
    { -992, 464, -232},
    { -1200, 384, -152},
    { -1456, 312, -16},
    // 29 seconds
    { -1656, 248, 48},
    { -1504, 152, 16},
    { -1368, 104, 80},
    { -1312, 104, 112},
    { -1256, 120, 120},
    { -1152, 56, 128},
    { -1064, 128, 192},
    { -1088, 96, 240},
    { -952, 96, 120},
    { -1136, 120, 144},
    { -1096, 160, -112},
    { -920, 168, -296},
    { -936, -48, -144},
    { -1216, -40, -184},
    { -1312, 104, -128},
    { -1264, 96, -56},
    { -1344, 264, 0},
    { -1424, 416, 144},
    { -1384, 488, 232},
    { -1128, 664, 72},
    { -1016, 584, 16},
    { -1040, 472, 128},
    { -1024, 960, 8},
    { -1264, 744, -152},
    { -1056, 840, -40},
    // 30 seconds
    { -1040, 672, -176},
    { -1152, 608, -112},
    { -1344, 552, -32},
    { -1336, 424, 160},
    { -1280, 336, 168},
    { -1288, 448, 216},
    { -1280, 368, 304},
    { -1152, 392, 288},
    { -976, 336, 240},
    { -864, 264, 248},
    { -744, 360, 192},
    { -600, 512, 224},
    { -632, 736, 200},
    { -520, 1008, 168},
    { -336, 784, 168},
    { -416, 864, -64},
    { -472, 600, -40},
    { -480, 360, -16},
    { -472, 272, -104},
    { -632, 112, -64},
    { -752, 104, 128},
    { -1016, 304, 144},
    { -1360, 432, 128},
    { -1784, 632, 128},
    { -2024, 928, 240},
    // 31 seconds
    { -1384, 1248, 176},
    { -1640, -48, -360},
    { -1464, 592, -32},
    { -888, 584, -112},
    { -880, 648, -160},
    { -1000, 664, -80},
    { -1120, 464, 0},
    { -1064, 328, -16},
    { -1040, 312, 24},
    { -1152, 256, 112},
    { -1264, 152, 160},
    { -1216, 96, 136},
    { -1208, 112, 176},
    { -1272, 112, 176},
    { -1216, 128, -24},
    { -1448, 88, 104},
    { -1344, 136, -312},
    { -1048, 16, -320},
    { -1040, -184, -56},
    { -1048, -368, -48},
    { -888, -112, -80},
    { -784, 56, -16},
    { -848, 104, 56},
    { -1008, 176, 104},
    { -1160, 224, 96},
    // 32 seconds
    { -1240, 360, -24},
    { -1432, 440, -56},
    { -1576, 776, -152},
    { -1240, 176, -296},
    { -1680, 352, -360},
    { -1360, 464, -296},
    { -1104, 344, -256},
    { -1200, 256, -104},
    { -1296, 200, 32},
    { -1184, 136, 64},
    { -1048, 96, 48},
    { -1096, 96, -56},
    { -1184, 112, 160},
    { -1240, 96, 176},
    { -1192, 72, 192},
    { -1176, 48, 200},
    { -1088, -144, 192},
    { -1256, -160, 168},
    { -1104, 32, -136},
    { -968, 80, -288},
    { -1152, -16, -80},
    { -1216, -152, 136},
    { -1176, -200, 112},
    { -1152, 128, 40},
    { -1088, 256, 8},
    // 33 seconds
    { -1112, 304, 56},
    { -1216, 352, 72},
    { -1096, 352, -24},
    { -1024, 480, -96},
    { -1080, 520, -136},
    { -1048, 264, -88},
    { -1408, 368, -120},
    { -1584, 480, -80},
    { -1432, 368, -96},
    { -1520, 272, -88},
    { -1688, 224, -64},
    { -1440, 96, 0},
    { -1280, 48, 72},
    { -1144, 0, 88},
    { -1024, 40, 48},
    { -952, 48, 64},
    { -1096, -128, 176},
    { -1216, -240, 272},
    { -952, -64, 72},
    { -1360, -224, 216},
    { -1104, 32, -24},
    { -1024, -8, -112},
    { -1408, 56, -80},
    { -1400, 80, -112},
    { -1272, 80, -112},
    // 34 seconds
    { -1456, 176, -136},
    { -1456, 184, -88},
    { -1216, 384, -232},
    { -1040, 616, -296},
    { -1224, 264, -280},
    { -1336, 216, -256},
    { -1368, 304, -504},
    { -1512, 248, -312},
    { -1272, 264, -176},
    { -1464, 288, -112},
    { -1616, 224, 48},
    { -1368, 152, 40},
    { -1128, 120, 72},
    { -1120, 56, -144},
    { -1000, 136, 80},
    { -1024, 72, 136},
    { -1072, 96, 128},
    { -1064, -24, 216},
    { -856, -16, 160},
    { -1120, 0, 160},
    { -1560, 0, 88},
    { -1328, 240, -256},
    { -1464, 200, -264},
    { -1472, 32, -144},
    { -1160, 96, -104},
    // 35 seconds
    { -1080, 248, -72},
    { -1232, 312, 16},
    { -1264, 352, 0},
    { -1160, 400, -96},
    { -1272, 696, -80},
    { -1304, 760, -16},
    { -1184, 664, 8},
    { -1136, 608, 88},
    { -888, 688, -120},
    { -1232, 752, -136},
    { -1504, 616, 56},
    { -1488, 576, 56},
    { -1216, 368, 112},
    { -1152, 392, 152},
    { -1152, 216, 168},
    { -1160, 224, 192},
    { -1200, 216, 248},
    { -1256, 192, 280},
    { -1232, 80, 208},
    { -968, 0, -64},
    { -1192, -56, -16},
    { -1152, 152, -288},
    { -1312, 304, -304},
    { -1392, -32, -80},
    { -1296, -216, -56},
    // 36 seconds
    { -1152, -24, -160},
    { -1016, 136, -104},
    { -952, 184, 64},
    { -1000, 248, 176},
    { -1096, 336, -80},
    { -1136, 424, -176},
    { -1456, 544, -152},
    { -1344, 1064, -136},
    { -1496, 40, -248},
    { -1368, 448, -256},
    { -992, 496, -296},
    { -1200, 392, -168},
    { -1512, 296, 32},
    { -1440, 176, 32},
    { -1192, 120, 24},
    { -1120, 160, 32},
    { -1120, 168, 64},
    { -1112, 176, 72},
    { -1128, 144, 80},
    { -1272, 112, 144},
    { -1248, -32, -8},
    { -1216, -200, 24},
    { -1192, -32, -104},
    { -1144, -128, -248},
    { -1288, -64, -144},
    // 37 seconds
    { -1256, -128, -16},
    { -1160, -56, -40},
    { -1104, 72, -32},
    { -1096, 160, 48},
    { -1128, 256, 120},
    { -1176, 336, 8},
    { -1160, 448, -72},
    { -1224, 560, -136},
    { -1240, 496, -224},
    { -1384, 184, -200},
    { -1656, 384, -256},
    { -1144, 368, -320},
    { -1352, 352, -264},
    { -1488, 264, -168},
    { -1416, 224, -152},
    { -1328, 184, -96},
    { -1216, 104, 24},
    { -1144, 88, 40},
    { -1064, 104, 32},
    { -1024, 128, 128},
    { -1000, 88, 128},
    { -1112, 48, 176},
    { -976, -144, 184},
    { -1344, -8, 0},
    { -1168, -80, -288},
    // 38 seconds
    { -1104, -144, -192},
    { -1224, -168, -200},
    { -1208, -88, -136},
    { -1048, -64, -128},
    { -1016, -24, -96},
    { -1112, 152, 64},
    { -1288, 360, 88},
    { -1352, 520, -128},
    { -1216, 640, -144},
    { -1232, 800, -176},
    { -1120, 504, -136},
    { -1544, 520, -40},
    { -1232, 528, -88},
    { -1088, 496, -160},
    { -1208, 264, -40},
    { -1368, 464, 56},
    { -1256, 336, 120},
    { -1056, 272, 152},
    { -944, 248, 160},
    { -984, 176, 200},
    { -960, 216, 192},
    { -1016, 208, 248},
    { -1272, 24, 408},
    { -1152, -40, 176},
    { -1304, -96, 264},
    // 39 seconds
    { -1264, 176, 16},
    { -1064, 400, -152},
    { -1184, 160, 32},
    { -1312, 192, 16},
    { -1136, 80, 72},
    { -1008, 224, 96},
    { -928, 264, 152},
    { -1032, 416, 184},
    { -1104, 512, 72},
    { -1040, 576, 16},
    { -1016, 704, 72},
    { -928, 936, -32},
    { -1272, 768, -32},
    { -1416, 728, 112},
    { -1104, 576, 40},
    { -1168, 632, 16},
    { -1416, 440, 136},
    { -1520, 416, 200},
    { -1424, 344, 240},
    { -1240, 168, 264},
    { -1168, 128, 248},
    { -1056, 144, 216},
    { -944, 72, 168},
    { -896, 88, 176},
    { -912, -64, 240},
    // 40 seconds
    { -728, -56, 32},
    { -1048, -8, 96},
    { -1376, 48, 88},
    { -1232, 296, -104},
    { -1400, 376, -200},
    { -1640, 216, -88},
    { -1488, 72, 56},
    { -1312, 240, 160},
    { -1112, 392, 312},
    { -1176, 520, 248},
    { -1104, 544, 168},
    { -952, 576, 152},
    { -832, 592, 0},
    { -848, 688, 136},
    { -904, 832, 96},
    { -1280, 856, 112},
    { -1120, 760, 16},
    { -1144, 632, -40},
    { -1344, 600, 144},
    { -1536, 608, 80},
    { -1440, 488, 104},
    { -1336, 400, 248},
    { -1312, 256, 288},
    { -1256, 192, 272},
    { -1104, 160, 200},
    // 41 seconds
    { -1008, 200, 208},
    { -1016, -80, 200},
    { -864, -264, 240},
    { -1064, -120, 136},
    { -1288, 168, 48},
    { -1280, 432, -232},
    { -1432, 224, -40},
    { -1544, 104, 8},
    { -1328, 160, -96},
    { -1184, 256, -48},
    { -1152, 336, 80},
    { -1224, 368, 88},
    { -1224, 488, -80},
    { -1200, 400, -176},
    { -1312, 584, -192},
    { -1136, 576, -144},
    { -1016, 560, -328},
    { -1480, 704, -184},
    { -1400, 400, -64},
    { -1520, 344, -72},
    { -1744, 312, -24},
    { -1664, 256, -8},
    { -1448, 216, 32},
    { -1352, 104, 64},
    { -1248, 32, 152},
    // 42 seconds
    { -1176, 64, 136},
    { -1056, 16, 136},
    { -992, -144, 248},
    { -912, -416, 440},
    { -720, -88, -32},
    { -1360, -72, 64},
    { -1600, 88, -160},
    { -1352, -48, -272},
    { -1408, -176, -232},
    { -1312, -360, -56},
    { -1216, -112, -176},
    { -1168, 112, -96},
    { -1104, 168, -88},
    { -1200, 168, -136},
    { -1248, 232, -232},
    { -1296, 408, -376},
    { -1232, 888, -288},
    { -1456, 16, -200},
    { -1640, 192, -64},
    { -1072, 288, -72},
    { -1232, 320, -64},
    { -1416, 328, 40},
    { -1424, 256, 24},
    { -1136, 152, -8},
    { -1056, 88, 24},
    // 43 seconds
    { -1144, 64, 104},
    { -1232, 72, 72},
    { -1272, 80, 48},
    { -1368, -112, 168},
    { -1216, -328, 360},
    { -1016, -152, 96},
    { -1296, -8, -96},
    { -1160, -72, -256},
    { -1312, -112, -152},
    { -1296, -224, -32},
    { -1208, -72, -48},
    { -1104, 128, 8},
    { -952, 256, 24},
    { -944, 200, 120},
    { -992, 288, 168},
    { -1032, 328, 192},
    { -1240, 336, 176},
    { -1296, 512, 200},
    { -1440, 776, 80},
    { -1384, 552, -8},
    { -952, 360, -128},
    { -1176, 424, -120},
    { -1336, 384, 8},
    { -1288, 336, -8},
    { -1104, 216, 8},
    // 44 seconds
    { -1056, 144, 48},
    { -1128, 112, 96},
    { -1168, 40, 96},
    { -1176, 72, 96},
    { -1328, 144, 144},
    { -1280, -224, 272},
    { -1256, -112, 184},
    { -1232, 48, 40},
    { -1144, 168, -304},
    { -1208, -72, -88},
    { -1144, -360, 0},
    { -1072, -120, -72},
    { -960, 48, -24},
    { -880, 200, 0},
    { -896, 136, 112},
    { -1016, 216, -8},
    { -1096, 264, -64},
    { -1328, 432, -64},
    { -1360, 768, 56},
    { -1344, 376, -200},
    { -1624, 680, -136},
    { -920, 424, -104},
    { -1128, 392, -88},
    { -1368, 368, 8},
    { -1328, 320, 16},
    // 45 seconds
    { -1080, 296, 40},
    { -1024, 192, 104},
    { -1016, 120, 136},
    { -1008, 88, 128},
    { -1016, 176, 144},
    { -1096, 96, 200},
    { -1152, 72, 200},
    { -1040, 120, 96},
    { -1368, 24, 48},
    { -1272, 360, -360},
    { -872, 168, -304},
    { -1104, 104, -200},
    { -1168, 40, -112},
    { -984, 144, -88},
    { -824, 184, -48},
    { -856, 192, 64},
    { -1008, 272, 128},
    { -1080, 384, 128},
    { -1280, 824, 48},
    { -1440, 736, 80},
    { -1136, 904, 72},
    { -1512, 912, -112},
    { -1168, 568, -56},
    { -904, 672, -200},
    { -968, 616, -104},
    // 46 seconds
    { -1160, 576, 88},
    { -1144, 480, 200},
    { -1016, 432, 224},
    { -1016, 352, 248},
    { -1040, 280, 280},
    { -1008, 232, 304},
    { -936, 264, 200},
    { -992, 200, 272},
    { -960, 312, 128},
    { -1072, 320, 280},
    { -1040, 664, 80},
    { -760, 840, 0},
    { -896, 768, 120},
    { -864, 648, 128},
    { -760, 592, 72},
    { -576, 392, 112},
    { -472, 376, 64},
    { -472, 384, 136},
    { -568, 392, 152},
    { -632, 456, 152},
    { -808, 464, 168},
    { -1216, 640, 176},
    { -1392, 600, 376},
    { -1808, 944, 272},
    { -1176, 784, 48},
    // 47 seconds
    { -896, 840, 32},
    { -928, 600, 104},
    { -952, 568, 208},
    { -784, 456, 112},
    { -640, 424, 104},
    { -712, 264, 152},
    { -840, 256, 184},
    { -960, 208, 208},
    { -1160, -232, 240},
    { -1168, -104, 80},
    { -1048, -32, -16},
    { -1736, 160, 104},
    { -1624, 496, -80},
    { -1032, 304, 0},
    { -1128, 176, -8},
    { -1152, 56, -96},
    { -976, 120, -40},
    { -728, 104, 0},
    { -656, 112, 72},
    { -768, 232, 56},
    { -928, 304, 88},
    { -920, 440, 136},
    { -1112, 552, 120},
    { -1048, 704, 336},
    { -1544, 752, 184},
    // 48 seconds
    { -1184, 608, 48},
    { -1024, 616, -80},
    { -1216, 608, -8},
    { -1376, 504, 104},
    { -1320, 408, 184},
    { -1080, 272, 160},
    { -976, 240, 200},
    { -960, 176, 160},
    { -936, 192, 112},
    { -920, 152, 152},
    { -1056, -24, 288},
    { -1136, -304, 336},
    { -1176, -88, 264},
    { -1296, 224, 120},
    { -1288, 472, -152},
    { -1416, 288, -24},
    { -1424, 256, 40},
    { -1216, 312, -112},
    { -976, 304, -168},
    { -880, 224, -48},
    { -960, 296, 0},
    { -1056, 352, -16},
    { -952, 392, -64},
    { -1104, 544, -120},
    { -1136, 728, 80},
    // 49 seconds
    { -1472, 624, -32},
    { -1464, 592, 40},
    { -1064, 448, -16},
    { -1256, 408, 48},
    { -1408, 368, 120},
    { -1360, 320, 112},
    { -1200, 248, 144},
    { -1128, 112, 192},
    { -1120, 80, 176},
    { -1072, 64, 152},
    { -976, 104, 160},
    { -960, 96, 184},
    { -1016, 40, 200},
    { -960, -32, 128},
    { -1232, 48, 80},
    { -1184, 264, -280},
    { -1288, 312, -232},
    { -1464, 168, -152},
    { -1328, 224, -72},
    { -1056, 304, -96},
    { -920, 312, 64},
    { -976, 336, 104},
    { -1056, 352, 144},
    { -1048, 400, 96},
    { -936, 424, 96},
    // 50 seconds
    { -984, 536, 136},
    { -952, 520, 208},
    { -1496, 600, 232},
    { -1304, 552, 160},
    { -984, 464, 40},
    { -1136, 472, 48},
    { -1216, 384, 72},
    { -1192, 296, 80},
    { -1128, 216, 136},
    { -1088, 208, 120},
    { -1080, 176, 144},
    { -1016, 104, 160},
    { -944, 120, 168},
    { -952, 144, 192},
    { -1048, 128, 240},
    { -992, 40, 128},
    { -1176, 40, 136},
    { -1344, 136, 0},
    { -1184, 272, -144},
    { -1184, 320, -184},
    { -1288, 256, -152},
    { -1160, 192, -72},
    { -1048, 280, -16},
    { -992, 248, 64},
    { -1032, 328, 80},
    // 51 seconds
    { -1032, 368, 64},
    { -968, 344, 32},
    { -944, 472, 24},
    { -912, 504, 40},
    { -912, 480, -24},
    { -1048, 480, 0},
    { -1352, 488, 80},
    { -1208, 416, 56},
    { -1128, 400, -16},
    { -1216, 384, -8},
    { -1272, 312, 32},
    { -1232, 336, 56},
    { -1104, 104, 80},
    { -976, 304, 120},
    { -1016, 296, 136},
    { -928, 176, 248},
    { -792, 352, 280},
    { -688, 264, 136},
    { -688, 272, 208},
    { -728, 416, 208},
    { -656, 568, 152},
    { -816, 656, 296},
    { -880, 800, 328},
    { -784, 960, 104},
    { -776, 808, 72},
    // 52 seconds
    { -872, 568, 88},
    { -840, 568, 8},
    { -688, 376, 24},
    { -624, 304, 64},
    { -688, 296, 96},
    { -752, 280, 128},
    { -800, 328, 96},
    { -888, 392, 104},
    { -1280, 456, 48},
    { -1416, 600, 296},
    { -1520, 1312, 72},
    { -1424, 632, -272},
    { -912, 752, -248},
    { -1008, 672, -80},
    { -1168, 384, 112},
    { -1200, 344, 112},
    { -1008, 280, 136},
    { -896, 224, 144},
    { -904, 104, 152},
    { -960, 120, 192},
    { -928, 112, 200},
    { -936, 80, 288},
    { -1096, 152, 224},
    { -1128, 272, -32},
    { -1456, 224, 72},
    // 53 seconds
    { -1360, 328, -208},
    { -912, 240, -264},
    { -912, 88, -240},
    { -1064, -144, -232},
    { -968, -240, -160},
    { -912, -48, -104},
    { -928, 128, 0},
    { -1048, 288, -8},
    { -1112, 424, -144},
    { -1024, 552, -200},
    { -1040, 688, -120},
    { -1192, 512, -96},
    { -1704, 224, -32},
    { -1664, 336, -16},
    { -1096, 312, -192},
    { -1096, 296, -136},
    { -1296, 288, 32},
    { -1312, 160, 80},
    { -1128, 104, 48},
    { -976, 40, 64},
    { -936, 8, 96},
    { -920, 32, 56},
    { -896, 48, 120},
    { -904, 40, 136},
    { -1080, 16, 160},
    // 54 seconds
    { -1072, 40, 8},
    { -1240, 8, -8},
    { -1240, 144, -400},
    { -1128, 168, -416},
    { -1248, -56, -224},
    { -1408, -352, -40},
    { -1200, -40, 32},
    { -936, 240, 104},
    { -816, 376, 96},
    { -912, 376, -16},
    { -1008, 256, -8},
    { -896, 208, -56},
    { -1016, 264, -128},
    { -1120, 296, -48},
    { -1576, 616, -112},
    { -1560, 104, -96},
    { -1056, 184, -232},
    { -1152, 384, -104},
    { -1392, 288, 120},
    { -1288, 8, 72},
    { -1040, -56, -40},
    { -984, -40, 8},
    { -816, 120, -64},
    { -1032, 48, 40},
    { -992, 96, -16},
    // 55 seconds
    { -1024, 64, 8},
    { -1120, 0, 48},
    { -1200, 0, -16},
    { -1248, 128, -24},
    { -1152, 320, -512},
    { -1152, 240, -376},
    { -1192, -32, -40},
    { -1192, -272, -48},
    { -1032, 120, -128},
    { -840, 296, -136},
    { -784, 256, -144},
    { -832, 160, -160},
    { -832, 216, -160},
    { -880, 208, -160},
    { -1168, 296, -208},
    { -1256, 616, -160},
    { -1704, 536, -192},
    { -1360, 160, -264},
    { -992, 360, -304},
    { -1168, 392, -232},
    { -1264, 104, -152},
    { -1272, 152, -136},
    { -1104, 112, -72},
    { -1016, 136, -24},
    { -1008, 144, 16},
    // 56 seconds
    { -944, 128, 24},
    { -912, 120, -8},
    { -928, 96, 56},
    { -1016, 56, 32},
    { -1024, 80, -8},
    { -1168, 88, -128},
    { -1136, 160, -408},
    { -1064, 128, -560},
    { -1168, 0, -400},
    { -1256, 16, -360},
    { -1176, 120, -280},
    { -1048, 328, -304},
    { -952, 312, -264},
    { -920, 336, -296},
    { -848, 344, -296},
    { -656, 336, -240},
    { -568, 360, -248},
    { -760, 560, -288},
    { -832, 560, -416},
    { -856, 488, -304},
    { -1256, 664, -384},
    { -1240, 576, -336},
    { -1040, 464, -224},
    { -1048, 376, -176},
    { -1040, 272, -120},
    // 57 seconds
    { -968, 480, -56},
    { -968, 624, -112},
    { -968, 384, -24},
    { -1024, 344, -104},
    { -1032, 352, -72},
    { -984, 408, -120},
    { -912, 496, -48},
    { -792, 512, -88},
    { -696, 616, -48},
    { -632, 648, -8},
    { -592, 904, 104},
    { -288, 968, 40},
    { -152, 840, 40},
    { -104, 840, 240},
    { -104, 824, 208},
    { -96, 816, 296},
    { -64, 816, 336},
    { -40, 816, 264},
    { -40, 832, 232},
    { -24, 840, 232},
    { 0, 872, 208},
    { 24, 832, 200},
    { 32, 832, 168},
    { 56, 808, 192},
    { 24, 808, 144},
    // 58 seconds
    { 56, 872, 136},
    { 72, 976, 216},
    { 32, 992, 216},
    { 32, 904, 112},
    { 48, 856, 40},
    { 64, 832, 96},
    { 32, 744, 8},
    { -24, 1064, -80},
    { 8, 896, 168},
    { 48, 944, 120},
    { 48, 944, 256},
    { 64, 952, 96},
    { 96, 920, 136},
    { 144, 992, 144},
    { 48, 872, -16},
    { 224, 1072, -32},
    { 72, 1056, -96},
    { 96, 1104, -112},
    { 88, 864, -240},
    { 48, 808, -416},
    { 48, 704, -576},
    { 40, 520, -680},
    { 16, 304, -736},
    { -64, 184, -784},
    { -72, 40, -864},
    // 59 seconds
    { -56, -56, -872},
    { -40, -144, -848},
    { -8, -208, -896},
    { 0, -192, -944},
    { 8, -160, -1016},
    { 24, -168, -1008},
    { 8, -168, -1064},
    { 32, -152, -1064},
    { 32, -176, -1016},
    { 32, -144, -1000},
    { 32, -152, -1016},
    { 40, -136, -968},
    { 48, -136, -976},
    { 64, -144, -952},
    { 72, -168, -912},
    { 72, -176, -944},
    { 104, -208, -904},
    { 80, -184, -896},
    { 80, -176, -904},
    { -72, -224, -920},
    { -80, -152, -952},
    { -104, -152, -952},
    { -144, -136, -1040},
    { -168, -144, -1072},
    { -144, -104, -1080},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-16 17:17:32 local
AccelRawData *activity_sample_walk_100_pbl_28394_6(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_28394_6
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -272, -384, -992},
    { -312, -280, -960},
    { -240, -272, -1080},
    { -288, -304, -1032},
    { -240, -256, -1008},
    { -232, -288, -1032},
    { -232, -336, -968},
    { -264, -304, -936},
    { -232, -312, -976},
    { -240, -280, -960},
    { -248, -280, -936},
    { -240, -272, -960},
    { -248, -280, -944},
    { -240, -288, -944},
    { -216, -280, -992},
    { -216, -280, -944},
    { -208, -296, -960},
    { -248, -288, -968},
    { -248, -320, -920},
    { -288, -304, -960},
    { -280, -296, -992},
    { -264, -328, -976},
    { -224, -272, -976},
    { -200, -256, -1000},
    { -136, -256, -1008},
    // 1 seconds
    { -224, -240, -984},
    { -120, -224, -976},
    { -160, -272, -968},
    { -160, -216, -984},
    { -160, -240, -1032},
    { -136, -192, -1016},
    { -128, -168, -1016},
    { -96, -152, -1048},
    { -72, -136, -1008},
    { -40, -72, -992},
    { -32, 16, -984},
    { -40, 72, -928},
    { -40, 72, -960},
    { -8, 120, -920},
    { -8, 40, -952},
    { -32, 24, -952},
    { -24, -48, -968},
    { -88, -200, -936},
    { -120, -128, -688},
    { -216, -80, -560},
    { -176, 400, -528},
    { -360, 792, 16},
    { -208, 1304, 288},
    { -96, 1192, 584},
    { 16, 1272, 568},
    // 2 seconds
    { 104, 952, 440},
    { 88, 1096, 336},
    { 72, 896, 192},
    { 112, 1016, 184},
    { 80, 928, 128},
    { 64, 840, 144},
    { 32, 776, 184},
    { 128, 568, 224},
    { 128, 968, 208},
    { 144, 712, 488},
    { 248, 936, 296},
    { 232, 928, 440},
    { 248, 896, 344},
    { 272, 640, 344},
    { 208, 984, 208},
    { 192, 760, 8},
    { 264, 920, 128},
    { 272, 752, 216},
    { 272, 664, 96},
    { 280, 800, 136},
    { 360, 792, 120},
    { 352, 984, 128},
    { 400, 824, 344},
    { 400, 944, 144},
    { 424, 912, 240},
    // 3 seconds
    { 424, 792, -80},
    { 408, 776, -152},
    { 456, 688, -48},
    { 456, 624, -120},
    { 440, 600, -40},
    { 440, 664, -88},
    { 424, 632, 40},
    { 440, 768, 112},
    { 496, 824, 72},
    { 504, 760, 120},
    { 512, 768, 24},
    { 496, 440, 152},
    { 464, 824, -8},
    { 520, 728, 40},
    { 544, 712, -216},
    { 552, 592, -80},
    { 592, 648, -232},
    { 584, 704, -200},
    { 624, 616, -272},
    { 592, 600, -88},
    { 584, 624, -88},
    { 600, 664, -152},
    { 600, 648, -96},
    { 600, 672, -120},
    { 608, 680, -72},
    // 4 seconds
    { 616, 680, -64},
    { 616, 656, -64},
    { 592, 648, -40},
    { 600, 632, -80},
    { 576, 632, -48},
    { 568, 680, -40},
    { 576, 664, 0},
    { 560, 664, 72},
    { 552, 672, 56},
    { 512, 712, 168},
    { 512, 696, 112},
    { 472, 744, 168},
    { 480, 728, 192},
    { 448, 736, 240},
    { 424, 736, 160},
    { 368, 688, 112},
    { 272, 600, 24},
    { 176, 440, -32},
    { -8, 536, -160},
    { -216, 216, 48},
    { -608, 456, -256},
    { -936, 520, -176},
    { -1504, 392, -128},
    { -1624, 448, -280},
    { -1784, 272, -112},
    // 5 seconds
    { -1952, 456, 88},
    { -1744, 456, 232},
    { -1440, 480, 208},
    { -1192, 336, 168},
    { -1088, 208, 112},
    { -1016, 320, 72},
    { -1008, 128, 104},
    { -1032, 280, 288},
    { -968, 608, 184},
    { -1040, 752, 192},
    { -1112, 896, 264},
    { -968, 600, 136},
    { -1440, 504, 288},
    { -2064, 472, 424},
    { -1880, 136, 328},
    { -1592, 56, 288},
    { -1464, 72, 296},
    { -1248, -48, 248},
    { -1128, 88, 240},
    { -968, 88, 184},
    { -928, 112, 200},
    { -968, 64, 232},
    { -912, -32, 56},
    { -1048, -152, 112},
    { -1096, 48, -152},
    // 6 seconds
    { -992, 320, -640},
    { -1536, 968, -632},
    { -1528, 960, -320},
    { -1144, 1800, -352},
    { -784, 1680, 0},
    { -256, 1480, -120},
    { 32, 1128, 96},
    { 104, 1288, 312},
    { 144, 1064, 472},
    { 288, 816, 520},
    { 448, 712, 456},
    { 456, 280, 240},
    { 488, 408, 136},
    { 184, 256, -160},
    { 144, 600, -312},
    { 0, 632, -344},
    { -120, 640, -336},
    { -64, 448, -432},
    { -88, 792, -312},
    { -104, 808, -320},
    { -176, 744, -672},
    { 0, 416, -480},
    { 240, 432, -688},
    { 376, 472, -472},
    { 296, 528, -544},
    // 7 seconds
    { -184, 816, -768},
    { -632, 736, -1552},
    { -376, 656, -704},
    { -48, 664, -200},
    { 72, 616, -288},
    { -72, 376, -352},
    { -472, 560, -480},
    { -592, 936, -928},
    { -576, 624, -688},
    { -536, 336, -848},
    { -496, 296, -792},
    { -256, 168, -408},
    { 64, -360, -616},
    { -440, -328, -1464},
    { -288, 416, -440},
    { -544, 1904, -224},
    { -472, 1224, -672},
    { -624, 856, -656},
    { -504, 328, -480},
    { -512, 512, -352},
    { -728, 640, -376},
    { -808, 1064, -424},
    { -536, 664, -264},
    { -296, 432, -96},
    { -616, 8, -920},
    // 8 seconds
    { -952, 320, -952},
    { -1040, 784, -968},
    { -368, 416, -728},
    { -464, 272, -576},
    { -664, -296, -776},
    { -432, -416, -920},
    { -360, 216, -816},
    { -344, 784, -784},
    { -320, 128, -496},
    { -464, -72, -472},
    { -552, -144, -544},
    { -840, -568, -680},
    { -1096, -560, -848},
    { -856, -640, -936},
    { -896, -184, -856},
    { -672, 216, -936},
    { -368, 416, -976},
    { -488, 32, -1048},
    { -128, -136, -920},
    { 64, -64, -480},
    { 128, -120, -352},
    { 136, 248, -328},
    { 152, 272, -304},
    { 208, 160, -224},
    { -32, 168, -152},
    // 9 seconds
    { -192, 248, -112},
    { -344, 608, -280},
    { -1240, 816, -464},
    { -1208, 1160, -480},
    { -1696, 824, -624},
    { -2512, 928, -184},
    { -1960, 768, 96},
    { -2128, 712, 88},
    { -1712, 704, 192},
    { -1184, 672, -168},
    { -1096, 520, -304},
    { -1080, 464, -136},
    { -1328, 584, 48},
    { -1280, 456, -32},
    { -1296, 728, -272},
    { -1176, 744, -400},
    { -1568, 360, -136},
    { -1312, 440, -40},
    { -1432, 536, 104},
    { -1664, 520, 144},
    { -1552, 352, 200},
    { -1368, 248, 208},
    { -1352, 192, 280},
    { -1352, 144, 224},
    { -1224, 80, 160},
    // 10 seconds
    { -1072, 72, 152},
    { -1048, 64, 176},
    { -880, -240, 256},
    { -808, -72, 144},
    { -1128, 72, 0},
    { -952, 360, -360},
    { -1024, 272, -208},
    { -1320, -216, -128},
    { -1528, -16, -120},
    { -1520, 304, -120},
    { -1416, 416, 80},
    { -1408, 784, 280},
    { -1104, 808, -56},
    { -904, 784, -192},
    { -840, 832, -120},
    { -824, 880, -48},
    { -984, 976, -96},
    { -1480, 848, -8},
    { -1264, 624, -8},
    { -1384, 576, 8},
    { -1584, 464, 160},
    { -1576, 368, 168},
    { -1256, 280, 136},
    { -1056, 208, 136},
    { -1032, 120, 168},
    // 11 seconds
    { -1040, 64, 144},
    { -968, 48, 128},
    { -952, 88, 96},
    { -968, 56, 152},
    { -848, 64, 64},
    { -1128, 64, 96},
    { -1280, 288, -200},
    { -1256, 416, -384},
    { -1472, 216, -176},
    { -1416, -160, -24},
    { -1200, -152, -88},
    { -1040, 184, 56},
    { -1008, 344, 136},
    { -1016, 400, 64},
    { -1032, 416, -88},
    { -1048, 384, 56},
    { -1352, 632, -120},
    { -1144, 1408, 0},
    { -1472, 360, -104},
    { -1080, 464, -144},
    { -1136, 760, -64},
    { -1464, 712, 64},
    { -1544, 472, 152},
    { -1272, 384, 72},
    { -1072, -1888, 920},
    // 12 seconds
    { -1440, 88, 424},
    { -1176, 208, 128},
    { -1152, 96, 80},
    { -1152, 40, 56},
    { -1104, -128, 104},
    { -760, -264, 88},
    { -1104, 32, -56},
    { -1136, 312, -328},
    { -1104, 256, -272},
    { -1272, 200, -72},
    { -1320, -272, 72},
    { -1216, -104, 8},
    { -1112, 128, 96},
    { -1096, 360, 288},
    { -1152, 432, 128},
    { -1176, 464, 8},
    { -1088, 432, 8},
    { -1272, 688, -216},
    { -1032, 944, -168},
    { -1712, 472, -352},
    { -1224, 440, -440},
    { -1088, 504, -480},
    { -1360, 440, -264},
    { -1608, 392, -112},
    { -1256, -16, -160},
    // 13 seconds
    { -1096, 96, -128},
    { -1112, 104, -16},
    { -1152, 104, 24},
    { -1152, 168, 80},
    { -1160, 136, 128},
    { -1224, 56, 40},
    { -992, -240, 24},
    { -1256, -192, -16},
    { -1168, 8, -416},
    { -1120, 24, -304},
    { -1296, -32, -240},
    { -1264, -128, -256},
    { -1096, 0, -176},
    { -1120, 168, -72},
    { -1192, 312, -8},
    { -1240, 392, -40},
    { -1224, 432, -128},
    { -1320, 816, -264},
    { -1320, 632, -264},
    { -1368, 560, -440},
    { -1624, 680, -272},
    { -1176, 440, -392},
    { -1304, 368, -336},
    { -1512, 344, -144},
    { -1552, 352, -176},
    // 14 seconds
    { -1312, 320, -224},
    { -1176, 184, -96},
    { -1152, 176, -48},
    { -1104, 216, 24},
    { -1000, 64, 24},
    { -1008, 168, 0},
    { -1032, 96, 176},
    { -888, -72, 112},
    { -1088, -56, 32},
    { -1208, 208, -320},
    { -1320, 232, -288},
    { -1544, 208, -240},
    { -1608, 208, -144},
    { -1432, 344, -32},
    { -1216, 392, 56},
    { -1056, 488, 232},
    { -1056, 768, 200},
    { -1080, 712, 192},
    { -992, 592, 264},
    { -976, 824, 352},
    { -824, 912, 336},
    { -1184, 1432, 288},
    { -1224, 944, -56},
    { -1272, 1048, -176},
    { -1656, 832, 64},
    // 15 seconds
    { -1816, 664, 192},
    { -1624, 504, 224},
    { -1472, 408, 224},
    { -1392, 328, 256},
    { -1232, 264, 280},
    { -1056, 280, 328},
    { -912, 336, 280},
    { -880, 128, 328},
    { -568, -624, -632},
    { -984, -360, -128},
    { -1168, 480, -272},
    { -1472, 712, -216},
    { -1808, 560, -56},
    { -1912, 520, 96},
    { -1672, 480, 480},
    { -1232, 928, 160},
    { -1184, 776, 72},
    { -1304, 552, 160},
    { -1280, 472, 232},
    { -1144, 544, 296},
    { -1160, 960, 280},
    { -736, 720, 312},
    { -960, 960, 288},
    { -936, 880, 384},
    { -960, 752, 240},
    // 16 seconds
    { -1200, 704, 248},
    { -1400, 656, 280},
    { -1560, 600, 296},
    { -1520, 432, 280},
    { -1456, 400, 312},
    { -1560, 352, 344},
    { -1504, 272, 224},
    { -1352, 200, 320},
    { -1376, 184, 160},
    { -1224, 32, 176},
    { -1080, -232, 112},
    { -1104, -88, 8},
    { -960, 216, -288},
    { -1096, 216, -168},
    { -1200, -136, 0},
    { -1264, 88, -80},
    { -1280, 272, -64},
    { -1408, 384, 24},
    { -1536, 472, 104},
    { -1552, 480, 40},
    { -1328, 1296, -232},
    { -1120, 384, -224},
    { -1232, 792, -80},
    { -1224, 696, -280},
    { -1488, 776, -160},
    // 17 seconds
    { -1120, 552, -232},
    { -1288, 496, -224},
    { -1520, 472, 0},
    { -1600, 392, 64},
    { -1328, 208, 72},
    { -1216, 88, 72},
    { -1200, 120, 104},
    { -1160, 128, 104},
    { -1080, 112, 88},
    { -1152, 72, 152},
    { -1032, -216, 192},
    { -1000, -256, 0},
    { -1184, -72, -104},
    { -1280, 168, -400},
    { -1456, 152, -376},
    { -1544, -184, -136},
    { -1448, -168, -120},
    { -1256, 200, -112},
    { -1104, 288, 0},
    { -1096, 360, 80},
    { -1192, 424, -24},
    { -1224, 440, -8},
    { -1352, 936, -80},
    { -1136, 568, 0},
    { -1184, 440, -272},
    // 18 seconds
    { -1376, 640, -200},
    { -1096, 536, -192},
    { -1376, 488, -168},
    { -1672, 336, -24},
    { -1640, 296, -112},
    { -1368, 184, -104},
    { -1512, 16, -648},
    { -1296, 176, 8},
    { -1272, 80, 16},
    { -1216, 96, 24},
    { -1192, 40, 56},
    { -992, -288, 120},
    { -768, -176, -32},
    { -1104, -96, 24},
    { -1208, 72, -144},
    { -1120, 120, -336},
    { -1440, 88, -280},
    { -1568, -72, -24},
    { -1480, 104, -8},
    { -1272, 488, -72},
    { -1120, 904, -176},
    { -1048, 256, -144},
    { -1064, 456, -152},
    { -1016, 504, -144},
    { -1192, 616, -176},
    // 19 seconds
    { -1136, 424, -160},
    { -1464, 552, -192},
    { -1304, 400, -152},
    { -1168, 360, -192},
    { -1440, 352, -40},
    { -1624, 296, 80},
    { -1328, 272, -72},
    { -1040, 192, -64},
    { -992, 144, 16},
    { -1000, 88, 48},
    { -1016, 64, 72},
    { -1088, 88, -8},
    { -856, -592, 312},
    { -832, 64, -232},
    { -1200, -304, 192},
    { -1848, -304, 48},
    { -1408, -112, -344},
    { -1400, -112, -280},
    { -1360, -256, -40},
    { -1256, 32, -96},
    { -1008, 232, -56},
    { -952, 320, -16},
    { -944, 216, -24},
    { -1016, 288, -64},
    { -1040, 232, -48},
    // 20 seconds
    { -1240, 512, -200},
    { -1048, 1192, -136},
    { -1280, 744, -464},
    { -1528, 528, -440},
    { -1200, 192, -408},
    { -1368, 240, -384},
    { -1704, 136, -120},
    { -1680, 216, -48},
    { -1384, 216, -24},
    { -1328, 240, -8},
    { -1256, 240, 40},
    { -1192, 192, 56},
    { -1056, 64, 80},
    { -1136, 112, 272},
    { -760, -632, -200},
    { -672, -424, -344},
    { -1088, -32, -192},
    { -1528, 280, -40},
    { -1568, 496, -384},
    { -1528, 544, -464},
    { -1616, 272, 80},
    { -1536, 360, 16},
    { -1224, 496, -88},
    { -1072, 472, -64},
    { -1032, 432, -48},
    // 21 seconds
    { -1064, 368, -32},
    { -1016, 384, -32},
    { -976, 480, -32},
    { -1048, 736, -24},
    { -1024, 504, -80},
    { -1512, 712, -160},
    { -1232, 496, -136},
    { -1160, 408, -216},
    { -1480, 328, -72},
    { -1592, 192, -144},
    { -1408, 152, -168},
    { -1328, 272, -88},
    { -1264, 256, -32},
    { -1208, 176, 0},
    { -1176, 104, 72},
    { -1120, 208, 48},
    { -1240, 176, 64},
    { -1048, 144, 8},
    { -1192, 16, 0},
    { -1080, 64, -152},
    { -936, 200, -448},
    { -1080, 144, -280},
    { -1192, -184, -88},
    { -1280, -40, -40},
    { -1224, 240, -168},
    // 22 seconds
    { -1288, 328, -136},
    { -1400, 392, 8},
    { -1448, 488, -88},
    { -1360, 648, -32},
    { -1328, 464, -56},
    { -1312, 440, 24},
    { -1168, 496, 0},
    { -1184, 688, -40},
    { -936, 520, -184},
    { -1128, 576, -256},
    { -1504, 448, -216},
    { -1544, 320, -208},
    { -1360, 240, -136},
    { -1344, 200, 8},
    { -1368, 56, 72},
    { -1408, 112, 88},
    { -1264, 0, 56},
    { -1280, -88, 136},
    { -1104, -280, 152},
    { -888, -344, 48},
    { -1176, -256, -64},
    { -1232, -8, -224},
    { -1152, -64, -280},
    { -1448, 56, -408},
    { -1416, -120, -272},
    // 23 seconds
    { -1240, -128, -336},
    { -1208, 40, -240},
    { -1240, 168, -72},
    { -1288, 288, -40},
    { -1288, 328, -64},
    { -1264, 624, -112},
    { -1104, 648, -320},
    { -952, 520, -232},
    { -1256, 664, -296},
    { -1200, 512, -136},
    { -1152, 432, -184},
    { -1464, 368, -80},
    { -1680, 288, 24},
    { -1408, 320, -24},
    { -1160, 240, -48},
    { -1408, 168, 160},
    { -1144, 176, -56},
    { -1152, 232, -64},
    { -1192, 192, -48},
    { -1248, -128, 56},
    { -976, -120, 24},
    { -1048, -216, -40},
    { -1304, 80, -216},
    { -1232, 72, -264},
    { -1488, 160, -376},
    // 24 seconds
    { -1552, 120, -64},
    { -1280, 288, 56},
    { -944, 552, -160},
    { -824, 448, -160},
    { -944, 288, -72},
    { -1040, 424, -32},
    { -1008, 416, -32},
    { -1168, 648, -56},
    { -1056, 664, 32},
    { -1392, 392, -312},
    { -1440, 520, -80},
    { -1184, 456, -128},
    { -1480, 400, -72},
    { -1520, 304, 0},
    { -1224, 264, -136},
    { -1008, 288, -136},
    { -1064, 184, -56},
    { -1096, 152, 8},
    { -1048, 136, 32},
    { -1024, 112, 40},
    { -1104, -24, 144},
    { -976, -96, 24},
    { -952, -120, -72},
    { -1240, -8, -48},
    { -1200, 72, -344},
    // 25 seconds
    { -1368, 40, -448},
    { -1536, 48, -192},
    { -1440, 96, -72},
    { -1112, 136, 24},
    { -912, 368, 32},
    { -952, 488, 16},
    { -1096, 360, 96},
    { -1048, 328, 80},
    { -944, 336, 88},
    { -1128, 696, 40},
    { -968, 752, -56},
    { -1664, 688, -40},
    { -1144, 520, -120},
    { -1240, 360, -88},
    { -1568, 264, 24},
    { -1648, 336, 64},
    { -1392, 400, 16},
    { -1272, 272, 72},
    { -1232, 264, 152},
    { -1144, 216, 104},
    { -1000, 248, 56},
    { -848, 168, 208},
    { -808, 32, 176},
    { -824, 240, -16},
    { -520, -536, -328},
    // 26 seconds
    { -1144, -16, -8},
    { -1520, 376, -328},
    { -1688, 336, -536},
    { -1912, 32, 120},
    { -1568, 304, 160},
    { -1208, 632, -80},
    { -1008, 504, -24},
    { -992, 368, 80},
    { -984, 288, 128},
    { -896, 336, 32},
    { -792, 392, 16},
    { -1112, 448, 120},
    { -1120, 992, 368},
    { -1320, 376, 192},
    { -1320, 608, 0},
    { -936, 600, -208},
    { -1240, 616, 8},
    { -1496, 496, 120},
    { -1320, 312, 40},
    { -1152, 336, 72},
    { -1144, 288, 104},
    { -1264, 176, 136},
    { -1168, 136, 96},
    { -1136, 144, 96},
    { -1288, -104, 232},
    // 27 seconds
    { -1136, -368, 224},
    { -944, -296, 0},
    { -1312, -56, -240},
    { -1360, 136, -216},
    { -1384, 64, -168},
    { -1432, -32, -56},
    { -1352, 8, -16},
    { -1216, 128, -8},
    { -1072, 216, 96},
    { -1032, 296, 24},
    { -1128, 408, -128},
    { -1080, 384, -112},
    { -1032, 584, -88},
    { -1160, 984, -176},
    { -1152, 160, -328},
    { -1504, 520, -224},
    { -1304, 448, -80},
    { -1360, 376, -80},
    { -1528, 248, 56},
    { -1560, 240, 96},
    { -1368, 304, 88},
    { -1232, 192, 128},
    { -1192, 128, 152},
    { -1184, 104, 160},
    { -1088, 96, 152},
    // 28 seconds
    { -1064, 104, 104},
    { -968, 0, 64},
    { -800, -40, -128},
    { -1176, -48, -40},
    { -1216, 24, -280},
    { -1080, -8, -360},
    { -1264, -112, -184},
    { -1336, -168, 40},
    { -1232, 40, 8},
    { -1112, 232, 72},
    { -1096, 376, 120},
    { -1176, 416, 80},
    { -1248, 416, -40},
    { -1184, 424, -32},
    { -1240, 752, -48},
    { -1160, 336, -16},
    { -1536, 496, -96},
    { -1360, 512, -128},
    { -1056, 432, -368},
    { -1224, 384, -352},
    { -1368, 272, -224},
    { -1272, 176, -248},
    { -1184, 184, -208},
    { -1240, 232, -128},
    { -1272, 152, -24},
    // 29 seconds
    { -1184, 160, -16},
    { -1104, 144, -24},
    { -1120, 152, 24},
    { -1016, -40, -24},
    { -1016, -120, -8},
    { -1000, 24, -112},
    { -928, -56, -192},
    { -1256, 72, -360},
    { -1520, 0, -328},
    { -1448, -40, -184},
    { -1280, 144, -192},
    { -1152, 296, -160},
    { -1080, 232, -32},
    { -1152, 280, -104},
    { -1120, 280, -64},
    { -936, 320, -96},
    { -1024, 608, -192},
    { -1072, 528, -160},
    { -1736, 448, -136},
    { -1248, 424, -176},
    { -1104, 288, -320},
    { -1336, 144, -208},
    { -1504, 112, -168},
    { -1320, 88, -200},
    { -1168, 56, -160},
    // 30 seconds
    { -1128, 72, -96},
    { -1088, 128, -8},
    { -1048, 112, -16},
    { -1040, 72, -16},
    { -1152, -232, 128},
    { -960, -256, -40},
    { -1184, -168, -56},
    { -1200, 0, -240},
    { -1216, 96, -376},
    { -1352, 32, -320},
    { -1288, -128, -144},
    { -1240, -56, -112},
    { -1128, 104, 24},
    { -1104, 288, -16},
    { -1072, 472, -112},
    { -1088, 392, -248},
    { -992, 512, -264},
    { -1008, 600, -376},
    { -1104, 296, -232},
    { -1520, 416, -336},
    { -1536, 376, -208},
    { -1152, 400, -280},
    { -1320, 336, -192},
    { -1496, 320, -56},
    { -1536, 304, -56},
    // 31 seconds
    { -1296, 312, -48},
    { -1200, 224, 16},
    { -1200, 192, 56},
    { -1064, 176, 24},
    { -912, 264, -48},
    { -848, 200, 104},
    { -784, -56, -64},
    { -696, 560, 104},
    { -648, 936, 72},
    { -256, 1360, 40},
    { -64, 1576, 0},
    { -72, 1176, 96},
    { -32, 936, 88},
    { 56, 760, 16},
    { 88, 648, -8},
    { 104, 592, 24},
    { 136, 488, 40},
    { 168, 528, -40},
    { 184, 576, -8},
    { 192, 568, -16},
    { 144, 704, 32},
    { 168, 768, 112},
    { 176, 936, 112},
    { 56, 1560, 184},
    { 96, 1448, 536},
    // 32 seconds
    { 112, 1376, 128},
    { 192, 976, 168},
    { 128, 880, 224},
    { 32, 888, 64},
    { 16, 512, 8},
    { -64, 360, 112},
    { -144, 296, 16},
    { -208, -8, 200},
    { -584, 256, 120},
    { -1192, 760, -80},
    { -1616, 288, 200},
    { -2112, 416, 152},
    { -1832, 360, 160},
    { -1296, 552, -296},
    { -1224, 608, -128},
    { -1280, 392, 56},
    { -1016, 216, 128},
    { -792, 296, 104},
    { -744, 328, 24},
    { -744, 296, -56},
    { -840, 448, -112},
    { -904, 496, -16},
    { -1144, 520, 152},
    { -1000, 1160, 64},
    { -1496, 296, -256},
    // 33 seconds
    { -1304, 488, -152},
    { -1120, 504, -136},
    { -1376, 376, 8},
    { -1528, 240, 112},
    { -1368, 216, 96},
    { -1136, 176, 128},
    { -1104, 136, 160},
    { -1120, 88, 160},
    { -1056, 64, 136},
    { -944, 72, 120},
    { -992, 64, 128},
    { -1048, -80, 96},
    { -888, -192, 64},
    { -1152, 0, -56},
    { -1144, 200, -208},
    { -1200, 296, -336},
    { -1320, 24, -208},
    { -1424, -232, 0},
    { -1440, -56, -24},
    { -1248, 264, 96},
    { -1080, 440, 64},
    { -1104, 464, -16},
    { -1016, 392, -16},
    { -816, 328, -72},
    { -960, 384, -120},
    // 34 seconds
    { -1064, 344, 16},
    { -1528, 328, 24},
    { -1472, 424, -56},
    { -960, 384, -256},
    { -1336, 392, -208},
    { -1672, 200, -80},
    { -1416, 64, -136},
    { -1216, 224, -160},
    { -1128, 144, -120},
    { -1136, 152, -56},
    { -1096, 168, -40},
    { -1056, 152, 8},
    { -1144, 64, 184},
    { -1104, -8, 200},
    { -1080, -160, 24},
    { -1224, 0, -56},
    { -1128, 176, -352},
    { -1200, 168, -400},
    { -1240, -56, -192},
    { -1152, -216, -168},
    { -1104, 48, -248},
    { -1064, 200, -152},
    { -1136, 248, -80},
    { -1136, 288, -88},
    { -1064, 384, -128},
    // 35 seconds
    { -1160, 528, -176},
    { -1200, 432, -96},
    { -1240, 304, -256},
    { -1664, 488, -152},
    { -1192, 440, -232},
    { -1200, 408, -312},
    { -1432, 312, -152},
    { -1416, 216, -136},
    { -1192, 152, -104},
    { -1144, 120, -8},
    { -1160, 80, 80},
    { -1120, 88, 64},
    { -1024, 96, 80},
    { -968, 120, 72},
    { -1016, 56, 96},
    { -992, 48, 16},
    { -1104, 32, 48},
    { -1216, 80, -128},
    { -1048, 224, -408},
    { -1176, 16, -328},
    { -1304, -208, -280},
    { -1200, -112, -264},
    { -1032, 32, -192},
    { -1008, 40, -32},
    { -1080, 240, -56},
    // 36 seconds
    { -1224, 592, -72},
    { -1192, 504, -192},
    { -1000, 688, -224},
    { -1080, 616, -160},
    { -1064, 512, -128},
    { -1496, 616, -112},
    { -1288, 552, -176},
    { -1064, 440, -304},
    { -1304, 416, -216},
    { -1528, 424, -16},
    { -1440, 296, 0},
    { -1240, 304, 0},
    { -1192, 272, 72},
    { -1128, 232, 112},
    { -984, 168, 56},
    { -848, 224, 136},
    { -808, 256, 88},
    { -1048, 296, -384},
    { -672, -272, -112},
    { -1224, 120, 112},
    { -1560, 440, -184},
    { -1576, 536, -256},
    { -1496, 448, 120},
    { -1352, 504, 312},
    { -1288, 600, 168},
    // 37 seconds
    { -1112, 480, 232},
    { -1024, 384, 256},
    { -1032, 312, 264},
    { -1008, 288, 192},
    { -880, 352, 112},
    { -936, 440, 88},
    { -1056, 632, 248},
    { -920, 608, 48},
    { -1352, 664, 120},
    { -1136, 648, 64},
    { -1064, 608, -16},
    { -1296, 656, 80},
    { -1376, 600, 168},
    { -1256, 568, 248},
    { -1216, 408, 392},
    { -1240, 264, 456},
    { -1216, 152, 448},
    { -1120, 232, 328},
    { -1000, 120, 336},
    { -1040, 40, 360},
    { -1016, 160, 208},
    { -992, 40, 184},
    { -1144, 112, 96},
    { -1064, 424, -32},
    { -1048, 408, -64},
    // 38 seconds
    { -1272, 408, -64},
    { -1240, 208, 24},
    { -1072, 192, 8},
    { -960, 248, 72},
    { -1072, 296, 136},
    { -1192, 368, 112},
    { -1144, 384, 40},
    { -1176, 424, 72},
    { -1336, 648, 216},
    { -1136, 432, 56},
    { -1464, 784, -64},
    { -1160, 544, 32},
    { -928, 576, -80},
    { -1200, 512, 24},
    { -1456, 312, 176},
    { -1376, 232, 152},
    { -1136, 184, 144},
    { -1072, 176, 128},
    { -1104, 136, 152},
    { -1088, 136, 112},
    { -1008, 120, 88},
    { -1128, 120, -8},
    { -1144, 64, 40},
    { -1064, -40, -64},
    { -1232, -56, -120},
    // 39 seconds
    { -1152, 72, -176},
    { -1112, 144, -192},
    { -1216, 64, -72},
    { -1152, 24, -56},
    { -1000, 64, -80},
    { -912, 160, 32},
    { -976, 216, -16},
    { -1176, 304, -64},
    { -1120, 312, -96},
    { -1200, 424, -224},
    { -1312, 1200, -232},
    { -1464, 104, -168},
    { -1808, 336, -224},
    { -1128, 424, -264},
    { -1184, 336, -240},
    { -1368, 240, -16},
    { -1368, 144, 48},
    { -1160, 192, 24},
    { -1040, 152, 72},
    { -1064, 104, 144},
    { -1088, 96, 120},
    { -1056, 88, 104},
    { -1040, 104, 80},
    { -1120, 40, 24},
    { -912, -168, -88},
    // 40 seconds
    { -1120, -120, -16},
    { -1056, 160, -296},
    { -1088, 248, -488},
    { -1344, -8, -40},
    { -1312, -424, 208},
    { -1224, -56, 88},
    { -1080, 320, 48},
    { -968, 424, 32},
    { -984, 344, 32},
    { -984, 272, -16},
    { -1008, 272, -16},
    { -1312, 360, 8},
    { -1240, 568, 112},
    { -1600, 616, -128},
    { -1376, 264, -200},
    { -992, 344, -232},
    { -1144, 440, -104},
    { -1344, 344, 72},
    { -1352, 184, 80},
    { -1128, 88, 72},
    { -1040, 72, 120},
    { -1040, 64, 128},
    { -1040, 56, 128},
    { -1024, 56, 120},
    { -1184, 64, 168},
    // 41 seconds
    { -1272, -192, 208},
    { -1096, -272, 128},
    { -1208, -88, 24},
    { -1144, 120, -208},
    { -1112, 208, -216},
    { -1240, 104, -80},
    { -1176, -152, -40},
    { -1040, -112, -128},
    { -952, 88, -88},
    { -960, 128, -48},
    { -1112, 208, -128},
    { -1096, 224, -128},
    { -1096, 304, -192},
    { -1240, 576, -248},
    { -1304, 320, -216},
    { -1776, 280, -224},
    { -1256, 296, -240},
    { -1136, 296, -232},
    { -1360, 144, -104},
    { -1392, 264, -16},
    { -1304, 256, -88},
    { -1184, 216, -16},
    { -1112, 160, 8},
    { -1000, 168, 32},
    { -872, 104, 88},
    // 42 seconds
    { -800, 240, 8},
    { -888, -96, 32},
    { -824, -80, 16},
    { -1008, 24, -16},
    { -1440, 184, -128},
    { -1392, 328, -384},
    { -1392, 480, -496},
    { -1336, 136, -160},
    { -1280, 208, -64},
    { -1120, 472, -128},
    { -936, 736, -120},
    { -728, 624, -64},
    { -640, 632, -80},
    { -584, 632, -16},
    { -496, 816, 144},
    { -696, 1008, 128},
    { -712, 1032, 280},
    { -1216, 1152, 368},
    { -1184, 1120, 488},
    { -1048, 1008, 264},
    { -1072, 880, 200},
    { -952, 704, 184},
    { -768, 520, 136},
    { -600, 448, 32},
    { -464, 240, 96},
    // 43 seconds
    { -432, 384, 8},
    { -424, 536, 16},
    { -408, 648, 80},
    { -520, 736, 0},
    { -528, 632, 56},
    { -544, 584, 64},
    { -704, 664, -152},
    { -624, 520, -184},
    { -792, 328, -176},
    { -1240, 352, -224},
    { -1656, 384, 16},
    { -1632, 312, 104},
    { -1296, 200, 224},
    { -1072, 296, 168},
    { -1104, 488, 40},
    { -1056, 440, 8},
    { -912, 432, -16},
    { -1088, 512, -40},
    { -1048, 632, -8},
    { -1504, 704, 24},
    { -1288, 368, -8},
    { -1056, 344, -128},
    { -1272, 432, 16},
    { -1488, 360, 160},
    { -1424, 272, 136},
    // 44 seconds
    { -1208, 208, 168},
    { -1128, 112, 208},
    { -1144, 24, 208},
    { -1128, 64, 184},
    { -1080, 64, 208},
    { -1152, -80, 272},
    { -1128, -304, 184},
    { -928, -72, 8},
    { -1200, 64, -32},
    { -1168, 296, -352},
    { -1152, 248, -280},
    { -1368, -16, -136},
    { -1400, -232, -8},
    { -1224, 16, -56},
    { -1024, 256, 32},
    { -992, 336, 40},
    { -1064, 408, -48},
    { -1008, 344, -32},
    { -976, 296, -32},
    { -1208, 400, 0},
    { -1160, 696, 8},
    { -1488, 184, -24},
    { -1272, 184, -48},
    { -1048, 296, -64},
    { -1240, 440, -24},
    // 45 seconds
    { -1416, 352, 80},
    { -1344, 232, 72},
    { -1184, 160, 112},
    { -1144, 96, 136},
    { -1192, 24, 152},
    { -1136, 24, 120},
    { -1016, 8, 104},
    { -992, 56, 128},
    { -1064, 24, 168},
    { -928, -96, 128},
    { -1208, 88, 112},
    { -1136, 416, -520},
    { -1104, 288, -272},
    { -1232, -136, -8},
    { -1296, -144, 0},
    { -1136, 160, -80},
    { -976, 296, 8},
    { -944, 304, 24},
    { -1064, 280, 0},
    { -1056, 264, -56},
    { -1040, 264, -136},
    { -1264, 376, -136},
    { -1264, 744, -152},
    { -1648, 112, -184},
    { -1256, 192, -232},
    // 46 seconds
    { -1072, 344, -216},
    { -1272, 400, -88},
    { -1392, 256, 32},
    { -1264, 120, 16},
    { -1088, 96, 32},
    { -1056, 96, 80},
    { -1072, 64, 112},
    { -1056, 40, 104},
    { -1008, 48, 104},
    { -1104, 32, 128},
    { -984, -216, 136},
    { -1008, -168, 72},
    { -1360, 120, 8},
    { -1128, 192, -376},
    { -1280, 232, -360},
    { -1384, -96, 16},
    { -1336, -200, -24},
    { -1184, 264, -120},
    { -968, 368, -88},
    { -912, 216, -72},
    { -952, 384, -48},
    { -928, 328, -24},
    { -904, 392, -64},
    { -1016, 376, -56},
    { -1024, 432, 0},
    // 47 seconds
    { -1608, 584, -104},
    { -1456, 328, -128},
    { -1080, 336, -216},
    { -1168, 384, -208},
    { -1296, 224, -64},
    { -1360, 256, -56},
    { -1336, 304, 16},
    { -1208, 176, 104},
    { -1104, 216, 144},
    { -1000, 232, 160},
    { -880, 232, 144},
    { -792, 216, 160},
    { -1008, 400, 16},
    { -848, 24, -40},
    { -952, -112, 200},
    { -1240, 248, 88},
    { -1360, 608, -184},
    { -1552, 792, -88},
    { -1344, 192, 80},
    { -1192, 248, 8},
    { -1040, 376, -8},
    { -880, 344, 80},
    { -896, 320, 56},
    { -992, 304, 112},
    { -960, 352, 32},
    // 48 seconds
    { -904, 360, 8},
    { -1144, 472, 48},
    { -1040, 1064, -72},
    { -1488, 424, 8},
    { -1352, 168, -8},
    { -1128, 200, -80},
    { -1344, 408, -72},
    { -1448, 344, 32},
    { -1344, 360, 24},
    { -1248, 328, 96},
    { -1224, 176, 184},
    { -1128, 0, 224},
    { -984, -40, 152},
    { -856, 24, 96},
    { -816, 0, 128},
    { -856, -88, 152},
    { -984, -16, 96},
    { -1216, 56, 88},
    { -1216, 240, -224},
    { -1248, 304, -296},
    { -1336, -32, 40},
    { -1352, -376, 184},
    { -1288, -24, 64},
    { -1096, 312, 24},
    { -968, 392, 24},
    // 49 seconds
    { -984, 312, 0},
    { -1000, 184, -56},
    { -880, 208, -120},
    { -1104, 224, -56},
    { -1344, 368, 32},
    { -1480, 872, 0},
    { -1416, -64, -48},
    { -1072, 40, -152},
    { -1232, 352, -104},
    { -1352, 352, -16},
    { -1320, 184, 8},
    { -1112, 88, 16},
    { -1008, 32, 64},
    { -1048, 48, 112},
    { -1064, 16, 120},
    { -1032, 32, 88},
    { -1048, 56, 112},
    { -1056, 24, 128},
    { -920, -96, 120},
    { -1168, -104, 128},
    { -1280, 232, -176},
    { -1080, 320, -352},
    { -1240, 152, -128},
    { -1264, -344, -16},
    { -1128, -304, -184},
    // 50 seconds
    { -1000, 80, -128},
    { -920, 208, -80},
    { -952, 280, -128},
    { -992, 296, -152},
    { -952, 264, -256},
    { -1072, 248, -248},
    { -1200, 464, -272},
    { -1280, 240, -272},
    { -1576, 280, -264},
    { -1128, 168, -216},
    { -1160, 248, -208},
    { -1328, 240, -136},
    { -1352, 216, -104},
    { -1088, 128, -80},
    { -976, 112, -56},
    { -1000, 64, -16},
    { -992, 40, -16},
    { -928, 48, -56},
    { -960, 72, -96},
    { -1064, -96, 88},
    { -1000, -136, 64},
    { -1280, -48, -32},
    { -1392, 16, -288},
    { -1272, 48, -448},
    { -1208, -160, -336},
    // 51 seconds
    { -1160, -216, -120},
    { -1136, 72, 88},
    { -944, 192, 40},
    { -752, 184, 56},
    { -792, 168, 8},
    { -888, 176, 16},
    { -872, 168, 24},
    { -1040, 264, 0},
    { -1312, 352, 72},
    { -1376, 512, -16},
    { -1456, 256, 24},
    { -1448, 192, -104},
    { -1240, 240, -224},
    { -1176, 256, -296},
    { -1184, 248, -232},
    { -1112, 128, -96},
    { -968, 88, -16},
    { -992, 88, 16},
    { -928, 80, 56},
    { -928, 88, 80},
    { -920, 96, 96},
    { -1024, 120, 200},
    { -1040, 80, 136},
    { -1080, 120, 80},
    { -1320, 120, 24},
    // 52 seconds
    { -1368, 176, -304},
    { -1080, 96, -336},
    { -1120, -160, -256},
    { -1216, -88, -184},
    { -1064, 24, -120},
    { -872, 128, -48},
    { -840, 256, -8},
    { -896, 256, -8},
    { -912, 264, -24},
    { -808, 280, -40},
    { -1000, 320, -64},
    { -1152, 336, 32},
    { -1424, 568, -72},
    { -1632, 368, -48},
    { -1152, 328, -208},
    { -1128, 328, -272},
    { -1232, 216, -176},
    { -1232, 376, -144},
    { -1072, 456, -40},
    { -992, 424, 104},
    { -1008, 368, 176},
    { -968, 328, 320},
    { -936, 168, 440},
    { -912, 120, 160},
    { -904, 80, -32},
    // 53 seconds
    { -904, 80, -88},
    { -1272, 424, 176},
    { -1240, 1888, 80},
    { -720, 1712, -104},
    { -552, 1328, -32},
    { -376, 928, 24},
    { -136, 728, -8},
    { -32, 568, 16},
    { 40, 456, 24},
    { 40, 520, -8},
    { 96, 512, 8},
    { 136, 672, -72},
    { 128, 752, 0},
    { 72, 1000, 16},
    { 136, 1264, 40},
    { 192, 1424, -32},
    { 240, 1152, -120},
    { 256, 896, -160},
    { 224, 752, -104},
    { 192, 600, -72},
    { 80, 400, -120},
    { -64, 328, -112},
    { -160, 256, -48},
    { -280, 152, 8},
    { -512, 176, 24},
    // 54 seconds
    { -800, 200, 56},
    { -1360, 208, 200},
    { -1904, 400, 40},
    { -2208, 328, 328},
    { -2224, 200, -256},
    { -1512, 288, -624},
    { -1336, 64, -328},
    { -1224, -8, -112},
    { -1064, 160, -64},
    { -784, 208, 24},
    { -696, 224, 32},
    { -672, 232, 48},
    { -728, 256, 48},
    { -632, 216, -8},
    { -792, 256, 24},
    { -1152, 352, 0},
    { -1720, 368, 192},
    { -1528, 408, -88},
    { -1024, 32, -256},
    { -1256, 320, -320},
    { -1440, 280, -224},
    { -1216, 120, -216},
    { -1000, 64, -104},
    { -864, -16, -64},
    { -848, -8, -48},
    // 55 seconds
    { -840, 64, -8},
    { -848, 72, 32},
    { -944, 56, 80},
    { -1064, 8, 144},
    { -1288, 16, 248},
    { -1432, 40, 248},
    { -1256, 288, -144},
    { -992, 352, -288},
    { -1032, 80, -176},
    { -1200, -72, -120},
    { -1112, 8, -72},
    { -944, 128, -56},
    { -928, 216, 8},
    { -992, 288, 32},
    { -1008, 296, -24},
    { -840, 272, -40},
    { -864, 264, -48},
    { -1120, 320, 0},
    { -1208, 344, 80},
    { -1584, 240, -40},
    { -1104, 232, -88},
    { -1040, 304, -136},
    { -1384, 288, -200},
    { -1472, 144, -216},
    { -1240, 56, -256},
    // 56 seconds
    { -1128, 0, -152},
    { -1048, 24, -128},
    { -864, 16, -64},
    { -760, 56, -56},
    { -776, 64, -64},
    { -808, 32, 16},
    { -904, 0, 128},
    { -904, 32, 144},
    { -1344, 64, 280},
    { -1560, 264, 80},
    { -1448, 656, -552},
    { -1288, 416, -112},
    { -1272, -24, -120},
    { -1064, -8, -48},
    { -872, 160, -72},
    { -800, 208, -56},
    { -744, 184, -16},
    { -680, 208, -24},
    { -624, 368, -96},
    { -832, 472, -64},
    { -1088, 432, 48},
    { -1472, 376, 216},
    { -1704, 656, 80},
    { -1256, 264, -24},
    { -1280, 288, -96},
    // 57 seconds
    { -1464, 360, -72},
    { -1392, 152, -176},
    { -1224, 64, 0},
    { -1112, 104, -128},
    { -968, 72, -24},
    { -760, 0, -80},
    { -648, 80, -88},
    { -560, 128, -104},
    { -584, 136, -40},
    { -752, 320, -40},
    { -840, 624, -128},
    { -1200, 760, -64},
    { -1272, 1152, -176},
    { -1032, 1152, -216},
    { -896, 776, -136},
    { -808, 616, -40},
    { -752, 512, 16},
    { -616, 360, 104},
    { -488, 328, 144},
    { -408, 408, 168},
    { -392, 480, 144},
    { -344, 624, 208},
    { -368, 792, 184},
    { -376, 832, 120},
    { -504, 1328, 488},
    // 58 seconds
    { -456, 1680, 176},
    { -472, 1608, 104},
    { -424, 1272, 80},
    { -528, 1040, -88},
    { -480, 880, 56},
    { -400, 896, 40},
    { -280, 680, 72},
    { -232, 648, 40},
    { -224, 560, 96},
    { -192, 528, 136},
    { -176, 592, 96},
    { -112, 584, 168},
    { -72, 704, 224},
    { 8, 976, 248},
    { 56, 1240, 320},
    { 120, 1288, 176},
    { 88, 1168, -24},
    { 104, 1096, -40},
    { 56, 744, 8},
    { 16, 784, 16},
    { 48, 728, 56},
    { 136, 784, -8},
    { 136, 712, 256},
    { 184, 768, 152},
    { 192, 832, 168},
    // 59 seconds
    { 184, 856, 184},
    { 168, 896, 184},
    { 208, 960, 144},
    { 152, 1016, 144},
    { 80, 1072, 104},
    { 64, 880, 72},
    { 64, 744, 192},
    { 72, 784, 272},
    { 88, 800, 296},
    { 120, 904, 392},
    { 80, 976, 464},
    { 48, 936, 368},
    { 72, 824, 352},
    { 80, 832, 328},
    { 80, 784, 224},
    { 72, 848, 360},
    { 120, 976, 336},
    { 136, 896, 320},
    { 128, 808, 144},
    { 112, 752, 176},
    { 184, 800, 152},
    { 208, 936, 0},
    { 208, 1160, -72},
    { 240, 1056, -96},
    { 160, 1176, -232},
    // 60 seconds
    // elapsed: 1 minutes
    { 272, 1000, -224},
    { 152, 904, -432},
    { 88, 536, -560},
    { -80, 64, -656},
    { -176, -8, -880},
    { -200, -96, -840},
    { -248, -296, -792},
    { -240, -536, -856},
    { -272, -296, -904},
    { -192, -456, -848},
    { -200, -416, -880},
    { -208, -368, -904},
    { -232, -384, -920},
    { -240, -392, -936},
    { -232, -392, -952},
    { -224, -400, -936},
    { -224, -408, -936},
    { -224, -384, -944},
    { -208, -368, -928},
    { -200, -376, -920},
    { -184, -312, -944},
    { -200, -344, -960},
    { -192, -312, -984},
    { -184, -368, -960},
    { -184, -360, -968},
    // 61 seconds
    { -192, -296, -1000},
    { -168, -264, -984},
    { -176, -256, -1016},
    { -160, -328, -984},
    { -144, -152, -968},
    { -56, -240, -936},
    { -32, -328, -768},
    { -72, -112, -816},
    { -200, 40, -792},
    { -152, 512, -936},
    { -120, 656, -840},
    { -112, 800, -856},
    { -56, 712, -792},
    { -88, 632, -704},
    { -112, 744, -632},
    { -64, 832, -480},
    { 40, 904, -408},
    { 136, 840, -456},
    { 120, 752, -360},
    { 64, 920, -288},
    { 112, 872, -288},
    { 56, 840, -296},
    { -16, 1016, -200},
    { 16, 768, -272},
    { 104, 696, -520},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

