/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 15:41:01 local
AccelRawData *activity_sample_walk_100_pbl_25672_1(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25672_1
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -80, -720, -648},
    { -112, -696, -640},
    { -96, -712, -632},
    { -88, -712, -648},
    { -104, -688, -632},
    { -96, -656, -632},
    { -48, -728, -600},
    { -56, -792, -632},
    { -64, -720, -600},
    { -88, -744, -640},
    { -56, -784, -624},
    { -104, -688, -616},
    { -144, -696, -640},
    { -136, -688, -688},
    { -104, -632, -664},
    { -112, -640, -728},
    { -144, -744, -648},
    { -208, -648, -728},
    { -176, -656, -672},
    { -184, -704, -704},
    { -144, -640, -680},
    { -136, -640, -744},
    { -64, -496, -760},
    { -16, -488, -768},
    { 152, -448, -832},
    // 1 seconds
    { 144, -448, -816},
    { 168, -456, -856},
    { 120, -464, -856},
    { 144, -488, -824},
    { 104, -440, -808},
    { 112, -520, -784},
    { 120, -432, -776},
    { 120, -440, -824},
    { 112, -480, -840},
    { 112, -296, -888},
    { 112, -384, -816},
    { 152, -328, -968},
    { 144, -312, -904},
    { 184, -328, -896},
    { 152, -320, -832},
    { 168, -328, -856},
    { 160, -312, -896},
    { 144, -392, -888},
    { 136, -360, -920},
    { 112, -384, -848},
    { 104, -416, -864},
    { 120, -368, -872},
    { 96, -448, -824},
    { 136, -376, -848},
    { 112, -440, -840},
    // 2 seconds
    { 120, -400, -864},
    { 112, -320, -856},
    { 96, -360, -896},
    { 72, -376, -744},
    { 112, -248, -888},
    { 64, -296, -760},
    { 56, -64, -752},
    { 120, 272, -808},
    { 296, 456, -712},
    { 384, 600, -664},
    { 448, 616, -632},
    { 424, 688, -584},
    { 456, 800, -592},
    { 432, 800, -488},
    { 448, 944, -512},
    { 416, 712, -368},
    { 440, 808, -416},
    { 424, 800, -464},
    { 424, 832, -480},
    { 400, 760, -528},
    { 392, 696, -536},
    { 376, 672, -672},
    { 440, 784, -896},
    { 368, 312, -648},
    { 376, 96, -752},
    // 3 seconds
    { 328, -192, -744},
    { 344, -200, -792},
    { 328, -224, -832},
    { 280, -328, -808},
    { 168, -328, -864},
    { 104, -416, -824},
    { 56, -344, -872},
    { 48, -376, -856},
    { 56, -416, -864},
    { 64, -384, -856},
    { 88, -360, -888},
    { 120, -352, -856},
    { 120, -328, -888},
    { 144, -352, -880},
    { 152, -328, -888},
    { 112, -328, -856},
    { 96, -344, -880},
    { 96, -336, -888},
    { 96, -336, -872},
    { 120, -296, -880},
    { 120, -272, -920},
    { 128, -280, -904},
    { 144, -264, -912},
    { 152, -256, -920},
    { 160, -248, -952},
    // 4 seconds
    { 112, -296, -920},
    { 56, -280, -904},
    { -8, -296, -808},
    { 0, -176, -824},
    { 64, -112, -720},
    { 80, 152, -672},
    { 160, 568, -800},
    { 120, 504, -472},
    { 224, 1040, -744},
    { 232, 832, -488},
    { 288, 952, -608},
    { 264, 840, -520},
    { 288, 704, -536},
    { 280, 864, -728},
    { 272, 656, -656},
    { 264, 624, -704},
    { 272, 592, -736},
    { 304, 512, -704},
    { 352, 528, -752},
    { 360, 376, -712},
    { 400, 520, -864},
    { 376, 232, -720},
    { 408, 384, -992},
    { 352, -8, -760},
    { 352, 56, -856},
    // 5 seconds
    { 200, 160, -848},
    { 312, -56, -1000},
    { 288, -72, -872},
    { 184, 72, -1032},
    { 160, 32, -968},
    { 248, 40, -1048},
    { 264, -32, -864},
    { 304, 64, -840},
    { 256, 104, -824},
    { 240, 96, -848},
    { 312, 96, -864},
    { 352, 48, -840},
    { 360, 40, -800},
    { 392, 48, -792},
    { 392, 72, -800},
    { 416, 104, -840},
    { 424, 56, -832},
    { 432, 112, -904},
    { 432, 40, -832},
    { 472, 8, -776},
    { 488, -56, -816},
    { 416, 80, -864},
    { 352, 136, -904},
    { 328, 232, -936},
    { 328, 88, -880},
    // 6 seconds
    { 264, 256, -880},
    { 336, 224, -896},
    { 336, 208, -904},
    { 288, 232, -896},
    { 272, 152, -856},
    { 272, 120, -864},
    { 312, 136, -936},
    { 296, 24, -872},
    { 328, 24, -872},
    { 312, -16, -800},
    { 288, 8, -856},
    { 240, -32, -848},
    { 200, -16, -864},
    { 224, 0, -896},
    { 232, -24, -864},
    { 168, 128, -1008},
    { 312, 32, -904},
    { 240, 208, -1136},
    { 328, 136, -952},
    { 312, 168, -936},
    { 256, 168, -888},
    { 296, 152, -792},
    { 344, 192, -752},
    { 312, 216, -808},
    { 336, 240, -856},
    // 7 seconds
    { 408, 168, -840},
    { 408, 208, -880},
    { 392, 144, -808},
    { 384, 168, -800},
    { 408, 208, -848},
    { 416, 144, -768},
    { 464, 192, -824},
    { 496, 192, -832},
    { 432, 48, -672},
    { 344, 408, -896},
    { 416, 176, -792},
    { 384, 656, -1040},
    { 296, 456, -872},
    { 312, 592, -1048},
    { 216, 352, -672},
    { 240, 440, -688},
    { 208, 464, -672},
    { 248, 448, -688},
    { 288, 600, -800},
    { 352, 424, -720},
    { 376, 400, -704},
    { 336, 512, -744},
    { 312, 392, -656},
    { 304, 456, -720},
    { 296, 432, -720},
    // 8 seconds
    { 296, 368, -704},
    { 288, 328, -680},
    { 392, 368, -744},
    { 256, 288, -712},
    { 304, 400, -736},
    { 352, 504, -768},
    { 344, 752, -816},
    { 376, 744, -848},
    { 440, 624, -736},
    { 392, 600, -784},
    { 336, 448, -624},
    { 352, 560, -632},
    { 328, 584, -624},
    { 328, 584, -608},
    { 344, 568, -656},
    { 368, 520, -664},
    { 384, 496, -664},
    { 392, 440, -624},
    { 416, 488, -632},
    { 448, 488, -632},
    { 480, 488, -640},
    { 480, 448, -624},
    { 592, 408, -728},
    { 400, 576, -720},
    { 392, 544, -736},
    // 9 seconds
    { 416, 696, -744},
    { 344, 840, -1016},
    { 264, 496, -896},
    { 248, 328, -728},
    { 280, 384, -608},
    { 248, 472, -704},
    { 232, 496, -800},
    { 272, 472, -824},
    { 320, 400, -848},
    { 328, 272, -752},
    { 304, 256, -768},
    { 296, 296, -784},
    { 304, 296, -784},
    { 296, 256, -752},
    { 280, 216, -736},
    { 288, 208, -744},
    { 304, 104, -696},
    { 336, 152, -808},
    { 296, 304, -912},
    { 408, 352, -816},
    { 368, 632, -1040},
    { 424, 376, -832},
    { 408, 520, -992},
    { 312, 352, -768},
    { 296, 392, -704},
    // 10 seconds
    { 304, 464, -696},
    { 328, 416, -680},
    { 344, 440, -736},
    { 400, 384, -712},
    { 400, 352, -728},
    { 408, 320, -736},
    { 440, 320, -760},
    { 472, 312, -768},
    { 504, 328, -776},
    { 488, 360, -816},
    { 496, 312, -760},
    { 368, 384, -848},
    { 352, 416, -728},
    { 328, 480, -752},
    { 256, 640, -920},
    { 152, 496, -872},
    { 224, 288, -720},
    { 216, 440, -736},
    { 192, 344, -680},
    { 224, 448, -800},
    { 248, 424, -808},
    { 248, 312, -736},
    { 272, 344, -792},
    { 304, 280, -768},
    { 280, 320, -760},
    // 11 seconds
    { 328, 376, -808},
    { 344, 320, -776},
    { 360, 344, -784},
    { 456, 240, -880},
    { 392, 504, -880},
    { 392, 488, -864},
    { 480, 544, -736},
    { 408, 840, -936},
    { 352, 448, -632},
    { 352, 544, -720},
    { 344, 416, -568},
    { 304, 504, -624},
    { 304, 536, -616},
    { 328, 600, -648},
    { 360, 512, -616},
    { 440, 520, -672},
    { 472, 424, -616},
    { 488, 440, -640},
    { 488, 440, -632},
    { 520, 440, -648},
    { 584, 432, -672},
    { 576, 400, -624},
    { 536, 464, -672},
    { 480, 520, -704},
    { 488, 568, -672},
    // 12 seconds
    { 280, 840, -912},
    { 272, 640, -824},
    { 288, 400, -720},
    { 368, 384, -608},
    { 360, 480, -592},
    { 296, 680, -776},
    { 328, 504, -704},
    { 368, 448, -720},
    { 376, 392, -680},
    { 352, 320, -640},
    { 368, 416, -712},
    { 376, 384, -672},
    { 400, 400, -704},
    { 408, 392, -680},
    { 416, 336, -616},
    { 408, 592, -832},
    { 480, 384, -472},
    { 328, 1272, -1120},
    { 416, 472, -600},
    { 528, 704, -824},
    { 384, 576, -608},
    { 368, 616, -568},
    { 344, 632, -560},
    { 360, 632, -560},
    { 392, 592, -544},
    // 13 seconds
    { 416, 496, -528},
    { 480, 472, -552},
    { 480, 448, -552},
    { 520, 480, -592},
    { 544, 448, -616},
    { 584, 424, -616},
    { 592, 424, -632},
    { 640, 312, -448},
    { 584, 560, -648},
    { 592, 600, -560},
    { 392, 1024, -928},
    { 368, 528, -696},
    { 440, 504, -608},
    { 456, 472, -504},
    { 416, 488, -512},
    { 304, 696, -712},
    { 352, 576, -648},
    { 400, 456, -632},
    { 432, 400, -632},
    { 416, 344, -576},
    { 408, 440, -672},
    { 384, 440, -672},
    { 376, 416, -672},
    { 392, 432, -712},
    { 408, 512, -712},
    // 14 seconds
    { 352, 592, -760},
    { 600, 400, -688},
    { 496, 1176, -920},
    { 368, 616, -432},
    { 432, 896, -760},
    { 488, 496, -536},
    { 384, 528, -496},
    { 368, 640, -584},
    { 392, 560, -512},
    { 440, 608, -560},
    { 448, 536, -560},
    { 464, 496, -568},
    { 472, 456, -584},
    { 480, 440, -608},
    { 544, 352, -608},
    { 592, 288, -504},
    { 424, 288, -640},
    { 464, 448, -656},
    { 520, 656, -712},
    { 296, 1096, -840},
    { 408, 664, -816},
    { 336, 560, -752},
    { 416, 240, -448},
    { 448, 568, -616},
    { 408, 544, -760},
    // 15 seconds
    { 456, 400, -728},
    { 464, 608, -896},
    { 336, 136, -472},
    { 360, 216, -528},
    { 336, 184, -344},
    { 280, 560, -400},
    { 328, 912, -376},
    { 408, 1088, -128},
    { 400, 1088, -216},
    { 520, 984, 304},
    { 328, 1440, 96},
    { 368, 1208, 232},
    { 480, 1128, 16},
    { 464, 792, 48},
    { 336, 696, 136},
    { 288, 840, 192},
    { 264, 800, 256},
    { 352, 904, 64},
    { 360, 800, 80},
    { 424, 776, -40},
    { 440, 768, -48},
    { 464, 800, -16},
    { 480, 912, -32},
    { 440, 1080, 112},
    { 376, 1144, 88},
    // 16 seconds
    { 376, 1112, 136},
    { 144, 1216, 264},
    { 360, 1496, -280},
    { 256, 736, -56},
    { 248, 688, 24},
    { 208, 768, 88},
    { 144, 904, 40},
    { 240, 992, -32},
    { 288, 920, -112},
    { 360, 736, -80},
    { 400, 792, -112},
    { 368, 768, -40},
    { 368, 856, -88},
    { 304, 1072, -200},
    { 400, 824, -240},
    { 272, 1096, -176},
    { 360, 1064, 184},
    { 136, 1448, 208},
    { 256, 1232, 288},
    { 456, 920, -24},
    { 384, 832, 72},
    { 328, 808, 160},
    { 272, 848, 144},
    { 240, 800, 216},
    { 288, 872, 160},
    // 17 seconds
    { 304, 840, 128},
    { 400, 840, 56},
    { 408, 784, 40},
    { 440, 840, 16},
    { 424, 888, 40},
    { 320, 1208, 112},
    { 336, 1320, 72},
    { 88, 1184, 312},
    { 296, 1368, -152},
    { 216, 712, 40},
    { 256, 736, 0},
    { 160, 784, 128},
    { 144, 976, 16},
    { 264, 952, -32},
    { 328, 832, -104},
    { 352, 784, -64},
    { 352, 752, -16},
    { 360, 840, -48},
    { 384, 800, -64},
    { 424, 736, -40},
    { 312, 1032, -136},
    { 400, 1152, 224},
    { 40, 1456, 392},
    { 216, 1296, 160},
    { 472, 1008, -16},
    // 18 seconds
    { 320, 872, 56},
    { 320, 800, 200},
    { 184, 848, 264},
    { 184, 832, 320},
    { 280, 976, 152},
    { 304, 792, 128},
    { 376, 816, 112},
    { 392, 800, 80},
    { 416, 832, 80},
    { 416, 864, 24},
    { 368, 824, 112},
    { 312, 1096, -40},
    { 352, 1152, -56},
    { 224, 1232, 472},
    { 224, 1088, 64},
    { 328, 976, -144},
    { 272, 560, 48},
    { 256, 840, 112},
    { 104, 952, 56},
    { 256, 944, 16},
    { 336, 840, -56},
    { 352, 848, -40},
    { 328, 808, 0},
    { 328, 824, -48},
    { 344, 848, -8},
    // 19 seconds
    { 432, 856, 16},
    { 272, 1144, -96},
    { 280, 1400, 320},
    { 144, 1144, 376},
    { 344, 1272, 248},
    { 224, 1000, 248},
    { 336, 824, 40},
    { 272, 824, 168},
    { 216, 840, 240},
    { 224, 872, 248},
    { 256, 864, 192},
    { 304, 832, 144},
    { 376, 792, 96},
    { 408, 816, 24},
    { 416, 840, 48},
    { 424, 856, 128},
    { 272, 1232, -16},
    { 240, 1144, -72},
    { 112, 1320, 520},
    { 128, 1312, 240},
    { 240, 824, -88},
    { 256, 520, 120},
    { 312, 800, 112},
    { 128, 968, 144},
    { 248, 1008, 88},
    // 20 seconds
    { 320, 880, 16},
    { 336, 816, -16},
    { 320, 808, 32},
    { 320, 792, 8},
    { 336, 568, 16},
    { 416, 800, 120},
    { 296, 1096, 96},
    { 320, 1024, 192},
    { 136, 1592, 360},
    { 264, 1216, 320},
    { 432, 960, 136},
    { 376, 752, 224},
    { 344, 848, 200},
    { 248, 736, 248},
    { 272, 784, 232},
    { 336, 840, 232},
    { 312, 856, 192},
    { 360, 856, 200},
    { 376, 816, 152},
    { 384, 840, 176},
    { 296, 1112, -64},
    { 184, 1040, 128},
    { 216, 1056, 240},
    { -16, 1400, 392},
    { 248, 1288, -88},
    // 21 seconds
    { 240, 640, 8},
    { 224, 704, 72},
    { 136, 904, 128},
    { 88, 1016, 168},
    { 216, 1040, 16},
    { 272, 816, 16},
    { 312, 808, 32},
    { 312, 800, 40},
    { 344, 600, 112},
    { 392, 648, -16},
    { 360, 904, 24},
    { 232, 1024, 248},
    { 368, 1200, 376},
    { -16, 1536, 528},
    { 128, 1176, 368},
    { 368, 920, 160},
    { 296, 848, 200},
    { 184, 848, 288},
    { 152, 808, 304},
    { 248, 832, 320},
    { 232, 816, 320},
    { 256, 864, 272},
    { 296, 824, 256},
    { 312, 816, 224},
    { 344, 840, 184},
    // 22 seconds
    { 344, 856, 176},
    { 304, 976, 216},
    { 248, 1104, 160},
    { 280, 1520, 384},
    { -16, 1280, 336},
    { 264, 1096, 0},
    { 304, 560, 64},
    { 336, 784, 192},
    { 176, 936, 112},
    { 120, 928, 224},
    { 272, 944, 56},
    { 304, 768, 72},
    { 344, 816, 96},
    { 376, 728, -80},
    { 336, 648, -144},
    { 384, 888, 40},
    { 280, 1008, 88},
    { 344, 1104, 168},
    { 312, 1072, 216},
    { 400, 1304, 464},
    { 24, 1328, 424},
    { 176, 1232, 224},
    { 320, 816, 168},
    { 320, 752, 208},
    { 224, 824, 232},
    // 23 seconds
    { 176, 792, 320},
    { 224, 864, 336},
    { 224, 856, 272},
    { 312, 800, 224},
    { 376, 776, 168},
    { 376, 784, 144},
    { 288, 912, 184},
    { 256, 696, -56},
    { 352, 1096, 40},
    { 168, 1408, 520},
    { 88, 1248, 256},
    { 288, 768, -112},
    { 368, 560, 64},
    { 296, 776, 144},
    { 136, 888, 200},
    { 160, 1024, 80},
    { 240, 864, 80},
    { 296, 808, -8},
    { 312, 808, 32},
    { 304, 1016, 24},
    { 288, 824, -96},
    { 288, 984, -24},
    { 280, 960, 72},
    { 216, 1048, 136},
    { 160, 1640, 384},
    // 24 seconds
    { 184, 1136, 488},
    { 392, 1008, 120},
    { 392, 784, 176},
    { 368, 672, 216},
    { 264, 808, 256},
    { 280, 824, 296},
    { 272, 936, 304},
    { 304, 936, 192},
    { 384, 808, 192},
    { 416, 800, 80},
    { 416, 752, 112},
    { 440, 776, -216},
    { 392, 992, 56},
    { 280, 992, 208},
    { 416, 1144, 248},
    { 104, 1344, 440},
    { 272, 1176, -24},
    { 376, 576, 24},
    { 312, 592, 152},
    { 224, 784, 208},
    { 128, 1008, 144},
    { 320, 960, 72},
    { 336, 824, 32},
    { 336, 776, 56},
    { 320, 928, 0},
    // 25 seconds
    { 320, 632, 24},
    { 344, 1024, 16},
    { 336, 888, 32},
    { 232, 1184, 128},
    { 304, 1248, 464},
    { -32, 1520, 456},
    { 256, 1120, 288},
    { 424, 856, 216},
    { 360, 752, 248},
    { 248, 808, 296},
    { 176, 808, 312},
    { 192, 848, 288},
    { 224, 888, 248},
    { 248, 840, 216},
    { 336, 800, 152},
    { 312, 872, 160},
    { 256, 976, 192},
    { 144, 1112, 192},
    { 160, 1184, 272},
    { -112, 1440, 472},
    { -40, 1248, 112},
    { 192, 760, 24},
    { 160, 656, 176},
    { 152, 808, 184},
    { 152, 896, 160},
    // 26 seconds
    { 160, 840, 80},
    { 144, 840, 8},
    { 176, 784, 56},
    { 232, 824, 40},
    { 296, 920, 40},
    { 336, 928, 40},
    { 360, 1016, 104},
    { 288, 1112, 200},
    { 344, 1208, 448},
    { 40, 1552, 416},
    { 120, 952, 400},
    { 224, 1136, 48},
    { 232, 688, 272},
    { 224, 840, 240},
    { 192, 808, 272},
    { 256, 912, 344},
    { 224, 960, 312},
    { 288, 800, 232},
    { 256, 768, 168},
    { 240, 720, -104},
    { 160, 1032, 120},
    { 72, 840, 320},
    { 200, 1160, 152},
    { -72, 1256, 656},
    { 248, 1272, -112},
    // 27 seconds
    { 272, 704, -24},
    { 200, 632, 120},
    { 176, 872, 128},
    { 128, 928, 168},
    { 184, 984, 72},
    { 200, 816, -8},
    { 240, 776, -40},
    { 224, 768, 0},
    { 288, 856, 64},
    { 288, 920, -64},
    { 336, 1024, 16},
    { 304, 1056, 160},
    { 328, 1120, 104},
    { 328, 1152, 328},
    { 216, 1152, 408},
    { 184, 1120, 256},
    { 256, 992, 320},
    { 160, 952, 296},
    { 144, 848, 256},
    { 192, 856, 240},
    { 184, 856, 280},
    { 192, 856, 232},
    { 264, 800, 224},
    { 296, 840, 176},
    { 240, 904, 256},
    // 28 seconds
    { 152, 1168, 264},
    { 168, 1144, 208},
    { 176, 1208, 328},
    { -80, 960, 216},
    { 272, 936, -128},
    { 248, 544, 152},
    { 168, 864, 176},
    { 80, 1056, 168},
    { 168, 944, 136},
    { 176, 992, 0},
    { 184, 576, 8},
    { 184, 696, 0},
    { 160, 920, 24},
    { 192, 912, 160},
    { 248, 1088, 112},
    { 256, 1096, 248},
    { 184, 1304, 392},
    { -32, 1392, 368},
    { 136, 1120, 280},
    { 136, 960, 288},
    { 120, 944, 296},
    { 144, 840, 296},
    { 136, 792, 280},
    { 152, 768, 224},
    { 136, 816, 280},
    // 29 seconds
    { 184, 856, 232},
    { 224, 848, 256},
    { 248, 888, 312},
    { 184, 1208, 144},
    { 48, 1176, 232},
    { 80, 1104, 344},
    { -40, 1224, 392},
    { 56, 1056, 128},
    { 80, 784, 208},
    { 72, 912, 160},
    { 104, 848, 120},
    { 168, 744, 88},
    { 168, 728, 112},
    { 160, 896, 104},
    { 120, 816, 184},
    { 168, 1016, 64},
    { 152, 1008, 224},
    { 192, 1080, 224},
    { 128, 1144, 192},
    { 144, 1280, 344},
    { 0, 1192, 352},
    { 72, 1128, 384},
    { 24, 952, 368},
    { 40, 872, 248},
    { 48, 736, 296},
    // 30 seconds
    { 128, 744, 264},
    { 168, 808, 296},
    { 224, 848, 240},
    { 248, 888, 224},
    { 208, 960, 248},
    { 136, 1112, 280},
    { 128, 1136, 256},
    { 200, 1176, 264},
    { 72, 1168, 368},
    { 168, 1040, 168},
    { 208, 928, 104},
    { 120, 944, 224},
    { 96, 872, 128},
    { 168, 768, 56},
    { 120, 736, 144},
    { 160, 760, 0},
    { 112, 824, 96},
    { 184, 840, 56},
    { 168, 816, 136},
    { 184, 904, 80},
    { 32, 1248, 296},
    { 40, 1512, 464},
    { -48, 1304, 360},
    { 96, 1064, 272},
    { 72, 928, 280},
    // 31 seconds
    { 96, 872, 264},
    { 72, 792, 328},
    { 120, 752, 280},
    { 144, 784, 296},
    { 152, 856, 288},
    { 200, 888, 256},
    { 296, 856, 208},
    { 240, 872, 312},
    { 176, 1096, 328},
    { 168, 1080, 344},
    { 224, 1184, 232},
    { 16, 1248, 440},
    { 128, 936, 80},
    { 152, 800, 128},
    { 112, 760, 232},
    { 112, 992, 136},
    { 160, 856, 176},
    { 168, 888, 168},
    { 184, 864, 152},
    { 168, 832, 136},
    { 144, 864, 104},
    { 136, 864, 80},
    { 136, 864, 56},
    { 160, 896, 216},
    { 184, 1008, 208},
    // 32 seconds
    { 144, 1144, 168},
    { 120, 1328, 464},
    { -160, 1400, 440},
    { 72, 1192, 280},
    { 64, 896, 296},
    { 8, 920, 352},
    { 32, 816, 288},
    { 88, 776, 248},
    { 144, 728, 304},
    { 232, 880, 224},
    { 272, 848, 240},
    { 320, 848, 344},
    { 256, 1096, 160},
    { 200, 1008, 312},
    { 112, 1104, 280},
    { 128, 1192, 256},
    { 56, 1144, 392},
    { 0, 1000, 80},
    { 24, 856, 72},
    { 8, 824, 184},
    { 80, 960, 112},
    { 160, 824, 88},
    { 192, 808, 80},
    { 200, 808, 56},
    { 160, 856, 104},
    // 33 seconds
    { 168, 880, 88},
    { 184, 856, 104},
    { 208, 968, 320},
    { 176, 1272, 176},
    { 152, 1472, 544},
    { -224, 1432, 464},
    { 96, 1264, 240},
    { 168, 872, 256},
    { 144, 896, 248},
    { 72, 752, 288},
    { 96, 696, 216},
    { 136, 704, 248},
    { 160, 840, 224},
    { 200, 816, 272},
    { 216, 840, 184},
    { 128, 720, 232},
    { 144, 1000, 96},
    { 80, 1032, 248},
    { 72, 1400, 344},
    { 32, 1144, 336},
    { 192, 1032, 8},
    { 144, 800, 232},
    { 144, 976, 160},
    { 192, 904, 176},
    { 216, 824, 144},
    // 34 seconds
    { 232, 768, 176},
    { 240, 856, 152},
    { 184, 872, 184},
    { 152, 912, 136},
    { 136, 888, 64},
    { 72, 656, 88},
    { 80, 1200, 144},
    { 16, 1016, 248},
    { 136, 1088, 120},
    { 32, 1680, 344},
    { -168, 1144, 504},
    { 8, 1240, 280},
    { -32, 768, 312},
    { 64, 656, 184},
    { 120, 608, 240},
    { 224, 680, 288},
    { 256, 872, 280},
    { 280, 920, 328},
    { 296, 960, 280},
    { 240, 920, 168},
    { 168, 808, 208},
    { 168, 1088, 136},
    { 128, 1200, 440},
    { 112, 1216, 304},
    { 152, 1152, 88},
    // 35 seconds
    { 168, 720, 192},
    { 104, 920, 96},
    { 176, 896, 152},
    { 200, 848, 96},
    { 240, 768, 112},
    { 240, 840, 112},
    { 248, 840, 112},
    { 224, 880, 40},
    { 216, 872, 40},
    { 232, 856, 56},
    { 160, 1032, 112},
    { 192, 1112, 80},
    { 272, 1064, 320},
    { -16, 1768, 264},
    { -48, 1272, 464},
    { 88, 1008, 272},
    { 128, 784, 200},
    { 208, 640, 88},
    { 304, 688, 208},
    { 256, 928, 208},
    { 272, 848, 256},
    { 232, 912, 176},
    { 248, 832, 280},
    { 248, 952, 168},
    { 192, 1032, 216},
    // 36 seconds
    { 184, 1016, 216},
    { 264, 1112, 192},
    { 56, 1072, 248},
    { 184, 1144, -40},
    { 136, 760, 112},
    { 136, 1000, 32},
    { 120, 896, 40},
    { 200, 816, -32},
    { 216, 760, -16},
    { 216, 824, 24},
    { 232, 824, 8},
    { 248, 864, 24},
    { 264, 904, 8},
    { 280, 888, 72},
    { 232, 1000, -24},
    { 176, 1048, 128},
    { 272, 1216, 352},
    { -80, 1496, 344},
    { 40, 1320, 288},
    { 104, 936, 288},
    { 88, 840, 232},
    { 96, 752, 256},
    { 160, 760, 272},
    { 200, 808, 304},
    { 200, 840, 272},
    // 37 seconds
    { 248, 888, 272},
    { 264, 904, 248},
    { 288, 896, 248},
    { 296, 976, 200},
    { 216, 992, 216},
    { 168, 1032, 144},
    { 208, 1184, 392},
    { -24, 1104, -88},
    { 0, 1224, -96},
    { 16, 752, 144},
    { 16, 968, 48},
    { 96, 880, 96},
    { 144, 800, 16},
    { 168, 776, 48},
    { 160, 832, 72},
    { 184, 824, 56},
    { 200, 872, 48},
    { 216, 880, 48},
    { 256, 904, 64},
    { 304, 960, 128},
    { 224, 1032, 136},
    { 224, 1184, 168},
    { 208, 1328, 360},
    { -40, 1232, 408},
    { 72, 1248, 296},
    // 38 seconds
    { 24, 912, 296},
    { 32, 872, 288},
    { 120, 760, 224},
    { 160, 736, 224},
    { 224, 792, 256},
    { 272, 880, 232},
    { 336, 864, 272},
    { 360, 888, 216},
    { 344, 928, 224},
    { 224, 888, 112},
    { 184, 1008, 232},
    { 192, 1208, 232},
    { 56, 1096, 280},
    { 104, 1176, 88},
    { 104, 840, 88},
    { 112, 968, 64},
    { 176, 928, 40},
    { 232, 808, 24},
    { 264, 752, 16},
    { 280, 744, 16},
    { 280, 800, 64},
    { 288, 808, 64},
    { 312, 880, 40},
    { 328, 912, 96},
    { 296, 976, 88},
    // 39 seconds
    { 320, 792, 144},
    { 384, 1128, 152},
    { 208, 1344, 272},
    { 80, 1192, 488},
    { 112, 1128, 352},
    { 152, 928, 296},
    { 144, 808, 328},
    { 192, 816, 200},
    { 192, 712, 304},
    { 232, 824, 280},
    { 264, 880, 240},
    { 296, 928, 224},
    { 320, 880, 176},
    { 328, 952, 160},
    { 248, 992, 184},
    { 224, 1064, 96},
    { 296, 1024, 288},
    { 168, 1320, 88},
    { 112, 1000, 168},
    { 168, 824, 120},
    { 200, 912, 24},
    { 208, 704, 24},
    { 288, 784, 24},
    { 248, 760, 72},
    { 280, 816, 40},
    // 40 seconds
    { 280, 848, 48},
    { 312, 880, -16},
    { 312, 816, 8},
    { 344, 928, 0},
    { 376, 1000, 88},
    { 360, 968, -48},
    { 320, 1032, 72},
    { 360, 1392, 392},
    { 104, 1152, 520},
    { 152, 1128, 192},
    { 24, 1056, 320},
    { 40, 808, 240},
    { 144, 632, 184},
    { 232, 680, 224},
    { 248, 816, 224},
    { 304, 816, 264},
    { 352, 888, 216},
    { 400, 864, 216},
    { 448, 856, 208},
    { 408, 976, 168},
    { 312, 1136, 248},
    { 288, 1024, 176},
    { 168, 1248, 432},
    { 200, 1304, 160},
    { 152, 912, 144},
    // 41 seconds
    { 168, 944, 104},
    { 184, 848, 120},
    { 232, 808, 120},
    { 256, 784, 120},
    { 288, 816, 128},
    { 288, 792, 120},
    { 280, 808, 48},
    { 296, 784, 24},
    { 256, 904, 88},
    { 304, 848, -48},
    { 288, 1096, 152},
    { 344, 1144, 296},
    { 264, 1360, 304},
    { 248, 1248, 392},
    { 312, 968, 216},
    { 208, 912, 312},
    { 168, 832, 240},
    { 208, 680, 240},
    { 256, 704, 216},
    { 272, 752, 280},
    { 368, 816, 224},
    { 368, 832, 216},
    { 432, 832, 200},
    { 464, 840, 144},
    { 504, 872, 224},
    // 42 seconds
    { 432, 976, 152},
    { 368, 1128, 224},
    { 320, 1072, 184},
    { 248, 1368, 224},
    { 144, 1232, 224},
    { 160, 1040, 72},
    { 256, 840, 8},
    { 264, 760, 88},
    { 296, 688, 136},
    { 304, 720, 80},
    { 280, 752, 120},
    { 288, 800, 72},
    { 328, 792, -24},
    { 344, 840, 8},
    { 416, 1008, -24},
    { 376, 1160, 112},
    { 344, 1144, 280},
    { 416, 1816, 320},
    { 408, 896, 456},
    { 560, 832, 240},
    { 464, 760, 208},
    { 392, 616, 280},
    { 368, 688, 224},
    { 408, 648, 208},
    { 424, 688, 240},
    // 43 seconds
    { 472, 744, 232},
    { 528, 728, 208},
    { 576, 704, 168},
    { 664, 832, 256},
    { 520, 992, 192},
    { 512, 952, 224},
    { 528, 1008, 200},
    { 544, 1232, 424},
    { 360, 1128, 176},
    { 352, 1000, 104},
    { 336, 728, 144},
    { 320, 808, 88},
    { 368, 696, 128},
    { 416, 704, 120},
    { 424, 784, 96},
    { 384, 840, 112},
    { 360, 816, 40},
    { 344, 832, 40},
    { 384, 768, 88},
    { 408, 976, 16},
    { 416, 896, 64},
    { 456, 1016, -24},
    { 472, 952, 200},
    { 288, 1656, 320},
    { 240, 984, 480},
    // 44 seconds
    { 368, 1128, 216},
    { 256, 784, 360},
    { 248, 816, 240},
    { 272, 704, 200},
    { 320, 712, 208},
    { 336, 816, 200},
    { 400, 808, 232},
    { 480, 848, 208},
    { 536, 776, 200},
    { 528, 816, 152},
    { 496, 904, -24},
    { 440, 944, 168},
    { 384, 1088, 296},
    { 272, 1200, 248},
    { 200, 1128, 272},
    { 184, 1032, 88},
    { 216, 904, 96},
    { 264, 872, 48},
    { 280, 816, 40},
    { 320, 720, 40},
    { 368, 720, -16},
    { 368, 776, 72},
    { 352, 840, 16},
    { 376, 848, 32},
    { 464, 928, -88},
    // 45 seconds
    { 448, 864, 136},
    { 400, 1184, 80},
    { 344, 1088, 232},
    { 360, 1448, 368},
    { 192, 1016, 504},
    { 408, 1080, 264},
    { 312, 920, 320},
    { 240, 896, 288},
    { 272, 728, 216},
    { 328, 672, 224},
    { 336, 744, 216},
    { 376, 776, 264},
    { 456, 816, 272},
    { 464, 784, 256},
    { 520, 760, 232},
    { 544, 752, 216},
    { 528, 744, 208},
    { 472, 1032, 272},
    { 488, 1088, 248},
    { 424, 992, 304},
    { 376, 1320, 240},
    { 256, 1200, 264},
    { 320, 1040, 56},
    { 376, 840, 96},
    { 376, 744, 128},
    // 46 seconds
    { 408, 624, 136},
    { 424, 648, 136},
    { 416, 680, 152},
    { 368, 816, 112},
    { 368, 848, 56},
    { 384, 888, 64},
    { 416, 880, -16},
    { 384, 1040, 168},
    { 440, 824, 208},
    { 592, 1560, 280},
    { 256, 976, 480},
    { 408, 1232, 200},
    { 312, 880, 312},
    { 264, 808, 280},
    { 312, 672, 184},
    { 368, 656, 280},
    { 384, 744, 328},
    { 432, 752, 312},
    { 496, 744, 320},
    { 512, 736, 264},
    { 520, 576, 192},
    { 488, 936, 296},
    { 408, 896, 248},
    { 408, 1048, 136},
    { 544, 1184, 416},
    // 47 seconds
    { 248, 1256, 304},
    { 352, 1272, 88},
    { 368, 728, 64},
    { 264, 832, -24},
    { 304, 688, 96},
    { 360, 784, 112},
    { 368, 832, 160},
    { 384, 920, 104},
    { 376, 832, 32},
    { 368, 704, 24},
    { 408, 696, 8},
    { 424, 760, 24},
    { 424, 808, 40},
    { 408, 816, 8},
    { 424, 792, -8},
    { 312, 624, -136},
    { 408, 1232, 400},
    { 168, 1792, 344},
    { 224, 1600, 384},
    { 256, 1112, 360},
    { 256, 944, 240},
    { 232, 704, 200},
    { 248, 752, 168},
    { 232, 704, 248},
    { 288, 840, 208},
    // 48 seconds
    { 344, 800, 264},
    { 416, 840, 248},
    { 416, 808, 216},
    { 464, 800, 192},
    { 480, 800, 144},
    { 504, 808, 208},
    { 552, 792, 144},
    { 472, 1096, 208},
    { 472, 992, 144},
    { 416, 1272, 312},
    { 336, 1192, -32},
    { 288, 752, 16},
    { 240, 792, 40},
    { 200, 792, 104},
    { 256, 800, 64},
    { 336, 832, 48},
    { 352, 808, 40},
    { 368, 784, 8},
    { 376, 808, -16},
    { 376, 752, 16},
    { 424, 776, -40},
    { 416, 856, 48},
    { 456, 864, 88},
    { 408, 1032, 64},
    { 384, 864, 168},
    // 49 seconds
    { 632, 1328, 432},
    { 168, 1472, 304},
    { 264, 1320, 416},
    { 280, 920, 296},
    { 256, 760, 208},
    { 288, 648, 192},
    { 344, 656, 240},
    { 344, 768, 272},
    { 392, 808, 280},
    { 432, 832, 232},
    { 464, 744, 208},
    { 496, 848, 168},
    { 456, 784, 160},
    { 368, 1112, 184},
    { 432, 1000, 176},
    { 488, 1368, 432},
    { 192, 1224, 216},
    { 336, 1128, -72},
    { 368, 568, 48},
    { 288, 688, 16},
    { 264, 728, 88},
    { 336, 832, 88},
    { 296, 904, 80},
    { 360, 824, 40},
    { 352, 776, 24},
    // 50 seconds
    { 360, 784, 0},
    { 336, 768, 88},
    { 408, 816, 0},
    { 392, 984, 16},
    { 360, 1056, 136},
    { 368, 1160, 96},
    { 552, 1416, 392},
    { 152, 1440, 504},
    { 288, 1192, 352},
    { 280, 872, 264},
    { 256, 680, 256},
    { 336, 696, 248},
    { 368, 720, 216},
    { 352, 728, 312},
    { 360, 856, 200},
    { 472, 704, 232},
    { 544, 704, 136},
    { 504, 760, 176},
    { 488, 856, 232},
    { 400, 936, 264},
    { 536, 1000, 136},
    { 368, 1408, 296},
    { 416, 1120, 208},
    { 376, 824, 88},
    { 392, 736, -40},
    // 51 seconds
    { 288, 816, 72},
    { 344, 672, 104},
    { 448, 776, 112},
    { 440, 816, 96},
    { 432, 792, 80},
    { 456, 728, 32},
    { 448, 728, -8},
    { 432, 704, -8},
    { 376, 808, 0},
    { 360, 1056, -136},
    { 328, 1160, -64},
    { 400, 928, 120},
    { 464, 1648, 224},
    { 272, 1192, 560},
    { 432, 1176, 192},
    { 352, 816, 304},
    { 312, 808, 208},
    { 312, 696, 200},
    { 368, 608, 224},
    { 400, 808, 200},
    { 440, 712, 256},
    { 472, 760, 240},
    { 504, 760, 240},
    { 496, 816, 256},
    { 440, 1000, 336},
    // 52 seconds
    { 440, 1224, 280},
    { 528, 1112, 344},
    { 192, 1624, 376},
    { 232, 1224, 32},
    { 264, 752, -56},
    { 184, 640, -96},
    { 248, 656, 8},
    { 368, 688, 88},
    { 384, 824, 24},
    { 368, 768, 24},
    { 360, 592, -64},
    { 328, 616, -168},
    { 280, 960, -32},
    { 272, 904, -64},
    { 352, 1224, 64},
    { 416, 1168, 152},
    { 432, 1152, 40},
    { 400, 1224, 344},
    { 120, 1400, 296},
    { 248, 1008, 296},
    { 264, 952, 224},
    { 184, 856, 320},
    { 208, 832, 224},
    { 272, 776, 208},
    { 336, 744, 296},
    // 53 seconds
    { 376, 792, 224},
    { 432, 760, 216},
    { 488, 760, 168},
    { 456, 888, 144},
    { 408, 952, 168},
    { 320, 1024, 120},
    { 376, 1032, 88},
    { 448, 1056, 488},
    { 160, 1192, 24},
    { 208, 1144, 0},
    { 240, 816, 104},
    { 272, 864, 8},
    { 304, 632, 72},
    { 376, 664, 64},
    { 392, 728, 32},
    { 344, 776, 40},
    { 352, 792, -32},
    { 368, 712, -56},
    { 384, 792, -56},
    { 432, 872, -104},
    { 440, 1216, 80},
    { 432, 1136, 168},
    { 400, 1728, 256},
    { 288, 1104, 384},
    { 392, 1248, 184},
    // 54 seconds
    { 296, 872, 224},
    { 216, 712, 224},
    { 240, 648, 224},
    { 312, 688, 208},
    { 320, 744, 232},
    { 384, 864, 200},
    { 432, 784, 216},
    { 512, 720, 184},
    { 568, 720, 144},
    { 568, 976, 184},
    { 536, 936, 192},
    { 528, 984, 200},
    { 552, 1288, 520},
    { 360, 1352, 136},
    { 240, 1168, 112},
    { 240, 784, 40},
    { 240, 784, 24},
    { 296, 696, 16},
    { 400, 752, 56},
    { 400, 784, 48},
    { 376, 760, 56},
    { 440, 704, -8},
    { 464, 552, 16},
    { 488, 560, -64},
    { 472, 944, -80},
    // 55 seconds
    { 440, 1064, 112},
    { 384, 1272, 88},
    { 456, 1408, 456},
    { 200, 1312, 272},
    { 272, 928, 304},
    { 344, 824, 200},
    { 360, 752, 296},
    { 280, 760, 272},
    { 328, 768, 272},
    { 360, 784, 288},
    { 344, 848, 264},
    { 384, 792, 240},
    { 416, 760, 256},
    { 400, 1000, 296},
    { 392, 1128, 400},
    { 376, 1112, 200},
    { 368, 1144, 288},
    { 32, 1432, 416},
    { 264, 1120, -24},
    { 296, 576, -8},
    { 200, 736, 72},
    { 176, 864, 128},
    { 128, 936, 176},
    { 208, 976, 40},
    { 256, 768, 16},
    // 56 seconds
    { 288, 760, 32},
    { 320, 792, 8},
    { 328, 832, 0},
    { 344, 824, 72},
    { 400, 984, 24},
    { 312, 1160, 136},
    { 288, 888, 144},
    { 496, 1248, 440},
    { 8, 1464, 392},
    { 208, 1168, 280},
    { 328, 816, 240},
    { 232, 728, 256},
    { 224, 768, 216},
    { 256, 792, 312},
    { 272, 800, 344},
    { 288, 800, 360},
    { 344, 792, 232},
    { 360, 792, 192},
    { 360, 760, 224},
    { 408, 792, 192},
    { 408, 928, 256},
    { 384, 1000, 232},
    { 360, 1096, 232},
    { 432, 1200, 304},
    { 64, 1520, 328},
    // 57 seconds
    { 264, 952, 8},
    { 328, 560, -80},
    { 328, 592, 200},
    { 152, 1064, 232},
    { 104, 960, 232},
    { 288, 1024, 8},
    { 312, 528, 64},
    { 344, 712, 64},
    { 320, 816, -8},
    { 280, 912, 104},
    { 352, 1000, 128},
    { 256, 1096, 136},
    { 296, 1152, 448},
    { 104, 1368, 376},
    { 304, 1192, 344},
    { 376, 872, 232},
    { 328, 792, 232},
    { 240, 808, 328},
    { 240, 776, 304},
    { 272, 752, 336},
    { 304, 800, 304},
    { 320, 840, 288},
    { 344, 840, 296},
    { 400, 864, 232},
    { 424, 856, 168},
    // 58 seconds
    { 464, 816, 312},
    { 464, 920, 16},
    { 344, 1112, 200},
    { 368, 1128, 216},
    { 264, 1368, 448},
    { 144, 1024, 96},
    { 216, 728, -128},
    { 192, 576, 72},
    { 160, 856, 72},
    { 88, 984, 112},
    { 240, 944, 72},
    { 304, 776, 8},
    { 352, 736, 16},
    { 360, 776, 48},
    { 368, 752, 48},
    { 368, 872, 120},
    { 376, 784, 16},
    { 352, 1096, 24},
    { 312, 1072, 176},
    { 368, 1152, 144},
    { 320, 1456, 320},
    { 184, 1216, 504},
    { 296, 1032, 224},
    { 272, 824, 328},
    { 192, 760, 304},
    // 59 seconds
    { 216, 712, 272},
    { 256, 744, 320},
    { 248, 824, 344},
    { 288, 832, 280},
    { 360, 816, 272},
    { 416, 584, 80},
    { 440, 944, 248},
    { 424, 896, 256},
    { 288, 1176, 232},
    { 288, 1336, 376},
    { 88, 1248, 576},
    { 80, 1160, -112},
    { 184, 592, 8},
    { 168, 632, 120},
    { 80, 1040, 296},
    { -24, 1064, 208},
    { 112, 1048, 40},
    { 160, 816, 8},
    { 216, 736, 48},
    { 256, 808, 48},
    { 272, 800, 56},
    { 288, 840, 88},
    { 328, 912, -56},
    { 320, 1000, 32},
    { 280, 888, 192},
    // 60 seconds
    // elapsed: 1 minutes
    { 352, 1008, 120},
    { 376, 1240, 424},
    { -56, 1384, 560},
    { 112, 1344, 448},
    { 168, 920, 352},
    { 144, 896, 352},
    { 104, 848, 360},
    { 168, 800, 336},
    { 152, 824, 360},
    { 176, 880, 344},
    { 224, 904, 360},
    { 264, 896, 368},
    { 248, 968, 208},
    { 184, 944, 128},
    { 248, 808, 336},
    { 224, 984, 256},
    { 256, 912, 144},
    { 288, 1016, 296},
    { 48, 1112, 360},
    { 136, 1144, 80},
    { 104, 816, 104},
    { 8, 968, 96},
    { -88, 952, 128},
    { -72, 976, 128},
    { -24, 952, 152},
    // 61 seconds
    { 24, 952, 112},
    { 40, 816, 280},
    { 40, 888, 184},
    { 72, 960, 232},
    { 48, 984, 192},
    { 88, 984, 200},
    { 96, 944, 208},
    { 112, 984, 200},
    { 112, 984, 208},
    { 136, 968, 200},
    { 120, 936, 208},
    { 112, 944, 208},
    { 120, 944, 184},
    { 136, 944, 200},
    { 136, 960, 208},
    { 128, 944, 216},
    { 144, 936, 224},
    { 168, 920, 216},
    { 184, 936, 224},
    { 200, 880, 384},
    { 224, 1112, 184},
    { 152, 856, 240},
    { 176, 920, 248},
    { 152, 912, 288},
    { 152, 912, 320},
    // 62 seconds
    { 96, 944, 344},
    { 104, 976, 328},
    { 104, 992, 312},
    { 104, 976, 296},
    { 112, 1008, 272},
    { 112, 1000, 288},
    { 112, 976, 264},
    { 104, 1008, 272},
    { 96, 936, 304},
    { 80, 944, 304},
    { 80, 928, 296},
    { 88, 928, 320},
    { 104, 944, 328},
    { 104, 904, 376},
    { 128, 960, 336},
    { 104, 936, 344},
    { 96, 960, 304},
    { 88, 944, 312},
    { 104, 968, 344},
    { 112, 960, 304},
    { 120, 960, 304},
    { 136, 952, 304},
    { 136, 960, 296},
    { 144, 960, 304},
    { 112, 1000, 328},
    // 63 seconds
    { 112, 992, 296},
    { 120, 976, 240},
    { 112, 952, 208},
    { 112, 984, 176},
    { 120, 976, 184},
    { 160, 936, 152},
    { 192, 912, 160},
    { 232, 888, 176},
    { 264, 920, 168},
    { 272, 912, 160},
    { 280, 896, 144},
    { 296, 880, 128},
    { 320, 872, 104},
    { 312, 912, 88},
    { 304, 912, 56},
    { 320, 936, 48},
    { 296, 992, 56},
    { 344, 1048, 16},
    { 280, 1224, 192},
    { 200, 1024, 336},
    { 280, 1088, 328},
    { 224, 824, 224},
    { 224, 784, 232},
    { 216, 832, 312},
    { 192, 864, 312},
    // 64 seconds
    { 224, 856, 256},
    { 288, 768, 232},
    { 312, 784, 240},
    { 336, 792, 248},
    { 408, 792, 264},
    { 496, 864, 288},
    { 496, 912, 280},
    { 488, 928, 296},
    { 424, 960, 320},
    { 352, 1040, 320},
    { 360, 1288, 416},
    { 136, 1448, 608},
    { 216, 1192, 104},
    { 248, 592, 64},
    { 192, 712, 192},
    { 64, 952, 288},
    { 56, 1072, 176},
    { 176, 944, 88},
    { 216, 832, 40},
    { 248, 792, 56},
    { 248, 784, 80},
    { 280, 824, 56},
    { 296, 840, 40},
    { 344, 872, 16},
    { 384, 832, 32},
    // 65 seconds
    { 424, 920, 208},
    { 416, 920, 128},
    { 456, 1000, 120},
    { 424, 1304, 496},
    { 152, 1200, 448},
    { 352, 1064, 320},
    { 368, 872, 328},
    { 328, 816, 304},
    { 312, 744, 296},
    { 344, 792, 296},
    { 296, 816, 296},
    { 296, 816, 192},
    { 360, 792, 248},
    { 408, 768, 288},
    { 480, 856, 216},
    { 480, 736, 288},
    { 464, 752, -16},
    { 424, 920, 120},
    { 464, 936, 328},
    { 392, 1184, 512},
    { 288, 1248, -80},
    { 424, 768, -24},
    { 280, 608, 168},
    { 248, 1008, 136},
    { 168, 936, 176},
    // 66 seconds
    { 232, 960, -32},
    { 224, 816, 48},
    { 296, 760, 40},
    { 344, 760, 48},
    { 384, 792, 64},
    { 440, 808, 32},
    { 464, 840, -16},
    { 504, 728, -24},
    { 440, 1032, 152},
    { 400, 1032, 360},
    { 312, 1592, 472},
    { 152, 1176, 384},
    { 392, 928, 224},
    { 408, 872, 208},
    { 312, 744, 360},
    { 296, 832, 296},
    { 344, 792, 336},
    { 336, 864, 336},
    { 352, 808, 360},
    { 400, 800, 304},
    { 408, 760, 280},
    { 432, 760, 280},
    { 456, 856, 248},
    { 464, 992, 280},
    { 512, 848, 24},
    // 67 seconds
    { 536, 1040, 120},
    { 520, 1064, 336},
    { 208, 1328, 536},
    { 296, 1368, 48},
    { 288, 472, 88},
    { 176, 672, 80},
    { 192, 792, 96},
    { 184, 944, 144},
    { 248, 984, 16},
    { 312, 824, -16},
    { 288, 808, 16},
    { 328, 792, 40},
    { 368, 896, -64},
    { 368, 632, -72},
    { 440, 952, 32},
    { 448, 768, 72},
    { 464, 1024, 192},
    { 520, 904, 136},
    { 584, 1240, 512},
    { 208, 1176, 536},
    { 416, 1224, 256},
    { 400, 896, 360},
    { 288, 784, 320},
    { 296, 752, 248},
    { 296, 696, 312},
    // 68 seconds
    { 256, 808, 296},
    { 272, 824, 280},
    { 328, 808, 280},
    { 400, 768, 224},
    { 448, 800, -80},
    { 312, 944, 144},
    { 280, 1056, 192},
    { 296, 1240, 208},
    { 368, 1112, 832},
    { 344, 1048, 40},
    { 184, 952, 48},
    { 248, 800, 96},
    { 168, 944, 72},
    { 96, 960, 136},
    { 168, 952, 24},
    { 232, 832, 0},
    { 304, 760, 104},
    { 392, 800, 88},
    { 376, 816, 80},
    { 384, 768, 128},
    { 400, 968, 152},
    { 392, 800, 128},
    { 472, 928, 176},
    { 472, 1016, 240},
    { 544, 976, 360},
    // 69 seconds
    { 368, 1176, 392},
    { 312, 1064, 352},
    { 368, 848, 344},
    { 264, 832, 360},
    { 216, 888, 320},
    { 256, 856, 336},
    { 288, 880, 352},
    { 312, 904, 320},
    { 320, 856, 296},
    { 352, 848, 264},
    { 360, 816, 264},
    { 384, 848, 224},
    { 408, 848, 240},
    { 416, 792, 200},
    { 432, 952, 224},
    { 440, 992, 112},
    { 272, 1224, 520},
    { 272, 1120, 320},
    { 304, 1024, 184},
    { 416, 768, 88},
    { 240, 864, 232},
    { 104, 1008, 280},
    { 104, 1072, 208},
    { 192, 944, 136},
    { 120, 848, 8},
    // 70 seconds
    { 144, 1096, -32},
    { 96, 912, 136},
    { 112, 1056, -80},
    { 168, 960, 32},
    { 224, 1032, -56},
    { 224, 1008, 96},
    { 224, 944, 48},
    { 200, 960, 56},
    { 192, 832, 56},
    { 192, 992, -40},
    { 232, 944, 8},
    { 224, 944, 8},
    { 304, 920, -56},
    { 296, 928, -80},
    { 256, 904, -72},
    { 272, 936, -64},
    { 216, 992, -144},
    { 248, 920, -120},
    { 256, 1016, -120},
    { 360, 1088, -168},
    { 360, 920, -104},
    { 416, 1312, -512},
    { 408, 680, -288},
    { 416, 536, -384},
    { 240, 360, -592},
    // 71 seconds
    { 120, 344, -832},
    { -40, 96, -720},
    { -96, 120, -928},
    { -152, -144, -856},
    { -112, -104, -920},
    { -96, -144, -944},
    { -56, -112, -944},
    { -32, -136, -960},
    { -8, -128, -992},
    { 56, -184, -944},
    { 8, -152, -944},
    { -16, -136, -928},
    { 16, -96, -952},
    { 32, -160, -928},
    { -24, -144, -920},
    { 0, -128, -928},
    { 16, -104, -944},
    { -8, -104, -912},
    { 32, -112, -920},
    { 32, -128, -904},
    { -8, -56, -944},
    { 24, -104, -920},
    { 0, -96, -944},
    { 24, -128, -936},
    { -24, -96, -912},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 15:42:22 local
AccelRawData *activity_sample_walk_100_pbl_25672_2(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25672_2
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 40, -48, -912},
    { -16, -56, -920},
    { 72, -120, -1000},
    { 8, -88, -1000},
    { -32, -32, -1008},
    { -80, -64, -976},
    { -40, -64, -936},
    { -48, -64, -920},
    { -32, -80, -928},
    { -80, -80, -928},
    { -80, -104, -952},
    { -64, -72, -968},
    { -88, -112, -944},
    { -56, -128, -936},
    { -88, -136, -944},
    { -72, -144, -936},
    { -96, -152, -936},
    { -56, -152, -936},
    { -88, -152, -936},
    { -64, -112, -920},
    { 0, -160, -896},
    { 24, -176, -904},
    { -80, -128, -904},
    { -64, -256, -848},
    { -88, -240, -880},
    // 1 seconds
    { -152, -232, -896},
    { -360, -232, -912},
    { -8, -288, -1184},
    { 440, -840, -888},
    { -120, -328, -1000},
    { 8, 0, -1016},
    { 24, 24, -944},
    { 112, 104, -1008},
    { 136, 8, -896},
    { 168, 88, -912},
    { 168, 32, -824},
    { 224, 224, -864},
    { 176, -56, -696},
    { 216, 456, -752},
    { 248, 264, -664},
    { 312, 536, -616},
    { 304, 560, -696},
    { 296, 584, -512},
    { 264, 896, -664},
    { 256, 608, -360},
    { 168, 944, -408},
    { 152, 840, -288},
    { 160, 1000, -144},
    { 80, 912, -304},
    { 120, 1128, 16},
    // 2 seconds
    { 144, 1224, -104},
    { 152, 1048, -56},
    { 216, 960, -120},
    { 208, 952, -176},
    { 280, 1000, -288},
    { 272, 1048, -392},
    { 400, 1008, -456},
    { 328, 736, -456},
    { 336, 768, -656},
    { 304, 368, -568},
    { 312, 520, -800},
    { 256, 144, -720},
    { 248, 184, -832},
    { 232, 88, -856},
    { 184, 104, -872},
    { 152, 88, -904},
    { 112, 80, -912},
    { 120, 88, -936},
    { 128, 56, -928},
    { 128, 112, -1008},
    { 128, 104, -952},
    { 120, 40, -928},
    { 168, 72, -960},
    { 192, -88, -856},
    { 248, -56, -888},
    // 3 seconds
    { 240, -104, -848},
    { 192, -128, -856},
    { 160, -144, -864},
    { 168, -168, -856},
    { 136, -200, -856},
    { 104, -168, -888},
    { 96, -128, -904},
    { 144, -88, -984},
    { 296, -224, -976},
    { 160, 8, -1128},
    { 360, -8, -1008},
    { 376, 88, -992},
    { 440, 16, -848},
    { 344, 120, -784},
    { 312, 80, -736},
    { 328, 120, -744},
    { 384, 88, -720},
    { 408, 120, -744},
    { 480, 112, -752},
    { 488, 96, -752},
    { 536, 72, -784},
    { 512, 96, -808},
    { 432, 56, -776},
    { 224, 304, -1040},
    { 408, 576, -1248},
    // 4 seconds
    { 88, 360, -1064},
    { 208, 304, -976},
    { 296, 128, -656},
    { 368, 368, -688},
    { 176, 624, -872},
    { 176, 384, -792},
    { 224, 328, -848},
    { 280, 112, -680},
    { 320, 144, -688},
    { 336, 152, -720},
    { 360, 184, -768},
    { 432, 240, -824},
    { 464, 376, -840},
    { 400, 320, -856},
    { 616, 784, -1096},
    { 424, 592, -824},
    { 528, 632, -912},
    { 416, 400, -736},
    { 464, 320, -576},
    { 424, 424, -608},
    { 456, 400, -552},
    { 520, 424, -576},
    { 560, 344, -576},
    { 584, 280, -560},
    { 616, 216, -568},
    // 5 seconds
    { 608, 336, -664},
    { 496, 272, -800},
    { 496, 408, -880},
    { 440, 616, -952},
    { 408, 560, -1096},
    { 360, 192, -816},
    { 416, 144, -552},
    { 384, 296, -584},
    { 272, 376, -760},
    { 368, 384, -808},
    { 368, 272, -784},
    { 400, 184, -696},
    { 392, 136, -672},
    { 440, 112, -640},
    { 488, 296, -768},
    { 616, 440, -792},
    { 536, 472, -808},
    { 640, 760, -888},
    { 520, 816, -928},
    { 552, 512, -736},
    { 504, 416, -648},
    { 440, 368, -480},
    { 472, 408, -536},
    { 456, 368, -536},
    { 488, 360, -592},
    // 6 seconds
    { 480, 264, -616},
    { 480, 272, -616},
    { 496, 176, -648},
    { 584, 88, -632},
    { 480, 72, -816},
    { 344, 304, -1040},
    { 536, 368, -984},
    { 280, 368, -1056},
    { 176, 224, -800},
    { 248, 96, -608},
    { 376, 320, -688},
    { 272, 224, -680},
    { 368, 360, -832},
    { 376, 248, -760},
    { 352, 224, -720},
    { 400, 192, -752},
    { 400, 112, -624},
    { 576, 304, -880},
    { 424, 480, -904},
    { 456, 400, -768},
    { 400, 1080, -1264},
    { 328, 464, -808},
    { 592, 576, -856},
    { 432, 512, -736},
    { 440, 344, -552},
    // 7 seconds
    { 384, 488, -688},
    { 360, 384, -640},
    { 320, 368, -712},
    { 328, 224, -696},
    { 264, 56, -680},
    { 296, 32, -744},
    { 216, 0, -824},
    { 112, -40, -936},
    { -32, 128, -1048},
    { -256, -8, -912},
    { -104, 400, -848},
    { -32, 528, -616},
    { 184, 808, -424},
    { 160, 1056, -496},
    { 152, 872, -184},
    { 232, 960, -336},
    { 216, 904, -296},
    { 208, 696, -144},
    { 296, 920, -200},
    { 288, 736, -56},
    { 384, 1160, -80},
    { 216, 1096, 48},
    { 304, 1224, 144},
    { 24, 1328, 56},
    { 256, 1080, 40},
    // 8 seconds
    { 336, 888, 32},
    { 264, 808, 88},
    { 248, 840, 96},
    { 184, 808, 112},
    { 296, 864, 96},
    { 272, 912, 80},
    { 360, 888, 40},
    { 384, 776, -72},
    { 344, 648, -72},
    { 248, 1144, 0},
    { 216, 1032, 24},
    { 264, 1216, -120},
    { -80, 1128, 280},
    { 304, 1240, -288},
    { 216, 680, -104},
    { 240, 720, -24},
    { 176, 880, -64},
    { 176, 784, -16},
    { 280, 888, -152},
    { 248, 744, -136},
    { 272, 776, -160},
    { 280, 784, -128},
    { 328, 872, -144},
    { 296, 1136, 40},
    { 272, 1040, 16},
    // 9 seconds
    { 256, 1344, 272},
    { 112, 1184, 248},
    { 384, 1168, 56},
    { 320, 872, 128},
    { 312, 864, 136},
    { 272, 800, 176},
    { 304, 808, 152},
    { 368, 808, 184},
    { 352, 848, 112},
    { 384, 872, 72},
    { 400, 840, 88},
    { 312, 936, 184},
    { 224, 1000, 56},
    { 336, 1168, -56},
    { 88, 1168, 456},
    { 352, 1304, -264},
    { 240, 712, -152},
    { 344, 544, 88},
    { 272, 864, 16},
    { 152, 840, 40},
    { 312, 944, -112},
    { 320, 784, -112},
    { 304, 736, -144},
    { 360, 728, -136},
    { 400, 728, -112},
    // 10 seconds
    { 416, 1072, -16},
    { 288, 1088, 48},
    { 384, 1144, 240},
    { 176, 1488, 136},
    { 376, 1008, 192},
    { 488, 936, 176},
    { 416, 808, 112},
    { 424, 800, 144},
    { 272, 824, 152},
    { 336, 808, 192},
    { 296, 864, 120},
    { 384, 816, 72},
    { 424, 880, -24},
    { 328, 928, 16},
    { 216, 1144, -96},
    { 256, 1336, -152},
    { 104, 984, 224},
    { 160, 1144, -48},
    { 272, 1024, -128},
    { 288, 616, -8},
    { 296, 856, -176},
    { 240, 600, 24},
    { 440, 704, -144},
    { 400, 704, -112},
    { 392, 712, -160},
    // 11 seconds
    { 440, 720, -168},
    { 488, 872, -160},
    { 528, 920, -96},
    { 488, 896, 0},
    { 464, 1096, 184},
    { 360, 1472, 168},
    { 296, 1240, 336},
    { 320, 1224, 24},
    { 328, 912, 48},
    { 312, 720, 96},
    { 320, 736, 96},
    { 304, 712, 192},
    { 320, 752, 160},
    { 360, 864, 32},
    { 360, 856, 80},
    { 312, 1024, 24},
    { 288, 1064, -56},
    { 320, 1168, -72},
    { 152, 1096, 144},
    { 200, 1096, -160},
    { 232, 1008, -184},
    { 256, 672, -56},
    { 264, 872, -56},
    { 248, 768, 0},
    { 352, 832, -88},
    // 12 seconds
    { 344, 800, -128},
    { 312, 752, -176},
    { 328, 680, -32},
    { 376, 720, -216},
    { 392, 936, -88},
    { 232, 1040, 32},
    { 256, 1488, 136},
    { 224, 1320, 104},
    { 296, 1240, 120},
    { 304, 952, 104},
    { 272, 872, 112},
    { 288, 784, 96},
    { 280, 720, 120},
    { 328, 792, 120},
    { 296, 792, 112},
    { 344, 848, 64},
    { 336, 912, 48},
    { 248, 1040, 32},
    { 216, 1136, -24},
    { 256, 1144, -96},
    { 32, 1216, 232},
    { 280, 1000, -176},
    { 272, 864, -120},
    { 312, 664, 0},
    { 288, 880, -72},
    // 13 seconds
    { 320, 736, -8},
    { 352, 808, -88},
    { 344, 760, -120},
    { 320, 688, -152},
    { 344, 776, -96},
    { 352, 848, -24},
    { 152, 1152, -120},
    { 184, 824, 80},
    { 144, 1656, 120},
    { 72, 1232, 264},
    { 200, 1216, 192},
    { 168, 896, 192},
    { 224, 816, 64},
    { 184, 688, 104},
    { 232, 752, 112},
    { 216, 856, 136},
    { 200, 912, 112},
    { 272, 912, 88},
    { 264, 912, 80},
    { 208, 1072, 88},
    { 176, 1048, 88},
    { 208, 1216, 56},
    { -184, 1296, 248},
    { 184, 1200, -136},
    { 112, 672, 8},
    // 14 seconds
    { 152, 792, -48},
    { 112, 920, -48},
    { 208, 800, 40},
    { 216, 872, -8},
    { 240, 808, -88},
    { 240, 720, -24},
    { 216, 632, -104},
    { 256, 1048, -200},
    { 224, 1024, 16},
    { 104, 1184, 136},
    { 136, 1512, 400},
    { -24, 1328, 216},
    { 176, 1056, 128},
    { 192, 856, 200},
    { 168, 832, 216},
    { 88, 792, 168},
    { 120, 800, 280},
    { 152, 968, 272},
    { 88, 968, 192},
    { 152, 832, 208},
    { 168, 952, 128},
    { 128, 1040, 216},
    { 24, 1080, 88},
    { 112, 1160, 16},
    { 24, 1208, 280},
    // 15 seconds
    { -32, 1024, 136},
    { 176, 944, -104},
    { 152, 720, 40},
    { 56, 928, 136},
    { -8, 984, 40},
    { 104, 864, 32},
    { 120, 856, 56},
    { 112, 856, -64},
    { 136, 864, 40},
    { 136, 920, 0},
    { 104, 976, 56},
    { 48, 1072, 72},
    { 56, 992, 96},
    { -48, 1240, 128},
    { 8, 1040, 264},
    { 112, 944, 152},
    { 120, 1000, 176},
    { 72, 928, 216},
    { 8, 968, 232},
    { 40, 896, 192},
    { 96, 880, 136},
    { 96, 888, 224},
    { 144, 912, 192},
    { 184, 896, 176},
    { 208, 920, 152},
    // 16 seconds
    { 232, 920, 128},
    { 256, 936, 88},
    { 256, 944, 168},
    { 240, 1152, 192},
    { 168, 1168, 320},
    { 216, 1528, 176},
    { 0, 1088, 128},
    { 96, 864, -104},
    { 144, 528, 40},
    { 120, 720, 32},
    { -56, 1016, 80},
    { -56, 1104, -24},
    { 56, 1000, -96},
    { 136, 824, -104},
    { 144, 864, -112},
    { 184, 832, -48},
    { 192, 912, -96},
    { 184, 944, -96},
    { 208, 816, -64},
    { 216, 896, -96},
    { 208, 880, -72},
    { 176, 872, 144},
    { 216, 1128, 16},
    { -72, 1456, 128},
    { 16, 1272, 296},
    // 17 seconds
    { 128, 1032, 160},
    { 224, 880, 120},
    { 176, 808, 160},
    { 144, 848, 168},
    { 128, 864, 192},
    { 128, 920, 152},
    { 144, 896, 144},
    { 200, 896, 160},
    { 248, 896, 128},
    { 304, 880, 104},
    { 352, 880, 72},
    { 400, 912, 72},
    { 352, 1008, 96},
    { 248, 1160, 128},
    { 272, 920, 280},
    { 256, 1496, 248},
    { 88, 1128, -64},
    { 152, 568, -16},
    { 184, 744, 16},
    { 128, 816, 144},
    { 48, 1080, 136},
    { 160, 1072, 96},
    { 224, 880, -24},
    { 256, 744, 8},
    { 320, 768, -32},
    // 18 seconds
    { 304, 840, 32},
    { 312, 968, 16},
    { 280, 912, 16},
    { 320, 808, 16},
    { 288, 888, 0},
    { 272, 936, 64},
    { 312, 960, 24},
    { 352, 1192, 360},
    { 136, 1472, 280},
    { 200, 1280, 336},
    { 248, 1112, 216},
    { 240, 1000, 256},
    { 208, 792, 168},
    { 248, 752, 200},
    { 264, 784, 200},
    { 256, 864, 160},
    { 272, 872, 128},
    { 320, 800, 136},
    { 344, 832, 112},
    { 392, 872, 96},
    { 384, 920, 80},
    { 312, 1016, 72},
    { 248, 1040, 32},
    { 312, 1000, 96},
    { 240, 1424, 296},
    // 19 seconds
    { 128, 1032, 96},
    { 264, 864, -56},
    { 248, 576, 152},
    { 200, 936, 96},
    { 104, 1072, 128},
    { 160, 1040, 104},
    { 240, 936, -16},
    { 272, 784, 24},
    { 312, 784, 0},
    { 336, 888, -40},
    { 328, 872, 0},
    { 312, 872, 0},
    { 320, 856, -40},
    { 296, 896, -32},
    { 280, 1024, 104},
    { 248, 888, -32},
    { 288, 1272, 168},
    { 56, 1424, 240},
    { 344, 1368, 144},
    { 312, 1120, 120},
    { 328, 896, 144},
    { 248, 904, 120},
    { 224, 792, 160},
    { 208, 736, 128},
    { 232, 752, 104},
    // 20 seconds
    { 296, 712, 112},
    { 320, 792, 120},
    { 320, 880, 80},
    { 368, 872, 16},
    { 424, 928, -24},
    { 344, 944, 72},
    { 320, 992, -184},
    { 288, 1024, -56},
    { 184, 1168, 192},
    { 216, 1192, -104},
    { 184, 664, -144},
    { 240, 664, 8},
    { 200, 856, 48},
    { 144, 1008, 96},
    { 232, 1048, -104},
    { 304, 816, -96},
    { 320, 792, -80},
    { 336, 856, -24},
    { 376, 848, -16},
    { 360, 880, -48},
    { 384, 824, -80},
    { 384, 968, -72},
    { 368, 840, -88},
    { 384, 896, -48},
    { 408, 920, -128},
    // 21 seconds
    { 448, 1016, 88},
    { 368, 1216, 344},
    { 472, 1488, 200},
    { 400, 1000, 200},
    { 392, 640, 168},
    { 416, 704, 112},
    { 408, 736, 160},
    { 336, 792, 144},
    { 312, 840, 120},
    { 352, 800, 192},
    { 376, 800, 120},
    { 392, 760, 160},
    { 416, 792, 160},
    { 472, 800, 128},
    { 480, 744, 152},
    { 400, 992, 32},
    { 360, 992, 152},
    { 432, 1144, 240},
    { 256, 1200, 384},
    { 472, 1008, -8},
    { 408, 768, 48},
    { 456, 696, 176},
    { 416, 976, 64},
    { 416, 904, 144},
    { 504, 952, 0},
    // 22 seconds
    { 536, 768, -16},
    { 512, 704, 24},
    { 456, 784, 0},
    { 424, 792, -8},
    { 424, 752, -24},
    { 424, 888, -72},
    { 384, 784, 72},
    { 328, 1096, 112},
    { 456, 904, 120},
    { 528, 1344, 208},
    { 432, 1080, 304},
    { 464, 1256, 152},
    { 456, 768, 168},
    { 424, 912, 152},
    { 360, 736, 224},
    { 352, 832, 168},
    { 312, 848, 200},
    { 320, 848, 168},
    { 312, 816, 160},
    { 360, 832, 160},
    { 400, 832, 88},
    { 432, 776, 224},
    { 528, 936, 40},
    { 528, 952, 104},
    { 480, 976, 144},
    // 23 seconds
    { 384, 1200, 120},
    { 288, 1104, 216},
    { 304, 1040, -88},
    { 328, 832, -88},
    { 288, 680, 32},
    { 216, 848, 72},
    { 176, 992, 24},
    { 272, 992, -56},
    { 336, 936, -184},
    { 328, 712, -96},
    { 392, 784, -72},
    { 344, 824, -48},
    { 352, 968, -40},
    { 280, 792, 8},
    { 264, 752, 128},
    { 224, 968, 144},
    { 336, 896, 104},
    { 384, 1224, 160},
    { 288, 1128, 272},
    { 328, 1272, 136},
    { 320, 1040, 264},
    { 216, 1056, 192},
    { 184, 880, 168},
    { 208, 768, 184},
    { 160, 816, 176},
    // 24 seconds
    { 192, 824, 232},
    { 200, 768, 400},
    { 208, 856, 360},
    { 232, 904, 208},
    { 232, 888, 184},
    { 320, 912, 24},
    { 296, 1072, 280},
    { 184, 1136, 248},
    { 160, 1160, 184},
    { 200, 1088, 288},
    { 16, 1280, 288},
    { 88, 1048, 80},
    { 288, 856, 8},
    { 160, 688, 224},
    { 120, 1032, 96},
    { 16, 1024, 64},
    { 160, 880, 8},
    { 232, 848, -64},
    { 216, 784, 8},
    { 224, 848, 0},
    { 208, 816, 24},
    { 216, 928, 32},
    { 272, 744, -40},
    { 232, 1000, 56},
    { 240, 952, 32},
    // 25 seconds
    { 248, 888, 88},
    { 240, 928, -32},
    { 392, 1216, 304},
    { 40, 1080, 504},
    { 216, 1360, 144},
    { 144, 1024, 288},
    { 128, 992, 96},
    { 144, 896, 96},
    { 152, 808, 136},
    { 152, 848, 112},
    { 144, 904, 136},
    { 192, 920, 192},
    { 200, 944, 144},
    { 256, 912, 168},
    { 264, 952, 136},
    { 304, 912, 96},
    { 344, 904, 96},
    { 312, 896, 24},
    { 280, 976, 56},
    { 216, 984, -24},
    { 160, 1120, 88},
    { 24, 1160, 304},
    { 16, 1232, 0},
    { 48, 912, 64},
    { 32, 904, 8},
    // 26 seconds
    { -16, 928, 56},
    { 32, 912, 16},
    { 80, 976, -40},
    { 112, 864, 24},
    { 192, 912, -16},
    { 192, 840, 16},
    { 208, 872, -40},
    { 208, 872, 16},
    { 232, 880, -40},
    { 224, 896, -32},
    { 200, 960, -40},
    { 160, 960, -88},
    { 176, 1008, 56},
    { 192, 1224, 304},
    { -80, 1384, 360},
    { -32, 1352, 272},
    { 80, 1048, 184},
    { 112, 896, 104},
    { 136, 808, 152},
    { 160, 768, 184},
    { 192, 872, 144},
    { 144, 952, 208},
    { 200, 968, 216},
    { 240, 904, 176},
    { 272, 840, 176},
    // 27 seconds
    { 296, 808, 176},
    { 328, 800, 144},
    { 336, 832, 136},
    { 296, 768, 40},
    { 272, 1136, 248},
    { 200, 1040, 272},
    { 232, 1160, 240},
    { 72, 1248, 520},
    { 32, 1248, 200},
    { 200, 800, 88},
    { 208, 616, 208},
    { 88, 992, 240},
    { 0, 1072, 176},
    { 136, 1032, 24},
    { 176, 904, -32},
    { 216, 808, 8},
    { 216, 832, 64},
    { 232, 848, 32},
    { 272, 896, 0},
    { 304, 864, 24},
    { 336, 888, 32},
    { 296, 864, 72},
    { 288, 752, 248},
    { 264, 752, -128},
    { 112, 1432, 128},
    // 28 seconds
    { -136, 1264, 600},
    { 48, 1440, 208},
    { 200, 1080, 160},
    { 216, 960, 208},
    { 168, 888, 232},
    { 128, 848, 208},
    { 136, 824, 208},
    { 128, 816, 224},
    { 200, 800, 184},
    { 224, 848, 184},
    { 232, 864, 200},
    { 232, 904, 160},
    { 232, 936, 192},
    { 192, 1008, 152},
    { 168, 1040, 160},
    { 160, 1064, 80},
    { 152, 1288, 192},
    { -112, 1080, 176},
    { 184, 952, -56},
    { 168, 704, 136},
    { 96, 960, 72},
    { -72, 1072, 160},
    { 32, 1096, 48},
    { 104, 912, 16},
    { 152, 800, -32},
    // 29 seconds
    { 168, 800, 32},
    { 168, 872, 56},
    { 184, 920, 24},
    { 216, 840, 16},
    { 256, 800, 0},
    { 232, 776, -64},
    { 160, 1064, 88},
    { 184, 1056, 152},
    { 224, 1344, 264},
    { -80, 1456, 528},
    { 24, 1368, 304},
    { 152, 912, 224},
    { 144, 896, 256},
    { 56, 856, 296},
    { 128, 848, 232},
    { 120, 824, 280},
    { 104, 864, 256},
    { 104, 864, 248},
    { 112, 880, 296},
    { 160, 904, 224},
    { 184, 880, 232},
    { 216, 896, 232},
    { 232, 968, 320},
    { 256, 1128, 192},
    { 200, 1104, 208},
    // 30 seconds
    { 200, 1040, 200},
    { 192, 1360, 264},
    { 120, 968, 176},
    { 136, 856, 72},
    { 232, 672, 88},
    { 112, 872, 120},
    { 16, 1064, 192},
    { 48, 1152, 64},
    { 112, 936, 40},
    { 144, 832, 24},
    { 168, 848, 72},
    { 200, 872, 88},
    { 232, 904, 72},
    { 248, 880, 48},
    { 248, 896, 64},
    { 272, 856, 40},
    { 280, 864, 144},
    { 272, 920, 80},
    { 280, 896, 80},
    { 288, 912, 64},
    { 312, 856, -80},
    { 280, 1144, 16},
    { -32, 1240, 240},
    { 16, 1408, 288},
    { 128, 1024, 136},
    // 31 seconds
    { 192, 864, 176},
    { 144, 888, 256},
    { 112, 824, 288},
    { 120, 920, 248},
    { 128, 928, 232},
    { 120, 944, 320},
    { 152, 952, 240},
    { 152, 864, 296},
    { 160, 928, 224},
    { 176, 832, 264},
    { 224, 880, 240},
    { 272, 888, 352},
    { 272, 968, 408},
    { 256, 1168, 208},
    { 176, 984, 352},
    { 176, 1096, 216},
    { 136, 1112, 408},
    { 112, 1096, 312},
    { 200, 936, 112},
    { 168, 792, 232},
    { 88, 928, 216},
    { 40, 1008, 208},
    { 112, 960, 144},
    { 160, 968, 48},
    { 184, 808, 96},
    // 32 seconds
    { 224, 864, 72},
    { 240, 824, 104},
    { 264, 848, 56},
    { 264, 824, 48},
    { 272, 816, 64},
    { 320, 944, -40},
    { 248, 968, 144},
    { 264, 1016, 80},
    { 296, 1000, 232},
    { 88, 1472, 368},
    { 96, 1080, 304},
    { 208, 1000, 120},
    { 224, 800, 200},
    { 104, 904, 200},
    { 160, 816, 232},
    { 176, 896, 240},
    { 160, 936, 280},
    { 184, 992, 280},
    { 184, 968, 256},
    { 224, 928, 224},
    { 256, 912, 160},
    { 272, 896, 160},
    { 272, 976, 144},
    { 224, 984, 256},
    { 216, 936, 96},
    // 33 seconds
    { 168, 1160, 312},
    { 24, 1184, 304},
    { 192, 992, -8},
    { 208, 704, 0},
    { 160, 744, 88},
    { 72, 992, 160},
    { 0, 1056, 80},
    { 88, 960, -8},
    { 152, 808, -24},
    { 176, 784, -8},
    { 168, 824, 16},
    { 192, 832, 24},
    { 240, 808, 72},
    { 312, 848, -8},
    { 208, 752, 144},
    { 192, 1080, 136},
    { 176, 1488, 488},
    { -200, 1512, 504},
    { 200, 1216, 144},
    { 304, 712, 80},
    { 184, 728, 208},
    { 80, 808, 280},
    { 152, 904, 240},
    { 160, 832, 304},
    { 184, 864, 240},
    // 34 seconds
    { 208, 856, 272},
    { 240, 848, 272},
    { 264, 872, 264},
    { 280, 928, 208},
    { 272, 856, 344},
    { 296, 1120, 64},
    { 280, 960, 184},
    { 232, 1000, 136},
    { 176, 1192, 416},
    { -80, 1256, 464},
    { 256, 1208, -120},
    { 240, 496, 160},
    { 56, 776, 200},
    { 8, 1104, 152},
    { 80, 1096, 80},
    { 128, 992, 24},
    { 168, 824, 8},
    { 216, 840, 40},
    { 224, 872, 64},
    { 232, 880, 48},
    { 240, 888, 48},
    { 296, 840, 24},
    { 248, 848, 240},
    { 240, 992, 64},
    { 248, 1064, 208},
    // 35 seconds
    { -168, 1512, 432},
    { -160, 1384, 400},
    { 112, 992, 224},
    { 184, 936, 216},
    { 88, 880, 240},
    { 104, 856, 296},
    { 144, 808, 304},
    { 128, 848, 296},
    { 160, 880, 320},
    { 176, 888, 296},
    { 192, 888, 280},
    { 208, 928, 264},
    { 240, 904, 232},
    { 280, 920, 208},
    { 264, 976, 224},
    { 240, 1032, 232},
    { 136, 952, 248},
    { 240, 1072, 112},
    { -48, 1336, 360},
    { 24, 1216, 48},
    { 120, 680, 88},
    { 112, 800, 104},
    { 8, 920, 128},
    { -24, 992, 104},
    { 104, 992, 64},
    // 36 seconds
    { 144, 856, 56},
    { 168, 808, 64},
    { 192, 880, 64},
    { 208, 864, 64},
    { 224, 880, 48},
    { 264, 824, 32},
    { 240, 800, 104},
    { 192, 896, 112},
    { 184, 920, 200},
    { 184, 1096, 248},
    { 48, 1808, 352},
    { -40, 1264, 576},
    { 112, 1048, 240},
    { 224, 800, 280},
    { 176, 856, 288},
    { 152, 832, 320},
    { 168, 880, 328},
    { 152, 904, 352},
    { 152, 856, 288},
    { 208, 840, 264},
    { 200, 864, 288},
    { 200, 936, 248},
    { 184, 944, 248},
    { 160, 984, 216},
    { 152, 1096, 288},
    // 37 seconds
    { 112, 976, 144},
    { 136, 1424, 416},
    { -104, 992, 304},
    { 152, 928, -88},
    { 112, 656, 64},
    { 0, 864, 160},
    { -48, 1056, 128},
    { 88, 928, 144},
    { 152, 872, 56},
    { 160, 808, 56},
    { 192, 824, 64},
    { 200, 848, 80},
    { 192, 880, 48},
    { 200, 848, 48},
    { 216, 872, 120},
    { 232, 1032, 168},
    { 112, 1240, 72},
    { 240, 1256, 232},
    { 16, 1328, 272},
    { 144, 1056, 320},
    { 232, 984, 152},
    { 264, 856, 176},
    { 192, 824, 232},
    { 192, 840, 208},
    { 200, 864, 272},
    // 38 seconds
    { 152, 976, 248},
    { 192, 928, 248},
    { 264, 872, 192},
    { 288, 816, 152},
    { 264, 832, 144},
    { 272, 872, 120},
    { 200, 1048, 80},
    { 56, 1136, 72},
    { -8, 1696, 296},
    { -136, 1064, 272},
    { 152, 944, -224},
    { 120, 584, 40},
    { 104, 792, 112},
    { 40, 1128, 24},
    { 88, 960, 104},
    { 112, 904, -16},
    { 136, 808, 0},
    { 168, 816, 8},
    { 200, 848, 0},
    { 232, 840, 0},
    { 248, 848, 8},
    { 280, 808, 8},
    { 248, 992, -48},
    { 144, 1088, 120},
    { 216, 984, 232},
    // 39 seconds
    { -8, 1760, 176},
    { -72, 1256, 544},
    { 160, 1000, 144},
    { 200, 864, 216},
    { 96, 816, 288},
    { 160, 872, 224},
    { 176, 800, 240},
    { 144, 896, 256},
    { 168, 888, 296},
    { 224, 888, 232},
    { 248, 904, 240},
    { 248, 880, 272},
    { 336, 1008, 136},
    { 216, 1064, 112},
    { 112, 1040, 216},
    { 88, 1136, 144},
    { 40, 1488, 400},
    { -24, 1032, 304},
    { 136, 888, -112},
    { 152, 552, 48},
    { 96, 776, 112},
    { 48, 960, 168},
    { 80, 1048, 96},
    { 160, 920, 32},
    { 184, 824, -8},
    // 40 seconds
    { 208, 832, 16},
    { 216, 888, 24},
    { 200, 920, -96},
    { 200, 888, -72},
    { 240, 952, 120},
    { 120, 1120, 128},
    { 224, 1064, 240},
    { 80, 1592, 256},
    { 32, 1064, 472},
    { 200, 872, 192},
    { 224, 808, 240},
    { 112, 776, 336},
    { 176, 872, 272},
    { 240, 840, 288},
    { 240, 896, 304},
    { 280, 944, 240},
    { 304, 864, 232},
    { 352, 848, 176},
    { 336, 704, 144},
    { 232, 1128, 240},
    { 184, 1000, 256},
    { 168, 1192, 168},
    { 32, 1320, 512},
    { 80, 1096, 0},
    { 272, 536, 16},
    // 41 seconds
    { 192, 536, 160},
    { 120, 824, 200},
    { -40, 1144, 96},
    { 104, 1008, -32},
    { 176, 808, -104},
    { 200, 760, -72},
    { 208, 864, -40},
    { 232, 856, -32},
    { 232, 944, 48},
    { 248, 864, 72},
    { 160, 1144, 344},
    { 184, 1360, 456},
    { -120, 1416, 576},
    { 48, 1416, 320},
    { 192, 768, 304},
    { 192, 808, 248},
    { 96, 776, 344},
    { 144, 792, 288},
    { 160, 784, 320},
    { 168, 864, 288},
    { 208, 864, 312},
    { 240, 856, 272},
    { 296, 832, 232},
    { 312, 864, 328},
    { 232, 1104, 296},
    // 42 seconds
    { 144, 1072, 336},
    { 104, 1128, 200},
    { 96, 1288, 328},
    { -168, 1160, 320},
    { 32, 1152, -104},
    { 88, 608, 56},
    { 48, 728, 96},
    { 88, 848, 96},
    { 48, 976, 152},
    { 104, 976, 80},
    { 160, 840, 32},
    { 160, 808, 64},
    { 184, 840, 72},
    { 200, 792, 48},
    { 160, 776, -8},
    { 216, 1048, 176},
    { 208, 944, 248},
    { 200, 1056, 168},
    { 160, 1416, 472},
    { -56, 1376, 568},
    { 64, 1248, 320},
    { 88, 904, 344},
    { 32, 808, 296},
    { 96, 728, 288},
    { 160, 728, 304},
    // 43 seconds
    { 184, 792, 336},
    { 200, 848, 344},
    { 248, 896, 304},
    { 224, 864, 272},
    { 256, 968, 72},
    { 160, 992, 264},
    { 152, 1016, 248},
    { 152, 1032, 248},
    { 112, 1456, 504},
    { -8, 968, 304},
    { 232, 856, -104},
    { 208, 552, 112},
    { 128, 816, 152},
    { -8, 1072, 184},
    { 112, 1008, 152},
    { 168, 832, 64},
    { 168, 808, 48},
    { 200, 800, 80},
    { 200, 832, 64},
    { 248, 984, 48},
    { 184, 840, 8},
    { 128, 1168, 208},
    { 168, 904, 232},
    { 256, 1384, 424},
    { -216, 1432, 536},
    // 44 seconds
    { 16, 1384, 264},
    { 96, 800, 248},
    { 96, 776, 248},
    { 112, 784, 232},
    { 152, 760, 288},
    { 160, 816, 304},
    { 192, 904, 296},
    { 216, 920, 256},
    { 248, 856, 264},
    { 272, 888, 216},
    { 256, 920, 176},
    { 184, 960, 224},
    { 208, 1064, 176},
    { 312, 1224, 328},
    { -104, 1248, 328},
    { 200, 1080, -64},
    { 240, 504, 40},
    { 232, 688, 144},
    { 80, 936, 200},
    { 0, 1112, 40},
    { 184, 992, 40},
    { 152, 784, 24},
    { 208, 744, 16},
    { 248, 784, 88},
    { 264, 816, 32},
    // 45 seconds
    { 248, 856, 64},
    { 296, 880, 72},
    { 208, 872, 128},
    { 200, 928, -72},
    { 256, 1488, 432},
    { -80, 1328, 576},
    { 136, 1320, 296},
    { 160, 744, 240},
    { 168, 808, 256},
    { 152, 760, 288},
    { 192, 808, 312},
    { 208, 864, 336},
    { 176, 936, 296},
    { 192, 904, 328},
    { 232, 872, 272},
    { 264, 880, 280},
    { 288, 864, 256},
    { 312, 904, 240},
    { 328, 984, 272},
    { 160, 976, 256},
    { 120, 1224, 200},
    { 176, 1432, 456},
    { -112, 1072, 224},
    { 72, 888, -16},
    { 176, 536, 64},
    // 46 seconds
    { 80, 752, 136},
    { -88, 1160, 136},
    { 0, 1144, 104},
    { 48, 880, 24},
    { 104, 808, 0},
    { 112, 792, 48},
    { 136, 848, 48},
    { 184, 776, 224},
    { 208, 768, -104},
    { 136, 1016, 40},
    { 120, 704, 248},
    { 264, 1352, 168},
    { -168, 1752, 376},
    { -56, 1400, 272},
    { 176, 784, 152},
    { 184, 672, 192},
    { 96, 872, 224},
    { 8, 976, 280},
    { 72, 984, 328},
    { 152, 944, 256},
    { 224, 840, 256},
    { 280, 864, 248},
    { 256, 896, 248},
    { 192, 968, 216},
    { 160, 1040, 224},
    // 47 seconds
    { 96, 984, 136},
    { 240, 1096, 216},
    { -296, 1272, -24},
    { 0, 1184, -144},
    { 152, 568, 16},
    { 152, 728, 48},
    { 80, 864, 112},
    { 96, 968, -8},
    { 136, 888, 32},
    { 160, 848, -64},
    { 192, 816, -16},
    { 216, 792, -16},
    { 240, 840, -40},
    { 224, 952, 104},
    { 280, 928, 144},
    { 184, 1112, 128},
    { 224, 952, 176},
    { 232, 1760, 232},
    { 56, 1160, 432},
    { 240, 944, 144},
    { 232, 808, 216},
    { 104, 784, 264},
    { 168, 808, 264},
    { 184, 856, 272},
    { 192, 928, 296},
    // 48 seconds
    { 232, 944, 264},
    { 304, 872, 216},
    { 328, 840, 200},
    { 352, 880, 144},
    { 264, 1016, 184},
    { 168, 1080, 192},
    { 136, 1096, 144},
    { 112, 1336, 304},
    { -96, 1200, 144},
    { 176, 808, -264},
    { 104, 632, 168},
    { 96, 832, 80},
    { 64, 1008, 88},
    { 40, 1064, 48},
    { 96, 968, -16},
    { 128, 776, -8},
    { 160, 760, 40},
    { 232, 776, 32},
    { 288, 808, 24},
    { 216, 784, 32},
    { 184, 904, 72},
    { 160, 1024, 160},
    { 160, 1016, 176},
    { 144, 1720, 232},
    { -72, 1352, 568},
    // 49 seconds
    { 112, 1176, 232},
    { 176, 784, 264},
    { 136, 808, 264},
    { 128, 792, 264},
    { 176, 768, 256},
    { 192, 864, 248},
    { 192, 904, 288},
    { 248, 888, 232},
    { 288, 880, 232},
    { 312, 888, 232},
    { 328, 872, 208},
    { 264, 1096, 192},
    { 176, 1000, 192},
    { 216, 1048, 224},
    { 216, 1360, 328},
    { -32, 1024, 296},
    { 176, 816, -48},
    { 152, 576, 64},
    { 96, 760, 144},
    { -8, 1112, 128},
    { 24, 1048, 120},
    { 120, 936, -8},
    { 128, 840, 40},
    { 192, 840, 96},
    { 256, 848, 48},
    // 50 seconds
    { 216, 912, 168},
    { 216, 920, 144},
    { 216, 1040, 112},
    { 176, 1072, 80},
    { 208, 1160, 208},
    { 48, 1328, 344},
    { 56, 1256, 328},
    { 168, 880, 208},
    { 160, 840, 232},
    { 64, 800, 296},
    { 120, 848, 232},
    { 160, 816, 256},
    { 176, 872, 264},
    { 192, 904, 248},
    { 272, 880, 216},
    { 288, 904, 208},
    { 296, 992, 184},
    { 272, 976, 184},
    { 176, 1080, 160},
    { 136, 1096, 136},
    { 80, 1144, 184},
    { -224, 1288, 160},
    { -56, 1296, 8},
    { 56, 608, 112},
    { 40, 848, 56},
    // 51 seconds
    { 56, 816, 40},
    { -16, 936, 136},
    { 40, 928, 48},
    { 96, 872, 64},
    { 160, 824, 32},
    { 200, 800, 16},
    { 264, 792, 40},
    { 256, 824, -8},
    { 264, 936, 136},
    { 208, 1008, 128},
    { 240, 968, 200},
    { 256, 1336, 304},
    { -48, 1408, 488},
    { 48, 1272, 256},
    { 120, 920, 272},
    { 56, 888, 352},
    { 104, 808, 272},
    { 120, 752, 224},
    { 120, 832, 272},
    { 120, 896, 288},
    { 176, 896, 256},
    { 216, 888, 224},
    { 224, 912, 232},
    { 256, 920, 192},
    { 280, 928, 208},
    // 52 seconds
    { 240, 1080, 192},
    { 192, 928, -128},
    { 152, 1096, 312},
    { -104, 1312, 280},
    { -224, 1320, 224},
    { -72, 960, -32},
    { -152, 784, 48},
    { -112, 808, 112},
    { -56, 872, 88},
    { 16, 856, 64},
    { 72, 880, 8},
    { 120, 928, 48},
    { 160, 872, 72},
    { 216, 880, 64},
    { 272, 864, 40},
    { 312, 880, 48},
    { 248, 840, 40},
    { 224, 968, 88},
    { 224, 1016, 200},
    { 232, 1296, 240},
    { 120, 1232, 424},
    { 96, 1360, 344},
    { 64, 984, 216},
    { 128, 832, 216},
    { 128, 808, 240},
    // 53 seconds
    { 128, 776, 280},
    { 184, 824, 248},
    { 208, 864, 272},
    { 176, 904, 296},
    { 232, 896, 232},
    { 264, 896, 264},
    { 304, 928, 200},
    { 304, 896, 224},
    { 280, 992, 232},
    { 200, 992, 376},
    { 168, 1128, 336},
    { 104, 1224, 296},
    { 8, 1168, 272},
    { -40, 1048, 144},
    { 64, 824, 8},
    { 40, 760, 48},
    { 64, 880, 80},
    { 88, 952, 56},
    { 120, 872, 32},
    { 152, 904, 8},
    { 208, 808, 24},
    { 248, 856, -16},
    { 264, 840, 40},
    { 288, 848, 32},
    { 320, 944, 56},
    // 54 seconds
    { 272, 984, -104},
    { 216, 1152, 16},
    { 192, 1064, 320},
    { 80, 1392, 368},
    { 72, 1224, 360},
    { 160, 952, 216},
    { 136, 840, 256},
    { 200, 800, 216},
    { 208, 768, 200},
    { 216, 840, 248},
    { 200, 912, 272},
    { 248, 896, 224},
    { 296, 944, 208},
    { 304, 880, 232},
    { 304, 904, 216},
    { 208, 1000, 192},
    { 192, 720, 24},
    { 152, 1144, 296},
    { 32, 1016, 136},
    { 32, 1392, 160},
    { 32, 1256, 16},
    { 56, 880, -16},
    { 40, 776, 0},
    { 64, 784, 24},
    { 128, 792, 48},
    // 55 seconds
    { 168, 792, 88},
    { 248, 912, 24},
    { 288, 968, 24},
    { 288, 976, 0},
    { 280, 840, 8},
    { 248, 776, -8},
    { 288, 952, 8},
    { 128, 856, -24},
    { 168, 984, 120},
    { 176, 1144, 192},
    { 160, 1232, 408},
    { -8, 1416, 336},
    { 120, 1136, 256},
    { 152, 928, 280},
    { 80, 912, 328},
    { 136, 896, 256},
    { 152, 864, 240},
    { 136, 872, 256},
    { 192, 872, 232},
    { 248, 864, 280},
    { 256, 888, 264},
    { 280, 880, 240},
    { 288, 936, 256},
    { 280, 976, 200},
    { 272, 928, 296},
    // 56 seconds
    { 272, 960, 24},
    { 184, 912, 128},
    { 120, 1272, 160},
    { -96, 1232, 200},
    { 0, 960, 40},
    { 48, 792, -16},
    { 8, 800, 56},
    { 56, 904, 64},
    { 88, 920, 8},
    { 136, 888, 56},
    { 184, 936, 32},
    { 200, 856, 64},
    { 232, 784, -32},
    { 304, 832, 64},
    { 272, 816, -8},
    { 256, 976, -64},
    { 240, 992, 112},
    { 176, 1112, 112},
    { 184, 1240, 216},
    { 176, 1200, 328},
    { 176, 1200, 272},
    { 192, 896, 160},
    { 232, 760, 192},
    { 176, 880, 248},
    { 152, 920, 232},
    // 57 seconds
    { 224, 888, 200},
    { 232, 912, 200},
    { 248, 864, 192},
    { 256, 872, 160},
    { 280, 896, 168},
    { 256, 904, 200},
    { 224, 984, 136},
    { 208, 1168, 96},
    { 88, 1112, -8},
    { 72, 1448, 40},
    { -8, 1112, 152},
    { 64, 896, 32},
    { 80, 864, 24},
    { 64, 816, 24},
    { 112, 880, 8},
    { 112, 848, 16},
    { 168, 816, 16},
    { 216, 840, -16},
    { 240, 864, -16},
    { 256, 864, -32},
    { 216, 904, -8},
    { 264, 1120, 56},
    { 216, 1136, 136},
    { 328, 1264, 272},
    { 200, 1184, 368},
    // 58 seconds
    { 168, 1224, 240},
    { 240, 928, 232},
    { 200, 888, 296},
    { 176, 824, 256},
    { 232, 760, 240},
    { 248, 784, 288},
    { 272, 864, 280},
    { 280, 904, 272},
    { 320, 816, 232},
    { 344, 896, 184},
    { 296, 912, 200},
    { 280, 1136, 168},
    { 192, 888, -192},
    { 144, 1104, 200},
    { 88, 1336, 224},
    { 16, 1152, 208},
    { 32, 952, 40},
    { 104, 800, -40},
    { 80, 792, 56},
    { 160, 792, -8},
    { 184, 784, 32},
    { 232, 816, 40},
    { 208, 840, 56},
    { 224, 816, -48},
    { 208, 856, 32},
    // 59 seconds
    { 208, 840, 80},
    { 192, 1088, 80},
    { 224, 1072, 136},
    { 200, 1384, 224},
    { 56, 1328, 368},
    { 160, 1104, 208},
    { 216, 936, 200},
    { 96, 872, 320},
    { 112, 872, 240},
    { 136, 736, 240},
    { 160, 768, 256},
    { 192, 808, 280},
    { 240, 752, 232},
    { 232, 1000, 256},
    { 240, 944, 304},
    { 240, 1040, 232},
    { 176, 1056, 224},
    { 152, 1120, 184},
    { 88, 1224, 256},
    { -56, 1096, 280},
    { 128, 1080, -48},
    { 104, 712, 88},
    { 56, 896, 56},
    { 56, 928, 80},
    { 80, 904, 48},
    // 60 seconds
    // elapsed: 1 minutes
    { 120, 840, 88},
    { 144, 888, 96},
    { 144, 896, 48},
    { 160, 832, 160},
    { 152, 960, -40},
    { 184, 912, 32},
    { 184, 1000, 80},
    { 176, 1032, 80},
    { 192, 1224, 200},
    { 64, 1280, 384},
    { 192, 1096, 280},
    { 264, 936, 256},
    { 144, 888, 328},
    { 168, 856, 288},
    { 184, 768, 256},
    { 200, 816, 256},
    { 248, 888, 256},
    { 256, 904, 248},
    { 280, 896, 216},
    { 296, 848, 224},
    { 280, 968, 168},
    { 208, 968, 200},
    { 184, 1048, 288},
    { 80, 1272, 224},
    { 40, 1400, 224},
    // 61 seconds
    { -40, 1200, 120},
    { 8, 848, -8},
    { 56, 768, -32},
    { 16, 840, 24},
    { 48, 848, 48},
    { 96, 920, 24},
    { 152, 848, 48},
    { 184, 872, 24},
    { 224, 840, 24},
    { 280, 776, -32},
    { 216, 792, 0},
    { 200, 992, 136},
    { 232, 1008, 128},
    { 208, 1120, 136},
    { 248, 1336, 224},
    { 8, 1424, 432},
    { 144, 1336, 224},
    { 192, 880, 216},
    { 120, 864, 216},
    { 80, 784, 272},
    { 144, 712, 232},
    { 176, 776, 280},
    { 216, 832, 280},
    { 256, 888, 264},
    { 288, 848, 272},
    // 62 seconds
    { 328, 896, 160},
    { 352, 736, 272},
    { 376, 1072, 48},
    { 232, 968, 88},
    { 208, 1136, 184},
    { 168, 1424, 368},
    { -16, 1280, 248},
    { 40, 1144, -48},
    { 24, 816, 0},
    { 24, 792, 0},
    { 72, 824, 40},
    { 104, 784, 0},
    { 168, 792, 24},
    { 168, 776, 40},
    { 216, 816, 8},
    { 248, 688, -64},
    { 272, 840, 40},
    { 256, 936, 120},
    { 232, 1040, 104},
    { 232, 1200, 216},
    { 64, 1672, 288},
    { 40, 1432, 312},
    { 144, 968, 200},
    { 104, 968, 160},
    { 24, 784, 280},
    // 63 seconds
    { 96, 720, 200},
    { 128, 760, 200},
    { 136, 832, 288},
    { 176, 896, 232},
    { 248, 864, 224},
    { 280, 864, 200},
    { 360, 896, 72},
    { 352, 888, 200},
    { 320, 1216, -72},
    { 168, 1136, 80},
    { 104, 1296, 264},
    { 0, 1176, 184},
    { 32, 944, 48},
    { 40, 856, 24},
    { 24, 800, 88},
    { 112, 856, 16},
    { 128, 832, 24},
    { 184, 840, 0},
    { 224, 840, -8},
    { 248, 824, -8},
    { 248, 824, 152},
    { 208, 880, -104},
    { 248, 864, 72},
    { 200, 992, 56},
    { 216, 1024, 160},
    // 64 seconds
    { 96, 1328, 192},
    { 40, 1320, 304},
    { 120, 1184, 176},
    { 72, 1048, 240},
    { 64, 936, 248},
    { 168, 864, 192},
    { 200, 776, 192},
    { 216, 880, 200},
    { 208, 920, 240},
    { 232, 880, 232},
    { 264, 896, 200},
    { 288, 872, 192},
    { 312, 856, 136},
    { 272, 904, 128},
    { 208, 904, 216},
    { 136, 1144, 0},
    { 128, 992, 224},
    { -56, 1360, 56},
    { -8, 1176, -64},
    { 40, 808, -96},
    { 16, 856, -48},
    { 48, 856, -24},
    { 56, 848, -8},
    { 88, 864, 8},
    { 136, 888, -8},
    // 65 seconds
    { 152, 904, -24},
    { 176, 888, 64},
    { 224, 1032, -80},
    { 176, 816, -32},
    { 208, 920, 16},
    { 224, 1000, 16},
    { 256, 1024, 144},
    { 64, 1400, 152},
    { 24, 1320, 352},
    { 104, 1176, 200},
    { 136, 976, 152},
    { 24, 896, 216},
    { 64, 840, 200},
    { 144, 776, 184},
    { 136, 840, 216},
    { 160, 920, 216},
    { 184, 888, 192},
    { 216, 888, 168},
    { 248, 880, 152},
    { 232, 872, 144},
    { 160, 968, 176},
    { 184, 1056, 128},
    { -40, 1200, 176},
    { -152, 1336, 136},
    { -16, 1240, -8},
    // 66 seconds
    { -8, 856, 24},
    { 32, 912, -40},
    { 32, 816, -8},
    { 0, 856, 8},
    { 24, 808, -8},
    { 56, 872, -32},
    { 96, 904, -40},
    { 160, 888, -48},
    { 184, 824, -56},
    { 208, 768, 104},
    { 160, 1056, -48},
    { 112, 960, 88},
    { 32, 1320, 192},
    { -128, 1304, 376},
    { -64, 1304, 320},
    { -80, 1168, 272},
    { -120, 1008, 280},
    { -64, 888, 224},
    { -16, 776, 208},
    { 16, 816, 176},
    { 8, 856, 216},
    { 24, 920, 232},
    { 8, 1032, 248},
    { 16, 1024, 296},
    { 48, 952, 264},
    // 67 seconds
    { 48, 856, 256},
    { 136, 800, 232},
    { 200, 760, 184},
    { 200, 712, 160},
    { 192, 1328, 272},
    { -48, 1080, 240},
    { 80, 1240, -200},
    { 96, 888, -152},
    { 64, 872, -352},
    { 192, 1192, -488},
    { 144, 808, -272},
    { -24, 464, -472},
    { -80, 584, -856},
    { -152, 424, -912},
    { -216, 352, -888},
    { -136, 192, -864},
    { -104, 120, -872},
    { -128, 16, -856},
    { -144, -64, -872},
    { -160, -112, -888},
    { -128, -88, -928},
    { -128, -96, -904},
    { -72, -72, -912},
    { -80, -88, -912},
    { -48, -96, -904},
    // 68 seconds
    { -72, -88, -904},
    { -48, -72, -912},
    { -56, -136, -880},
    { -272, -240, -824},
    { -144, -40, -896},
    { -80, -64, -920},
    { -48, -184, -888},
    { -96, -128, -912},
    { -144, -128, -904},
    { -72, -160, -944},
    { -128, -112, -912},
    { -144, -128, -920},
    { -104, -160, -960},
    { -176, -88, -896},
    { -136, -176, -928},
    { -136, -200, -888},
    { -136, -264, -904},
    { -144, -192, -896},
    { -104, -280, -904},
    { -112, -288, -888},
    { -128, -256, -896},
    { -104, -256, -896},
    { -80, -280, -896},
    { -80, -256, -912},
    { -104, -288, -896},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 15:44:37 local
AccelRawData *activity_sample_walk_100_pbl_25672_3(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25672_3
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 0, 8, -960},
    { -8, -32, -920},
    { -24, -24, -936},
    { 0, -32, -944},
    { -40, -16, -944},
    { -24, -40, -952},
    { -16, -184, -840},
    { -24, -32, -960},
    { 24, -80, -936},
    { 0, -80, -920},
    { -16, 40, -936},
    { 16, -72, -944},
    { 16, -112, -936},
    { 16, -8, -936},
    { 40, -112, -912},
    { 0, -80, -904},
    { 24, -104, -920},
    { 8, -8, -928},
    { -168, -192, -848},
    { -56, -136, -952},
    { 0, -80, -952},
    { -176, -96, -920},
    { 288, -24, -1120},
    { -40, -672, -1064},
    { -16, 224, -952},
    // 1 seconds
    { -56, -24, -832},
    { -16, 136, -776},
    { 64, 488, -832},
    { 144, 344, -568},
    { 240, 784, -504},
    { 368, 856, -512},
    { 272, 728, -232},
    { 408, 1296, -576},
    { 272, 776, -136},
    { 272, 1152, -240},
    { 232, 856, -96},
    { 208, 936, -32},
    { 248, 936, -128},
    { 232, 912, 24},
    { 224, 840, 56},
    { 192, 928, 200},
    { 184, 928, 336},
    { 200, 896, 312},
    { 208, 920, 456},
    { 216, 840, 600},
    { 240, 896, 592},
    { 240, 784, 728},
    { 256, 824, 720},
    { 240, 736, 824},
    { 208, 696, 816},
    // 2 seconds
    { 152, 584, 816},
    { 0, 448, 1056},
    { 88, 656, 1008},
    { 48, 464, 1136},
    { 72, 560, 904},
    { 72, 408, 1136},
    { 88, 424, 816},
    { 128, 408, 848},
    { 176, 440, 792},
    { 208, 512, 728},
    { 224, 472, 824},
    { 240, 528, 824},
    { 248, 536, 864},
    { 272, 608, 896},
    { 256, 688, 1032},
    { 192, 656, 928},
    { 88, 616, 1048},
    { 64, 696, 1096},
    { -152, 544, 1144},
    { -16, 888, 640},
    { 8, 544, 712},
    { 0, 592, 664},
    { 0, 544, 752},
    { 32, 600, 696},
    { 56, 600, 704},
    // 3 seconds
    { 80, 616, 664},
    { 96, 616, 704},
    { 104, 624, 760},
    { 80, 664, 696},
    { 120, 744, 808},
    { 152, 728, 944},
    { 88, 664, 984},
    { 56, 776, 1424},
    { 8, 648, 1080},
    { 56, 576, 1040},
    { 64, 376, 872},
    { 128, 432, 760},
    { 120, 368, 864},
    { 136, 416, 816},
    { 160, 432, 928},
    { 176, 448, 856},
    { 232, 488, 840},
    { 208, 560, 904},
    { 96, 728, 1032},
    { 40, 704, 1024},
    { 40, 704, 1080},
    { -184, 384, 1408},
    { 136, 960, 456},
    { 128, 432, 688},
    { 192, 456, 680},
    // 4 seconds
    { 144, 536, 768},
    { 136, 584, 704},
    { 136, 592, 712},
    { 160, 616, 640},
    { 176, 616, 704},
    { 216, 568, 704},
    { 256, 584, 784},
    { 224, 472, 592},
    { 112, 736, 1000},
    { 112, 736, 1520},
    { -72, 664, 1056},
    { 96, 616, 1064},
    { 96, 448, 848},
    { 160, 384, 776},
    { 112, 368, 792},
    { 128, 416, 808},
    { 152, 408, 912},
    { 192, 504, 816},
    { 256, 456, 864},
    { 304, 512, 776},
    { 216, 504, 888},
    { 88, 808, 936},
    { 8, 728, 1072},
    { -24, 824, 1344},
    { -112, 584, 1288},
    // 5 seconds
    { 144, 896, 440},
    { 168, 352, 672},
    { 200, 520, 728},
    { 120, 544, 704},
    { 136, 632, 688},
    { 128, 528, 632},
    { 120, 568, 616},
    { 144, 560, 760},
    { 184, 584, 768},
    { 208, 648, 752},
    { 192, 832, 880},
    { 96, 736, 1080},
    { -192, 704, 1464},
    { -32, 848, 1280},
    { 32, 488, 1008},
    { 96, 440, 736},
    { 152, 320, 696},
    { 160, 424, 632},
    { 224, 336, 792},
    { 232, 480, 808},
    { 256, 544, 792},
    { 232, 544, 824},
    { 168, 640, 864},
    { 56, 808, 888},
    { -64, 824, 1424},
    // 6 seconds
    { -96, 536, 888},
    { 112, 728, 648},
    { 80, 584, 744},
    { 64, 560, 808},
    { 48, 576, 664},
    { 56, 608, 696},
    { 88, 552, 616},
    { 120, 616, 616},
    { 152, 568, 688},
    { 200, 632, 752},
    { 192, 752, 856},
    { 48, 744, 1024},
    { 104, 912, 1384},
    { -72, 592, 1256},
    { 24, 784, 1112},
    { 24, 552, 1032},
    { 8, 560, 648},
    { 56, 384, 664},
    { 144, 416, 608},
    { 200, 384, 832},
    { 192, 488, 864},
    { 200, 544, 888},
    { 152, 512, 800},
    { 80, 808, 920},
    { -24, 728, 992},
    // 7 seconds
    { -48, 840, 944},
    { -120, 640, 1160},
    { 40, 896, 632},
    { -8, 672, 736},
    { 64, 592, 520},
    { 152, 592, 488},
    { 200, 512, 440},
    { 216, 608, 536},
    { 184, 624, 616},
    { 176, 688, 680},
    { 208, 744, 752},
    { 240, 784, 784},
    { 64, 744, 976},
    { 216, 1176, 1592},
    { -192, 816, 1144},
    { 8, 864, 1032},
    { 64, 504, 744},
    { 112, 480, 664},
    { 120, 416, 552},
    { 208, 424, 600},
    { 248, 528, 792},
    { 200, 592, 688},
    { 296, 608, 784},
    { 216, 648, 824},
    { 128, 784, 872},
    // 8 seconds
    { 104, 776, 856},
    { 16, 904, 1496},
    { 112, 888, 648},
    { 224, 776, 544},
    { 288, 464, 560},
    { 288, 608, 512},
    { 288, 528, 608},
    { 264, 536, 560},
    { 240, 600, 584},
    { 232, 616, 544},
    { 280, 688, 664},
    { 280, 816, 688},
    { 224, 904, 808},
    { 216, 864, 1048},
    { 144, 920, 1208},
    { 160, 896, 888},
    { 144, 616, 1048},
    { 160, 688, 704},
    { 136, 352, 688},
    { 208, 472, 424},
    { 248, 472, 504},
    { 296, 536, 600},
    { 344, 688, 720},
    { 320, 720, 832},
    { 208, 792, 616},
    // 9 seconds
    { 112, 872, 936},
    { 120, 944, 992},
    { -40, 752, 1456},
    { 184, 984, 176},
    { 152, 528, 720},
    { 200, 488, 560},
    { 240, 680, 584},
    { 256, 568, 648},
    { 232, 728, 576},
    { 264, 640, 592},
    { 280, 592, 528},
    { 264, 760, 544},
    { 280, 912, 664},
    { 208, 816, 824},
    { 208, 1104, 1160},
    { -88, 704, 1168},
    { 128, 1016, 872},
    { 96, 504, 792},
    { 152, 472, 576},
    { 176, 464, 536},
    { 232, 464, 568},
    { 320, 528, 680},
    { 328, 640, 736},
    { 424, 552, 648},
    { 240, 984, 840},
    // 10 seconds
    { 168, 712, 968},
    { 240, 752, 904},
    { 224, 728, 1576},
    { 40, 1048, 520},
    { 8, 504, 824},
    { 152, 504, 576},
    { 184, 544, 576},
    { 256, 400, 696},
    { 232, 576, 672},
    { 248, 464, 720},
    { 288, 568, 720},
    { 320, 576, 744},
    { 344, 600, 872},
    { 216, 648, 936},
    { 240, 664, 1288},
    { -16, 480, 1440},
    { 112, 624, 1056},
    { 152, 328, 1032},
    { 168, 448, 776},
    { 192, 304, 768},
    { 216, 360, 712},
    { 240, 368, 904},
    { 224, 400, 872},
    { 232, 480, 968},
    { 160, 432, 880},
    // 11 seconds
    { 112, 584, 1072},
    { 88, 624, 1000},
    { 80, 728, 1312},
    { -64, 352, 952},
    { 104, 808, 624},
    { 168, 360, 744},
    { 120, 600, 560},
    { 160, 488, 704},
    { 208, 560, 688},
    { 176, 584, 696},
    { 184, 608, 744},
    { 240, 632, 720},
    { 224, 616, 872},
    { 216, 728, 960},
    { 88, 576, 1008},
    { 248, 776, 1224},
    { -56, 536, 1264},
    { 48, 560, 1240},
    { 64, 424, 960},
    { 56, 328, 808},
    { 104, 336, 736},
    { 176, 352, 696},
    { 208, 400, 816},
    { 192, 432, 856},
    { 160, 504, 1000},
    // 12 seconds
    { 144, 560, 1056},
    { 80, 680, 1072},
    { 64, 672, 832},
    { 88, 632, 1168},
    { -80, 608, 1112},
    { 48, 816, 976},
    { 160, 640, 704},
    { 176, 544, 560},
    { 224, 456, 504},
    { 232, 488, 608},
    { 248, 528, 552},
    { 192, 624, 912},
    { 288, 672, 776},
    { 256, 776, 880},
    { 160, 600, 912},
    { 216, 888, 888},
    { 88, 880, 1304},
    { -8, 832, 1272},
    { 32, 624, 1112},
    { 48, 496, 824},
    { 168, 440, 720},
    { 224, 416, 616},
    { 288, 416, 672},
    { 248, 536, 752},
    { 200, 584, 808},
    // 13 seconds
    { 144, 672, 856},
    { 96, 736, 984},
    { 24, 968, 808},
    { -32, 872, 1392},
    { 24, 816, 840},
    { 144, 800, 712},
    { 232, 584, 592},
    { 256, 664, 560},
    { 312, 552, 472},
    { 344, 584, 520},
    { 328, 632, 560},
    { 272, 672, 568},
    { 328, 664, 616},
    { 312, 680, 680},
    { 336, 680, 936},
    { 208, 928, 832},
    { 120, 1112, 1592},
    { 32, 768, 1248},
    { 144, 656, 952},
    { 168, 496, 864},
    { 208, 432, 624},
    { 208, 440, 600},
    { 280, 432, 680},
    { 272, 488, 800},
    { 296, 560, 744},
    // 14 seconds
    { 312, 544, 832},
    { 232, 640, 888},
    { 160, 744, 880},
    { 160, 872, 856},
    { 56, 752, 1208},
    { 152, 1048, 712},
    { 224, 688, 680},
    { 240, 632, 552},
    { 280, 608, 464},
    { 296, 536, 448},
    { 304, 576, 464},
    { 304, 624, 448},
    { 320, 632, 464},
    { 328, 656, 608},
    { 312, 808, 664},
    { 272, 696, 808},
    { 272, 920, 944},
    { 104, 704, 1360},
    { 104, 936, 1264},
    { 72, 672, 1080},
    { 8, 584, 848},
    { 128, 536, 712},
    { 208, 424, 568},
    { 200, 488, 704},
    { 216, 496, 744},
    // 15 seconds
    { 184, 608, 784},
    { 152, 664, 904},
    { 16, 680, 864},
    { 48, 888, 792},
    { -32, 840, 1384},
    { -104, 904, 864},
    { 32, 824, 672},
    { 40, 648, 664},
    { 64, 696, 528},
    { 160, 648, 520},
    { 160, 640, 504},
    { 152, 664, 584},
    { 168, 712, 616},
    { 216, 704, 672},
    { 248, 752, 712},
    { 128, 760, 792},
    { 120, 784, 1032},
    { -136, 928, 1408},
    { -128, 920, 1224},
    { -72, 536, 952},
    { 24, 448, 768},
    { 88, 400, 680},
    { 120, 432, 616},
    { 200, 448, 672},
    { 176, 496, 744},
    // 16 seconds
    { 160, 560, 872},
    { 136, 576, 856},
    { 104, 640, 1032},
    { 8, 624, 712},
    { 88, 888, 888},
    { -248, 432, 1224},
    { 0, 1128, 656},
    { 56, 608, 680},
    { 80, 648, 576},
    { 120, 552, 544},
    { 200, 568, 576},
    { 200, 600, 672},
    { 176, 680, 624},
    { 216, 616, 664},
    { 256, 632, 624},
    { 216, 624, 744},
    { 104, 824, 704},
    { 96, 752, 1216},
    { -48, 968, 1408},
    { -48, 808, 1208},
    { -8, 472, 936},
    { 40, 536, 824},
    { 96, 328, 752},
    { 168, 400, 616},
    { 208, 424, 744},
    // 17 seconds
    { 208, 432, 824},
    { 184, 552, 864},
    { 200, 608, 840},
    { 120, 632, 920},
    { 136, 792, 896},
    { 128, 720, 816},
    { -56, 584, 1416},
    { 120, 1064, 744},
    { 176, 536, 664},
    { 208, 616, 584},
    { 160, 536, 632},
    { 240, 592, 528},
    { 224, 552, 672},
    { 208, 608, 608},
    { 240, 632, 680},
    { 280, 632, 728},
    { 248, 720, 784},
    { 208, 760, 856},
    { 184, 728, 800},
    { 272, 856, 1328},
    { -176, 712, 1296},
    { -32, 736, 1296},
    { 0, 528, 936},
    { 0, 440, 840},
    { 96, 392, 656},
    // 18 seconds
    { 160, 336, 656},
    { 152, 384, 752},
    { 176, 424, 824},
    { 224, 520, 872},
    { 240, 520, 936},
    { 152, 584, 960},
    { 80, 784, 896},
    { 56, 768, 1088},
    { -64, 720, 1240},
    { 24, 912, 784},
    { 32, 576, 696},
    { 88, 584, 656},
    { 112, 560, 616},
    { 168, 536, 624},
    { 184, 552, 648},
    { 192, 576, 680},
    { 184, 624, 696},
    { 192, 664, 784},
    { 248, 736, 792},
    { 216, 776, 776},
    { 176, 648, 992},
    { 272, 792, 1264},
    { -80, 672, 1296},
    { 48, 624, 1128},
    { 40, 528, 1008},
    // 19 seconds
    { 24, 472, 832},
    { 112, 360, 696},
    { 176, 368, 616},
    { 176, 368, 728},
    { 208, 520, 840},
    { 224, 480, 856},
    { 184, 504, 912},
    { 64, 712, 952},
    { 32, 736, 912},
    { 8, 880, 1304},
    { -80, 688, 896},
    { 48, 808, 664},
    { 168, 592, 600},
    { 136, 592, 552},
    { 200, 584, 576},
    { 248, 528, 664},
    { 264, 696, 608},
    { 248, 632, 680},
    { 296, 656, 704},
    { 248, 632, 648},
    { 168, 656, 744},
    { 208, 712, 904},
    { -8, 704, 1240},
    { 8, 832, 1176},
    { 8, 576, 1136},
    // 20 seconds
    { 0, 456, 912},
    { 80, 520, 720},
    { 160, 360, 640},
    { 192, 368, 624},
    { 192, 432, 784},
    { 192, 488, 848},
    { 168, 592, 968},
    { 72, 648, 968},
    { 80, 856, 856},
    { 32, 792, 1032},
    { -48, 808, 1280},
    { 32, 920, 736},
    { 80, 552, 664},
    { 152, 624, 600},
    { 160, 520, 512},
    { 224, 504, 488},
    { 216, 536, 648},
    { 240, 600, 608},
    { 240, 728, 744},
    { 232, 648, 648},
    { 192, 768, 832},
    { 216, 712, 752},
    { 312, 960, 1272},
    { -160, 728, 1400},
    { 32, 824, 1248},
    // 21 seconds
    { 64, 560, 984},
    { 80, 368, 744},
    { 184, 400, 520},
    { 216, 336, 616},
    { 232, 440, 648},
    { 184, 432, 824},
    { 216, 560, 736},
    { 64, 688, 960},
    { 16, 736, 808},
    { 112, 800, 960},
    { -40, 728, 1344},
    { 88, 1128, 664},
    { 136, 640, 712},
    { 136, 600, 640},
    { 184, 608, 448},
    { 272, 560, 488},
    { 288, 560, 592},
    { 296, 632, 616},
    { 312, 712, 784},
    { 320, 648, 680},
    { 312, 752, 808},
    { 336, 728, 808},
    { 424, 984, 1296},
    { -40, 664, 1224},
    { 112, 728, 1080},
    // 22 seconds
    { 200, 536, 872},
    { 104, 344, 760},
    { 224, 400, 592},
    { 296, 328, 616},
    { 304, 440, 720},
    { 248, 480, 944},
    { 336, 536, 952},
    { 280, 688, 1144},
    { 112, 680, 944},
    { 104, 824, 800},
    { 72, 776, 872},
    { -16, 768, 1232},
    { 8, 960, 624},
    { 112, 672, 616},
    { 176, 496, 504},
    { 248, 488, 464},
    { 312, 520, 584},
    { 264, 600, 624},
    { 240, 664, 624},
    { 264, 688, 648},
    { 232, 768, 784},
    { 216, 624, 624},
    { 176, 888, 880},
    { 176, 632, 824},
    { 288, 952, 1280},
    // 23 seconds
    { -216, 680, 1304},
    { 48, 824, 1264},
    { 104, 504, 832},
    { 176, 368, 536},
    { 232, 360, 528},
    { 320, 336, 688},
    { 376, 496, 792},
    { 336, 512, 960},
    { 280, 504, 816},
    { 208, 648, 872},
    { 160, 648, 1024},
    { 176, 704, 968},
    { 144, 640, 1392},
    { 24, 880, 632},
    { 104, 640, 744},
    { 160, 576, 624},
    { 208, 552, 440},
    { 272, 440, 504},
    { 264, 528, 560},
    { 248, 552, 640},
    { 216, 608, 680},
    { 288, 664, 656},
    { 288, 720, 1008},
    { 224, 736, 952},
    { 256, 848, 984},
    // 24 seconds
    { 160, 936, 1560},
    { 24, 776, 1112},
    { 112, 576, 1048},
    { 96, 376, 728},
    { 136, 392, 704},
    { 232, 400, 656},
    { 272, 368, 696},
    { 232, 456, 840},
    { 248, 528, 768},
    { 168, 592, 976},
    { 120, 712, 944},
    { 56, 848, 856},
    { 56, 808, 1336},
    { -64, 752, 896},
    { 112, 816, 560},
    { 184, 576, 640},
    { 152, 504, 416},
    { 240, 536, 560},
    { 256, 520, 592},
    { 248, 616, 632},
    { 200, 664, 608},
    { 224, 712, 584},
    { 232, 752, 760},
    { 200, 824, 968},
    { 136, 872, 1144},
    // 25 seconds
    { 8, 976, 1432},
    { -40, 688, 1120},
    { 72, 480, 896},
    { 104, 512, 768},
    { 136, 400, 696},
    { 176, 424, 600},
    { 216, 432, 648},
    { 248, 504, 752},
    { 224, 584, 792},
    { 224, 624, 840},
    { 136, 744, 888},
    { 112, 880, 848},
    { 16, 792, 1096},
    { -136, 584, 1160},
    { 88, 904, 608},
    { 152, 472, 680},
    { 144, 608, 504},
    { 192, 472, 568},
    { 264, 512, 520},
    { 288, 568, 688},
    { 256, 632, 544},
    { 232, 688, 744},
    { 280, 728, 384},
    { 288, 792, 896},
    { 216, 872, 984},
    // 26 seconds
    { 216, 800, 944},
    { 304, 928, 1760},
    { -8, 560, 952},
    { 56, 616, 1144},
    { 96, 416, 784},
    { 96, 384, 640},
    { 168, 408, 688},
    { 208, 448, 568},
    { 232, 584, 808},
    { 200, 616, 728},
    { 168, 688, 824},
    { 88, 800, 784},
    { 104, 880, 792},
    { 24, 792, 1112},
    { -56, 616, 912},
    { 168, 896, 760},
    { 168, 544, 592},
    { 120, 672, 528},
    { 216, 552, 472},
    { 200, 536, 456},
    { 192, 600, 568},
    { 216, 688, 600},
    { 232, 736, 632},
    { 312, 712, 648},
    { 320, 824, 792},
    // 27 seconds
    { 208, 760, 872},
    { 408, 1008, 1392},
    { -120, 752, 1104},
    { 176, 784, 1296},
    { 120, 488, 824},
    { 64, 536, 648},
    { 80, 408, 600},
    { 136, 448, 528},
    { 168, 480, 584},
    { 168, 616, 672},
    { 136, 632, 624},
    { 72, 776, 744},
    { 24, 728, 792},
    { 104, 896, 1296},
    { -64, 760, 1072},
    { 200, 1016, 520},
    { 160, 656, 592},
    { 120, 616, 344},
    { 224, 568, 496},
    { 208, 520, 544},
    { 240, 720, 728},
    { 192, 688, 600},
    { 280, 688, 656},
    { 344, 688, 568},
    { 200, 912, 1088},
    // 28 seconds
    { 120, 880, 792},
    { 0, 1168, 1584},
    { -56, 1000, 1064},
    { -32, 528, 984},
    { 48, 592, 688},
    { 72, 408, 640},
    { 160, 416, 608},
    { 208, 480, 664},
    { 224, 512, 792},
    { 200, 616, 832},
    { 184, 672, 832},
    { 80, 752, 712},
    { 48, 856, 800},
    { -8, 920, 928},
    { -176, 624, 1168},
    { 168, 1096, 376},
    { 168, 512, 704},
    { 232, 664, 440},
    { 256, 632, 496},
    { 320, 576, 536},
    { 320, 672, 496},
    { 280, 688, 576},
    { 312, 680, 512},
    { 328, 776, 680},
    { 320, 832, 880},
    // 29 seconds
    { 136, 896, 720},
    { 304, 936, 1080},
    { -112, 744, 1008},
    { 176, 880, 1080},
    { 112, 552, 920},
    { 56, 544, 592},
    { 144, 352, 640},
    { 256, 448, 456},
    { 272, 448, 720},
    { 272, 592, 760},
    { 200, 688, 848},
    { 104, 856, 848},
    { 112, 744, 848},
    { 168, 856, 808},
    { 96, 832, 1144},
    { 0, 760, 832},
    { 176, 888, 680},
    { 184, 688, 616},
    { 160, 656, 472},
    { 232, 560, 456},
    { 224, 576, 504},
    { 232, 664, 504},
    { 256, 696, 560},
    { 304, 752, 560},
    { 336, 720, 664},
    // 30 seconds
    { 208, 776, 792},
    { 280, 840, 960},
    { 48, 856, 1104},
    { 232, 792, 1032},
    { 160, 648, 928},
    { 120, 448, 648},
    { 152, 448, 704},
    { 192, 456, 600},
    { 224, 464, 720},
    { 216, 536, 776},
    { 232, 592, 704},
    { 144, 696, 824},
    { 8, 800, 888},
    { 48, 920, 824},
    { -8, 904, 1176},
    { -104, 752, 576},
    { 104, 912, 648},
    { 152, 720, 624},
    { 120, 696, 512},
    { 240, 584, 488},
    { 240, 536, 440},
    { 232, 560, 592},
    { 240, 688, 544},
    { 224, 616, 800},
    { 224, 704, 688},
    // 31 seconds
    { 32, 800, 984},
    { 184, 816, 992},
    { 32, 800, 1648},
    { 80, 616, 1136},
    { 40, 440, 1048},
    { 120, 408, 768},
    { 192, 344, 688},
    { 168, 304, 672},
    { 264, 456, 816},
    { 200, 328, 760},
    { 216, 472, 944},
    { 192, 488, 992},
    { 184, 608, 1096},
    { 80, 656, 1056},
    { 72, 624, 1408},
    { -24, 664, 808},
    { 72, 624, 776},
    { 128, 528, 712},
    { 72, 552, 664},
    { 144, 552, 640},
    { 224, 440, 600},
    { 240, 512, 672},
    { 264, 624, 736},
    { 256, 592, 704},
    { 280, 592, 704},
    // 32 seconds
    { 264, 648, 1016},
    { 160, 544, 968},
    { 296, 744, 1480},
    { -120, 584, 1168},
    { 80, 568, 1272},
    { 112, 392, 864},
    { 112, 392, 736},
    { 160, 368, 680},
    { 216, 304, 736},
    { 272, 368, 896},
    { 256, 408, 864},
    { 200, 496, 848},
    { 216, 560, 936},
    { 120, 616, 1080},
    { 104, 776, 1008},
    { 8, 744, 1472},
    { 16, 664, 712},
    { 136, 648, 632},
    { 192, 456, 464},
    { 192, 608, 632},
    { 256, 520, 648},
    { 224, 592, 616},
    { 240, 608, 560},
    { 248, 632, 640},
    { 344, 688, 648},
    // 33 seconds
    { 360, 768, 800},
    { 320, 912, 1120},
    { 208, 928, 944},
    { 160, 872, 1624},
    { 48, 680, 1104},
    { 104, 520, 1120},
    { 160, 456, 808},
    { 144, 376, 696},
    { 232, 280, 704},
    { 264, 392, 672},
    { 256, 368, 832},
    { 264, 520, 864},
    { 192, 552, 824},
    { 152, 744, 888},
    { 88, 712, 960},
    { 136, 776, 848},
    { 0, 776, 1544},
    { 64, 896, 592},
    { 104, 568, 800},
    { 96, 528, 712},
    { 120, 544, 656},
    { 192, 512, 424},
    { 264, 512, 624},
    { 256, 624, 528},
    { 272, 680, 600},
    // 34 seconds
    { 296, 752, 600},
    { 272, 784, 808},
    { 184, 832, 896},
    { 104, 808, 1144},
    { 112, 976, 1496},
    { -16, 816, 1136},
    { 120, 608, 976},
    { 128, 496, 728},
    { 120, 424, 768},
    { 184, 392, 648},
    { 216, 400, 712},
    { 232, 456, 800},
    { 200, 520, 816},
    { 192, 592, 976},
    { 152, 712, 888},
    { 80, 728, 864},
    { 112, 832, 920},
    { -136, 840, 1480},
    { 16, 1128, 680},
    { 40, 664, 552},
    { 88, 536, 496},
    { 192, 568, 448},
    { 256, 544, 616},
    { 304, 552, 600},
    { 312, 616, 680},
    // 35 seconds
    { 328, 632, 552},
    { 384, 608, 600},
    { 328, 624, 688},
    { 64, 792, 1048},
    { 296, 848, 1232},
    { 88, 888, 1320},
    { 168, 752, 1072},
    { 168, 544, 968},
    { 112, 488, 792},
    { 208, 360, 560},
    { 288, 328, 608},
    { 280, 392, 680},
    { 248, 520, 800},
    { 264, 672, 808},
    { 280, 648, 720},
    { 304, 808, 944},
    { 200, 760, 800},
    { 192, 760, 952},
    { 232, 880, 1408},
    { 80, 944, 720},
    { 32, 608, 672},
    { 120, 592, 528},
    { 96, 664, 488},
    { 144, 624, 464},
    { 208, 656, 512},
    // 36 seconds
    { 240, 720, 504},
    { 240, 704, 544},
    { 280, 768, 560},
    { 304, 728, 584},
    { 216, 928, 1048},
    { 160, 792, 760},
    { 408, 896, 976},
    { 104, 736, 1024},
    { 224, 720, 1000},
    { 144, 520, 936},
    { 96, 536, 720},
    { 216, 384, 720},
    { 336, 416, 592},
    { 336, 400, 704},
    { 360, 440, 816},
    { 360, 584, 840},
    { 352, 536, 808},
    { 216, 816, 912},
    { 152, 856, 864},
    { 168, 856, 760},
    { 72, 824, 1432},
    { 264, 1040, 608},
    { 232, 520, 520},
    { 304, 624, 472},
    { 272, 568, 464},
    // 37 seconds
    { 320, 656, 504},
    { 304, 408, 568},
    { 336, 744, 464},
    { 304, 608, 616},
    { 416, 736, 536},
    { 424, 816, 864},
    { 208, 720, 728},
    { 504, 1104, 1424},
    { -168, 752, 1200},
    { 320, 744, 1216},
    { 160, 432, 872},
    { 200, 344, 704},
    { 224, 304, 576},
    { 296, 352, 624},
    { 312, 424, 832},
    { 288, 552, 880},
    { 280, 584, 952},
    { 296, 616, 864},
    { 216, 712, 976},
    { 168, 784, 528},
    { 72, 752, 960},
    { -16, 752, 1016},
    { 160, 1064, 664},
    { 232, 680, 496},
    { 192, 656, 456},
    // 38 seconds
    { 280, 504, 504},
    { 344, 584, 488},
    { 320, 576, 640},
    { 296, 696, 544},
    { 320, 696, 632},
    { 392, 696, 576},
    { 344, 752, 816},
    { 216, 672, 608},
    { 432, 960, 1376},
    { -240, 800, 1224},
    { 208, 864, 1208},
    { 136, 504, 672},
    { 144, 432, 656},
    { 224, 368, 648},
    { 272, 448, 664},
    { 288, 432, 816},
    { 272, 568, 824},
    { 312, 568, 912},
    { 280, 624, 832},
    { 192, 632, 744},
    { 160, 808, 752},
    { 136, 808, 952},
    { 32, 800, 1128},
    { 216, 920, 624},
    { 200, 624, 632},
    // 39 seconds
    { 200, 664, 592},
    { 264, 576, 520},
    { 336, 488, 544},
    { 360, 592, 552},
    { 360, 552, 576},
    { 392, 560, 584},
    { 448, 592, 616},
    { 448, 688, 848},
    { 224, 736, 960},
    { 480, 792, 1368},
    { 0, 736, 1104},
    { 280, 528, 1200},
    { 216, 504, 832},
    { 144, 376, 792},
    { 248, 360, 656},
    { 304, 352, 680},
    { 312, 376, 816},
    { 352, 424, 856},
    { 344, 488, 832},
    { 352, 528, 856},
    { 216, 720, 864},
    { 192, 768, 872},
    { 144, 760, 1008},
    { 48, 664, 1064},
    { 200, 976, 744},
    // 40 seconds
    { 184, 568, 704},
    { 232, 712, 504},
    { 304, 584, 560},
    { 360, 544, 472},
    { 400, 512, 536},
    { 408, 568, 520},
    { 472, 632, 624},
    { 496, 600, 632},
    { 440, 664, 656},
    { 240, 624, 848},
    { 472, 880, 1416},
    { -112, 848, 1312},
    { 224, 792, 1272},
    { 104, 504, 784},
    { 168, 392, 808},
    { 224, 392, 488},
    { 320, 384, 712},
    { 392, 464, 672},
    { 392, 496, 856},
    { 400, 576, 864},
    { 344, 600, 792},
    { 296, 736, 848},
    { 208, 880, 824},
    { 248, 936, 1056},
    { -48, 728, 1016},
    // 41 seconds
    { 208, 1112, 528},
    { 184, 624, 472},
    { 160, 608, 432},
    { 264, 624, 368},
    { 320, 440, 632},
    { 304, 680, 504},
    { 256, 576, 576},
    { 384, 736, 376},
    { 424, 752, 552},
    { 392, 840, 536},
    { 240, 1024, 904},
    { 320, 896, 1104},
    { 360, 1128, 1200},
    { 160, 720, 1064},
    { 120, 720, 952},
    { 168, 464, 712},
    { 200, 384, 480},
    { 256, 368, 528},
    { 312, 360, 672},
    { 384, 512, 744},
    { 448, 488, 936},
    { 488, 520, 792},
    { 416, 600, 1016},
    { 224, 616, 696},
    { 216, 648, 1008},
    // 42 seconds
    { 160, 712, 1440},
    { 88, 896, 824},
    { 120, 600, 784},
    { 104, 560, 648},
    { 96, 552, 688},
    { 184, 496, 616},
    { 200, 512, 688},
    { 272, 488, 712},
    { 232, 552, 824},
    { 264, 632, 712},
    { 328, 640, 816},
    { 352, 648, 1000},
    { 248, 568, 1024},
    { 408, 656, 1880},
    { -136, 472, 936},
    { 144, 440, 1088},
    { 192, 328, 784},
    { 160, 320, 832},
    { 176, 288, 776},
    { 232, 280, 808},
    { 296, 272, 824},
    { 288, 360, 888},
    { 312, 408, 872},
    { 304, 432, 968},
    { 216, 496, 1168},
    // 43 seconds
    { 192, 600, 1144},
    { 160, 488, 1376},
    { 40, 608, 1024},
    { 144, 624, 824},
    { 160, 528, 688},
    { 136, 488, 680},
    { 232, 472, 576},
    { 296, 400, 792},
    { 272, 504, 576},
    { 216, 552, 848},
    { 304, 496, 696},
    { 392, 432, 904},
    { 392, 560, 1056},
    { 336, 432, 1104},
    { 304, 536, 1840},
    { 120, 496, 1152},
    { 232, 328, 1104},
    { 256, 264, 800},
    { 264, 224, 800},
    { 264, 264, 664},
    { 296, 256, 864},
    { 296, 248, 944},
    { 344, 312, 944},
    { 360, 336, 856},
    { 392, 336, 1048},
    // 44 seconds
    { 384, 408, 1040},
    { 328, 504, 992},
    { 320, 376, 1232},
    { 120, 424, 1200},
    { 216, 656, 936},
    { 256, 488, 864},
    { 136, 512, 688},
    { 208, 464, 624},
    { 304, 336, 624},
    { 360, 480, 680},
    { 408, 536, 752},
    { 432, 496, 784},
    { 472, 456, 752},
    { 504, 496, 1016},
    { 336, 440, 960},
    { 456, 480, 1416},
    { 136, 392, 1256},
    { 256, 416, 1200},
    { 264, 384, 952},
    { 208, 288, 824},
    { 240, 272, 688},
    { 296, 288, 776},
    { 296, 320, 880},
    { 320, 352, 856},
    { 368, 392, 840},
    // 45 seconds
    { 408, 376, 1024},
    { 296, 512, 1056},
    { 232, 640, 1056},
    { 200, 528, 1280},
    { 72, 464, 1160},
    { 120, 728, 808},
    { 208, 576, 856},
    { 136, 688, 560},
    { 144, 576, 672},
    { 184, 576, 688},
    { 200, 552, 776},
    { 216, 624, 688},
    { 264, 552, 664},
    { 320, 600, 744},
    { 336, 632, 680},
    { 360, 656, 976},
    { 240, 576, 912},
    { 304, 648, 1328},
    { -16, 480, 1336},
    { 160, 528, 1160},
    { 224, 424, 896},
    { 184, 384, 856},
    { 176, 320, 768},
    { 216, 320, 792},
    { 264, 336, 816},
    // 46 seconds
    { 256, 384, 912},
    { 272, 408, 920},
    { 288, 440, 952},
    { 184, 536, 864},
    { 144, 576, 1024},
    { 120, 648, 976},
    { 72, 688, 1048},
    { -80, 488, 1392},
    { 128, 888, 664},
    { 120, 576, 776},
    { 120, 568, 536},
    { 160, 536, 640},
    { 184, 488, 576},
    { 216, 504, 632},
    { 232, 552, 712},
    { 264, 576, 760},
    { 336, 640, 752},
    { 368, 672, 936},
    { 264, 688, 872},
    { 256, 752, 1096},
    { 24, 736, 1360},
    { -24, 592, 1272},
    { 72, 560, 1104},
    { 136, 360, 896},
    { 136, 304, 784},
    // 47 seconds
    { 168, 256, 680},
    { 232, 360, 776},
    { 232, 376, 840},
    { 232, 416, 872},
    { 280, 464, 944},
    { 136, 528, 864},
    { 16, 592, 1072},
    { 32, 712, 904},
    { 48, 568, 1040},
    { 72, 456, 1432},
    { 184, 856, 704},
    { 272, 552, 736},
    { 240, 480, 600},
    { 280, 496, 584},
    { 344, 488, 648},
    { 352, 504, 712},
    { 352, 576, 712},
    { 424, 592, 720},
    { 440, 584, 776},
    { 384, 632, 920},
    { 256, 592, 1016},
    { 288, 768, 1328},
    { -80, 608, 1224},
    { 96, 480, 1168},
    { 120, 296, 992},
    // 48 seconds
    { 144, 264, 768},
    { 208, 320, 776},
    { 304, 264, 752},
    { 352, 328, 832},
    { 336, 296, 872},
    { 424, 304, 976},
    { 440, 432, 864},
    { 424, 352, 872},
    { 328, 544, 992},
    { 232, 568, 1048},
    { 176, 576, 1136},
    { 192, 464, 1312},
    { 208, 624, 752},
    { 224, 344, 832},
    { 304, 456, 800},
    { 192, 456, 808},
    { 232, 512, 784},
    { 256, 496, 752},
    { 304, 424, 792},
    { 304, 512, 760},
    { 304, 520, 800},
    { 312, 528, 792},
    { 288, 536, 968},
    { 200, 520, 1096},
    { 168, 688, 1584},
    // 49 seconds
    { 0, 520, 1232},
    { 152, 384, 1056},
    { 264, 264, 928},
    { 264, 264, 944},
    { 224, 256, 848},
    { 216, 256, 840},
    { 232, 248, 904},
    { 232, 296, 936},
    { 256, 352, 912},
    { 208, 376, 904},
    { 128, 472, 1040},
    { 104, 560, 1032},
    { 136, 640, 976},
    { 48, 576, 1432},
    { 16, 712, 872},
    { 96, 608, 832},
    { 184, 536, 640},
    { 160, 552, 680},
    { 184, 352, 760},
    { 264, 544, 608},
    { 240, 480, 768},
    { 264, 584, 632},
    { 344, 576, 616},
    { 344, 624, 704},
    { 248, 608, 1040},
    // 50 seconds
    { 208, 664, 968},
    { 288, 592, 1656},
    { 32, 608, 1080},
    { 128, 336, 1200},
    { 208, 360, 896},
    { 168, 328, 904},
    { 184, 328, 864},
    { 248, 320, 872},
    { 256, 328, 888},
    { 248, 384, 952},
    { 320, 456, 744},
    { 320, 408, 1000},
    { 176, 616, 944},
    { 176, 704, 1056},
    { 32, 696, 1192},
    { -80, 568, 1016},
    { 56, 880, 624},
    { 160, 496, 752},
    { 160, 648, 544},
    { 264, 536, 656},
    { 264, 496, 616},
    { 256, 552, 744},
    { 240, 552, 656},
    { 376, 576, 688},
    { 440, 616, 696},
    // 51 seconds
    { 448, 584, 768},
    { 368, 704, 848},
    { 368, 712, 1080},
    { 96, 520, 1552},
    { 112, 728, 1088},
    { 192, 408, 944},
    { 152, 384, 888},
    { 160, 344, 872},
    { 208, 376, 744},
    { 256, 304, 872},
    { 240, 360, 880},
    { 232, 384, 920},
    { 248, 400, 896},
    { 176, 472, 1072},
    { 144, 520, 992},
    { 136, 632, 1000},
    { 48, 560, 1576},
    { 16, 824, 880},
    { 64, 632, 1000},
    { 80, 656, 680},
    { 184, 496, 672},
    { 264, 384, 560},
    { 288, 408, 672},
    { 304, 464, 680},
    { 288, 552, 736},
    // 52 seconds
    { 312, 648, 768},
    { 392, 656, 656},
    { 376, 608, 856},
    { 304, 616, 944},
    { 368, 552, 1176},
    { 8, 480, 1432},
    { 152, 600, 1144},
    { 264, 392, 960},
    { 256, 336, 864},
    { 240, 304, 880},
    { 264, 264, 800},
    { 248, 272, 928},
    { 264, 288, 968},
    { 232, 344, 888},
    { 288, 312, 832},
    { 296, 352, 848},
    { 280, 496, 984},
    { 224, 504, 1000},
    { 264, 576, 1248},
    { 192, 632, 1128},
    { 232, 728, 840},
    { 232, 600, 912},
    { 184, 568, 760},
    { 224, 528, 784},
    { 264, 440, 688},
    // 53 seconds
    { 256, 384, 856},
    { 296, 432, 752},
    { 256, 496, 888},
    { 296, 432, 696},
    { 296, 536, 664},
    { 344, 464, 952},
    { 272, 480, 912},
    { 328, 472, 1248},
    { 80, 336, 1472},
    { 216, 504, 1080},
    { 280, 312, 952},
    { 328, 232, 896},
    { 248, 248, 928},
    { 224, 304, 904},
    { 248, 272, 944},
    { 248, 304, 976},
    { 248, 256, 920},
    { 312, 272, 920},
    { 336, 264, 864},
    { 360, 264, 928},
    { 416, 304, 920},
    { 368, 264, 744},
    { 216, 416, 928},
    { 184, 400, 1264},
    { 8, 592, 1112},
    // 54 seconds
    { 24, 664, 1168},
    { -72, 520, 976},
    { -88, 648, 888},
    { 32, 888, 736},
    { 56, 976, 688},
    { 128, 1072, 488},
    { 144, 688, 416},
    { 136, 568, 56},
    { 168, 1008, -304},
    { 184, 872, -336},
    { 160, 760, -464},
    { 192, 872, -592},
    { 256, 496, -400},
    { 272, 888, -624},
    { 264, 384, -432},
    { 352, 736, -712},
    { 360, 400, -568},
    { 200, 480, -664},
    { 216, 624, -864},
    { 136, 416, -808},
    { 136, 480, -896},
    { 72, 280, -896},
    { 48, 320, -944},
    { 32, 88, -792},
    { -128, 24, -1184},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 15:47:31 local
AccelRawData *activity_sample_walk_100_pbl_25672_4(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25672_4
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -144, -104, -928},
    { -152, -112, -904},
    { -160, -112, -896},
    { -168, -120, -896},
    { -192, -104, -904},
    { -184, -88, -920},
    { -176, -72, -912},
    { -184, -56, -928},
    { -192, -72, -928},
    { -192, -48, -920},
    { -176, -80, -920},
    { -160, -56, -912},
    { -120, -56, -920},
    { -128, -40, -920},
    { -184, -32, -912},
    { -128, -96, -912},
    { -160, 64, -920},
    { -104, -112, -920},
    { -168, -104, -928},
    { -72, -64, -928},
    { -160, -136, -904},
    { -136, -184, -888},
    { -160, -128, -920},
    { -112, -360, -936},
    { -136, -152, -960},
    // 1 seconds
    { -184, -256, -880},
    { -120, -288, -840},
    { -96, -232, -832},
    { -88, -152, -872},
    { -96, -192, -856},
    { -88, -200, -904},
    { -88, -208, -936},
    { -40, -272, -936},
    { -176, -112, -1200},
    { -280, 120, -1352},
    { -64, 24, -1056},
    { 40, 152, -1088},
    { 48, 80, -816},
    { 112, 104, -856},
    { 8, 128, -816},
    { 16, 144, -848},
    { 16, 160, -808},
    { 72, 152, -872},
    { 88, 72, -840},
    { 160, 120, -872},
    { 144, 72, -960},
    { -96, 288, -984},
    { -16, 184, -1096},
    { -56, 232, -1128},
    { -128, 200, -1104},
    // 2 seconds
    { -104, 88, -1008},
    { -128, 40, -832},
    { -96, -8, -832},
    { -96, -32, -800},
    { -48, -40, -744},
    { -48, -64, -768},
    { -40, -120, -784},
    { -16, -96, -800},
    { -16, -232, -840},
    { 120, 80, -1096},
    { -24, -56, -1152},
    { 136, 72, -1128},
    { 40, 168, -1256},
    { 224, 240, -1096},
    { 168, 104, -1024},
    { 56, 40, -736},
    { 128, 16, -720},
    { 120, 24, -728},
    { 144, 8, -768},
    { 136, -24, -840},
    { 200, -72, -800},
    { 200, -112, -896},
    { -16, 40, -1008},
    { 40, -8, -1128},
    { -96, 96, -1152},
    // 3 seconds
    { -72, 128, -1096},
    { -40, 72, -984},
    { 32, 0, -880},
    { 48, -88, -752},
    { 88, -80, -752},
    { 80, -144, -712},
    { 64, -144, -768},
    { 40, -152, -832},
    { 136, -512, -616},
    { 80, -104, -1088},
    { 0, -376, -928},
    { 256, 208, -1216},
    { 128, 128, -1176},
    { 320, 344, -1088},
    { 288, 584, -1088},
    { 200, 0, -584},
    { 208, 344, -680},
    { 200, 328, -648},
    { 208, 104, -560},
    { 240, 552, -832},
    { 296, 240, -520},
    { 288, 480, -776},
    { 216, 560, -664},
    { 144, 752, -552},
    { 152, 1224, -176},
    // 4 seconds
    { 64, 1176, -216},
    { 136, 1232, -224},
    { 96, 648, 80},
    { 176, 1104, -224},
    { 176, 616, 48},
    { 256, 728, 32},
    { 184, 928, 0},
    { 184, 832, 16},
    { 280, 1056, 40},
    { 320, 1192, 248},
    { 184, 1056, 416},
    { 368, 1160, 392},
    { 160, 1064, 664},
    { 296, 1312, 304},
    { 224, 936, 432},
    { 256, 736, 152},
    { 280, 760, 184},
    { 272, 640, 304},
    { 288, 848, 272},
    { 256, 848, 240},
    { 296, 832, 208},
    { 312, 1008, 304},
    { 200, 1056, 240},
    { 160, 1248, 64},
    { 56, 960, 520},
    // 5 seconds
    { 64, 1096, 160},
    { 168, 1112, 96},
    { 184, 792, 128},
    { 232, 864, 8},
    { 216, 688, 80},
    { 264, 640, 40},
    { 216, 728, 80},
    { 256, 744, 32},
    { 280, 816, -56},
    { 352, 848, 120},
    { 360, 1176, 248},
    { 272, 1240, 744},
    { 168, 1448, 688},
    { 400, 1320, 504},
    { 264, 888, 432},
    { 248, 864, 232},
    { 272, 640, 224},
    { 280, 600, 328},
    { 288, 816, 328},
    { 208, 816, 496},
    { 304, 912, 256},
    { 328, 856, 408},
    { 232, 968, 320},
    { 264, 1240, 312},
    { 112, 984, 224},
    // 6 seconds
    { 104, 1200, 296},
    { 96, 992, 256},
    { 224, 952, 120},
    { 256, 744, 56},
    { 328, 672, 8},
    { 304, 624, 120},
    { 304, 760, 104},
    { 272, 824, 96},
    { 320, 848, 120},
    { 384, 952, 208},
    { 272, 1040, 192},
    { 424, 1128, 400},
    { 304, 1240, 592},
    { 232, 1208, 552},
    { 304, 1152, 472},
    { 248, 752, 272},
    { 248, 680, 264},
    { 272, 624, 264},
    { 296, 688, 312},
    { 272, 856, 376},
    { 216, 960, 240},
    { 288, 856, 296},
    { 216, 1168, 200},
    { 104, 1248, 312},
    { 104, 1112, 320},
    // 7 seconds
    { -32, 1152, 352},
    { 168, 1048, 64},
    { 224, 816, 112},
    { 336, 648, 72},
    { 360, 672, 64},
    { 360, 664, 176},
    { 360, 728, 112},
    { 360, 824, 48},
    { 344, 816, 56},
    { 360, 1064, 64},
    { 288, 1064, 304},
    { 240, 1232, 480},
    { 264, 1464, 528},
    { 304, 1192, 480},
    { 208, 1056, 408},
    { 176, 752, 288},
    { 216, 672, 184},
    { 232, 584, 240},
    { 256, 736, 248},
    { 200, 888, 328},
    { 176, 952, 208},
    { 144, 992, 144},
    { 48, 1064, 272},
    { 136, 1184, 272},
    { 24, 1152, 320},
    // 8 seconds
    { 208, 1216, 24},
    { 248, 912, 200},
    { 272, 784, 0},
    { 328, 672, 24},
    { 320, 648, 112},
    { 304, 808, 160},
    { 304, 848, 112},
    { 384, 784, 96},
    { 424, 1080, 112},
    { 352, 1120, 184},
    { 400, 920, 416},
    { 336, 1360, 568},
    { 176, 1160, 536},
    { 192, 1112, 512},
    { 128, 768, 328},
    { 256, 568, 256},
    { 296, 624, 272},
    { 344, 712, 296},
    { 296, 808, 384},
    { 312, 1000, 312},
    { 232, 1040, 360},
    { 160, 1264, 264},
    { 256, 1112, 248},
    { 120, 928, 432},
    { 336, 1008, 72},
    // 9 seconds
    { 336, 832, 200},
    { 392, 776, 136},
    { 336, 656, 48},
    { 408, 600, 120},
    { 416, 696, 120},
    { 432, 784, 120},
    { 408, 752, 128},
    { 520, 944, 112},
    { 448, 864, 232},
    { 472, 808, 392},
    { 416, 1632, 736},
    { 56, 1296, 904},
    { 200, 1208, 624},
    { 264, 680, 272},
    { 352, 576, 264},
    { 368, 608, 264},
    { 384, 640, 424},
    { 328, 792, 512},
    { 296, 992, 464},
    { 216, 1080, 384},
    { 160, 1096, 336},
    { 224, 1008, 328},
    { 168, 1000, 448},
    { 256, 1152, 152},
    { 296, 880, 224},
    // 10 seconds
    { 272, 816, 16},
    { 296, 656, 24},
    { 320, 568, 80},
    { 336, 744, 64},
    { 288, 792, 152},
    { 360, 880, 168},
    { 392, 1024, 96},
    { 448, 960, 480},
    { 320, 1392, 632},
    { 312, 1200, 600},
    { 344, 1176, 528},
    { 200, 1008, 488},
    { 176, 688, 376},
    { 264, 656, 208},
    { 240, 584, 280},
    { 232, 696, 384},
    { 272, 840, 384},
    { 248, 848, 528},
    { 176, 1216, 352},
    { 72, 1136, 240},
    { 56, 1032, 432},
    { 128, 1072, 224},
    { 208, 1088, 80},
    { 152, 888, 128},
    { 208, 792, 56},
    // 11 seconds
    { 296, 616, 72},
    { 328, 600, 136},
    { 360, 704, 136},
    { 352, 784, 208},
    { 400, 904, 184},
    { 352, 840, 280},
    { 208, 1224, 280},
    { 240, 1224, 856},
    { -56, 1376, 496},
    { 184, 1088, 408},
    { 8, 1088, 400},
    { 88, 800, 288},
    { 160, 560, 312},
    { 168, 712, 288},
    { 184, 856, 416},
    { 184, 880, 464},
    { 240, 936, 384},
    { 176, 1048, 416},
    { 80, 1024, 176},
    { 80, 1336, 472},
    { 8, 944, 504},
    { 80, 1376, -48},
    { 96, 936, 144},
    { 176, 768, 104},
    { 224, 648, 64},
    // 12 seconds
    { 272, 544, 96},
    { 256, 656, 112},
    { 264, 680, 144},
    { 312, 768, 160},
    { 376, 840, 112},
    { 384, 1008, 360},
    { 216, 1064, 280},
    { 400, 1344, 584},
    { -56, 1312, 496},
    { 120, 1312, 384},
    { 24, 944, 432},
    { 128, 760, 168},
    { 200, 624, 176},
    { 224, 672, 216},
    { 208, 752, 280},
    { 128, 984, 352},
    { 144, 1016, 344},
    { -16, 1168, 144},
    { 176, 1152, 88},
    { 8, 1080, 520},
    { 160, 1048, 256},
    { 248, 1056, 136},
    { 272, 752, 192},
    { 296, 648, 40},
    { 360, 544, 96},
    // 13 seconds
    { 384, 512, 160},
    { 432, 768, 112},
    { 312, 672, 104},
    { 424, 992, 168},
    { 296, 1088, 336},
    { 168, 1136, 376},
    { 112, 1640, 696},
    { -24, 1376, 464},
    { 48, 1312, 384},
    { 56, 992, 208},
    { 136, 672, 224},
    { 240, 616, 136},
    { 192, 576, 264},
    { 216, 768, 232},
    { 192, 848, 320},
    { 112, 888, 288},
    { 16, 1312, 160},
    { 0, 1096, 344},
    { -48, 1464, 416},
    { 88, 1096, 184},
    { 104, 1024, 144},
    { 112, 864, 88},
    { 248, 608, 64},
    { 320, 584, 80},
    { 320, 592, 200},
    // 14 seconds
    { 336, 816, 152},
    { 360, 856, 200},
    { 304, 784, 464},
    { 272, 1840, 144},
    { 120, 632, 600},
    { 360, 1376, 408},
    { 136, 1160, 528},
    { 96, 1256, 712},
    { 88, 1000, 424},
    { 96, 656, 360},
    { 184, 608, 192},
    { 272, 616, 136},
    { 200, 688, 320},
    { 144, 800, 224},
    { 120, 1096, 256},
    { 32, 1112, 280},
    { 80, 1168, 232},
    { 88, 1200, 448},
    { 72, 1032, 232},
    { 216, 1040, 80},
    { 200, 784, 248},
    { 256, 776, 24},
    { 320, 592, 104},
    { 312, 632, 176},
    { 400, 808, 88},
    // 15 seconds
    { 368, 736, 216},
    { 440, 952, 216},
    { 392, 1016, 248},
    { 184, 1096, 336},
    { 248, 1360, 528},
    { 32, 1400, 528},
    { 80, 1272, 440},
    { 32, 1040, 416},
    { 72, 832, 232},
    { 168, 632, 176},
    { 192, 576, 192},
    { 112, 728, 256},
    { 32, 920, 296},
    { -24, 1120, 344},
    { -80, 1256, 344},
    { -32, 1280, 400},
    { -56, 1176, 440},
    { 304, 1072, -8},
    { 200, 744, 184},
    { 184, 800, 56},
    { 248, 688, 32},
    { 248, 648, 128},
    { 264, 832, 80},
    { 208, 744, 200},
    { 352, 816, -8},
    // 16 seconds
    { 416, 1176, 304},
    { 168, 1024, 336},
    { 408, 1456, 592},
    { -64, 1240, 480},
    { 184, 1344, 432},
    { 48, 880, 352},
    { 128, 608, 136},
    { 160, 600, 256},
    { 168, 568, 248},
    { 120, 856, 384},
    { 16, 976, 224},
    { 8, 1120, 328},
    { 96, 1040, 200},
    { 112, 1136, 104},
    { 0, 976, 504},
    { 184, 1080, 64},
    { 256, 928, 160},
    { 272, 720, 88},
    { 280, 584, 176},
    { 336, 560, 88},
    { 312, 800, 152},
    { 272, 896, 240},
    { 304, 904, 240},
    { 424, 1000, 336},
    { 232, 1160, 224},
    // 17 seconds
    { 352, 984, 488},
    { 256, 1496, 672},
    { 40, 1360, 520},
    { 40, 1176, 536},
    { 88, 864, 208},
    { 88, 592, 280},
    { 232, 544, 48},
    { 200, 608, 224},
    { 144, 776, 288},
    { 48, 992, 360},
    { -32, 1200, 344},
    { 8, 1056, 296},
    { -40, 1352, 632},
    { 160, 1048, -136},
    { 208, 1008, 64},
    { 192, 792, 184},
    { 248, 776, 8},
    { 296, 704, 112},
    { 296, 568, 280},
    { 328, 784, -8},
    { 288, 768, 96},
    { 408, 744, 240},
    { 328, 1208, 368},
    { 232, 1144, 480},
    { 64, 1776, 712},
    // 18 seconds
    { 104, 1160, 424},
    { 160, 1096, 320},
    { 136, 776, 208},
    { 200, 672, 256},
    { 224, 576, 192},
    { 200, 744, 264},
    { 48, 880, 360},
    { 24, 1064, 392},
    { 48, 1232, 352},
    { 88, 1120, 240},
    { 32, 1152, 248},
    { -24, 944, 376},
    { 208, 1032, 8},
    { 192, 800, 160},
    { 232, 608, 32},
    { 296, 560, 112},
    { 384, 600, 240},
    { 352, 736, 144},
    { 368, 1016, 176},
    { 488, 992, 360},
    { 264, 1264, 344},
    { 488, 1208, 400},
    { 248, 1376, 504},
    { 192, 1200, 320},
    { 96, 960, 376},
    // 19 seconds
    { 32, 680, 168},
    { 48, 512, 192},
    { 104, 640, 120},
    { -16, 704, 280},
    { -24, 968, 288},
    { -136, 1200, 376},
    { -80, 1136, 272},
    { -88, 1264, 352},
    { 0, 1000, 280},
    { 240, 1144, 0},
    { 176, 880, 232},
    { 232, 672, 16},
    { 312, 640, 128},
    { 320, 592, 184},
    { 352, 776, 272},
    { 232, 984, 24},
    { 408, 1016, 288},
    { 240, 1216, 376},
    { 176, 1328, 584},
    { -80, 1544, 496},
    { 72, 1184, 384},
    { 56, 1000, 304},
    { 88, 776, 184},
    { 120, 592, 232},
    { 120, 656, 184},
    // 20 seconds
    { 136, 712, 296},
    { 64, 824, 272},
    { 120, 976, 192},
    { -72, 1040, 368},
    { 72, 1216, 112},
    { -64, 1272, 672},
    { 96, 1056, 80},
    { 256, 1040, 0},
    { 256, 728, 88},
    { 280, 632, 56},
    { 328, 568, 144},
    { 328, 616, 176},
    { 320, 800, 160},
    { 328, 688, 144},
    { 400, 912, 88},
    { 288, 1184, 408},
    { 232, 1088, 624},
    { 64, 1880, 576},
    { 232, 1272, 512},
    { 128, 1152, 472},
    { 144, 856, 224},
    { 184, 584, 256},
    { 192, 520, 200},
    { 168, 592, 448},
    { 40, 776, 256},
    // 21 seconds
    { 48, 968, 352},
    { -56, 1168, 360},
    { 64, 1128, 240},
    { -72, 1248, 456},
    { 16, 1040, 208},
    { 160, 1096, 64},
    { 80, 880, 160},
    { 152, 784, 24},
    { 208, 648, 120},
    { 248, 672, 176},
    { 272, 832, 192},
    { 256, 824, 176},
    { 304, 808, 184},
    { 336, 984, 264},
    { 112, 1080, 296},
    { 256, 1080, 496},
    { 8, 1728, 696},
    { 72, 1344, 464},
    { 104, 1144, 424},
    { 80, 808, 272},
    { 112, 704, 216},
    { 152, 616, 272},
    { 120, 696, 328},
    { 144, 768, 344},
    { 112, 872, 328},
    // 22 seconds
    { 48, 976, 304},
    { 0, 1168, 352},
    { 64, 1016, 192},
    { 32, 1352, 336},
    { 128, 1088, 216},
    { 96, 1008, 152},
    { 80, 880, 208},
    { 136, 768, 128},
    { 240, 624, 72},
    { 264, 568, 128},
    { 312, 752, 96},
    { 272, 784, 224},
    { 304, 1072, 128},
    { 368, 960, 376},
    { 200, 1200, 328},
    { 224, 1528, 664},
    { -48, 1400, 504},
    { 152, 1312, 384},
    { 80, 960, 328},
    { 168, 704, 152},
    { 152, 632, 224},
    { 184, 616, 200},
    { 240, 712, 232},
    { 168, 808, 312},
    { 120, 944, 296},
    // 23 seconds
    { 112, 1144, 320},
    { 96, 1008, 328},
    { 56, 1288, 416},
    { 80, 1288, 320},
    { 152, 1152, 128},
    { 168, 864, 136},
    { 240, 768, 0},
    { 304, 584, 16},
    { 336, 488, 120},
    { 360, 656, 120},
    { 296, 720, 200},
    { 360, 760, 144},
    { 432, 936, 216},
    { 280, 1088, 336},
    { 184, 1080, 360},
    { 232, 1632, 640},
    { -16, 1440, 360},
    { 80, 1264, 552},
    { 120, 952, 192},
    { 152, 712, 192},
    { 200, 672, 168},
    { 232, 544, 184},
    { 208, 640, 264},
    { 120, 880, 256},
    { 72, 960, 304},
    // 24 seconds
    { 24, 1080, 392},
    { -8, 1136, -80},
    { -152, 1440, 368},
    { -24, 1200, 112},
    { -128, 1160, 136},
    { 24, 952, 80},
    { 120, 864, -40},
    { 248, 608, -24},
    { 280, 560, -16},
    { 320, 600, 128},
    { 312, 768, 128},
    { 312, 808, 128},
    { 376, 840, 152},
    { 352, 1072, 216},
    { 216, 1016, 120},
    { 272, 1328, 456},
    { 0, 1432, 360},
    { 56, 1376, 440},
    { 16, 1176, 328},
    { -40, 816, 208},
    { 96, 600, 168},
    { 120, 632, 192},
    { 80, 624, 312},
    { 104, 808, 304},
    { 104, 864, 288},
    // 25 seconds
    { 112, 952, 296},
    { 16, 1096, 216},
    { 40, 1200, 48},
    { -96, 1240, 384},
    { 8, 1320, 40},
    { -16, 1240, 120},
    { 88, 920, 72},
    { 176, 872, 80},
    { 288, 648, 40},
    { 264, 608, 112},
    { 296, 624, 72},
    { 264, 736, 88},
    { 296, 768, 96},
    { 352, 824, 80},
    { 392, 920, 192},
    { 272, 1000, 72},
    { 296, 1224, 344},
    { 176, 1728, 672},
    { 72, 1288, 448},
    { 80, 1160, 448},
    { 56, 800, 248},
    { 104, 688, 208},
    { 208, 592, 192},
    { 248, 704, 224},
    { 224, 816, 320},
    // 26 seconds
    { 200, 984, 248},
    { 240, 840, 296},
    { 184, 1128, 160},
    { 64, 1128, 208},
    { -8, 1176, 280},
    { 0, 1288, 368},
    { 128, 1048, 168},
    { 104, 960, 104},
    { 200, 816, 112},
    { 296, 720, 64},
    { 344, 616, 80},
    { 336, 616, 128},
    { 344, 704, 136},
    { 328, 776, 160},
    { 400, 824, 136},
    { 384, 976, 200},
    { 360, 1240, 296},
    { 256, 1064, 400},
    { 168, 1560, 584},
    { -144, 1408, 400},
    { 16, 1216, 384},
    { 72, 840, 272},
    { 24, 688, 240},
    { 120, 600, 248},
    { 152, 680, 224},
    // 27 seconds
    { 184, 728, 312},
    { 176, 848, 304},
    { 200, 952, 272},
    { 128, 1008, 328},
    { 88, 1096, 88},
    { 120, 1200, 144},
    { -40, 1136, 456},
    { 80, 1128, 88},
    { 88, 1064, 184},
    { 160, 920, 56},
    { 248, 832, -32},
    { 288, 560, 104},
    { 320, 680, 72},
    { 320, 840, 16},
    { 280, 848, 96},
    { 368, 944, 40},
    { 384, 984, 136},
    { 368, 1064, 248},
    { 336, 1080, 512},
    { 48, 1656, 504},
    { 168, 1168, 424},
    { 64, 1160, 328},
    { 96, 840, 176},
    { 144, 584, 224},
    { 168, 696, 168},
    // 28 seconds
    { 160, 744, 176},
    { 168, 744, 256},
    { 248, 848, 200},
    { 176, 1000, 328},
    { 96, 992, 144},
    { 136, 1128, 272},
    { 96, 1136, 352},
    { 248, 1200, 0},
    { 88, 896, 280},
    { 168, 1024, 112},
    { 200, 936, 64},
    { 256, 760, 72},
    { 320, 672, 56},
    { 352, 712, 144},
    { 376, 712, 168},
    { 416, 840, 144},
    { 408, 912, 184},
    { 408, 864, 304},
    { 208, 1176, 208},
    { 144, 1200, 584},
    { -192, 1528, 512},
    { 120, 1248, 424},
    { -16, 1040, 504},
    { 104, 952, 296},
    { 216, 728, 240},
    // 29 seconds
    { 200, 680, 288},
    { 192, 704, 248},
    { 152, 768, 272},
    { 96, 880, 224},
    { 80, 640, 232},
    { 16, 1280, 264},
    { -64, 1200, 160},
    { -248, 1240, 296},
    { 0, 1184, 120},
    { 24, 1024, -24},
    { 64, 992, 0},
    { 176, 760, -48},
    { 256, 608, -32},
    { 280, 648, 64},
    { 320, 736, 96},
    { 256, 808, 56},
    { 344, 952, 16},
    { 360, 888, -168},
    { 232, 1112, 200},
    { 128, 928, 192},
    { 112, 1424, 352},
    { -104, 1432, 288},
    { -56, 1288, 440},
    { 0, 1064, 288},
    { 40, 744, 192},
    // 30 seconds
    { 64, 624, 168},
    { 72, 696, 208},
    { 0, 752, 256},
    { -32, 864, 200},
    { -40, 944, 248},
    { 8, 1040, 216},
    { 120, 1160, 40},
    { -32, 1032, 400},
    { 112, 1360, 120},
    { 104, 1216, 176},
    { 136, 1120, 56},
    { 208, 752, -24},
    { 288, 608, -16},
    { 336, 648, 16},
    { 328, 664, 112},
    { 328, 768, 80},
    { 336, 808, 120},
    { 360, 896, 56},
    { 264, 960, 16},
    { 208, 1032, 144},
    { 168, 1496, 504},
    { -184, 1544, 288},
    { 16, 1272, 336},
    { 24, 1016, 192},
    { 32, 680, 96},
    // 31 seconds
    { 152, 656, 144},
    { 200, 704, 192},
    { 176, 856, 248},
    { 192, 896, 272},
    { 232, 888, 272},
    { 192, 976, 56},
    { 112, 1128, 208},
    { 120, 1040, 184},
    { 32, 1176, 296},
    { 88, 1088, 192},
    { 160, 1000, 56},
    { 216, 936, 88},
    { 272, 792, -8},
    { 360, 576, 16},
    { 400, 696, 56},
    { 408, 704, 64},
    { 384, 760, 40},
    { 408, 760, 16},
    { 464, 1160, 224},
    { 184, 1296, 240},
    { 272, 1240, 544},
    { 104, 1624, 392},
    { 200, 1112, 360},
    { 120, 1120, 336},
    { 88, 760, 184},
    // 32 seconds
    { 192, 672, 112},
    { 216, 624, 184},
    { 216, 712, 248},
    { 192, 808, 320},
    { 200, 912, 240},
    { 200, 968, 416},
    { 208, 1184, 104},
    { 176, 1184, 336},
    { 48, 1368, 360},
    { 312, 976, 96},
    { 256, 744, 136},
    { 280, 840, 64},
    { 320, 648, 56},
    { 368, 624, 144},
    { 400, 800, 88},
    { 344, 728, 104},
    { 408, 872, -16},
    { 416, 768, 168},
    { 328, 1176, 104},
    { 160, 1144, 200},
    { 208, 1648, 560},
    { 40, 1304, 200},
    { 136, 1064, 376},
    { 120, 896, 232},
    { 136, 632, 144},
    // 33 seconds
    { 160, 648, 240},
    { 160, 680, 232},
    { 88, 792, 280},
    { 128, 944, 264},
    { 112, 968, 184},
    { 96, 1184, 192},
    { 72, 1168, 184},
    { 24, 1376, 360},
    { 184, 1120, -8},
    { 96, 920, 8},
    { 8, 920, 72},
    { 128, 824, -32},
    { 232, 680, -40},
    { 264, 640, -48},
    { 320, 672, -8},
    { 352, 784, -16},
    { 408, 760, 56},
    { 408, 872, 56},
    { 264, 1136, 168},
    { 232, 1104, 448},
    { -48, 2088, 576},
    { 56, 1168, 424},
    { 112, 1232, 232},
    { 144, 808, 176},
    { 176, 672, 208},
    // 34 seconds
    { 216, 688, 192},
    { 216, 656, 232},
    { 200, 776, 280},
    { 192, 768, 304},
    { 208, 1040, 296},
    { 72, 1088, 328},
    { 184, 1232, 160},
    { 32, 1192, 384},
    { 216, 984, 64},
    { 200, 992, 120},
    { 240, 936, 80},
    { 272, 720, 32},
    { 304, 640, 16},
    { 328, 608, 72},
    { 336, 736, 88},
    { 304, 880, 64},
    { 360, 824, -8},
    { 400, 872, 104},
    { 344, 1096, 48},
    { 240, 1040, 168},
    { 296, 1496, 344},
    { 40, 1392, 288},
    { 208, 1200, 328},
    { 208, 1112, 248},
    { 72, 776, 248},
    // 35 seconds
    { 136, 648, 152},
    { 160, 664, 168},
    { 160, 640, 240},
    { 144, 864, 232},
    { 176, 864, 192},
    { 128, 1128, 192},
    { 96, 1136, 216},
    { 8, 1352, 288},
    { 64, 1232, 184},
    { 112, 1032, -24},
    { 72, 880, 32},
    { 144, 752, -48},
    { 248, 672, -64},
    { 296, 584, 40},
    { 328, 696, 80},
    { 368, 776, 72},
    { 384, 784, 24},
    { 472, 1056, -56},
    { 416, 1208, 120},
    { 280, 1136, 216},
    { 232, 1768, 528},
    { 64, 1128, 360},
    { 184, 1200, 256},
    { 176, 848, 176},
    { 152, 592, 208},
    // 36 seconds
    { 232, 560, 160},
    { 264, 640, 176},
    { 192, 744, 320},
    { 112, 992, 48},
    { 32, 1032, 320},
    { 8, 1216, 168},
    { 56, 1264, 264},
    { 40, 1168, 432},
    { 264, 1056, -176},
    { 224, 856, 72},
    { 264, 840, -56},
    { 280, 608, -16},
    { 368, 592, 56},
    { 472, 712, 24},
    { 448, 720, 80},
    { 504, 800, -48},
    { 568, 1008, 152},
    { 432, 1144, 216},
    { 416, 1176, 528},
    { 72, 1664, 488},
    { 128, 1120, 296},
    { 144, 1040, 256},
    { 96, 704, 248},
    { 216, 592, 208},
    { 280, 568, 216},
    // 37 seconds
    { 288, 648, 264},
    { 256, 912, 336},
    { 224, 888, 256},
    { 216, 1200, 384},
    { 176, 1144, 192},
    { 272, 1208, 80},
    { 136, 1048, 288},
    { 248, 1096, 120},
    { 272, 1024, -8},
    { 296, 824, -24},
    { 304, 624, -80},
    { 360, 504, -8},
    { 376, 552, 24},
    { 360, 824, 8},
    { 392, 696, 80},
    { 472, 944, 32},
    { 344, 1232, 112},
    { 472, 984, 392},
    { 208, 1944, 376},
    { 176, 1280, 584},
    { 128, 1312, 352},
    { 152, 848, 136},
    { 208, 568, 168},
    { 272, 536, 112},
    { 232, 608, 240},
    // 38 seconds
    { 240, 760, 280},
    { 184, 896, 272},
    { 176, 1216, 200},
    { 192, 1120, 128},
    { 80, 1264, 224},
    { 152, 1144, 88},
    { 248, 1016, 16},
    { 304, 824, 32},
    { 384, 784, -112},
    { 432, 568, -24},
    { 480, 464, 16},
    { 528, 592, -24},
    { 432, 776, 40},
    { 480, 1088, -40},
    { 520, 928, 168},
    { 344, 1264, 120},
    { 376, 1008, 384},
    { 224, 1528, 352},
    { 304, 1208, 176},
    { 272, 1032, 336},
    { 184, 800, 224},
    { 176, 584, 192},
    { 216, 568, 160},
    { 256, 512, 128},
    { 24, 1000, 416},
    // 39 seconds
    { 104, 1136, 168},
    { 0, 1176, 408},
    { 120, 1256, 384},
    { -40, 1112, 464},
    { 200, 1048, 248},
    { 200, 1104, 184},
    { 176, 976, 128},
    { 232, 752, 16},
    { 304, 608, 32},
    { 328, 712, 128},
    { 288, 704, 232},
    { 320, 920, 160},
    { 368, 960, 8},
    { 408, 1088, 224},
    { 120, 1032, 256},
    { 264, 1328, 496},
    { 56, 1400, 552},
    { 176, 1248, 432},
    { 136, 1040, 376},
    { 120, 672, 200},
    { 144, 600, 256},
    { 208, 584, 216},
    { 184, 752, 248},
    { 144, 760, 240},
    { 192, 1048, 224},
    // 40 seconds
    { 144, 1064, 312},
    { 264, 1248, 336},
    { 80, 1288, 432},
    { 184, 1168, -32},
    { 56, 936, 120},
    { 112, 976, -32},
    { 232, 704, -56},
    { 280, 592, -8},
    { 392, 600, -104},
    { 376, 600, 248},
    { 504, 808, -128},
    { 392, 1040, 120},
    { 448, 928, 320},
    { 272, 1264, 160},
    { 184, 1336, 624},
    { 40, 1424, 320},
    { 200, 1248, 328},
    { 256, 1040, 288},
    { 216, 776, 240},
    { 184, 600, 248},
    { 232, 640, 224},
    { 240, 704, 264},
    { 200, 736, 344},
    { 264, 952, 176},
    { 224, 1096, 328},
    // 41 seconds
    { 168, 1128, 200},
    { 184, 1328, 184},
    { 152, 1168, 184},
    { 288, 920, -16},
    { 264, 896, 96},
    { 280, 968, 0},
    { 256, 720, 8},
    { 352, 592, -64},
    { 448, 544, -72},
    { 432, 488, 88},
    { 496, 768, -16},
    { 424, 872, 152},
    { 192, 1264, 264},
    { 312, 1312, 592},
    { -176, 1936, 616},
    { 40, 1384, 392},
    { 80, 1080, 296},
    { 144, 760, 176},
    { 200, 568, 248},
    { 248, 688, 160},
    { 272, 600, 264},
    { 208, 816, 352},
    { 168, 1008, 400},
    { 176, 1120, 384},
    { 144, 1008, 256},
    // 42 seconds
    { 128, 1304, 232},
    { 0, 1272, 256},
    { 72, 1064, -56},
    { 88, 864, 48},
    { 120, 912, -88},
    { 192, 712, -40},
    { 288, 560, -24},
    { 344, 656, -56},
    { 312, 616, 88},
    { 352, 848, -112},
    { 400, 944, 32},
    { 448, 1056, 128},
    { 336, 960, 120},
    { 392, 1456, 584},
    { -56, 1536, 248},
    { 144, 1184, 432},
    { 248, 1000, 200},
    { 248, 656, 152},
    { 200, 560, 288},
    { 256, 744, 160},
    { 160, 752, 352},
    { 112, 864, 232},
    { 192, 1104, 264},
    { 88, 1192, 336},
    { 176, 1168, 272},
    // 43 seconds
    { 96, 1120, 296},
    { 224, 1008, 8},
    { 168, 952, 72},
    { 168, 920, 16},
    { 272, 688, -88},
    { 312, 552, -56},
    { 384, 584, 0},
    { 408, 672, 80},
    { 512, 744, -40},
    { 512, 864, 272},
    { 312, 1192, 208},
    { 320, 1224, 640},
    { -96, 1928, 528},
    { 104, 1264, 416},
    { 184, 1144, 312},
    { 192, 752, 176},
    { 168, 544, 216},
    { 224, 488, 96},
    { 280, 672, 8},
    { 160, 840, 104},
    { -32, 1184, 232},
    { -104, 1040, 288},
    { -184, 1272, 224},
    { -248, 1224, 280},
    { -256, 1184, 400},
    // 44 seconds
    { 160, 1080, -152},
    { -72, 904, 64},
    { 112, 920, -96},
    { 208, 824, -128},
    { 184, 648, -88},
    { 240, 696, -152},
    { 216, 752, -72},
    { 248, 776, -208},
    { 280, 792, -336},
    { 376, 888, -112},
    { 224, 1168, 8},
    { 64, 1600, 520},
    { -168, 1568, 400},
    { 24, 1360, 320},
    { 64, 1024, 144},
    { 152, 728, 184},
    { 128, 672, 176},
    { 88, 616, 200},
    { 16, 768, 184},
    { -16, 880, 168},
    { 24, 880, 144},
    { 48, 1080, 120},
    { 56, 1072, 64},
    { -136, 1304, 208},
    { 168, 1352, -64},
    // 45 seconds
    { -64, 1048, 80},
    { 16, 1080, -112},
    { 72, 896, -56},
    { 160, 768, -128},
    { 176, 704, -64},
    { 216, 656, -16},
    { 208, 744, 16},
    { 280, 952, -128},
    { 328, 728, -56},
    { 400, 1088, -48},
    { 240, 1104, 72},
    { 288, 1280, 400},
    { -128, 1664, 248},
    { 72, 1216, 288},
    { 128, 1064, 216},
    { 112, 768, 160},
    { 120, 584, 216},
    { 152, 696, 184},
    { 144, 600, 224},
    { 128, 856, 72},
    { 112, 944, 184},
    { 104, 1112, 200},
    { 64, 1248, 136},
    { 32, 1136, 232},
    { 32, 1256, 160},
    // 46 seconds
    { 168, 1024, -136},
    { 112, 904, -64},
    { 192, 904, -168},
    { 200, 640, -88},
    { 296, 600, -72},
    { 344, 584, -40},
    { 376, 800, -152},
    { 336, 896, -24},
    { 416, 984, 40},
    { 272, 1168, 136},
    { 80, 1432, 704},
    { -168, 1528, 224},
    { 64, 1144, 152},
    { 120, 896, 112},
    { 120, 744, 160},
    { 128, 760, 256},
    { 88, 736, 176},
    { 0, 936, 264},
    { 40, 896, 240},
    { 80, 928, 192},
    { 72, 1040, 248},
    { 8, 1088, 216},
    { -128, 1280, 344},
    { 144, 1232, -176},
    { 0, 904, -80},
    // 47 seconds
    { -32, 1024, -96},
    { 48, 832, -144},
    { 128, 728, -48},
    { 192, 696, -96},
    { 120, 560, 64},
    { 248, 816, -104},
    { 296, 904, -8},
    { 352, 920, 40},
    { 88, 1256, 176},
    { 96, 1032, 488},
    { -32, 1632, 536},
    { 160, 1096, 376},
    { 144, 1048, 392},
    { 144, 904, 240},
    { 160, 680, 280},
    { 176, 696, 208},
    { 56, 712, 240},
    { 112, 904, 328},
    { 88, 888, 384},
    { 96, 1072, 312},
    { 16, 1136, 368},
    { 0, 1168, 272},
    { -80, 1224, 456},
    { 112, 1032, -16},
    { 88, 856, 144},
    // 48 seconds
    { 48, 944, 144},
    { 136, 896, -56},
    { 136, 640, 56},
    { 256, 744, 0},
    { 264, 680, 192},
    { 240, 744, -8},
    { 304, 904, 24},
    { 320, 968, 240},
    { 160, 1152, 280},
    { 144, 1536, 704},
    { -80, 1336, 368},
    { 120, 1112, 256},
    { 240, 880, 248},
    { 256, 728, 280},
    { 192, 704, 352},
    { 200, 776, 272},
    { 168, 688, 408},
    { 152, 1008, 352},
    { 240, 872, 288},
    { 296, 1072, 248},
    { 280, 1192, 208},
    { 224, 1040, 224},
    { 72, 1384, 312},
    { 72, 1184, -112},
    { -72, 824, 0},
    // 49 seconds
    { 48, 936, -112},
    { 136, 696, -88},
    { 216, 632, -56},
    { 256, 680, -48},
    { 288, 688, 8},
    { 272, 688, -264},
    { 304, 904, -64},
    { 408, 768, -88},
    { 304, 1096, -32},
    { 288, 960, 168},
    { 128, 1760, 384},
    { 216, 1216, 224},
    { 336, 1072, 128},
    { 344, 904, 168},
    { 304, 728, 256},
    { 232, 752, 240},
    { 264, 728, 240},
    { 232, 712, 416},
    { 224, 944, 216},
    { 280, 848, 248},
    { 288, 968, 232},
    { 224, 1208, 184},
    { 280, 1160, 264},
    { 136, 1208, 320},
    { 248, 1176, -80},
    // 50 seconds
    { 120, 904, 8},
    { 216, 944, -136},
    { 216, 776, -80},
    { 272, 632, -72},
    { 328, 720, -56},
    { 296, 712, -24},
    { 320, 704, -40},
    { 304, 752, -200},
    { 400, 792, -48},
    { 312, 1080, 64},
    { 296, 872, 96},
    { 288, 1592, 368},
    { 88, 1288, 296},
    { 248, 1264, 304},
    { 264, 1048, 176},
    { 264, 736, 200},
    { 240, 832, 232},
    { 304, 904, 272},
    { 400, 1216, 296},
    { 592, 944, 296},
    { 680, 1256, 48},
    { 472, 976, -64},
    { 64, 368, -368},
    { -48, 368, -744},
    { -224, 136, -856},
    // 51 seconds
    { -424, 56, -968},
    { -408, 216, -1064},
    { -384, 96, -976},
    { -344, 64, -848},
    { -264, 72, -832},
    { -240, 40, -824},
    { -256, 72, -856},
    { -240, 88, -928},
    { -208, 48, -912},
    { -152, 56, -928},
    { -104, 16, -920},
    { -96, 8, -904},
    { -352, 88, -920},
    { -136, 96, -1016},
    { -64, -72, -848},
    { -56, 96, -960},
    { 0, 80, -920},
    { -24, 104, -880},
    { 24, 104, -912},
    { -24, 120, -928},
    { -8, 104, -936},
    { 16, 120, -952},
    { 8, 136, -928},
    { -40, 112, -936},
    { -24, 96, -952},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 15:49:18 local
AccelRawData *activity_sample_walk_100_pbl_25672_5(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25672_5
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -152, -88, -904},
    { -176, -72, -896},
    { -144, -80, -928},
    { -200, -136, -880},
    { -152, -168, -848},
    { -184, -208, -880},
    { -152, -240, -896},
    { 40, -56, -960},
    { -184, -104, -1032},
    { 104, -248, -800},
    { -192, -224, -800},
    { -144, -56, -968},
    { -128, -152, -896},
    { -136, -160, -904},
    { -104, -208, -864},
    { -152, -168, -912},
    { -192, -200, -904},
    { -184, -224, -856},
    { -168, -256, -768},
    { -120, -264, -728},
    { -96, -264, -736},
    { -112, -88, -784},
    { -56, -96, -824},
    { -64, 8, -840},
    { 24, 120, -912},
    // 1 seconds
    { 48, 0, -832},
    { 232, 408, -1208},
    { 48, 536, -1096},
    { -112, 808, -1056},
    { -72, 728, -896},
    { -8, 696, -672},
    { 48, 640, -464},
    { 24, 880, -512},
    { 8, 672, -360},
    { 16, 736, -312},
    { 56, 840, -344},
    { 120, 720, -264},
    { 144, 928, -336},
    { 104, 872, -208},
    { -120, 1200, -288},
    { -168, 1360, -296},
    { -344, 1080, -160},
    { -256, 1280, -208},
    { -176, 976, -80},
    { -168, 1016, -96},
    { -8, 832, -152},
    { 56, 632, -64},
    { 96, 664, -136},
    { 80, 560, -80},
    { 80, 920, -160},
    // 2 seconds
    { 32, 784, -184},
    { 64, 1064, 16},
    { 152, 1360, -160},
    { 32, 1104, -64},
    { 136, 1112, 184},
    { -104, 1648, 104},
    { -56, 1112, 320},
    { -64, 1136, 200},
    { -88, 800, 64},
    { 0, 536, 160},
    { 144, 720, 48},
    { 152, 688, 152},
    { 112, 864, 136},
    { 56, 872, 160},
    { -152, 1024, 80},
    { -184, 1464, -56},
    { -328, 1208, 232},
    { -328, 1480, 160},
    { -104, 1128, 24},
    { -48, 864, -24},
    { 104, 712, -16},
    { 240, 544, 24},
    { 280, 648, 8},
    { 288, 608, 88},
    { 272, 1064, -24},
    // 3 seconds
    { 176, 1104, 88},
    { 152, 1200, 128},
    { -16, 1360, 104},
    { -112, 1712, 344},
    { -304, 1288, 392},
    { 0, 1088, 120},
    { -80, 824, 200},
    { 0, 592, 152},
    { 72, 528, 120},
    { 112, 608, 88},
    { 48, 776, 184},
    { -136, 1064, 48},
    { -16, 1496, 176},
    { -64, 1016, 216},
    { -112, 1384, 256},
    { -96, 1296, 72},
    { -16, 1080, -104},
    { 72, 880, -56},
    { 176, 512, -56},
    { 256, 552, -88},
    { 304, 488, 32},
    { 328, 712, 80},
    { 264, 856, -40},
    { 296, 1048, 40},
    { 192, 1504, 200},
    // 4 seconds
    { 48, 1272, 528},
    { -192, 1864, 208},
    { -96, 1208, 336},
    { -112, 1200, 216},
    { 24, 608, 152},
    { 160, 416, 168},
    { 200, 544, 48},
    { 216, 672, 192},
    { 80, 944, 240},
    { 104, 952, 168},
    { -16, 1024, 184},
    { 24, 1152, -16},
    { -216, 1144, 128},
    { -48, 1456, 104},
    { -96, 1328, 0},
    { -16, 1000, -72},
    { 88, 648, -128},
    { 176, 528, -152},
    { 248, 496, -88},
    { 280, 592, 16},
    { 288, 880, -16},
    { 296, 992, 40},
    { 344, 1024, 112},
    { 296, 1088, 24},
    { 280, 736, 112},
    // 5 seconds
    { 344, 1912, 312},
    { -96, 1464, 600},
    { -192, 1632, 456},
    { -48, 752, 328},
    { 80, 624, 128},
    { 184, 504, 120},
    { 208, 504, 144},
    { 200, 632, 216},
    { 184, 944, 136},
    { 168, 1080, 272},
    { -8, 1152, 200},
    { 0, 1200, 32},
    { -112, 904, 296},
    { -128, 1552, -80},
    { -224, 1224, -32},
    { -8, 864, -72},
    { 64, 584, -56},
    { 160, 520, -72},
    { 208, 584, -56},
    { 192, 784, -16},
    { 232, 936, 0},
    { 248, 960, -40},
    { 360, 1000, -8},
    { 272, 976, 0},
    { 328, 680, 48},
    // 6 seconds
    { 384, 1408, -40},
    { -64, 1568, 400},
    { -400, 1832, 464},
    { -88, 1232, 400},
    { -72, 768, 216},
    { 88, 768, 128},
    { 184, 512, 176},
    { 272, 640, 56},
    { 224, 984, 152},
    { 112, 1064, 184},
    { 176, 1000, 168},
    { 128, 920, 128},
    { 112, 952, 80},
    { -160, 1008, -88},
    { -208, 1096, 32},
    { -312, 1272, 32},
    { -192, 1256, 8},
    { -24, 920, 16},
    { 32, 792, -40},
    { 120, 616, -48},
    { 144, 704, -56},
    { 168, 696, 8},
    { 120, 888, -72},
    { 56, 856, -32},
    { 104, 904, -40},
    // 7 seconds
    { 152, 1016, -8},
    { 152, 1168, -40},
    { 120, 1232, 96},
    { -248, 2024, 16},
    { -336, 1080, 464},
    { 24, 1208, 96},
    { 0, 600, 200},
    { 24, 400, 288},
    { 192, 688, 48},
    { 272, 704, 176},
    { 200, 672, 368},
    { 248, 1064, 248},
    { 200, 848, 424},
    { 104, 920, 112},
    { 0, 1360, 248},
    { -184, 1160, 368},
    { -176, 1456, 296},
    { -184, 1184, 232},
    { -112, 1008, 48},
    { 88, 736, -16},
    { 192, 664, -48},
    { 288, 560, 32},
    { 304, 712, 8},
    { 280, 784, 32},
    { 240, 832, 48},
    // 8 seconds
    { 224, 1048, 88},
    { 272, 1136, 56},
    { 264, 1296, 248},
    { 288, 1400, 432},
    { -120, 1592, 480},
    { 80, 1296, 448},
    { 48, 856, 328},
    { 136, 568, 224},
    { 184, 616, 192},
    { 232, 640, 184},
    { 280, 664, 232},
    { 248, 856, 248},
    { 280, 888, 200},
    { 304, 968, 192},
    { 176, 1104, 192},
    { 192, 1512, 96},
    { 112, 1376, 320},
    { 32, 1312, 80},
    { 88, 992, 104},
    { 168, 936, -88},
    { 208, 704, -64},
    { 264, 608, -48},
    { 272, 648, -64},
    { 320, 688, -8},
    { 312, 712, 40},
    // 9 seconds
    { 432, 816, 0},
    { 512, 880, 296},
    { 296, 1328, 128},
    { 240, 1600, 624},
    { -64, 1104, 936},
    { -136, 1280, 688},
    { -64, 688, 744},
    { 48, 688, 336},
    { 184, 576, 432},
    { 232, 576, 400},
    { 240, 696, 440},
    { 176, 680, 592},
    { 216, 912, 592},
    { 256, 672, 376},
    { 144, 1384, 568},
    { 104, 1016, 560},
    { 48, 1192, 848},
    { -16, 976, 408},
    { 48, 1152, 344},
    { 136, 776, 208},
    { 120, 680, 152},
    { 232, 640, 104},
    { 272, 624, 112},
    { 256, 680, 256},
    { 320, 768, 128},
    // 10 seconds
    { 344, 808, 328},
    { 384, 1160, 368},
    { 296, 928, 472},
    { 392, 1544, 640},
    { -136, 1096, 832},
    { 136, 1360, 808},
    { -32, 1016, 608},
    { 88, 688, 552},
    { 168, 536, 320},
    { 200, 504, 352},
    { 304, 544, 408},
    { 192, 728, 512},
    { 280, 768, 616},
    { 208, 1096, 608},
    { -72, 1096, 360},
    { 200, 1120, 800},
    { -32, 1136, 904},
    { -32, 1208, 352},
    { 0, 936, 424},
    { 48, 832, 272},
    { 160, 696, 168},
    { 216, 568, 208},
    { 264, 640, 232},
    { 296, 712, 240},
    { 272, 752, 264},
    // 11 seconds
    { 368, 848, 224},
    { 408, 800, 360},
    { 312, 1128, 344},
    { 232, 1048, 336},
    { 312, 1296, 976},
    { -224, 1328, 896},
    { 96, 1056, 768},
    { 144, 752, 536},
    { 104, 648, 504},
    { 184, 552, 416},
    { 240, 576, 416},
    { 240, 648, 520},
    { 208, 824, 448},
    { 224, 832, 608},
    { 136, 952, 512},
    { 88, 1032, 400},
    { 40, 1304, 384},
    { -224, 1016, 480},
    { -32, 1016, 368},
    { 16, 1112, 416},
    { 128, 928, 280},
    { 160, 688, 40},
    { 280, 608, 112},
    { 264, 624, 64},
    { 232, 696, 96},
    // 12 seconds
    { 208, 800, 160},
    { 312, 864, 216},
    { 384, 920, 328},
    { 280, 888, 248},
    { 312, 1240, 624},
    { 104, 1472, 864},
    { -48, 1520, 1072},
    { 0, 1072, 776},
    { 88, 784, 488},
    { 128, 600, 408},
    { 216, 552, 320},
    { 256, 624, 408},
    { 192, 768, 448},
    { 216, 864, 464},
    { 184, 904, 488},
    { 160, 880, 464},
    { 136, 1120, 128},
    { 0, 1408, 776},
    { -40, 1384, 248},
    { 120, 824, 416},
    { 168, 848, 120},
    { 248, 648, 88},
    { 304, 568, 112},
    { 296, 680, 144},
    { 256, 720, 160},
    // 13 seconds
    { 200, 832, 192},
    { 296, 808, 224},
    { 288, 736, 240},
    { 128, 920, 40},
    { 216, 1000, 528},
    { 128, 1664, 624},
    { -80, 1520, 904},
    { -24, 1120, 648},
    { 80, 728, 456},
    { 176, 552, 352},
    { 224, 520, 328},
    { 256, 552, 376},
    { 248, 752, 448},
    { 216, 800, 488},
    { 192, 920, 480},
    { 88, 1216, 264},
    { -232, 992, 240},
    { -56, 1248, 832},
    { -8, 1176, 432},
    { 160, 1016, 256},
    { 192, 784, 160},
    { 208, 728, 144},
    { 304, 648, -24},
    { 336, 544, 88},
    { 352, 800, 80},
    // 14 seconds
    { 280, 752, 112},
    { 336, 728, 144},
    { 440, 856, 8},
    { 152, 1056, 456},
    { 120, 1240, 560},
    { 128, 1616, 896},
    { -112, 1240, 824},
    { 56, 1104, 528},
    { 128, 632, 384},
    { 160, 536, 408},
    { 216, 552, 344},
    { 216, 712, 456},
    { 192, 744, 488},
    { 168, 864, 512},
    { 240, 840, 568},
    { 176, 1240, 320},
    { -40, 1200, 392},
    { -64, 1392, 768},
    { -32, 1240, 264},
    { 88, 816, 152},
    { 96, 904, 16},
    { 224, 632, 192},
    { 280, 656, 56},
    { 280, 656, 200},
    { 288, 744, 208},
    // 15 seconds
    { 288, 880, 144},
    { 296, 776, 168},
    { 440, 832, 240},
    { 360, 672, 88},
    { 288, 1288, 576},
    { -24, 1848, 848},
    { 56, 1696, 784},
    { 208, 1112, 528},
    { 224, 760, 424},
    { 152, 544, 360},
    { 200, 472, 232},
    { 240, 520, 256},
    { 280, 536, 368},
    { 296, 840, 392},
    { 280, 920, 440},
    { 176, 1320, 496},
    { -16, 1168, 288},
    { 40, 1184, 344},
    { 136, 1168, 400},
    { 32, 1128, 240},
    { 200, 1088, 64},
    { 176, 888, 112},
    { 200, 624, 32},
    { 248, 592, 48},
    { 264, 632, 56},
    // 16 seconds
    { 272, 752, 48},
    { 288, 792, 64},
    { 360, 912, 56},
    { 416, 912, 160},
    { 424, 1024, 288},
    { 360, 880, 176},
    { 384, 1440, 728},
    { -176, 1448, 472},
    { 88, 1136, 816},
    { 16, 1016, 552},
    { 88, 744, 368},
    { 176, 704, 384},
    { 248, 696, 304},
    { 264, 712, 336},
    { 256, 824, 368},
    { 272, 904, 320},
    { 272, 1080, 192},
    { 280, 1152, 264},
    { 240, 1088, 120},
    { 144, 968, 392},
    { 208, 1112, 320},
    { 88, 1320, 376},
    { 128, 1000, 256},
    { 224, 872, 24},
    { 296, 616, -24},
    // 17 seconds
    { 344, 512, 16},
    { 344, 672, 96},
    { 296, 776, 176},
    { 272, 912, 112},
    { 360, 952, 120},
    { 352, 896, -96},
    { 184, 752, 152},
    { 384, 1152, 312},
    { -8, 1608, 544},
    { 128, 1216, 544},
    { 184, 896, 496},
    { 184, 728, 416},
    { 200, 592, 288},
    { 232, 608, 280},
    { 288, 672, 344},
    { 280, 792, 344},
    { 280, 824, 344},
    { 344, 808, 392},
    { 280, 992, 384},
    { 272, 1136, 352},
    { 136, 1200, 464},
    { 96, 1416, 32},
    { 56, 1224, 232},
    { 40, 936, 64},
    { 80, 616, -40},
    // 18 seconds
    { 200, 592, 8},
    { 280, 528, 32},
    { 336, 712, 16},
    { 328, 712, 88},
    { 328, 816, -16},
    { 352, 800, 72},
    { 352, 768, 288},
    { 144, 1240, 184},
    { 288, 1616, 552},
    { -104, 1752, 768},
    { 112, 1512, 664},
    { 152, 952, 424},
    { 160, 720, 400},
    { 224, 528, 280},
    { 296, 544, 208},
    { 288, 592, 336},
    { 320, 784, 376},
    { 256, 832, 464},
    { 320, 960, 432},
    { 160, 928, 432},
    { 64, 1152, 80},
    { 56, 1144, 408},
    { 24, 1280, 448},
    { 136, 1280, -16},
    { 216, 720, -16},
    // 19 seconds
    { 160, 760, 8},
    { 280, 616, 24},
    { 320, 584, 80},
    { 344, 680, 104},
    { 376, 712, 40},
    { 400, 728, 56},
    { 432, 800, 104},
    { 400, 760, 88},
    { 152, 1104, 112},
    { 344, 992, 416},
    { 296, 1840, 504},
    { -208, 1320, 696},
    { 40, 1032, 456},
    { 144, 584, 304},
    { 224, 552, 208},
    { 272, 440, 264},
    { 304, 760, 384},
    { 264, 800, 424},
    { 312, 896, 440},
    { 312, 912, 392},
    { 272, 1120, 400},
    { 64, 1064, 352},
    { -40, 1296, 368},
    { -96, 1264, 344},
    { 112, 1048, 40},
    // 20 seconds
    { 112, 688, 64},
    { 112, 816, 40},
    { 192, 624, 16},
    { 168, 576, 56},
    { 192, 792, 40},
    { 136, 832, 120},
    { 224, 840, 176},
    { 296, 640, 32},
    { 192, 1200, 128},
    { 56, 1152, 376},
    { 328, 1984, 752},
    { -320, 1312, 728},
    { 168, 1296, 512},
    { 32, 592, 304},
    { 128, 512, 320},
    { 168, 560, 272},
    { 200, 752, 376},
    { 136, 888, 432},
    { 120, 880, 384},
    { 176, 880, 456},
    { 24, 912, 56},
    { 56, 1320, 368},
    { -192, 1120, 512},
    { -8, 1280, 216},
    { -16, 840, 144},
    // 21 seconds
    { -56, 744, -40},
    { 160, 704, 32},
    { 256, 688, -56},
    { 200, 624, 64},
    { 288, 856, 0},
    { 264, 824, 88},
    { 392, 1024, 96},
    { 272, 1328, 296},
    { 136, 1096, 384},
    { 64, 1728, 512},
    { -232, 1160, 944},
    { 64, 920, 248},
    { 144, 592, 504},
    { 192, 656, 240},
    { 192, 576, 360},
    { 184, 664, 336},
    { 104, 856, 440},
    { 64, 960, 480},
    { 56, 728, 616},
    { -56, 1488, 368},
    { -64, 1088, 552},
    { -184, 1216, 576},
    { -104, 1352, 120},
    { -32, 744, 72},
    { 40, 720, 104},
    // 22 seconds
    { 144, 640, 40},
    { 184, 608, 128},
    { 232, 688, 144},
    { 224, 800, 112},
    { 264, 880, 144},
    { 384, 864, 128},
    { 280, 1048, 80},
    { 64, 1168, 760},
    { 408, 1288, 576},
    { -328, 1352, 760},
    { 88, 1208, 872},
    { 8, 768, 672},
    { 104, 704, 304},
    { 160, 608, 448},
    { 232, 696, 376},
    { 224, 672, 472},
    { 184, 832, 456},
    { 184, 800, 480},
    { 128, 1088, 440},
    { 192, 1384, 144},
    { -176, 1328, 552},
    { -192, 1392, 360},
    { -128, 1096, 208},
    { -80, 928, 120},
    { 40, 632, 8},
    // 23 seconds
    { 96, 560, -72},
    { 216, 512, 24},
    { 264, 704, 16},
    { 248, 808, 88},
    { 304, 856, 112},
    { 416, 1000, 272},
    { 232, 1200, 376},
    { 352, 1312, 728},
    { 192, 1392, 488},
    { 264, 1136, 728},
    { 16, 1000, 632},
    { 104, 912, 560},
    { 208, 776, 312},
    { 144, 688, 336},
    { 224, 632, 264},
    { 200, 776, 224},
    { 128, 872, 248},
    { 152, 952, 256},
    { 64, 1224, 56},
    { -72, 1328, 232},
    { -288, 1136, 200},
    { -232, 1072, 272},
    { -128, 1080, 176},
    { 32, 840, 72},
    { 224, 792, 72},
    // 24 seconds
    { 368, 616, 120},
    { 384, 632, 96},
    { 384, 704, 208},
    { 392, 856, 144},
    { 416, 816, 216},
    { 528, 872, 40},
    { 352, 1224, 352},
    { 88, 1920, 744},
    { -248, 1544, 872},
    { 104, 1328, 432},
    { 8, 880, 472},
    { 88, 624, 320},
    { 160, 584, 320},
    { 160, 608, 304},
    { 144, 704, 392},
    { 136, 888, 408},
    { 136, 944, 344},
    { 112, 1048, 336},
    { 16, 1240, 400},
    { -32, 1616, 280},
    { -128, 1344, 232},
    { 16, 1048, -56},
    { 48, 712, 32},
    { 104, 608, -8},
    { 136, 640, 24},
    // 25 seconds
    { 176, 672, 24},
    { 216, 776, 56},
    { 184, 856, 40},
    { 248, 816, 32},
    { 384, 864, 88},
    { 312, 960, 264},
    { 240, 1008, 112},
    { 424, 1672, 600},
    { 16, 1248, 632},
    { 184, 1144, 624},
    { 80, 744, 312},
    { 192, 568, 296},
    { 224, 592, 272},
    { 304, 640, 312},
    { 296, 776, 400},
    { 288, 936, 304},
    { 320, 888, 384},
    { 288, 1048, 336},
    { 152, 1104, 560},
    { -144, 1200, -440},
    { 144, 1096, 296},
    { 88, 1240, 56},
    { 176, 864, 32},
    { 176, 672, -72},
    { 264, 608, 24},
    // 26 seconds
    { 264, 672, 16},
    { 256, 720, 72},
    { 224, 800, 32},
    { 328, 808, -192},
    { 448, 936, -88},
    { 424, 1136, 152},
    { 344, 1104, 256},
    { 464, 1272, 592},
    { 264, 1400, 560},
    { 560, 1184, 608},
    { 416, 1000, 456},
    { 336, 712, 376},
    { 224, 576, 232},
    { 224, 504, 304},
    { 320, 600, 288},
    { 352, 696, 368},
    { 440, 928, 368},
    { 512, 1000, 240},
    { 552, 1136, 80},
    { 376, 1216, 216},
    { 168, 1008, 504},
    { 80, 1280, 160},
    { 232, 1040, 160},
    { 192, 784, -24},
    { 296, 608, -16},
    // 27 seconds
    { 352, 592, 8},
    { 320, 608, 48},
    { 312, 816, 56},
    { 264, 912, 64},
    { 288, 944, -88},
    { 320, 848, 72},
    { 280, 976, -88},
    { 272, 944, 16},
    { 320, 1104, 312},
    { 8, 1704, 504},
    { 144, 1512, 376},
    { 256, 1168, 328},
    { 104, 960, 352},
    { 104, 768, 224},
    { 152, 544, 184},
    { 200, 608, 216},
    { 272, 712, 152},
    { 288, 784, 184},
    { 288, 984, 176},
    { 280, 1296, 56},
    { 88, 1408, 64},
    { 40, 1208, 72},
    { -96, 1136, 544},
    { 0, 1256, -56},
    { 80, 688, 280},
    // 28 seconds
    { 152, 736, 56},
    { 128, 768, 96},
    { 184, 672, 136},
    { 240, 744, 48},
    { 296, 752, 8},
    { 280, 728, -16},
    { 416, 1008, 112},
    { 576, 1152, 232},
    { 304, 1208, 424},
    { 224, 1792, 840},
    { -152, 1232, 848},
    { 224, 1088, 520},
    { 160, 800, 472},
    { 216, 720, 416},
    { 184, 560, 360},
    { 160, 576, 320},
    { 168, 696, 376},
    { 160, 824, 448},
    { 152, 920, 392},
    { -72, 1392, 432},
    { -80, 1144, 280},
    { -64, 1216, 368},
    { -280, 1096, 480},
    { -32, 1120, -144},
    { 88, 480, 128},
    // 29 seconds
    { 200, 560, 112},
    { 216, 632, 200},
    { 256, 912, 120},
    { 200, 880, 120},
    { 264, 744, 40},
    { 192, 688, 56},
    { 280, 880, 32},
    { 304, 1136, 256},
    { 200, 1040, 528},
    { 296, 1480, 712},
    { -40, 1456, 840},
    { 152, 1240, 672},
    { 136, 880, 592},
    { 168, 672, 368},
    { 168, 592, 328},
    { 192, 624, 304},
    { 200, 704, 352},
    { 128, 904, 312},
    { 88, 920, 344},
    { 88, 1272, 200},
    { -64, 1288, 304},
    { -16, 1280, 424},
    { -64, 1064, 344},
    { 136, 968, 184},
    { 200, 728, 168},
    // 30 seconds
    { 280, 720, -48},
    { 312, 584, 160},
    { 368, 744, 104},
    { 312, 800, 120},
    { 248, 912, 40},
    { 272, 904, 40},
    { 384, 1040, 200},
    { 320, 1208, 232},
    { 176, 1144, 344},
    { 336, 1544, 608},
    { 24, 1224, 640},
    { 288, 1128, 528},
    { 200, 832, 592},
    { 240, 672, 400},
    { 168, 632, 368},
    { 152, 664, 408},
    { 168, 856, 368},
    { 168, 896, 360},
    { 128, 936, 400},
    { -40, 1272, 216},
    { 16, 1184, 120},
    { -16, 1328, 408},
    { -128, 1208, 96},
    { 136, 920, 16},
    { 120, 608, -72},
    // 31 seconds
    { 144, 624, -16},
    { 224, 632, -16},
    { 208, 664, 32},
    { 256, 760, 16},
    { 240, 832, 0},
    { 352, 776, 152},
    { 288, 1048, 152},
    { 144, 1192, 408},
    { 360, 1464, 792},
    { 48, 1352, 616},
    { 200, 1168, 664},
    { 64, 936, 568},
    { 128, 776, 384},
    { 184, 600, 336},
    { 168, 664, 328},
    { 232, 736, 344},
    { 184, 888, 216},
    { 248, 784, 424},
    { 248, 848, 136},
    { 160, 1000, 232},
    { 88, 1168, 264},
    { -24, 1336, 488},
    { 24, 1192, 208},
    { 128, 1000, 168},
    { 104, 872, 80},
    // 32 seconds
    { 72, 776, 64},
    { 136, 640, 72},
    { 160, 704, 8},
    { 176, 784, 32},
    { 176, 760, 32},
    { 288, 1072, 56},
    { 296, 976, 104},
    { 288, 1152, 240},
    { 296, 1368, 368},
    { 296, 1776, 568},
    { 96, 1216, 496},
    { 280, 816, 520},
    { 240, 760, 400},
    { 232, 632, 304},
    { 200, 568, 288},
    { 160, 776, 264},
    { 152, 832, 280},
    { 256, 888, 264},
    { 232, 728, 120},
    { 64, 1016, 64},
    { 24, 1120, 80},
    { -144, 1248, 128},
    { -112, 1440, 336},
    { -88, 1288, 16},
    { 96, 1064, 48},
    // 33 seconds
    { 160, 800, 8},
    { 240, 752, 32},
    { 256, 560, 72},
    { 272, 632, 40},
    { 232, 808, 96},
    { 224, 1000, -64},
    { 304, 1192, 216},
    { 304, 1192, 144},
    { 304, 1008, 136},
    { 288, 1320, 352},
    { -64, 1272, 464},
    { -72, 1008, 600},
    { -40, 1200, 496},
    { -32, 864, 472},
    { -56, 744, 448},
    { -32, 824, 368},
    { 0, 784, 400},
    { 40, 864, 232},
    { 104, 872, 136},
    { 8, 856, 56},
    { -136, 944, 72},
    { -520, 1200, -88},
    { -728, 1016, -296},
    { -544, 1136, 232},
    { -72, 1168, 8},
    // 34 seconds
    { -8, 848, 72},
    { 104, 800, 16},
    { 168, 752, 120},
    { 144, 696, 80},
    { 96, 832, 96},
    { 32, 840, 88},
    { 40, 840, 88},
    { 120, 1008, 120},
    { 96, 680, -128},
    { -192, 1448, 224},
    { -88, 1184, 328},
    { -368, 1376, 704},
    { -208, 1200, 752},
    { 8, 1200, 552},
    { 112, 840, 464},
    { 144, 776, 280},
    { 104, 648, 312},
    { 136, 664, 312},
    { 168, 736, 288},
    { 256, 744, 416},
    { 232, 464, 136},
    { 88, 1128, 144},
    { 48, 1192, 320},
    { -64, 1176, 568},
    { 40, 1320, 176},
    // 35 seconds
    { 56, 1104, 160},
    { 88, 712, 128},
    { 168, 920, -136},
    { 208, 736, -40},
    { 408, 888, -224},
    { 464, 1440, -448},
    { 24, 432, 160},
    { 160, -296, -496},
    { 208, 312, -824},
    { 248, 400, -1040},
    { 424, 288, -808},
    { 312, 864, -1248},
    { 320, 376, -736},
    { 304, 400, -920},
    { 248, 128, -656},
    { 336, 192, -648},
    { 264, 104, -576},
    { 288, 200, -656},
    { 304, 120, -664},
    { 456, 88, -816},
    { 208, 152, -1000},
    { 136, -160, -720},
    { 120, 512, -544},
    { 40, 984, 200},
    { -80, 2104, -504},
    // 36 seconds
    { 8, 1040, 336},
    { 216, 1024, 128},
    { 216, 784, 168},
    { 264, 696, 288},
    { 248, 928, 144},
    { 192, 640, 296},
    { 288, 952, 176},
    { 344, 832, 480},
    { 272, 1200, 208},
    { 72, 1160, 152},
    { 432, 1072, 824},
    { 80, 936, 904},
    { 336, 832, 792},
    { 272, 800, 600},
    { 248, 568, 504},
    { 344, 584, 376},
    { 304, 648, 440},
    { 344, 656, 528},
    { 288, 800, 448},
    { 368, 736, 576},
    { 256, 840, 552},
    { 272, 1024, 712},
    { 120, 1248, 728},
    { 0, 928, 792},
    { 200, 1248, 272},
    // 37 seconds
    { 216, 672, 256},
    { 184, 696, 152},
    { 160, 656, 264},
    { 200, 672, 328},
    { 240, 800, 280},
    { 224, 808, 248},
    { 312, 880, 272},
    { 384, 1016, 144},
    { 200, 1320, 608},
    { 304, 1056, 672},
    { 320, 1344, 888},
    { 112, 1280, 584},
    { 272, 816, 712},
    { 168, 752, 480},
    { 224, 624, 440},
    { 208, 592, 472},
    { 240, 712, 512},
    { 320, 720, 632},
    { 176, 896, 568},
    { 184, 968, 616},
    { 64, 1192, 304},
    { -56, 1120, 400},
    { -16, 864, 808},
    { 88, 1408, 184},
    { 272, 632, 216},
    // 38 seconds
    { 224, 688, 144},
    { 224, 512, 304},
    { 248, 640, 272},
    { 256, 752, 344},
    { 248, 792, 200},
    { 360, 776, 144},
    { 456, 760, 280},
    { 288, 584, 424},
    { 232, 1120, 432},
    { 368, 1320, 888},
    { 8, 1144, 936},
    { 240, 952, 664},
    { 176, 720, 680},
    { 200, 648, 520},
    { 192, 536, 496},
    { 232, 616, 488},
    { 304, 648, 592},
    { 256, 720, 592},
    { 320, 792, 560},
    { 336, 904, 728},
    { 64, 616, 520},
    { 80, 1112, 656},
    { -80, 1056, 968},
    { 72, 1136, 376},
    { 144, 760, 568},
    // 39 seconds
    { 200, 736, 240},
    { 160, 680, 352},
    { 232, 728, 304},
    { 240, 792, 320},
    { 216, 792, 296},
    { 264, 880, 304},
    { 304, 848, 320},
    { 296, 1240, 408},
    { 144, 800, 560},
    { 232, 1296, 600},
    { 152, 856, 1288},
    { 192, 1352, 584},
    { 32, 392, 1216},
    { 64, 472, 752},
    { 72, 448, 648},
    { 176, 472, 592},
    { 296, 496, 640},
    { 224, 632, 680},
    { 176, 592, 688},
    { 104, 848, 920},
    { -160, 904, 992},
    { 144, 760, 352},
    { -136, 720, 1200},
    { 72, 1160, 488},
    { 80, 720, 776},
    // 40 seconds
    { 240, 744, 224},
    { 112, 528, 384},
    { 256, 560, 392},
    { 264, 728, 392},
    { 280, 664, 472},
    { 280, 968, 336},
    { 336, 1088, 592},
    { 288, 832, 752},
    { 208, 1064, 664},
    { 328, 1272, 1448},
    { -368, 1144, 1104},
    { 200, 752, 984},
    { 80, 464, 488},
    { 264, 352, 512},
    { 192, 592, 504},
    { 176, 648, 600},
    { 216, 704, 696},
    { 160, 808, 680},
    { 104, 728, 656},
    { -64, 968, 744},
    { 64, 1024, 752},
    { -80, 752, 992},
    { 88, 1160, 80},
    { 144, 472, 432},
    { 144, 744, 304},
    // 41 seconds
    { 80, 832, 576},
    { 72, 768, 376},
    { 144, 792, 328},
    { 232, 664, 272},
    { 160, 704, 224},
    { 256, 552, 48},
    { 280, 664, 440},
    { 56, 952, 1000},
    { 400, 1568, 1344},
    { -144, 1296, 1208},
    { 240, 1136, 784},
    { 176, 704, 624},
    { 264, 624, 464},
    { 144, 624, 480},
    { 144, 696, 480},
    { 104, 728, 344},
    { 128, 1072, 88},
    { -16, 1000, -104},
    { -40, 1072, 720},
    { -208, 1224, 728},
    { -104, 1128, 1160},
    { 72, 896, 672},
    { 144, 696, 520},
    { 96, 440, 416},
    { 192, 552, 296},
    // 42 seconds
    { 248, 672, 160},
    { 224, 840, 232},
    { 152, 1200, 152},
    { 72, 664, 368},
    { 592, 480, 608},
    { 296, 1040, 1064},
    { -88, 1360, 712},
    { 104, 1360, 1024},
    { -96, 1064, 824},
    { 32, 624, 688},
    { 152, 680, 648},
    { 176, 576, 632},
    { 192, 504, 736},
    { 112, 648, 760},
    { 72, 768, 728},
    { 256, 768, 624},
    { 24, 1008, 608},
    { 240, 904, 544},
    { 0, 856, 704},
    { 0, 1048, 480},
    { 40, 1056, 920},
    { -232, 1120, 152},
    { 88, 824, 352},
    { 184, 576, 384},
    { 248, 752, 264},
    // 43 seconds
    { 208, 808, 328},
    { 216, 904, 304},
    { 368, 720, 224},
    { 64, 744, 528},
    { 336, 1080, 560},
    { 344, 1032, 824},
    { 320, 920, 864},
    { 408, 1032, 952},
    { -24, 896, 808},
    { 168, 752, 616},
    { 184, 608, 600},
    { 160, 616, 568},
    { 160, 672, 616},
    { 184, 744, 544},
    { 216, 696, 552},
    { 320, 672, 504},
    { 272, 888, 768},
    { 0, 560, 864},
    { 112, 1200, 440},
    { 0, 1032, 1048},
    { 48, 1296, 512},
    { 144, 928, 384},
    { 232, 824, 312},
    { 232, 808, 176},
    { 232, 600, 296},
    // 44 seconds
    { 288, 752, 240},
    { 304, 720, 328},
    { 176, 520, 136},
    { 272, 928, -32},
    { 568, 1064, 88},
    { 536, 1368, 616},
    { 384, 1048, 1008},
    { 184, 1224, 976},
    { 128, 896, 824},
    { 200, 792, 680},
    { 216, 680, 568},
    { 176, 592, 400},
    { 280, 552, 416},
    { 304, 648, 392},
    { 272, 688, 472},
    { 280, 824, 544},
    { 296, 936, 600},
    { 272, 1136, 400},
    { 144, 1112, 480},
    { 200, 856, 832},
    { 120, 1400, 144},
    { 264, 744, 448},
    { 280, 800, 208},
    { 312, 648, 184},
    { 448, 640, 224},
    // 45 seconds
    { 456, 800, 280},
    { 456, 768, 232},
    { 552, 896, 168},
    { 536, 824, 144},
    { 480, 992, 520},
    { 304, 1168, 688},
    { 544, 1408, 896},
    { -80, 1128, 816},
    { 168, 816, 672},
    { 128, 592, 384},
    { 248, 552, 408},
    { 248, 576, 400},
    { 360, 688, 600},
    { 208, 416, 376},
    { 152, 936, 536},
    { 192, 1016, 600},
    { 240, 1112, 552},
    { -32, 1304, 664},
    { -160, 984, 784},
    { 120, 1096, 0},
    { 352, 536, 256},
    { 336, 496, 232},
    { 296, 624, 216},
    { 288, 696, 240},
    { 240, 1072, 224},
    // 46 seconds
    { 312, 760, -24},
    { 336, 904, 248},
    { 392, 680, 368},
    { 200, 1168, 592},
    { 352, 1160, 920},
    { -48, 1168, 1032},
    { 56, 1064, 736},
    { 136, 760, 568},
    { 240, 584, 416},
    { 288, 632, 488},
    { 216, 640, 456},
    { 264, 600, 560},
    { 248, 872, 392},
    { 192, 888, 648},
    { 112, 960, 608},
    { 80, 1128, 552},
    { -176, 1544, 1136},
    { -168, 1168, 368},
    { 48, 888, 0},
    { 344, 464, 128},
    { 296, 592, 272},
    { 184, 632, 320},
    { 240, 824, 288},
    { 224, 768, 264},
    { 280, 896, 272},
    // 47 seconds
    { 136, 728, 320},
    { 200, 1120, 480},
    { -32, 968, 752},
    { 184, 1560, 960},
    { -304, 1288, 824},
    { -32, 936, 824},
    { 72, 768, 592},
    { 96, 632, 544},
    { 192, 584, 496},
    { 240, 776, 392},
    { 304, 608, 368},
    { 240, 664, 576},
    { 152, 816, 648},
    { 40, 1024, 688},
    { -8, 1032, 640},
    { -128, 1424, 1152},
    { -424, 992, 848},
    { 8, 1088, 128},
    { 40, 464, 208},
    { 0, 680, 296},
    { 80, 696, 384},
    { 120, 840, 352},
    { 152, 760, 320},
    { 248, 832, 232},
    { 400, 840, 408},
    // 48 seconds
    { 312, 1080, 480},
    { 88, 1040, 664},
    { 16, 1736, 1248},
    { -384, 1320, 1016},
    { 120, 1000, 560},
    { 104, 584, 488},
    { 120, 624, 408},
    { 176, 504, 472},
    { 232, 648, 528},
    { 240, 744, 608},
    { 160, 872, 616},
    { 144, 824, 544},
    { 152, 888, 544},
    { 128, 976, 592},
    { 32, 1136, 720},
    { -136, 1280, 1128},
    { -96, 1048, 296},
    { 96, 712, 216},
    { 72, 536, 320},
    { 64, 728, 376},
    { 0, 824, 432},
    { 16, 896, 376},
    { 120, 800, 304},
    { 208, 768, 160},
    { 272, 800, 376},
    // 49 seconds
    { 320, 1040, 424},
    { 104, 952, 704},
    { 112, 1248, 992},
    { -128, 1464, 1104},
    { 144, 1016, 712},
    { 256, 696, 480},
    { 256, 624, 496},
    { 208, 648, 472},
    { 224, 600, 464},
    { 304, 640, 480},
    { 256, 480, 576},
    { 160, 672, 192},
    { 304, 768, 528},
    { 256, 824, 640},
    { 248, 1192, 576},
    { 200, 800, 480},
    { 160, 1256, 640},
    { -72, 920, 528},
    { 152, 880, 64},
    { 184, 600, 344},
    { 144, 872, 248},
    { 16, 936, 400},
    { 120, 904, 256},
    { 160, 768, 232},
    { 184, 712, 200},
    // 50 seconds
    { 200, 704, 344},
    { 160, 816, 56},
    { 272, 1008, 352},
    { 224, 1200, 720},
    { 168, 1416, 688},
    { -128, 1272, 856},
    { 88, 936, 544},
    { 240, 696, 280},
    { 280, 592, 472},
    { 256, 640, 584},
    { 176, 760, 664},
    { 192, 776, 688},
    { 216, 792, 584},
    { 256, 696, 480},
    { 296, 728, 488},
    { 304, 752, 440},
    { 304, 800, 688},
    { 112, 1032, 288},
    { 256, 1328, 224},
    { 304, 744, 496},
    { 144, 1456, -264},
    { -96, 688, -112},
    { -208, 520, -624},
    { -136, 712, -680},
    { -200, 488, -616},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 15:50:58 local
AccelRawData *activity_sample_walk_100_pbl_25672_6(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_100_pbl_25672_6
  //> TEST_EXPECTED 100
  //> TEST_EXPECTED_MIN 80
  //> TEST_EXPECTED_MAX 120
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -160, -280, -920},
    { -160, -256, -960},
    { -128, -256, -944},
    { -72, -264, -944},
    { -96, -256, -912},
    { -104, -224, -928},
    { -104, -232, -952},
    { -128, -248, -952},
    { -96, -232, -856},
    { -24, -336, -752},
    { 16, -72, -712},
    { -56, -160, -920},
    { -80, -112, -904},
    { -104, -216, -904},
    { -96, -208, -912},
    { -64, -200, -912},
    { 24, -336, -912},
    { 40, -360, -880},
    { -8, -328, -912},
    { 88, -408, -840},
    { -112, -288, -800},
    { -200, -448, -624},
    { -336, -504, -536},
    { -192, -416, -624},
    { -192, -112, -776},
    // 1 seconds
    { 160, 400, -632},
    { 256, 1040, -576},
    { 352, 1040, -496},
    { 408, 896, -256},
    { 392, 832, -288},
    { 360, 880, -32},
    { 344, 904, -88},
    { 280, 928, -16},
    { 248, 1088, 176},
    { 184, 1120, 392},
    { 32, 1312, 664},
    { -56, 1120, 704},
    { 200, 1208, 488},
    { 120, 792, 536},
    { 112, 792, 440},
    { 136, 800, 352},
    { 160, 664, 424},
    { 208, 848, 480},
    { 80, 848, 584},
    { 8, 944, 440},
    { -24, 1112, 464},
    { -96, 992, 616},
    { -40, 1224, 560},
    { -96, 848, 448},
    { 104, 848, 240},
    // 2 seconds
    { 112, 720, 408},
    { 112, 744, 240},
    { 184, 696, 264},
    { 176, 648, 312},
    { 160, 720, 280},
    { 208, 744, 216},
    { 224, 1152, 480},
    { 144, 1152, 680},
    { 32, 1272, 816},
    { 80, 1392, 776},
    { 8, 1032, 552},
    { 96, 800, 568},
    { 48, 648, 384},
    { 80, 560, 432},
    { 88, 664, 384},
    { 152, 752, 440},
    { 104, 768, 592},
    { -88, 944, 392},
    { 48, 1152, 560},
    { 8, 1088, 528},
    { 96, 1096, 576},
    { -56, 832, 440},
    { 32, 880, 312},
    { 64, 696, 320},
    { 200, 640, 176},
    // 3 seconds
    { 304, 560, 160},
    { 288, 592, 280},
    { 280, 832, 320},
    { 192, 960, 336},
    { 192, 1000, 488},
    { 144, 1320, 480},
    { 168, 976, 720},
    { 120, 1536, 744},
    { 48, 1152, 760},
    { 16, 1144, 640},
    { 56, 776, 456},
    { 80, 584, 376},
    { 144, 536, 256},
    { 120, 568, 360},
    { 32, 680, 440},
    { 24, 856, 440},
    { 32, 1032, 512},
    { -8, 1112, 432},
    { -72, 1432, 312},
    { -152, 1152, 392},
    { -136, 1248, 216},
    { -120, 952, 408},
    { 80, 752, 176},
    { 120, 696, 104},
    { 208, 528, 104},
    // 4 seconds
    { 240, 592, 160},
    { 248, 768, 208},
    { 288, 880, 272},
    { 312, 1040, 464},
    { 80, 1112, 336},
    { 232, 1280, 912},
    { -152, 1512, 776},
    { 24, 1248, 672},
    { -144, 904, 520},
    { 72, 616, 272},
    { 104, 544, 280},
    { 144, 504, 264},
    { 104, 672, 432},
    { 0, 744, 448},
    { -72, 1040, 384},
    { -176, 1136, 536},
    { -16, 1280, 352},
    { -64, 1136, 720},
    { -80, 1168, 296},
    { 72, 1016, 144},
    { 80, 696, 216},
    { 160, 624, 80},
    { 256, 624, 104},
    { 312, 608, 184},
    { 248, 856, 168},
    // 5 seconds
    { 224, 832, 280},
    { 256, 960, 264},
    { 72, 1176, 280},
    { 144, 1104, 600},
    { -88, 1464, 544},
    { -8, 1328, 640},
    { -96, 992, 600},
    { -64, 704, 392},
    { 64, 640, 216},
    { 112, 504, 248},
    { 112, 664, 368},
    { 80, 808, 552},
    { 88, 872, 320},
    { 72, 1136, 592},
    { -72, 1224, 296},
    { -104, 1320, 464},
    { -120, 1208, 448},
    { -40, 1136, 144},
    { -104, 1056, 168},
    { -24, 728, 72},
    { 112, 616, 8},
    { 168, 576, 104},
    { 192, 640, 88},
    { 200, 824, 112},
    { 208, 864, 200},
    // 6 seconds
    { 304, 960, 192},
    { 312, 1144, 456},
    { 56, 1200, 360},
    { 96, 1752, 528},
    { -208, 1272, 728},
    { 56, 1328, 392},
    { 72, 864, 320},
    { 32, 768, 160},
    { 104, 496, 232},
    { 152, 608, 256},
    { 168, 752, 344},
    { 184, 840, 416},
    { 200, 960, 328},
    { 176, 944, 440},
    { 0, 984, 96},
    { 32, 1392, 344},
    { -56, 1056, 424},
    { -40, 1280, 216},
    { 40, 808, 240},
    { 184, 856, 64},
    { 272, 672, 64},
    { 288, 608, 80},
    { 328, 616, 224},
    { 288, 792, 136},
    { 288, 832, 184},
    // 7 seconds
    { 320, 872, 88},
    { 328, 856, 128},
    { 376, 1344, 328},
    { 80, 1184, 552},
    { 304, 1672, 528},
    { -240, 1464, 544},
    { 64, 1200, 392},
    { 64, 712, 312},
    { 56, 592, 240},
    { 144, 504, 192},
    { 192, 560, 272},
    { 176, 760, 256},
    { 152, 960, 312},
    { 104, 1032, 384},
    { -24, 1232, 240},
    { -104, 1304, 104},
    { -104, 1472, 424},
    { 88, 1096, 88},
    { 80, 832, 208},
    { 112, 728, 136},
    { 168, 736, -16},
    { 216, 608, -24},
    { 232, 616, 64},
    { 304, 760, 112},
    { 288, 880, 48},
    // 8 seconds
    { 400, 880, 176},
    { 376, 1160, 216},
    { 120, 1240, 240},
    { 256, 1384, 760},
    { -88, 1608, 536},
    { 24, 1256, 496},
    { -56, 936, 488},
    { 104, 688, 240},
    { 144, 592, 240},
    { 184, 512, 264},
    { 160, 864, 296},
    { 104, 864, 400},
    { 56, 1008, 320},
    { 24, 1168, 352},
    { -232, 944, -48},
    { -232, 1344, 344},
    { -216, 1056, 248},
    { -120, 1152, 112},
    { 8, 664, 232},
    { 184, 744, 72},
    { 264, 616, 56},
    { 288, 584, 144},
    { 296, 832, 104},
    { 208, 840, 208},
    { 240, 984, 128},
    // 9 seconds
    { 320, 856, -8},
    { 184, 1200, 360},
    { 184, 888, 344},
    { 280, 1752, 648},
    { -136, 1456, 696},
    { -152, 1288, 624},
    { -72, 736, 328},
    { 72, 592, 168},
    { 176, 472, 336},
    { 208, 656, 256},
    { 216, 808, 384},
    { 64, 904, 416},
    { -64, 1048, 168},
    { -64, 1088, 320},
    { 32, 1224, 256},
    { 56, 1032, 560},
    { 104, 1168, 144},
    { 80, 976, 176},
    { 120, 800, 96},
    { 168, 704, -8},
    { 208, 592, 48},
    { 288, 600, 112},
    { 280, 832, 96},
    { 280, 792, 160},
    { 288, 792, 280},
    // 10 seconds
    { 104, 1040, 136},
    { 152, 936, 424},
    { 392, 2080, 776},
    { -360, 1688, 984},
    { -56, 1288, 656},
    { 64, 800, 224},
    { 128, 512, 224},
    { 200, 440, 192},
    { 232, 568, 272},
    { 336, 656, 376},
    { 248, 824, 464},
    { 184, 744, 248},
    { 160, 1152, 304},
    { 120, 1224, 344},
    { 16, 1256, 392},
    { 24, 1224, 288},
    { 48, 1328, 72},
    { 64, 920, 232},
    { 216, 792, 56},
    { 264, 592, 24},
    { 248, 560, 32},
    { 272, 704, 48},
    { 152, 544, -184},
    { 256, 1136, 80},
    { 248, 920, 144},
    // 11 seconds
    { 224, 1000, 272},
    { 416, 992, 440},
    { 624, 1200, 760},
    { 272, 1232, 752},
    { 328, 1032, 616},
    { 120, 824, 392},
    { 184, 608, 304},
    { 224, 496, 344},
    { 336, 560, 304},
    { 328, 664, 568},
    { 224, 856, 264},
    { 280, 1064, 376},
    { 208, 1248, 680},
    { 376, 1328, 384},
    { 96, 1248, 632},
    { 96, 912, 344},
    { 184, 1040, 112},
    { 40, 744, 328},
    { 152, 824, 64},
    { 208, 632, 104},
    { 232, 576, 32},
    { 144, 552, 24},
    { 296, 952, 96},
    { 280, 1008, 280},
    { 376, 1112, 344},
    // 12 seconds
    { 280, 1192, 360},
    { 376, 1200, 664},
    { 160, 1176, 592},
    { 360, 1208, 488},
    { 144, 840, 480},
    { 208, 584, 304},
    { 216, 504, 368},
    { 136, 616, 56},
    { 256, 840, 352},
    { 152, 816, 496},
    { 280, 1184, 448},
    { 88, 1184, 424},
    { 152, 1224, 616},
    { 0, 1048, 104},
    { 280, 1112, 96},
    { 176, 840, 296},
    { 280, 768, 24},
    { 296, 584, 80},
    { 224, 496, -168},
    { 248, 760, 72},
    { 184, 856, 136},
    { 320, 1016, 176},
    { 424, 1208, 296},
    { 296, 1048, 288},
    { 560, 1384, 544},
    // 13 seconds
    { 184, 1152, 512},
    { 480, 1112, 440},
    { 248, 744, 416},
    { 176, 528, 232},
    { 296, 560, 288},
    { 336, 576, 336},
    { 184, 928, 208},
    { 136, 968, 344},
    { 208, 1104, 600},
    { 224, 1064, 312},
    { 296, 1264, 400},
    { 96, 768, 384},
    { 328, 1168, -168},
    { 280, 752, 288},
    { 272, 808, -24},
    { 320, 792, 24},
    { 288, 552, 16},
    { 352, 640, 56},
    { 384, 928, 264},
    { 480, 992, 248},
    { 552, 1224, 416},
    { 432, 1368, 800},
    { 120, 1256, 520},
    { 424, 1024, 224},
    { 280, 736, 344},
    // 14 seconds
    { 272, 752, 248},
    { 376, 704, 408},
    { 248, 672, 288},
    { 296, 832, 392},
    { 160, 864, 432},
    { 304, 1032, 408},
    { 88, 1144, 336},
    { 232, 1256, 344},
    { 96, 1056, 424},
    { 232, 1192, -16},
    { 320, 792, 216},
    { 352, 728, 32},
    { 304, 664, -152},
    { 320, 368, -8},
    { 400, 728, 56},
    { 352, 984, 224},
    { 400, 920, 136},
    { 528, 1008, 312},
    { 280, 1128, 376},
    { 600, 1464, 768},
    { 32, 1232, 416},
    { 352, 1248, 400},
    { 112, 728, 288},
    { 216, 584, 256},
    { 248, 592, 272},
    // 15 seconds
    { 344, 656, 280},
    { 344, 720, 280},
    { 312, 888, 352},
    { 312, 992, 408},
    { 168, 1168, 320},
    { 176, 1488, 360},
    { 64, 1064, 240},
    { 176, 1272, 88},
    { 232, 808, 296},
    { 304, 912, 0},
    { 280, 600, -56},
    { 296, 520, 8},
    { 336, 632, 64},
    { 280, 712, 104},
    { 344, 752, 144},
    { 544, 888, 240},
    { 344, 984, 272},
    { 248, 1024, 280},
    { 776, 1504, 784},
    { -32, 1512, 704},
    { 464, 1408, 592},
    { 32, 840, 392},
    { 168, 568, 112},
    { 240, 392, 232},
    { 344, 624, 232},
    // 16 seconds
    { 408, 680, 432},
    { 352, 896, 344},
    { 368, 928, 392},
    { 400, 1064, 464},
    { 344, 1088, 280},
    { 288, 1264, 272},
    { 176, 1040, 360},
    { 176, 1208, 24},
    { 184, 952, 136},
    { 168, 792, 48},
    { 240, 712, -16},
    { 272, 560, 24},
    { 312, 600, 72},
    { 304, 712, 160},
    { 328, 760, 104},
    { 344, 816, -88},
    { 592, 1232, 192},
    { 216, 1032, 280},
    { 632, 1312, 560},
    { 152, 1264, 392},
    { 456, 1352, 480},
    { 176, 832, 392},
    { 136, 672, 256},
    { 184, 504, 264},
    { 328, 488, 216},
    // 17 seconds
    { 376, 888, 304},
    { 320, 912, 344},
    { 328, 1008, 312},
    { 368, 1128, 432},
    { 304, 1088, 200},
    { 280, 1192, 256},
    { 208, 960, 328},
    { 248, 1056, 72},
    { 320, 808, 192},
    { 336, 864, 128},
    { 400, 680, 40},
    { 416, 488, 32},
    { 400, 632, 24},
    { 400, 872, 120},
    { 392, 1048, 160},
    { 536, 1160, 328},
    { 256, 1128, 256},
    { 584, 1416, 576},
    { 224, 1184, 344},
    { 408, 1328, 360},
    { 136, 760, 376},
    { 80, 792, 144},
    { 208, 512, 304},
    { 280, 592, 256},
    { 240, 744, 360},
    // 18 seconds
    { 232, 976, 352},
    { 216, 1000, 376},
    { 104, 1168, 256},
    { 168, 1192, 64},
    { 56, 1072, 360},
    { 40, 1144, -56},
    { 176, 1072, -8},
    { 168, 824, 96},
    { 296, 768, -8},
    { 336, 552, -32},
    { 368, 584, 48},
    { 376, 752, 0},
    { 344, 672, 104},
    { 448, 976, 80},
    { 440, 1080, 184},
    { 320, 1080, 336},
    { 560, 1496, 496},
    { 184, 1288, 464},
    { 360, 1272, 368},
    { 240, 824, 360},
    { 192, 600, 224},
    { 272, 520, 216},
    { 320, 560, 312},
    { 304, 688, 416},
    { 344, 936, 336},
    // 19 seconds
    { 248, 1048, 320},
    { 232, 1240, 376},
    { 192, 1232, 256},
    { 256, 1160, 408},
    { 120, 1168, 56},
    { 256, 1136, 88},
    { 256, 768, 64},
    { 336, 744, 56},
    { 384, 448, -64},
    { 320, 480, -224},
    { 280, 648, -136},
    { 200, 1104, 208},
    { 384, 1024, 56},
    { 624, 1192, 112},
    { 320, 928, 208},
    { 624, 1264, 360},
    { 240, 1224, 304},
    { 488, 1288, 392},
    { 216, 824, 304},
    { 200, 640, 128},
    { 200, 464, 160},
    { 272, 288, -24},
    { 384, 840, 208},
    { 192, 800, 296},
    { 344, 1120, 240},
    // 20 seconds
    { 272, 1240, 128},
    { 248, 1376, 192},
    { 176, 1056, 224},
    { 184, 1232, -80},
    { 216, 856, 192},
    { 248, 888, -112},
    { 312, 704, -104},
    { 392, 528, -16},
    { 376, 560, 168},
    { 496, 888, 112},
    { 480, 1072, 192},
    { 528, 1000, 144},
    { 432, 1080, 168},
    { 488, 1216, 376},
    { 288, 1440, 448},
    { 208, 1176, 312},
    { 296, 1056, 336},
    { 32, 416, 152},
    { 272, 544, 112},
    { 304, 616, 272},
    { 344, 952, 352},
    { 432, 920, 352},
    { 328, 1176, 360},
    { 256, 1216, 368},
    { 304, 1104, 240},
    // 21 seconds
    { 152, 776, 352},
    { 56, 1288, 8},
    { 96, 816, 312},
    { 96, 1024, 128},
    { 232, 792, 0},
    { 288, 552, -16},
    { 368, 616, -80},
    { 392, 712, 72},
    { 472, 792, 120},
    { 560, 888, 152},
    { 592, 1216, 0},
    { 176, 880, -72},
    { 568, 1456, 440},
    { 216, 1368, 560},
    { 256, 1248, 400},
    { 104, 1096, 520},
    { 152, 712, 128},
    { 280, 504, 192},
    { 336, 608, 216},
    { 240, 528, 344},
    { 264, 1056, 376},
    { 272, 1224, 432},
    { 112, 1224, 384},
    { 248, 1512, 184},
    { 208, 1000, 384},
    // 22 seconds
    { 216, 1032, -96},
    { 280, 944, 8},
    { 232, 840, 104},
    { 288, 736, -112},
    { 264, 544, -224},
    { 200, 336, -176},
    { 384, 712, 128},
    { 392, 936, 264},
    { 472, 1104, 0},
    { 416, 1320, 208},
    { 584, 1056, 336},
    { 376, 1368, 208},
    { 296, 1328, 312},
    { 248, 608, 72},
    { 120, 552, 152},
    { 240, 576, 192},
    { 368, 720, 248},
    { 424, 848, 216},
    { 480, 832, 248},
    { 416, 936, 232},
    { 400, 1160, 280},
    { 376, 1144, 216},
    { 248, 1272, 200},
    { 184, 904, -16},
    { 312, 840, 24},
    // 23 seconds
    { 88, 480, 160},
    { 168, 1016, 48},
    { 248, 640, 104},
    { 240, 728, 96},
    { 312, 672, -16},
    { 360, 728, 128},
    { 480, 808, -16},
    { 504, 1048, 160},
    { 352, 1120, 336},
    { 504, 1424, 304},
    { 136, 1944, 480},
    { 216, 1344, 632},
    { 96, 1080, 392},
    { 184, 840, 312},
    { 248, 480, 184},
    { 304, 568, 88},
    { 336, 584, 336},
    { 376, 824, 232},
    { 368, 904, 288},
    { 432, 912, 152},
    { 336, 1184, 216},
    { 152, 1152, 176},
    { 128, 1088, 184},
    { 168, 1152, 248},
    { 40, 1128, 144},
    // 24 seconds
    { 88, 1112, 16},
    { 192, 808, 32},
    { 200, 552, -96},
    { 264, 536, 8},
    { 312, 640, 48},
    { 328, 768, 80},
    { 368, 800, 112},
    { 368, 856, 64},
    { 464, 1000, 176},
    { 328, 1048, 208},
    { 568, 1360, 384},
    { 144, 1624, 432},
    { 304, 1320, 384},
    { 264, 976, 264},
    { 208, 896, 256},
    { 192, 568, 352},
    { 128, 480, 16},
    { 192, 600, 224},
    { 232, 664, 288},
    { 344, 896, 240},
    { 408, 816, 296},
    { 440, 944, 168},
    { 344, 1000, 208},
    { 328, 1120, 184},
    { 200, 1256, 168},
    // 25 seconds
    { 184, 1136, 152},
    { 104, 1096, 48},
    { 88, 1048, 96},
    { 16, 1072, 48},
    { 152, 888, 0},
    { 184, 696, -8},
    { 296, 552, 24},
    { 304, 792, -112},
    { 264, 520, -168},
    { 344, 880, 24},
    { 360, 848, 112},
    { 528, 944, 24},
    { 376, 1192, 136},
    { 408, 928, 168},
    { 608, 1368, 240},
    { 264, 1176, 440},
    { 392, 1296, 360},
    { 280, 936, 392},
    { 184, 832, 488},
    { 232, 848, 184},
    { 240, 448, 280},
    { 272, 696, 296},
    { 352, 872, 272},
    { 392, 720, 176},
    { 536, 1024, 200},
    // 26 seconds
    { 352, 1120, 216},
    { 336, 1192, 240},
    { 152, 1440, 320},
    { 8, 1112, 48},
    { 24, 976, 56},
    { -88, 848, 184},
    { 96, 1048, 40},
    { 152, 976, -32},
    { 136, 416, -200},
    { 224, 608, -168},
    { 240, 728, 80},
    { 304, 840, 32},
    { 336, 912, 56},
    { 480, 944, 104},
    { 384, 1208, 136},
    { 400, 1072, 408},
    { 384, 1608, 320},
    { 184, 1216, 408},
    { 200, 1032, 224},
    { 152, 824, 240},
    { 176, 744, 360},
    { 184, 656, 72},
    { 224, 736, 208},
    { 256, 840, 296},
    { 240, 952, 336},
    // 27 seconds
    { 272, 952, 240},
    { 232, 1160, 128},
    { 120, 1096, 112},
    { 120, 1352, 168},
    { 16, 1104, 160},
    { 152, 1008, -120},
    { 128, 872, 8},
    { 176, 912, 80},
    { 120, 552, 88},
    { 248, 560, -144},
    { 256, 840, -104},
    { 344, 600, 272},
    { 448, 904, 48},
    { 504, 976, 112},
    { 544, 1016, 152},
    { 248, 1128, 56},
    { 576, 1336, 256},
    { 144, 1288, 152},
    { 320, 1200, 264},
    { 184, 992, 288},
    { 88, 840, 104},
    { 208, 544, 272},
    { 312, 552, 280},
    { 288, 920, 120},
    { 344, 824, 128},
    // 28 seconds
    { 272, 1048, 224},
    { 368, 1184, 176},
    { 88, 1184, 152},
    { 168, 1048, 112},
    { 128, 1152, 160},
    { 72, 1048, -104},
    { 232, 960, 0},
    { 256, 976, 96},
    { 336, 968, 8},
    { 272, 912, -80},
    { 216, 520, 88},
    { 272, 744, -72},
    { 256, 736, 80},
    { 376, 800, 112},
    { 424, 1168, 112},
    { 200, 1096, 184},
    { 544, 1408, 288},
    { 32, 1400, 184},
    { 328, 1216, 256},
    { 208, 888, 160},
    { 152, 640, 120},
    { 144, 480, 192},
    { 280, 456, -128},
    { 360, 712, 200},
    { 344, 928, 192},
    // 29 seconds
    { 320, 960, 72},
    { 320, 1072, 152},
    { 160, 904, 64},
    { 88, 1336, -128},
    { 88, 960, 176},
    { 24, 1184, -40},
    { 104, 1056, -24},
    { 120, 992, 56},
    { 104, 952, -128},
    { 184, 640, 200},
    { 352, 560, -88},
    { 288, 744, 24},
    { 336, 712, 160},
    { 424, 1056, -96},
    { 480, 1032, 200},
    { 264, 1272, 40},
    { 360, 968, 128},
    { 448, 1216, 88},
    { 232, 1208, 208},
    { 184, 1320, 352},
    { 136, 872, 320},
    { 152, 984, 168},
    { 256, 496, 208},
    { 336, 784, 216},
    { 376, 808, 304},
    // 30 seconds
    { 336, 928, 64},
    { 208, 952, 168},
    { 104, 1040, 208},
    { 88, 1248, 48},
    { 72, 1096, 144},
    { 24, 1096, 88},
    { -72, 1112, -320},
    { -16, 848, -72},
    { 32, 1032, -136},
    { 184, 920, 336},
    { 224, 560, 120},
    { 224, 592, 0},
    { 280, 800, -104},
    { 336, 912, 72},
    { 432, 1024, 136},
    { 368, 1112, 88},
    { 288, 992, -16},
    { 448, 1136, 216},
    { 176, 1584, 168},
    { 160, 1328, 408},
    { 48, 1328, 8},
    { -24, 944, 120},
    { 104, 648, 192},
    { 312, 680, 112},
    { 280, 800, 240},
    // 31 seconds
    { 344, 784, 184},
    { 232, 1024, 48},
    { 216, 1120, 160},
    { 136, 1048, 88},
    { 88, 1248, -64},
    { -56, 648, -248},
    { -64, 960, -40},
    { -56, 1040, -16},
    { 40, 1200, 224},
    { 40, 952, -168},
    { 200, 656, -64},
    { 248, 568, -56},
    { 264, 712, 0},
    { 312, 768, 80},
    { 432, 888, 48},
    { 488, 1016, 144},
    { 368, 1120, 120},
    { 432, 936, 152},
    { 560, 1280, 200},
    { 104, 1528, 240},
    { 8, 1120, 0},
    { -24, 1160, 336},
    { 40, 928, 448},
    { 200, 624, 144},
    { 224, 704, 160},
    // 32 seconds
    { 256, 536, 248},
    { 304, 936, 96},
    { 312, 840, 232},
    { 224, 1016, 208},
    { 216, 1192, 344},
    { 104, 1168, -176},
    { 32, 1304, -112},
    { -120, 1160, 88},
    { 0, 1232, 72},
    { -40, 1112, 32},
    { 104, 856, -40},
    { 184, 712, -112},
    { 216, 552, 64},
    { 296, 704, 88},
    { 336, 824, 80},
    { 432, 816, 160},
    { 480, 1080, 64},
    { 424, 1040, 104},
    { 432, 968, 80},
    { 560, 904, 160},
    { 552, 1376, 336},
    { 144, 1544, 744},
    { -80, 824, 128},
    { 152, 800, 224},
    { 160, 656, 480},
    // 33 seconds
    { 216, 760, 128},
    { 248, 576, 352},
    { 320, 728, 152},
    { 336, 864, 120},
    { 320, 736, 240},
    { 296, 1192, 96},
    { 184, 1016, 128},
    { 120, 1200, 104},
    { 24, 1256, 304},
    { -32, 1264, -120},
    { -40, 816, 352},
    { -24, 1376, 232},
    { -16, 856, -80},
    { 208, 600, 56},
    { 224, 560, 40},
    { 272, 704, 144},
    { 304, 872, 184},
    { 360, 1016, 88},
    { 376, 1032, 208},
    { 440, 1152, 104},
    { 400, 1056, 272},
    { 464, 1152, -8},
    { 408, 1448, 352},
    { 32, 1088, 392},
    { 64, 1240, 520},
    // 34 seconds
    { 32, 760, 320},
    { 152, 824, 320},
    { 240, 576, 184},
    { 288, 656, 112},
    { 360, 712, 160},
    { 400, 888, 240},
    { 432, 912, 320},
    { 192, 800, 272},
    { 72, 1480, 184},
    { -56, 1008, 144},
    { -8, 1032, 256},
    { 8, 1248, 112},
    { 72, 1088, 224},
    { 128, 1024, 80},
    { 216, 824, -8},
    { 264, 520, 96},
    { 312, 624, 64},
    { 344, 720, 192},
    { 352, 888, 224},
    { 440, 960, 128},
    { 464, 976, 208},
    { 392, 1000, 168},
    { 336, 1072, 264},
    { 176, 552, -216},
    { 264, 1824, 240},
    // 35 seconds
    { -448, 1544, 824},
    { -192, 1328, 320},
    { -24, 944, 272},
    { 80, 520, 320},
    { 184, 552, 56},
    { 224, 528, 144},
    { 336, 536, 184},
    { 264, 1168, 72},
    { 272, 640, -64},
    { 200, 1312, 192},
    { 40, 1152, 192},
    { 8, 992, 40},
    { 0, 1112, 160},
    { -56, 936, 208},
    { 16, 1120, 40},
    { 48, 1040, 200},
    { 88, 960, 72},
    { 160, 768, 80},
    { 224, 656, 8},
    { 288, 680, 56},
    { 304, 848, 24},
    { 280, 1200, 200},
    { 288, 808, -152},
    { 232, 1176, 24},
    { 136, 1048, 96},
    // 36 seconds
    { 336, 1240, 272},
    { -16, 1688, 224},
    { -40, 1264, 288},
    { -32, 1048, 160},
    { 0, 672, 144},
    { 144, 424, 192},
    { 256, 504, 112},
    { 240, 776, 248},
    { 272, 808, 56},
    { 224, 1008, 304},
    { 216, 1144, -128},
    { 136, 880, 224},
    { 24, 1296, -112},
    { -80, 1200, 32},
    { -136, 968, -344},
    { 8, 840, -216},
    { 80, 872, -16},
    { 112, 1016, -144},
    { 224, 704, -96},
    { 272, 688, -144},
    { 336, 664, 32},
    { 232, 1024, -48},
    { 232, 856, 40},
    { 384, 1176, 128},
    { 216, 1344, 72},
    // 37 seconds
    { 416, 1336, 176},
    { 176, 1208, 128},
    { 208, 1144, 200},
    { 216, 1072, 232},
    { 32, 864, 216},
    { 88, 608, 208},
    { 200, 768, 56},
    { 112, 440, 120},
    { 320, 944, 48},
    { 184, 960, 168},
    { 232, 1248, 136},
    { 96, 1216, 184},
    { 72, 1280, 80},
    { 48, 1144, 200},
    { 0, 1040, -104},
    { 88, 888, -88},
    { 128, 768, 104},
    { 216, 776, 40},
    { 304, 744, -16},
    { 240, 800, 168},
    { 240, 712, 40},
    { 288, 984, 168},
    { 424, 904, 8},
    { 464, 1336, 160},
    { 224, 984, 192},
    // 38 seconds
    { 512, 1456, 216},
    { 88, 1312, 208},
    { 256, 1032, 176},
    { 184, 872, 224},
    { 56, 760, 240},
    { 144, 560, 216},
    { 288, 736, 56},
    { 240, 952, 160},
    { 256, 864, 144},
    { 224, 920, 288},
    { 184, 1328, 80},
    { 80, 1136, 136},
    { 32, 1096, 88},
    { 48, 1088, 128},
    { 56, 1144, -64},
    { 96, 936, 24},
    { 128, 920, 40},
    { 200, 760, 16},
    { 296, 632, -48},
    { 328, 696, 0},
    { 400, 696, 160},
    { 312, 848, 96},
    { 376, 864, 80},
    { 336, 1208, 56},
    { 336, 1112, 416},
    // 39 seconds
    { 376, 1496, 200},
    { 168, 1352, 256},
    { 216, 1080, 192},
    { 104, 904, 200},
    { 72, 632, 200},
    { 216, 496, 176},
    { 320, 720, 104},
    { 200, 960, 168},
    { 192, 960, 152},
    { 224, 1048, 400},
    { 256, 1216, 120},
    { 160, 1216, 128},
    { 120, 1088, 184},
    { 72, 1016, 88},
    { 88, 1000, -72},
    { 112, 896, 80},
    { 152, 992, 56},
    { 232, 776, 16},
    { 272, 648, -32},
    { 312, 664, 32},
    { 288, 800, 48},
    { 392, 752, 104},
    { 344, 896, -24},
    { 272, 1432, 88},
    { 56, 1120, 152},
    // 40 seconds
    { 456, 1424, 360},
    { 80, 1456, 256},
    { 240, 1224, 272},
    { 152, 1008, 272},
    { 96, 672, 248},
    { 192, 528, 160},
    { 280, 512, 200},
    { 224, 600, 88},
    { 304, 568, 16},
    { 304, 920, 152},
    { 232, 1192, 176},
    { 112, 1184, 216},
    { 112, 1256, 56},
    { 40, 1056, 88},
    { 48, 1088, 0},
    { 72, 1112, -16},
    { 128, 920, 104},
    { 216, 904, -64},
    { 312, 584, 8},
    { 408, 576, 80},
    { 456, 936, 128},
    { 280, 976, -16},
    { 304, 1008, 72},
    { 384, 1000, 152},
    { 280, 1240, 56},
    // 41 seconds
    { 368, 1088, 384},
    { 160, 1728, 96},
    { 152, 1208, 280},
    { 216, 1056, 184},
    { 152, 832, 184},
    { 184, 616, 168},
    { 128, 520, 24},
    { 184, 416, 32},
    { 288, 784, 104},
    { 232, 992, 224},
    { 176, 1088, 560},
    { 88, 1376, 32},
    { 112, 1464, -80},
    { 104, 808, 328},
    { 48, 1080, -88},
    { 192, 840, 128},
    { 256, 808, 176},
    { 296, 744, 72},
    { 400, 584, 144},
    { 376, 680, -48},
    { 304, 616, -112},
    { 464, 752, 72},
    { 456, 1136, 32},
    { 424, 1224, 216},
    { 368, 888, 264},
    // 42 seconds
    { 448, 1328, 96},
    { 192, 1240, 248},
    { 280, 1024, 192},
    { 192, 992, 224},
    { 144, 760, 232},
    { 216, 824, 96},
    { 152, 360, -64},
    { 296, 768, 168},
    { 184, 936, 152},
    { 256, 960, 352},
    { 168, 1016, 256},
    { 8, 1120, 136},
    { 72, 1144, 360},
    { 16, 1160, -48},
    { 256, 1064, -152},
    { 176, 776, 120},
    { 200, 816, -40},
    { 232, 616, 8},
    { 240, 600, 176},
    { 224, 872, 112},
    { 264, 872, 136},
    { 360, 1000, 32},
    { 376, 1016, 264},
    { 320, 1232, 168},
    { 296, 1200, 136},
    // 43 seconds
    { 328, 1528, 192},
    { -64, 1160, 528},
    { 136, 1128, 560},
    { 56, 904, 448},
    { 0, 712, 344},
    { 160, 520, 152},
    { 184, 616, 208},
    { 216, 680, 288},
    { 328, 832, 200},
    { 360, 1264, 248},
    { 216, 792, 56},
    { 168, 1192, 376},
    { 128, 1160, 408},
    { 8, 1216, 488},
    { 16, 1056, 88},
    { 80, 768, 160},
    { 72, 1000, 144},
    { 176, 920, 184},
    { 280, 776, 72},
    { 288, 704, 144},
    { 408, 928, 192},
    { 336, 1192, 112},
    { 248, 968, 200},
    { 288, 1048, 216},
    { 216, 1200, 440},
    // 44 seconds
    { 176, 1328, 400},
    { 112, 1536, 448},
    { 40, 992, 376},
    { 152, 1016, 296},
    { 80, 960, 328},
    { 96, 736, 312},
    { 232, 720, 344},
    { 304, 744, 64},
    { 240, 776, 200},
    { 224, 904, 256},
    { 272, 976, 424},
    { 208, 1072, 256},
    { 104, 1216, 280},
    { 80, 1312, 344},
    { -144, 1176, 344},
    { -32, 976, 16},
    { 32, 776, 144},
    { 64, 832, 184},
    { 160, 800, 24},
    { 240, 584, 224},
    { 152, 520, -72},
    { 200, 792, -112},
    { 264, 824, 88},
    { 288, 896, 176},
    { 320, 1072, 280},
    // 45 seconds
    { 152, 1200, 256},
    { 360, 1400, 456},
    { -64, 1392, 360},
    { 216, 1120, 328},
    { 152, 896, 296},
    { 112, 704, 288},
    { 192, 544, 296},
    { 200, 784, 112},
    { 240, 536, -32},
    { 224, 904, 360},
    { 232, 888, 264},
    { 256, 1072, 296},
    { 160, 1280, 280},
    { 8, 1352, 408},
    { -32, 1032, 320},
    { 56, 920, -16},
    { 136, 704, 200},
    { 80, 928, 200},
    { 120, 848, 88},
    { 184, 696, 80},
    { 216, 704, 120},
    { 296, 856, 152},
    { 288, 880, 8},
    { 432, 944, -64},
    { 392, 1112, 208},
    // 46 seconds
    { 144, 1208, 416},
    { 296, 1512, 624},
    { -176, 1384, 448},
    { 72, 976, 320},
    { 88, 840, 296},
    { 24, 760, 256},
    { 72, 616, 288},
    { 168, 688, 184},
    { 200, 680, 224},
    { 232, 768, 296},
    { 208, 696, 320},
    { 160, 936, 88},
    { 248, 1160, 408},
    { 80, 1104, 400},
    { 64, 1416, 448},
    { 0, 1288, 552},
    { -32, 992, 192},
    { 64, 872, 96},
    { 8, 904, 256},
    { 88, 848, 144},
    { 184, 712, 96},
    { 256, 600, 128},
    { 232, 728, 200},
    { 136, 1088, 152},
    { 256, 840, 280},
    // 47 seconds
    { 344, 976, 304},
    { 248, 1160, 200},
    { 200, 1088, 320},
    { 304, 1328, 432},
    { 16, 1352, 272},
    { 160, 1096, 352},
    { 152, 976, 264},
    { 72, 720, 288},
    { 128, 640, 200},
    { 176, 584, 240},
    { 136, 512, 48},
    { 288, 1032, 208},
    { 200, 1040, 320},
    { 304, 992, 304},
    { 120, 1112, 272},
    { 192, 952, 272},
    { 120, 1088, 272},
    { -40, 1008, 56},
    { 72, 968, 144},
    { 8, 872, 368},
    { 80, 984, 160},
    { 168, 824, 96},
    { 224, 672, 256},
    { 200, 976, 176},
    { 224, 832, 288},
    // 48 seconds
    { 184, 848, 184},
    { 336, 1024, 328},
    { 256, 1008, 352},
    { 120, 1128, 344},
    { 400, 1240, 656},
    { -88, 1408, 536},
    { 168, 1144, 448},
    { -8, 752, 456},
    { 128, 736, 232},
    { 104, 680, 312},
    { 160, 632, 312},
    { 176, 760, 304},
    { 192, 752, 336},
    { 200, 848, 472},
    { 144, 904, 216},
    { 112, 1120, 384},
    { 80, 1224, 560},
    { -192, 1096, 696},
    { -112, 1168, 104},
    { -112, 792, 464},
    { -32, 904, 328},
    { 96, 808, 256},
    { 208, 696, 224},
    { 256, 624, 256},
    { 272, 784, 280},
    // 49 seconds
    { 304, 920, 480},
    { 232, 792, 264},
    { 280, 976, 344},
    { 160, 1032, 448},
    { 136, 1072, 672},
    { -56, 1800, 792},
    { -240, 1216, 680},
    { -64, 1040, 488},
    { -64, 840, 408},
    { -8, 664, 312},
    { 96, 624, 288},
    { 72, 624, 312},
    { 64, 688, 288},
    { 136, 832, 272},
    { 176, 776, 328},
    { 160, 984, 216},
    { 160, 1192, 96},
    { 64, 808, 128},
    { -32, 504, 80},
    { -584, 128, -264},
    { -1104, 1144, -664},
    { -992, 1032, -232},
    { -872, 1288, -400},
    { -544, 888, -272},
    { -312, 800, -232},
    // 50 seconds
    { -208, 736, -232},
    { -224, 760, -168},
    { -280, 736, -232},
    { -232, 712, -376},
    { -440, 736, -320},
    { -712, 768, -424},
    { -696, 784, -512},
    { -512, 1288, -528},
    { -216, 1280, -432},
    { -160, 1080, -504},
    { -336, 1304, -512},
    { -432, 800, -592},
    { -592, 736, -728},
    { -640, 464, -712},
    { -560, 192, -656},
    { -664, 1376, 176},
    { -552, 400, -720},
    { -376, 184, -768},
    { -168, -240, -736},
    { -80, -88, -816},
    { -96, -144, -872},
    { -280, 16, -672},
    { 8, -200, -848},
    { -120, -224, -864},
    { -216, -192, -872},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

