/* SPDX-FileCopyrightText: 2024 Google LLC */
/* SPDX-License-Identifier: Apache-2.0 */


// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:04:21 local
AccelRawData *activity_sample_walk_200_pbl_25671_9(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25671_9
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { 192, 472, -776},
    { 72, 616, -928},
    { -32, 328, -872},
    { -72, 256, -968},
    { -56, 168, -912},
    { -224, 32, -616},
    { 120, 136, -1000},
    { -48, 176, -864},
    { 40, 176, -872},
    { 24, 104, -856},
    { 72, -32, -912},
    { -56, 24, -896},
    { -80, 104, -960},
    { -56, 104, -952},
    { -56, 72, -920},
    { -32, 96, -952},
    { -72, 64, -928},
    { -64, 56, -952},
    { -96, 64, -912},
    { -56, 32, -960},
    { -96, 8, -960},
    { -104, 24, -928},
    { -128, 48, -904},
    { -104, -24, -912},
    { -112, 96, -944},
    // 1 seconds
    { -56, -32, -920},
    { -104, -32, -936},
    { -88, 8, -912},
    { -104, -24, -880},
    { -160, -64, -920},
    { -224, -96, -912},
    { -216, 24, -904},
    { -40, 88, -1040},
    { -112, 216, -952},
    { 0, -120, -920},
    { 48, 128, -1048},
    { -128, -56, -872},
    { -152, 48, -912},
    { -160, -8, -864},
    { -176, 0, -856},
    { -384, -144, -824},
    { -232, -112, -904},
    { -176, 8, -936},
    { -144, 224, -984},
    { -128, 368, -1032},
    { -112, 328, -904},
    { -56, 344, -920},
    { -24, 272, -848},
    { -24, 328, -912},
    { -16, 232, -904},
    // 2 seconds
    { 8, 200, -888},
    { 48, 128, -856},
    { 80, 120, -824},
    { 56, 96, -864},
    { 32, 56, -832},
    { -8, 24, -888},
    { 0, 0, -896},
    { 8, -40, -864},
    { 8, 56, -888},
    { 16, 40, -792},
    { -120, 408, -1016},
    { 16, 424, -784},
    { -352, 648, -640},
    { -368, 968, -352},
    { -368, 448, 40},
    { -472, 1256, -80},
    { -520, 896, -160},
    { -520, 448, 168},
    { -640, 680, 72},
    { -648, 824, -72},
    { -672, 856, 40},
    { -664, 912, -120},
    { -952, 1176, -352},
    { -1072, 960, 8},
    { -1096, 960, -96},
    // 3 seconds
    { -1184, 800, -104},
    { -1232, 680, -8},
    { -440, 296, -24},
    { -664, 328, -112},
    { -824, 96, 152},
    { -696, 280, 8},
    { -592, 360, -80},
    { -616, 384, -72},
    { -680, 448, -64},
    { -712, 520, -136},
    { -760, 952, -376},
    { -904, 488, -72},
    { -808, 632, -256},
    { -1056, 600, -184},
    { -1416, 664, -168},
    { -1328, 592, -120},
    { -1272, 424, 0},
    { -944, 512, -120},
    { -688, 376, 8},
    { -600, 336, -8},
    { -608, 344, 8},
    { -648, 352, 48},
    { -728, 424, 72},
    { -768, 344, 16},
    { -992, 192, 48},
    // 4 seconds
    { -1096, 456, -168},
    { -856, 296, -120},
    { -1568, 424, -64},
    { -1112, 320, 40},
    { -984, 472, -144},
    { -952, 512, -208},
    { -608, 304, -56},
    { -336, 344, -32},
    { -432, 408, -32},
    { -520, 496, -48},
    { -864, 752, -128},
    { -928, 200, -288},
    { -888, 664, -320},
    { -1048, 672, -344},
    { -1504, 648, -456},
    { -2032, 664, -432},
    { -1472, 240, -256},
    { -1144, 224, -208},
    { -776, 232, -104},
    { -584, 152, 56},
    { -544, 136, 112},
    { -592, 216, 56},
    { -632, 136, 96},
    { -520, 384, -280},
    { -848, 248, 128},
    // 5 seconds
    { -1024, 408, -104},
    { -1000, 320, -144},
    { -1696, 576, -120},
    { -1280, 296, -112},
    { -1008, 496, -352},
    { -1072, 352, -192},
    { -696, 96, -144},
    { -312, 392, -480},
    { -520, 216, -344},
    { -576, 280, -408},
    { -784, 696, -376},
    { -1120, 280, -544},
    { -776, 288, -256},
    { -984, 488, -368},
    { -1040, 448, -232},
    { -1760, 728, -408},
    { -1344, 448, -280},
    { -984, 288, -240},
    { -760, 328, -256},
    { -704, 152, -120},
    { -648, 64, 16},
    { -632, 128, 0},
    { -720, 184, -40},
    { -960, 296, -48},
    { -864, -232, -272},
    // 6 seconds
    { -1128, 8, -144},
    { -1120, -224, 64},
    { -1712, 544, -248},
    { -1496, 136, -80},
    { -936, 312, -264},
    { -960, 248, -240},
    { -640, 8, 8},
    { -344, 120, -120},
    { -480, 256, -96},
    { -640, 384, -104},
    { -800, 656, -240},
    { -1136, 816, -624},
    { -1016, 408, -312},
    { -1048, 336, -376},
    { -1160, 232, -264},
    { -1760, 672, -504},
    { -1280, 104, -320},
    { -1192, 136, -184},
    { -968, -176, 56},
    { -544, -56, 24},
    { -544, 152, -56},
    { -656, 136, -40},
    { -696, 272, 128},
    { -1176, 488, -312},
    { -1176, -40, 24},
    // 7 seconds
    { -1288, 184, -176},
    { -1088, 280, -232},
    { -1520, 88, -120},
    { -952, 232, -248},
    { -1056, 200, -248},
    { -936, 56, -104},
    { -552, 128, -152},
    { -440, 240, -200},
    { -528, 304, -232},
    { -688, 440, -344},
    { -776, 352, -256},
    { -1296, 728, -352},
    { -1000, 296, -320},
    { -1032, 72, -240},
    { -1616, 616, -576},
    { -1376, -40, -56},
    { -1120, 120, -184},
    { -1064, 16, -48},
    { -792, -136, 120},
    { -496, 120, -88},
    { -640, 128, 32},
    { -816, 128, 0},
    { -912, 216, -72},
    { -872, 672, -472},
    { -1312, 40, -48},
    // 8 seconds
    { -1160, 360, -184},
    { -1576, 320, -192},
    { -456, 304, -264},
    { -1016, 288, -192},
    { -984, -64, 120},
    { -648, 40, -24},
    { -504, 184, -184},
    { -568, 144, -128},
    { -680, 192, -176},
    { -808, 272, -240},
    { -1016, 640, -376},
    { -1080, -24, -488},
    { -1016, 216, -352},
    { -1464, 288, -280},
    { -1976, 456, -432},
    { -1184, 80, 16},
    { -1040, 280, -304},
    { -800, 40, -24},
    { -416, 56, 48},
    { -512, 184, -40},
    { -640, 136, 32},
    { -1000, 728, -368},
    { -1024, 128, 48},
    { -1248, 120, -40},
    { -1176, 208, -160},
    // 9 seconds
    { -1328, 408, -272},
    { -1544, 160, -72},
    { -728, 248, -280},
    { -1024, 256, -320},
    { -824, -16, -56},
    { -488, 128, -160},
    { -440, 200, -176},
    { -520, 224, -192},
    { -752, 360, -256},
    { -1152, 600, -456},
    { -1056, 328, -296},
    { -1088, 392, -464},
    { -1080, 64, -152},
    { -1544, 472, -840},
    { -1408, 72, -96},
    { -1216, 176, -152},
    { -960, 208, -240},
    { -544, 72, -168},
    { -480, 168, -152},
    { -608, 208, -72},
    { -624, 48, 160},
    { -488, 592, -296},
    { -808, 384, -24},
    { -1000, 352, -96},
    { -1048, 352, -280},
    // 10 seconds
    { -1048, 360, -72},
    { -1664, 216, -120},
    { -680, 424, -568},
    { -1112, 280, -296},
    { -992, -40, -56},
    { -648, 56, -128},
    { -400, 48, -192},
    { -312, 56, -128},
    { -432, 232, -280},
    { -656, 488, -312},
    { -1264, 664, -456},
    { -1112, 568, -512},
    { -1288, 184, -144},
    { -2240, 736, -432},
    { -1264, 208, 80},
    { -1056, 248, -176},
    { -1000, 128, -200},
    { -520, -112, -16},
    { -344, 136, -128},
    { -352, 56, -24},
    { -768, -56, 16},
    { -1152, 144, -160},
    { -1104, -8, -24},
    { -1384, 96, -232},
    { -1352, 128, -24},
    // 11 seconds
    { -1416, 192, -112},
    { -1048, 64, -240},
    { -640, 56, -216},
    { -1064, 24, -160},
    { -864, 64, -40},
    { -504, 144, -144},
    { -464, 192, -192},
    { -560, 208, -200},
    { -776, 248, -240},
    { -880, 96, -224},
    { -1008, 360, -384},
    { -1432, 608, -536},
    { -1088, 48, -240},
    { -1752, 456, -624},
    { -1632, 64, -104},
    { -1168, 224, -112},
    { -1064, 112, -168},
    { -544, -48, -32},
    { -296, 48, -8},
    { -440, 72, 56},
    { -640, 128, 72},
    { -920, 168, 0},
    { -1088, 584, -40},
    { -1520, -56, -216},
    { -1240, 32, -144},
    // 12 seconds
    { -1264, 64, -96},
    { -1504, 72, -104},
    { -880, 192, -248},
    { -976, 184, -304},
    { -808, -32, -200},
    { -504, -24, -176},
    { -368, 112, -272},
    { -456, 184, -240},
    { -584, 344, -248},
    { -896, -16, -352},
    { -960, -24, -208},
    { -1096, 400, -576},
    { -1064, 112, -280},
    { -1936, 456, -728},
    { -1568, -64, 0},
    { -1256, 112, -176},
    { -1056, 432, -248},
    { -680, 64, 32},
    { -376, 32, -64},
    { -344, 88, -96},
    { -480, 720, -216},
    { -1000, -224, 176},
    { -944, 200, -80},
    { -1240, 368, -224},
    { -1056, -16, -152},
    // 13 seconds
    { -1112, 72, -184},
    { -1560, 16, -152},
    { -936, 144, -376},
    { -968, 40, -288},
    { -760, -96, -200},
    { -416, -48, -96},
    { -360, 232, -168},
    { -552, 232, -192},
    { -912, 776, -440},
    { -1408, 96, -256},
    { -1024, 176, -408},
    { -1184, 216, -368},
    { -1384, 224, -352},
    { -1560, 384, -440},
    { -1192, 144, -176},
    { -1088, 272, -304},
    { -864, 24, -56},
    { -552, 24, -8},
    { -488, 32, 8},
    { -696, 56, 32},
    { -904, -184, 176},
    { -680, 632, -56},
    { -1296, 200, -24},
    { -1256, -80, -8},
    { -1392, 192, -184},
    // 14 seconds
    { -1224, 240, -72},
    { -856, 376, -304},
    { -960, 216, -216},
    { -760, 112, -176},
    { -448, 112, -176},
    { -384, 168, -240},
    { -464, 296, -288},
    { -696, 368, -304},
    { -1384, 560, -152},
    { -952, 72, -136},
    { -1176, 440, -472},
    { -1024, 96, -168},
    { -1384, 512, -384},
    { -1464, 328, -240},
    { -1216, 40, -56},
    { -968, 248, -120},
    { -688, 64, 0},
    { -456, 128, 0},
    { -624, 208, -40},
    { -904, 224, -64},
    { -880, 256, -128},
    { -1008, 408, -80},
    { -1136, -304, -296},
    { -1152, 16, -96},
    { -1640, 32, -88},
    // 15 seconds
    { -816, 440, -272},
    { -872, 104, -240},
    { -968, 184, -232},
    { -600, -24, -184},
    { -400, 8, -216},
    { -408, 96, -256},
    { -640, 264, -280},
    { -1048, 608, -512},
    { -1152, -240, -424},
    { -1016, 432, -520},
    { -1032, 184, -344},
    { -1576, 512, -712},
    { -1504, -16, -112},
    { -1216, 176, -176},
    { -1080, 176, -144},
    { -808, 0, -72},
    { -616, 96, -64},
    { -560, 64, -32},
    { -720, 32, 8},
    { -712, 24, 104},
    { -904, 688, -288},
    { -1120, 56, -48},
    { -1288, -88, 8},
    { -1272, 0, -160},
    { -1480, 48, 8},
    // 16 seconds
    { -920, 328, -104},
    { -944, 352, -352},
    { -864, 24, -232},
    { -512, -72, -184},
    { -440, 8, -224},
    { -528, 184, -328},
    { -696, 280, -360},
    { -792, 416, -304},
    { -1336, 552, -424},
    { -928, 152, -432},
    { -1000, 64, -296},
    { -1680, 528, -608},
    { -1792, 152, -176},
    { -1232, 16, -96},
    { -936, 464, -336},
    { -848, -64, 24},
    { -792, -96, 80},
    { -648, -32, 40},
    { -656, 24, -24},
    { -768, 40, 32},
    { -856, 40, -112},
    { -872, 64, 32},
    { -1256, 288, -64},
    { -1152, 80, 56},
    { -1720, 488, -176},
    // 17 seconds
    { -784, 272, -72},
    { -920, 312, -304},
    { -976, 48, -248},
    { -616, -104, -224},
    { -488, 56, -264},
    { -616, 160, -232},
    { -816, 256, -304},
    { -888, 8, -112},
    { -1080, 416, -328},
    { -1216, -200, -496},
    { -1128, 152, -296},
    { -1328, 312, -408},
    { -1784, 720, -584},
    { -1408, 16, 56},
    { -952, 160, -104},
    { -704, 40, 8},
    { -552, 128, -24},
    { -656, 256, 0},
    { -800, 344, -56},
    { -944, 48, 160},
    { -848, -256, 184},
    { -904, 200, 24},
    { -1208, 120, -96},
    { -1288, 200, -176},
    { -1672, 216, -176},
    // 18 seconds
    { -696, 400, -168},
    { -984, 0, -176},
    { -920, -40, -112},
    { -528, 88, -216},
    { -448, 160, -208},
    { -568, 200, -168},
    { -744, 248, -256},
    { -1208, 8, -312},
    { -928, 256, -336},
    { -888, 320, -408},
    { -1160, 312, -472},
    { -1368, 280, -424},
    { -1760, 392, -408},
    { -1096, 8, -96},
    { -1008, 280, -264},
    { -888, 248, -152},
    { -632, 88, 0},
    { -488, 152, 0},
    { -576, 192, 40},
    { -744, 120, -128},
    { -976, -104, -104},
    { -920, 64, 8},
    { -1184, 240, -168},
    { -1136, 40, -120},
    { -1512, 88, -32},
    // 19 seconds
    { -1248, 88, -80},
    { -736, 160, -200},
    { -896, 176, -224},
    { -816, 104, -208},
    { -568, 56, -216},
    { -504, 144, -248},
    { -568, 176, -264},
    { -984, 344, -432},
    { -752, -432, -216},
    { -832, 240, -472},
    { -1056, 272, -440},
    { -920, 56, -216},
    { -1064, 104, -304},
    { -1896, 624, -672},
    { -1368, 64, -40},
    { -1208, 264, -288},
    { -872, 144, -120},
    { -472, -8, -32},
    { -400, 176, -104},
    { -568, 528, 112},
    { -1088, 608, -368},
    { -984, 144, -240},
    { -992, 208, -264},
    { -1176, 328, -264},
    { -1168, 152, -80},
    // 20 seconds
    { -1624, -88, -96},
    { -800, 64, -136},
    { -1176, 8, -184},
    { -1096, 0, -200},
    { -656, -88, -112},
    { -432, 160, -288},
    { -448, -304, -112},
    { -496, -200, -480},
    { -808, 152, -496},
    { -920, 248, -624},
    { -1008, 288, -632},
    { -1136, -168, -232},
    { -1760, 312, -720},
    { -1328, 32, -184},
    { -1120, 192, -320},
    { -840, 304, -336},
    { -648, 32, 32},
    { -520, 64, -16},
    { -440, -112, 80},
    { -600, -200, -88},
    { -872, 24, -8},
    { -968, 336, -272},
    { -1240, 264, -320},
    { -1456, 0, -152},
    { -1568, -80, 0},
    // 21 seconds
    { -896, 184, -280},
    { -872, 8, -152},
    { -1104, -104, -64},
    { -952, 0, -128},
    { -560, 0, -216},
    { -416, -120, -112},
    { -384, -304, -384},
    { -576, 96, -432},
    { -776, 176, -424},
    { -800, 216, -472},
    { -1048, 288, -648},
    { -1128, 144, -272},
    { -1608, 416, -656},
    { -1424, 312, -408},
    { -1408, 136, -256},
    { -1184, 320, -360},
    { -632, 32, -56},
    { -400, 96, -72},
    { -424, 240, -112},
    { -680, 8, -80},
    { -792, 112, -32},
    { -944, 304, -248},
    { -1152, 200, -224},
    { -1152, -16, -96},
    { -1560, 168, -216},
    // 22 seconds
    { -1376, 40, -96},
    { -656, 192, -376},
    { -960, 232, -240},
    { -864, 64, -232},
    { -560, 48, -224},
    { -336, 264, -408},
    { -536, -8, -80},
    { -472, 96, -600},
    { -872, 184, -352},
    { -920, 280, -400},
    { -1072, 552, -656},
    { -1472, 216, -424},
    { -1936, 512, -624},
    { -1072, -32, -80},
    { -1072, 208, -336},
    { -760, 264, -240},
    { -480, -24, -32},
    { -736, -120, -168},
    { -464, -688, 64},
    { -720, 368, -48},
    { -848, 512, -184},
    { -1152, 272, -256},
    { -1128, 144, -392},
    { -1368, -40, -80},
    { -1440, 192, -520},
    // 23 seconds
    { -704, 336, -664},
    { -1056, 120, -368},
    { -736, -88, -136},
    { -456, 216, -320},
    { -368, 264, -160},
    { -392, 256, -224},
    { -608, 248, -176},
    { -680, 88, -424},
    { -944, 576, -472},
    { -1032, 408, -384},
    { -936, 376, -360},
    { -1760, 584, -576},
    { -1240, 176, -240},
    { -1240, 344, -456},
    { -944, 312, -296},
    { -568, 256, -208},
    { -632, 272, -96},
    { -480, 320, 192},
    { -712, 976, 0},
    { -840, 800, -248},
    { -1208, 392, -168},
    { -1200, 64, -216},
    { -904, -136, -328},
    { -1680, -240, -104},
    { -1216, 56, -192},
    // 24 seconds
    { -1048, 296, -400},
    { -1016, 88, -176},
    { -808, -64, -120},
    { -640, 192, -264},
    { -600, 232, -232},
    { -632, 304, -304},
    { -800, 512, -248},
    { -1152, 64, -304},
    { -1000, 472, -424},
    { -920, 512, -504},
    { -1016, 504, -368},
    { -1504, 656, -648},
    { -1224, 312, -224},
    { -1016, 64, -152},
    { -944, 248, -176},
    { -792, 120, -56},
    { -712, 64, 16},
    { -736, 256, -8},
    { -896, 24, 176},
    { -1072, -216, -168},
    { -640, 8, -24},
    { -1032, 168, -184},
    { -1152, 136, -16},
    { -2040, 240, -184},
    { -520, 352, -200},
    // 25 seconds
    { -1016, 192, -144},
    { -960, -288, 0},
    { -624, -328, -72},
    { -448, 80, -264},
    { -520, 208, -312},
    { -640, 328, -416},
    { -824, 280, -384},
    { -888, 248, -360},
    { -1272, 256, -400},
    { -1096, 376, -544},
    { -1744, 592, -760},
    { -1432, 128, -272},
    { -1176, 184, -200},
    { -936, 448, -384},
    { -648, 192, -168},
    { -656, 328, -112},
    { -656, 200, 72},
    { -632, 240, 8},
    { -664, 32, 288},
    { -800, 128, 48},
    { -920, 24, 56},
    { -1064, 120, 40},
    { -1304, 248, 8},
    { -1456, 80, 88},
    { -960, 248, -176},
    // 26 seconds
    { -1408, 368, -392},
    { -1192, 112, -32},
    { -896, 120, -232},
    { -584, 264, -256},
    { -504, 128, -216},
    { -368, 208, -440},
    { -584, 336, -288},
    { -880, 464, -536},
    { -976, 376, -600},
    { -920, 200, -416},
    { -1272, 112, -224},
    { -2096, 664, -464},
    { -1168, 96, -128},
    { -1200, 296, -344},
    { -976, 376, -200},
    { -704, 144, -24},
    { -672, 240, -64},
    { -688, 160, 16},
    { -744, 96, -16},
    { -840, 160, -120},
    { -888, -248, -208},
    { -1152, 40, -224},
    { -952, -392, -8},
    { -1720, -24, -96},
    { -1496, 16, -184},
    // 27 seconds
    { -1048, 184, -240},
    { -1216, 136, -240},
    { -984, 96, -152},
    { -704, 208, -200},
    { -600, 288, -248},
    { -712, 216, -384},
    { -984, 320, -528},
    { -880, 376, -568},
    { -848, 368, -520},
    { -928, 464, -656},
    { -1088, 280, -368},
    { -1720, 504, -712},
    { -1360, 128, -248},
    { -1104, 80, -240},
    { -1096, 256, -264},
    { -1008, 176, -40},
    { -872, 144, -24},
    { -808, 32, 40},
    { -808, -168, -24},
    { -912, 32, 152},
    { -904, 144, 40},
    { -912, 136, -16},
    { -856, -184, 224},
    { -1080, 184, -64},
    { -1528, 56, 48},
    // 28 seconds
    { -840, 272, -240},
    { -1152, 192, -296},
    { -1216, -40, -192},
    { -896, 16, -328},
    { -576, 416, -576},
    { -544, 280, -496},
    { -712, 344, -504},
    { -792, 344, -448},
    { -888, 528, -480},
    { -976, 272, -568},
    { -1120, 408, -360},
    { -1624, 528, -456},
    { -1672, 192, -152},
    { -1240, 224, -192},
    { -1048, 408, -304},
    { -840, 344, -128},
    { -600, 136, 24},
    { -536, 120, -8},
    { -656, 128, 0},
    { -840, 0, 96},
    { -912, -240, 120},
    { -696, -48, -168},
    { -1032, 128, -192},
    { -1016, 136, -152},
    { -1656, 64, -120},
    // 29 seconds
    { -1096, 400, -344},
    { -1032, 304, -312},
    { -1128, 136, -216},
    { -896, 128, -240},
    { -536, 176, -288},
    { -488, 184, -288},
    { -608, 216, -248},
    { -696, 208, -264},
    { -936, -8, -384},
    { -832, 344, -456},
    { -928, 424, -440},
    { -1064, 200, -336},
    { -1176, 280, -360},
    { -1520, 488, -448},
    { -1256, 128, -136},
    { -1168, 352, -328},
    { -1032, 280, -112},
    { -784, 120, -40},
    { -640, 168, -40},
    { -728, 248, 0},
    { -832, 136, 56},
    { -880, 152, 0},
    { -808, -24, -176},
    { -864, 128, -88},
    { -1032, 128, -88},
    // 30 seconds
    { -1160, 224, -256},
    { -1440, 40, -168},
    { -1144, 120, -288},
    { -1016, 120, -320},
    { -968, 80, -344},
    { -864, 96, -328},
    { -648, 152, -328},
    { -584, 168, -320},
    { -624, 192, -352},
    { -696, 152, -320},
    { -816, 184, -496},
    { -952, 232, -408},
    { -800, 88, -544},
    { -952, 144, -496},
    { -1112, 168, -424},
    { -1792, 608, -776},
    { -1400, 24, -136},
    { -1184, -48, -176},
    { -1040, 256, -264},
    { -952, 24, 0},
    { -672, 32, -8},
    { -648, 184, 0},
    { -792, 248, 32},
    { -824, 248, -56},
    { -680, 280, -136},
    // 31 seconds
    { -600, 320, -176},
    { -656, 304, -200},
    { -680, 384, -208},
    { -1072, 784, -568},
    { -920, 232, -320},
    { -1336, 128, -296},
    { -1584, 64, -248},
    { -1208, 352, -544},
    { -1232, 64, -288},
    { -1056, -224, -144},
    { -696, -64, -240},
    { -464, 120, -264},
    { -432, 200, -280},
    { -528, 240, -304},
    { -672, 280, -240},
    { -768, 192, -240},
    { -744, -8, -144},
    { -792, -40, -176},
    { -880, 96, -232},
    { -896, 72, -368},
    { -960, 280, -376},
    { -784, 520, -720},
    { -920, 656, -696},
    { -856, 376, -424},
    { -2288, 528, -448},
    // 32 seconds
    { -1456, -312, 16},
    { -1672, -56, -80},
    { -1248, -264, -72},
    { -688, -128, -64},
    { -552, -120, 64},
    { -504, -184, 80},
    { -664, 56, -8},
    { -840, 216, -80},
    { -856, 232, -24},
    { -816, 40, -384},
    { -1528, 200, -144},
    { -1312, 264, -352},
    { -1424, 72, -80},
    { -1048, 272, -128},
    { -1008, 192, -128},
    { -1080, 64, -144},
    { -848, -32, -152},
    { -504, 48, -208},
    { -352, 56, -216},
    { -376, 160, -264},
    { -520, 128, -240},
    { -816, 288, -328},
    { -1104, 384, -360},
    { -1072, 536, -336},
    { -1544, 848, -616},
    // 33 seconds
    { -1200, 384, -456},
    { -1336, 688, -624},
    { -1216, 8, -56},
    { -944, 296, -224},
    { -840, 240, -104},
    { -640, 112, 32},
    { -600, 232, 16},
    { -728, 352, 24},
    { -904, 344, 96},
    { -1096, 216, -88},
    { -992, -304, -72},
    { -1256, 168, -184},
    { -1120, -16, -48},
    { -1616, 48, -80},
    { -1064, -104, -96},
    { -872, 216, -264},
    { -920, -56, -136},
    { -744, -88, -120},
    { -560, 32, -192},
    { -488, 40, -168},
    { -584, 136, -200},
    { -688, 184, -216},
    { -896, 400, -296},
    { -744, 768, -624},
    { -1104, 304, -448},
    // 34 seconds
    { -1216, 272, -608},
    { -1120, 32, -384},
    { -1528, 352, -624},
    { -1576, 96, -184},
    { -1112, -8, -112},
    { -936, 192, -208},
    { -800, 136, -80},
    { -576, 160, -88},
    { -512, 160, -120},
    { -688, 96, -120},
    { -864, -16, -120},
    { -1064, -24, -264},
    { -1056, -48, -160},
    { -1408, 200, -176},
    { -1136, -48, 40},
    { -1728, 56, 128},
    { -1120, 0, -48},
    { -1000, 72, -88},
    { -944, 56, -144},
    { -696, 128, -200},
    { -416, 176, -216},
    { -400, 144, -192},
    { -560, 192, -184},
    { -880, 352, -320},
    { -1120, 272, -344},
    // 35 seconds
    { -1160, 216, -336},
    { -1032, 64, -376},
    { -912, 120, -440},
    { -1512, 528, -696},
    { -1360, -112, -136},
    { -1216, -16, -232},
    { -1216, 112, -144},
    { -760, -184, 24},
    { -568, 56, 8},
    { -672, -8, 144},
    { -784, 112, 112},
    { -888, 192, 184},
    { -960, 688, -232},
    { -1128, 112, 48},
    { -1248, 256, -96},
    { -1048, 24, -40},
    { -2040, 144, -16},
    { -864, 520, -320},
    { -920, 392, -472},
    { -1008, -144, -104},
    { -568, 184, -192},
    { -344, 144, -136},
    { -416, 168, -96},
    { -592, 272, -88},
    { -680, 360, -136},
    // 36 seconds
    { -416, 424, -552},
    { -904, 408, -256},
    { -1072, 120, -328},
    { -1024, 168, -360},
    { -1792, 1160, -1184},
    { -1992, -216, 136},
    { -1432, 112, -144},
    { -1040, -72, -80},
    { -712, -80, 48},
    { -464, 32, 72},
    { -496, 72, 0},
    { -568, -72, 64},
    { -992, 240, -168},
    { -824, -88, -72},
    { -1120, -32, -16},
    { -1264, 120, -136},
    { -1800, 440, -80},
    { -1240, 528, -384},
    { -792, 360, -384},
    { -992, 72, -216},
    { -768, -8, -176},
    { -464, 80, -208},
    { -400, 144, -224},
    { -512, 184, -232},
    { -680, 264, -112},
    // 37 seconds
    { -608, 736, -448},
    { -944, 168, -256},
    { -1000, 136, -432},
    { -992, -64, -160},
    { -1696, 584, -664},
    { -1616, 440, -200},
    { -1504, 80, -224},
    { -1248, 64, -144},
    { -704, -96, -56},
    { -384, 72, -112},
    { -576, 136, -104},
    { -816, 192, -104},
    { -960, 128, -264},
    { -784, 88, -184},
    { -920, 336, -240},
    { -1000, 112, -40},
    { -888, 280, -112},
    { -1488, 352, -128},
    { -952, 208, -216},
    { -1336, -160, -96},
    { -1168, 16, -192},
    { -736, 168, -208},
    { -424, 256, -232},
    { -344, 176, -184},
    { -488, 184, -200},
    // 38 seconds
    { -792, 160, -184},
    { -960, 96, -8},
    { -1304, 304, -496},
    { -1056, 384, -528},
    { -1336, 176, -320},
    { -2120, 424, -496},
    { -1408, -640, 400},
    { -1328, 280, -240},
    { -984, -48, -64},
    { -576, 8, 24},
    { -376, 184, -24},
    { -312, 280, -88},
    { -472, 288, -216},
    { -664, 720, -376},
    { -832, 1552, -720},
    { -1136, 792, -456},
    { -1784, 1080, -400},
    { -1608, 280, -24},
    { -1184, -208, 16},
    { -1040, -664, 312},
    { -1512, -344, 112},
    { -1488, -320, 104},
    { -1312, 96, -200},
    { -1016, 232, -232},
    { -736, 200, -200},
    // 39 seconds
    { -568, 184, -120},
    { -520, 304, -144},
    { -696, 464, -272},
    { -712, 704, -208},
    { -1392, 456, -528},
    { -736, 824, -704},
    { -720, 656, -648},
    { -712, 704, -624},
    { -1040, 792, -464},
    { -1672, 824, -696},
    { -1624, 280, -48},
    { -1184, 320, -24},
    { -824, 352, -88},
    { -680, 104, 112},
    { -984, 440, -208},
    { -920, -152, 8},
    { -936, 128, 128},
    { -1232, 320, -64},
    { -1208, -208, 24},
    { -1216, 272, -120},
    { -1120, 152, -280},
    { -1248, 232, -120},
    { -1120, 304, -192},
    { -824, 176, -168},
    { -536, 112, -120},
    // 40 seconds
    { -584, 248, -136},
    { -688, 472, -360},
    { -920, 416, -232},
    { -1312, -8, -528},
    { -1000, 416, -384},
    { -1072, 504, -560},
    { -984, 288, -360},
    { -1336, 456, -464},
    { -1368, 384, -416},
    { -1008, 32, -24},
    { -1024, 144, -88},
    { -944, 48, 16},
    { -648, 80, 0},
    { -688, 184, 16},
    { -728, 256, 8},
    { -1000, 144, 32},
    { -944, -184, -72},
    { -1224, 192, -176},
    { -1504, 200, -160},
    { -1344, -8, 40},
    { -1288, 40, 56},
    { -704, 344, -336},
    { -1000, 296, -184},
    { -1104, 184, -72},
    { -816, 80, -120},
    // 41 seconds
    { -480, 128, -120},
    { -400, 224, -184},
    { -536, 248, -176},
    { -744, 432, -432},
    { -920, -144, -256},
    { -888, 224, -360},
    { -1168, 408, -512},
    { -1168, 192, -112},
    { -1952, 544, -592},
    { -1224, 120, -112},
    { -1016, 184, -184},
    { -968, 256, -144},
    { -552, 64, -16},
    { -480, 72, 72},
    { -592, 104, -24},
    { -784, 488, 112},
    { -920, 496, -120},
    { -1128, 32, 120},
    { -1408, 16, 0},
    { -1096, -80, -32},
    { -1760, -8, 248},
    { -1360, 112, -64},
    { -592, 384, -432},
    { -952, 232, -264},
    { -616, -48, -80},
    // 42 seconds
    { -408, 120, -168},
    { -456, 104, -144},
    { -656, 152, -160},
    { -872, 280, -200},
    { -920, 368, -256},
    { -792, 64, -304},
    { -1112, 400, -312},
    { -1120, 24, -104},
    { -1960, 680, -688},
    { -1688, 112, -16},
    { -1208, -80, -112},
    { -912, -104, -72},
    { -544, -72, 0},
    { -408, 168, 48},
    { -600, 256, 88},
    { -680, 584, 0},
    { -1168, 568, -104},
    { -976, -240, 96},
    { -1384, -344, 200},
    { -1080, -168, 24},
    { -1736, -104, 32},
    { -848, 40, -288},
    { -1288, -432, 152},
    { -1008, -296, -24},
    { -472, -56, -144},
    // 43 seconds
    { -424, -56, -160},
    { -472, -8, -192},
    { -664, 136, -256},
    { -824, -16, -248},
    { -1152, 272, -256},
    { -1376, 16, -592},
    { -1160, -184, -264},
    { -1232, -416, -120},
    { -1592, -184, -424},
    { -1240, -216, -72},
    { -1288, 8, -368},
    { -1176, -80, -128},
    { -856, -40, -16},
    { -480, 32, -64},
    { -672, -328, 176},
    { -648, 64, 152},
    { -1296, 1016, -384},
    { -936, 88, -48},
    { -1120, 160, -176},
    { -1224, 72, -120},
    { -1632, 264, -168},
    { -992, 240, -320},
    { -816, 200, -280},
    { -1064, 48, -288},
    { -784, -8, -168},
    // 44 seconds
    { -432, 64, -224},
    { -456, 136, -256},
    { -568, 192, -272},
    { -720, 232, -96},
    { -504, -360, -688},
    { -704, -128, -296},
    { -1168, 488, -672},
    { -1040, -56, -136},
    { -1576, 408, -472},
    { -1384, 352, -256},
    { -1256, 152, -160},
    { -1136, 176, -104},
    { -728, 0, 24},
    { -480, 64, -56},
    { -576, 328, -104},
    { -784, -8, 72},
    { -1032, 384, -64},
    { -1056, 16, -16},
    { -1216, 136, -8},
    { -1320, 176, -56},
    { -1288, 40, -64},
    { -1360, 104, 24},
    { -704, 344, -336},
    { -968, 424, -360},
    { -888, 176, -200},
    // 45 seconds
    { -528, -56, -128},
    { -472, 64, -144},
    { -528, 144, -192},
    { -688, 256, -216},
    { -920, 384, -360},
    { -1016, 296, -400},
    { -1048, 304, -488},
    { -1088, 24, -216},
    { -1632, 88, -184},
    { -1488, 272, -200},
    { -1056, 208, -128},
    { -928, 368, -304},
    { -872, 32, 40},
    { -512, -56, 32},
    { -576, 128, -32},
    { -736, 80, 80},
    { -952, 208, 184},
    { -1080, 152, -40},
    { -1280, -40, -56},
    { -1368, 8, -24},
    { -1200, 248, -120},
    { -1528, -112, -88},
    { -784, 72, -216},
    { -928, 16, -280},
    { -784, -120, -120},
    // 46 seconds
    { -464, -24, -168},
    { -408, 96, -192},
    { -536, 216, -184},
    { -776, 264, -264},
    { -912, 232, -248},
    { -1032, 168, -216},
    { -1152, 248, -416},
    { -1248, 24, 24},
    { -1000, -56, -176},
    { -1600, 376, -504},
    { -1440, 48, 8},
    { -1176, 40, -88},
    { -968, 104, -16},
    { -520, 32, -48},
    { -472, 144, -80},
    { -656, 176, 56},
    { -760, 136, 16},
    { -832, 216, 24},
    { -1088, 248, -88},
    { -1272, -72, 16},
    { -1040, 16, -48},
    { -1456, 272, -128},
    { -1272, -112, -88},
    { -968, 176, -264},
    { -1104, 112, -264},
    // 47 seconds
    { -760, -56, -128},
    { -424, -8, -200},
    { -440, 128, -184},
    { -536, 184, -256},
    { -704, 264, -224},
    { -896, 256, -328},
    { -976, 184, -328},
    { -1128, 176, -456},
    { -1280, 120, -280},
    { -2184, 744, -744},
    { -1376, -288, 168},
    { -1144, 320, -320},
    { -768, 80, -136},
    { -336, -112, -32},
    { -296, 104, -56},
    { -512, 240, -32},
    { -944, 432, -56},
    { -1256, 344, 16},
    { -1248, 160, 232},
    { -1080, -24, 80},
    { -1048, -40, 80},
    { -1184, 264, -136},
    { -1192, 296, -400},
    { -848, 344, -384},
    { -1152, -144, -128},
    // 48 seconds
    { -1000, -176, -144},
    { -600, -112, -176},
    { -488, 24, -216},
    { -424, 104, -264},
    { -696, 152, -272},
    { -968, 184, -256},
    { -1072, 152, -464},
    { -1216, 304, -472},
    { -1088, 64, -200},
    { -1504, 344, -424},
    { -1400, 344, -352},
    { -1160, 264, -136},
    { -1160, 176, -160},
    { -824, 48, -32},
    { -496, 72, -72},
    { -568, 216, -96},
    { -720, 192, -16},
    { -968, 368, -8},
    { -1088, 32, 48},
    { -1024, 152, -136},
    { -1384, 248, -208},
    { -1064, -88, -72},
    { -1600, -64, 152},
    { -1128, -32, -72},
    { -688, 424, -368},
    // 49 seconds
    { -856, 216, -352},
    { -728, -136, -96},
    { -512, 56, -224},
    { -472, 56, -152},
    { -544, 96, -72},
    { -720, 32, -320},
    { -872, 232, -208},
    { -936, 432, -400},
    { -992, 296, -424},
    { -1112, 216, -312},
    { -1664, 648, -528},
    { -1224, 216, -248},
    { -1144, 304, -240},
    { -1128, 416, -272},
    { -928, 216, -80},
    { -744, 240, -96},
    { -640, 104, -96},
    { -664, 16, 8},
    { -896, 64, 64},
    { -928, 8, -8},
    { -1040, 24, -72},
    { -1192, -224, -40},
    { -992, -160, -248},
    { -1728, -176, 224},
    { -1272, 176, -144},
    // 50 seconds
    { -976, 272, -288},
    { -872, 144, -200},
    { -688, 64, -144},
    { -552, 136, -208},
    { -680, 232, -240},
    { -800, 136, -352},
    { -1112, 480, -320},
    { -792, 48, -488},
    { -928, 248, -528},
    { -1056, 304, -576},
    { -1216, 192, -352},
    { -1664, 584, -680},
    { -1216, 88, -208},
    { -1376, 192, -192},
    { -1248, 256, -96},
    { -864, 144, 104},
    { -744, 208, 64},
    { -744, 192, 72},
    { -752, 40, -56},
    { -824, -72, -112},
    { -1040, 24, 80},
    { -1272, 0, -56},
    { -1104, -88, -48},
    { -1632, -16, 24},
    { -1400, -48, -72},
    // 51 seconds
    { -976, 248, -208},
    { -1168, 240, -256},
    { -1008, 160, -152},
    { -760, 112, -216},
    { -720, 224, -336},
    { -768, 184, -288},
    { -880, 352, -424},
    { -984, 384, -216},
    { -904, 344, -568},
    { -888, 224, -576},
    { -968, 248, -536},
    { -1128, 232, -600},
    { -1400, 608, -736},
    { -1328, 128, -280},
    { -1408, 296, -288},
    { -1280, 216, -96},
    { -1016, 112, 32},
    { -1072, 216, 0},
    { -1064, 32, 40},
    { -856, -304, -96},
    { -792, -200, -16},
    { -1008, -128, -88},
    { -1096, -272, -120},
    { -1176, -88, -88},
    { -1552, -104, 0},
    // 52 seconds
    { -1112, 240, -176},
    { -1144, 304, -232},
    { -1104, 344, -256},
    { -904, 160, -168},
    { -840, 216, -312},
    { -864, 208, -304},
    { -936, 280, -448},
    { -952, 256, -536},
    { -936, 360, -664},
    { -1064, 680, -656},
    { -864, 400, -696},
    { -1120, 432, -672},
    { -1616, 408, -592},
    { -1440, -168, -160},
    { -1376, 216, -184},
    { -1320, 208, -40},
    { -1000, 216, 32},
    { -896, 272, 48},
    { -992, 288, 136},
    { -904, 72, 176},
    { -1016, -56, 168},
    { -904, -120, 104},
    { -1168, -240, -80},
    { -1336, -336, 32},
    { -1736, -544, 232},
    // 53 seconds
    { -1176, 184, -120},
    { -1024, 336, -296},
    { -1128, 280, -248},
    { -1032, 192, -160},
    { -856, 184, -224},
    { -744, 240, -312},
    { -696, 272, -352},
    { -800, 272, -456},
    { -928, 224, -488},
    { -848, 280, -672},
    { -952, 408, -656},
    { -1000, 232, -488},
    { -1464, 624, -880},
    { -1504, 104, -384},
    { -1440, -40, -232},
    { -1408, 256, -168},
    { -1144, 264, -64},
    { -952, 168, 0},
    { -888, 232, -64},
    { -1072, 240, -80},
    { -984, -136, -64},
    { -856, -96, 40},
    { -968, -16, -64},
    { -792, -184, -32},
    { -1376, -56, -8},
    // 54 seconds
    { -1224, -96, -112},
    { -1160, 312, -320},
    { -1288, 280, -240},
    { -1200, 280, -264},
    { -960, 216, -336},
    { -760, 280, -368},
    { -736, 240, -376},
    { -824, 168, -416},
    { -912, 240, -504},
    { -984, 160, -624},
    { -936, 176, -624},
    { -1024, 288, -648},
    { -1360, 352, -736},
    { -1488, 256, -520},
    { -1184, -248, -56},
    { -1064, 88, -168},
    { -976, 344, -216},
    { -960, 232, -40},
    { -736, 240, -24},
    { -824, 136, -56},
    { -856, 16, 56},
    { -912, 72, 32},
    { -952, -48, -192},
    { -1232, -336, 144},
    { -1128, -208, -64},
    // 55 seconds
    { -1824, -128, 72},
    { -1016, 176, -288},
    { -1232, 320, -224},
    { -1136, 336, -224},
    { -848, 248, -248},
    { -632, 176, -248},
    { -640, 280, -232},
    { -840, 224, -352},
    { -904, 344, -512},
    { -920, 416, -648},
    { -824, 384, -584},
    { -592, -64, -624},
    { -1064, 232, -408},
    { -1608, 560, -552},
    { -1432, 32, 56},
    { -1192, 200, -104},
    { -1312, 448, -64},
    { -1088, 144, 120},
    { -1016, 56, 216},
    { -904, 112, 272},
    { -888, 264, 264},
    { -1096, 64, 128},
    { -872, 488, 32},
    { -1104, 408, 152},
    { -944, 704, 96},
    // 56 seconds
    { -1288, 960, 128},
    { -600, 888, 232},
    { -504, 880, 16},
    { -384, 720, 40},
    { -240, 712, 0},
    { -64, 576, -32},
    { 16, 616, -24},
    { 40, 616, 56},
    { 16, 752, 80},
    { 8, 920, 136},
    { 0, 928, 216},
    { 8, 1112, 248},
    { -24, 1152, 408},
    { -248, 472, 120},
    { -232, 1616, 464},
    { -400, 1168, 512},
    { -344, 1176, 480},
    { -304, 912, 464},
    { -128, 712, 376},
    { 40, 552, 232},
    { 40, 584, 264},
    { 8, 656, 432},
    { -232, 680, 144},
    { -120, 944, 488},
    { -208, 1160, 352},
    // 57 seconds
    { -168, 1112, 360},
    { -464, 1240, 432},
    { -352, 1096, 296},
    { -328, 960, 176},
    { -360, 760, 200},
    { -240, 792, 72},
    { -96, 608, 104},
    { -8, 552, 80},
    { 8, 640, 88},
    { 0, 768, 128},
    { 8, 888, 144},
    { 48, 1000, 136},
    { 128, 1064, 208},
    { 144, 1136, 424},
    { -288, 1240, 640},
    { -648, 1600, 872},
    { -600, 1296, 432},
    { -424, 1040, 416},
    { -368, 888, 368},
    { -176, 744, 240},
    { 24, 520, 168},
    { 88, 568, 144},
    { 88, 672, 336},
    { 136, 1208, 8},
    { -168, 888, 200},
    // 58 seconds
    { -400, 1200, 256},
    { -624, 1248, 488},
    { -768, 1184, 424},
    { -408, 976, 296},
    { -416, 904, 152},
    { -416, 672, 216},
    { -336, 664, 48},
    { -232, 488, 0},
    { -168, 376, -152},
    { -216, 224, -40},
    { -480, -344, 264},
    { -568, 504, 8},
    { -768, 1200, -312},
    { -1216, 976, 128},
    { -1480, 1024, -392},
    { -1224, 288, -88},
    { -1608, 808, -416},
    { -1264, 568, -392},
    { -1328, 704, -304},
    { -888, 288, -144},
    { -472, 128, -120},
    { -416, 208, -80},
    { -528, 280, -16},
    { -744, 304, 48},
    { -920, 224, 40},
    // 59 seconds
    { -648, -152, -64},
    { -1160, 264, 16},
    { -1208, 328, -24},
    { -1040, 288, -248},
    { -1352, 272, -120},
    { -1216, 144, -160},
    { -784, 280, -280},
    { -904, 136, -256},
    { -656, 56, -144},
    { -440, 152, -184},
    { -456, 224, -184},
    { -632, 360, -240},
    { -760, 416, -256},
    { -856, 416, -304},
    { -864, 472, -328},
    { -984, 480, -424},
    { -1032, 912, -424},
    { -792, -56, -192},
    { -1400, 656, -472},
    { -1760, 48, -56},
    { -1576, 360, -104},
    { -1200, 224, 16},
    { -632, 112, -24},
    { -432, 208, 0},
    { -376, 160, 0},
    // 60 seconds
    // elapsed: 1 minutes
    { -456, 160, 40},
    { -896, 424, -120},
    { -1048, 368, 88},
    { -768, -232, -8},
    { -1144, 184, 16},
    { -1240, 136, -64},
    { -1392, 216, -176},
    { -784, 208, -184},
    { -896, 312, -384},
    { -928, 312, -280},
    { -640, 200, -184},
    { -480, 184, -152},
    { -520, 232, -200},
    { -584, 184, -216},
    { -760, 344, -240},
    { -976, 432, -408},
    { -1096, 400, -512},
    { -1272, 712, -560},
    { -760, -24, -72},
    { -1576, 488, -776},
    { -1592, -264, 144},
    { -1496, 160, 40},
    { -1104, 224, -112},
    { -560, 72, -32},
    { -424, 64, -8},
    // 61 seconds
    { -480, 96, 56},
    { -672, 232, -40},
    { -872, 160, 112},
    { -1024, 488, -288},
    { -1360, -264, 208},
    { -976, 120, -64},
    { -1688, -32, -96},
    { -1112, 144, -304},
    { -1080, 72, -432},
    { -1096, 48, -288},
    { -584, -176, -168},
    { -392, 16, -240},
    { -456, 168, -296},
    { -592, 168, -312},
    { -808, 200, -264},
    { -896, 240, -312},
    { -896, 288, -320},
    { -960, 280, -368},
    { -1384, 536, -472},
    { -808, -344, -360},
    { -1448, 808, -792},
    { -1672, 120, -168},
    { -1360, 56, 16},
    { -1168, 248, -80},
    { -736, 184, -120},
    // 62 seconds
    { -544, 152, -32},
    { -528, 200, 8},
    { -592, 216, 56},
    { -704, 256, 24},
    { -784, 288, -64},
    { -888, 600, -64},
    { -1312, 672, -176},
    { -1200, 296, -184},
    { -1384, 304, -176},
    { -1216, 168, -216},
    { -944, 368, -360},
    { -1264, 112, -144},
    { -1112, 96, -152},
    { -688, 256, -224},
    { -440, 248, -224},
    { -352, 232, -248},
    { -416, 264, -224},
    { -656, 240, -224},
    { -904, 632, -640},
    { -1184, 264, -344},
    { -1104, 336, -512},
    { -944, 264, -392},
    { -1648, 760, -912},
    { -1392, -8, 40},
    { -1336, 160, -168},
    // 63 seconds
    { -1056, 368, -192},
    { -760, 152, 48},
    { -608, 184, 88},
    { -600, 184, 120},
    { -712, 152, 144},
    { -864, 488, 88},
    { -1208, -304, 16},
    { -1136, 368, -80},
    { -1064, 344, -248},
    { -1104, 184, -144},
    { -1456, 192, -232},
    { -984, 296, -320},
    { -1064, 128, -256},
    { -824, -16, -120},
    { -528, 120, -168},
    { -464, 184, -176},
    { -480, 240, -264},
    { -616, 384, -320},
    { -880, 240, -256},
    { -880, 160, -296},
    { -1032, 624, -856},
    { -880, -144, -304},
    { -1408, 776, -768},
    { -1424, 656, -520},
    { -1456, 72, -192},
    // 64 seconds
    { -1224, 264, -288},
    { -664, 240, -152},
    { -472, 200, -120},
    { -520, 232, -72},
    { -648, 240, -40},
    { -776, 232, -64},
    { -808, 184, -8},
    { -1128, 576, -208},
    { -1176, -8, -40},
    { -1008, 104, -112},
    { -1920, 136, -80},
    { -1112, 144, 24},
    { -1080, 344, -304},
    { -1008, 192, -224},
    { -768, 56, -112},
    { -512, 216, -232},
    { -456, 304, -248},
    { -616, 408, -336},
    { -792, 416, -360},
    { -944, 264, -368},
    { -464, -176, -688},
    { -1112, 592, -760},
    { -1088, 0, -416},
    { -1848, 464, -592},
    { -1320, -128, 0},
    // 65 seconds
    { -1120, 208, -224},
    { -1096, 288, -64},
    { -840, -32, 208},
    { -624, 112, 96},
    { -632, 256, 96},
    { -768, 424, 88},
    { -1200, 680, -48},
    { -960, 224, -48},
    { -1024, 72, -64},
    { -1224, 104, -216},
    { -1048, 112, -248},
    { -1640, 48, -120},
    { -896, 192, -224},
    { -1040, 312, -344},
    { -912, 24, -184},
    { -512, -128, -200},
    { -424, -416, 104},
    { -472, 368, -200},
    { -648, 552, -328},
    { -848, 560, -392},
    { -1008, -96, -56},
    { -904, 536, -232},
    { -1088, 504, -344},
    { -1720, 616, -560},
    { -1568, 320, -216},
    // 66 seconds
    { -1120, 56, -128},
    { -1040, 224, -256},
    { -832, -48, -24},
    { -576, 128, -48},
    { -496, 192, 0},
    { -624, 152, 96},
    { -1160, 96, 40},
    { -1008, 264, 208},
    { -928, 456, -40},
    { -1104, 400, -152},
    { -984, 464, -208},
    { -1216, 552, -176},
    { -936, 424, -112},
    { -704, 624, -224},
    { -936, 560, -280},
    { -624, 480, -192},
    { -328, 600, -288},
    { -304, 680, -192},
    { -296, 560, -64},
    { -352, 608, -80},
    { -336, 792, -176},
    { -296, 608, -40},
    { -392, 488, -464},
    { -344, 960, 112},
    { -312, 1048, -64},
    // 67 seconds
    { -648, 1304, 128},
    { -640, 1168, 120},
    { -480, 1240, 216},
    { -472, 920, 200},
    { -312, 752, 152},
    { -168, 592, 128},
    { -24, 520, 104},
    { 80, 456, 144},
    { -176, 1024, -96},
    { -296, 360, 184},
    { -568, 1136, -32},
    { -792, 1136, 96},
    { -1344, 1248, 136},
    { -520, 1032, -312},
    { -760, 800, -200},
    { -600, 832, -200},
    { -368, 576, -136},
    { -136, 440, -136},
    { -112, 416, -104},
    { -160, 400, -8},
    { -248, 688, -80},
    { -304, 872, -72},
    { -416, 976, -40},
    { -632, 936, 16},
    { -1280, 1472, -80},
    // 68 seconds
    { -1456, 624, -200},
    { -1400, 1000, -248},
    { -960, 480, -104},
    { -672, 408, -48},
    { -416, 360, -200},
    { -400, 216, -96},
    { -520, 336, -80},
    { -792, 344, -168},
    { -904, 336, -8},
    { -1024, 544, -40},
    { -1368, 224, -8},
    { -960, 240, -72},
    { -1552, 432, -32},
    { -776, 536, -216},
    { -1016, 600, -304},
    { -1056, 512, -368},
    { -456, 352, -184},
    { -336, 376, -192},
    { -368, 376, -136},
    { -440, 408, -112},
    { -488, 432, -192},
    { -568, 440, -120},
    { -728, 584, -192},
    { -1040, 640, -184},
    { -1144, 488, -56},
    // 69 seconds
    { -1400, 672, -208},
    { -1336, 616, -168},
    { -1208, 816, -128},
    { -1240, 976, -104},
    { -808, 496, -152},
    { -424, 384, -16},
    { -232, 344, -80},
    { -448, 416, 56},
    { -632, 480, 104},
    { -784, 512, 104},
    { -800, 560, 144},
    { -760, -16, -136},
    { -992, 536, -176},
    { -1488, 560, -88},
    { -1168, 792, -176},
    { -896, 616, -376},
    { -824, 312, -240},
    { -440, 152, -136},
    { -328, 224, -144},
    { -392, 208, 16},
    { -440, 560, -64},
    { -576, 688, -8},
    { -568, 896, -72},
    { -464, 992, -48},
    { -472, 1016, -56},
    // 70 seconds
    { -600, 928, 0},
    { -736, 904, 8},
    { -1264, 1088, 104},
    { -1232, 784, 360},
    { -1312, 1200, -240},
    { -1104, 480, 256},
    { -848, 632, 88},
    { -504, 640, 208},
    { -344, 488, 128},
    { -232, 488, 56},
    { -232, 520, 96},
    { -208, 640, 144},
    { -312, 984, -88},
    { -200, 464, 176},
    { -328, 1032, 80},
    { -448, 1080, 176},
    { -496, 1288, 200},
    { -584, 1112, 176},
    { -560, 968, 152},
    { -576, 1008, 64},
    { -536, 816, 104},
    { -312, 776, -8},
    { -136, 536, 24},
    { -24, 480, -24},
    { -32, 552, 16},
    // 71 seconds
    { -112, 768, 112},
    { -144, 1000, 96},
    { -352, 1488, 152},
    { -216, 880, 208},
    { -216, 880, 328},
    { -552, 1776, 112},
    { -920, 1336, 616},
    { -728, 1288, 264},
    { -384, 712, 208},
    { -128, 456, 128},
    { -24, 512, 96},
    { -48, 520, 216},
    { -96, 752, 192},
    { -144, 952, 368},
    { -200, 1656, -152},
    { -608, 1032, 152},
    { -376, 1008, 88},
    { -648, 912, 216},
    { -568, 1128, 264},
    { -544, 1264, 32},
    { -448, 896, 112},
    { -208, 680, -16},
    { -8, 496, 24},
    { 56, 536, 32},
    { 16, 696, 200},
    // 72 seconds
    { 8, 840, 40},
    { -136, 1024, 176},
    { -88, 1152, 176},
    { -224, 1208, 280},
    { -216, 1072, 232},
    { -352, 1568, 112},
    { -776, 1520, 328},
    { -592, 1088, 360},
    { -488, 1000, 400},
    { -152, 608, 112},
    { -8, 536, 48},
    { -16, 448, 96},
    { -48, 672, 24},
    { -144, 896, 120},
    { -232, 1048, 40},
    { -464, 1056, 120},
    { -576, 992, -192},
    { -328, 1056, -240},
    { -504, 960, -8},
    { -456, 1208, 16},
    { -448, 1120, 32},
    { -384, 1040, 48},
    { -88, 688, -128},
    { 96, 496, -64},
    { 120, 496, 32},
    // 73 seconds
    { 88, 712, 40},
    { 40, 832, 144},
    { -8, 1080, 160},
    { 8, 1176, 224},
    { -56, 1416, 264},
    { -104, 1464, -24},
    { -248, 1280, 168},
    { -552, 1432, 352},
    { -456, 1232, 496},
    { -472, 1040, 400},
    { -296, 800, 320},
    { -48, 576, 216},
    { 48, 600, 160},
    { 16, 512, 256},
    { 0, 632, 272},
    { -88, 816, 264},
    { -496, 680, 568},
    { -520, 968, 128},
    { -536, 1176, 32},
    { -768, 1112, 624},
    { -600, 1312, 184},
    { -448, 1168, 64},
    { -416, 584, 312},
    { -184, 712, 64},
    { -136, 624, 24},
    // 74 seconds
    { -136, 568, 80},
    { -136, 752, 56},
    { -168, 848, 128},
    { -88, 1072, 64},
    { -40, 1136, 264},
    { -136, 1208, 168},
    { -40, 1040, 272},
    { -272, 1360, 8},
    { -600, 1216, 376},
    { -616, 1360, 392},
    { -472, 1016, 336},
    { -184, 696, 216},
    { 24, 600, 88},
    { 88, 512, 104},
    { 64, 584, 192},
    { 112, 720, 112},
    { -48, 816, 8},
    { -136, 976, 64},
    { -288, 1184, 224},
    { -176, 1176, 184},
    { -360, 1184, 272},
    { -368, 1360, 40},
    { -352, 1040, 112},
    { -296, 960, 24},
    { -96, 672, 16},
    // 75 seconds
    { 16, 560, -32},
    { 48, 560, -48},
    { 32, 624, -8},
    { 64, 768, -32},
    { 56, 872, 48},
    { 88, 992, 96},
    { 64, 1176, 80},
    { -32, 1112, 176},
    { -280, 1120, 104},
    { -424, 1688, 256},
    { -432, 1272, 496},
    { -312, 1160, 320},
    { -184, 920, 248},
    { -8, 672, 120},
    { 104, 576, 88},
    { 112, 608, 168},
    { 104, 664, 336},
    { 224, 1192, -72},
    { 16, 1040, 64},
    { -48, 1032, 280},
    { -136, 1120, 328},
    { -448, 1216, 400},
    { -496, 1304, 272},
    { -552, 1120, 216},
    { -552, 896, 200},
    // 76 seconds
    { -368, 872, 112},
    { -208, 760, 96},
    { -56, 592, 48},
    { 32, 552, 40},
    { 16, 648, 56},
    { 40, 744, 104},
    { 24, 872, 136},
    { 32, 1040, 200},
    { 120, 1128, 304},
    { -120, 1312, -72},
    { -80, 1432, 112},
    { -280, 1224, 304},
    { -368, 1088, 384},
    { -304, 1312, 200},
    { -200, 968, 192},
    { -80, 704, 184},
    { 24, 616, 136},
    { 40, 632, 168},
    { 24, 744, 368},
    { 96, 1312, -144},
    { -136, 784, 72},
    { -224, 1208, 144},
    { -320, 1272, 48},
    { -392, 1448, -24},
    { -360, 1184, 72},
    // 77 seconds
    { -384, 1080, -136},
    { -288, 816, -112},
    { -144, 696, -120},
    { 0, 600, -128},
    { 64, 544, -88},
    { 112, 568, -56},
    { 136, 736, -56},
    { 112, 1064, -152},
    { 80, 976, -16},
    { 64, 1208, -296},
    { 0, 1136, -232},
    { -336, 1368, -536},
    { -312, 1680, -376},
    { -512, 1416, -64},
    { -568, 1344, -128},
    { -312, 864, 96},
    { -248, 560, 112},
    { 72, 784, -288},
    { 32, 464, -8},
    { -32, 592, -16},
    { -104, 840, -16},
    { -248, 520, -192},
    { -112, 808, -176},
    { -288, 1120, -232},
    { -288, 1264, -280},
    // 78 seconds
    { -424, 1360, -56},
    { -320, 1096, -88},
    { -432, 920, -88},
    { -352, 848, -192},
    { -240, 816, -208},
    { -56, 624, -192},
    { 32, 576, -216},
    { 128, 608, -216},
    { 144, 744, -192},
    { 128, 864, -144},
    { 120, 1024, -128},
    { 160, 1160, -112},
    { 72, 1216, -8},
    { -208, 1304, -104},
    { -136, 1576, -96},
    { -424, 1480, 176},
    { -368, 1376, -40},
    { -320, 856, 120},
    { -88, 568, 120},
    { 120, 536, 40},
    { 144, 712, 0},
    { 120, 728, 96},
    { 152, 1064, 88},
    { -32, 1008, 48},
    { -88, 976, 8},
    // 79 seconds
    { -248, 1136, -32},
    { -192, 1216, -200},
    { -320, 1136, -40},
    { -208, 1232, -208},
    { -224, 1032, -128},
    { -240, 1232, -312},
    { -80, 880, -288},
    { 32, 240, -56},
    { 112, 328, -280},
    { 160, 432, -224},
    { 208, 552, -440},
    { 336, 672, -576},
    { 264, 712, -752},
    { 272, 1344, -584},
    { 64, 1296, -80},
    { -184, 1856, 64},
    { -240, 1304, -64},
    { 8, 1256, -32},
    { -32, 688, -32},
    { -48, 456, -64},
    { 24, 608, -200},
    { 88, 424, -160},
    { -56, 360, 88},
    { 80, 816, -640},
    { 96, 1312, -776},
    // 80 seconds
    { 48, 936, -152},
    { -24, 1040, -416},
    { -16, 1112, -216},
    { -120, 936, 40},
    { -64, 1168, -200},
    { -112, 936, -16},
    { -88, 880, -56},
    { 56, 792, -216},
    { 144, 600, -160},
    { 192, 648, -200},
    { 184, 816, -224},
    { 224, 792, -200},
    { 208, 880, -120},
    { 168, 1040, -152},
    { 64, 1024, 72},
    { 136, 1312, -312},
    { -144, 1328, -16},
    { -184, 1144, 392},
    { -152, 1184, 160},
    { -56, 1112, 144},
    { 48, 760, 64},
    { 104, 632, -16},
    { 136, 584, 64},
    { 176, 864, 72},
    { 72, 936, 16},
    // 81 seconds
    { 40, 1032, 0},
    { -96, 1280, 40},
    { -168, 1192, 8},
    { -336, 1384, 56},
    { -312, 1152, 8},
    { -264, 1104, -104},
    { -256, 928, -128},
    { -184, 824, -112},
    { -40, 624, -136},
    { 40, 504, -176},
    { 80, 632, -160},
    { 48, 744, -120},
    { 48, 864, -128},
    { 88, 912, -144},
    { 136, 968, -88},
    { 80, 1120, -16},
    { -56, 688, 64},
    { 48, 1624, 24},
    { -240, 1360, 296},
    { -168, 1256, 264},
    { -224, 1080, 384},
    { -216, 872, 320},
    { 0, 776, 152},
    { 104, 608, 136},
    { 104, 512, 208},
    // 82 seconds
    { 152, 824, 352},
    { 112, 952, 296},
    { 128, 1056, 208},
    { -104, 976, 640},
    { -40, 1168, 392},
    { -312, 1016, 696},
    { -256, 1056, 624},
    { -328, 1112, 600},
    { -344, 1008, 496},
    { -232, 848, 296},
    { -48, 688, 216},
    { 72, 640, 80},
    { 96, 544, 160},
    { 152, 704, 160},
    { 144, 824, 208},
    { 128, 984, 368},
    { 152, 1088, 264},
    { -16, 1232, 392},
    { -240, 1184, 576},
    { -248, 1392, 792},
    { -464, 1360, 576},
    { -144, 880, 504},
    { -160, 904, 440},
    { -96, 752, 344},
    { 24, 704, 200},
    // 83 seconds
    { 128, 552, 240},
    { 168, 712, 432},
    { 136, 1200, 232},
    { -8, 976, 368},
    { -56, 992, 440},
    { -152, 1048, 448},
    { -72, 1096, 560},
    { -280, 1216, 336},
    { -272, 1216, 376},
    { -408, 1056, 440},
    { -424, 992, 384},
    { -208, 688, 256},
    { -64, 688, 160},
    { 8, 576, 168},
    { 48, 608, 176},
    { 48, 728, 248},
    { -32, 856, 328},
    { -8, 1008, 392},
    { -8, 1096, 488},
    { -152, 968, 656},
    { -256, 1416, 696},
    { -408, 1616, 576},
    { -144, 776, 648},
    { -104, 1000, 264},
    { -64, 664, 336},
    // 84 seconds
    { -32, 576, 272},
    { 24, 584, 288},
    { 24, 616, 440},
    { 48, 648, 528},
    { -160, 872, 304},
    { -112, 1144, 568},
    { -256, 1224, 568},
    { -224, 1376, 192},
    { -344, 1184, 472},
    { -368, 1128, 264},
    { -296, 992, 104},
    { -96, 784, 200},
    { 96, 624, 176},
    { 136, 576, 128},
    { 96, 584, 200},
    { -8, 768, 152},
    { -56, 992, 104},
    { -104, 1032, 0},
    { 40, 984, -8},
    { 56, 1056, 264},
    { -104, 744, 72},
    { 104, 1160, 536},
    { -184, 1528, 496},
    { -64, 1248, 664},
    { 0, 1056, 752},
    // 85 seconds
    { 0, 856, 376},
    { 112, 600, 216},
    { 160, 536, 176},
    { 104, 480, 336},
    { 16, 688, 360},
    { -72, 864, 344},
    { -24, 1176, 320},
    { -216, 1240, 488},
    { -208, 1192, 272},
    { -336, 1184, 536},
    { -152, 1104, 280},
    { -160, 920, 208},
    { -96, 720, 224},
    { 48, 704, 112},
    { 168, 624, 96},
    { 184, 632, 168},
    { 184, 728, 152},
    { 160, 856, 168},
    { 184, 920, 208},
    { 176, 1096, 264},
    { 120, 1096, 384},
    { 32, 1184, 288},
    { -112, 2144, 896},
    { -344, 1320, 640},
    { -112, 1192, 208},
    // 86 seconds
    { -40, 800, 248},
    { 0, 560, 216},
    { 104, 536, 104},
    { 152, 512, 176},
    { 128, 632, 216},
    { 120, 904, 464},
    { 48, 1096, -136},
    { 56, 1104, 40},
    { -72, 1160, 136},
    { 56, 1392, 488},
    { -296, 792, 440},
    { -80, 1184, 136},
    { -40, 1128, 48},
    { -64, 1112, 0},
    { 56, 840, -24},
    { 152, 568, -24},
    { 208, 672, -32},
    { 200, 728, 24},
    { 192, 880, 56},
    { 136, 968, 184},
    { 232, 1120, 96},
    { 208, 1152, 224},
    { 232, 1048, 112},
    { 112, 992, 88},
    { -24, 1144, 56},
    // 87 seconds
    { -264, 1200, 488},
    { -48, 1336, 352},
    { -96, 1096, 400},
    { 8, 808, 328},
    { 136, 728, 136},
    { 144, 600, 224},
    { 120, 688, 224},
    { 120, 824, 304},
    { 160, 960, 336},
    { 88, 1480, 96},
    { -136, 1032, 248},
    { -136, 1328, 216},
    { -120, 1200, 344},
    { -152, 1248, 32},
    { -144, 1000, 72},
    { -136, 864, 16},
    { 24, 656, -56},
    { 56, 544, -96},
    { 56, 720, -80},
    { 0, 848, -56},
    { 8, 896, 16},
    { 96, 1048, -80},
    { 144, 968, 48},
    { 152, 888, 160},
    { 152, 968, 88},
    // 88 seconds
    { 144, 920, 176},
    { 232, 1368, 280},
    { -120, 1840, 336},
    { -200, 1160, 504},
    { -120, 1152, 352},
    { -104, 976, 352},
    { 40, 784, 272},
    { 120, 648, 128},
    { 120, 520, 224},
    { 136, 704, 128},
    { 136, 800, 240},
    { -96, 656, 208},
    { -88, 1400, 224},
    { -232, 1320, 24},
    { -352, 1352, 256},
    { -408, 1392, 72},
    { -360, 1184, -160},
    { -104, 904, -264},
    { 8, 464, -192},
    { 88, 368, -144},
    { 264, 448, -128},
    { 280, 704, -8},
    { 160, 1008, -24},
    { 224, 952, -56},
    { 232, 872, 24},
    // 89 seconds
    { 136, 1024, 48},
    { -32, 976, 336},
    { 96, 1720, 176},
    { -328, 1392, 472},
    { -160, 1328, 216},
    { -176, 1080, 464},
    { -136, 1072, 96},
    { 24, 808, 168},
    { 184, 584, 96},
    { 160, 528, 168},
    { 136, 632, 376},
    { 216, 1528, -16},
    { -152, 1016, 136},
    { -296, 1296, 120},
    { -352, 1408, 392},
    { -496, 1312, 400},
    { -248, 992, 48},
    { -224, 816, -88},
    { -224, 656, 128},
    { -136, 736, 40},
    { -24, 704, -40},
    { -16, 656, 40},
    { 48, 784, -32},
    { 72, 896, 24},
    { 168, 1008, 72},
    // 90 seconds
    { 160, 1144, 96},
    { 88, 1080, 192},
    { 88, 1040, 128},
    { 136, 840, 344},
    { -360, 1592, 608},
    { -560, 1496, 600},
    { -384, 1368, 432},
    { -168, 896, 304},
    { 168, 656, 216},
    { 80, 384, 144},
    { 72, 536, 224},
    { 96, 648, 320},
    { 32, 800, 112},
    { -88, 1216, 384},
    { -304, 1168, 272},
    { -248, 1168, 232},
    { -456, 1200, 352},
    { -328, 1344, 152},
    { -240, 1032, -40},
    { -160, 800, 96},
    { -56, 704, 24},
    { 40, 592, -16},
    { 64, 624, 88},
    { 88, 744, 72},
    { 56, 920, 80},
    // 91 seconds
    { 88, 960, 128},
    { 96, 1032, 96},
    { 104, 1096, 168},
    { -16, 1112, 184},
    { -16, 1200, 368},
    { -168, 1456, 392},
    { -392, 1040, 616},
    { -240, 1368, 440},
    { -192, 792, 368},
    { -24, 704, 128},
    { 160, 432, 176},
    { 136, 560, 160},
    { 160, 784, 168},
    { 184, 920, 360},
    { 184, 1272, 240},
    { 80, 1128, 456},
    { -104, 1200, 152},
    { -120, 1200, 144},
    { -168, 960, 8},
    { -360, 1024, 312},
    { -504, 1312, 232},
    { -296, 1200, 112},
    { -136, 928, 32},
    { 8, 608, 72},
    { 120, 528, 24},
    // 92 seconds
    { 176, 512, 144},
    { 184, 680, 152},
    { 176, 856, 136},
    { 120, 1104, 144},
    { 128, 1056, 200},
    { 40, 1392, -88},
    { -24, 1112, 16},
    { -24, 1040, 136},
    { -304, 1712, 248},
    { -368, 1248, 496},
    { -248, 1192, 192},
    { -184, 728, 248},
    { -32, 512, 216},
    { 136, 616, 192},
    { 104, 976, 104},
    { 24, 1048, 80},
    { -24, 816, 296},
    { -48, 1096, 296},
    { -200, 1176, 232},
    { -272, 1200, 184},
    { -464, 1232, 304},
    { -424, 1344, 72},
    { -352, 1040, 24},
    { -280, 760, 0},
    { -80, 584, -56},
    // 93 seconds
    { 80, 496, -64},
    { 120, 560, -48},
    { 168, 792, -72},
    { 152, 912, 64},
    { 128, 1120, 72},
    { 152, 1040, 152},
    { -32, 1208, 200},
    { -48, 1384, 192},
    { -352, 1496, 296},
    { -216, 1288, 416},
    { -216, 1016, 456},
    { -136, 784, 288},
    { 104, 608, 168},
    { 176, 600, 168},
    { 184, 600, 376},
    { 216, 872, 160},
    { 88, 1008, 336},
    { -40, 1096, 304},
    { -144, 1376, 344},
    { -160, 1216, 272},
    { -312, 1304, 232},
    { -248, 1120, 48},
    { -232, 960, 32},
    { -192, 880, 0},
    { 0, 616, -72},
    // 94 seconds
    { 96, 480, -64},
    { 120, 504, 0},
    { 64, 736, 32},
    { -24, 952, 48},
    { 0, 912, 16},
    { -80, 864, 16},
    { -256, 736, -328},
    { -240, 688, -160},
    { -488, 640, 88},
    { -1128, 752, 16},
    { -1512, 1032, -72},
    { -1432, 600, 56},
    { -1336, 792, -360},
    { -680, 584, -136},
    { -520, 280, -48},
    { -696, 256, -88},
    { -920, 376, -192},
    { -1080, 232, -136},
    { -1056, 392, -176},
    { -1272, 296, -184},
    { -1152, 184, -48},
    { -1440, 136, -160},
    { -624, 328, -336},
    { -896, 408, -464},
    { -792, -16, -128},
    // 95 seconds
    { -440, 56, -168},
    { -376, 0, -96},
    { -456, 64, -88},
    { -728, 136, -128},
    { -960, 264, -168},
    { -960, 248, -240},
    { -1144, 280, -392},
    { -976, 312, -272},
    { -1480, 392, -288},
    { -2016, 600, -336},
    { -1152, -32, 72},
    { -1104, 232, -160},
    { -752, 176, -88},
    { -448, 88, -16},
    { -504, 176, -48},
    { -576, 144, 56},
    { -728, -32, 104},
    { -904, 240, -16},
    { -1120, 176, -40},
    { -1232, 256, -168},
    { -984, 256, -144},
    { -1608, 184, -136},
    { -728, 256, -248},
    { -1072, 24, -160},
    { -896, -88, -64},
    // 96 seconds
    { -464, -16, -136},
    { -368, 8, -128},
    { -448, 32, -176},
    { -688, 136, -224},
    { -784, 88, -248},
    { -896, -8, -448},
    { -1056, 304, -224},
    { -984, 304, -448},
    { -1264, 152, -264},
    { -1984, 616, -552},
    { -1256, -168, 192},
    { -1072, 264, -176},
    { -880, 192, -160},
    { -512, 40, -80},
    { -528, 128, -32},
    { -600, 48, 56},
    { -672, -184, 112},
    { -1120, 152, 144},
    { -1080, 264, -96},
    { -1176, 200, -72},
    { -1088, 216, -120},
    { -1520, 120, -56},
    { -1032, 520, -440},
    { -984, 600, -376},
    { -728, 528, -152},
    // 97 seconds
    { -448, 728, -184},
    { -416, 648, -160},
    { -448, 616, -120},
    { -416, 456, -40},
    { -336, 848, -192},
    { -224, 688, -112},
    { -96, 944, -104},
    { -176, 960, 96},
    { -200, 888, 112},
    { -528, 1568, 184},
    { -696, 1240, 328},
    { -432, 1176, 216},
    { -304, 952, 200},
    { -184, 720, 120},
    { -32, 624, 112},
    { -16, 576, 120},
    { 24, 600, 144},
    { 80, 824, 144},
    { -96, 1000, 160},
    { -64, 1040, 152},
    { -256, 1096, 272},
    { -360, 1688, 240},
    { -368, 1208, 208},
    { -288, 1152, -56},
    { -312, 784, 32},
    // 98 seconds
    { -136, 648, -144},
    { 0, 496, -64},
    { 32, 480, -32},
    { 56, 672, -24},
    { -16, 872, 72},
    { -40, 1072, 8},
    { 64, 976, 56},
    { 104, 1176, 144},
    { -48, 1072, 392},
    { -88, 1792, 384},
    { -528, 1488, 456},
    { -208, 1192, 328},
    { -144, 992, 304},
    { -64, 728, 368},
    { 56, 640, 224},
    { 128, 592, 184},
    { 120, 624, 304},
    { 56, 928, 296},
    { 40, 1072, 472},
    { -184, 1208, 360},
    { -264, 1160, 224},
    { -200, 1080, 200},
    { -368, 1200, 328},
    { -336, 1176, 232},
    { -200, 1064, -8},
    // 99 seconds
    { -128, 784, -8},
    { -72, 656, 56},
    { 88, 608, -32},
    { 96, 568, 40},
    { 120, 720, 40},
    { 104, 848, 88},
    { 120, 976, 248},
    { 208, 1048, 296},
    { -72, 1376, 320},
    { -96, 1016, 408},
    { -216, 1680, 408},
    { -360, 1296, 552},
    { -224, 1184, 368},
    { -176, 936, 408},
    { -32, 632, 288},
    { 72, 552, 224},
    { 72, 576, 280},
    { 48, 672, 328},
    { 8, 1184, 280},
    { -32, 1376, 184},
    { -184, 1336, 168},
    { -232, 1024, 144},
    { -360, 1440, 240},
    { -360, 1224, 112},
    { -344, 1072, -56},
    // 100 seconds
    { -312, 808, 8},
    { -128, 712, -32},
    { 16, 616, -48},
    { 48, 560, -40},
    { 80, 592, -8},
    { 64, 808, -80},
    { 32, 848, 72},
    { 104, 944, 48},
    { 136, 1360, 184},
    { -40, 1184, 96},
    { 8, 1496, 120},
    { -248, 1536, 8},
    { -120, 1096, 408},
    { -24, 1176, 208},
    { 0, 920, 272},
    { -40, 672, 256},
    { 40, 792, 360},
    { 80, 816, 296},
    { 16, 808, 272},
    { -16, 976, 168},
    { -96, 944, 160},
    { -168, 1192, 88},
    { -216, 1248, -16},
    { -408, 1328, 224},
    { -152, 1088, -136},
    // 101 seconds
    { -72, 872, -120},
    { -64, 792, 0},
    { 40, 760, -72},
    { 168, 624, -48},
    { 168, 640, 24},
    { 200, 752, 0},
    { 152, 816, 24},
    { 232, 912, -40},
    { 256, 1072, 80},
    { 56, 1336, -64},
    { 24, 1344, 328},
    { -248, 1824, 208},
    { -112, 1200, 376},
    { 48, 1296, 240},
    { -8, 984, 240},
    { 64, 656, 200},
    { 176, 600, 112},
    { 184, 640, 136},
    { 160, 648, 184},
    { 56, 888, -128},
    { 128, 824, 144},
    { 120, 968, 232},
    { 16, 1144, 56},
    { -160, 1200, 152},
    { -240, 1384, 160},
    // 102 seconds
    { -336, 1360, 32},
    { -344, 1000, 8},
    { -240, 856, -80},
    { -200, 680, -104},
    { -136, 456, 24},
    { 32, 472, -128},
    { 144, 520, 32},
    { 152, 808, 24},
    { 144, 1048, 232},
    { 120, 1200, 208},
    { -136, 1376, 272},
    { -40, 1320, 408},
    { -344, 1632, 392},
    { -184, 1144, 464},
    { -144, 1160, 336},
    { -136, 840, 360},
    { -32, 592, 192},
    { 48, 592, 192},
    { 88, 576, 312},
    { -8, 536, 296},
    { -80, 1200, 336},
    { -200, 1136, 320},
    { -304, 1176, 144},
    { -280, 1112, 288},
    { -384, 1216, 112},
    // 103 seconds
    { -144, 984, -32},
    { -136, 976, -112},
    { -200, 880, -40},
    { -16, 672, -120},
    { 112, 624, -136},
    { 120, 584, -48},
    { 152, 720, -32},
    { 112, 856, 8},
    { 112, 1000, 64},
    { 120, 1048, 168},
    { -48, 1488, -280},
    { -88, 1664, 136},
    { -416, 1272, 280},
    { -168, 1240, 248},
    { -168, 1048, 320},
    { -112, 784, 328},
    { -8, 680, 144},
    { 48, 648, 200},
    { 40, 688, 264},
    { 40, 1192, 240},
    { -128, 736, 24},
    { -16, 1008, 328},
    { -128, 1144, 232},
    { -80, 1112, 224},
    { -232, 1032, 208},
    // 104 seconds
    { -144, 1104, 112},
    { -208, 1064, -40},
    { -256, 952, 24},
    { -104, 848, -120},
    { 16, 616, -64},
    { 72, 592, -64},
    { 96, 672, -32},
    { 80, 856, -72},
    { 80, 904, -16},
    { 96, 968, -16},
    { 96, 1104, -8},
    { 32, 1048, 16},
    { 128, 1120, 176},
    { -288, 1280, 216},
    { -128, 1544, 440},
    { -128, 1184, 328},
    { -40, 920, 288},
    { 16, 680, 320},
    { 56, 576, 136},
    { 88, 752, 240},
    { 24, 712, 248},
    { 48, 848, 288},
    { 0, 744, 120},
    { -136, 1208, 280},
    { -152, 1120, 280},
    // 105 seconds
    { -232, 1344, 288},
    { -184, 1296, 200},
    { -184, 1112, 16},
    { -152, 928, 48},
    { -120, 784, 16},
    { -32, 656, -24},
    { -32, 648, 24},
    { -16, 720, 56},
    { -48, 856, 96},
    { 24, 928, 72},
    { 72, 976, 128},
    { 96, 1096, 200},
    { 80, 1056, 464},
    { -96, 1544, 416},
    { -104, 1248, 544},
    { -120, 1104, 448},
    { -104, 888, 384},
    { -16, 720, 312},
    { -16, 776, 280},
    { -56, 744, 312},
    { -64, 848, 312},
    { -24, 920, 384},
    { 24, 888, 344},
    { 56, 848, 296},
    { 24, 1072, 344},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:09:32 local
AccelRawData *activity_sample_walk_200_pbl_25671_10(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25671_10
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -168, -488, -832},
    { -208, -488, -816},
    { -216, -496, -768},
    { -208, -488, -792},
    { -136, -504, -784},
    { -120, -288, -720},
    { -184, -480, -872},
    { -224, -472, -848},
    { -208, -520, -816},
    { -240, -520, -832},
    { -216, -496, -784},
    { -232, -512, -768},
    { -232, -504, -768},
    { -224, -504, -760},
    { -224, -504, -760},
    { -208, -488, -776},
    { -216, -520, -768},
    { -208, -488, -800},
    { -232, -504, -800},
    { -240, -536, -792},
    { -240, -520, -800},
    { -216, -512, -792},
    { -224, -544, -760},
    { -200, -544, -752},
    { -208, -568, -760},
    // 1 seconds
    { -240, -576, -712},
    { -320, -560, -648},
    { -280, -560, -704},
    { -304, -584, -712},
    { -240, -520, -760},
    { -296, -504, -760},
    { -264, -512, -792},
    { -208, -464, -776},
    { -264, -456, -752},
    { -264, -352, -688},
    { -328, -440, -608},
    { -384, -432, -536},
    { -656, -728, -88},
    { -664, 608, -256},
    { 56, 928, -272},
    { 336, 1936, -552},
    { 560, 1104, -392},
    { 400, 1256, -584},
    { 256, 976, -576},
    { 128, 776, -424},
    { 120, 880, -240},
    { 48, 816, -240},
    { -56, 848, -232},
    { -120, 792, -144},
    { -144, 912, -80},
    // 2 seconds
    { -136, 1056, -96},
    { -88, 1064, -96},
    { -40, 936, -24},
    { -16, 968, -16},
    { -48, 976, 16},
    { -80, 896, 16},
    { -128, 856, 8},
    { -184, 832, 40},
    { -240, 744, -24},
    { -360, 824, 120},
    { -776, 960, 24},
    { -840, 960, -152},
    { -1232, 920, -80},
    { -1336, 896, -232},
    { -1184, 912, -160},
    { -976, 664, -104},
    { -672, 472, -32},
    { -512, 424, -120},
    { -456, 488, -168},
    { -408, 320, -40},
    { -408, 400, -136},
    { -520, 576, -200},
    { -712, 608, -240},
    { -936, 704, -432},
    { -1264, 352, -72},
    // 3 seconds
    { -1320, 240, -80},
    { -1272, 288, -152},
    { -856, 256, -200},
    { -984, 240, -256},
    { -888, 168, -160},
    { -664, 136, -96},
    { -448, 232, -152},
    { -400, 200, -128},
    { -480, 304, -48},
    { -424, 344, -256},
    { -856, 400, -24},
    { -936, 632, -384},
    { -904, 680, -528},
    { -944, 592, -304},
    { -1280, 656, -456},
    { -1528, 608, -368},
    { -1272, 376, -144},
    { -1192, 400, -248},
    { -1024, 184, -104},
    { -632, 16, -8},
    { -552, 56, -32},
    { -544, 112, 8},
    { -536, 152, 24},
    { -648, -16, -56},
    { -704, -208, -176},
    // 4 seconds
    { -1136, 240, -176},
    { -1488, 320, -192},
    { -1760, 488, -232},
    { -1008, 304, -328},
    { -984, 192, -208},
    { -1192, -160, -88},
    { -896, -48, -120},
    { -584, 136, -224},
    { -384, 200, -296},
    { -328, 216, -184},
    { -448, 184, -176},
    { -648, -296, 88},
    { -928, 344, -136},
    { -936, 400, -96},
    { -1048, 560, -416},
    { -1056, 344, -280},
    { -2088, 784, -528},
    { -1544, -104, 32},
    { -1496, 224, -344},
    { -1040, -152, -80},
    { -512, -232, -88},
    { -528, -288, -16},
    { -528, -112, -192},
    { -712, 152, -136},
    { -872, 392, -248},
    // 5 seconds
    { -984, 256, -328},
    { -1168, 432, -392},
    { -1064, 8, -240},
    { -1192, 152, -224},
    { -1632, 304, -216},
    { -568, 248, -344},
    { -976, 8, 16},
    { -872, 144, -144},
    { -480, 192, -216},
    { -392, 144, -176},
    { -464, 160, -168},
    { -680, 240, -216},
    { -896, 328, -288},
    { -1032, 456, -224},
    { -784, 568, -536},
    { -1168, 232, -200},
    { -1616, 376, -504},
    { -1520, -16, -152},
    { -1192, -40, -168},
    { -1008, 152, -256},
    { -688, -16, -88},
    { -464, 80, -88},
    { -600, 96, -48},
    { -800, 152, -24},
    { -952, 208, -88},
    // 6 seconds
    { -960, 96, -40},
    { -1104, 616, -200},
    { -1480, 64, -104},
    { -1184, 80, -104},
    { -1576, 192, -152},
    { -488, 104, -160},
    { -1240, 80, -144},
    { -1016, -56, -80},
    { -584, 40, -144},
    { -448, 120, -200},
    { -432, 152, -224},
    { -608, 184, -144},
    { -760, 288, -200},
    { -768, -192, -200},
    { -928, 312, -216},
    { -1120, 256, -360},
    { -1320, 248, -352},
    { -1976, 408, -560},
    { -1256, 0, 0},
    { -824, 144, -328},
    { -688, 128, -288},
    { -664, 8, -64},
    { -592, 96, -56},
    { -640, 120, 48},
    { -720, 168, 8},
    // 7 seconds
    { -848, 192, -32},
    { -1096, 312, -88},
    { -968, -352, -136},
    { -1296, 200, -112},
    { -1384, -112, -32},
    { -1656, 0, -168},
    { -480, 8, -264},
    { -1184, -296, -224},
    { -960, -304, -96},
    { -568, 112, -200},
    { -416, 128, -240},
    { -424, 104, -168},
    { -840, 352, -344},
    { -760, -400, -392},
    { -968, 280, -400},
    { -1104, 256, -440},
    { -1072, 296, -280},
    { -1376, 304, -352},
    { -1712, 184, -264},
    { -1224, -16, -64},
    { -1072, 200, -232},
    { -784, 56, -72},
    { -512, 32, -80},
    { -464, 128, -104},
    { -608, 104, -8},
    // 8 seconds
    { -776, 48, -104},
    { -776, -520, -120},
    { -1256, 216, 32},
    { -1256, 72, 128},
    { -1424, 112, -152},
    { -1104, 8, -232},
    { -912, 80, -216},
    { -1144, 24, -208},
    { -840, -56, -136},
    { -456, 112, -264},
    { -352, 112, -248},
    { -464, 152, -240},
    { -672, 264, -288},
    { -1152, 744, -640},
    { -1064, -248, -592},
    { -1152, 40, -264},
    { -1648, 336, -480},
    { -1584, 224, -256},
    { -1192, 152, -144},
    { -1016, 272, -240},
    { -656, 16, -16},
    { -536, 80, -40},
    { -520, 88, -48},
    { -688, 96, -16},
    { -784, 176, 104},
    // 9 seconds
    { -1248, 720, -168},
    { -1184, -24, 8},
    { -1184, -24, -48},
    { -1600, 272, -280},
    { -1360, -64, -8},
    { -880, 448, -352},
    { -976, 200, -312},
    { -568, 168, -272},
    { -288, 288, -240},
    { -424, 232, -152},
    { -576, 416, -240},
    { -688, 616, -240},
    { -568, 416, -336},
    { -816, 544, -192},
    { -1056, 424, -232},
    { -1304, 112, 32},
    { -2056, 760, -400},
    { -1056, 224, 104},
    { -1008, 504, -272},
    { -816, 392, -224},
    { -520, 176, 0},
    { -360, 144, -32},
    { -584, 120, 88},
    { -704, 152, 48},
    { -552, 288, 8},
    // 10 seconds
    { -928, 272, -16},
    { -1264, 360, -24},
    { -1224, 376, -232},
    { -1848, 432, -248},
    { -1152, 400, -376},
    { -952, 256, -304},
    { -904, 8, -104},
    { -472, 16, -168},
    { -336, 48, -216},
    { -440, 200, -256},
    { -592, 272, -296},
    { -800, 352, -256},
    { -1000, 296, -456},
    { -992, 392, -424},
    { -1088, 32, -152},
    { -1920, 504, -512},
    { -1432, 40, -72},
    { -1176, 216, -160},
    { -984, 232, -240},
    { -752, 112, -72},
    { -488, 104, -88},
    { -568, 176, -96},
    { -680, 120, -80},
    { -832, 80, -24},
    { -1104, 712, -184},
    // 11 seconds
    { -1240, -200, -456},
    { -1208, -152, 32},
    { -1344, 384, -176},
    { -1368, 48, -280},
    { -656, 200, -280},
    { -984, 264, -304},
    { -840, 136, -176},
    { -488, 200, -176},
    { -392, 296, -312},
    { -680, 384, -360},
    { -832, 264, -368},
    { -872, -104, -224},
    { -992, 344, -424},
    { -1152, 424, -544},
    { -1672, 384, -384},
    { -1712, 184, -256},
    { -1352, -200, 8},
    { -1072, 128, -144},
    { -624, 208, -160},
    { -424, 672, -264},
    { -424, 144, 216},
    { -536, -112, 168},
    { -864, -248, -40},
    { -1128, 392, -88},
    { -1552, 96, -168},
    // 12 seconds
    { -1160, 80, -200},
    { -1792, 344, -432},
    { -640, 48, -64},
    { -808, -16, -136},
    { -848, -152, -104},
    { -512, 48, -136},
    { -472, 152, -216},
    { -656, 184, -352},
    { -944, 696, -360},
    { -1152, -16, -208},
    { -800, 128, -496},
    { -1168, 216, -440},
    { -1264, 0, -128},
    { -1864, 360, -560},
    { -1192, -160, -72},
    { -1048, 152, -256},
    { -880, 64, -56},
    { -616, 16, 24},
    { -560, 56, 40},
    { -696, 40, 0},
    { -776, 88, -16},
    { -1088, 552, -176},
    { -1016, -120, -272},
    { -1168, 168, -160},
    { -992, 224, -176},
    // 13 seconds
    { -1456, 104, -96},
    { -680, -16, -48},
    { -1248, 128, -224},
    { -1144, 168, -256},
    { -584, 96, -264},
    { -416, 80, -240},
    { -584, 280, -232},
    { -824, 328, -408},
    { -856, 240, -440},
    { -864, 176, -328},
    { -1160, 296, -528},
    { -1224, 24, -80},
    { -1544, 240, -336},
    { -1216, 288, -240},
    { -1160, 200, -176},
    { -1096, 200, -160},
    { -736, -8, 72},
    { -456, 152, -72},
    { -648, 528, -56},
    { -1088, 296, -48},
    { -824, 88, 0},
    { -928, 280, -112},
    { -1120, 216, -64},
    { -1192, 248, -104},
    { -1064, 152, -152},
    // 14 seconds
    { -1512, 80, -88},
    { -912, 136, -264},
    { -1056, 184, -296},
    { -960, -16, -184},
    { -544, -40, -184},
    { -392, 104, -232},
    { -392, -16, -264},
    { -672, -472, -360},
    { -848, 280, -456},
    { -1056, 344, -408},
    { -1096, 352, -464},
    { -1192, 296, -288},
    { -1664, 384, -448},
    { -1248, 80, -152},
    { -1096, 192, -200},
    { -936, 176, -216},
    { -656, 40, -64},
    { -432, 72, -48},
    { -616, -168, -144},
    { -584, -368, 0},
    { -872, 184, -72},
    { -1024, 280, -184},
    { -1264, 312, -208},
    { -1184, 56, -40},
    { -1800, 104, -120},
    // 15 seconds
    { -864, 176, -272},
    { -912, 176, -304},
    { -888, 24, -192},
    { -504, -88, -152},
    { -400, 72, -176},
    { -768, 472, -408},
    { -624, -408, -384},
    { -872, 376, -448},
    { -904, 344, -456},
    { -976, 256, -504},
    { -1096, 64, -168},
    { -1632, 368, -496},
    { -1168, 152, -224},
    { -1152, 256, -232},
    { -928, 240, -240},
    { -624, 32, -24},
    { -464, 152, -24},
    { -520, -16, -136},
    { -920, -152, -40},
    { -912, 208, -128},
    { -1144, 200, -128},
    { -1304, 128, -104},
    { -1200, 128, -144},
    { -1688, 104, -104},
    { -968, 168, -248},
    // 16 seconds
    { -1080, 160, -304},
    { -832, 24, -176},
    { -408, -16, -184},
    { -272, 320, -440},
    { -760, 144, -464},
    { -680, 232, -376},
    { -864, 208, -464},
    { -944, 424, -472},
    { -984, 264, -440},
    { -1272, 80, -192},
    { -1784, 312, -368},
    { -1088, 192, -168},
    { -1104, 232, -224},
    { -944, 272, -272},
    { -632, 136, -96},
    { -472, 480, -344},
    { -736, 544, -144},
    { -736, 8, -8},
    { -960, 48, -88},
    { -1144, 264, -256},
    { -1096, 224, -240},
    { -1128, 72, -128},
    { -1512, 104, -160},
    { -944, 216, -264},
    { -1072, 96, -200},
    // 17 seconds
    { -856, 152, -232},
    { -424, 192, -280},
    { -256, 224, -288},
    { -320, 416, -488},
    { -976, 224, 296},
    { -816, 312, -544},
    { -792, 112, -360},
    { -1168, 328, -496},
    { -1320, 248, -272},
    { -1984, 312, -384},
    { -1160, 104, -120},
    { -968, 280, -232},
    { -800, 352, -352},
    { -624, 216, -184},
    { -448, 112, -136},
    { -608, 728, -544},
    { -600, -168, -360},
    { -952, -40, -104},
    { -888, 152, -176},
    { -1208, 288, -312},
    { -1208, 232, -184},
    { -1384, 440, -176},
    { -992, 256, -136},
    { -1048, 248, -256},
    { -1120, 128, -280},
    // 18 seconds
    { -736, 40, -208},
    { -408, 88, -256},
    { -416, 64, -200},
    { -936, 120, -424},
    { -416, -136, -88},
    { -880, 328, -448},
    { -1048, 296, -480},
    { -1176, 184, -288},
    { -1720, 176, -352},
    { -1696, 176, -296},
    { -1040, 56, -112},
    { -992, 248, -280},
    { -712, 144, -168},
    { -464, 32, -88},
    { -464, 56, -96},
    { -632, 208, 56},
    { -1312, 544, -384},
    { -872, -120, 80},
    { -928, 264, -216},
    { -1208, 200, -216},
    { -1064, 96, -144},
    { -1456, 320, -280},
    { -800, 272, -200},
    { -1032, 152, -232},
    { -984, 96, -232},
    // 19 seconds
    { -616, -64, -144},
    { -408, 24, -208},
    { -432, -160, -176},
    { -592, 312, -344},
    { -896, 112, -176},
    { -968, 280, -472},
    { -1016, 264, -464},
    { -1144, 48, -176},
    { -1776, 224, -360},
    { -1360, 72, -112},
    { -1072, 40, -136},
    { -904, 192, -208},
    { -728, 120, -24},
    { -560, 56, -16},
    { -528, -288, -80},
    { -920, 1064, 160},
    { -912, 24, 40},
    { -1056, 280, 8},
    { -1288, 264, -144},
    { -1048, 248, -144},
    { -1520, 208, 16},
    { -968, 272, -160},
    { -1032, 288, -240},
    { -984, 88, -104},
    { -536, 8, -104},
    // 20 seconds
    { -368, 168, -192},
    { -472, 160, -144},
    { -752, 128, -488},
    { -1080, -280, -368},
    { -992, 128, -520},
    { -1256, 296, -472},
    { -1248, -80, -128},
    { -1928, 136, -304},
    { -968, 24, -104},
    { -1008, 160, -320},
    { -912, 64, -240},
    { -624, -152, -88},
    { -536, -232, 64},
    { -520, -232, -128},
    { -856, -64, 56},
    { -1056, -8, -64},
    { -1136, 88, -160},
    { -1320, -24, -88},
    { -840, 56, -216},
    { -1248, -200, -48},
    { -1184, -24, -160},
    { -1144, 96, -424},
    { -856, 144, -360},
    { -456, -112, -216},
    { -392, -120, -152},
    // 21 seconds
    { -544, 0, -288},
    { -856, 464, -344},
    { -904, 496, -472},
    { -928, 64, -536},
    { -976, -24, -448},
    { -1016, 0, -208},
    { -1816, 512, -520},
    { -1376, -8, -16},
    { -1160, 280, -296},
    { -1008, 216, -192},
    { -704, 64, -64},
    { -528, 104, -16},
    { -600, 152, -32},
    { -776, 160, -32},
    { -896, 72, 0},
    { -920, 64, 24},
    { -832, -208, -256},
    { -1168, 96, -64},
    { -1392, 208, -104},
    { -1192, 176, -96},
    { -1120, 304, -328},
    { -1168, 32, -192},
    { -864, 16, -280},
    { -456, 24, -296},
    { -432, 144, -344},
    // 22 seconds
    { -512, 272, -352},
    { -640, 288, -352},
    { -464, 392, -608},
    { -1016, 88, -352},
    { -1168, 304, -424},
    { -1440, 368, -504},
    { -1680, 432, -520},
    { -1048, 96, -160},
    { -1072, 256, -304},
    { -944, 312, -192},
    { -664, 160, -128},
    { -600, 536, -64},
    { -592, 592, -136},
    { -880, -360, 56},
    { -824, 240, -16},
    { -1016, 472, -512},
    { -1184, 72, -432},
    { -1088, -64, -472},
    { -1848, -184, -184},
    { -888, 128, -256},
    { -1056, 264, -384},
    { -1048, 184, -192},
    { -696, 176, -152},
    { -488, 352, -136},
    { -576, 512, -232},
    // 23 seconds
    { -808, 808, -328},
    { -944, 360, -288},
    { -1048, 416, -536},
    { -904, 312, -608},
    { -1072, 392, -696},
    { -1528, 480, -808},
    { -1080, 152, -464},
    { -1104, 224, -432},
    { -1128, 376, -312},
    { -1040, 232, -136},
    { -936, 264, -56},
    { -1016, 200, 0},
    { -1480, 112, 48},
    { -776, -256, 192},
    { -896, -32, -168},
    { -1200, -272, 56},
    { -1296, -88, 80},
    { -1656, -472, 136},
    { -1064, 72, -136},
    { -1264, 104, -192},
    { -1080, 16, -144},
    { -816, 0, -104},
    { -752, 168, -368},
    { -928, -24, -232},
    { -1008, 40, -576},
    // 24 seconds
    { -1016, 744, -824},
    { -1096, 664, -904},
    { -808, 400, -488},
    { -1000, 192, -376},
    { -1584, 336, -480},
    { -1584, -64, 112},
    { -1280, -280, 328},
    { -1320, -88, -8},
    { -992, -216, -88},
    { -624, 8, 8},
    { -784, 128, -8},
    { -680, -304, 264},
    { -872, 48, -240},
    { -840, -40, -104},
    { -1112, 184, -96},
    { -1336, 304, -96},
    { -1400, 200, 8},
    { -1680, 72, 56},
    { -824, 112, -96},
    { -1184, 240, -136},
    { -1096, 136, -88},
    { -712, 168, -104},
    { -416, 88, -232},
    { -376, 240, -120},
    { -488, 416, -280},
    // 25 seconds
    { -728, 248, -408},
    { -936, 96, -424},
    { -1064, 96, -448},
    { -1144, -24, -256},
    { -1656, 264, -408},
    { -1760, 128, -88},
    { -1184, 32, -40},
    { -1048, 184, -216},
    { -920, 16, -64},
    { -648, -144, -88},
    { -544, 48, -192},
    { -760, -56, -48},
    { -912, -344, -24},
    { -1080, -24, -32},
    { -1256, 184, -64},
    { -1112, -24, -96},
    { -1504, 96, -32},
    { -1176, 168, -216},
    { -1056, 208, -288},
    { -984, 160, -360},
    { -664, -40, -240},
    { -376, -96, -216},
    { -424, 64, -312},
    { -632, 160, -384},
    { -936, 600, -624},
    // 26 seconds
    { -816, 336, -480},
    { -944, -56, -296},
    { -1280, 112, -448},
    { -2008, 88, -408},
    { -1200, -240, 48},
    { -904, 152, -224},
    { -800, 184, -272},
    { -720, -24, -56},
    { -656, 40, -56},
    { -648, 168, -80},
    { -712, 104, -24},
    { -888, -112, -80},
    { -720, -72, 80},
    { -1072, 64, 0},
    { -1192, 72, -48},
    { -1984, 112, -48},
    { -1160, 56, -240},
    { -1112, -232, -64},
    { -1184, -344, -56},
    { -872, -96, -224},
    { -496, -40, -200},
    { -392, -8, -232},
    { -360, 96, -216},
    { -376, 600, -696},
    { -856, 336, -280},
    // 27 seconds
    { -1008, 248, -456},
    { -1088, 136, -416},
    { -1672, 224, -504},
    { -2096, 184, -416},
    { -1256, -88, -112},
    { -1152, 16, -208},
    { -928, 320, -152},
    { -624, 184, -16},
    { -464, 112, 0},
    { -504, 240, -40},
    { -680, 0, 16},
    { -600, 240, -176},
    { -952, 288, -288},
    { -1344, 232, -240},
    { -1208, 136, -344},
    { -1496, 184, -80},
    { -1056, 144, -152},
    { -872, 392, -344},
    { -1088, 456, -352},
    { -736, 304, -176},
    { -368, 208, -144},
    { -384, 384, -360},
    { -576, 416, -272},
    { -1000, -536, -384},
    { -960, 432, -440},
    // 28 seconds
    { -800, 656, -536},
    { -1048, 608, -560},
    { -1032, 296, -248},
    { -1376, 552, -664},
    { -1344, 384, -344},
    { -1344, 360, -280},
    { -1008, 328, -216},
    { -656, 248, -88},
    { -624, 248, -56},
    { -752, 272, -40},
    { -928, 680, -136},
    { -896, -16, -256},
    { -944, 24, 104},
    { -1104, 192, -104},
    { -1200, 432, -248},
    { -1392, 248, -216},
    { -744, 408, -192},
    { -1128, 400, -240},
    { -1040, 280, -224},
    { -616, 200, -120},
    { -272, 216, -416},
    { -416, -32, -240},
    { -776, 224, -320},
    { -800, 616, -696},
    { -608, 376, -552},
    // 29 seconds
    { -1040, 488, -544},
    { -1128, 120, -160},
    { -1864, 424, -400},
    { -1576, 120, -128},
    { -1192, 168, -184},
    { -1096, 248, -240},
    { -784, 80, -48},
    { -400, 88, -104},
    { -488, 160, -104},
    { -600, 824, -200},
    { -1272, 200, 40},
    { -1016, -176, 160},
    { -1120, -176, -56},
    { -1256, 40, -176},
    { -1048, 176, -208},
    { -1560, 224, -176},
    { -840, 176, -184},
    { -1056, 248, -328},
    { -1000, 152, -184},
    { -504, 56, -88},
    { -304, 200, -376},
    { -560, 496, -128},
    { -616, 232, -288},
    { -760, 144, -360},
    { -920, 248, -408},
    // 30 seconds
    { -1352, 336, -464},
    { -1552, -72, -152},
    { -1616, 192, -384},
    { -1088, 32, -120},
    { -1176, 144, -280},
    { -880, 32, -112},
    { -568, 64, -160},
    { -496, 88, -152},
    { -592, 64, -88},
    { -824, -8, 32},
    { -840, -80, 96},
    { -1000, -440, -208},
    { -1344, -96, 80},
    { -992, -80, -80},
    { -1680, -16, -80},
    { -1056, 168, -304},
    { -1024, -32, -296},
    { -912, -296, -128},
    { -640, 288, -272},
    { -368, -40, -192},
    { -424, 168, -264},
    { -656, 344, -328},
    { -1032, -104, -200},
    { -1152, -208, -296},
    { -1264, -144, -392},
    // 31 seconds
    { -1040, -112, -288},
    { -1624, 176, -568},
    { -1168, -96, -168},
    { -1144, 112, -248},
    { -872, -72, -16},
    { -536, -120, -8},
    { -560, -48, -32},
    { -680, 8, -112},
    { -776, 520, -32},
    { -1320, 144, -256},
    { -1152, 136, -232},
    { -1032, -120, 0},
    { -1344, -224, 56},
    { -1232, -24, -80},
    { -1128, 160, -224},
    { -1104, -104, -80},
    { -304, -32, -520},
    { -360, 128, -376},
    { -424, 120, -360},
    { -552, 80, -384},
    { -872, 184, -288},
    { -928, 248, -328},
    { -1200, 352, -464},
    { -1104, 48, -80},
    { -1808, 472, -616},
    // 32 seconds
    { -1232, -104, 160},
    { -1120, 424, -280},
    { -952, 264, -192},
    { -608, 40, -72},
    { -456, 136, -104},
    { -616, 88, 0},
    { -752, 168, 40},
    { -944, 192, 0},
    { -896, 192, 96},
    { -1120, 368, -192},
    { -1104, 240, -64},
    { -1256, 312, -160},
    { -1608, 184, -96},
    { -1000, 168, -240},
    { -984, 320, -536},
    { -616, 224, -216},
    { -320, 88, -160},
    { -448, 224, -176},
    { -680, 192, -224},
    { -864, 400, -296},
    { -872, 288, -312},
    { -1096, 408, -456},
    { -1232, 280, -176},
    { -2032, 536, -472},
    { -1104, 24, 8},
    // 33 seconds
    { -1192, 312, -304},
    { -880, 184, -176},
    { -648, 56, -56},
    { -560, 88, -48},
    { -584, 144, -32},
    { -712, 192, -24},
    { -856, 144, 24},
    { -880, 88, 56},
    { -1144, -176, -600},
    { -1072, 208, -32},
    { -1792, 96, -128},
    { -1152, 96, -224},
    { -632, 320, -256},
    { -1088, -16, -216},
    { -776, -64, -136},
    { -400, 160, -224},
    { -712, 64, -184},
    { -552, 72, -184},
    { -856, 200, -312},
    { -1128, 472, -224},
    { -1096, 344, -440},
    { -1192, 232, -336},
    { -1896, 392, -552},
    { -1336, 32, -152},
    { -1048, 216, -312},
    // 34 seconds
    { -888, 208, -272},
    { -624, 0, -72},
    { -408, 96, -96},
    { -528, 208, -88},
    { -784, 144, -24},
    { -1000, 128, -24},
    { -1280, 560, -400},
    { -1008, -672, -264},
    { -1112, -160, 8},
    { -1376, -16, -80},
    { -1144, -56, 0},
    { -968, 216, -328},
    { -976, 72, -304},
    { -688, -128, -152},
    { -416, -32, -120},
    { -112, 144, -616},
    { -800, 304, -376},
    { -840, -136, -168},
    { -968, 240, -368},
    { -1160, 200, -496},
    { -1160, -192, -96},
    { -1720, 88, -472},
    { -1480, -144, -232},
    { -1144, 24, -304},
    { -992, 72, -320},
    // 35 seconds
    { -744, -216, -64},
    { -424, -16, -152},
    { -480, 144, -96},
    { -704, 104, -48},
    { -896, 56, -24},
    { -936, 80, -40},
    { -1080, 96, -56},
    { -1184, 64, -168},
    { -944, -24, -104},
    { -1992, 528, -440},
    { -1176, -72, -336},
    { -1120, 48, -272},
    { -1016, -64, -232},
    { -528, 32, -184},
    { -328, 16, -256},
    { -440, 96, -264},
    { -688, 192, -336},
    { -1024, 656, -384},
    { -1240, -32, -472},
    { -1008, 168, -416},
    { -1104, 104, -296},
    { -1752, 360, -536},
    { -1680, 272, -256},
    { -1128, 128, -136},
    { -984, 152, -224},
    // 36 seconds
    { -808, 56, -96},
    { -536, 72, 8},
    { -536, 176, -88},
    { -704, 136, 0},
    { -816, 104, 8},
    { -896, 72, 16},
    { -808, 128, -248},
    { -1240, -232, -144},
    { -1056, 136, -136},
    { -1504, 96, -168},
    { -896, 80, -168},
    { -1024, 216, -296},
    { -1120, 16, -200},
    { -688, -128, -136},
    { -392, -96, -104},
    { -440, -440, -320},
    { -472, 32, -280},
    { -952, 312, -320},
    { -1064, 64, -328},
    { -1008, 288, -512},
    { -1064, 208, -336},
    { -1640, 136, -408},
    { -1584, 88, -232},
    { -976, 120, -208},
    { -888, 328, -368},
    // 37 seconds
    { -648, 272, -160},
    { -408, 104, -48},
    { -664, 136, -32},
    { -832, 336, 136},
    { -1256, 248, -112},
    { -872, 24, -16},
    { -1064, 184, -160},
    { -1168, 64, -160},
    { -1608, 288, -184},
    { -1328, 96, -168},
    { -816, 120, -256},
    { -1104, 64, -248},
    { -776, -32, -192},
    { -400, 80, -136},
    { -224, 176, -296},
    { -464, -184, -160},
    { -784, 208, -336},
    { -992, 104, -496},
    { -1040, 88, -216},
    { -1024, 464, -432},
    { -1176, 304, -304},
    { -1728, 472, -448},
    { -1016, 176, -120},
    { -1096, 320, -264},
    { -1048, 288, -216},
    // 38 seconds
    { -688, 168, -128},
    { -496, 224, -176},
    { -680, 312, -184},
    { -760, -48, 8},
    { -720, -88, 176},
    { -704, 312, -272},
    { -1184, 448, -336},
    { -1064, 328, -272},
    { -1480, 80, -128},
    { -1024, 216, -200},
    { -736, 384, -352},
    { -960, 168, -264},
    { -736, 96, -200},
    { -392, 128, -232},
    { -312, 184, -176},
    { -336, -120, -320},
    { -592, 472, -488},
    { -816, 536, -576},
    { -800, 520, -608},
    { -1120, 360, -464},
    { -1152, 152, -224},
    { -1616, 416, -392},
    { -1312, 288, -224},
    { -1304, 264, -128},
    { -1064, 288, -240},
    // 39 seconds
    { -776, 224, -112},
    { -488, 128, -152},
    { -464, 152, -144},
    { -520, -24, -64},
    { -552, -56, -184},
    { -928, 168, -136},
    { -1288, 216, -216},
    { -1264, 264, -248},
    { -1480, 376, -144},
    { -952, 288, -240},
    { -904, 224, -304},
    { -1048, 120, -200},
    { -736, 104, -216},
    { -400, 120, -192},
    { -432, 176, -240},
    { -560, 200, -248},
    { -712, 88, -200},
    { -864, -400, -544},
    { -784, 24, -176},
    { -1208, 344, -544},
    { -1152, 8, -136},
    { -1824, 632, -728},
    { -1224, 32, -112},
    { -1104, 56, -248},
    { -976, 32, -160},
    // 40 seconds
    { -496, -40, -48},
    { -328, 136, -120},
    { -584, 112, -16},
    { -832, 112, 32},
    { -944, 96, 24},
    { -1008, -120, 88},
    { -1064, -216, -160},
    { -1056, 144, -152},
    { -1832, 112, -256},
    { -920, 48, -296},
    { -1160, 152, -368},
    { -1016, -168, -184},
    { -464, -104, -208},
    { -352, 80, -304},
    { -392, 144, -304},
    { -512, 392, -312},
    { -832, 856, -480},
    { -1168, 352, -440},
    { -1216, 280, -408},
    { -1136, 96, -208},
    { -1768, 488, -592},
    { -1296, 184, -168},
    { -1288, 200, -128},
    { -1008, 200, -32},
    { -608, 16, -16},
    // 41 seconds
    { -448, 56, -40},
    { -552, 32, -64},
    { -672, -16, 40},
    { -712, -32, -112},
    { -1120, 8, -96},
    { -1216, 56, -144},
    { -1320, 144, -128},
    { -1728, 312, -240},
    { -784, 304, -344},
    { -1016, 96, -200},
    { -1024, -48, -144},
    { -512, -64, -136},
    { -360, 424, -368},
    { -560, 240, -296},
    { -744, 256, -424},
    { -1008, 232, -408},
    { -872, 320, -512},
    { -1120, 288, -440},
    { -1144, 64, -256},
    { -1640, 280, -424},
    { -1216, 128, -136},
    { -1176, 128, -176},
    { -1112, 256, -264},
    { -784, 120, -136},
    { -600, 48, 24},
    // 42 seconds
    { -568, 192, -232},
    { -768, 624, -24},
    { -936, 144, 8},
    { -864, 112, 32},
    { -1048, 344, -72},
    { -1176, 296, -128},
    { -1216, 320, -24},
    { -1224, 112, 24},
    { -840, 232, -208},
    { -1056, 312, -344},
    { -888, 264, -376},
    { -448, 0, -192},
    { -424, 72, -312},
    { -584, 360, -256},
    { -904, 896, -648},
    { -904, 248, -464},
    { -928, 224, -528},
    { -1272, 296, -528},
    { -1344, 16, -240},
    { -1688, 376, -568},
    { -1088, -24, -56},
    { -1144, 160, -232},
    { -984, 256, -264},
    { -552, -8, -8},
    { -376, 112, -104},
    // 43 seconds
    { -600, 200, -120},
    { -744, 0, -16},
    { -896, -256, 32},
    { -952, -304, -48},
    { -1288, 264, -136},
    { -1160, 232, -160},
    { -1360, 296, -96},
    { -960, 256, -232},
    { -1152, 216, -360},
    { -912, 104, -248},
    { -392, -104, -176},
    { -336, -16, -208},
    { -520, 136, -184},
    { -776, 120, -304},
    { -928, -224, -344},
    { -1168, 304, -304},
    { -1320, -136, 64},
    { -1344, -192, -24},
    { -1656, 232, -144},
    { -1200, 176, -24},
    { -1176, 64, 160},
    { -920, -248, 416},
    { -384, -104, 184},
    { -496, 0, 184},
    { -656, 136, 64},
    // 44 seconds
    { -808, 136, 48},
    { -912, 136, -256},
    { -1232, -368, 0},
    { -1168, 256, -176},
    { -1088, -96, 136},
    { -1736, 48, -280},
    { -1048, -72, -128},
    { -1128, -336, 112},
    { -816, -88, -88},
    { -408, -56, -40},
    { -384, -24, -48},
    { -496, 128, -104},
    { -768, 152, -248},
    { -960, 80, -448},
    { -1088, 88, -168},
    { -1096, 88, -200},
    { -1472, 176, -152},
    { -2080, 360, -312},
    { -1328, -200, 112},
    { -1040, 64, -72},
    { -784, 176, -104},
    { -568, -24, 80},
    { -440, 40, 24},
    { -536, 120, -16},
    { -680, 152, -24},
    // 45 seconds
    { -944, 472, -96},
    { -1048, 192, 16},
    { -1208, 64, -72},
    { -1080, 56, -112},
    { -1552, 96, -112},
    { -864, 88, -208},
    { -1192, 80, -328},
    { -1048, -144, -184},
    { -520, -136, -200},
    { -376, -32, -256},
    { -368, -416, -384},
    { -512, -112, -376},
    { -976, 256, -472},
    { -1056, 176, -464},
    { -1328, 232, -528},
    { -1232, -120, -72},
    { -1696, 232, -400},
    { -1152, 192, -168},
    { -1240, 224, -192},
    { -1144, 224, -104},
    { -680, 56, 32},
    { -464, 144, -72},
    { -496, 168, -72},
    { -656, 120, -24},
    { -840, 80, -32},
    // 46 seconds
    { -896, 144, -24},
    { -1280, 48, -48},
    { -1296, 112, -24},
    { -1296, 144, -104},
    { -1328, 32, -104},
    { -944, 224, -248},
    { -1056, 160, -272},
    { -784, 0, -200},
    { -472, -24, -208},
    { -416, 112, -216},
    { -568, 224, -296},
    { -808, 264, -312},
    { -1216, 368, -488},
    { -1120, -184, -464},
    { -1120, 264, -480},
    { -1160, -160, -144},
    { -1872, 392, -432},
    { -1152, 40, -80},
    { -1048, 208, -232},
    { -968, 120, -72},
    { -584, 48, 8},
    { -408, 128, -24},
    { -512, 224, 24},
    { -720, 208, 96},
    { -840, 336, -64},
    // 47 seconds
    { -1000, 344, 56},
    { -1216, 120, -80},
    { -1184, -40, 56},
    { -1568, -240, 112},
    { -1352, 64, -192},
    { -1024, 168, -264},
    { -1120, -80, -192},
    { -752, -56, -224},
    { -352, 72, -208},
    { -384, 96, -232},
    { -560, 224, -256},
    { -808, 240, -248},
    { -888, 104, -368},
    { -1120, -56, -432},
    { -1096, 296, -392},
    { -1472, -176, 8},
    { -1864, 480, -392},
    { -1200, -128, -32},
    { -1184, -8, -192},
    { -824, -96, -56},
    { -288, -64, -32},
    { -480, 136, 32},
    { -784, -32, 88},
    { -1024, 16, 120},
    { -936, 88, 16},
    // 48 seconds
    { -968, 120, -128},
    { -1200, 72, -128},
    { -1184, 80, -376},
    { -1616, 144, -384},
    { -888, -168, -184},
    { -984, 24, -168},
    { -1240, -80, -136},
    { -720, 112, -224},
    { -360, 16, -208},
    { -400, 64, -168},
    { -504, 112, -136},
    { -800, 192, -200},
    { -1000, 200, -216},
    { -1080, 160, -240},
    { -1272, 864, -272},
    { -960, -472, 8},
    { -1976, 416, -416},
    { -1464, -248, 208},
    { -1352, 144, -144},
    { -920, 360, -24},
    { -512, -248, -8},
    { -432, 8, -8},
    { -728, -120, -80},
    { -696, 120, -40},
    { -936, 224, -128},
    // 49 seconds
    { -1056, 184, -80},
    { -1176, 184, -104},
    { -1144, 8, -24},
    { -792, 0, -120},
    { -1552, -136, -8},
    { -1160, -48, -168},
    { -920, 136, -336},
    { -976, -112, -192},
    { -536, -136, -136},
    { -392, 80, -184},
    { -488, 184, -280},
    { -640, 176, -176},
    { -840, 160, -336},
    { -1072, 480, -448},
    { -1176, -312, -544},
    { -1096, 16, -216},
    { -1048, 32, -216},
    { -1936, 592, -680},
    { -1376, -920, -56},
    { -1264, 32, -216},
    { -848, -160, -144},
    { -504, 312, 40},
    { -320, 64, -48},
    { -536, 144, -112},
    { -776, 184, -80},
    // 50 seconds
    { -1040, 152, -120},
    { -1232, 232, -88},
    { -1352, 232, -184},
    { -992, 56, -136},
    { -1616, 128, -136},
    { -680, 0, -144},
    { -1144, 16, -224},
    { -920, -8, -216},
    { -480, -16, -152},
    { -344, 24, -176},
    { -440, -24, -80},
    { -600, 112, -272},
    { -960, 40, -184},
    { -1048, 152, -200},
    { -1208, 72, -360},
    { -1216, -200, -56},
    { -1832, -8, -464},
    { -1560, -312, 160},
    { -1424, 296, -8},
    { -848, 200, 48},
    { -304, 136, -80},
    { -336, 8, -16},
    { -560, 152, -40},
    { -872, 224, -160},
    { -1000, 0, -24},
    // 51 seconds
    { -1072, 200, -104},
    { -1216, 120, -40},
    { -1440, 216, -144},
    { -1192, 0, -232},
    { -912, -16, -216},
    { -1280, -56, -224},
    { -672, -152, -208},
    { -296, -8, -208},
    { -368, 48, -216},
    { -544, 104, -256},
    { -824, 80, -264},
    { -1016, 64, -240},
    { -1104, 104, -320},
    { -1376, 168, -328},
    { -1472, 96, 384},
    { -1424, 304, -544},
    { -1416, -80, 80},
    { -1280, -328, 128},
    { -1328, -64, 216},
    { -864, -216, -312},
    { -384, -112, 88},
    { -488, -32, 112},
    { -672, 56, 24},
    { -856, 16, 72},
    { -1096, 88, 16},
    // 52 seconds
    { -1376, 168, 272},
    { -1112, 24, 184},
    { -1064, -8, 208},
    { -1440, 8, 64},
    { -952, -144, -80},
    { -1240, -56, -64},
    { -776, -408, 120},
    { -424, -8, -80},
    { -464, 168, -248},
    { -464, 128, -168},
    { -912, 16, -56},
    { -1168, 216, -96},
    { -1296, 312, -104},
    { -1152, 152, -72},
    { -1056, 304, -64},
    { -944, 432, -216},
    { -1824, 512, -160},
    { -1296, -296, 296},
    { -1000, 304, -8},
    { -1192, -200, 152},
    { -560, -160, 272},
    { -472, -96, 24},
    { -592, -96, 32},
    { -832, 88, 24},
    { -864, 40, 0},
    // 53 seconds
    { -1192, 112, -136},
    { -1280, -16, 32},
    { -1056, 80, -96},
    { -1152, -88, 40},
    { -1240, 0, -48},
    { -976, 80, -224},
    { -1120, 32, -248},
    { -776, -240, -152},
    { -368, -160, -168},
    { -448, 72, -264},
    { -624, 32, -256},
    { -808, 96, -288},
    { -928, 440, -376},
    { -1176, 136, -512},
    { -1192, 72, -432},
    { -1176, -16, -176},
    { -840, 88, -232},
    { -1744, 1024, -1072},
    { -1648, -1160, 664},
    { -1200, 112, 32},
    { -936, -344, 56},
    { -600, -56, 40},
    { -408, 40, -16},
    { -520, 32, -24},
    { -792, 48, -56},
    // 54 seconds
    { -1048, 240, -120},
    { -1080, 80, -64},
    { -1296, 88, -136},
    { -1024, -8, -24},
    { -1680, 248, -160},
    { -696, 96, -232},
    { -952, 144, -240},
    { -1040, -40, -120},
    { -640, -232, -112},
    { -496, 88, -272},
    { -544, 136, -320},
    { -648, 88, -320},
    { -920, 200, -192},
    { -952, 40, -448},
    { -1384, 304, -616},
    { -984, 144, -288},
    { -1152, 64, -184},
    { -2128, 152, -488},
    { -1184, -56, 184},
    { -1200, 192, -80},
    { -952, 64, 152},
    { -552, 0, 88},
    { -432, 8, 16},
    { -672, 32, 8},
    { -864, 64, -24},
    // 55 seconds
    { -920, 64, -72},
    { -1008, 120, -160},
    { -1312, 80, -136},
    { -1080, 16, -152},
    { -1352, -88, 0},
    { -1160, -64, -40},
    { -904, 8, -192},
    { -1064, -80, -144},
    { -744, -208, -112},
    { -448, -72, -168},
    { -432, 64, -288},
    { -584, -16, -272},
    { -776, 256, -528},
    { -976, 336, -776},
    { -1048, 176, -560},
    { -1024, 64, -488},
    { -1112, -72, -192},
    { -872, -224, -792},
    { -1928, 56, 16},
    { -1368, -232, 48},
    { -1088, -128, 248},
    { -1176, 392, -312},
    { -440, -304, -512},
    { -288, 256, -272},
    { -496, 208, -232},
    // 56 seconds
    { -736, 8, -176},
    { -712, -24, -216},
    { -1104, -160, -264},
    { -1360, -72, -208},
    { -1160, -32, -176},
    { -1368, -64, -72},
    { -1080, 56, -104},
    { -1112, 136, -224},
    { -1064, 168, -136},
    { -720, 120, -216},
    { -416, -40, -136},
    { -552, 136, -296},
    { -688, 240, -376},
    { -848, 400, -496},
    { -1144, 256, -480},
    { -1240, 128, -520},
    { -1048, 56, -496},
    { -912, -168, -312},
    { -1440, 192, -560},
    { -1336, 264, -88},
    { -1264, -320, -328},
    { -1216, -48, 96},
    { -952, -88, 200},
    { -512, -120, 40},
    { -504, 504, 16},
    // 57 seconds
    { -848, -296, 280},
    { -928, -136, 56},
    { -1200, 296, -88},
    { -1216, -176, -16},
    { -1176, -136, -48},
    { -1784, -144, 8},
    { -712, 112, -368},
    { -1072, -144, -160},
    { -920, -216, -72},
    { -472, 0, -192},
    { -448, 160, -264},
    { -608, 160, -320},
    { -856, 248, -360},
    { -1032, 200, -400},
    { -1048, 192, -448},
    { -1064, 312, -552},
    { -944, 16, -320},
    { -1064, 64, -352},
    { -1608, 280, -472},
    { -1304, -152, -96},
    { -1144, 296, -264},
    { -1216, 704, -120},
    { -696, 128, 32},
    { -592, -160, 32},
    { -648, 136, 8},
    // 58 seconds
    { -888, -232, 72},
    { -1024, 16, 56},
    { -1216, -16, -104},
    { -1304, -96, -16},
    { -1016, -24, -136},
    { -1576, -32, -64},
    { -984, 112, -248},
    { -1016, 184, -384},
    { -888, 0, -216},
    { -480, -8, -200},
    { -352, 104, -272},
    { -576, 176, -288},
    { -864, 320, -392},
    { -1016, 264, -392},
    { -1056, 160, -408},
    { -1112, 120, -440},
    { -1024, 128, -416},
    { -920, -16, -224},
    { -1352, 208, -576},
    { -1112, -648, -192},
    { -1248, -400, 24},
    { -1248, -152, -56},
    { -856, -184, 152},
    { -552, 376, -24},
    { -632, -72, 80},
    // 59 seconds
    { -768, -8, 48},
    { -1048, 112, -72},
    { -1024, 40, -80},
    { -1240, -64, -112},
    { -1064, -176, 40},
    { -1072, 240, -192},
    { -1480, 40, -96},
    { -936, 176, -352},
    { -1072, -88, -232},
    { -736, -192, -120},
    { -368, 0, -216},
    { -384, 136, -328},
    { -592, 40, -208},
    { -800, 200, -408},
    { -1048, 48, -288},
    { -968, -16, -400},
    { -1176, -40, -416},
    { -960, -208, -200},
    { -1712, 520, -984},
    { -1560, -600, 344},
    { -1288, -16, -344},
    { -1096, -480, 168},
    { -568, -104, -112},
    { -600, 0, -24},
    { -544, -256, 72},
    // 60 seconds
    // elapsed: 1 minutes
    { -568, -160, 24},
    { -776, -16, -136},
    { -1008, 88, -104},
    { -1136, 72, -64},
    { -1240, 0, -88},
    { -872, 184, -216},
    { -1352, 144, -136},
    { -1104, 24, -160},
    { -872, 240, -448},
    { -976, 48, -400},
    { -648, -136, -192},
    { -480, -16, -216},
    { -584, 24, -192},
    { -720, 56, -208},
    { -840, 88, -272},
    { -1048, 184, -376},
    { -1160, 128, -368},
    { -1088, 24, -368},
    { -1488, -104, 120},
    { -1800, 560, -688},
    { -1064, -112, -40},
    { -968, 304, -296},
    { -904, 72, -160},
    { -720, -368, -8},
    { -520, 16, -80},
    // 61 seconds
    { -616, 128, -136},
    { -784, 192, -80},
    { -960, 264, -120},
    { -1120, 248, -160},
    { -1256, 256, -168},
    { -1264, 272, -128},
    { -1608, 432, -128},
    { -632, 528, -240},
    { -1024, 528, -232},
    { -880, 440, -112},
    { -520, 592, -192},
    { -352, 448, -192},
    { -352, 536, -88},
    { -312, 600, -200},
    { -264, 688, 200},
    { -208, 568, -512},
    { -312, 936, 24},
    { -168, 1024, -80},
    { -240, 1056, 248},
    { -312, 1504, 184},
    { -400, 1168, 272},
    { -240, 824, 152},
    { -248, 808, 216},
    { -160, 728, 232},
    { -120, 576, 208},
    // 62 seconds
    { -32, 640, 192},
    { -8, 720, 144},
    { -32, 832, 192},
    { -24, 976, 144},
    { -168, 1096, 224},
    { -192, 1128, 184},
    { -184, 1272, 136},
    { -224, 1016, 160},
    { -160, 1048, 8},
    { -200, 872, 72},
    { -120, 832, 64},
    { 0, 744, -16},
    { 64, 656, -8},
    { 88, 680, 8},
    { 104, 1056, -40},
    { 136, 992, -24},
    { 128, 936, 0},
    { 192, 1144, 80},
    { 64, 1264, 56},
    { 184, 1392, 248},
    { -136, 1104, 248},
    { -72, 1264, 272},
    { -72, 1160, 352},
    { -64, 920, 184},
    { 32, 648, 152},
    // 63 seconds
    { 96, 632, 152},
    { 96, 736, 152},
    { 80, 792, 184},
    { 72, 976, 192},
    { 80, 1080, 200},
    { -64, 1088, 224},
    { -104, 1208, 152},
    { -168, 1224, 232},
    { -144, 1104, 96},
    { -64, 1008, 40},
    { -88, 896, 24},
    { 16, 760, -8},
    { 96, 544, -40},
    { 48, 568, 96},
    { 16, 720, 144},
    { 64, 856, 184},
    { 272, 720, -304},
    { 224, 1168, 216},
    { 112, 1616, -8},
    { 48, 1072, 56},
    { -80, 1216, 232},
    { -136, 1144, 728},
    { -104, 1168, 304},
    { -120, 1064, 544},
    { -80, 920, 208},
    // 64 seconds
    { 144, 576, 128},
    { 104, 616, 160},
    { 40, 728, 176},
    { 64, 872, 224},
    { -24, 1064, 200},
    { -168, 1248, 272},
    { -192, 1184, 224},
    { -184, 1272, 352},
    { -200, 1080, 232},
    { -64, 1096, 8},
    { -96, 920, 88},
    { 48, 680, 32},
    { 136, 640, -88},
    { 176, 600, 64},
    { 144, 936, 24},
    { 128, 960, 152},
    { 192, 1168, -104},
    { 96, 824, -136},
    { 64, 1080, 176},
    { 8, 1088, 408},
    { -16, 1336, 168},
    { -16, 1264, 368},
    { 64, 1256, 344},
    { 80, 808, 192},
    { 80, 840, 432},
    // 65 seconds
    { 80, 648, 32},
    { 184, 576, 160},
    { 240, 656, 248},
    { 304, 976, 288},
    { 240, 1072, 240},
    { 112, 1064, 224},
    { 48, 912, 320},
    { 32, 1104, 40},
    { 40, 872, 272},
    { 104, 992, 360},
    { 40, 1400, 128},
    { 128, 1040, 136},
    { 176, 640, 64},
    { 288, 520, 0},
    { 336, 568, 216},
    { 352, 936, -8},
    { 256, 592, 496},
    { 184, 1216, 176},
    { 216, 1488, 488},
    { 344, 1240, 424},
    { 264, 1400, 400},
    { -200, 1080, 472},
    { -72, 904, 304},
    { 0, 976, 392},
    { -80, 680, 280},
    // 66 seconds
    { 56, 544, 184},
    { 96, 616, 160},
    { 88, 768, 304},
    { 80, 992, 232},
    { 144, 936, 192},
    { 64, 1016, 232},
    { -64, 984, 208},
    { -120, 1096, 168},
    { -256, 1136, 408},
    { -200, 1328, 160},
    { -88, 1232, 240},
    { -72, 960, 176},
    { 128, 760, 56},
    { 176, 656, 88},
    { 232, 640, 40},
    { 168, 1200, 376},
    { 144, 952, -304},
    { 208, 1224, 40},
    { 392, 896, 64},
    { 248, 1472, 32},
    { 0, 672, 56},
    { 120, 1440, 312},
    { -264, 1576, 544},
    { -232, 1248, 384},
    { -16, 824, 208},
    // 67 seconds
    { -152, -80, 112},
    { 192, 472, 184},
    { 272, 616, 136},
    { 256, 872, 256},
    { 256, 1064, 224},
    { 216, 968, 296},
    { 152, 1120, 264},
    { 120, 1176, 168},
    { -16, 1088, 136},
    { -32, 944, 432},
    { -128, 1384, 152},
    { 8, 1072, 232},
    { 32, 976, 24},
    { 88, 760, 96},
    { 184, 648, 32},
    { 216, 656, -8},
    { 200, 664, 72},
    { 240, 824, -24},
    { 296, 896, 0},
    { 360, 1112, 8},
    { 312, 1232, 64},
    { 240, 1432, -40},
    { 432, 1336, 240},
    { -16, 992, 16},
    { 144, 1208, 208},
    // 68 seconds
    { 16, 712, 192},
    { 120, 1152, 32},
    { 64, 680, -56},
    { 96, 536, -272},
    { 200, 800, 8},
    { 296, 704, 256},
    { 256, 1080, 136},
    { 248, 984, 104},
    { 104, 1056, 96},
    { 208, 992, 112},
    { 136, 1024, 152},
    { 160, 1024, 392},
    { 88, 1344, 280},
    { 256, 1136, 168},
    { 176, 936, 104},
    { 248, 600, 144},
    { 272, 600, 120},
    { 280, 664, 192},
    { 296, 888, 176},
    { 312, 928, 200},
    { 384, 1040, 200},
    { 344, 1072, 216},
    { 304, 1144, 160},
    { 288, 816, 192},
    { 368, 1312, 408},
    // 69 seconds
    { -232, 1520, 176},
    { 24, 776, 608},
    { 96, 968, 168},
    { 136, 720, 200},
    { 128, 648, 136},
    { 192, 648, 64},
    { 352, 624, 208},
    { 248, 992, 216},
    { 248, 936, 304},
    { 96, 1208, 152},
    { 48, 1072, 104},
    { 24, 1112, -104},
    { -8, 944, 88},
    { -136, 1336, 16},
    { 64, 1288, -16},
    { 176, 816, 16},
    { 288, 544, 48},
    { 376, 464, 88},
    { 360, 552, 144},
    { 312, 728, 208},
    { 320, 952, 160},
    { 352, 968, 208},
    { 392, 976, 200},
    { 304, 984, 224},
    { 232, 1000, 288},
    // 70 seconds
    { 176, 1064, 112},
    { 184, 1384, 328},
    { -648, 1336, 704},
    { -96, 1496, 144},
    { -216, 856, 312},
    { 24, 936, 40},
    { 304, 824, 104},
    { 272, 696, 96},
    { 272, 792, 192},
    { -8, 1192, 232},
    { -280, 1272, 224},
    { -224, 1040, 120},
    { -160, 888, 64},
    { -104, 856, 144},
    { 0, 1024, 320},
    { -48, 1272, 24},
    { 128, 928, 72},
    { 152, 704, 16},
    { 256, 632, 80},
    { 208, 760, 48},
    { 224, 872, 128},
    { 240, 1400, -184},
    { 296, 816, -136},
    { 288, 1152, 256},
    { 216, 1336, 152},
    // 71 seconds
    { 264, 688, 192},
    { 280, 1520, 128},
    { -328, 1392, 808},
    { -264, 1552, 432},
    { -72, 920, 408},
    { 64, 800, 104},
    { 224, 472, 64},
    { 200, 624, 80},
    { 208, 776, 192},
    { 184, 944, 288},
    { 8, 1176, 248},
    { -40, 1160, 280},
    { -152, 1352, 248},
    { -56, 1008, 128},
    { -64, 1040, 112},
    { -88, 904, 112},
    { -8, 808, 72},
    { 120, 672, 16},
    { 168, 664, -8},
    { 128, 744, 144},
    { 176, 1024, 144},
    { 224, 952, 120},
    { 352, 1392, 160},
    { 320, 1728, -40},
    { 168, 736, 520},
    // 72 seconds
    { 328, 1784, -128},
    { 40, 944, 296},
    { 104, 800, -72},
    { 216, 808, 224},
    { 176, 712, 288},
    { 56, 616, 232},
    { 128, 808, 136},
    { 152, 688, 112},
    { 88, 880, 120},
    { 112, 968, 80},
    { 64, 1064, 144},
    { 0, 1200, 72},
    { 16, 1264, 272},
    { -72, 1192, 160},
    { 40, 1216, -8},
    { 80, 800, 48},
    { 88, 792, -8},
    { 192, 680, -64},
    { 280, 640, -32},
    { 280, 768, -8},
    { 368, 744, 32},
    { 328, 1144, -80},
    { 424, 712, -96},
    { 400, 1216, 144},
    { 384, 1184, 32},
    // 73 seconds
    { 472, 1128, 176},
    { 144, 1224, -144},
    { -8, 1416, 264},
    { 64, 1080, 328},
    { 80, 816, 160},
    { 144, 688, 0},
    { 216, 456, 64},
    { 240, 616, 64},
    { 264, 720, 104},
    { 256, 920, 144},
    { 160, 1088, 144},
    { -32, 1056, 112},
    { 32, 1104, -64},
    { 0, 1312, 144},
    { -128, 1224, 88},
    { 96, 1296, 24},
    { 144, 952, -32},
    { 120, 904, -208},
    { 160, 584, -16},
    { 224, 616, -96},
    { 216, 616, -8},
    { 304, 704, -64},
    { 352, 688, 264},
    { 256, 1080, 80},
    { 304, 1336, 40},
    // 74 seconds
    { 408, 1008, -88},
    { 200, 784, -112},
    { 360, 552, -128},
    { 96, 1584, 264},
    { -16, 1576, 640},
    { 88, 1168, 184},
    { 176, 704, 24},
    { 280, 504, 8},
    { 352, 600, -32},
    { 376, 656, 128},
    { 352, 896, 144},
    { 168, 1120, 136},
    { 120, 1208, 232},
    { 168, 1168, 144},
    { 120, 1320, 224},
    { -8, 1056, 160},
    { 152, 1088, 32},
    { 136, 832, 80},
    { 224, 680, 80},
    { 336, 440, -144},
    { 288, 544, -56},
    { 328, 776, 56},
    { 536, 1200, 80},
    { 400, 1264, 64},
    { 232, 744, -352},
    // 75 seconds
    { 96, 1208, -24},
    { 304, 1096, 592},
    { 48, 1216, 248},
    { 224, 1264, 352},
    { 112, 872, 272},
    { 104, 744, 112},
    { 208, 600, 40},
    { 328, 544, 88},
    { 344, 744, 128},
    { 208, 992, 176},
    { 112, 1152, 160},
    { -80, 1144, 176},
    { 32, 1152, 48},
    { -88, 1128, 280},
    { -144, 1304, 48},
    { -40, 1208, 8},
    { -40, 888, 8},
    { 64, 640, 0},
    { 24, 416, 8},
    { 160, 528, 96},
    { 336, 712, 96},
    { 376, 1328, -344},
    { 432, 1152, -32},
    { 448, 1568, 312},
    { 192, 1152, 136},
    // 76 seconds
    { 272, 2112, 328},
    { -360, 1128, 624},
    { -40, 944, 216},
    { -8, 984, 288},
    { 8, 648, 240},
    { 176, 504, 96},
    { 216, 400, 40},
    { 192, 656, 192},
    { 128, 1048, 184},
    { -8, 1040, 216},
    { -56, 1128, 184},
    { -216, 1176, 200},
    { -224, 1408, 344},
    { -232, 1272, 104},
    { -64, 1224, -48},
    { -80, 904, 32},
    { 64, 800, 0},
    { 168, 592, -56},
    { 216, 480, 24},
    { 296, 576, 0},
    { 200, 784, 112},
    { 320, 904, 64},
    { 368, 1024, 272},
    { 216, 1480, 104},
    { 72, 1288, 0},
    // 77 seconds
    { 232, 1344, 160},
    { -360, 1800, 400},
    { -24, 1496, 536},
    { 8, 1104, 56},
    { 192, 448, -48},
    { 264, 376, -24},
    { 272, 400, 0},
    { 312, 512, -16},
    { 368, 720, 144},
    { 272, 1152, 176},
    { 120, 1264, 168},
    { 136, 1160, 144},
    { 80, 1176, 88},
    { 80, 1048, 304},
    { 32, 1200, 144},
    { 32, 1040, 296},
    { 144, 920, 120},
    { 192, 864, 56},
    { 272, 520, 48},
    { 256, 656, -32},
    { 192, 664, 80},
    { 192, 1400, -104},
    { 192, 440, -192},
    { 336, 1208, 152},
    { 272, 1176, 192},
    // 78 seconds
    { 328, 984, 184},
    { 104, 840, 544},
    { 24, 1520, 512},
    { 72, 1000, 736},
    { 32, 1032, 432},
    { 72, 792, 328},
    { 104, 520, 112},
    { 120, 536, 184},
    { 168, 720, 184},
    { 208, 720, 280},
    { 176, 984, 344},
    { 88, 1104, 352},
    { -16, 1184, 160},
    { -120, 1152, 432},
    { -160, 1064, 288},
    { -128, 1304, 168},
    { -80, 1040, 240},
    { -24, 816, 24},
    { 112, 616, -88},
    { 160, 552, -64},
    { 96, 776, 80},
    { 152, 1120, 128},
    { 272, 1064, 136},
    { 344, 1160, 24},
    { 352, 912, 88},
    // 79 seconds
    { 80, 1072, 328},
    { 216, 1536, 336},
    { -256, 1448, 464},
    { 24, 1168, 488},
    { -104, 976, 344},
    { -8, 904, 224},
    { 152, 408, 144},
    { 160, 456, 24},
    { 264, 680, 184},
    { 192, 848, 272},
    { 144, 1008, 280},
    { 40, 1184, 248},
    { -32, 976, 248},
    { -120, 1160, 112},
    { -184, 1112, 360},
    { -248, 1288, 216},
    { -96, 1192, 112},
    { -56, 896, 88},
    { 96, 736, -32},
    { 192, 624, 72},
    { 264, 624, 40},
    { 232, 912, 112},
    { 200, 1056, 144},
    { 256, 1064, 144},
    { 304, 976, 152},
    // 80 seconds
    { 184, 1760, -24},
    { 128, 960, -48},
    { 88, 1584, 336},
    { -376, 1440, 512},
    { -128, 904, 200},
    { 128, 768, 296},
    { -72, 448, 40},
    { 160, 752, 208},
    { 304, 760, 120},
    { 208, 872, 200},
    { 232, 896, 240},
    { 112, 952, 224},
    { -64, 1104, 272},
    { -56, 1048, 240},
    { -80, 1376, 328},
    { -64, 1152, 488},
    { -232, 1512, 88},
    { -216, 960, 208},
    { -32, 736, -72},
    { 152, 600, -40},
    { 216, 400, 40},
    { 304, 672, 16},
    { 272, 872, 120},
    { 304, 816, 48},
    { 368, 1392, -176},
    // 81 seconds
    { 304, 1176, 96},
    { 192, 1056, 184},
    { 376, 1240, 152},
    { 112, 1232, 472},
    { -208, 1192, 160},
    { -232, 872, 352},
    { -32, 928, 232},
    { 56, 728, -80},
    { 152, 568, 32},
    { 160, 664, 24},
    { 208, 704, 48},
    { 224, 832, -32},
    { 232, 952, 24},
    { 176, 1088, 40},
    { 24, 1072, 152},
    { -136, 1264, 248},
    { -176, 1336, 344},
    { -264, 1216, 144},
    { -160, 1048, 144},
    { -80, 1000, -16},
    { 40, 816, -96},
    { 184, 584, -72},
    { 240, 680, -40},
    { 288, 760, 88},
    { 304, 944, 88},
    // 82 seconds
    { 304, 1088, -32},
    { 360, 1120, 296},
    { 360, 1008, 240},
    { 344, 1312, 304},
    { -432, 1688, 56},
    { -168, 1448, 232},
    { 64, 1088, 120},
    { 144, 672, -8},
    { 72, 216, -384},
    { 128, 568, 160},
    { 160, 616, 256},
    { 160, 752, 72},
    { 184, 944, 256},
    { 32, 1104, 184},
    { -16, 1144, 112},
    { -8, 1232, 128},
    { -64, 1136, 312},
    { -88, 1360, 8},
    { -72, 1112, 8},
    { 16, 904, -176},
    { 184, 616, -128},
    { 312, 496, -120},
    { 312, 680, -24},
    { 264, 776, 88},
    { 160, 896, 144},
    // 83 seconds
    { 272, 1032, 152},
    { 264, 1144, 160},
    { 96, 688, 112},
    { -64, 1792, 376},
    { -168, 1328, 496},
    { 24, 1000, 256},
    { 24, 632, 96},
    { 40, 632, 216},
    { 48, 840, 40},
    { 216, 520, 344},
    { 136, 848, 144},
    { 152, 880, 280},
    { 128, 1080, 272},
    { 8, 1248, 376},
    { -16, 1184, 248},
    { -152, 1096, 416},
    { -64, 1104, 320},
    { -120, 1032, 248},
    { -120, 1168, 80},
    { 72, 792, -48},
    { 144, 496, -88},
    { 112, 584, -8},
    { 160, 592, 184},
    { 120, 920, 184},
    { 168, 976, 280},
    // 84 seconds
    { 304, 1416, 376},
    { 88, 928, 24},
    { 248, 1176, 560},
    { 56, 1480, 720},
    { 8, 1384, 944},
    { -48, 1728, 216},
    { -96, 752, 168},
    { 40, 600, 328},
    { 232, 400, 304},
    { 152, 680, 280},
    { 184, 600, 304},
    { 128, 848, 336},
    { 112, 1048, 360},
    { -88, 1128, 352},
    { -64, 1096, 264},
    { -160, 1240, 368},
    { -144, 784, 512},
    { -120, 1384, 544},
    { -232, 1168, -120},
    { 0, 744, 360},
    { 120, 656, 128},
    { 136, 528, 288},
    { 136, 712, 288},
    { 184, 896, 328},
    { 208, 984, 312},
    // 85 seconds
    { 136, 984, 496},
    { 120, 1248, 568},
    { 328, 1336, 520},
    { 96, 1312, 768},
    { 56, 960, 720},
    { -40, 1032, 360},
    { 136, 720, 624},
    { 40, 616, 424},
    { 160, 608, 280},
    { 208, 576, 280},
    { 200, 584, 304},
    { 184, 800, 320},
    { 160, 880, 392},
    { -48, 848, 400},
    { -248, 1120, 808},
    { -64, 1816, 544},
    { -176, 1104, 896},
    { -64, 1072, 632},
    { -72, 1000, 648},
    { -8, 520, 448},
    { 40, 448, 192},
    { 112, 288, 200},
    { 216, 400, 232},
    { 184, 656, 344},
    { 24, 656, 376},
    // 86 seconds
    { 240, 1352, 752},
    { 80, 1408, 728},
    { 216, 1328, 760},
    { -232, 1512, 760},
    { 0, 1408, 480},
    { 64, 760, 448},
    { -104, 832, 512},
    { 112, 736, 312},
    { 248, 536, 120},
    { 248, 408, 160},
    { 232, 640, 264},
    { 280, 824, 288},
    { 208, 992, 440},
    { -8, 1288, 456},
    { -120, 1264, 224},
    { -96, 1344, 568},
    { -88, 1120, 560},
    { 32, 1264, 120},
    { 152, 856, 96},
    { 176, 640, 24},
    { 320, 496, 72},
    { 568, 592, 112},
    { 416, 928, 192},
    { 208, 912, 272},
    { 176, 1152, 104},
    // 87 seconds
    { 160, 1208, 168},
    { -176, 1264, 128},
    { 136, 1400, 296},
    { -288, 1600, 728},
    { 112, 1832, 256},
    { 120, 560, 600},
    { 24, 632, 72},
    { 168, 344, -40},
    { 328, 456, 32},
    { 208, 696, 0},
    { 280, 960, 152},
    { 216, 1096, 128},
    { 88, 1144, 144},
    { 56, 1104, 80},
    { -40, 1248, 208},
    { -80, 1192, 376},
    { -120, 1376, 136},
    { -80, 984, 208},
    { -8, 704, 168},
    { 224, 520, 8},
    { 208, 528, -80},
    { 192, 736, 8},
    { 112, 1040, -16},
    { 48, 1336, -56},
    { 80, 1016, -40},
    // 88 seconds
    { 104, 1416, 88},
    { 304, 1272, 248},
    { 288, 1648, 376},
    { 120, 920, 280},
    { 168, 360, 312},
    { -16, 728, 248},
    { 40, 768, 112},
    { 200, 520, -264},
    { 288, 416, 56},
    { 304, 648, 208},
    { 248, 1024, 232},
    { 192, 1104, 360},
    { 112, 1336, 352},
    { 152, 1280, 256},
    { 56, 1184, 416},
    { -344, 1360, 144},
    { -16, 1080, 112},
    { -72, 744, 160},
    { 168, 632, 8},
    { 192, 656, 8},
    { 176, 608, 56},
    { 152, 744, 192},
    { 200, 1112, 32},
    { 280, 904, 568},
    { 440, 1152, 224},
    // 89 seconds
    { 216, 1152, 480},
    { 584, 1416, 440},
    { 176, 1552, 432},
    { 232, 1136, 496},
    { 32, 880, 152},
    { -40, 464, 376},
    { 64, 768, 136},
    { 144, 600, 232},
    { 264, 704, 248},
    { 272, 960, 264},
    { 136, 1096, 272},
    { 8, 1096, 184},
    { -120, 1000, 80},
    { -88, 960, 120},
    { -152, 1224, 320},
    { -216, 1440, 168},
    { -72, 1088, 96},
    { -72, 856, 104},
    { 72, 672, 24},
    { 128, 568, 8},
    { 120, 672, 144},
    { -64, 816, 240},
    { -152, 792, 448},
    { 0, 888, 296},
    { 152, 1464, 176},
    // 90 seconds
    { 120, 1008, 400},
    { 272, 1464, 512},
    { -296, 1856, 752},
    { -312, 1440, 608},
    { -224, 848, -48},
    { -80, 632, 280},
    { -32, 544, 384},
    { 64, 592, 456},
    { 8, 496, 496},
    { 120, 496, 576},
    { 72, 760, 480},
    { -8, 944, 496},
    { -192, 1096, 512},
    { -240, 984, 336},
    { -248, 1184, 560},
    { -344, 1216, 464},
    { -128, 1232, 392},
    { -96, 896, 184},
    { 40, 512, 272},
    { 152, 624, 48},
    { 184, 488, 224},
    { 168, 720, 240},
    { 144, 928, 344},
    { 104, 1088, 456},
    { 192, 1200, 488},
    // 91 seconds
    { -24, 960, 464},
    { 192, 1472, 552},
    { -280, 1632, 744},
    { -24, 1304, 544},
    { -32, 1112, 288},
    { -56, 560, -192},
    { 24, 600, 232},
    { 168, 608, 264},
    { 168, 624, 176},
    { 200, 856, 264},
    { 192, 984, 336},
    { 112, 1192, 344},
    { -64, 1240, 376},
    { -16, 1256, 336},
    { -120, 1072, 400},
    { -96, 1080, 280},
    { -104, 864, 280},
    { -56, 896, 184},
    { 24, 648, 88},
    { 120, 576, 24},
    { 136, 608, 80},
    { 176, 848, 88},
    { 120, 896, 200},
    { 224, 1064, 128},
    { 320, 1016, 152},
    // 92 seconds
    { 368, 1544, 0},
    { 304, 1320, 256},
    { 104, 1288, 512},
    { -168, 1264, 688},
    { -120, 1016, 728},
    { -32, 1488, 184},
    { -120, 552, 400},
    { 64, 864, 112},
    { 128, 664, 328},
    { 136, 720, 136},
    { 120, 768, 208},
    { 112, 984, 328},
    { 56, 1104, 328},
    { -96, 1184, 320},
    { -56, 1048, 264},
    { -112, 1104, 336},
    { -112, 1048, 264},
    { -96, 1136, 200},
    { -24, 912, 160},
    { 40, 712, 80},
    { 136, 568, 88},
    { 200, 664, 48},
    { 232, 712, 104},
    { 232, 816, 24},
    { 272, 1152, 152},
    // 93 seconds
    { 200, 920, -240},
    { 248, 1264, 192},
    { 144, 1304, 232},
    { 208, 1400, 320},
    { -264, 1592, 288},
    { -88, 912, 392},
    { -80, 1056, 400},
    { 0, 936, 528},
    { 16, 776, 296},
    { 152, 560, 96},
    { 176, 464, 120},
    { 192, 624, 168},
    { 176, 856, 176},
    { 136, 1016, 192},
    { -56, 1192, 216},
    { -96, 1152, 184},
    { -32, 1232, 272},
    { 40, 1384, 376},
    { 40, 1296, 136},
    { 48, 1040, 200},
    { 8, 840, 88},
    { 88, 648, 0},
    { 144, 616, -48},
    { 88, 672, -24},
    { 104, 768, 96},
    // 94 seconds
    { 112, 1128, 24},
    { 24, 872, -72},
    { 240, 1168, 80},
    { 240, 1296, 176},
    { 392, 1272, 208},
    { 392, 1968, 280},
    { -40, 1304, 320},
    { -8, 768, 208},
    { -64, 1096, 208},
    { -40, 984, 208},
    { 112, 656, 104},
    { 152, 544, 152},
    { 152, 696, 272},
    { 112, 912, 280},
    { 128, 928, 232},
    { 24, 1144, 240},
    { -64, 1032, 192},
    { 96, 1384, 376},
    { 136, 1352, 360},
    { 16, 1576, 152},
    { 56, 920, 208},
    { 64, 816, -56},
    { 176, 752, -152},
    { 216, 592, -56},
    { 208, 664, 16},
    // 95 seconds
    { 264, 624, -8},
    { 208, 736, 48},
    { 304, 920, 64},
    { 368, 1112, 200},
    { 384, 992, 104},
    { 576, 1208, 376},
    { 136, 1352, 456},
    { 88, 1360, 424},
    { 184, 1000, 520},
    { 200, 832, 8},
    { 264, 536, 80},
    { 304, 616, -96},
    { 224, 632, -80},
    { 88, 840, -32},
    { 312, 928, 8},
    { 488, 752, 168},
    { 504, 952, 216},
    { 352, 1032, 144},
    { 64, 1144, 232},
    { 48, 1144, 160},
    { -112, 1552, 40},
    { -72, 1128, 56},
    { -16, 1152, -104},
    { 120, 704, -280},
    { 232, 728, -224},
    // 96 seconds
    { 272, 512, -168},
    { 232, 864, -48},
    { 144, 752, -216},
    { 336, 1288, 320},
    { 792, 1088, 192},
    { 616, 720, -8},
    { 392, 712, -168},
    { 392, 1336, 48},
    { 8, 1528, 512},
    { 184, 1408, 288},
    { 248, 840, 136},
    { 192, 488, 88},
    { 208, 616, -64},
    { 304, 496, 40},
    { 352, 584, 64},
    { 424, 888, 120},
    { 384, 1040, 272},
    { 296, 1208, 88},
    { 144, 1248, 208},
    { 24, 1160, -72},
    { 88, 1032, 272},
    { -24, 1384, 160},
    { -16, 1200, 240},
    { -8, 1128, 80},
    { 56, 888, 8},
    // 97 seconds
    { 184, 512, 16},
    { 264, 544, -40},
    { 288, 592, 16},
    { 312, 680, 72},
    { 360, 928, 232},
    { 256, 736, 232},
    { 336, 672, -112},
    { 288, 1032, 504},
    { 176, 1960, 288},
    { -8, 1328, 552},
    { -208, 704, 208},
    { -168, 1080, 328},
    { 0, 736, 304},
    { 104, 464, 32},
    { 200, 512, 136},
    { 232, 664, 112},
    { 216, 816, 152},
    { 280, 872, 184},
    { 136, 1168, 120},
    { 16, 1144, 168},
    { -144, 1368, 512},
    { -120, 1360, 312},
    { -216, 1112, 448},
    { -64, 1008, 256},
    { 104, 768, 152},
    // 98 seconds
    { 272, 648, 72},
    { 272, 608, 64},
    { 240, 672, 80},
    { 232, 768, 136},
    { 296, 1096, 296},
    { 304, 1024, 200},
    { 312, 1288, 280},
    { 272, 1056, 376},
    { 320, 1424, 280},
    { -48, 1488, 320},
    { 8, 1168, 448},
    { -96, 1208, 424},
    { -8, 728, 304},
    { 144, 600, 144},
    { 208, 480, 168},
    { 144, 632, 152},
    { 120, 880, 240},
    { 16, 984, 320},
    { -80, 1248, 280},
    { -192, 1176, 256},
    { -104, 1416, 352},
    { -256, 1128, 408},
    { -152, 1176, 64},
    { -104, 792, 128},
    { -72, 776, 56},
    // 99 seconds
    { 72, 648, 16},
    { 152, 656, 24},
    { 248, 848, -56},
    { 160, 824, 272},
    { 40, 712, -96},
    { 168, 960, 120},
    { 208, 1376, 16},
    { 72, 1168, 16},
    { 72, 1656, 272},
    { -416, 1600, 600},
    { -128, 1448, 360},
    { -16, 888, 328},
    { -32, 608, 232},
    { 112, 584, 48},
    { 200, 504, 32},
    { 208, 592, 128},
    { 200, 824, 144},
    { 152, 984, 216},
    { 112, 1040, 224},
    { -24, 1264, 160},
    { 16, 1048, 168},
    { 0, 1328, 272},
    { -128, 1248, 256},
    { -56, 1160, 144},
    { -8, 952, 128},
    // 100 seconds
    { 24, 800, 40},
    { 168, 544, 32},
    { 232, 568, 16},
    { 280, 560, 112},
    { 144, 584, 64},
    { 152, 960, 40},
    { 280, 1344, 232},
    { 392, 1408, 168},
    { 312, 1496, 176},
    { 40, 1024, -272},
    { -72, 1096, 544},
    { -64, 1168, 440},
    { -112, 896, 360},
    { -16, 816, 288},
    { 120, 568, 88},
    { 192, 584, 152},
    { 176, 720, 160},
    { 200, 776, 200},
    { 224, 912, 272},
    { 144, 1176, 248},
    { 16, 1136, 240},
    { 96, 1336, 304},
    { -56, 1176, 432},
    { -32, 1264, 200},
    { 8, 968, 216},
    // 101 seconds
    { 0, 880, 144},
    { 112, 712, 72},
    { 200, 560, 48},
    { 240, 592, 64},
    { 272, 760, 48},
    { 288, 792, 216},
    { 304, 1120, -304},
    { 336, 1040, 192},
    { 256, 1296, 224},
    { 320, 1280, 144},
    { 232, 1656, -224},
    { 80, 888, 528},
    { 112, 1240, 592},
    { 24, 1152, 304},
    { 88, 1456, -48},
    { 160, 864, 168},
    { 248, 928, -136},
    { 152, 784, 8},
    { 88, 616, -448},
    { -40, 608, -496},
    { -2728, 1152, -168},
    { 168, 272, -656},
    { 0, 336, -696},
    { 160, 304, -928},
    { -128, 720, -1032},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:12:25 local
AccelRawData *activity_sample_walk_200_pbl_25671_11(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25671_11
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -336, -200, -744},
    { -200, -208, -904},
    { -336, -200, -840},
    { -488, -288, -864},
    { -456, -296, -888},
    { -416, -296, -872},
    { -344, -264, -896},
    { -368, -280, -880},
    { -368, -248, -880},
    { -368, -272, -944},
    { -408, -280, -928},
    { -384, -272, -856},
    { -408, -320, -840},
    { -376, -312, -816},
    { -368, -320, -816},
    { -400, -288, -816},
    { -344, -320, -816},
    { -312, -328, -832},
    { -296, -328, -816},
    { -320, -344, -792},
    { -296, -320, -800},
    { -296, -296, -824},
    { -272, -352, -808},
    { -304, -344, -816},
    { -304, -376, -736},
    // 1 seconds
    { -312, -392, -736},
    { -288, -400, -768},
    { -224, -384, -848},
    { -328, -368, -744},
    { -312, -392, -752},
    { -424, -336, -784},
    { -448, -496, -760},
    { -304, -296, -880},
    { -392, -152, -936},
    { -200, -808, -752},
    { -256, -368, -760},
    { -264, -408, -672},
    { -240, -392, -648},
    { -256, -344, -648},
    { -248, -424, -688},
    { -256, -384, -744},
    { -264, -384, -872},
    { -336, -432, -800},
    { -416, -144, -1120},
    { -456, -376, -808},
    { -624, -120, -776},
    { -688, 640, -904},
    { -808, 456, -448},
    { -824, 1272, -440},
    { -664, 984, -344},
    // 2 seconds
    { -528, 848, -120},
    { -336, 992, -184},
    { -168, 760, -216},
    { -224, 720, -240},
    { -408, 824, -336},
    { -528, 784, -248},
    { -632, 784, -200},
    { -1000, 744, -320},
    { -928, 728, -352},
    { -992, 520, -200},
    { -880, 456, -160},
    { -920, 400, -152},
    { -968, 360, -200},
    { -776, 352, -224},
    { -456, 248, -224},
    { -368, 304, -216},
    { -376, 408, -264},
    { -568, 496, -416},
    { -808, 616, -624},
    { -840, 728, -440},
    { -976, 816, -456},
    { -808, 664, -240},
    { -1424, 928, -368},
    { -2120, 648, 0},
    { -1624, 328, 104},
    // 3 seconds
    { -1120, 440, 0},
    { -496, 224, -24},
    { -192, 96, 16},
    { -248, 144, 40},
    { -432, 208, 64},
    { -840, 424, -56},
    { -928, 632, -104},
    { -1024, 624, -96},
    { -968, 752, -152},
    { -1080, 896, 16},
    { -616, 1112, -32},
    { -888, 1168, 136},
    { -600, 1032, 144},
    { -240, 720, 88},
    { -88, 600, 136},
    { -104, 536, 176},
    { -96, 624, 264},
    { -64, 752, 336},
    { -8, 832, 152},
    { -96, 1304, 656},
    { -256, 1192, 496},
    { -200, 1032, 736},
    { -384, 1248, 656},
    { -376, 904, 856},
    { -416, 1000, 368},
    // 4 seconds
    { -200, 248, 264},
    { -48, 560, 96},
    { 16, 440, 216},
    { 8, 712, 272},
    { -128, 800, 384},
    { -256, 1000, 464},
    { -424, 1232, 504},
    { -480, 1104, 432},
    { -408, 1176, 456},
    { -376, 992, 520},
    { -384, 1056, 368},
    { -312, 848, 264},
    { -112, 536, 152},
    { 40, 520, 56},
    { 120, 624, 216},
    { 80, 896, 336},
    { -80, 1344, 168},
    { 56, 1208, 608},
    { -272, 1368, 536},
    { -336, 1376, 624},
    { -656, 1432, 464},
    { -288, 408, 208},
    { -464, 744, 240},
    { -288, 544, 216},
    { -96, 384, 72},
    // 5 seconds
    { 16, 536, 232},
    { -208, 456, 280},
    { -632, 1168, -96},
    { -736, 864, 120},
    { -1008, 920, -456},
    { -824, 256, -192},
    { -1544, 16, -632},
    { -872, 504, -872},
    { -1792, 264, -80},
    { -920, 448, 160},
    { -856, 608, 256},
    { -944, 408, 808},
    { -368, 280, 1264},
    { -208, 1760, 512},
    { -24, 1216, 464},
    { 64, 2056, -104},
    { -320, 1616, -640},
    { -792, 1000, -528},
    { -1616, 1056, -696},
    { -2072, 648, -184},
    { -1576, 376, 120},
    { -1496, 144, 472},
    { -808, 576, 248},
    { -648, 560, 352},
    { -264, 568, 352},
    // 6 seconds
    { -704, 568, -208},
    { -840, 408, 208},
    { -1304, 456, 128},
    { -1208, 272, 48},
    { -944, 232, -48},
    { -752, 80, -280},
    { -1160, 304, -88},
    { -872, 680, -368},
    { -784, 688, -368},
    { -328, 696, -408},
    { 24, 344, -144},
    { 0, 456, -168},
    { -344, 704, 32},
    { -536, 1040, -88},
    { -360, 864, 64},
    { -424, 1440, -120},
    { -400, 680, -344},
    { -576, 808, 40},
    { -1248, 1264, -128},
    { -1392, 536, 152},
    { -1040, 888, -8},
    { -712, 456, -280},
    { -320, 304, -40},
    { -200, 560, -88},
    { -400, 416, 24},
    // 7 seconds
    { -592, 328, 48},
    { -880, 616, -88},
    { -1176, 608, -80},
    { -1048, 488, -56},
    { -1504, 584, -32},
    { -920, 440, -144},
    { -960, 648, -320},
    { -824, 544, -392},
    { -248, 224, -40},
    { -144, 320, -248},
    { -248, 440, -96},
    { -472, 744, -272},
    { -664, 616, -112},
    { -728, 896, -304},
    { -976, 760, -176},
    { -1048, 680, -48},
    { -1552, 1184, -368},
    { -1432, 1016, -152},
    { -1152, 232, -368},
    { -1024, 400, -16},
    { -352, 144, 88},
    { -256, -64, -264},
    { -312, 80, 240},
    { -728, 336, 24},
    { -944, 640, 64},
    // 8 seconds
    { -1016, 760, 80},
    { -1072, 688, 64},
    { -1064, 904, 40},
    { -1000, 552, 160},
    { -664, 680, -184},
    { -824, 552, -216},
    { -496, 296, -64},
    { -248, 304, -96},
    { -312, 320, -8},
    { -480, 504, -8},
    { -672, 744, -56},
    { -696, 856, -40},
    { -584, 800, 24},
    { -800, 968, -392},
    { -720, 672, -88},
    { -1248, 1328, -144},
    { -1624, 1160, 240},
    { -1480, 1216, -256},
    { -960, 296, 400},
    { -704, 560, 240},
    { -280, 376, 344},
    { -248, 232, 304},
    { -328, 512, 224},
    { -408, 536, 272},
    { -504, 840, 320},
    // 9 seconds
    { -640, 928, 352},
    { -592, 1072, 232},
    { -736, 1192, 400},
    { -536, 984, 256},
    { -504, 1048, 96},
    { -384, 776, 168},
    { -208, 736, 80},
    { -40, 584, 64},
    { 32, 600, 88},
    { 88, 624, 224},
    { 88, 568, 192},
    { 72, 1048, 304},
    { 152, 1072, 328},
    { 184, 1312, 432},
    { 120, 1224, 248},
    { 24, 800, 488},
    { -152, 1248, 704},
    { -128, 1192, 720},
    { -112, 1144, 648},
    { -80, 720, 344},
    { 88, 512, 224},
    { 192, 456, 248},
    { 168, 584, 304},
    { 152, 792, 352},
    { 24, 984, 464},
    // 10 seconds
    { -80, 1104, 488},
    { -80, 1064, 504},
    { -96, 1280, 592},
    { -208, 880, 688},
    { -96, 1248, 312},
    { -48, 840, 472},
    { 40, 784, 256},
    { 136, 664, 168},
    { 208, 560, 208},
    { 264, 632, 376},
    { 176, 768, 392},
    { 120, 904, 344},
    { 184, 1112, 488},
    { 456, 1304, 368},
    { 0, 1136, 824},
    { -248, 1488, 912},
    { -480, 1288, 688},
    { -240, 840, 504},
    { -168, 704, 512},
    { -80, 768, 256},
    { 24, 592, 208},
    { 80, 520, 240},
    { 88, 560, 272},
    { -8, 832, 440},
    { -192, 984, 520},
    // 11 seconds
    { -360, 1024, 464},
    { -528, 1032, 528},
    { -608, 1480, 424},
    { -640, 1000, 640},
    { -568, 1208, 232},
    { -376, 1016, 184},
    { -168, 600, 216},
    { -16, 512, 216},
    { 104, 456, 280},
    { 120, 744, 368},
    { 24, 912, 376},
    { 0, 968, 208},
    { 112, 1008, 344},
    { -160, 1552, 384},
    { -384, 1256, 328},
    { -544, 1696, 464},
    { -1008, 1376, 264},
    { -424, 1016, 360},
    { -520, 448, 464},
    { -184, 656, 64},
    { -32, 360, 96},
    { 8, 416, 152},
    { 0, 560, 144},
    { -48, 648, 240},
    { -104, 928, 376},
    // 12 seconds
    { -288, 1224, 352},
    { -424, 1096, 504},
    { -392, 1152, 240},
    { -392, 1312, 520},
    { -552, 1104, 296},
    { -400, 1160, 360},
    { -208, 856, 216},
    { 32, 720, 48},
    { 120, 496, 144},
    { 160, 568, 88},
    { 168, 768, 224},
    { 136, 888, -8},
    { -48, 1248, 768},
    { -16, 1376, -80},
    { -64, 824, 456},
    { -440, 1040, 384},
    { -632, 1592, 112},
    { -904, 1440, 376},
    { -576, 1248, 120},
    { -536, 360, 640},
    { -416, 928, 232},
    { -104, 800, 104},
    { 24, 288, 336},
    { 16, 632, 232},
    { 24, 608, 296},
    // 13 seconds
    { -56, 728, 424},
    { -136, 920, 376},
    { -416, 1040, 376},
    { -472, 1048, 296},
    { -808, 1224, 496},
    { -640, 1208, 160},
    { -680, 1040, 104},
    { -480, 768, 136},
    { -184, 688, -24},
    { -32, 512, 24},
    { -8, 536, 40},
    { 80, 552, 112},
    { 88, 648, 296},
    { -40, 1024, 264},
    { -408, 1296, 640},
    { -520, 1720, 360},
    { -608, 1464, 400},
    { -1024, 1296, 680},
    { -984, 936, 568},
    { -616, 944, 264},
    { -256, 600, 304},
    { -168, 568, 176},
    { -48, 488, 208},
    { -112, 440, 296},
    { -136, 560, 256},
    // 14 seconds
    { -328, 840, 456},
    { -584, 1256, 416},
    { -704, 1048, 368},
    { -616, 1016, 128},
    { -792, 848, 376},
    { -640, 968, 320},
    { -592, 1096, 168},
    { -400, 832, 176},
    { -80, 648, 48},
    { -16, 512, 192},
    { 40, 608, 256},
    { -128, 752, 328},
    { -40, 1168, 304},
    { 64, 1136, 304},
    { 112, 1024, -8},
    { 56, 328, 208},
    { -608, 1680, 1056},
    { -1560, 1896, 536},
    { -712, 736, 696},
    { -448, 736, 416},
    { -248, 608, 168},
    { -48, 536, 152},
    { -200, 448, 192},
    { -272, 800, 176},
    { -392, 784, 256},
    // 15 seconds
    { -584, 880, 352},
    { -656, 992, 208},
    { -624, 920, 240},
    { -808, 1080, 376},
    { -520, 1024, 144},
    { -560, 944, 192},
    { -488, 920, 144},
    { -256, 768, 48},
    { -64, 680, 0},
    { -120, 576, -192},
    { -328, 816, -40},
    { -168, 984, 8},
    { -208, 1240, -208},
    { -368, 904, 160},
    { -408, 1088, 592},
    { -408, 1368, 432},
    { -592, 1440, 360},
    { -576, 840, 376},
    { -568, 928, 304},
    { -392, 592, 408},
    { -208, 672, -8},
    { -96, 512, 88},
    { -72, 496, 80},
    { -208, 744, 128},
    { -312, 856, 136},
    // 16 seconds
    { -440, 1168, 264},
    { -528, 1040, 288},
    { -688, 1448, 360},
    { -520, 1056, 256},
    { -560, 1184, 88},
    { -464, 848, 120},
    { -328, 632, 136},
    { -104, 520, 56},
    { -96, 584, 64},
    { -56, 768, 192},
    { -152, 952, 136},
    { -216, 1072, 320},
    { -280, 1080, -704},
    { -144, 1192, 176},
    { -160, 1064, 424},
    { -392, 1344, 376},
    { -392, 1168, 472},
    { -600, 744, -320},
    { -192, 880, 568},
    { -72, 712, 168},
    { 56, 504, 32},
    { 48, 544, 176},
    { -96, 672, 88},
    { -184, 736, 272},
    { -296, 1016, 216},
    // 17 seconds
    { -392, 1096, 288},
    { -408, 1320, 328},
    { -384, 1168, 352},
    { -416, 1144, 248},
    { -272, 800, 280},
    { -184, 832, 216},
    { 72, 640, 96},
    { 184, 584, -16},
    { 152, 752, 160},
    { 120, 952, 168},
    { 208, 1272, 280},
    { 56, 1040, 232},
    { 8, 1152, 448},
    { 8, 1208, 424},
    { -56, 1704, 896},
    { -408, 2144, 712},
    { -128, 1040, 368},
    { 24, 520, 416},
    { 56, 656, 448},
    { 40, 536, 224},
    { 160, 400, 264},
    { 72, 528, 296},
    { 296, 1232, 352},
    { 432, 1200, 568},
    { 240, 1304, 320},
    // 18 seconds
    { 48, 1056, 328},
    { 48, 808, 216},
    { 8, 784, 416},
    { 8, 800, 448},
    { 24, 1192, 264},
    { 40, 904, 216},
    { 224, 728, 160},
    { 360, 488, 72},
    { 344, 536, 136},
    { 328, 664, 160},
    { 312, 752, 24},
    { 336, 696, -16},
    { 144, 1336, 280},
    { 96, 1400, 344},
    { -248, 1704, 408},
    { -568, 1224, 816},
    { -416, 1528, 440},
    { -64, 952, 512},
    { 64, 704, 216},
    { 184, 480, 64},
    { 240, 280, -8},
    { 232, 376, 152},
    { 216, 688, 216},
    { 168, 1016, 504},
    { 0, 1328, 408},
    // 19 seconds
    { -112, 1088, 528},
    { -24, 1224, 288},
    { -184, 1160, 552},
    { -224, 1168, 472},
    { -160, 1072, 256},
    { -64, 872, 200},
    { 48, 624, 128},
    { 176, 552, 80},
    { 224, 496, 144},
    { 168, 976, 432},
    { 216, 896, 336},
    { 176, 1576, -304},
    { 416, 664, 208},
    { 48, 1088, 552},
    { -96, 1696, 656},
    { -464, 1784, 576},
    { -304, 920, 168},
    { -248, 696, 352},
    { -144, 664, 176},
    { -136, 776, 136},
    { 128, 680, 64},
    { 272, 592, 208},
    { 448, 536, 296},
    { 392, 1032, 456},
    { -80, 1024, 352},
    // 20 seconds
    { -424, 952, 80},
    { -128, 1136, -312},
    { -208, 1024, 72},
    { -240, 1304, 128},
    { -128, 1088, 336},
    { -32, 1056, 208},
    { 56, 920, 192},
    { 344, 96, 104},
    { 208, 416, 136},
    { 168, 824, 248},
    { 136, 1000, 336},
    { 104, 1712, 400},
    { -80, 1128, 600},
    { -8, 1152, 104},
    { -128, 864, 312},
    { -232, 1408, 352},
    { -664, 1568, 416},
    { -512, 1296, 432},
    { -280, 1032, 312},
    { -24, 688, 88},
    { 80, 488, 104},
    { 88, 480, 88},
    { 24, 536, 192},
    { -72, 784, 200},
    { -160, 1008, 320},
    // 21 seconds
    { -304, 1248, 400},
    { -368, 1216, 88},
    { -472, 1416, 328},
    { -128, 984, 280},
    { -168, 1208, 192},
    { -40, 960, 152},
    { -64, 704, 152},
    { 40, 656, -8},
    { 40, 792, 136},
    { 16, 688, -344},
    { -64, 752, 136},
    { -8, 992, 192},
    { 112, 1304, 120},
    { -96, 1064, 168},
    { -184, 1120, 504},
    { -144, 1416, 456},
    { -496, 1512, 624},
    { -328, 1136, 944},
    { -80, 896, 240},
    { 128, 800, 88},
    { 232, 312, 272},
    { 312, 448, 240},
    { 272, 528, 336},
    { 184, 752, 488},
    { 88, 1024, 584},
    // 22 seconds
    { -88, 1232, 600},
    { -176, 1144, 472},
    { -368, 1384, 552},
    { -384, 1056, 456},
    { -304, 1344, -40},
    { -320, 696, 408},
    { -216, 488, 232},
    { -88, 408, 136},
    { -8, 416, 72},
    { 0, 616, 232},
    { 88, 1008, 56},
    { 104, 1184, 208},
    { 224, 1440, 16},
    { -16, 1416, 296},
    { -72, 1096, 784},
    { -544, 1976, 584},
    { -568, 1488, 648},
    { -504, 1392, 8},
    { -248, 368, 288},
    { 8, 616, -24},
    { 144, 544, 152},
    { 216, 264, 376},
    { 152, 688, 312},
    { 24, 1000, 352},
    { -200, 1344, 432},
    // 23 seconds
    { -376, 1144, 336},
    { -264, 1072, 184},
    { -352, 824, 392},
    { -416, 1216, 576},
    { -296, 1376, -48},
    { -272, 920, 288},
    { -88, 632, 192},
    { 0, 632, 152},
    { 104, 296, 152},
    { 64, 776, 280},
    { 64, 320, 176},
    { -16, 976, 592},
    { -72, 1696, 576},
    { -72, 1440, 208},
    { 336, 1216, 208},
    { 40, 944, 176},
    { -176, 1224, -160},
    { -64, 1024, 88},
    { -144, 1032, -152},
    { 72, 752, -24},
    { 112, 552, -64},
    { 120, 544, -56},
    { 64, 680, -160},
    { 0, 752, -72},
    { -176, 1152, -208},
    // 24 seconds
    { -376, 1296, -208},
    { -512, 1520, -256},
    { -376, 1024, -112},
    { -176, 976, -240},
    { -152, 800, -104},
    { -16, 672, -48},
    { 152, 584, -120},
    { 168, 544, 168},
    { 160, 736, 48},
    { 128, 904, -40},
    { 184, 944, -96},
    { 376, 1440, 16},
    { 232, 1400, -24},
    { 80, 1464, -24},
    { -200, 1192, -168},
    { -384, 1184, 264},
    { -304, 1216, 192},
    { -224, 912, 128},
    { -64, 664, 184},
    { 24, 472, 120},
    { 40, 496, 128},
    { 40, 608, 128},
    { -72, 968, 184},
    { -160, 1160, 192},
    { -336, 1288, 160},
    // 25 seconds
    { -288, 1040, -16},
    { -336, 1240, 48},
    { -408, 1232, 48},
    { -272, 1160, -128},
    { -176, 920, -240},
    { -16, 536, -88},
    { 128, 424, -136},
    { 208, 528, -80},
    { 248, 704, -16},
    { -144, 1136, -192},
    { 168, 920, -112},
    { 16, 1400, 56},
    { -128, 1072, 160},
    { 24, 1528, -8},
    { -424, 1472, -184},
    { -416, 800, 416},
    { -320, 1200, -32},
    { -176, 776, 40},
    { 24, 648, 16},
    { 112, 520, -16},
    { 144, 520, 8},
    { 112, 680, 40},
    { 56, 992, 88},
    { -104, 1392, -8},
    { -248, 1232, 8},
    // 26 seconds
    { -184, 1144, -24},
    { -296, 1200, 24},
    { -216, 1184, 0},
    { -184, 1096, -112},
    { -136, 840, -56},
    { 16, 592, -128},
    { 64, 432, -224},
    { 120, 344, -80},
    { 120, 504, -64},
    { 96, 928, 128},
    { 32, 1472, 64},
    { -8, 1280, 104},
    { -128, 1352, 136},
    { 160, 1376, 216},
    { -160, 1928, 328},
    { -280, 1192, 560},
    { -216, 1056, 288},
    { -56, 720, 240},
    { -8, 616, 152},
    { 200, 584, 112},
    { 256, 576, 96},
    { 184, 688, 184},
    { 120, 848, 128},
    { -56, 1128, 168},
    { -256, 1128, 112},
    // 27 seconds
    { -264, 1272, 192},
    { -312, 968, 528},
    { -224, 1416, 200},
    { -136, 1128, 160},
    { -96, 712, 288},
    { 168, 600, 168},
    { 224, 536, 192},
    { 176, 544, 224},
    { 264, 640, 520},
    { 88, 1232, 336},
    { 112, 984, 688},
    { 96, 1400, 600},
    { 40, 1304, 448},
    { -80, 1328, 696},
    { -336, 1360, 944},
    { -248, 1096, 464},
    { 8, 576, 464},
    { -48, 776, 424},
    { 144, 656, 144},
    { 184, 496, 168},
    { 128, 480, 168},
    { 72, 712, 200},
    { -120, 960, 360},
    { -432, 1168, 392},
    { -320, 1328, 192},
    // 28 seconds
    { -432, 1224, 456},
    { -240, 1152, 288},
    { -224, 1072, 264},
    { -104, 848, 160},
    { 96, 576, 152},
    { 192, 432, 144},
    { 192, 568, 184},
    { 112, 792, 368},
    { 24, 1008, 416},
    { 48, 1120, 568},
    { -40, 1328, 152},
    { -272, 904, 584},
    { -32, 1280, 440},
    { -184, 1656, 456},
    { -520, 1296, 496},
    { -328, 1248, 288},
    { -192, 792, 336},
    { -64, 536, 296},
    { -8, 552, 264},
    { -16, 544, 192},
    { -56, 624, 192},
    { -184, 840, 200},
    { -352, 944, 328},
    { -376, 1120, 200},
    { -400, 1192, 472},
    // 29 seconds
    { -256, 1152, 128},
    { -208, 1168, 96},
    { -184, 888, 112},
    { -56, 736, 8},
    { 128, 528, -56},
    { 328, 568, 48},
    { 336, 960, 104},
    { 272, 1080, 360},
    { 160, 1240, 144},
    { 32, 1264, 376},
    { -72, 1176, 160},
    { -16, 1360, 432},
    { -288, 1416, 392},
    { -272, 1392, 560},
    { -288, 960, 208},
    { -8, 728, 0},
    { 88, 632, 120},
    { 88, 584, 0},
    { 128, 584, 72},
    { -56, 784, 192},
    { -328, 1144, 200},
    { -480, 1280, 272},
    { -480, 976, 216},
    { -512, 1152, 416},
    { -376, 1104, 168},
    // 30 seconds
    { -384, 1048, 64},
    { -248, 736, 80},
    { -168, 736, -32},
    { -80, 680, -16},
    { 0, 696, 128},
    { 32, 840, 104},
    { 56, 1024, 176},
    { 112, 1056, 112},
    { 256, 984, 144},
    { -24, 1288, 376},
    { -280, 1976, 624},
    { -144, 1552, 440},
    { -136, 1056, 264},
    { 32, 224, 104},
    { -8, 352, -48},
    { 24, 472, -72},
    { 72, 648, 168},
    { 48, 912, 296},
    { -104, 1144, 248},
    { -120, 1000, 296},
    { -160, 1112, 200},
    { -240, 1048, 272},
    { -280, 1528, 456},
    { -408, 1168, 264},
    { -376, 1160, 8},
    // 31 seconds
    { -288, 728, 128},
    { -64, 608, 0},
    { 88, 552, -104},
    { 96, 536, 0},
    { 64, 856, 136},
    { 56, 1208, -80},
    { 128, 712, 184},
    { 272, 1416, -24},
    { 272, 1128, 96},
    { 288, 1032, 168},
    { 48, 1168, 192},
    { -184, 1176, 320},
    { -376, 1328, 432},
    { -168, 936, 160},
    { 64, 648, -40},
    { 168, 376, -96},
    { 112, 280, 40},
    { 152, 608, 80},
    { 120, 1008, 136},
    { 8, 1368, 152},
    { -96, 1264, 304},
    { 0, 1216, 80},
    { -32, 1184, 288},
    { -72, 1064, 152},
    { -72, 1128, 136},
    // 32 seconds
    { -40, 888, 168},
    { 24, 776, 32},
    { 104, 568, 32},
    { 152, 400, 56},
    { 184, 488, 160},
    { -32, 512, -232},
    { -72, 888, -16},
    { -144, 1632, 24},
    { -136, 1640, 88},
    { -112, 1696, 232},
    { -472, 1448, 80},
    { -192, 1136, 152},
    { -96, 832, 248},
    { -152, 744, 208},
    { -144, 824, 96},
    { 32, 640, 88},
    { 80, 536, 160},
    { 24, 704, 192},
    { -88, 792, 296},
    { -384, 984, 448},
    { -472, 1072, 248},
    { -368, 1056, 216},
    { -472, 1264, 504},
    { -408, 1424, 192},
    { -288, 1288, 8},
    // 33 seconds
    { -208, 984, 16},
    { 72, 648, 56},
    { 104, 520, -40},
    { 120, 616, 32},
    { 96, 688, -16},
    { -64, 1272, -144},
    { 8, 640, -56},
    { 40, 1128, -40},
    { -88, 1192, 176},
    { 112, 1576, 80},
    { -312, 1536, 472},
    { -192, 1112, 128},
    { -120, 872, 144},
    { -72, 544, 224},
    { 48, 400, 16},
    { 176, 576, -48},
    { 144, 536, -8},
    { 72, 856, 56},
    { 64, 920, 104},
    { -8, 1128, 128},
    { -152, 1272, 72},
    { -136, 1088, 96},
    { -192, 1224, 56},
    { -208, 1104, 24},
    { -184, 1056, -40},
    // 34 seconds
    { -120, 904, -120},
    { 0, 440, -96},
    { 0, 424, 48},
    { 24, 544, 32},
    { 72, 808, 80},
    { 24, 1000, 240},
    { -40, 992, 312},
    { -96, 1136, 600},
    { -288, 1256, 512},
    { -152, 1376, 696},
    { -600, 1232, 552},
    { -504, 1192, 584},
    { -296, 880, 584},
    { -232, 856, 480},
    { -96, 632, 288},
    { 40, 496, 256},
    { 24, 552, 280},
    { -32, 720, 360},
    { -128, 840, 408},
    { -256, 1016, 504},
    { -520, 1120, 568},
    { -440, 976, 544},
    { -584, 1256, 560},
    { -408, 976, 192},
    { -320, 848, 160},
    // 35 seconds
    { -248, 816, 120},
    { -128, 712, 128},
    { 0, 624, 16},
    { 24, 640, 72},
    { 64, 712, 128},
    { -40, 656, 104},
    { 56, 776, 648},
    { 120, 1152, 232},
    { 80, 1504, 264},
    { 128, 1656, 328},
    { -384, 1416, 560},
    { -232, 960, 440},
    { -64, 856, 112},
    { -80, 656, 320},
    { 40, 480, 48},
    { 120, 480, 80},
    { 120, 624, 96},
    { 80, 904, 280},
    { -40, 1088, 248},
    { -104, 1152, 296},
    { -176, 960, 192},
    { -224, 1168, 432},
    { -232, 1344, 280},
    { -184, 1064, 240},
    { -56, 1080, 120},
    // 36 seconds
    { -16, 832, 72},
    { 88, 560, 120},
    { 184, 520, 152},
    { 312, 560, 304},
    { 336, 672, 232},
    { 64, 888, 200},
    { 32, 768, 376},
    { -8, 1072, 688},
    { -120, 1624, 688},
    { 136, 1536, 888},
    { -240, 1584, 824},
    { -424, 1008, 1056},
    { -320, 1200, 600},
    { -152, 624, 624},
    { 0, 608, 376},
    { 160, 384, 256},
    { 192, 392, 312},
    { 152, 544, 432},
    { 88, 760, 480},
    { -72, 992, 608},
    { -208, 1088, 672},
    { -200, 1032, 552},
    { -168, 1336, 704},
    { -272, 792, 672},
    { -72, 1160, 312},
    // 37 seconds
    { -184, 920, 352},
    { -96, 736, 296},
    { 0, 672, 184},
    { -8, 936, 40},
    { -152, 1392, 16},
    { -152, 1224, 128},
    { 128, 688, 136},
    { 536, 1224, 304},
    { 256, 1232, 216},
    { 504, 480, 896},
    { 368, 1376, 672},
    { 200, 1304, 800},
    { 0, 1040, 256},
    { 64, 528, 416},
    { 0, 760, 48},
    { 72, 584, 88},
    { 120, 536, 32},
    { 192, 728, 120},
    { 200, 888, 296},
    { -24, 1368, 432},
    { -8, 1248, 320},
    { 72, 1032, 72},
    { 48, 1064, 216},
    { 16, 1048, 216},
    { 24, 1136, 128},
    // 38 seconds
    { 48, 1016, 160},
    { 80, 792, 104},
    { 200, 584, 16},
    { 232, 584, 64},
    { 272, 688, 24},
    { 240, 728, 168},
    { 312, 848, 144},
    { 376, 1112, 288},
    { 312, 1304, 128},
    { 304, 920, 760},
    { 448, 2088, 416},
    { 128, 1088, 584},
    { 88, 1032, 248},
    { 264, 872, 144},
    { 96, 288, 376},
    { 160, 808, 320},
    { 144, 560, 168},
    { 248, 568, 160},
    { 248, 592, 248},
    { 280, 784, 328},
    { 224, 1064, 440},
    { 40, 1208, 384},
    { 104, 1216, 248},
    { 24, 1160, 352},
    { 96, 1064, 208},
    // 39 seconds
    { 64, 1120, 272},
    { 96, 992, 192},
    { 120, 776, 80},
    { 192, 632, 32},
    { 280, 552, -80},
    { 264, 632, 64},
    { 288, 1152, 160},
    { 288, 1096, -32},
    { 296, 1256, 320},
    { 104, 1712, 0},
    { 400, 1584, 96},
    { -56, 912, -88},
    { -88, 1160, 176},
    { -112, 1576, -208},
    { -32, 792, 400},
    { 112, 672, 0},
    { 208, 416, -72},
    { 264, 400, -88},
    { 280, 520, 48},
    { 280, 968, 176},
    { 224, 1224, 160},
    { 56, 1128, 160},
    { -40, 1112, 96},
    { -64, 1208, 192},
    { -72, 1304, 192},
    // 40 seconds
    { -176, 1168, 112},
    { -64, 1112, 96},
    { 8, 872, 48},
    { 128, 648, 8},
    { 192, 488, 24},
    { 312, 528, 40},
    { 272, 696, 72},
    { 168, 648, 56},
    { 288, 1248, 184},
    { 160, 1336, 248},
    { 48, 936, 112},
    { 16, 1744, 72},
    { -432, 1472, 608},
    { -216, 1448, 392},
    { -224, 840, 368},
    { -8, 544, 256},
    { 96, 440, 128},
    { 128, 440, 176},
    { 144, 664, 56},
    { -48, 1080, 104},
    { -96, 1152, 280},
    { -184, 1184, 240},
    { -80, 1024, 176},
    { -168, 1312, 328},
    { -184, 1064, 128},
    // 41 seconds
    { -152, 1128, 8},
    { -144, 904, 24},
    { 8, 736, 48},
    { 144, 568, -72},
    { 168, 528, 16},
    { 224, 696, 144},
    { 304, 712, 392},
    { 184, 760, -136},
    { 184, 1576, 176},
    { -104, 1312, 504},
    { -184, 1560, 440},
    { -584, 1576, 608},
    { -432, 952, 128},
    { -48, 832, 360},
    { -64, 856, 352},
    { 96, 728, 208},
    { 208, 608, 112},
    { 152, 560, 232},
    { 144, 680, 240},
    { 88, 960, 248},
    { -48, 1120, 360},
    { -232, 1232, 320},
    { -152, 1040, 256},
    { -232, 1264, 328},
    { -288, 1096, 312},
    // 42 seconds
    { -160, 1224, 88},
    { -184, 944, 104},
    { -104, 728, 88},
    { 8, 488, 88},
    { 88, 448, 48},
    { 184, 384, 120},
    { 304, 608, 432},
    { 72, 1168, -136},
    { 24, 1384, 24},
    { 16, 1472, 144},
    { 40, 1248, 384},
    { -24, 1464, 136},
    { -232, 1096, 520},
    { -368, 1232, 504},
    { -184, 1088, 440},
    { -32, 624, 352},
    { 32, 536, 152},
    { 128, 456, 160},
    { 96, 480, 216},
    { 72, 776, 264},
    { -40, 1096, 336},
    { -248, 1144, 424},
    { -216, 976, 248},
    { -296, 1312, 304},
    { -288, 1072, 368},
    // 43 seconds
    { -200, 1216, 112},
    { -144, 984, 96},
    { -120, 776, 96},
    { 24, 664, -120},
    { 80, 576, -88},
    { 80, 728, -8},
    { 24, 928, -72},
    { 168, 1064, 152},
    { 288, 912, -248},
    { 72, 1232, 88},
    { 64, 1096, 168},
    { 128, 1456, 184},
    { -320, 1496, 736},
    { -352, 1328, 568},
    { -256, 904, 424},
    { -80, 648, 472},
    { 56, 512, 248},
    { 128, 376, 144},
    { 136, 528, 184},
    { 64, 672, 304},
    { -56, 936, 464},
    { -152, 1344, 440},
    { -224, 1144, 440},
    { -160, 1072, 408},
    { -200, 1016, 632},
    // 44 seconds
    { -272, 1200, 328},
    { -176, 928, 328},
    { -152, 760, 288},
    { -24, 648, 232},
    { 96, 488, 48},
    { 56, 432, 256},
    { 24, 824, 24},
    { 72, 848, 368},
    { 56, 1136, 192},
    { 88, 992, 304},
    { -128, 1192, 424},
    { -16, 1536, 464},
    { -392, 1640, 848},
    { -272, 1384, 608},
    { -80, 904, 432},
    { 16, 608, 416},
    { 96, 424, 256},
    { 160, 352, 208},
    { 128, 488, 208},
    { 24, 760, 392},
    { 24, 936, 472},
    { -8, 1032, 512},
    { -168, 1240, 568},
    { -280, 1048, 480},
    { -264, 1272, 536},
    // 45 seconds
    { -312, 960, 472},
    { -288, 1120, 296},
    { -240, 960, 272},
    { -128, 720, 208},
    { 40, 584, 136},
    { 96, 504, 104},
    { 184, 648, 168},
    { 104, 1032, -104},
    { 48, 776, 240},
    { 216, 1288, 392},
    { 152, 1320, 392},
    { 200, 1680, 672},
    { -256, 1432, 880},
    { -216, 1416, 704},
    { -120, 1032, 616},
    { 16, 784, 424},
    { 144, 656, 272},
    { 232, 504, 168},
    { 208, 480, 152},
    { 152, 568, 224},
    { 96, 800, 304},
    { 32, 912, 376},
    { -144, 1096, 336},
    { -248, 1104, 416},
    { -184, 1400, 424},
    // 46 seconds
    { -248, 1208, 400},
    { -56, 1232, 96},
    { -56, 1000, 144},
    { -24, 848, 144},
    { 72, 648, 0},
    { 104, 608, 104},
    { 104, 576, 48},
    { 184, 848, -64},
    { 144, 696, 136},
    { 224, 1064, 184},
    { 232, 1184, 136},
    { 232, 1616, 552},
    { -216, 1568, 736},
    { -160, 1456, 496},
    { -136, 1088, 408},
    { -48, 816, 232},
    { 40, 512, 232},
    { 112, 544, 104},
    { 136, 576, 176},
    { 96, 776, 256},
    { 104, 936, 272},
    { 72, 1048, 368},
    { 8, 1104, 368},
    { -8, 1112, 256},
    { -152, 1256, 496},
    // 47 seconds
    { -208, 1208, 216},
    { -144, 1144, 232},
    { -160, 944, 264},
    { -24, 856, 56},
    { 152, 592, 8},
    { 192, 528, 40},
    { 248, 688, 112},
    { 344, 712, 112},
    { 192, 1096, 416},
    { 208, 1080, 256},
    { 168, 1400, 432},
    { 184, 1032, 512},
    { -16, 1344, 416},
    { -80, 992, 680},
    { -144, 1496, 432},
    { -32, 976, 688},
    { 0, 736, 256},
    { 136, 440, 248},
    { 224, 440, 56},
    { 200, 504, 296},
    { 200, 688, 352},
    { 96, 1032, 392},
    { -32, 1160, 496},
    { -80, 1168, 424},
    { -128, 1432, 520},
    // 48 seconds
    { -200, 1064, 288},
    { -56, 1064, 216},
    { -96, 888, 304},
    { -8, 832, 224},
    { 80, 472, 88},
    { 72, 504, 64},
    { 176, 776, 72},
    { 312, 904, 56},
    { 240, 704, 440},
    { 240, 1328, 168},
    { -8, 1352, 72},
    { 120, 1472, 360},
    { -112, 1504, 304},
    { 112, 1352, 336},
    { -16, 1048, 384},
    { 32, 672, 240},
    { 128, 496, 128},
    { 192, 504, 80},
    { 288, 592, 168},
    { 272, 800, 168},
    { 288, 920, 240},
    { 216, 1136, 224},
    { 88, 1200, 232},
    { 40, 1128, 176},
    { 0, 1240, 168},
    // 49 seconds
    { -120, 1040, 272},
    { -112, 1160, 128},
    { -48, 992, 176},
    { 16, 840, 72},
    { 136, 704, 16},
    { 216, 504, 8},
    { 264, 504, 144},
    { 304, 608, 136},
    { 80, 528, -56},
    { 240, 1040, 304},
    { 112, 1496, 296},
    { 168, 1360, 576},
    { -152, 1808, 656},
    { -336, 1240, 928},
    { -272, 1528, 496},
    { -72, 912, 592},
    { -16, 680, 352},
    { 184, 488, 112},
    { 272, 400, 0},
    { 248, 480, 168},
    { 280, 736, 272},
    { 136, 1088, 320},
    { -72, 1328, 368},
    { -112, 1176, 344},
    { -96, 1080, 224},
    // 50 seconds
    { -176, 1040, 336},
    { -208, 1088, 208},
    { -128, 904, 128},
    { -48, 776, 96},
    { 32, 584, 64},
    { 128, 576, -8},
    { 152, 664, 48},
    { 176, 808, 72},
    { 112, 1120, -144},
    { 192, 984, -16},
    { 120, 1536, 320},
    { 152, 1384, 448},
    { -40, 2048, 360},
    { -232, 864, 128},
    { -48, 584, 232},
    { -48, 848, 296},
    { 64, 720, 336},
    { 168, 560, 176},
    { 224, 584, 192},
    { 176, 856, 232},
    { 144, 1032, 280},
    { 80, 1032, 312},
    { -24, 1232, 240},
    { -152, 1080, 304},
    { -64, 1240, 304},
    // 51 seconds
    { -240, 1120, 328},
    { -120, 1184, 88},
    { -80, 872, 152},
    { -16, 696, 104},
    { 112, 600, -8},
    { 184, 576, -24},
    { 248, 656, 72},
    { 288, 1032, -56},
    { 224, 984, -32},
    { 256, 1376, 72},
    { 64, 1400, 320},
    { 336, 1320, 328},
    { 64, 1080, 488},
    { 192, 1112, 528},
    { 80, 768, 264},
    { 8, 920, 376},
    { 112, 792, 80},
    { 248, 496, 32},
    { 288, 456, 120},
    { 304, 696, 272},
    { 280, 848, 272},
    { 272, 1008, 320},
    { 136, 1128, 224},
    { 104, 1008, 88},
    { 24, 1248, 192},
    // 52 seconds
    { -72, 1120, 192},
    { -16, 1472, 32},
    { -48, 1112, 80},
    { -32, 1008, 8},
    { 168, 680, 8},
    { 240, 504, 48},
    { 264, 632, 40},
    { 272, 776, 72},
    { 208, 712, 64},
    { 272, 920, 208},
    { 176, 1296, 288},
    { 168, 936, 400},
    { 200, 1704, 336},
    { -208, 1224, 480},
    { -72, 1224, 160},
    { -72, 1160, 384},
    { 16, 720, 280},
    { 192, 480, 168},
    { 176, 528, -144},
    { 208, 616, 464},
    { 272, 624, 272},
    { 160, 1072, 344},
    { 96, 1032, 384},
    { -104, 1168, 328},
    { -80, 1216, 224},
    // 53 seconds
    { -192, 1200, 528},
    { -200, 1304, 248},
    { -72, 1104, 152},
    { -32, 840, 112},
    { 112, 648, 64},
    { 168, 576, 64},
    { 160, 584, 128},
    { 176, 720, 200},
    { 184, 816, 144},
    { 288, 1016, 288},
    { 312, 1200, 216},
    { 336, 1480, 320},
    { 48, 896, 136},
    { 112, 1280, 576},
    { -152, 1648, 720},
    { -40, 1408, 592},
    { -16, 672, 584},
    { -176, 800, 384},
    { -32, 672, 216},
    { 144, 576, 168},
    { 96, 400, 88},
    { 216, 784, 240},
    { 136, 984, 368},
    { -56, 1216, 280},
    { -120, 1208, 344},
    // 54 seconds
    { -72, 1168, 296},
    { -136, 1000, 432},
    { -128, 1280, 216},
    { -112, 952, 344},
    { -32, 888, 136},
    { 64, 648, 80},
    { 152, 552, 88},
    { 176, 608, 224},
    { 216, 944, 152},
    { -24, 984, 80},
    { 128, 912, 224},
    { 296, 1248, 208},
    { 200, 1344, 168},
    { 48, 1456, 280},
    { -272, 1376, 568},
    { -120, 1480, 504},
    { -16, 1032, 488},
    { 24, 688, 240},
    { 144, 424, 216},
    { 192, 456, 96},
    { 200, 552, 264},
    { 168, 792, 232},
    { 88, 1024, 320},
    { -16, 1272, 360},
    { -184, 1184, 312},
    // 55 seconds
    { -112, 1472, 352},
    { -184, 1056, 376},
    { -160, 1296, 152},
    { -128, 832, 120},
    { -72, 816, 48},
    { 120, 584, -8},
    { 184, 584, 112},
    { 312, 1072, 168},
    { 128, 1360, -40},
    { 320, 1024, 152},
    { 544, 904, 32},
    { 432, 784, -232},
    { 624, 992, 408},
    { 80, 1512, 512},
    { 176, 1536, 576},
    { 304, 1032, 552},
    { 176, 776, 184},
    { 136, 520, 128},
    { 200, 552, 56},
    { 264, 640, 128},
    { 288, 776, 120},
    { 264, 920, 304},
    { 96, 1208, 368},
    { -88, 1272, 304},
    { -104, 1248, 408},
    // 56 seconds
    { -176, 1184, 520},
    { -184, 1232, 208},
    { -24, 880, 224},
    { 0, 864, 184},
    { 72, 680, 104},
    { 192, 568, 40},
    { 304, 864, 24},
    { 280, 896, -168},
    { 352, 928, 288},
    { 328, 1168, 240},
    { 96, 1312, 552},
    { 80, 1120, 472},
    { -40, 1248, 632},
    { -248, 1280, 664},
    { -32, 1024, 296},
    { -72, 904, 312},
    { 32, 744, 232},
    { 120, 592, 72},
    { 152, 640, 120},
    { 152, 744, 248},
    { 80, 920, 208},
    { -40, 1040, 328},
    { -128, 1200, 296},
    { -160, 1136, 248},
    { -216, 1264, 408},
    // 57 seconds
    { -176, 1192, 296},
    { -104, 1040, 216},
    { -72, 888, 280},
    { 88, 752, 64},
    { 152, 656, 176},
    { 160, 456, -96},
    { 264, 768, 232},
    { 96, 720, 224},
    { 184, 1368, 208},
    { 272, 1312, 456},
    { 0, 1592, 344},
    { 184, 1176, 536},
    { -352, 1536, 616},
    { 64, 1192, 528},
    { 24, 1072, 496},
    { 56, 576, 304},
    { 168, 448, 232},
    { 248, 560, 152},
    { 232, 552, 288},
    { 216, 792, 304},
    { 120, 992, 344},
    { 64, 1104, 416},
    { -152, 1136, 360},
    { -80, 1416, 560},
    { -216, 1120, 344},
    // 58 seconds
    { -40, 1192, 160},
    { -104, 936, 256},
    { 16, 736, 144},
    { 128, 624, 120},
    { 144, 560, 128},
    { 288, 824, 240},
    { 0, 712, -32},
    { 136, 608, 368},
    { 248, 1224, 216},
    { 312, 1168, 384},
    { 168, 1184, 152},
    { 88, 816, 248},
    { 40, 1264, 536},
    { 8, 1176, 480},
    { -56, 952, 376},
    { 80, 712, 240},
    { 184, 472, 136},
    { 216, 440, 152},
    { 208, 640, 208},
    { 200, 944, 280},
    { 120, 1080, 344},
    { 16, 1176, 264},
    { -80, 1248, 208},
    { -152, 1408, 424},
    { -272, 1376, 232},
    // 59 seconds
    { -152, 1032, 72},
    { -40, 808, 96},
    { 88, 640, 0},
    { 168, 536, -16},
    { 248, 648, 24},
    { 296, 776, 144},
    { 288, 1288, 72},
    { 264, 784, 64},
    { 264, 1256, 296},
    { 200, 1096, 512},
    { 16, 1544, 296},
    { -56, 1032, 208},
    { -40, 928, 208},
    { -48, 624, 176},
    { -88, 584, 168},
    { -152, 904, 184},
    { 16, 848, 200},
    { 80, 776, 208},
    { 8, 896, 216},
    { -80, 1008, 280},
    { -248, 1176, 208},
    { -184, 1152, 88},
    { -320, 1336, 264},
    { -368, 1512, 104},
    { -280, 1208, 96},
    // 60 seconds
    // elapsed: 1 minutes
    { -256, 864, 120},
    { -112, 496, 80},
    { -8, 480, -32},
    { 64, 496, 8},
    { 96, 736, 72},
    { 96, 744, 88},
    { 168, 896, 144},
    { 280, 1040, 240},
    { 192, 1280, 152},
    { -56, 1240, 512},
    { -640, 2208, 840},
    { -792, 1768, 800},
    { -408, 960, 480},
    { -104, 296, 152},
    { -56, 456, 104},
    { -56, 496, 184},
    { -88, 464, 184},
    { -32, 696, 248},
    { 16, 792, 400},
    { -32, 1016, 320},
    { -168, 1168, 296},
    { -136, 1040, 248},
    { -256, 1248, 248},
    { -264, 960, 392},
    { -296, 1368, 96},
    // 61 seconds
    { -192, 1024, 112},
    { -56, 752, 0},
    { 24, 592, -80},
    { 72, 568, -80},
    { 64, 704, 56},
    { -32, 1024, 32},
    { -72, 968, -264},
    { -8, 1008, 72},
    { -88, 1352, 104},
    { 8, 1208, 80},
    { -104, 1528, 264},
    { -344, 1328, 560},
    { -520, 1472, 176},
    { -248, 968, 504},
    { -32, 720, 136},
    { 104, 536, 64},
    { 64, 504, 48},
    { 72, 584, 168},
    { 56, 704, 120},
    { -56, 960, 192},
    { -272, 1208, 200},
    { -240, 1176, 168},
    { -320, 1400, 472},
    { -344, 1224, 112},
    { -176, 1240, 120},
    // 62 seconds
    { -176, 800, 152},
    { 16, 616, 96},
    { 152, 568, 88},
    { 192, 608, 104},
    { 216, 648, 152},
    { 248, 992, 96},
    { 88, 992, 8},
    { 152, 1112, 128},
    { 136, 1184, 208},
    { 136, 1040, 224},
    { 88, 1712, 264},
    { -88, 1256, 584},
    { -112, 1152, 256},
    { 16, 640, 400},
    { 24, 616, 192},
    { 240, 496, 80},
    { 296, 400, 224},
    { 264, 656, 232},
    { 128, 1048, 352},
    { 64, 1184, 368},
    { -88, 1160, 360},
    { -168, 1152, 72},
    { -448, 1528, 272},
    { -480, 1104, 48},
    { -96, 1152, 64},
    // 63 seconds
    { 80, 880, 136},
    { 256, 552, 64},
    { 232, 592, 24},
    { 200, 480, 80},
    { 192, 776, 120},
    { 248, 784, 80},
    { 216, 944, 216},
    { 160, 1160, 24},
    { -24, 1408, 296},
    { 232, 1640, 344},
    { -320, 1576, 448},
    { -304, 1240, 384},
    { -312, 1056, 280},
    { -24, 672, 480},
    { 16, 616, 232},
    { 184, 456, 160},
    { 160, 456, 128},
    { 112, 584, 208},
    { 88, 888, 288},
    { -72, 1176, 328},
    { -144, 1208, 240},
    { -184, 1080, 200},
    { -200, 1056, 200},
    { -256, 1248, 344},
    { -312, 1216, 400},
    // 64 seconds
    { -120, 1024, -120},
    { -120, 736, 0},
    { 16, 552, -32},
    { 136, 600, 168},
    { 184, 808, 0},
    { 56, 1008, -144},
    { 144, 544, 80},
    { 104, 1288, 184},
    { 88, 1552, 304},
    { 104, 848, 72},
    { 72, 1360, 160},
    { -544, 1912, 352},
    { -120, 1264, 648},
    { -16, 808, 280},
    { 56, 416, 192},
    { 112, 368, 120},
    { 72, 416, 160},
    { 112, 656, 240},
    { 24, 1016, 192},
    { -8, 1032, 264},
    { -160, 1152, 240},
    { -104, 1072, 8},
    { 24, 1304, 320},
    { -8, 1520, 32},
    { 40, 1320, -32},
    // 65 seconds
    { 80, 808, -48},
    { 80, 664, -192},
    { 96, 440, -104},
    { 128, 440, 32},
    { 232, 768, 24},
    { -40, 904, 96},
    { 288, 552, 264},
    { 416, 1096, 200},
    { 272, 1080, 272},
    { 392, 1384, 288},
    { 184, 1272, 440},
    { -48, 1640, 720},
    { 224, 1480, 496},
    { 208, 984, 312},
    { 184, 472, 104},
    { 272, 544, 136},
    { 304, 424, 176},
    { 360, 552, 240},
    { 392, 840, 248},
    { 336, 912, 376},
    { 144, 1016, 368},
    { 56, 1104, 248},
    { -112, 1248, 344},
    { 0, 1144, 432},
    { -80, 1368, 304},
    // 66 seconds
    { 80, 1024, 144},
    { 80, 784, 136},
    { 208, 720, 160},
    { 232, 528, 200},
    { 256, 528, 96},
    { 264, 760, 200},
    { 256, 808, 344},
    { 232, 1120, 344},
    { 248, 1144, 464},
    { 104, 1192, 352},
    { 160, 1192, 528},
    { 152, 1856, 520},
    { 112, 1384, 568},
    { 112, 1096, 272},
    { 72, 408, 424},
    { -48, 912, 184},
    { 88, 680, 200},
    { 264, 592, 48},
    { 224, 608, 88},
    { 232, 472, 224},
    { 136, 1088, 248},
    { 208, 1184, 328},
    { 64, 1312, 296},
    { -24, 1256, 312},
    { -80, 1136, 320},
    // 67 seconds
    { -112, 1200, 72},
    { -56, 952, 144},
    { -48, 848, 24},
    { 88, 648, 8},
    { 144, 576, -16},
    { 104, 608, 200},
    { 96, 704, 80},
    { 48, 896, 72},
    { 56, 968, 128},
    { 112, 1248, 80},
    { 80, 1344, 40},
    { 64, 1040, 144},
    { 152, 720, 224},
    { -8, 1712, 32},
    { -632, 2072, 520},
    { -496, 1872, 528},
    { -104, 1264, 280},
    { -8, 568, 288},
    { 152, 192, -208},
    { 208, 256, 64},
    { 176, 192, -56},
    { 152, 832, 88},
    { 40, 1000, 240},
    { 32, 1144, 360},
    { -128, 1136, 232},
    // 68 seconds
    { -72, 992, 96},
    { -128, 1024, 160},
    { -248, 1248, 232},
    { -232, 1176, 144},
    { -192, 1000, -8},
    { -104, 920, -88},
    { 24, 424, 72},
    { 104, 616, -72},
    { 120, 808, 16},
    { 16, 1000, 32},
    { 0, 1032, 120},
    { 40, 1200, 136},
    { -8, 1304, 88},
    { -112, 1120, 224},
    { 120, 1416, 88},
    { -296, 1408, 336},
    { -192, 1272, 504},
    { -120, 952, 360},
    { -32, 688, 136},
    { 24, 896, -8},
    { 120, 488, 272},
    { 184, 688, 128},
    { 136, 800, 272},
    { 96, 1024, 248},
    { -24, 1144, 168},
    // 69 seconds
    { -152, 1192, 376},
    { -160, 1112, 72},
    { -192, 1096, 320},
    { -192, 1088, 64},
    { -152, 1040, 120},
    { -56, 952, 40},
    { -24, 768, -40},
    { 120, 616, 80},
    { 200, 680, 72},
    { 184, 808, 112},
    { 192, 976, 80},
    { 128, 1112, 328},
    { 200, 1072, -56},
    { 56, 1408, 120},
    { 112, 992, 256},
    { -16, 1496, 528},
    { -216, 1040, 328},
    { -8, 1016, 296},
    { 24, 944, 368},
    { 88, 680, 296},
    { 104, 744, 88},
    { 184, 592, 184},
    { 144, 760, 320},
    { 184, 896, 200},
    { 32, 1072, 264},
    // 70 seconds
    { -104, 1128, 264},
    { -176, 1056, 240},
    { -192, 1104, 168},
    { -104, 1048, 360},
    { -192, 1320, 224},
    { -152, 1240, 232},
    { -96, 888, 136},
    { 16, 632, 24},
    { 96, 536, 32},
    { 112, 616, 168},
    { 328, 656, 72},
    { 120, 696, 488},
    { 120, 1152, 176},
    { 208, 1424, 416},
    { 136, 1192, 352},
    { 72, 1160, 480},
    { -144, 1136, 160},
    { -216, 1208, 392},
    { -184, 1128, 376},
    { -96, 760, 392},
    { -8, 648, 120},
    { 112, 504, 56},
    { 80, 344, 328},
    { 232, 568, 352},
    { 72, 1408, 344},
    // 71 seconds
    { -64, 856, 704},
    { -168, 1152, 592},
    { -168, 1128, 408},
    { -176, 1168, 816},
    { -312, 1232, 344},
    { -152, 1128, 504},
    { -16, 1024, 272},
    { 104, 712, 152},
    { 184, 576, 96},
    { 208, 344, 120},
    { 304, 392, 112},
    { 248, 848, 144},
    { 16, 1248, 696},
    { 32, 1336, 880},
    { 56, 960, 840},
    { 152, 912, 640},
    { -128, 968, 656},
    { -40, 616, 728},
    { -56, 1016, 664},
    { 48, 728, 360},
    { 88, 552, 288},
    { 168, 576, 192},
    { 192, 736, 256},
    { -48, 864, 432},
    { -40, 976, 352},
    // 72 seconds
    { -224, 1032, 408},
    { -176, 1064, 392},
    { -392, 1264, 216},
    { -432, 1136, 480},
    { -392, 1216, 184},
    { -288, 1104, 256},
    { -200, 960, 272},
    { -16, 648, 104},
    { 40, 632, 176},
    { 64, 800, 240},
    { 72, 736, 416},
    { 88, 1072, 80},
    { 128, 1000, 352},
    { 128, 1600, 16},
    { -80, 1328, 32},
    { 112, 1048, 240},
    { -136, 1232, 456},
    { -16, 848, 424},
    { 64, 704, 184},
    { -72, -120, 344},
    { 24, 880, -40},
    { 160, 592, 408},
    { 160, 896, 216},
    { 112, 776, 312},
    { 40, 960, 336},
    // 73 seconds
    { -80, 952, 392},
    { -208, 984, 384},
    { -320, 1464, 480},
    { -240, 1128, 424},
    { -272, 1256, 120},
    { -144, 920, 160},
    { -48, 768, 128},
    { 104, 680, 160},
    { 152, 672, 128},
    { 96, 736, 224},
    { 56, 872, 160},
    { 8, 976, 312},
    { -8, 1424, 112},
    { 176, 968, 480},
    { -24, 1224, 264},
    { -72, 1424, 552},
    { -528, 1448, 608},
    { -200, 880, 312},
    { -216, 416, 120},
    { -16, 472, 176},
    { 72, 584, 328},
    { -32, 616, 336},
    { 40, 800, 256},
    { -32, 1032, 384},
    { -96, 912, 432},
    // 74 seconds
    { -184, 1040, 456},
    { -328, 1032, 448},
    { -352, 1168, 376},
    { -304, 1136, 712},
    { -288, 1224, 360},
    { -224, 1048, 408},
    { -128, 792, 336},
    { -16, 640, 160},
    { 56, 536, 168},
    { 88, 464, 136},
    { -40, 568, 272},
    { -160, 816, 440},
    { -200, 1264, 200},
    { -32, 1088, 280},
    { -88, 1904, 248},
    { 232, 1240, 176},
    { -88, 1544, 96},
    { -240, 968, 152},
    { -216, 1304, 112},
    { -392, 952, 584},
    { -176, 800, 72},
    { -48, 680, 112},
    { -16, 560, 72},
    { -8, 664, 80},
    { -16, 760, 88},
    // 75 seconds
    { 8, 896, 64},
    { -120, 1200, 96},
    { -296, 1192, 104},
    { -248, 1216, -48},
    { -248, 1216, 168},
    { -256, 1200, -200},
    { -144, 1120, -80},
    { -80, 824, -88},
    { 8, 728, -144},
    { 88, 592, -8},
    { 144, 608, -72},
    { 80, 728, -80},
    { -96, 384, 88},
    { 64, 912, 96},
    { 104, 1512, 48},
    { 32, 1464, -48},
    { 120, 1344, 320},
    { -24, 1824, 280},
    { -272, 1448, 280},
    { -216, 1192, 272},
    { -216, 808, 264},
    { 16, 536, 80},
    { 80, 400, 48},
    { 80, 560, 184},
    { 64, 688, 272},
    // 76 seconds
    { 40, 1032, 272},
    { 24, 1128, 368},
    { -120, 1112, 392},
    { -80, 1168, 200},
    { -152, 1208, 448},
    { -168, 1160, 152},
    { -128, 1400, 48},
    { -128, 976, 272},
    { -72, 888, 8},
    { 40, 672, 8},
    { 88, 536, 168},
    { 216, 912, 136},
    { -40, 712, -168},
    { 64, 792, 112},
    { 368, 1120, 120},
    { 264, 984, 112},
    { 200, 1016, 312},
    { 224, 1224, 512},
    { -128, 1304, 312},
    { 88, 1008, 600},
    { 48, 856, 256},
    { 144, 672, 144},
    { 208, 576, 168},
    { 280, 616, 144},
    { 248, 752, 344},
    // 77 seconds
    { 160, 896, 448},
    { 128, 1032, 320},
    { 40, 1032, 392},
    { -8, 1224, 264},
    { -112, 1264, 280},
    { -200, 1144, 392},
    { -224, 1128, 256},
    { -24, 928, 192},
    { 32, 760, 96},
    { 136, 632, 80},
    { 192, 576, 112},
    { 280, 808, 160},
    { 216, 936, 216},
    { 208, 1072, 232},
    { 208, 920, -24},
    { 216, 1272, 400},
    { 104, 1952, 416},
    { 512, 1536, 560},
    { 104, 1016, -56},
    { 232, 376, 136},
    { -144, 840, 304},
    { 16, 616, 432},
    { 80, 680, 176},
    { 272, 560, 136},
    { 280, 680, 248},
    // 78 seconds
    { 296, 784, 240},
    { 304, 872, 288},
    { 208, 904, 192},
    { 24, 1048, 368},
    { -48, 1136, 200},
    { -72, 1272, 408},
    { -168, 1168, 408},
    { -56, 1160, 240},
    { 64, 1000, 200},
    { 128, 752, 64},
    { 192, 616, 56},
    { 280, 480, 24},
    { 280, 704, 16},
    { 16, 1040, 224},
    { -104, 1192, 264},
    { -16, 1232, 416},
    { -128, 1472, 0},
    { -72, 1088, 512},
    { -168, 1424, 760},
    { -416, 1424, 736},
    { -200, 1120, 464},
    { -136, 472, 232},
    { 32, 512, 320},
    { 48, 640, 136},
    { 96, 616, 360},
    // 79 seconds
    { 24, 712, 304},
    { 24, 1088, 256},
    { 64, 872, 424},
    { 8, 1024, 296},
    { -112, 984, 328},
    { -168, 1112, 280},
    { -208, 1184, 456},
    { -352, 1200, 176},
    { -200, 1024, 264},
    { -152, 848, 136},
    { -16, 704, 56},
    { 48, 488, 136},
    { 72, 448, 112},
    { 104, 744, 104},
    { 32, 864, 184},
    { 8, 1160, 184},
    { 128, 1136, 296},
    { 8, 1464, 128},
    { -128, 864, 544},
    { 200, 1968, 520},
    { -312, 1632, 936},
    { -280, 1296, 544},
    { -200, 784, 512},
    { -88, 600, 376},
    { -64, 664, 448},
    // 80 seconds
    { -72, 704, 320},
    { 72, 560, 320},
    { 104, 584, 304},
    { 120, 712, 360},
    { 136, 888, 416},
    { 16, 1024, 376},
    { -80, 1104, 384},
    { -128, 1152, 328},
    { -168, 1176, 576},
    { -176, 1128, 264},
    { -56, 1032, 216},
    { -56, 816, 208},
    { 8, 736, 104},
    { 56, 704, 40},
    { 72, 696, 128},
    { 48, 912, 88},
    { 24, 1176, 192},
    { 240, 1392, 232},
    { 120, 1864, -200},
    { 40, 928, 264},
    { 152, 1216, -40},
    { 416, 664, 312},
    { 272, 1024, 368},
    { 96, 648, 80},
    { 168, 616, 200},
    // 81 seconds
    { -104, 896, 424},
    { 24, 1032, 280},
    { 184, 656, 224},
    { 296, 624, 72},
    { 304, 632, 72},
    { 352, 912, 64},
    { 256, 1040, 72},
    { 128, 1152, 56},
    { -40, 1240, -8},
    { -48, 1024, 80},
    { -152, 1544, 160},
    { -144, 1552, -40},
    { -24, 1008, -8},
    { 24, 816, -80},
    { 72, 536, -32},
    { 136, 432, -56},
    { 192, 584, -32},
    { 216, 672, 24},
    { 184, 1232, 72},
    { 168, 1224, -112},
    { 288, 1112, -216},
    { 120, 1304, 200},
    { 80, 1616, -24},
    { -56, 1192, 184},
    { -56, 928, 144},
    // 82 seconds
    { 40, 936, 0},
    { -8, 752, 384},
    { -96, 648, 264},
    { 64, 688, 32},
    { 96, 448, 184},
    { 104, 680, 256},
    { 96, 952, 304},
    { -16, 1080, 432},
    { -224, 1256, 416},
    { -320, 1192, 344},
    { -464, 1296, 760},
    { -408, 1648, 232},
    { -360, 968, 552},
    { -192, 928, 352},
    { 0, 672, 232},
    { 88, 552, 168},
    { 136, 600, 168},
    { 240, 800, 464},
    { 72, 952, 24},
    { 120, 912, 248},
    { 152, 1048, 280},
    { 288, 1136, 96},
    { 104, 1008, 312},
    { 232, 1192, 288},
    { -200, 1200, 672},
    // 83 seconds
    { -152, 1288, 656},
    { -64, 976, 552},
    { -24, 656, 280},
    { 72, 384, 224},
    { 104, 360, 240},
    { 104, 464, 248},
    { 48, 624, 352},
    { 56, 800, 416},
    { -16, 1056, 320},
    { -80, 1152, 448},
    { -136, 1224, 488},
    { -192, 1640, 616},
    { -336, 1504, 296},
    { -320, 1136, 488},
    { -248, 928, 552},
    { -96, 848, 160},
    { 8, 608, 144},
    { 72, 512, 32},
    { -64, 848, 200},
    { 104, 528, 88},
    { 40, 664, 304},
    { 248, 1056, 96},
    { 368, 1104, 160},
    { 216, 1128, 552},
    { 224, 1584, 456},
    // 84 seconds
    { -16, 1480, 376},
    { 120, 1120, 800},
    { 224, 840, 312},
    { 104, 672, 232},
    { 152, 480, 144},
    { 240, 528, 176},
    { 256, 552, 256},
    { 256, 800, 320},
    { 72, 928, 352},
    { -328, 1288, 544},
    { -512, 1576, 368},
    { -144, 768, 344},
    { -72, 1112, 440},
    { -32, 1408, 288},
    { 40, 1176, 248},
    { 64, 984, 272},
    { 112, 736, 216},
    { 168, 808, 72},
    { 208, 624, 192},
    { 264, 832, -40},
    { 264, 872, -144},
    { 288, 784, 112},
    { 416, 1064, 200},
    { 256, 1352, 120},
    { 32, 872, 224},
    // 85 seconds
    { 32, 1504, 512},
    { -16, 1280, 576},
    { 64, 1224, 560},
    { 32, 920, 232},
    { 40, 656, 288},
    { 168, 584, 128},
    { 272, 552, 192},
    { 280, 632, 264},
    { 264, 824, 312},
    { 192, 1040, 408},
    { 56, 1160, 376},
    { 72, 1072, 416},
    { 104, 1352, 544},
    { -16, 1296, 168},
    { -88, 1160, 200},
    { -112, 992, 192},
    { -16, 840, 48},
    { 128, 568, 8},
    { 248, 520, 32},
    { 256, 616, 168},
    { 304, 888, 232},
    { 168, 984, 136},
    { 352, 1144, 328},
    { 360, 1472, 344},
    { 296, 952, 304},
    // 86 seconds
    { 440, 1136, 216},
    { 168, 856, 288},
    { 192, 976, 416},
    { 32, 1080, 552},
    { 72, 792, 472},
    { 104, 704, 104},
    { 264, 552, 232},
    { 240, 576, 136},
    { 256, 728, 232},
    { 224, 768, 296},
    { 104, 944, 376},
    { -24, 960, 472},
    { -16, 1336, 496},
    { -144, 1480, 280},
    { -216, 1512, 200},
    { -176, 1264, 224},
    { -96, 952, 168},
    { 96, 720, 64},
    { 144, 608, 104},
    { 168, 688, 104},
    { 192, 864, 280},
    { 240, 816, 256},
    { 272, 800, 344},
    { 192, 992, 480},
    { 40, 1152, 424},
    // 87 seconds
    { 80, 1496, 488},
    { -56, 1120, 344},
    { -384, 1128, 648},
    { -216, 1144, 608},
    { -16, 736, 312},
    { 104, 568, 176},
    { 200, 544, 136},
    { 240, 584, 192},
    { 232, 712, 360},
    { 264, 888, 424},
    { 192, 1112, 472},
    { 72, 1120, 528},
    { -80, 1032, 432},
    { -376, 1224, 832},
    { -736, 1392, 0},
    { -304, 1320, 456},
    { -304, 896, 528},
    { 32, 896, -32},
    { 96, 680, 112},
    { 160, 872, -200},
    { 120, 808, 80},
    { 176, 704, 120},
    { 96, 968, 152},
    { 200, 672, 192},
    { 128, 1256, 160},
    // 88 seconds
    { 120, 872, 664},
    { 232, 1136, 328},
    { 80, 912, 320},
    { 40, 944, 376},
    { -72, 1376, 728},
    { 144, 896, 208},
    { 144, 680, 128},
    { 240, 544, 24},
    { 264, 640, 64},
    { 272, 704, 152},
    { 248, 760, 232},
    { 88, 1000, 360},
    { -56, 1024, 376},
    { -200, 1240, 208},
    { -384, 1408, 568},
    { -584, 1496, 208},
    { -440, 1232, 152},
    { -256, 992, 88},
    { 32, 552, -208},
    { 128, 520, 80},
    { 184, 616, 80},
    { 192, 848, 96},
    { 144, 1080, 152},
    { 200, 1176, 192},
    { 40, 1416, -88},
    // 89 seconds
    { -344, 1512, 80},
    { -504, 1104, 400},
    { -216, 1728, -104},
    { -392, 640, 208},
    { 24, 616, -264},
    { 160, 1000, 72},
    { 472, 752, 424},
    { 440, 688, 280},
    { 344, 568, 224},
    { 384, 592, 224},
    { 376, 760, 184},
    { 248, 776, 240},
    { -48, 1032, 104},
    { -288, 1184, 24},
    { -320, 1512, 264},
    { -536, 1584, 168},
    { -416, 1592, -16},
    { -408, 1176, 80},
    { -216, 600, -88},
    { -112, 472, -208},
    { -144, 360, -176},
    { -160, 664, -208},
    { -32, 640, -176},
    { 56, 1232, -312},
    { 136, 976, -360},
    // 90 seconds
    { -32, 952, -216},
    { 80, 992, -296},
    { -200, 1376, -400},
    { -448, 1416, -344},
    { -72, 1216, -280},
    { -272, 928, 176},
    { -112, 744, -256},
    { 128, 392, -56},
    { 256, 592, 152},
    { 312, 872, 104},
    { 312, 1120, -40},
    { 264, 968, 40},
    { 104, 1008, -24},
    { -64, 968, -8},
    { -152, 984, -200},
    { -144, 1128, 40},
    { -232, 1296, -192},
    { -192, 1264, -160},
    { -80, 968, -96},
    { 8, 584, -72},
    { 88, 432, -64},
    { 128, 424, 72},
    { 128, 880, 120},
    { 120, 1064, 216},
    { 152, 952, 0},
    // 91 seconds
    { 192, 1232, 8},
    { 32, 1112, 344},
    { -96, 1360, 0},
    { -120, 944, 504},
    { -408, 1256, 0},
    { -208, 1056, 176},
    { -104, 1168, 152},
    { 96, 976, 112},
    { 192, 584, 240},
    { 256, 544, 64},
    { 232, 680, 136},
    { 232, 776, 184},
    { 192, 896, 200},
    { 160, 1016, 176},
    { 104, 1128, 192},
    { 168, 1160, 112},
    { 88, 1344, 248},
    { -120, 1192, 264},
    { -288, 1368, 120},
    { -120, 1080, 128},
    { -112, 832, 64},
    { -16, 560, 40},
    { 80, 480, 48},
    { 176, 616, 88},
    { 224, 872, -72},
    // 92 seconds
    { 256, 784, 64},
    { 272, 968, 112},
    { 264, 1160, 336},
    { 344, 1264, 224},
    { 384, 1784, 408},
    { 96, 1152, 536},
    { 24, 1096, 416},
    { 40, 960, 464},
    { 40, 816, 152},
    { 168, 560, 136},
    { 200, 584, 152},
    { 216, 688, 176},
    { 240, 760, 192},
    { 240, 880, 216},
    { 152, 1104, 272},
    { -8, 1152, 288},
    { 24, 1288, 320},
    { -32, 1128, 400},
    { -32, 1280, 216},
    { -32, 1032, 280},
    { -48, 920, 256},
    { 104, 752, 104},
    { 184, 592, 96},
    { 248, 568, 64},
    { 328, 888, 128},
    // 93 seconds
    { 288, 816, -48},
    { 288, 872, 152},
    { 336, 1304, 288},
    { 264, 1272, 128},
    { 360, 1368, 344},
    { 0, 1080, 656},
    { 80, 1152, 536},
    { 24, 1000, 728},
    { -48, 768, 352},
    { 120, 720, 128},
    { 224, 472, 120},
    { 216, 600, 176},
    { 208, 800, 264},
    { 208, 976, 352},
    { 184, 1112, 400},
    { 64, 1184, 416},
    { 24, 1288, 328},
    { -32, 1072, 552},
    { -24, 944, 272},
    { 24, 1008, 368},
    { -40, 880, 376},
    { 0, 960, 208},
    { 80, 768, 152},
    { 152, 576, 40},
    { 200, 904, 64},
    // 94 seconds
    { 216, 760, 224},
    { 264, 952, 96},
    { 472, 832, 192},
    { 224, 912, 408},
    { 56, 1040, 664},
    { -168, 1432, 744},
    { -8, 1432, 736},
    { 136, 1240, 672},
    { 200, 808, 456},
    { 240, 624, 272},
    { 304, 544, 192},
    { 352, 504, 224},
    { 304, 656, 288},
    { 312, 864, 256},
    { 288, 824, 392},
    { 152, 1056, 488},
    { -24, 1200, 432},
    { 0, 1400, 456},
    { -208, 1048, 568},
    { -104, 1176, 208},
    { -104, 824, 272},
    { -32, 656, 200},
    { 112, 632, 56},
    { 152, 600, 152},
    { 136, 680, 176},
    // 95 seconds
    { 224, 864, 296},
    { 152, 1184, 264},
    { 352, 1048, 120},
    { 312, 1296, 384},
    { 288, 1168, 192},
    { 272, 976, 232},
    { 96, 1336, 544},
    { 80, 984, 280},
    { -56, 760, 472},
    { -80, 1224, 640},
    { 56, 992, 376},
    { 144, 688, 312},
    { 144, 600, 216},
    { 120, 728, 152},
    { 144, 728, 240},
    { 64, 952, 224},
    { 48, 952, 256},
    { -104, 1152, 512},
    { -48, 1512, 448},
    { -152, 1280, 488},
    { -72, 1328, 192},
    { -64, 944, 280},
    { -48, 752, 216},
    { 56, 664, 64},
    { 144, 640, 120},
    // 96 seconds
    { 224, 728, 32},
    { 176, 672, 112},
    { 208, 1032, 192},
    { 264, 992, 64},
    { 272, 1032, 24},
    { 40, 896, -112},
    { 40, 1152, 480},
    { -232, 1504, 552},
    { -32, 1136, 608},
    { -16, 1040, 376},
    { 16, 816, 304},
    { 48, 616, 288},
    { 112, 632, 168},
    { 136, 624, 160},
    { 88, 736, 232},
    { 48, 904, 304},
    { 8, 1088, 352},
    { -8, 1408, 392},
    { -152, 1080, 200},
    { -144, 1224, 304},
    { -96, 968, 296},
    { -96, 1112, 232},
    { -32, 936, 256},
    { 8, 784, 192},
    { 88, 680, 88},
    // 97 seconds
    { 144, 632, 200},
    { 216, 560, 128},
    { 192, 808, 192},
    { 208, 832, -80},
    { 248, 1344, 352},
    { 240, 1184, 312},
    { 200, 1528, 544},
    { 120, 1320, 376},
    { 40, 1128, 408},
    { -72, 1008, 336},
    { 0, 688, 392},
    { -8, 664, 240},
    { 120, 600, 152},
    { 184, 680, 152},
    { 184, 696, 232},
    { 208, 776, 256},
    { 208, 920, 304},
    { 104, 1080, 344},
    { 0, 1136, 328},
    { 104, 1200, 280},
    { 144, 1168, 216},
    { 184, 1344, -32},
    { 72, 1160, 336},
    { 56, 928, 144},
    { 104, 840, 64},
    // 98 seconds
    { 184, 600, 8},
    { 184, 640, 24},
    { 256, 736, 0},
    { 320, 688, 24},
    { 304, 696, 88},
    { 328, 864, -168},
    { 104, 1160, 264},
    { 192, 1488, 336},
    { 256, 1392, 336},
    { 176, 960, 344},
    { 88, 1152, 408},
    { 64, 1096, 328},
    { 128, 784, 464},
    { 168, 624, 160},
    { 264, 544, 104},
    { 232, 792, 176},
    { 216, 816, 280},
    { 232, 920, 304},
    { 216, 1024, 312},
    { 48, 1080, 336},
    { 32, 1096, 392},
    { -16, 1384, 536},
    { -112, 1008, 320},
    { -72, 1176, 312},
    { -88, 1000, 344},
    // 99 seconds
    { -40, 800, 128},
    { 88, 696, 56},
    { 88, 712, 40},
    { 128, 752, 80},
    { 152, 744, 160},
    { 144, 720, 232},
    { 192, 1248, 256},
    { 280, 1200, 656},
    { 224, 1720, 800},
    { 120, 880, 368},
    { -32, 664, 720},
    { -88, 832, 728},
    { -16, 768, 512},
    { 120, 672, 408},
    { 216, 504, 352},
    { 312, 584, 424},
    { 240, 840, 624},
    { 160, 776, 584},
    { 120, 896, 528},
    { 64, 944, 472},
    { -40, 1136, 704},
    { -184, 1040, 624},
    { -328, 1272, 1000},
    { -216, 1320, 704},
    { -144, 800, 672},
    // 100 seconds
    { -40, 648, 464},
    { 8, 600, 320},
    { 96, 592, 296},
    { 120, 424, 272},
    { 192, 624, 432},
    { 168, 784, 552},
    { 280, 896, 576},
    { 352, 992, 296},
    { 56, 832, 264},
    { 184, 1120, 1120},
    { 24, 1424, 920},
    { 128, 1224, 992},
    { 56, 1160, 280},
    { 32, 464, 488},
    { 48, 744, 256},
    { 192, 384, 224},
    { 248, 600, 328},
    { 176, 624, 472},
    { 176, 912, 384},
    { 168, 872, 520},
    { 16, 1072, 544},
    { -120, 1024, 464},
    { -168, 1160, 672},
    { -280, 1152, 440},
    { -184, 1256, 448},
    // 101 seconds
    { -264, 1032, 248},
    { -160, 1032, 80},
    { 56, 632, 24},
    { 104, 640, 32},
    { 104, 656, 40},
    { 96, 816, 144},
    { 152, 888, 224},
    { 8, 848, 104},
    { 104, 1112, 256},
    { 48, 1296, 576},
    { 232, 1672, 664},
    { -128, 1288, 688},
    { -72, 568, 400},
    { -96, 904, 152},
    { 8, 624, 480},
    { 80, 560, 232},
    { 208, 496, 312},
    { 208, 600, 368},
    { 168, 792, 384},
    { 104, 904, 520},
    { 0, 1040, 512},
    { -200, 1232, 504},
    { -232, 1528, 520},
    { -592, 1336, 536},
    { -280, 1200, 8},
    // 102 seconds
    { -136, 856, 336},
    { -72, 768, 312},
    { -8, 648, 160},
    { 64, 672, 176},
    { 160, 504, 208},
    { 120, 768, 248},
    { 240, 808, 80},
    { 288, 1072, 288},
    { 248, 1272, 464},
    { 136, 1184, 528},
    { 32, 1176, 440},
    { -144, 1232, 632},
    { -96, 1096, 432},
    { -8, 736, 344},
    { 96, 768, 192},
    { 144, 464, 192},
    { 144, 480, 256},
    { 152, 704, 256},
    { 128, 768, 336},
    { 96, 872, 376},
    { 40, 992, 400},
    { -64, 1096, 504},
    { -288, 912, 704},
    { -320, 1160, 720},
    { -408, 1000, 504},
    // 103 seconds
    { -104, 1248, 408},
    { -8, 1032, 600},
    { 104, 824, 320},
    { 224, 816, 288},
    { 232, 744, 336},
    { 200, 912, 376},
    { 200, 1096, 384},
    { 192, 816, 488},
    { 128, 768, 280},
    { 136, 1112, 312},
    { 112, 1288, 528},
    { 184, 1000, 632},
    { 8, 1320, 344},
    { 248, 1176, 224},
    { 120, 1088, 40},
    { 232, 904, 104},
    { 184, 296, -216},
    { 232, 768, -416},
    { 280, 272, -344},
    { 304, 480, -664},
    { 312, 120, -664},
    { 304, 336, -872},
    { 160, 160, -912},
    { 136, 224, -992},
    { 72, 304, -1112},
    // 104 seconds
    { -80, 344, -1096},
    { -112, 216, -1024},
    { -64, 144, -832},
    { 64, 16, -632},
    { 104, -56, -536},
    { 152, 0, -520},
    { 136, 200, -808},
    { 144, 136, -1000},
    { 136, 40, -992},
    { 208, 144, -1168},
    { 24, 272, -1184},
    { 416, 416, -1296},
    { -40, 304, -960},
    { 224, 616, -1152},
    { 136, 168, -664},
    { 80, 464, -536},
    { 96, 272, -184},
    { 104, 368, -136},
    { 24, 1024, -24},
    { 112, 1120, 40},
    { 136, 1120, 240},
    { 88, 1200, 384},
    { 32, 1120, 480},
    { -8, 1096, 464},
    { -56, 1136, 608},
    // 105 seconds
    { -136, 1048, 624},
    { -96, 1152, 416},
    { -144, 904, 520},
    { -48, 832, 296},
    { 16, 832, 200},
    { 80, 720, 216},
    { 200, 656, 240},
    { -64, 416, 16},
    { 88, 976, 160},
    { 120, 880, 176},
    { 296, 1032, 96},
    { 72, 1192, 192},
    { 80, 1184, 472},
    { -80, 1456, 512},
    { 64, 1096, 384},
    { 144, 968, 296},
    { 112, 848, 352},
    { 144, 816, 336},
    { 128, 840, 360},
    { 408, 528, 88},
    { 272, 696, 320},
    { 40, 736, 312},
    { 216, 880, 352},
    { 192, 1064, 400},
    { 320, 936, 376},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}




// ----------------------------------------------------------------
// Sample captured: 2015-10-05 16:15:10 local
AccelRawData *activity_sample_walk_200_pbl_25671_12(int *len) {
  // The unit tests parse the //> TEST_.* lines below for test values
  //> TEST_NAME walk_200_pbl_25671_12
  //> TEST_EXPECTED 200
  //> TEST_EXPECTED_MIN 165
  //> TEST_EXPECTED_MAX 230
  //> TEST_WEIGHT 1.0
  static AccelRawData samples[] = {
    // 0 seconds
    // elapsed: 0 minutes
    { -80, -328, -880},
    { -128, -336, -912},
    { -144, -360, -936},
    { -112, -360, -912},
    { -104, -368, -896},
    { -112, -384, -872},
    { -104, -384, -872},
    { -104, -384, -872},
    { -96, -376, -864},
    { -104, -376, -856},
    { -152, -408, -880},
    { -136, -392, -824},
    { -104, -448, -856},
    { -128, -416, -840},
    { -136, -384, -864},
    { -88, -376, -840},
    { -128, -400, -888},
    { -280, -360, -584},
    { -216, -392, -928},
    { -152, -400, -832},
    { -144, -360, -816},
    { -136, -312, -864},
    { -176, -344, -888},
    { -184, -336, -856},
    { -176, -352, -864},
    // 1 seconds
    { -184, -328, -832},
    { -208, -360, -856},
    { -136, -328, -856},
    { -152, -312, -872},
    { -168, -352, -864},
    { -176, -352, -848},
    { -144, -336, -856},
    { -144, -304, -856},
    { -168, -256, -848},
    { -272, -216, -784},
    { -240, -240, -712},
    { -224, 40, -680},
    { -136, 216, -560},
    { 48, 728, -624},
    { 192, 864, -672},
    { 248, 576, -496},
    { 320, 1008, -440},
    { 312, 960, -264},
    { 280, 1056, -192},
    { 264, 992, -64},
    { 272, 1272, -72},
    { 232, 960, 72},
    { 248, 1080, 152},
    { 256, 1040, 136},
    { 256, 896, 208},
    // 2 seconds
    { 288, 952, 184},
    { 296, 856, 208},
    { 328, 928, 200},
    { 328, 976, 216},
    { 296, 992, 336},
    { 280, 1208, 184},
    { 256, 1024, 344},
    { 208, 1096, 512},
    { 152, 1000, 432},
    { 152, 904, 576},
    { 96, 696, 48},
    { 200, 736, 384},
    { 200, 768, 288},
    { 240, 696, 360},
    { 280, 784, 344},
    { 336, 768, 248},
    { 360, 776, 328},
    { 360, 840, 296},
    { 296, 904, 344},
    { 216, 1032, 352},
    { 128, 1000, 312},
    { -16, 1128, 360},
    { -88, 1032, 424},
    { -8, 1064, 224},
    { 0, 936, 304},
    // 3 seconds
    { -8, 920, 336},
    { 56, 936, 288},
    { 120, 872, 272},
    { 152, 752, 256},
    { 168, 832, 192},
    { 192, 824, 184},
    { 232, 912, 160},
    { 296, 1032, 160},
    { 320, 1024, 312},
    { 416, 1384, 248},
    { -8, 1096, 456},
    { 40, 1304, 504},
    { -176, 1240, 640},
    { -40, 1000, 488},
    { -56, 952, 224},
    { -160, 520, 528},
    { -16, 968, 168},
    { 104, 800, 360},
    { 144, 688, 288},
    { 112, 736, 216},
    { 120, 784, 312},
    { 104, 944, 360},
    { -40, 1200, 392},
    { -152, 1168, 392},
    { -128, 1272, 296},
    // 4 seconds
    { -168, 1048, 416},
    { -104, 1088, 208},
    { -128, 920, 232},
    { -16, 840, 144},
    { 64, 656, 152},
    { 176, 600, 120},
    { 208, 1088, 80},
    { 56, 648, -80},
    { 192, 800, 400},
    { 296, 1208, 160},
    { 328, 952, 456},
    { 144, 1288, 336},
    { -104, 1384, 840},
    { -376, 1696, 592},
    { -104, 1080, 552},
    { -32, 848, 336},
    { 16, 656, 248},
    { 48, 584, 280},
    { 104, 544, 208},
    { 120, 680, 272},
    { 80, 832, 328},
    { 72, 872, 328},
    { 88, 984, 368},
    { -16, 1088, 472},
    { -40, 1248, 472},
    // 5 seconds
    { -208, 1312, 576},
    { -168, 1088, 176},
    { -152, 984, 176},
    { -152, 752, 304},
    { -8, 728, 176},
    { 144, 504, 112},
    { 128, 408, 344},
    { 112, 672, 56},
    { 120, 952, 296},
    { 384, 1040, 160},
    { 256, 800, 456},
    { 168, 1056, 328},
    { -24, 1192, 232},
    { 40, 1440, 744},
    { -272, 1400, 632},
    { -104, 1016, 496},
    { -48, 760, 432},
    { 0, 632, 384},
    { 88, 624, 184},
    { 128, 632, 296},
    { 96, 776, 320},
    { 88, 936, 256},
    { 24, 960, 336},
    { 24, 1040, 216},
    { -56, 1536, 448},
    // 6 seconds
    { -136, 1352, 352},
    { -376, 1216, 632},
    { -296, 1224, 216},
    { -192, 856, 128},
    { -128, 720, 232},
    { 48, 696, 104},
    { 128, 712, 96},
    { 184, 704, 224},
    { 224, 864, 168},
    { 224, 960, 152},
    { 288, 848, 240},
    { 336, 720, 48},
    { 184, 1392, 208},
    { -56, 1088, 704},
    { 192, 1440, 632},
    { -224, 1168, 704},
    { -104, 984, 936},
    { -192, 1056, 320},
    { 24, 592, 520},
    { 40, 552, 360},
    { 144, 432, 144},
    { 168, 552, 176},
    { 160, 712, 384},
    { 152, 912, 320},
    { -48, 1248, 496},
    // 7 seconds
    { -160, 1040, 464},
    { -136, 1288, 232},
    { -200, 984, 432},
    { -72, 984, 232},
    { -160, 1184, 344},
    { -352, 1136, 384},
    { -112, 920, 376},
    { 128, 528, 72},
    { 152, 528, 32},
    { 384, 456, 152},
    { 96, 912, -88},
    { 160, 896, 392},
    { 96, 1184, 384},
    { 104, 1160, 264},
    { -160, 1952, 704},
    { -744, 1096, 416},
    { -96, 792, 528},
    { -128, 792, 408},
    { -16, 656, 328},
    { 32, 688, 232},
    { 152, 528, 8},
    { 120, 584, 240},
    { 72, 928, 264},
    { -168, 1104, 384},
    { -144, 1032, 392},
    // 8 seconds
    { -392, 1176, 168},
    { -288, 1080, 336},
    { -352, 1152, 368},
    { -168, 1152, 328},
    { -312, 1144, 344},
    { -248, 824, 152},
    { -80, 664, 64},
    { 120, 552, -136},
    { 80, 576, -136},
    { 88, 568, -8},
    { -168, 544, -216},
    { -48, 1152, 192},
    { -208, 1392, 592},
    { -200, 1696, 376},
    { -336, 1184, 440},
    { -168, 1112, 640},
    { -248, 856, 408},
    { -256, 792, 344},
    { -56, 600, 232},
    { 48, 432, 112},
    { 8, 480, 224},
    { 32, 696, 224},
    { -112, 1016, 368},
    { -248, 1184, 368},
    { -360, 1208, 368},
    // 9 seconds
    { -272, 1000, 56},
    { -368, 888, 328},
    { -312, 952, 248},
    { -328, 1136, 160},
    { -328, 952, 216},
    { -168, 864, 104},
    { 16, 712, 32},
    { -144, 384, -80},
    { 136, 584, 64},
    { -64, 784, 184},
    { -96, 1376, 56},
    { -16, 1008, 192},
    { -128, 1088, 240},
    { -168, 888, 856},
    { -680, 1840, 656},
    { -472, 1368, 616},
    { -304, 1096, 576},
    { -160, 888, 424},
    { 0, 568, 160},
    { 136, 504, 120},
    { 192, 544, 8},
    { 72, 496, 128},
    { 64, 752, 160},
    { -160, 1144, 360},
    { -496, 1480, 472},
    // 10 seconds
    { -496, 1304, 336},
    { -440, 1224, 392},
    { -368, 1048, 312},
    { -408, 1088, 216},
    { -344, 848, 152},
    { -152, 616, 48},
    { -32, 496, -200},
    { 80, 376, 80},
    { 112, 248, 184},
    { -96, 856, 328},
    { -304, 1360, 96},
    { -200, 1456, 344},
    { -448, 1176, 664},
    { -168, 1312, 464},
    { -512, 1504, 552},
    { -432, 1328, 416},
    { -440, 984, 488},
    { -272, 640, 376},
    { -248, 672, 240},
    { -104, 464, 160},
    { -88, 584, 232},
    { -120, 632, 208},
    { -176, 864, 232},
    { -304, 1040, 280},
    { -528, 1032, 328},
    // 11 seconds
    { -480, 1136, 320},
    { -552, 1056, 592},
    { -440, 1088, -64},
    { -504, 992, 96},
    { -496, 808, 352},
    { -160, 624, 32},
    { -48, 656, -8},
    { 48, 800, -96},
    { -24, 744, 64},
    { -32, 976, 192},
    { -48, 1264, 224},
    { -160, 1504, 80},
    { -256, 984, 48},
    { -176, 1136, 328},
    { -344, 1528, 312},
    { -216, 1352, 512},
    { -152, 1024, 360},
    { -64, 736, 80},
    { 16, 592, -64},
    { 40, 448, 56},
    { 56, 576, 88},
    { -16, 800, 16},
    { -96, 944, 56},
    { -248, 1232, 88},
    { -320, 1160, -32},
    // 12 seconds
    { -320, 1240, 176},
    { -328, 1200, 208},
    { -240, 1224, 16},
    { -176, 856, 80},
    { -64, 712, 64},
    { 32, 688, 0},
    { 120, 712, 16},
    { 128, 536, -8},
    { 24, 744, -32},
    { 168, 1032, 40},
    { 376, 1016, 264},
    { 88, 1576, 104},
    { -24, 1312, 40},
    { -312, 1288, 496},
    { -304, 1496, 376},
    { -200, 1136, 304},
    { -112, 872, 248},
    { 0, 776, 176},
    { 16, 512, 160},
    { 48, 472, 48},
    { 8, 616, 16},
    { -120, 880, -80},
    { -304, 1192, -232},
    { -568, 1288, -96},
    { -560, 1168, -112},
    // 13 seconds
    { -688, 1112, 200},
    { -552, 936, -96},
    { -440, 984, 96},
    { -320, 512, 56},
    { -88, 864, 64},
    { 192, 568, 64},
    { 264, 832, -192},
    { 360, 560, 16},
    { 248, 880, 40},
    { 120, 840, -88},
    { 0, 1072, 80},
    { -336, 1112, 216},
    { -360, 1576, 488},
    { -600, 1568, 392},
    { -192, 1352, 336},
    { -136, 952, 368},
    { -40, 792, 136},
    { 16, 656, 104},
    { 48, 560, 104},
    { 48, 680, 112},
    { -48, 944, 80},
    { -160, 968, 112},
    { -280, 1096, 64},
    { -440, 1120, -104},
    { -368, 968, -64},
    // 14 seconds
    { -392, 920, 88},
    { -312, 984, 24},
    { -256, 1120, 16},
    { -64, 840, 120},
    { 40, 592, -128},
    { 160, 472, 56},
    { 240, 696, 32},
    { 176, 864, -40},
    { 80, 848, 64},
    { 64, 1104, 56},
    { -24, 1424, 80},
    { -104, 1320, 216},
    { -64, 1440, 248},
    { -216, 1304, 128},
    { -40, 1160, 176},
    { -24, 968, 248},
    { -8, 648, 176},
    { 48, 568, 128},
    { 56, 560, 88},
    { 48, 664, 184},
    { -88, 1024, 120},
    { -256, 1048, 144},
    { -448, 1304, -48},
    { -400, 1024, -56},
    { -568, 1168, 72},
    // 15 seconds
    { -368, 1056, -64},
    { -240, 984, -112},
    { -144, 872, 240},
    { 8, 744, -8},
    { 64, 624, -48},
    { 128, 608, 0},
    { 224, 856, -88},
    { 256, 872, 80},
    { 208, 1024, 72},
    { 64, 1296, 128},
    { -80, 1608, 496},
    { -328, 2184, 304},
    { -96, 1400, 304},
    { -96, 1024, 240},
    { -32, 808, 272},
    { 80, 480, 200},
    { 64, 472, 152},
    { 112, 528, 96},
    { 112, 632, 128},
    { 48, 920, 88},
    { -32, 1072, 16},
    { -200, 1256, -24},
    { -136, 1096, -112},
    { -216, 1200, -56},
    { -80, 1128, -128},
    // 16 seconds
    { -8, 1088, -136},
    { 0, 856, -104},
    { 120, 568, -40},
    { 280, 272, 24},
    { 304, 224, 128},
    { 360, 952, 120},
    { 400, 1016, 280},
    { 488, 1040, 392},
    { 384, 1600, 216},
    { 56, 768, 568},
    { -72, 1640, 720},
    { -184, 1640, 744},
    { -168, 1328, 512},
    { -32, 808, 440},
    { 120, 584, 360},
    { 152, 472, 232},
    { 248, 464, 224},
    { 224, 480, 296},
    { 184, 416, 344},
    { 128, 720, 752},
    { -80, 1072, 728},
    { -152, 1344, 536},
    { -224, 1432, 472},
    { -288, 1024, 608},
    { -128, 1208, 304},
    // 17 seconds
    { 40, 888, 368},
    { 96, 688, 136},
    { 208, 672, 80},
    { 256, 640, 288},
    { 216, 744, 392},
    { 120, 936, 232},
    { 88, 832, 424},
    { 96, 1152, 544},
    { -144, 1248, 560},
    { 48, 1024, 568},
    { -208, 1504, 936},
    { -208, 1424, 896},
    { -56, 1120, 528},
    { 128, 720, 432},
    { 136, 432, 376},
    { 296, 408, 240},
    { 272, 504, 264},
    { 296, 520, 184},
    { 440, 576, 240},
    { 520, 640, 384},
    { 392, 1128, 520},
    { 56, 1192, 464},
    { 16, 1152, 288},
    { -56, 1096, 312},
    { -56, 904, 488},
    // 18 seconds
    { -80, 1208, 344},
    { -8, 1112, 488},
    { 40, 1128, 296},
    { 104, 984, 64},
    { 160, 632, 408},
    { 200, 744, -232},
    { 264, 488, 160},
    { 368, 672, 344},
    { 616, 904, 376},
    { 480, 744, 728},
    { 120, 1136, 664},
    { 144, 1384, 928},
    { 72, 1256, 952},
    { 136, 1152, 632},
    { 184, 816, 432},
    { 208, 728, 336},
    { 288, 424, 352},
    { 296, 560, 200},
    { 400, 696, 352},
    { 296, 800, 392},
    { 248, 1120, 440},
    { 80, 1176, 312},
    { 16, 872, 472},
    { -48, 824, 304},
    { -128, 672, 728},
    // 19 seconds
    { -192, 984, 728},
    { -240, 1056, 624},
    { -16, 944, 400},
    { 144, 872, 40},
    { 208, 592, -376},
    { 56, 424, 144},
    { 184, 1248, 16},
    { 288, 992, 312},
    { 464, 952, 256},
    { 832, 856, 592},
    { 384, 1480, 720},
    { -112, 1840, 520},
    { -640, 1720, 448},
    { -576, 1496, 120},
    { -352, 904, 56},
    { -64, 536, 112},
    { 112, 480, -80},
    { 128, 592, -144},
    { 184, 352, 200},
    { 120, 312, 224},
    { 0, 1288, -88},
    { -272, 1280, 168},
    { -232, 1264, -72},
    { -48, 1720, -88},
    { -48, 1176, 144},
    // 20 seconds
    { -96, 1072, -208},
    { 80, 632, -24},
    { 120, 336, -56},
    { 200, 568, 80},
    { 320, 624, -336},
    { 232, 688, -16},
    { 224, 984, -216},
    { 272, 1016, -248},
    { 384, 1280, -504},
    { 104, 1120, -40},
    { -200, 2080, -232},
    { -184, 1528, 32},
    { -48, 1352, -48},
    { -32, 1048, -88},
    { 112, 624, -200},
    { 272, 424, -320},
    { 560, 360, -520},
    { 368, 408, -280},
    { 56, 920, -344},
    { -224, 968, -72},
    { -312, 856, -128},
    { -232, 952, -240},
    { -208, 1040, 8},
    { -136, 1080, -128},
    { 0, 1264, -176},
    // 21 seconds
    { -16, 912, -40},
    { 32, 840, -72},
    { 136, 752, -152},
    { 240, 656, -120},
    { 248, 720, -72},
    { 208, 912, -8},
    { 280, 928, 8},
    { 248, 1320, -16},
    { 160, 1424, 104},
    { 56, 1216, 504},
    { -96, 1712, 224},
    { -128, 1360, 456},
    { -104, 768, 272},
    { -16, 736, 128},
    { 8, 472, 176},
    { 16, 544, 88},
    { 104, 600, 160},
    { 96, 728, 256},
    { 32, 904, 304},
    { -80, 1216, 320},
    { -400, 1280, 336},
    { -384, 1232, 256},
    { -272, 1080, 296},
    { -240, 1144, 48},
    { -160, 832, 168},
    // 22 seconds
    { -24, 752, 136},
    { 64, 680, 24},
    { 128, 552, -32},
    { -24, 976, -472},
    { -24, 624, 40},
    { 24, 1312, -224},
    { 192, 1096, -112},
    { 0, 1344, -208},
    { 8, 1024, -104},
    { -72, 1488, -144},
    { -96, 1104, 232},
    { -32, 1216, -136},
    { -8, 920, -64},
    { 16, 600, 40},
    { 80, 536, -184},
    { 112, 488, -88},
    { 80, 624, 16},
    { -40, 880, 72},
    { -312, 1112, 152},
    { -264, 992, 48},
    { -176, 1184, 0},
    { -256, 1456, -112},
    { -72, 1576, -440},
    { 16, 1352, -440},
    { 40, 968, -208},
    // 23 seconds
    { 96, 776, -152},
    { 136, 536, -88},
    { 144, 504, -112},
    { 200, 752, -112},
    { 352, 672, 24},
    { 224, 504, 256},
    { 144, 1344, -192},
    { 216, 1280, -16},
    { 88, 1416, 168},
    { -304, 1448, 16},
    { -424, 944, -312},
    { -176, 968, -448},
    { -128, 904, -248},
    { -88, 800, -8},
    { 72, 704, -160},
    { 136, 584, -112},
    { 72, 648, 40},
    { 24, 896, 72},
    { -16, 1088, 16},
    { -120, 1080, 160},
    { -168, 1152, 88},
    { -208, 1336, 160},
    { -176, 1288, 0},
    { -184, 1184, -120},
    { -232, 944, -24},
    // 24 seconds
    { -144, 856, -24},
    { -8, 672, -200},
    { -24, 464, 40},
    { 192, 696, -296},
    { 88, 872, 112},
    { 160, 1272, 152},
    { -48, 1208, 72},
    { 176, 1192, 176},
    { 152, 1096, 480},
    { 456, 1608, 600},
    { -32, 1624, 688},
    { -32, 1248, 632},
    { 24, 896, 328},
    { 104, 656, 600},
    { -88, 568, 328},
    { 72, 736, 56},
    { 64, 728, 208},
    { 32, 744, 272},
    { -24, 792, 240},
    { -56, 944, 304},
    { -200, 1248, 272},
    { -208, 1056, 216},
    { -248, 1288, 296},
    { -160, 1192, 72},
    { -128, 1016, -96},
    // 25 seconds
    { -224, 1008, 176},
    { -24, 824, -136},
    { 88, 648, -128},
    { 112, 648, 8},
    { 104, 832, -96},
    { 120, 944, -168},
    { -112, 824, 376},
    { 144, 1248, -24},
    { 72, 1112, 280},
    { 240, 1432, 304},
    { -280, 1704, 64},
    { -128, 616, 112},
    { -48, 952, 80},
    { 64, 704, 80},
    { 88, 672, 208},
    { 168, 624, 48},
    { 168, 704, 120},
    { 128, 864, 240},
    { 88, 1056, 264},
    { 40, 904, 192},
    { -40, 1080, 272},
    { -176, 1296, 72},
    { -200, 1752, 256},
    { -136, 1496, 264},
    { -128, 1000, -112},
    // 26 seconds
    { -128, 544, -112},
    { -120, 528, -216},
    { 16, 280, 8},
    { 88, 264, -8},
    { 192, 392, -112},
    { 248, 976, 40},
    { 432, 1160, 160},
    { 448, 1280, 64},
    { 296, 1488, 448},
    { 240, 1240, 968},
    { 600, 1976, 584},
    { -56, 1344, 832},
    { -128, 824, 248},
    { -112, 736, 400},
    { -48, 600, 360},
    { 88, 488, 216},
    { 128, 448, 64},
    { 168, 448, 264},
    { 216, 472, 232},
    { 232, 648, 232},
    { 160, 608, 184},
    { -168, 672, 40},
    { -448, 1032, 192},
    { -528, 1432, 296},
    { -584, 1464, 256},
    // 27 seconds
    { -528, 1560, 112},
    { -472, 1192, 288},
    { -216, 944, 112},
    { -24, 696, -32},
    { 40, 584, 8},
    { 64, 592, 136},
    { 32, 720, 160},
    { -64, 728, -48},
    { 104, 1312, 200},
    { -208, 1576, 144},
    { -384, 2136, 176},
    { 88, 1008, 192},
    { -368, 784, -344},
    { -56, 656, -8},
    { -240, 696, 48},
    { -224, 824, 208},
    { -80, 632, -40},
    { 56, 608, -32},
    { -48, 600, 96},
    { -96, 536, 144},
    { -104, 568, 168},
    { -280, 904, 72},
    { -272, 936, -32},
    { -256, 1336, 176},
    { -576, 1672, 16},
    // 28 seconds
    { -720, 1632, -288},
    { -672, 1296, -136},
    { -376, 848, -112},
    { -288, 816, -184},
    { -128, 784, -232},
    { -144, 624, -168},
    { -88, 992, -80},
    { -200, 720, -48},
    { -136, 1104, -96},
    { -248, 1072, -64},
    { 8, 968, -56},
    { -48, 856, 48},
    { -120, 1288, 136},
    { -272, 1056, -80},
    { 96, 1104, 256},
    { -32, 1056, 136},
    { -8, 896, 88},
    { 64, 704, -56},
    { 64, 800, 56},
    { -64, 792, 56},
    { -40, 840, 56},
    { 40, 912, 64},
    { 120, 960, 24},
    { 96, 976, 200},
    { 232, 1056, 208},
    // 29 seconds
    { 336, 1160, 152},
    { 424, 1016, 56},
    { 472, 784, -8},
    { 416, 576, 128},
    { 408, 616, 160},
    { 376, 752, 104},
    { 448, 744, 88},
    { 448, 768, 152},
    { 392, 880, 200},
    { 320, 1000, 504},
    { 152, 1496, 776},
    { 48, 1448, 696},
    { 248, 1152, 544},
    { 232, 856, 544},
    { 200, 752, 464},
    { 160, 776, 448},
    { 104, 744, 512},
    { 64, 800, 656},
    { -24, 888, 632},
    { 0, 840, 640},
    { 0, 840, 712},
    { 64, 928, 480},
    { 112, 824, 472},
    { 136, 912, 432},
    { 88, 984, 336},
    // 30 seconds
    { 104, 984, 320},
    { 128, 1056, 304},
    { 56, 984, 408},
    { 96, 1096, 272},
    { 0, 1016, 360},
    { 24, 984, 320},
    { 32, 840, 200},
    { 64, 584, 256},
    { 168, 592, 176},
    { 128, 592, 232},
    { 200, 648, 248},
    { 200, 1064, 296},
    { 336, 1200, 288},
    { 480, 1144, 192},
    { 456, 568, -104},
    { 344, 1208, 480},
    { -112, 1432, 608},
    { -48, 1640, 832},
    { -216, 1248, 512},
    { -80, 904, 496},
    { -8, 688, 224},
    { 120, 552, 208},
    { 88, 616, 232},
    { 88, 832, 296},
    { 24, 984, 464},
    // 31 seconds
    { 8, 1120, 464},
    { -72, 1192, 560},
    { 0, 1104, 448},
    { 0, 936, 520},
    { 24, 1176, 288},
    { -112, 1104, 248},
    { -120, 624, 240},
    { -112, 584, -104},
    { 80, 648, -32},
    { 168, 664, 264},
    { 224, 1096, 152},
    { 200, 864, 232},
    { 216, 1240, 192},
    { 144, 1384, 392},
    { 16, 1728, 904},
    { -312, 1632, 432},
    { -224, 1136, 352},
    { -88, 616, 336},
    { 64, 488, 184},
    { 224, 424, 112},
    { 216, 432, 144},
    { 104, 608, 272},
    { 0, 912, 336},
    { -80, 1152, 456},
    { -208, 1424, 520},
    // 32 seconds
    { -128, 1216, 208},
    { -112, 1096, 320},
    { -64, 936, 344},
    { -128, 1152, 168},
    { -176, 864, 256},
    { 56, 576, 80},
    { 104, 640, 24},
    { 112, 416, 32},
    { 344, 936, 72},
    { 368, 1224, 40},
    { 240, 1112, -136},
    { -56, 1240, 360},
    { -48, 1200, 528},
    { -128, 1528, 728},
    { -232, 1256, 440},
    { -120, 920, 408},
    { 8, 664, 304},
    { 88, 552, 192},
    { 192, 728, 88},
    { 224, 664, 200},
    { 200, 736, 304},
    { 184, 1000, 480},
    { 128, 1216, 440},
    { 0, 1312, 416},
    { 160, 1232, 208},
    // 33 seconds
    { 40, 1248, 264},
    { 96, 944, 152},
    { 0, 920, 144},
    { 40, 712, 232},
    { 136, 528, 144},
    { 72, 208, -160},
    { 312, 488, 208},
    { 352, 808, 304},
    { 512, 1160, 280},
    { 368, 808, 184},
    { 312, 1120, 544},
    { 256, 1560, 600},
    { 56, 1744, 856},
    { -128, 1424, 168},
    { 56, 720, 456},
    { 96, 648, 392},
    { 240, 712, 192},
    { 216, 496, 32},
    { 264, 552, 224},
    { 240, 736, 256},
    { 152, 936, 384},
    { 120, 1104, 376},
    { -16, 1192, 296},
    { 40, 1232, 288},
    { -8, 1024, 592},
    // 34 seconds
    { -8, 1400, 120},
    { -16, 968, 192},
    { 56, 808, 120},
    { 128, 608, 64},
    { 192, 448, 104},
    { 280, 464, 96},
    { -80, 152, -192},
    { 160, 472, 440},
    { 184, 1440, 400},
    { 272, 1176, 176},
    { 152, 1400, 272},
    { -48, 1392, 688},
    { -248, 1744, 672},
    { -256, 1120, 568},
    { 24, 1008, 280},
    { 120, 536, 112},
    { 232, 448, 112},
    { 216, 504, 184},
    { 176, 560, 352},
    { 160, 696, 352},
    { 128, 992, 400},
    { 8, 1216, 568},
    { -32, 1216, 248},
    { -40, 1208, 528},
    { 8, 1088, 384},
    // 35 seconds
    { -16, 1240, 48},
    { 48, 816, 184},
    { 88, 752, 56},
    { 168, 568, 120},
    { 256, 536, 160},
    { 176, 720, -72},
    { 176, 736, 248},
    { 192, 968, 288},
    { 424, 1136, 208},
    { 112, 984, 368},
    { 280, 904, 416},
    { -464, 944, 424},
    { -776, 1736, 992},
    { -600, 1784, 576},
    { -88, 1176, 312},
    { 176, 640, 96},
    { 224, 432, 104},
    { 72, 528, 160},
    { -72, 648, 176},
    { -168, 808, 248},
    { -328, 1056, 288},
    { -496, 1160, 224},
    { -520, 1208, 280},
    { -584, 1248, 424},
    { -400, 1216, -32},
    // 36 seconds
    { -424, 1128, 40},
    { -288, 752, 120},
    { -96, 520, -8},
    { 16, 520, -64},
    { 56, 520, 40},
    { 56, 736, 0},
    { 120, 648, 80},
    { 128, 832, 152},
    { 16, 968, 288},
    { -8, 1680, 416},
    { -104, 1248, 232},
    { -144, 1552, 680},
    { -112, 1864, 608},
    { -168, 1912, 776},
    { -488, 1512, 680},
    { -592, 1736, 496},
    { -480, 1272, 464},
    { -416, 784, 256},
    { -400, 296, 240},
    { -360, 176, 200},
    { -280, 304, -80},
    { -256, 400, -112},
    { -320, 792, 200},
    { 8, 1008, 808},
    { 48, 1944, 224},
    // 37 seconds
    { 112, 1304, 328},
    { 232, 704, 296},
    { 392, 536, 152},
    { 360, 600, 144},
    { 296, 664, 72},
    { 392, 680, 192},
    { 136, 1168, -800},
    { 280, 1528, 72},
    { 48, 1264, 256},
    { 256, 984, 192},
    { 32, 1216, 472},
    { -216, 736, 256},
    { -40, 584, 208},
    { 16, 560, 328},
    { 8, 992, 104},
    { 120, 888, 280},
    { 128, 864, 224},
    { 64, 872, 224},
    { 80, 848, 216},
    { -8, 936, 280},
    { -32, 1080, 264},
    { -40, 1232, 216},
    { 8, 1176, 480},
    { -56, 1448, 0},
    { -24, 1280, -24},
    // 38 seconds
    { -16, 960, -8},
    { 48, 760, -152},
    { 136, 512, -56},
    { 168, 584, 40},
    { 248, 1016, 224},
    { 416, 848, 88},
    { 760, 904, 512},
    { 624, 968, 480},
    { 512, 1368, 304},
    { 576, 1664, -184},
    { 80, 640, 320},
    { 144, 920, -56},
    { 144, 680, 120},
    { 72, 848, 280},
    { 64, 1080, 136},
    { 232, 680, 248},
    { 320, 600, 192},
    { 344, 696, 216},
    { 312, 928, 312},
    { 216, 1136, 400},
    { 208, 1184, 352},
    { 104, 1256, 480},
    { 56, 1064, 392},
    { 80, 1152, 208},
    { 64, 880, 216},
    // 39 seconds
    { 88, 784, 56},
    { 208, 576, 48},
    { 272, 768, 40},
    { 128, 816, 184},
    { 368, 1064, 208},
    { 392, 968, 256},
    { 528, 1008, 208},
    { 400, 1272, 304},
    { 536, 1056, 216},
    { -48, 1072, 584},
    { 152, 1192, 400},
    { 272, 904, 464},
    { 200, 696, 208},
    { 272, 488, 224},
    { 336, 528, 184},
    { 344, 712, 232},
    { 328, 920, 280},
    { 216, 1056, 288},
    { 216, 1232, 320},
    { 96, 1128, 264},
    { 128, 1224, 344},
    { 24, 1024, 400},
    { 56, 1160, 96},
    { 88, 840, 248},
    { 96, 784, 96},
    // 40 seconds
    { 208, 552, 8},
    { 352, 392, -24},
    { 344, 488, 200},
    { 216, 1056, 296},
    { 288, 1240, 368},
    { 320, 1296, 288},
    { 120, 728, 48},
    { 168, 1664, 624},
    { -192, 1488, 656},
    { 32, 1216, 384},
    { 104, 848, 384},
    { 144, 544, 232},
    { 168, 552, 168},
    { 224, 568, 152},
    { 192, 664, 240},
    { 160, 864, 352},
    { 88, 1072, 296},
    { 64, 1304, 392},
    { -32, 1184, 296},
    { -64, 1464, 408},
    { -208, 944, 320},
    { 0, 1272, 224},
    { -248, 568, -80},
    { -32, 784, 160},
    { 56, 568, 168},
    // 41 seconds
    { 184, 480, 64},
    { 232, 784, 176},
    { 264, 968, 272},
    { 352, 1040, 256},
    { 440, 1208, 424},
    { -48, 1136, 192},
    { 296, 1160, 560},
    { -160, 1496, 496},
    { -144, 1248, 416},
    { -80, 1200, 384},
    { -152, 624, 544},
    { -128, 968, 240},
    { 72, 648, 168},
    { 136, 600, 184},
    { 120, 728, 264},
    { 72, 936, 344},
    { -56, 1208, 376},
    { -120, 1304, 320},
    { -64, 1384, 472},
    { -192, 880, 352},
    { 16, 1224, 224},
    { 8, 768, 184},
    { 40, 752, 136},
    { 16, 808, -168},
    { 128, 312, 72},
    // 42 seconds
    { 160, 688, 136},
    { 80, 1024, 272},
    { 248, 1112, 288},
    { 232, 1072, 280},
    { 56, 1136, 360},
    { 16, 1696, 520},
    { -280, 1640, 528},
    { 120, 968, 296},
    { 48, 696, 208},
    { 104, 328, 200},
    { 192, 512, 40},
    { 240, 664, 104},
    { 136, 976, 208},
    { 16, 1104, 216},
    { -40, 1200, 296},
    { -144, 1240, 224},
    { -48, 968, 104},
    { -40, 1072, 240},
    { -176, 1120, 328},
    { -56, 1072, 32},
    { -144, 488, 8},
    { -136, -472, -336},
    { -320, 440, -88},
    { -296, 1376, 280},
    { 136, 1096, 552},
    // 43 seconds
    { 248, 1064, 408},
    { 304, 984, 360},
    { -248, 1416, 456},
    { -336, 1616, 808},
    { -680, 1352, 600},
    { -232, 1040, 360},
    { -88, 728, 288},
    { -96, 552, 248},
    { -48, 680, 160},
    { 24, 584, 168},
    { -48, 728, 216},
    { -200, 920, 272},
    { -272, 992, 304},
    { -352, 1264, 360},
    { -256, 1064, 368},
    { -320, 1136, 456},
    { -128, 1160, 136},
    { -128, 952, 208},
    { -88, 928, -80},
    { 72, 336, 8},
    { 64, 144, -352},
    { 40, 24, -192},
    { -424, 1440, 32},
    { -240, 1464, 200},
    { 192, 1248, -32},
    // 44 seconds
    { -40, 1144, 168},
    { -168, 1624, 488},
    { -816, 1728, 496},
    { -344, 1288, 336},
    { -256, 872, 288},
    { -96, 608, 208},
    { 16, 440, 128},
    { -40, 504, 160},
    { -80, 600, 80},
    { -272, 1040, 192},
    { -480, 1072, 272},
    { -424, 1160, 224},
    { -352, 1016, 304},
    { -360, 1120, 384},
    { -344, 1008, 448},
    { -320, 1096, 216},
    { -296, 1016, 200},
    { -168, 688, 128},
    { -32, 464, 368},
    { -24, 800, -32},
    { 96, 552, 216},
    { 168, 968, -56},
    { 80, 984, -24},
    { 72, 1408, 240},
    { -96, 1256, 192},
    // 45 seconds
    { 120, 1384, 352},
    { -272, 1384, 352},
    { -248, 824, 496},
    { -184, 944, 376},
    { -72, 616, 392},
    { -80, 568, 240},
    { 152, 664, 88},
    { 8, 648, 376},
    { 80, 1008, 408},
    { -24, 1112, 424},
    { -72, 1400, 248},
    { -128, 1088, 560},
    { -128, 904, 432},
    { -88, 976, 440},
    { -160, 1056, 352},
    { -72, 1064, 168},
    { -48, 896, 0},
    { 32, 552, -8},
    { 56, 480, -48},
    { 128, 688, -80},
    { 176, 792, 184},
    { 192, 832, -240},
    { 280, 1304, 312},
    { 120, 1504, 464},
    { 240, 1648, 768},
    // 46 seconds
    { -8, 1624, 424},
    { -32, 1136, 360},
    { 24, 576, 416},
    { -24, 624, 216},
    { 8, 568, 176},
    { 32, 616, 48},
    { 88, 664, 80},
    { 152, 744, 72},
    { 216, 928, 192},
    { 224, 1088, 216},
    { 160, 1264, 304},
    { 144, 1240, 200},
    { 72, 1064, 168},
    { 64, 1000, 200},
    { 32, 984, 120},
    { 16, 792, 152},
    { -24, 880, 112},
    { 88, 664, 8},
    { 192, 704, 32},
    { 280, 912, -80},
    { 176, 1232, 392},
    { 296, 1408, 448},
    { 360, 1568, 456},
    { 168, 1296, 384},
    { 176, 928, 384},
    // 47 seconds
    { 144, 320, 384},
    { 0, 712, 448},
    { 16, 1024, 552},
    { -8, 568, 328},
    { 64, 496, 240},
    { 160, 952, -72},
    { 320, 584, 360},
    { 360, 856, 384},
    { 312, 1080, 440},
    { 248, 1160, 536},
    { 264, 1088, 368},
    { 184, 1152, 448},
    { 96, 1152, 544},
    { -16, 1080, 168},
    { 104, 896, 128},
    { 120, 688, 80},
    { 232, 552, 216},
    { 280, 616, 168},
    { 376, 696, 184},
    { 392, 784, 264},
    { 480, 936, 56},
    { 344, 1248, 432},
    { 176, 1320, 360},
    { 480, 1056, 552},
    { 376, 1352, 440},
    // 48 seconds
    { -136, 1168, 440},
    { 80, 672, 472},
    { 16, 1120, 296},
    { 104, 528, 248},
    { 224, 480, 224},
    { 224, 656, 288},
    { 240, 768, 632},
    { 168, 1184, 608},
    { 208, 1112, 672},
    { 120, 976, 560},
    { 104, 896, 424},
    { 160, 752, 856},
    { 72, 968, 592},
    { 88, 960, 416},
    { 64, 808, 312},
    { 176, 616, 248},
    { 232, 560, 248},
    { 416, 512, 384},
    { 296, 696, -32},
    { 216, 984, 160},
    { 96, 1592, 480},
    { 184, 1616, 112},
    { 296, 1512, 432},
    { -168, 1136, 464},
    { -56, 968, 168},
    // 49 seconds
    { -144, 1008, 360},
    { 0, 648, 160},
    { 128, 640, 160},
    { 128, 512, 216},
    { 72, 728, 312},
    { 0, 1064, 368},
    { -120, 1016, 216},
    { -192, 1064, 360},
    { -216, 1000, 296},
    { -296, 1288, 232},
    { -176, 1032, 480},
    { -208, 1280, 80},
    { -112, 1080, 176},
    { -32, 728, 40},
    { 56, 624, 24},
    { 0, 528, -160},
    { 0, 600, 112},
    { -112, 736, -224},
    { 72, 1128, 200},
    { 72, 1288, 136},
    { 248, 1336, 624},
    { 136, 1232, 320},
    { 328, 1696, 560},
    { -232, 1320, 520},
    { -168, 1008, 984},
    // 50 seconds
    { -160, 704, 328},
    { 64, 840, 480},
    { -56, 624, 8},
    { 32, 600, 272},
    { 80, 880, 376},
    { 32, 960, 384},
    { 136, 952, 416},
    { 16, 1016, 464},
    { 72, 1096, 384},
    { 16, 1040, 528},
    { -88, 1008, 600},
    { -40, 1008, 424},
    { -88, 560, 504},
    { 96, 552, 104},
    { 224, 616, 88},
    { 256, 712, 576},
    { 208, 1040, 512},
    { 152, 1160, 616},
    { 192, 1184, 440},
    { 288, 976, 784},
    { -88, 1048, 272},
    { -48, 1352, 304},
    { 80, 1072, 1032},
    { -88, 1208, 560},
    { -8, 1184, 632},
    // 51 seconds
    { -152, 592, 384},
    { 8, 352, 176},
    { 256, 384, 200},
    { 224, 592, 80},
    { 312, 704, 296},
    { 224, 912, 296},
    { 184, 1088, 504},
    { 80, 1088, 464},
    { -64, 1040, 320},
    { 16, 1136, 440},
    { -264, 1216, 400},
    { -304, 1152, 272},
    { -272, 1000, 368},
    { -104, 744, 128},
    { 64, 592, 80},
    { 184, 560, -104},
    { 80, 912, -136},
    { 160, 336, 16},
    { 8, 1168, 80},
    { 88, 1560, 328},
    { -16, 1480, 80},
    { 112, 1208, -24},
    { -240, 1184, 240},
    { -136, 1408, 352},
    { -8, 832, 480},
    // 52 seconds
    { -8, 616, 128},
    { 24, 504, 160},
    { 104, 576, 24},
    { 64, 608, 184},
    { 64, 848, 264},
    { 0, 1048, 288},
    { -184, 1312, 296},
    { -264, 1072, 376},
    { -272, 1288, 216},
    { -256, 1104, 352},
    { -264, 1016, 248},
    { -216, 936, 184},
    { -248, 888, 288},
    { -160, 816, 80},
    { -32, 616, 136},
    { 48, 800, 96},
    { 136, 560, -112},
    { 80, 1144, 544},
    { 176, 1440, 448},
    { 24, 1400, 208},
    { 8, 656, 32},
    { 88, 784, 416},
    { -56, 1320, 520},
    { -112, 1440, 816},
    { -128, 1104, 480},
    // 53 seconds
    { -56, 712, 288},
    { -32, 672, 192},
    { 80, 584, 96},
    { 120, 600, 176},
    { 96, 704, 328},
    { -8, 872, 312},
    { -176, 1128, 480},
    { -360, 984, 456},
    { -568, 848, 376},
    { -648, 712, 576},
    { -528, 1384, -64},
    { -504, 1184, 200},
    { -376, 1040, 304},
    { -112, 816, 144},
    { 24, 520, 56},
    { -120, 640, 344},
    { -176, 968, 432},
    { -160, 1176, 632},
    { -32, 1296, 264},
    { -96, 1160, 280},
    { -336, 976, 296},
    { -288, 1328, 384},
    { -648, 1384, 424},
    { -536, 1016, 240},
    { -216, 696, 256},
    // 54 seconds
    { -200, 536, 272},
    { -112, 520, 152},
    { -48, 560, 128},
    { -168, 840, 304},
    { -408, 1000, 320},
    { -528, 1152, 280},
    { -520, 1064, 344},
    { -448, 992, 272},
    { -360, 960, 392},
    { -336, 1024, 128},
    { -304, 1128, 280},
    { -40, 784, -184},
    { -112, 824, -104},
    { 8, 488, 128},
    { -48, 1272, 248},
    { 248, 1168, 376},
    { 216, 800, 272},
    { 216, 968, 192},
    { -120, 1240, 8},
    { -24, 952, 680},
    { -168, 1424, 424},
    { -224, 664, 304},
    { -280, 1144, 496},
    { -152, 928, 336},
    { -16, 592, 120},
    // 55 seconds
    { 48, 560, -8},
    { 80, 544, 184},
    { 112, 800, 336},
    { 56, 944, 312},
    { -112, 1200, 336},
    { -264, 1120, 480},
    { -272, 1232, 400},
    { -184, 1368, 544},
    { -184, 1336, 224},
    { -232, 1136, 168},
    { -416, 800, 232},
    { -232, 312, 208},
    { -128, 416, 136},
    { 32, 496, 272},
    { 192, 848, 240},
    { 376, 1184, 224},
    { 296, 1424, -80},
    { 552, 1480, 560},
    { 368, 1416, 464},
    { 536, 848, 408},
    { 72, 1064, 416},
    { 40, 512, 264},
    { -56, 584, 416},
    { -192, 904, 568},
    { -120, 792, 400},
    // 56 seconds
    { 0, 744, 152},
    { 120, 600, 288},
    { 184, 752, 352},
    { 192, 1112, 352},
    { 48, 1192, 496},
    { 128, 1232, 248},
    { 40, 1200, 464},
    { -40, 1056, 192},
    { -16, 1144, 144},
    { -48, 808, 216},
    { 80, 736, 40},
    { 168, 592, 0},
    { 240, 656, 88},
    { 256, 848, 192},
    { 352, 976, 192},
    { 368, 1048, 152},
    { 440, 808, 192},
    { 280, 1160, 352},
    { 584, 1288, 584},
    { 120, 1456, 504},
    { 200, 712, 208},
    { -72, 1256, 400},
    { -72, 928, 440},
    { 96, 712, 200},
    { 160, 600, 184},
    // 57 seconds
    { 216, 568, 216},
    { 192, 688, 288},
    { 184, 928, 376},
    { 104, 1072, 424},
    { -48, 1168, 432},
    { -96, 1096, 304},
    { -72, 1136, 496},
    { -128, 1104, 376},
    { -96, 1136, 264},
    { -96, 960, 216},
    { 0, 688, 152},
    { 176, 696, 96},
    { 144, 544, 96},
    { 208, 752, 232},
    { 96, 1192, -32},
    { 24, 952, 488},
    { 160, 1192, 224},
    { 120, 1392, 184},
    { 120, 960, 464},
    { 216, 1456, 200},
    { -32, 656, 504},
    { -88, 1168, 368},
    { -8, 864, 368},
    { 48, 544, 176},
    { 104, 528, 136},
    // 58 seconds
    { 96, 680, 272},
    { 136, 800, 320},
    { 112, 1000, 288},
    { -72, 1312, 384},
    { -80, 1144, 336},
    { -120, 1368, 368},
    { -104, 1128, 400},
    { -96, 1248, 112},
    { -88, 976, 224},
    { 0, 712, 56},
    { 88, 520, 0},
    { 208, 432, 48},
    { 16, 680, 64},
    { 288, 1032, -40},
    { 136, 1504, 448},
    { 376, 1272, 328},
    { 296, 1096, 72},
    { 96, 632, -96},
    { 176, 1352, 368},
    { -160, 1360, 528},
    { 24, 816, 440},
    { -56, 760, 200},
    { -16, 680, 104},
    { 88, 672, 160},
    { 216, 600, 256},
    // 59 seconds
    { 240, 848, 344},
    { 144, 1112, 408},
    { -8, 1136, 416},
    { -72, 1280, 416},
    { -152, 1128, 288},
    { -96, 1264, 504},
    { -160, 1128, 344},
    { -112, 1112, 208},
    { -128, 960, 288},
    { -96, 680, -16},
    { 56, 496, 176},
    { 24, 504, -240},
    { 112, 864, -48},
    { 24, 952, 240},
    { 248, 960, 344},
    { 296, 1256, 152},
    { 264, 1024, 40},
    { 368, 1432, 344},
    { -48, 1160, 688},
    { -176, 952, 136},
    { 144, 360, 376},
    { -120, 704, 456},
    { 56, 720, 336},
    { 56, 512, 160},
    { 192, 760, 272},
    // 60 seconds
    // elapsed: 1 minutes
    { 96, 936, 320},
    { 24, 1096, 296},
    { -48, 1248, 280},
    { -88, 1128, 304},
    { -96, 1240, 288},
    { 40, 1008, 480},
    { -72, 1144, 200},
    { 32, 824, 96},
    { 40, 624, 120},
    { 88, 528, -24},
    { 192, 464, -48},
    { 296, 536, -40},
    { 424, 552, 160},
    { 320, 1128, 368},
    { 128, 1592, 40},
    { -168, 1672, 456},
    { -144, 1816, 824},
    { -264, 1384, 464},
    { -176, 552, 320},
    { -280, 664, 688},
    { -272, 472, 248},
    { 24, 352, 280},
    { -80, 720, 224},
    { 0, 776, 176},
    { -32, 840, 368},
    // 61 seconds
    { -88, 1016, 424},
    { -128, 1256, 336},
    { -296, 1072, 384},
    { -304, 1240, 400},
    { -216, 976, 432},
    { -248, 1208, 112},
    { -224, 864, 176},
    { -144, 800, 40},
    { -88, 696, -456},
    { -16, 824, -192},
    { 288, 592, -208},
    { 160, 1016, 32},
    { 184, 1208, 200},
    { 200, 1088, 416},
    { 160, 1152, 296},
    { 0, 1000, 616},
    { -104, 1360, 768},
    { -296, 1744, 392},
    { -480, 1416, 800},
    { -240, 856, 432},
    { -104, 728, 40},
    { 32, 576, 72},
    { 32, 584, -88},
    { 64, 600, 128},
    { 24, 768, 240},
    // 62 seconds
    { 88, 824, 376},
    { 64, 1064, 464},
    { -88, 1072, 464},
    { -104, 1168, 328},
    { -152, 1056, 440},
    { -128, 1152, 296},
    { -144, 1088, 296},
    { -128, 816, 232},
    { -112, 744, 152},
    { -8, 712, 24},
    { 24, 624, 152},
    { 56, 784, 168},
    { 96, 1448, 608},
    { 152, 1544, 152},
    { 176, 1000, 656},
    { 24, 1256, 320},
    { 208, 912, 592},
    { -112, 1032, 440},
    { -112, 832, 280},
    { -240, 864, 392},
    { -144, 984, 448},
    { -32, 728, 224},
    { 120, 504, 80},
    { 152, 552, 168},
    { 96, 800, 352},
    // 63 seconds
    { -24, 1080, 400},
    { -184, 1128, 344},
    { -240, 1280, 376},
    { -400, 1312, 352},
    { -256, 1248, 480},
    { -280, 1176, 216},
    { -224, 1088, 200},
    { -192, 776, 16},
    { -40, 536, -64},
    { -8, 200, -8},
    { 16, -152, 96},
    { 64, 488, 80},
    { -216, 872, 296},
    { -568, 1632, 272},
    { -272, 1512, 672},
    { -304, 1448, 888},
    { -264, 1544, 784},
    { -600, 1408, 704},
    { -352, 688, 440},
    { -288, 784, 416},
    { -216, 416, 336},
    { -184, 648, 208},
    { -72, 528, 232},
    { -80, 560, 272},
    { -128, 720, 392},
    // 64 seconds
    { -152, 896, 376},
    { -240, 1016, 376},
    { -496, 1176, 384},
    { -472, 1040, 224},
    { -616, 1160, 400},
    { -472, 1040, 232},
    { -360, 1040, 56},
    { -232, 872, 136},
    { -72, 616, 56},
    { 40, 584, 48},
    { 152, 480, 200},
    { 32, 664, -24},
    { 96, 848, 184},
    { 32, 1336, 160},
    { 120, 1656, 32},
    { -264, 1320, 160},
    { -160, 1448, 344},
    { -280, 1208, 296},
    { -208, 792, 632},
    { -200, 896, 384},
    { -152, 624, 344},
    { -96, 520, 232},
    { -32, 608, 112},
    { 8, 608, 152},
    { -104, 928, 168},
    // 65 seconds
    { -136, 976, 72},
    { -280, 1232, 96},
    { -344, 1080, 296},
    { -504, 1440, 496},
    { -360, 1200, 216},
    { -288, 1264, -48},
    { -128, 800, 200},
    { -104, 536, -24},
    { -16, 584, 16},
    { -8, 504, 96},
    { 56, 744, 288},
    { 176, 1200, 152},
    { -32, 1104, -192},
    { 72, 1248, -184},
    { 0, 1432, 128},
    { 48, 1272, -192},
    { 280, 1152, 384},
    { 40, 848, 376},
    { 64, 608, 208},
    { 8, 776, 392},
    { -184, 912, 72},
    { 112, 824, -128},
    { 160, 960, -224},
    { 96, 1040, 104},
    { 32, 840, -64},
    // 66 seconds
    { 0, 896, 72},
    { -32, 920, 352},
    { -256, 1184, 184},
    { -336, 1248, 208},
    { -424, 1088, -88},
    { -400, 872, 96},
    { -208, 848, -136},
    { -136, 728, -264},
    { 72, 776, -392},
    { 176, 832, -256},
    { 72, 1136, -248},
    { -56, 1400, -144},
    { 24, 1424, -16},
    { 192, 1184, 24},
    { -272, 1264, 480},
    { -72, 864, 520},
    { -336, 1480, 312},
    { -248, 1048, 440},
    { -152, 792, 336},
    { 0, 624, 120},
    { 0, 552, 40},
    { -8, 600, 56},
    { -88, 744, 152},
    { -304, 992, 200},
    { -432, 1104, 120},
    // 67 seconds
    { -496, 1192, 96},
    { -368, 1064, 80},
    { -408, 1248, 320},
    { -304, 1160, 192},
    { -296, 1088, 96},
    { -264, 960, 48},
    { -56, 688, 8},
    { 0, 584, 96},
    { -56, 728, 224},
    { 0, 832, 368},
    { -128, 1232, 472},
    { -96, 1032, 296},
    { -24, 1336, 256},
    { -120, 1312, 216},
    { -48, 856, 232},
    { -264, 1168, 400},
    { -504, 1560, 320},
    { -248, 1312, 344},
    { -48, 800, 184},
    { 48, 432, 88},
    { 112, 320, 96},
    { 176, 504, 40},
    { 200, 664, 152},
    { 272, 864, 168},
    { 0, 1288, 208},
    // 68 seconds
    { -32, 1248, 296},
    { -144, 1256, 136},
    { -104, 1000, 304},
    { -288, 1112, 216},
    { -200, 976, 8},
    { -160, 1232, -192},
    { 64, 848, 16},
    { 184, 656, 64},
    { 80, 904, 240},
    { 208, 1040, 408},
    { 224, 928, 424},
    { 312, 944, 384},
    { 432, 768, 248},
    { 80, 744, 64},
    { 472, 640, 208},
    { -88, 1352, 448},
    { 136, 976, 528},
    { 208, 544, 464},
    { 32, 848, 256},
    { 152, 744, 144},
    { 192, 488, 320},
    { 200, 744, 272},
    { 168, 928, 368},
    { 64, 1008, 480},
    { 0, 1160, 488},
    // 69 seconds
    { -24, 1224, 376},
    { 48, 1280, 440},
    { -48, 1368, 392},
    { -184, 1216, 208},
    { -224, 992, 240},
    { -168, 560, 32},
    { -296, 752, -16},
    { -168, 576, 168},
    { -56, 568, 176},
    { -40, 792, -16},
    { 56, 936, 328},
    { 272, 912, 632},
    { 584, 1200, 1008},
    { 192, 1376, 584},
    { 304, 528, 1008},
    { -192, 936, 880},
    { -256, 896, 912},
    { -192, 480, 520},
    { 8, 336, 440},
    { 0, 448, 320},
    { -48, 744, 384},
    { -40, 792, 424},
    { -48, 872, 600},
    { -136, 1112, 680},
    { -360, 1208, 648},
    // 70 seconds
    { -440, 1096, 552},
    { -456, 1384, 616},
    { -464, 968, 640},
    { -368, 1080, 216},
    { -272, 768, 344},
    { -120, 632, 288},
    { -56, 520, 200},
    { -16, 520, 240},
    { -8, 664, 344},
    { -24, 912, 416},
    { -72, 1024, 496},
    { -64, 1256, 312},
    { -8, 1008, 320},
    { 64, 1048, 632},
    { 0, 1480, 584},
    { -264, 1432, 648},
    { -240, 832, 448},
    { -48, 464, 328},
    { -72, 592, 288},
    { -56, 680, 336},
    { -8, 680, 232},
    { -72, 744, 392},
    { -144, 888, 488},
    { -152, 848, 368},
    { -232, 984, 464},
    // 71 seconds
    { -336, 944, 504},
    { -344, 1400, 552},
    { -424, 1080, 552},
    { -352, 1104, 224},
    { -304, 856, 192},
    { -288, 752, 72},
    { -128, 464, 120},
    { -32, 608, 144},
    { 0, 696, 216},
    { -56, 888, 328},
    { 24, 984, -112},
    { 112, 1408, 216},
    { -8, 1272, 560},
    { 80, 1312, 632},
    { -376, 1368, 736},
    { -640, 936, 536},
    { -360, 952, 288},
    { -200, 1024, 376},
    { -136, 832, 216},
    { -24, 544, 224},
    { 0, 584, 200},
    { 24, 720, 232},
    { -16, 896, 280},
    { -112, 1096, 312},
    { -232, 1088, 304},
    // 72 seconds
    { -272, 1056, 240},
    { -256, 1112, 256},
    { -328, 1200, 576},
    { -240, 1136, 280},
    { -248, 1080, 304},
    { -216, 888, 280},
    { -80, 672, 144},
    { 56, 408, 328},
    { 104, 240, 160},
    { -152, 592, -88},
    { -184, 928, 176},
    { -16, 1232, 360},
    { 168, 1232, 112},
    { -136, 1128, 216},
    { -152, 1128, 576},
    { -520, 1400, 560},
    { -312, 1344, 448},
    { -272, 816, 312},
    { -248, 552, 352},
    { -248, 656, 272},
    { -144, 712, 224},
    { -96, 752, 264},
    { -176, 848, 328},
    { -320, 976, 296},
    { -400, 976, 288},
    // 73 seconds
    { -496, 1112, 128},
    { -592, 928, 272},
    { -680, 1048, 280},
    { -536, 984, 336},
    { -584, 1168, 16},
    { -584, 976, 192},
    { -432, 696, 80},
    { -248, 808, 0},
    { -120, 264, 248},
    { -8, 640, 112},
    { -64, 632, 152},
    { -88, 792, 416},
    { -152, 888, 168},
    { -96, 1264, 368},
    { -152, 1192, 528},
    { -208, 1536, 368},
    { -616, 1488, 280},
    { -432, 1072, 432},
    { -368, 1056, 184},
    { -120, 648, 304},
    { -88, 616, 184},
    { -24, 560, 160},
    { 72, 632, 208},
    { 144, 720, 312},
    { 48, 1024, 344},
    // 74 seconds
    { -120, 1104, 248},
    { -288, 1136, 200},
    { -448, 992, 128},
    { -560, 960, -16},
    { -720, 928, 176},
    { -496, 968, -16},
    { -456, 904, 64},
    { -344, 848, 112},
    { -136, 776, 80},
    { -32, 808, 112},
    { 24, 808, 152},
    { 32, 912, 264},
    { 0, 1216, 312},
    { 112, 1184, 232},
    { 184, 1752, 296},
    { 136, 1320, 120},
    { 16, 1144, 472},
    { -80, 1576, 296},
    { -136, 1448, 368},
    { -136, 1528, 456},
    { -32, 832, 464},
    { -144, 672, 392},
    { -40, 640, 208},
    { -128, 672, 320},
    { -128, 760, 288},
    // 75 seconds
    { -176, 856, 200},
    { -120, 816, 96},
    { -200, 784, 48},
    { -168, 744, -8},
    { -272, 1184, 256},
    { -112, 1272, 264},
    { 96, 1656, 128},
    { 80, 1128, 456},
    { 152, 864, 208},
    { 216, 776, 192},
    { 240, 720, 104},
    { 216, 736, 224},
    { 256, 896, 88},
    { 264, 824, 240},
    { 248, 952, 48},
    { 232, 1168, 472},
    { 368, 1216, 472},
    { 216, 1264, 512},
    { 80, 920, 376},
    { 200, 1056, 448},
    { 144, 952, 408},
    { 288, 776, 280},
    { 232, 672, 240},
    { 240, 592, 280},
    { 208, 728, 288},
    // 76 seconds
    { 160, 856, 328},
    { 144, 968, 312},
    { 112, 1120, 320},
    { 16, 1104, 256},
    { -64, 1320, 440},
    { -168, 1112, 288},
    { -32, 1072, 136},
    { 8, 872, 120},
    { 0, 904, 120},
    { 152, 696, 80},
    { 168, 488, 96},
    { 120, 576, 72},
    { 208, 872, 144},
    { 224, 992, 400},
    { 256, 1152, 128},
    { 256, 1048, 296},
    { 120, 1232, 320},
    { 152, 1400, 512},
    { -112, 1408, 536},
    { -16, 1200, 312},
    { 96, 912, 336},
    { 112, 776, 256},
    { 112, 632, 264},
    { 144, 656, 224},
    { 184, 616, 280},
    // 77 seconds
    { 176, 728, 328},
    { 136, 880, 440},
    { 24, 1048, 448},
    { -120, 1136, 408},
    { -120, 1088, 288},
    { -248, 1304, 424},
    { -288, 1120, 304},
    { -200, 1280, 40},
    { -96, 888, 168},
    { 8, 712, 48},
    { 96, 704, -24},
    { 152, 424, -120},
    { 184, 416, 128},
    { 208, 704, 320},
    { 240, 1104, 272},
    { 288, 1208, 200},
    { 136, 984, 160},
    { -16, 1408, 536},
    { -336, 1752, 808},
    { -408, 1584, 584},
    { -208, 1240, 432},
    { -136, 960, 352},
    { -48, 704, 376},
    { 80, 568, 128},
    { 152, 512, 120},
    // 78 seconds
    { 160, 520, 168},
    { 184, 624, 280},
    { 168, 856, 304},
    { 64, 896, 400},
    { -160, 1224, 376},
    { -144, 1176, 232},
    { -240, 1128, 280},
    { -200, 1032, 432},
    { -248, 1264, 120},
    { -144, 1104, 152},
    { -104, 896, 120},
    { 16, 728, 0},
    { 120, 584, 8},
    { 176, 512, 32},
    { 232, 560, 152},
    { 248, 736, 8},
    { 32, 1104, 304},
    { 120, 1336, 184},
    { 224, 1280, 136},
    { -160, 1760, 320},
    { -384, 1416, 504},
    { -432, 1296, 240},
    { -128, 784, 360},
    { -88, 648, 200},
    { -24, 696, 216},
    // 79 seconds
    { -16, 704, 272},
    { 48, 784, 248},
    { 72, 832, 224},
    { 32, 880, 320},
    { 40, 928, 296},
    { -32, 984, 312},
    { -232, 1144, 272},
    { -288, 1112, 264},
    { -384, 1400, 384},
    { -328, 1136, 72},
    { -288, 1032, 32},
    { -184, 896, 64},
    { -56, 736, -8},
    { 72, 616, -8},
    { 96, 536, 120},
    { 192, 600, 56},
    { 88, 848, -112},
    { 160, 904, 240},
    { 168, 1240, 256},
    { 280, 1248, 112},
    { -96, 1216, 296},
    { -320, 1352, 408},
    { -296, 1384, 264},
    { -80, 832, 408},
    { -16, 832, 232},
    // 80 seconds
    { 80, 712, 192},
    { 104, 568, 184},
    { 160, 568, -48},
    { 232, 776, -24},
    { 112, 816, 168},
    { 0, 1104, 112},
    { -120, 1264, 112},
    { -168, 1240, 144},
    { -224, 1168, -24},
    { -304, 1176, 88},
    { -176, 1032, 32},
    { -160, 984, -40},
    { -160, 864, 0},
    { -8, 752, -144},
    { 88, 520, -80},
    { -8, 504, -304},
    { 112, 704, -96},
    { 56, 920, 96},
    { 208, 1072, 56},
    { 280, 960, 160},
    { 264, 1112, 312},
    { 184, 1248, 440},
    { -136, 1808, 440},
    { -184, 1344, 488},
    { -104, 1208, 368},
    // 81 seconds
    { 40, 928, 304},
    { 88, 664, 160},
    { 120, 488, 88},
    { 152, 544, 112},
    { 144, 688, 232},
    { 96, 856, 224},
    { 88, 864, 256},
    { 40, 960, 200},
    { -120, 1104, 136},
    { -80, 1168, 16},
    { -248, 1184, 216},
    { -232, 1184, 168},
    { -144, 1136, 128},
    { -24, 944, 128},
    { 48, 824, 80},
    { 232, 560, 168},
    { 352, 592, 200},
    { 408, 720, 224},
    { 504, 896, 400},
    { 424, 1248, 112},
    { 336, 1264, 440},
    { 72, 1304, 344},
    { 48, 1320, 328},
    { -240, 1552, 456},
    { -248, 872, 440},
    // 82 seconds
    { -160, 944, 344},
    { -104, 928, 400},
    { -16, 784, 224},
    { 120, 592, 192},
    { 152, 632, 232},
    { 144, 840, 320},
    { 72, 856, 376},
    { 8, 1112, 352},
    { -96, 1136, 336},
    { -112, 1024, 304},
    { -88, 1096, 472},
    { -176, 1192, 168},
    { -96, 1032, 240},
    { -88, 928, 352},
    { 32, 848, 136},
    { 120, 712, 96},
    { 136, 576, 272},
    { 168, 704, 296},
    { 272, 904, 280},
    { 208, 960, 400},
    { 256, 1024, 536},
    { 96, 1416, 432},
    { 232, 1392, 632},
    { -72, 1376, 592},
    { -152, 1240, 504},
    // 83 seconds
    { -80, 840, 376},
    { 56, 656, 296},
    { 72, 656, 272},
    { 136, 672, 248},
    { 200, 624, 320},
    { 208, 720, 336},
    { 192, 896, 368},
    { 192, 936, 400},
    { 96, 1080, 408},
    { 80, 1080, 400},
    { 16, 1200, 328},
    { -80, 1160, 520},
    { -72, 1096, 360},
    { -8, 1224, 160},
    { -8, 736, 296},
    { 40, 752, 144},
    { 128, 656, -72},
    { 152, 592, 16},
    { 208, 872, 152},
    { 176, 968, 328},
    { 360, 1192, -8},
    { 344, 1344, 208},
    { -72, 1456, 40},
    { 232, 2152, 312},
    { 224, 1520, 168},
    // 84 seconds
    { 200, 1304, -32},
    { 144, -264, 544},
    { 152, 992, -208},
    { 160, 432, 128},
    { 312, 536, 8},
    { 344, 808, -16},
    { 280, 976, 8},
    { 280, 1152, -152},
    { 224, 1096, -216},
    { 88, 776, -216},
    { 32, 1168, -512},
    { 0, 1112, -552},
    { 24, 1048, -512},
    { 0, 856, -504},
    { -24, 728, -448},
    { 32, 568, -424},
    { 80, 296, -288},
    { 160, 368, -392},
    { 248, 136, -240},
    { 120, 544, -448},
    { 208, 840, -776},
    { 24, 1176, -672},
    { -152, 1400, -736},
    { 64, 1304, -480},
    { -248, 1672, -768},
    // 85 seconds
    { -96, 1120, -344},
    { -144, 1032, -216},
    { 0, 672, -64},
    { 40, 760, -72},
    { 24, 856, -264},
    { 104, 560, -72},
    { 48, 688, -64},
    { 16, 968, -240},
    { 24, 1184, -256},
    { -184, 584, -80},
    { -216, 1096, -456},
    { -288, 1264, -480},
    { -304, 1176, -392},
    { -264, 1208, -456},
    { -176, 912, -384},
    { -56, 624, -264},
    { 48, 464, -240},
    { 112, 432, -168},
    { 192, 472, -120},
    { 176, 632, 24},
    { 240, 856, 88},
    { 304, 1160, 72},
    { 32, 1440, -64},
    { -48, 1688, 320},
    { -232, 2000, 560},
    // 86 seconds
    { -128, 1488, 464},
    { -104, 992, 176},
    { 24, 464, 168},
    { 64, 256, 160},
    { 8, 536, 128},
    { 88, 624, 56},
    { 120, 576, 72},
    { 168, 872, 168},
    { 120, 1136, 176},
    { 40, 1120, 168},
    { -56, 1104, 144},
    { -48, 1448, 232},
    { -176, 1128, 304},
    { -248, 1216, 152},
    { -296, 864, 320},
    { -296, 696, 336},
    { -80, 488, 224},
    { 56, 608, -16},
    { 160, 560, 24},
    { 224, 1016, 200},
    { 192, 1264, 408},
    { 136, 1256, 408},
    { 240, 960, 616},
    { -16, 1048, 352},
    { -88, 848, 976},
    // 87 seconds
    { -360, 1592, 1160},
    { -184, 1160, 952},
    { 0, 896, 832},
    { -88, 584, 816},
    { -120, 520, 560},
    { -40, 344, 344},
    { 8, 560, 208},
    { 80, 632, 344},
    { 96, 712, 368},
    { 144, 872, 464},
    { 24, 1120, 568},
    { -88, 1168, 512},
    { -72, 1208, 456},
    { -144, 1096, 576},
    { -128, 1096, 288},
    { -72, 1024, 336},
    { 248, 920, 296},
    { 328, 336, 456},
    { 224, 872, -16},
    { 144, 528, 120},
    { 144, 808, -72},
    { -40, 1096, -40},
    { 8, 832, 128},
    { 240, 1120, 64},
    { 0, 400, -232},
    // 88 seconds
    { 248, 1304, 160},
    { 24, 1336, 536},
    { 24, 1536, 736},
    { 128, 1336, 496},
    { 112, 840, 256},
    { 96, 432, 360},
    { 88, 680, 152},
    { 208, 584, 128},
    { 216, 768, 224},
    { 224, 768, 240},
    { 248, 896, 312},
    { 408, 1088, 296},
    { 184, 1200, 296},
    { 208, 1264, 448},
    { -296, 1456, 136},
    { -256, 960, 56},
    { -280, 1024, 152},
    { -184, 800, -32},
    { -104, 648, 16},
    { -48, 504, -192},
    { 0, 400, 64},
    { 80, 888, -88},
    { 232, 1032, -80},
    { 272, 1248, -104},
    { 264, 1104, 176},
    // 89 seconds
    { 200, 1000, 368},
    { 112, 1832, 552},
    { -176, 1184, 648},
    { 16, 1184, 144},
    { -48, 520, 328},
    { 8, 720, 104},
    { 24, 712, 320},
    { 16, 624, 136},
    { -8, 568, 232},
    { -48, 832, 280},
    { -88, 1016, 256},
    { -168, 1072, 376},
    { -232, 1120, 352},
    { -320, 1296, 528},
    { -472, 1368, 360},
    { -544, 1392, -64},
    { -456, 1064, 136},
    { -208, 632, -48},
    { -16, 480, -24},
    { 8, 504, 8},
    { -96, 624, -80},
    { -64, 784, -56},
    { -192, 776, 336},
    { -304, 1488, -272},
    { -168, 1432, 392},
    // 90 seconds
    { -184, 1032, 520},
    { -88, 1168, 600},
    { -312, 1456, 376},
    { -312, 1184, 568},
    { -208, 616, 616},
    { -104, 720, 296},
    { -136, 768, 488},
    { -120, 600, 200},
    { -168, 704, 256},
    { -264, 720, 280},
    { -344, 880, 288},
    { -368, 1000, 200},
    { -480, 1056, 208},
    { -584, 1056, -168},
    { -920, 1104, -144},
    { -632, 1056, -40},
    { -504, 1032, -136},
    { -456, 880, 72},
    { -288, 712, 104},
    { -184, 680, 160},
    { -216, 688, 320},
    { -280, 576, 352},
    { -152, 664, 408},
    { -168, 824, 312},
    { -144, 904, 232},
    // 91 seconds
    { -328, 1112, 56},
    { -424, 1464, -128},
    { -872, 1088, 328},
    { -1688, 2176, -336},
    { -808, 792, 104},
    { -648, 832, -40},
    { -392, 608, -16},
    { -232, 408, -8},
    { -128, 328, 128},
    { -184, 488, 128},
    { -288, 696, 80},
    { -424, 720, 32},
    { -600, 672, -8},
    { -800, 616, -144},
    { -992, 728, -304},
    { -1024, 392, -88},
    { -1336, 392, 64},
    { -1208, 632, -256},
    { -1240, 624, -360},
    { -1056, 480, -304},
    { -576, 472, -168},
    { -496, 456, -112},
    { -656, 408, -176},
    { -736, 384, -336},
    { -768, 432, -424},
    // 92 seconds
    { -736, 392, -360},
    { -800, 496, -488},
    { -968, 464, -392},
    { -1184, 376, -568},
    { -1744, 840, -632},
    { -1832, -40, 80},
    { -1856, 376, -152},
    { -1280, 232, -192},
    { -552, -104, -120},
    { -224, -168, -144},
    { -400, -56, 64},
    { -520, 224, 0},
    { -632, 368, -56},
    { -728, 320, -24},
    { -984, 352, -120},
    { -1136, 360, -24},
    { -1264, 416, -120},
    { -1904, 368, 16},
    { -1248, 608, -632},
    { -1312, 464, -440},
    { -960, -40, -64},
    { -608, -304, 232},
    { -568, 496, -288},
    { -488, 376, -256},
    { -528, 584, -432},
    // 93 seconds
    { -736, 360, -176},
    { -872, 424, -360},
    { -1088, 704, -472},
    { -888, 520, -328},
    { -824, 320, -272},
    { -1144, 864, -768},
    { -1888, 328, 64},
    { -1592, -144, 128},
    { -1280, 976, -432},
    { -784, 456, -120},
    { -536, 384, -64},
    { -648, 400, 104},
    { -640, 352, 168},
    { -728, 432, 136},
    { -760, 528, 112},
    { -696, 592, 120},
    { -752, 528, -16},
    { -776, 496, 0},
    { -1144, 552, -104},
    { -1136, 696, -536},
    { -1072, 664, -296},
    { -648, 1048, -456},
    { -32, 936, -256},
    { 184, 856, 88},
    { 8, 1032, 176},
    // 94 seconds
    { -128, 1168, 256},
    { -384, 1504, 120},
    { -336, 1208, 344},
    { -232, 1416, 320},
    { -264, 1232, 184},
    { -416, 840, 584},
    { -328, 1336, 416},
    { -480, 1040, 472},
    { -296, 704, 0},
    { -184, 640, 264},
    { -152, 840, 328},
    { -16, 624, 248},
    { 144, 608, 200},
    { 144, 568, 232},
    { 152, 712, 280},
    { -8, 936, 448},
    { -344, 864, 680},
    { -104, 1112, 408},
    { 104, 976, 392},
    { -8, 1272, 568},
    { -272, 1400, 304},
    { -152, 1072, 400},
    { -128, 696, 328},
    { -24, 712, 160},
    { 96, 616, 144},
    // 95 seconds
    { 160, 632, 176},
    { 184, 600, 96},
    { 200, 640, 168},
    { 0, 648, 8},
    { -136, 1192, 480},
    { -360, 1680, 1176},
    { -88, 1112, 984},
    { -256, 1632, 696},
    { -496, 496, 808},
    { -352, 1128, 632},
    { -192, 928, 568},
    { -40, 672, 448},
    { 8, 472, 312},
    { 48, 472, 264},
    { -16, 536, 384},
    { -16, 768, 408},
    { -184, 920, 464},
    { -320, 1072, 592},
    { -480, 1056, 512},
    { -464, 1320, 712},
    { -352, 824, 424},
    { -368, 1064, 216},
    { -312, 896, 344},
    { -160, 640, 160},
    { -64, 552, 8},
    // 96 seconds
    { -16, 400, -16},
    { -56, 144, 24},
    { -304, 896, 640},
    { -328, 1840, 560},
    { -32, 960, 832},
    { -112, 1168, 568},
    { -216, 832, 696},
    { -472, 1064, 768},
    { -432, 1192, 904},
    { -360, 992, 648},
    { -232, 648, 600},
    { -112, 608, 496},
    { -64, 592, 440},
    { -32, 624, 432},
    { -128, 616, 568},
    { -248, 728, 496},
    { -544, 936, 704},
    { -528, 960, 640},
    { -256, 880, 376},
    { -472, 1088, 600},
    { -424, 1128, 480},
    { -448, 1024, 320},
    { -336, 816, 248},
    { -160, 656, 80},
    { 0, 608, 24},
    // 97 seconds
    { 96, 536, 176},
    { 72, 712, 344},
    { -16, 1072, 408},
    { 168, 984, 488},
    { 104, 1144, 256},
    { 16, 768, 552},
    { 16, 1440, 528},
    { -176, 1352, 600},
    { -96, 1104, 640},
    { -16, 888, 464},
    { -56, 752, 384},
    { -16, 688, 280},
    { 104, 576, 168},
    { 88, 552, 208},
    { 24, 736, 296},
    { -104, 1088, 336},
    { -240, 1296, 416},
    { -416, 1256, 320},
    { -304, 1304, 256},
    { -360, 1024, 320},
    { -216, 1032, 184},
    { -120, 912, 192},
    { -72, 672, 184},
    { 104, 672, 96},
    { 160, 592, 208},
    // 98 seconds
    { 272, 784, 328},
    { 368, 1024, 552},
    { 496, 976, 216},
    { 488, 944, 408},
    { 536, 1208, 264},
    { 488, 912, 320},
    { 472, 1504, 72},
    { 128, 608, 176},
    { 104, 1264, 56},
    { 216, 864, 536},
    { 112, 744, 56},
    { 168, 592, 176},
    { 248, 536, 224},
    { 272, 656, 216},
    { 296, 728, 200},
    { 248, 920, 264},
    { 200, 1184, 176},
    { 40, 1056, 216},
    { 56, 1200, 32},
    { 40, 1360, 200},
    { -56, 1136, -32},
    { 72, 1080, -88},
    { 56, 824, 16},
    { 104, 776, -64},
    { 176, 600, -72},
    // 99 seconds
    { 240, 592, 40},
    { 304, 720, -8},
    { 304, 1080, 272},
    { 184, 704, 152},
    { 360, 1248, 24},
    { 336, 1304, 128},
    { 128, 1264, 40},
    { 248, 1208, -72},
    { -24, 864, 144},
    { 24, 1344, 88},
    { 24, 872, 512},
    { 16, 1080, 240},
    { 120, 784, 64},
    { 216, 648, 128},
    { 232, 576, 216},
    { 240, 648, 288},
    { 184, 888, 320},
    { 80, 1040, 448},
    { -168, 1104, 616},
    { -312, 896, 536},
    { -32, 1128, 536},
    { 40, 1208, 424},
    { 216, 1544, 208},
    { 104, 1168, 312},
    { 80, 736, 256},
    // 100 seconds
    { 184, 688, -24},
    { 224, 416, 64},
    { 200, -16, 272},
    { 80, 616, -96},
    { -32, 1320, 104},
    { 88, 1472, 296},
    { 224, 1256, 232},
    { 40, 1472, 360},
    { -336, 1968, 368},
    { -544, 1328, 568},
    { 8, 1008, 152},
    { 112, 384, 176},
    { 72, 528, 112},
    { 96, 448, 120},
    { 184, 512, 88},
    { 192, 656, 216},
    { 200, 1112, 392},
    { 112, 1056, 320},
    { 152, 1008, 328},
    { 0, 1056, 280},
    { -24, 1072, 256},
    { -112, 1392, 480},
    { -136, 1192, 216},
    { -80, 1248, -104},
    { 128, 1176, -72},
    // 101 seconds
    { 272, 776, -192},
    { 376, 832, -264},
    { 352, 752, -64},
    { 320, 824, 0},
    { 256, 1008, -232},
    { 328, 808, 80},
    { 408, 768, 88},
    { 360, 800, 8},
    { 304, 552, 152},
    { 336, 872, 240},
    { 192, 1264, 192},
    { 392, 1008, 440},
    { 344, 936, 176},
    { 408, 800, -16},
    { 408, 576, -24},
    { 448, 648, 128},
    { 424, 840, 216},
    { 296, 1008, 328},
    { 296, 1072, 232},
    { 304, 1016, 240},
    { 128, 1064, 336},
    { 152, 1080, 448},
    { 200, 1656, 496},
    { 32, 1088, 160},
    { 144, 1056, 232},
    // 102 seconds
    { 56, 856, 264},
    { 136, 576, 192},
    { 224, 496, 192},
    { 248, 504, 176},
    { 144, 488, 248},
    { 304, 728, 384},
    { 448, 952, 464},
    { 584, 1040, 400},
    { 568, 976, 328},
    { 528, 960, 600},
    { 336, 1424, 616},
    { 304, 1344, 592},
    { 256, 1112, 512},
    { 200, 752, 272},
    { 200, 592, 248},
    { 240, 600, 160},
    { 248, 632, 208},
    { 264, 656, 264},
    { 248, 792, 392},
    { 232, 904, 360},
    { 152, 1112, 512},
    { 16, 1128, 400},
    { 40, 1168, 424},
    { 104, 1032, 592},
    { -56, 1368, 136},
    // 103 seconds
    { -56, 1192, 424},
    { -136, 968, 360},
    { 32, 784, 144},
    { 64, 560, 104},
    { 80, 456, 192},
    { 80, 800, 216},
    { 64, 656, 112},
    { 224, 1152, 312},
    { 336, 1088, 472},
    { 456, 1272, 400},
    { 408, 1392, 520},
    { 192, 1160, 680},
    { -88, 1056, 656},
    { 64, 1024, 440},
    { 32, 776, 416},
    { 128, 704, 328},
    { 96, 728, 264},
    { 120, 640, 208},
    { 72, 680, 232},
    { 80, 840, 288},
    { -56, 944, 312},
    { -248, 1256, 272},
    { -384, 1128, 336},
    { -184, 1128, 344},
    { -64, 1256, 456},
    // 104 seconds
    { -40, 1248, 136},
    { 8, 1024, 136},
    { -16, 848, 240},
    { 64, 608, 152},
    { 96, 592, 72},
    { 88, 672, 168},
    { 8, 664, 392},
    { 112, 512, 432},
    { 56, 1248, 128},
    { 256, 1208, 328},
    { 80, 1272, 560},
    { 264, 1216, 696},
    { 40, 1464, 568},
    { -592, 1320, 568},
    { -448, 968, 696},
    { -248, 936, 456},
    { -72, 568, 416},
    { 24, 608, 160},
    { 56, 568, 200},
    { 56, 552, 264},
    { 48, 648, 336},
    { -32, 864, 440},
    { -152, 1184, 400},
    { -344, 1264, 384},
    { -224, 1112, 264},
    // 105 seconds
    { -216, 1200, 376},
    { -184, 1000, 512},
    { -248, 1144, 56},
    { -112, 888, 256},
    { -56, 640, 192},
    { 64, 568, 104},
    { 168, 616, 272},
    { 272, 480, 312},
    { 168, 1048, 304},
    { 208, 968, 312},
    { 128, 1280, 224},
    { -112, 1248, 432},
    { -160, 1368, 504},
    { -208, 1216, 1008},
    { -336, 1048, 712},
    { -296, 864, 440},
    { -72, 440, 592},
    { -48, 592, 248},
    { 8, 536, 168},
    { 56, 696, 304},
    { 24, 632, 272},
    { 56, 1000, 432},
    { -24, 1024, 464},
    { -112, 1224, 704},
    { -168, 1040, 488},
    // 106 seconds
    { -128, 1184, 408},
    { -56, 1008, 752},
    { -136, 1144, 288},
    { -88, 1048, 368},
    { -56, 784, 440},
    { 8, 624, 184},
    { 168, 400, 464},
    { 200, 504, 224},
    { 288, 928, 368},
    { 120, 1008, 224},
    { 240, 1056, 232},
    { 264, 944, 120},
    { 328, 1008, 32},
    { 112, 872, 280},
    { 208, 1032, 552},
    { 128, 1384, 720},
    { -40, 1112, 760},
    { -40, 1232, 688},
    { 40, 512, 608},
    { 56, 848, 304},
    { 160, 512, 288},
    { 168, 624, 176},
    { 248, 672, 280},
    { 256, 728, 344},
    { 288, 904, 368},
    // 107 seconds
    { 296, 1024, 424},
    { 104, 1168, 416},
    { 48, 1032, 360},
    { 8, 1136, 328},
    { -24, 920, 464},
    { -32, 1240, 200},
    { -64, 880, 296},
    { 32, 704, 136},
    { 104, 624, 16},
    { 168, 448, 200},
    { 200, 728, 152},
    { 224, 1040, 296},
    { -48, 1000, 472},
    { 48, 1312, 544},
    { 232, 928, 496},
    { 0, 976, 512},
    { -16, 1080, 512},
    { -432, 1568, 768},
    { -168, 1280, 664},
    { -120, 944, 464},
    { -32, 656, 344},
    { -8, 600, 256},
    { 80, 552, 288},
    { 120, 728, 272},
    { 104, 816, 336},
    // 108 seconds
    { 88, 960, 360},
    { 64, 1040, 368},
    { -16, 1144, 328},
    { -112, 1088, 264},
    { -40, 1224, 264},
    { -152, 1032, 232},
    { -40, 1136, 96},
    { -40, 848, 120},
    { 0, 888, 168},
    { 120, 784, 112},
    { 184, 712, 184},
    { 200, 760, 96},
    { 264, 824, 88},
    { 264, 928, 152},
    { 256, 952, 208},
    { 248, 1024, 176},
    { 72, 952, 264},
    { 168, 1144, 536},
    { 56, 1440, 440},
    { 56, 1008, 552},
    { 80, 1040, 400},
    { 72, 864, 344},
    { 64, 680, 392},
    { 64, 928, 296},
    { 40, 736, 512},
  };
  *len = ARRAY_LENGTH(samples);
  return samples;
}

